/*
	Fatal-on-failure memory allocation

	$Id: xmalloc.h,v 1.1 2005/07/19 18:50:00 andymort Exp $
*/

#ifndef xmalloc_h_INCLUDED
#define xmalloc_h_INCLUDED

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

/* memory allocation */
void *xmalloc (size_t size);
void *xrealloc (void *ptr, size_t size);

/* exit with fatal error */
#ifdef __GNUC__
/* tell GCC more about the function, so it can optimise/debug better */
void fatal(char *fmt, ...) __attribute__ ((noreturn,format(printf,1,2)));
#else /* __GNUC__ */
void fatal(char *fmt, ...);
#endif /* __GNUC__ */

#ifdef __cplusplus
}
#endif

#endif
