/*-
 * Copyright (c) 2004 Free (Olivier Beyssac)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#ifndef _OPTIONS_H
#define _OPTIONS_H

#include <time.h>        /* time_t */
#include "netlist.h"

/* General information */
#define PROGRAM_VERSION "v0.3.4.1"
#define MAX_CMD_LEN (32)


/* Global options */
struct options {
  char *port;                  /* port to listen to */
  unsigned int list_size;      /* IP list max size */
  time_t interval;             /* time to wait before blacklisting */
  unsigned int max_req;        /* max reqs in interval before blacklisting */
  unsigned int blacklist_size; /* blacklist max size */
  time_t blacklist_expiration; /* time to keep an IP in the blacklist */
  time_t last_dump;            /* last data dump */
  time_t dump_delay;           /* interval between data dumps */
  int log_level;               /* logs verbosity */
  char *wl_filename;           /* where to dump IP list */
  char *bl_filename;           /* where to dump blacklist */
  char *pid_filename;          /* where to write PID */
  int daemon;                  /* detach from terminal */
  time_t start_time;           /* birthdate */
  char *progname;              /* argv[0] */
  char *working_dir;           /* where to chdir() at startup */
  char *listening_ip;          /* IP address to listen to */
  char *acl_filename;          /* where to find access list */
  time_t acl_mtime;            /* mtime of ACL filename */
  netlist acl;                 /* access list */
  char *whitelist_filename;    /* where to find access list */
  time_t whitelist_mtime;      /* mtime of whitelist filename */
  netlist whitelist;           /* access list */
  time_t client_timeout;       /* max idle time for a client */
  char *uid;                   /* user to run as */
  char *gid;                   /* group to run as */
  unsigned long submissions;   /* total submissions */
  unsigned long blqueries;     /* total BL queries */
  unsigned long positive_blqueries; /* total positive BL queries */
  unsigned long insertqueries; /* total submissions to BL */
  unsigned long bad_requests;  /* total invalid requests */
  unsigned long denied_requests; /* total denied requests */
  char *config_file;           /* configuration file */
  time_t config_mtime;         /* mtime of config file */
  char **notify_hosts;         /* host(s) to send notifications to */
  unsigned int notify_timeout; /* timeout when notifying other hosts */
  unsigned int connect_timeout;/* connect(2) timeout */
  unsigned long notifies;      /* total notifications to other hosts */
  int syslog;                  /* either log to syslog or stderr */
  unsigned long decrqueries;   /* total decrements */
};


/* Values to use as parameter to options_check */
#define DAEMON_CHK               (0)
#define LOG_LEVEL_CHK            (1)
#define INTERVAL_CHK             (2)
#define MAX_REQ_CHK              (3)
#define LIST_SIZE_CHK            (4)
#define BLACKLIST_SIZE_CHK       (5)
#define BLACKLIST_EXPIRATION_CHK (6)
#define CLIENT_TIMEOUT_CHK       (7)


/* Initialize options/parameters */
extern void options_init(char *progname);

/* Show runtime options/parameters */
extern void options_log(void);

/* Check an option value and return 1 if correct */
extern int options_check(const int option, const int value);


#endif /* _OPTIONS_H */
