//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/ItemFileNameUtil.h
//! @brief     Defines namespace GUI::Model::FilenameUtil
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_UTIL_ITEMFILENAMEUTIL_H
#define BORNAGAIN_GUI_SUPPORT_UTIL_ITEMFILENAMEUTIL_H

#include <QStringList>

//! Contains set of convenience methods for JobItem and its children.

namespace GUI::Model::FilenameUtil {

QString jobResultsFileName(const QString& itemName);

QString jobReferenceFileName(const QString& itemName);

QString jobNativeDataFileName(const QString& id);

QString realDataFileName(const QString& dataName);

QString nativeDataFileName(const QString& dataName);

QStringList nonXMLFileNameFilters();

} // namespace GUI::Model::FilenameUtil

#endif // BORNAGAIN_GUI_SUPPORT_UTIL_ITEMFILENAMEUTIL_H
