{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetPickingGeometry: TAbstractGeometryNode;
    procedure SetPickingGeometry(const Value: TAbstractGeometryNode);
  public
    procedure SetObjectType(const Value: array of string);
    procedure SetObjectType(const Value: TCastleStringList);
    property PickingGeometry: TAbstractGeometryNode read GetPickingGeometry write SetPickingGeometry;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractPickSensorNode ----------------------------------------------- }

procedure TAbstractPickSensorNode.SetObjectType(const Value: array of string);
begin
  FdObjectType.Send(Value);
end;

procedure TAbstractPickSensorNode.SetObjectType(const Value: TCastleStringList);
begin
  FdObjectType.Send(Value);
end;

function TAbstractPickSensorNode.GetPickingGeometry: TAbstractGeometryNode;
begin
  if FdPickingGeometry.Value is TAbstractGeometryNode then
    Result := TAbstractGeometryNode(FdPickingGeometry.Value)
  else
    Result := nil;
end;

procedure TAbstractPickSensorNode.SetPickingGeometry(const Value: TAbstractGeometryNode);
begin
  FdPickingGeometry.Send(Value);
end;

{$endif read_implementation}
