{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetUpdate: TTextureUpdate;
    procedure SetUpdate(const Value: TTextureUpdate);
    function GetSize: Integer;
    procedure SetSize(const Value: Integer);
    function GetLight: TAbstractPunctualLightNode;
    procedure SetLight(const Value: TAbstractPunctualLightNode);
    function GetScale: Single;
    procedure SetScale(const Value: Single);
    function GetBias: Single;
    procedure SetBias(const Value: Single);
    function GetCompareMode: TShadowMapCompareMode;
    procedure SetCompareMode(const Value: TShadowMapCompareMode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdUpdate: TSFStringEnum;
    { Internal wrapper for property @code(Update). This wrapper API may change, we advise to access simpler @code(Update) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUpdate: TSFStringEnum read FFdUpdate;
    { When to update the texture contents. }
    property Update: TTextureUpdate read GetUpdate write SetUpdate;

    strict private FFdSize: TSFInt32;
    { Internal wrapper for property @code(Size). This wrapper API may change, we advise to access simpler @code(Size) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSize: TSFInt32 read FFdSize;
    {  }
    property Size: Integer read GetSize write SetSize;

    strict private FFdLight: TSFNode;
    { Internal wrapper for property @code(Light). This wrapper API may change, we advise to access simpler @code(Light) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLight: TSFNode read FFdLight;
    { @deprecated This field is only used internally by the engine now. You should never specify any light source here. The light source associated with the shadow map is implicit: it is the parent node of this GeneratedShadowMap node, that defined this GeneratedShadowMap node in defaultShadowMap field. }
    property Light: TAbstractPunctualLightNode read GetLight write SetLight;

    strict private FFdScale: TSFFloat;
    { Internal wrapper for property @code(Scale). This wrapper API may change, we advise to access simpler @code(Scale) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScale: TSFFloat read FFdScale;
    {  }
    property Scale: Single read GetScale write SetScale;

    strict private FFdBias: TSFFloat;
    { Internal wrapper for property @code(Bias). This wrapper API may change, we advise to access simpler @code(Bias) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBias: TSFFloat read FFdBias;
    {  }
    property Bias: Single read GetBias write SetBias;

    strict private FFdCompareMode: TSFStringEnum;
    { Internal wrapper for property @code(CompareMode). This wrapper API may change, we advise to access simpler @code(CompareMode) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCompareMode: TSFStringEnum read FFdCompareMode;
    { @deprecated This is ignored now. It was unportable and complicated to maintain. }
    property CompareMode: TShadowMapCompareMode read GetCompareMode write SetCompareMode;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeneratedShadowMapNode ----------------------------------------------- }

function TGeneratedShadowMapNode.GetUpdate: TTextureUpdate;
begin
  Result := TTextureUpdate(FdUpdate.EnumValue);
end;

procedure TGeneratedShadowMapNode.SetUpdate(const Value: TTextureUpdate);
begin
  FdUpdate.SendEnumValue(Ord(Value));
end;

function TGeneratedShadowMapNode.GetSize: Integer;
begin
  Result := FdSize.Value;
end;

procedure TGeneratedShadowMapNode.SetSize(const Value: Integer);
begin
  FdSize.Send(Value);
end;

function TGeneratedShadowMapNode.GetLight: TAbstractPunctualLightNode;
begin
  if FdLight.Value is TAbstractPunctualLightNode then
    Result := TAbstractPunctualLightNode(FdLight.Value)
  else
    Result := nil;
end;

procedure TGeneratedShadowMapNode.SetLight(const Value: TAbstractPunctualLightNode);
begin
  FdLight.Send(Value);
end;

function TGeneratedShadowMapNode.GetScale: Single;
begin
  Result := FdScale.Value;
end;

procedure TGeneratedShadowMapNode.SetScale(const Value: Single);
begin
  FdScale.Send(Value);
end;

function TGeneratedShadowMapNode.GetBias: Single;
begin
  Result := FdBias.Value;
end;

procedure TGeneratedShadowMapNode.SetBias(const Value: Single);
begin
  FdBias.Send(Value);
end;

function TGeneratedShadowMapNode.GetCompareMode: TShadowMapCompareMode;
begin
  Result := TShadowMapCompareMode(FdCompareMode.EnumValue);
end;

procedure TGeneratedShadowMapNode.SetCompareMode(const Value: TShadowMapCompareMode);
begin
  FdCompareMode.SendEnumValue(Ord(Value));
end;

class function TGeneratedShadowMapNode.ClassX3DType: String;
begin
  Result := 'GeneratedShadowMap';
end;

procedure TGeneratedShadowMapNode.CreateNode;
begin
  inherited;

  FFdUpdate := TSFStringEnum.Create(Self, True, 'update', @TextureUpdateNames, Ord(High(TextureUpdateNames)) + 1, Ord(upNone));
   FdUpdate.ChangeAlways := chRedisplay;
  AddField(FFdUpdate);

  FFdSize := TSFInt32.Create(Self, False, 'size', 128);
   FdSize.ChangeAlways := chTextureRendererProperties;
   FdSize.MustBeNonnegative := true;
  AddField(FFdSize);

  FFdLight := TSFNode.Create(Self, False, 'light', [TAbstractPunctualLightNode]);
   FdLight.ChangeAlways := chGeneratedTextureUpdateNeeded;
   FdLight.WeakLink := true;
  AddField(FFdLight);

  FFdScale := TSFFloat.Create(Self, True, 'scale', DefaultScale);
   FdScale.ChangeAlways := chGeneratedTextureUpdateNeeded;
   FdScale.MustBeNonnegative := true;
  AddField(FFdScale);

  FFdBias := TSFFloat.Create(Self, True, 'bias', DefaultBias);
   FdBias.ChangeAlways := chGeneratedTextureUpdateNeeded;
   FdBias.MustBeNonnegative := true;
  AddField(FFdBias);

  FFdCompareMode := TSFStringEnum.Create(Self, False, 'compareMode', @CompareModeNames, Ord(High(CompareModeNames)) + 1, Ord(smCompareRLEqual));
   FdCompareMode.ChangeAlways := chTextureRendererProperties;
  AddField(FFdCompareMode);
end;

{$endif read_implementation}
