;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; File:     memstore-tests.asd
;;;; Author:   Kevin Rosenberg
;;;; Created:  March 2011
;;;;
;;;; This file is part of the Memstore package.
;;;; *************************************************************************

(in-package #:cl-user)
(defpackage #:memstore-tests-system (:use #:asdf #:cl))
(in-package #:memstore-tests-system)

(defsystem memstore-tests
    :name "Memstore tests"
  :author "Kevin Rosenberg"
  :licence "BSD"
  :description "A regression test suite for memstore."
  :depends-on (memstore rt)
  :components ((:module src
                :components
                        ((:file "tests")))))

(defmethod operation-done-p ((o test-op)
                             (c (eql (find-system :memstore-tests))))
  ;; Always returns NIL so that tests are never marked as done.
  nil)

(defmethod perform ((o test-op) (c (eql (find-system :memstore-tests))))
  (flet ((run-tests (&rest args)
           (apply (intern (string '#:run-tests)
                          (find-package '#:memstore-tests))
                  args)))
    (load-system c)
    (run-tests :compiled nil)
    (run-tests :compiled t)))
