import QtQuick 2.0
import QtWebKit 3.0

Rectangle {
    id: inappbrowser
    property string url: "http://canonical.com"
    Rectangle {
        border.color: "black"
        width: parent.width
        height: url.height
        color: "gray"
        TextInput {
            id: url
            width: parent.width - closeButton.width
            text: inappbrowser.url
            activeFocusOnPress: false
        }
        Image {
            id: closeButton
            width: height
            x: parent.width - width
            height: parent.height
            source: "assets/close.png"
            MouseArea {
                anchors.fill: parent
                onClicked: {
                    inappbrowser.parent.exec("com.cordova.InAppBrowser", "close", [0, 0])
                }
            }
        }
    }

    WebView {
        width: parent.width
        y: url.height
        height: parent.height - y
        url: inappbrowser.url
        onLoadingChanged: {
            if (loadRequest.status) {
                inappbrowser.parent.exec("com.cordova.InAppBrowser", "loadFinished")
            }
        }
    }
}
