/* $Id: qfits_memory.h,v 1.1.1.1 2008-11-03 13:40:49 agabasch Exp $
 *
 * This file is part of the ESO QFITS Library
 * Copyright (C) 2001-2004 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: agabasch $
 * $Date: 2008-11-03 13:40:49 $
 * $Revision: 1.1.1.1 $
 * $Name: not supported by cvs2svn $
 */

#ifndef QFITS_MEMORY_H
#define QFITS_MEMORY_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

#define qfits_malloc(s)         qfits_memory_malloc(s,      __FILE__,__LINE__)
#define qfits_calloc(n,s)       qfits_memory_calloc(n,s,    __FILE__,__LINE__)
#define qfits_realloc(p,s)      qfits_memory_realloc(p,s,   __FILE__,__LINE__)
#define qfits_free(p)           qfits_memory_free(p,        __FILE__,__LINE__)
#define qfits_strdup(s)         qfits_memory_strdup(s,      __FILE__,__LINE__)
#define qfits_falloc(f,o,s)     qfits_memory_falloc(f,o,s,  __FILE__,__LINE__)
#define qfits_fdealloc(f,o,s)   qfits_memory_fdealloc(f,o,s,__FILE__,__LINE__)

/*-----------------------------------------------------------------------------
                               Function prototypes
 -----------------------------------------------------------------------------*/

/* *********************************************************************** */
/* These functions have to be called by the assiciated macro defined above */
void * qfits_memory_malloc(size_t, const char *, int) ;
void * qfits_memory_calloc(size_t, size_t, const char *, int) ;
void * qfits_memory_realloc(void *, size_t, const char *, int) ;
void   qfits_memory_free(void *, const char *, int) ;
char * qfits_memory_strdup(const char *, const char *, int) ;
char * qfits_memory_falloc(char *, size_t, size_t *, const char *, int) ;
void qfits_memory_fdealloc(void *, size_t, size_t, const char *, int) ;
/* *********************************************************************** */

void qfits_memory_status(void) ;
int qfits_memory_is_empty(void) ;

#endif
