<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version = '1.0' 
     xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<!-- alphabet.xsl Iain Murray 09/2002
     A quick demonstration of another reason for using XML: ease of transformation
     alphabet-nest2.xsl by DJCM Identical to Kaburagi's alphabet-nest.xsl except the "t" field
     is displayed rather than the "d" -->

<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"
doctype-public="-//W3C//DTD HTML 4.01//EN"
doctype-system="http://www.w3.org/TR/html4/strict.dtd" />

<xsl:template match="alphabets">
<html lang="en">
<head>
<title>Dasher Alphabets</title>
<!-- Uncomment the following line if your xslt processor doesn't add it.
     xsltproc from the Gnome project (and available for Windows) does. -->
<!-- <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /> -->
<link rel="home" title="Home" href="http://www.inference.phy.cam.ac.uk/dasher/"/>
<link rel="contact" title="Contact" href="http://www.metafaq.com/faq/dasher/"/>
<style type="text/css">
.content {font-family : 'Lucida Grande', Verdana, Geneva, Lucida, Arial, Helvetica, sans-serif;}
.content h1 {border-bottom : 2px solid #4686c2; margin-bottom : 1em;}
.content h2 {margin-top : 0;}
.content hr{
	color : #4686c2;
	background-color : #4686c2;
	height : 2px;
	border: 0 solid #4686c2;
	margin-top : 1em;
	margin-bottom : 1em;
}
</style>
</head>
<body>

<div class="content">
	<h1><a><xsl:attribute name="href">http://www.inference.phy.cam.ac.uk/dasher/</xsl:attribute>Dasher </a>
<a><xsl:attribute name="href">http://www.inference.phy.cam.ac.uk/dasher/download/alphabets/</xsl:attribute>Alphabets</a></h1>
	<xsl:apply-templates select="//alphabet"/>
</div>

<div style="text-align:right"><em>This page automagically generated by
<a><xsl:attribute name="href">http://www.inference.phy.cam.ac.uk/dasher/download/alphabets/alphabet-nest2.xsl</xsl:attribute>
alphabet-nest2.xsl
</a></em></div>

</body>
</html> 
</xsl:template>

<xsl:template match="alphabet">

	<h2><xsl:value-of select="@name"/></h2>
	<ul>
	<li>Training file:
	<a><xsl:attribute name="href">http://www.inference.phy.cam.ac.uk/dasher/download/training/<xsl:value-of select="train"/></xsl:attribute>
 <xsl:value-of select="train"/>
 </a></li>
	<li>Encoding type: <xsl:value-of select="encoding/@type"/></li>
	<li>Default orientation: <xsl:value-of select="orientation/@type"/></li>
	<li>Space character: <xsl:value-of select="space/@d"/></li>
	<li>Paragraph character: <xsl:value-of select="paragraph/@d"/></li>
	</ul>
	<!--edited by T.Kaburagi 2004.10.23 -->
	<table>
	<tr><td>
		<xsl:apply-templates/>
	</td></tr>
	</table>
	
	<hr/>
</xsl:template>

<xsl:template match="group">
	<table>
	<tr>

	<td><strong><xsl:value-of select="@name"/></strong></td><td bgcolor="#ddeeff"><strong><xsl:value-of select="@label"/></strong> </td>
	<td>
		<xsl:apply-templates/>
	</td>

	</tr>
	</table>
</xsl:template>

<xsl:template match="s">
	<td> <abbr>
	<xsl:attribute name="title">
	<xsl:value-of select="@d"/> 
	<xsl:value-of select="@note"/> 
	bgcolor:<xsl:value-of select="@b"/>
	</xsl:attribute>
	<xsl:value-of select="@t"/>
	</abbr></td>
</xsl:template>


</xsl:stylesheet>
