# Copyright 2012 Managed I.T.
#
# Author: Kiall Mac Innes <kiall@managedit.ie>
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
from oslo_config import cfg


cfg.CONF.register_group(cfg.OptGroup(
    name='service:api', title="Configuration for API Service"
))

cfg.CONF.register_opts([
    cfg.IntOpt('workers',
               help='Number of api worker processes to spawn'),
    cfg.IntOpt('threads', default=1000,
               help='Number of api greenthreads to spawn'),
    cfg.BoolOpt('enable-host-header', default=False,
               help='Enable host request headers'),
    cfg.StrOpt('api-base-uri', default='http://127.0.0.1:9001/'),
    cfg.IPOpt('api_host', default='0.0.0.0',
              help='API Host'),
    cfg.PortOpt('api_port', default=9001,
                help='API Port Number'),
    cfg.StrOpt('api_paste_config', default='api-paste.ini',
               help='File name for the paste.deploy config for designate-api'),
    cfg.StrOpt('auth_strategy', default='keystone',
               help='The strategy to use for auth. Supports noauth or '
                    'keystone'),
    cfg.BoolOpt('enable-api-v1', default=True),
    cfg.BoolOpt('enable-api-v2', default=False),
    cfg.BoolOpt('enable-api-admin', default=False),
    cfg.IntOpt('max_header_line', default=16384,
               help="Maximum line size of message headers to be accepted. "
                    "max_header_line may need to be increased when using "
                    "large tokens (typically those generated by the "
                    "Keystone v3 API with big service catalogs)."),
], group='service:api')
