/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.adl.datamodels.cmi.CMIComments;
import org.adl.datamodels.cmi.CMICommentsFromLms;
import org.adl.datamodels.cmi.CMICore;
import org.adl.datamodels.cmi.CMIInteractions;
import org.adl.datamodels.cmi.CMILaunchData;
import org.adl.datamodels.cmi.CMIObjectives;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMIStudentData;
import org.adl.datamodels.cmi.CMIStudentPreference;
import org.adl.datamodels.cmi.CMISuspendData;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class SCODataManager
implements Serializable {
    public CMICore core = new CMICore();
    public CMISuspendData suspend_data = new CMISuspendData();
    public CMILaunchData launch_data = new CMILaunchData();
    public CMIComments comments = new CMIComments();
    public CMICommentsFromLms comments_from_lms = new CMICommentsFromLms();
    public CMIObjectives objectives = new CMIObjectives();
    public CMIInteractions interactions = new CMIInteractions();
    public CMIStudentData student_data = new CMIStudentData();
    public CMIStudentPreference student_preference = new CMIStudentPreference();
    private String workingBaseCategory;
    private static final String CMI_VERSION = "3.4";
    private static final String DM_CLASSNAME = "org.adl.datamodels.cmi.CMI";

    public CMICore getCore() {
        return this.core;
    }

    public CMISuspendData getSuspendData() {
        return this.suspend_data;
    }

    public CMILaunchData getLaunchData() {
        return this.launch_data;
    }

    public CMIComments getComments() {
        return this.comments;
    }

    public CMICommentsFromLms getCommentsFromLMS() {
        return this.comments_from_lms;
    }

    public CMIObjectives getObjectives() {
        return this.objectives;
    }

    public CMIInteractions getInteractions() {
        return this.interactions;
    }

    public CMIStudentData getStudentData() {
        return this.student_data;
    }

    public CMIStudentPreference getStudentPreference() {
        return this.student_preference;
    }

    public void setCore(CMICore inCore) {
        this.core = inCore;
    }

    public void setSuspendData(CMISuspendData inSuspendData) {
        this.suspend_data = inSuspendData;
    }

    public void setLaunchData(CMILaunchData inLaunchData) {
        this.launch_data = inLaunchData;
    }

    public void setComments(CMIComments inComments) {
        this.comments = inComments;
    }

    public void setCommentsFromLMS(CMICommentsFromLms inComments) {
        this.comments_from_lms = inComments;
    }

    public void setObjectives(CMIObjectives inObjectives) {
        this.objectives = inObjectives;
    }

    public void setInteractions(CMIInteractions inInteractions) {
        this.interactions = inInteractions;
    }

    public void setStudentData(CMIStudentData inStudentData) {
        this.student_data = inStudentData;
    }

    public void setStudentPreference(CMIStudentPreference inStudentPref) {
        this.student_preference = inStudentPref;
    }

    public String getValue(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("In SCODataManager::getValue");
        }
        this.workingBaseCategory = theRequest.getBaseCategory();
        String result = new String("");
        result = this.workingBaseCategory.equals("_version") ? CMI_VERSION : this.processRequest(theRequest, dmErrorMgr);
        return result;
    }

    public void setValue(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("In SCODataManager::setValue");
        }
        this.workingBaseCategory = theRequest.getBaseCategory();
        String result = this.processRequest(theRequest, dmErrorMgr);
    }

    private String processRequest(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String result = new String("");
        String tmpClassName = this.convertString(this.workingBaseCategory);
        String className = DM_CLASSNAME + tmpClassName;
        if (DebugIndicator.ON) {
            System.out.println("Class Name: " + className);
            System.out.println("Working Base Cat: " + this.workingBaseCategory);
        }
        try {
            Class<?> c = Class.forName(className);
            try {
                Field tmpField = this.getClass().getField(this.workingBaseCategory);
                Class[] parameterTypes = new Class[]{theRequest.getClass(), dmErrorMgr.getClass()};
                Object[] arguments = new Object[]{theRequest, dmErrorMgr};
                try {
                    if (theRequest.isForASetRequest()) {
                        Method theMethod = c.getMethod("performSet", parameterTypes);
                        if (DebugIndicator.ON) {
                            System.out.println("I will invoke theMethod: " + theMethod);
                        }
                        theMethod.invoke(tmpField.get(this), arguments);
                    } else {
                        Method theMethod = c.getMethod("performGet", parameterTypes);
                        result = (String)theMethod.invoke(tmpField.get(this), arguments);
                    }
                }
                catch (NoSuchMethodException e) {
                    System.out.println("nosuchmethodexception");
                    System.out.println(e);
                }
                catch (IllegalAccessException e) {
                    System.out.println("illegalaccessexception");
                    System.out.println(e);
                }
                catch (InvocationTargetException e) {
                    System.out.println("InvocationTargetException");
                    System.out.println(e);
                }
            }
            catch (NoSuchFieldException nsfe) {
                if (DebugIndicator.ON) {
                    System.out.println(nsfe);
                    System.out.println("Error - Data Model Element not Implemented");
                }
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        }
        catch (ClassNotFoundException cnfe) {
            if (DebugIndicator.ON) {
                System.out.println(cnfe);
                System.out.println("Error - Data Model Element not implemented");
            }
            dmErrorMgr.recNotImplementedError(theRequest);
        }
        return result;
    }

    private String convertString(String theString) {
        StringTokenizer stk = new StringTokenizer(theString, "_", false);
        int total = stk.countTokens();
        String result = new String("");
        while (stk.hasMoreTokens()) {
            result = result.concat(this.fixWord(stk.nextToken()));
        }
        return result;
    }

    private String fixWord(String wordToFix) {
        String result = new String("");
        String firstLetter = wordToFix.substring(0, 1);
        String restOfWord = wordToFix.substring(1);
        String ucFirstLetter = firstLetter.toUpperCase();
        result = ucFirstLetter.concat(restOfWord);
        return result;
    }
}

