/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: LEFTab.java
 *
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;

import javax.swing.JPanel;

/**
 * Class to handle the "LEF" tab of the Preferences dialog.
 */
public class LEFTab extends PreferencePanel
{
	/** Creates new form LEFTab */
	public LEFTab(PreferencesFrame parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
	}

	/** return the panel to use for the user preferences. */
	public JPanel getUserPreferencesPanel() { return lef; }

	/** return the name of this preferences tab. */
	public String getName() { return "LEF"; }

	/**
	 * Method called at the start of the dialog.
	 * Caches current values and displays them in the LEF tab.
	 */
	public void init()
	{
		lefIgnoreUngeneratedPins.setSelected(IOTool.isLEFIgnoreUngeneratedPins());
		lefIgnoreTechnology.setSelected(IOTool.isLEFIgnoreTechnology());

		lefUnknownLayers.addItem("Ignore");
		lefUnknownLayers.addItem("Convert to DRC Exclusion layer");
		lefUnknownLayers.setSelectedIndex(IOTool.getLEFInUnknownLayerHandling());
	}

	/**
	 * Method called when the "OK" panel is hit.
	 * Updates any changed fields in the LEF tab.
	 */
	public void term()
	{
		boolean currentValue = lefIgnoreUngeneratedPins.isSelected();
		if (currentValue != IOTool.isLEFIgnoreUngeneratedPins())
			IOTool.setLEFIgnoreUngeneratedPins(currentValue);
		currentValue = lefIgnoreTechnology.isSelected();
		if (currentValue != IOTool.isLEFIgnoreTechnology())
			IOTool.setLEFIgnoreTechnology(currentValue);
		
		int currentI = lefUnknownLayers.getSelectedIndex();
		if (currentI != IOTool.getLEFInUnknownLayerHandling())
			IOTool.setLEFInUnknownLayerHandling(currentI);
	}

	/**
	 * Method called when the factory reset is requested.
	 */
	public void reset()
	{
		if (IOTool.isFactoryLEFIgnoreUngeneratedPins() != IOTool.isLEFIgnoreUngeneratedPins())
			IOTool.setLEFIgnoreUngeneratedPins(IOTool.isFactoryLEFIgnoreUngeneratedPins());
		if (IOTool.isFactoryLEFIgnoreTechnology() != IOTool.isLEFIgnoreTechnology())
			IOTool.setLEFIgnoreTechnology(IOTool.isFactoryLEFIgnoreTechnology());
		if (IOTool.getFactoryLEFInUnknownLayerHandling() != IOTool.getLEFInUnknownLayerHandling())
			IOTool.setLEFInUnknownLayerHandling(IOTool.getFactoryLEFInUnknownLayerHandling());
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        java.awt.GridBagConstraints gridBagConstraints;

        lef = new javax.swing.JPanel();
        lefIgnoreTechnology = new javax.swing.JCheckBox();
        lefImport = new javax.swing.JPanel();
        lefIgnoreUngeneratedPins = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        lefUnknownLayers = new javax.swing.JComboBox();

        setTitle("IO Options");
        setName(""); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                closeDialog(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        lef.setLayout(new java.awt.GridBagLayout());

        lefIgnoreTechnology.setText("Ignore technology information");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        lef.add(lefIgnoreTechnology, gridBagConstraints);

        lefImport.setBorder(javax.swing.BorderFactory.createTitledBorder("Import"));
        lefImport.setLayout(new java.awt.GridBagLayout());

        lefIgnoreUngeneratedPins.setText("Ignore ungenerated pins (with no location)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        lefImport.add(lefIgnoreUngeneratedPins, gridBagConstraints);

        jLabel1.setText("Unknown layers:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        lefImport.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        lefImport.add(lefUnknownLayers, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        lef.add(lefImport, gridBagConstraints);

        getContentPane().add(lef, new java.awt.GridBagConstraints());

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel lef;
    private javax.swing.JCheckBox lefIgnoreTechnology;
    private javax.swing.JCheckBox lefIgnoreUngeneratedPins;
    private javax.swing.JPanel lefImport;
    private javax.swing.JComboBox lefUnknownLayers;
    // End of variables declaration//GEN-END:variables

}
