//
// File: Encadreur.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Mon Jul 31 19:57:35 2006
//

#include "Encadreur.h"
#include <iostream>
using std::cout;
using std::endl;
#include <list>
using std::list;
using std::pair;


Encadreur::Encadreur()
{
	//valeurs par défaut des paramètres:
	couleur_fonte_signature=Color(0,0,0);
	pourcentage_fonte_signature=2.0/100;
	position_signature=SouthEastGravity;
	signature="";
	qualite=100;
	prefixe_nom_image_encadree="cadre-";
	taille_cadre_exterieur=0;
	taille_cadre_interieur=0;
	repertoire_source="";
	repertoire_destination="";
    redimensionnement=0;
}

Encadreur::~Encadreur()
{
	// TODO: put destructor code here
}

bool Encadreur::SetPourcentagesCadres(vector<double> pourcentages)
{
    pourcentages_cadres.clear();
    double pourcentage=0.0;
    if (!pourcentages.empty())
    {    
       for (unsigned int i=0;i<pourcentages.size();i++)
       {
            if (ConversionEnPourcentage(pourcentages[i], pourcentage))
                    pourcentages_cadres.push_back(pourcentage);
            else return false;    
        }
    } 
    return true;       
}

bool Encadreur::ConversionEnPourcentage(double pourcentage, double &valeur_pourcentage)
{
    if ((pourcentage >=0.0) && (pourcentage <=100.0))
    {
        valeur_pourcentage=pourcentage/100.0;
        return true;
    }
    else
    {
        return false;
    }      
}

bool Encadreur::SetPourcentageFonteSignature(double pourcentage)
{
	return ConversionEnPourcentage(pourcentage, pourcentage_fonte_signature);
}

bool Encadreur::SetPositionSignature(wxString position)
{
    if (position.IsSameAs(wxT("Haut-Droite"))) position_signature=NorthEastGravity;
    else if (position.IsSameAs(wxT("Bas-Droite"))) position_signature=SouthEastGravity;
    else return false;
    return true;
}

bool Encadreur::SetCouleurSignature(wxColor couleur)
{
	// sous ImageMagick, les options de compilation par défaut codent les couleurs sur 16bits
	// wxWidgets les code sous 8 bits, d'ou la conversion ci-dessous (65535/255=257)
	couleur_fonte_signature=Color(couleur.Red()*257,couleur.Green()*257,couleur.Blue()*257);
	return true;
}	


void Encadreur::SetCouleurAutoSignature(bool couleurauto)
{
    couleur_auto_signature=couleurauto;
}    

bool Encadreur::SetCouleursCadres(vector<wxColor> couleurs)
{
    couleurs_cadres.clear();
    if (!couleurs.empty())
	{
        // sous ImageMagick, les options de compilation par défaut codent les couleurs sur 16bits
        // wxWidgets les code sous 8 bits, d'ou la conversion ci-dessous (65535/255=257)
       for (unsigned int i=0;i<couleurs.size();i++) 
           couleurs_cadres.push_back(Color(couleurs[i].Red()*257,couleurs[i].Green()*257,couleurs[i].Blue()*257));
    }  
   return true;       
}	


void Encadreur::SetCouleursAutoCadres(vector <bool> couleursauto)
{
    couleur_auto_cadres.clear();
    for (unsigned int i=0;i<couleursauto.size();i++) couleur_auto_cadres.push_back(couleursauto[i]);
}    

void Encadreur::SetSignature(wxString chaine)
{
	string temp(chaine.mb_str());
	signature=temp;
}

void Encadreur::SetRepertoireSource(wxString chaine)
{
	string temp(chaine.mb_str());
	repertoire_source=temp;
}

void Encadreur::SetRepertoireDestination(wxString chaine)
{
	string temp(chaine.mb_str());
	repertoire_destination=temp;
}	

void Encadreur::SetPrefixeFichier(wxString chaine)
{
	string temp(chaine.mb_str());
	prefixe_nom_image_encadree=temp;
}	

bool Encadreur::SetQualiteEnregistrement(int pourcentage)
{
    if ((pourcentage >=1) && (pourcentage <=100))
    {
        qualite=pourcentage;
        return true;
    }
    else {
        qualite=100;
        return false;
    }    
}   

void Encadreur::SetRedimensionnement(int dimension)
{
    redimensionnement=dimension;
}   

wxString Encadreur::Encadre(wxString image_a_encadrer)
{
    dominante_deja_calcule=false;
	wxString erreur(wxT(""));
	string nom_image(image_a_encadrer.mb_str());
	string temp("");
	temp=repertoire_source+"/"+nom_image;
	Image master;
	// on vérifie qu'il s'agit bien d'un fichier image
	try
	{
		master.read( temp );
	}
	catch( Exception &error_ )
	{
		string str =error_.what();
		wxString exception(str.c_str(),wxConvUTF8);
		erreur << wxT("erreur lors de l'ouverture de l'image ") << image_a_encadrer<<wxT(":  ")<<exception;
		return erreur;
	}
    Image image_de_travail=master;
	double taille=0;
    //std::cout<<"encadrement de "<<nom_image<<std::endl;
	// la taille du cadre à ajouter sera un pourcentage de la taille en pixel du plus grand côté
	if (image_de_travail.columns()>=image_de_travail.rows())
		taille=image_de_travail.columns();
	else
		taille=image_de_travail.rows();
    // s'il y a des cadres à tracer, on le fait
    Image image_encadree = image_de_travail;
    int taille_totale_cadres=0;
    if (!pourcentages_cadres.empty())
    {   
        int taille_cadre=0;
        for (unsigned int i=0;i<pourcentages_cadres.size();i++)
        { 
            // on ajoute les cadres
            Image image_encadree = image_de_travail;
            if (pourcentages_cadres[i]!=0)
            {
                if (couleur_auto_cadres[i]) couleurs_cadres[i]=ChercheDominante(master);
                taille_cadre=(int)(pourcentages_cadres[i]*taille);
                Geometry geometrie_cadre(taille_cadre,taille_cadre);
                taille_totale_cadres=taille_totale_cadres+taille_cadre;
                try
                {
                    image_encadree.borderColor(couleurs_cadres[i]);
                    image_encadree.border(geometrie_cadre);
                }
                catch( Exception &error_ )
                {
                    string str =error_.what();
                    wxString exception(str.c_str(),wxConvUTF8);
                    erreur << wxT("erreur lors de l'ajout du cadre n° ") << i<< wxT(" sur ")<< image_a_encadrer<<wxT(":  ")<<exception;
                    return erreur;
                }
                image_de_travail=image_encadree;
            }
        }
    }        

	// on ajoute la signature si elle est demandée
	if (signature !="")
	{
		try
		{
			image_de_travail.fillColor(couleur_fonte_signature);
			taille_fonte_signature=(int)(pourcentage_fonte_signature*taille);
			image_de_travail.fontPointsize(taille_fonte_signature);
			image_de_travail.annotate(signature,GeometrieSignature(image_de_travail,taille_totale_cadres),position_signature);
		}
		catch( Exception &error_ )
		{
			string str =error_.what();
			wxString exception(str.c_str(),wxConvUTF8);
			erreur << wxT("erreur lors de l'ajout de la signature ") << image_a_encadrer<<wxT(":  ")<<exception;
			return erreur;
		}
	}

    // on effecte le redimensionnement de l'image si demandé
    if (redimensionnement!=0)
    {
       Geometry geometrie(redimensionnement,redimensionnement);
        image_de_travail.scale(geometrie);        
    }
    
	// on sauvegarde l'image encadrée
//    Image image_encadree;
	try
	{
		image_de_travail.quality (qualite);
		image_de_travail.write(repertoire_destination+"/"+prefixe_nom_image_encadree+nom_image);
	}
	catch( Exception &error_ )
	{
		string str =error_.what();
		wxString exception(str.c_str(),wxConvUTF8);
		erreur << wxT("erreur lors de la sauvegarde de l'image encadrée ") << image_a_encadrer<<wxT(":  ")<<exception;
		return erreur;
	}
	
	return (wxT(""));
}

Geometry Encadreur::GeometrieSignature(Image image,int taille_cadres)
{
	// calcule les coordonnées de la signature en fonction de sa position et de la taille de l'image
	int x=0;
	int y=0;
	unsigned int xdecalage=0;
	unsigned int ydecalage=0;
	bool xnegatif=false;
	bool ynegatif=false;
	switch (position_signature)
	{
		case NorthEastGravity:
			xdecalage=taille_cadres;ydecalage=xdecalage;
			x=image.columns();y=0;
			xnegatif=false;ynegatif=true;
		break;
		case SouthEastGravity:
			xdecalage=taille_cadres;ydecalage=xdecalage;
			x=image.columns();y=image.rows();
			xnegatif=false;ynegatif=false;
		break;
		default:
            wxLogFatalError(wxT("problème position signature"));
        break;	
	}
	// on rajoute 40% de décalage pour éviter que la signature ne colle trop au cadre intérieur
	xdecalage=(unsigned int)(1.4*xdecalage);
	ydecalage=(unsigned int)(1.4*ydecalage);
	Geometry geometrie_signature(x,y,xdecalage,ydecalage,xnegatif,ynegatif);
	return geometrie_signature;
}

Color Encadreur::ChercheDominante(Image image)
{
    if (!dominante_deja_calcule)
    {    
        dominante_deja_calcule=true;
        // on récupère l'histogramme    
        list<pair<Color,unsigned long> > histogram;
        colorHistogram( &histogram, image);
    
        // on met les occurences de couleur en première position dans la paire
        list<pair<unsigned long,Color> > histogram2;
        pair<unsigned long,Color> paire;
        list<pair<Color,unsigned long> >::const_iterator p=histogram.begin();
        while (p != histogram.end())
        {
            paire.first=p->second;
            paire.second=p->first;
            histogram2.push_front(paire);
            p++;
        }	
    
        // on trie les couleurs en fonction des occurences
        histogram2.sort();
    
        // on calcule la couleur moyenne sur 5 % des couleurs les plus représentées.
        unsigned long rouge=0;unsigned long vert=0;unsigned long bleu=0;
        unsigned int pourcentage(histogram2.size()*5/100);
        list<pair<unsigned long,Color> >::const_iterator ilp=histogram2.end();
        for (unsigned int i=0; i<pourcentage;i++)
        {
            ilp--;
            rouge=rouge+ilp->second.redQuantum() ;
            vert=vert+ilp->second.greenQuantum();
            bleu=bleu+ilp->second.blueQuantum() ;
        }
        rouge=rouge/pourcentage;
        vert=vert/pourcentage;
        bleu=bleu/pourcentage;
        Color dominante(rouge,vert,bleu);
        couleur_dominante_image=dominante;
    } 
    return couleur_dominante_image;
}
