<?

/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2004 by Simone Vellei                             */
/* http://flatnuke.sourceforge.net                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


include "header.php";
include_once "functions.php";
include_once "themes/$theme/theme.php";

$host = getparam("HTTP_HOST", PAR_SERVER, SAN_FLAT);
$self = getparam("PHP_SELF", PAR_SERVER, SAN_FLAT);

$url = "http://".$host.$self;
$url = str_replace(basename($url),"",$url);

// Security convertions
$news = getparam("news",PAR_GET,SAN_FLAT);
$mod = getparam("mod",PAR_GET,SAN_FLAT);
$file = getparam("file",PAR_GET,SAN_FLAT);

// no action for empty datas
if( ($news == "") and ($mod == ""))
	die(_NONPUOI);

// intercept possible directory changes
if(stristr($mod,".."))
	die(_NONPUOI);
if(stristr($file,".."))
	die(_NONPUOI);
if(stristr($news,".."))
	die(_NONPUOI);

// print the news
if($news!=""){
	if(!file_exists("news/$news.xml")) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}

	$string = get_file("news/$news.xml");
	$title = get_xml_element("fn:title",$string);
	$header = stripslashes(get_xml_element("fn:header",$string));
	$body = stripslashes(get_xml_element("fn:body",$string));

	echo "<div align='center'><h1>$title</h1><br /><table width='80%'><tr><td>";
	echo "<font size='3'>$header<br /><br />$body</font>";
	echo "</td></tr></table>";
	echo "<br /><br /><small>"._ARTTR." <b>$sitename</b> - <a href='$url'>$url</a><br />";
	echo _URLREF." <a href='$url"."index.php?mod=read&amp;id=$news'>$url"."index.php?mod=read&amp;id=$news</a>";
	echo "</small></div>";
}
else {
	if($file=="") {
		if(!file_exists("sections/$mod/section.php") AND !file_exists("sections/$mod/gallery")) {
			OpenTable();
			print("<div align='center'><b>"._NORESULT."</b></div>");
			CloseTable();
			return;
		}
	} else {
		if(!file_exists("sections/$mod/$file")) {
			OpenTable();
			print("<div align='center'><b>"._NORESULT."</b></div>");
			CloseTable();
			return;
		}
	}
	
	$mod_title = eregi_replace("^([0-9]*)_|(none)_", "", $mod);
	$mod_title = str_replace("_", " ", $mod_title);
	echo "<div align='center'><h3>$mod_title</h3><br /><table width='90%'><tr><td><font size='3'>" ;
	if($file=="") {
		if(file_exists("sections/$mod/section.php"))
			include("sections/$mod/section.php");
	} else include("sections/$mod/$file");
	/* Gestisce la galleria con gallery */
	if(file_exists("sections/$mod/gallery")) {
		echo "<br /><br />";
		include("gallery/gallery.php");
	}
	echo "</font></td></tr></table>";
	echo "<br /><br /><small>"._ARTTR." <b>$sitename</b> - <a href=\"$url\">$url</a><br />";
	echo _URLREF." <a href=\"$url"."index.php?mod=$mod\">$url"."index.php?mod=$mod</a></small></div>";
}
?>

<script type="text/javascript" language="javascript1.2">
<!--
// Do print the page
if (typeof(window.print) != 'undefined') {
    window.print();
    }
    //-->
    </script>

</body>
</html>
