# របៀបប្រើប្រាស #

ឯកសារទាំងស្រុងនៃវិធីប្រើ: [`fpdf.FPDF` API doc](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF)

[TOC]

## មេរៀនទី 1 - គំរូខ្លី ##

តោះចាប់ផ្តើមជាមួយឧទាហរណ៍ងាយៗ:

```python
{% include "../tutorial/tuto1.py" %}
```

[លទ្ធផល PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto1.pdf)

បន្ទាប់ពីបញ្ចូលឯកសារដើម្បីប្រើក្នុងបណ្ណាល័យ, យើងបង្កើតទំរង់ `FPDF` មួយ។ 
[FPDF](fpdf/fpdf.html#fpdf.fpdf.FPDF) ទំរង់នៃតម្លៃដើមដែលត្រូវបានប្រើទីនេះគឺ: 
ខ្នាតនៃទំព័រទាំងអស់ជា A4 រាងបញ្ឃរ ហើយមានរង្វាស់ខ្នាតគិតជាមីលីម៉ែត្រ។
វាត្រូវបានសំគាល់យ៉ាងច្បាស់ដូចកូដមួយបន្ទាត់ខាងក្រោមនេះ:

```python
pdf = FPDF(orientation="P", unit="mm", format="A4")
```

យើងក៏អាចកំណត់ PDF បានផងដែរជាទំរង់រៀងក្រដាសផ្តេក (`L`) ឬ អាចប្រើក្នុងទំរង់ក្រដាសផ្សេងៗទៀតដូចជា
(ទំរង់លិតស្នាម `Letter` និង ទំរង់ផ្លូវច្បាប់ `Legal`) ហើយខ្នាតរង្វាស់អាចគិតជា (`pt`, `cm`, `in`)។

មុននេះយើងមិនបាននិយាយអំពីទំព័រទេ ដូច្នេះយើងអាចអាចបង្កើតវាដោយប្រើ 
[add_page](fpdf/fpdf.html#fpdf.fpdf.FPDF.add_page)។ ទីតាំងជ្រុងខាងលើខាងឆ្វេង និងទីតាំងដែលកំពុងស្ថិតនៅគឺកំណត់ដោយតម្លៃដើម 1 សង់ទីម៉ែត្រពីស៊ុបនៃបន្ទាត់ ការតម្រឹមអាចផ្លាស់ប្តូរបានដោយប្រើ
[set_margins](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_margins).

មុនយើងអាចបោះពុម្ភអត្ថបទបាន កាតព្វកិច្ចរបស់យើងគឺរើសពុម្ភអក្សរជាមុនសិនដោយប្រើ
[set_font](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_font) មិនដូចនោះទេអត្ថបទរបស់យើងនឹងមានបញ្ហា។
យើងអាចរើសយកពុម្ភអក្សរ Helvetica ដាក់ bold ទំហំ 16 តាមវិធីដូចខាងក្រោមជាគំរូ:

```python
pdf.set_font('helvetica', 'B', 16)
```

យើងអាចកំណត់ជាទំរង់អក្សរទ្រេតដោយប្រើ `I` និង ទំរង់មានបន្ទាត់រត់ពីក្រោយដោយប្រើ `U` ឬ មិនចាំបាច់ប្រើពួកវា វានឹងបង្ហាញទំរង់ធម្មតាជាមួយនិងការប្រើអក្សរទទេ (empty string) មានន័យ (ឬ ការរួមបញ្ចូលគ្នាផ្សេងទៀត)។ ត្រូវចាំថាទំហំអក្សរត្រូវតែអោយតម្លៃខ្នាតគិតជាចុច(points)  មិនមែនគិតជាមីលីម៉ែត្រ (ឬជាខ្នាតណាមួយផ្សេងទេ) នេះជាករណីលើកលេងក្នុងការប្រើប្រាស។
ពុម្ភអក្សរដែលបានបញ្ចូលរួចស្រេចរួមមាន `Times`, `Courier`, `Symbol` និង `ZapfDingbats` ។

ឥលូវយើងអាចបោះពុម្ភសាកល្បងជាមួយការប្រើ [cell](fpdf/fpdf.html#fpdf.fpdf.FPDF.cell)។ មួយក្រឡា (cell) គឹមួយចតុកោណផ្ទៃគិតចាប់ពីផ្តើមបន្ទាត់ រហូតចប់នៃបន្ទាត់ផ្តេក ជាមួយស៊ុបដែលដែលអាចសរសេរអត្ថបទបាន។ វាបញ្ចេញទៅលើទីតាំងដែលកំពុងស្ថិនៅ។ យើងអាចកំណត់វិមាត្រ និង អត្ថបទ (ចំកណ្តាល ឬ ដោយការតម្រឹមស្រេចបាន) ប្រសិនបើមានការកំណត់ព្រំដែនវាអាចបង្ហាញផងដែរ ហើយនិងបង្ហាញចេញបន្ទាប់ពីទីតាំងដែលកំពុងនៅ (ដាក់ទៅខាងស្តាំ ឬ
ដាក់ពីក្រោម ឬ ដាក់បន្ទាប់ពីចុះបន្ទាត់)។ ដើម្បីដាក់ស៊ុមជាបន្ទាត់ជុំវិញយើងប្រើ:

```python
pdf.cell(40, 10, 'Hello World!', 1)
```

ដើម្បីដាក់ Cell ថ្មីមួយទៀតជាប់វា ដោយតម្រឹមអត្ថបទចេញពីកណ្តាលសម្រាប់បន្ទាត់បន្ទាប់យើងអាចប្រើ:

```python
pdf.cell(60, 10, 'Powered by FPDF.', new_x="LMARGIN", new_y="NEXT", align='C')
```

**ចំណាំ**: ការចុះបន្ទាត់អាចធ្វើបានដោយប្រើ [ln](fpdf/fpdf.html#fpdf.fpdf.FPDF.ln). វិធីសាស្រ្តនេះជាការបញ្ជាក់បន្ថែមលើការបញ្ចប់កថាខ័ណ្ឌតាមរយៈគម្លាតកម្ពស់នៃបន្ទាត់។

ជាចុងក្រោយ ក្នុងការបញ្ចប់នៃការបង្កើត យើងត្រូវផ្តល់នូវផ្លូវរបស់ទីតាំងដែលយើងត្រូវរក្សារឯកសារទុកដោយប្រើ [output](fpdf/fpdf.html#fpdf.fpdf.FPDF.output) ដោយមិនចាំបាច់ផ្តល់ប៉ារ៉ាម៉ែត `output()` បញ្ចូនត្រលប់វិញជាស្រទាប់ PDF `bytearray`។

## មេរៀនទី 2 - ក្បាលទំព័រ បាតកថា បំនែកទំពរ និង រូបភាព ##

នេះជាឧទារហ៍មួយដែលមានពីរទំព័រ ក្បាលទំព័រ, បាតកថាទំព័រ ឬ ជើងទំព័រ និង យីហោ:

```python
{% include "../tutorial/tuto2.py" %}
```

[លទ្ធផលចេញជាឯកសារ PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto2.pdf)

ឯកសារនេះបង្កើតដោយប្រើ [header](fpdf/fpdf.html#fpdf.fpdf.FPDF.header) និង 
[footer](fpdf/fpdf.html#fpdf.fpdf.FPDF.footer) ជារបៀបនៃដំណើរបង្កើតនៃក្បាលទំព័រ និង បាតកថាទំព័រ។ ពួកវានឹងចេញមកដោយស្វ័យប្រវត្តិ។ វាមានស្រាប់មកជាមួយ FPDF ត្រាន់តែវាបង្ហាញចេញជាចន្លោះទំនេរដែលធ្វើអោយយើងមើលមិនដឹង។
ដូច្នេះយើងគ្រាន់តែតែបន្ថែមបន្ថយវាជាការស្រេច។

រូបភាពនៃយីហោបានបង្ហាញ [image](fpdf/fpdf.html#fpdf.fpdf.FPDF.image) តាមរយៈការកំណត់ប្រវែងទទឹងដាក់វាលើជ្រុងខាងលើនៃផ្នែកខាងឆ្វេង។ កម្ពស់គឺគណនាដោយស្វ័យប្រវត្តិផ្អែកតាមច្បាប់សមាមាត្រ។

ចំពោះការបង្ហាញលេខទំព័រវាបង្ហាញតម្លៃទទេរនៃប្រវែងទទឹងរបស់ក្រឡាផ្ទៃបន្ទាត់ (cell)។ វាមានន័យថាក្រឡាផ្ទៃត្រូវពង្រីកទៅផ្នែកនៃការកំណត់ចន្លោះទំនេរ(margin) ផ្នែកខាងស្តាំវាតម្រឹមចេញពីកណ្តាលនៃអត្ថបទមក។
លេខទំព័រដែលយើងកំពុងស្ថិតនៅនឹងបង្ហាញតម្លៃដោយប្រើ [page_no](fpdf/fpdf.html#fpdf.fpdf.FPDF.page_no) ទៅតាមចំនួនសរុបនៃទំព័រជាញឹកញ៉ាប់គឺប្រើតម្លៃពិសេសបែបនេះ  `{nb}` ដែលជំនួសដោយចំនួនសរុបនៃទំព័រ (តម្លៃពិសេសនេះអាចប្តូរបានដោយ [alias_nb_pages()](fpdf/fpdf.html#fpdf.fpdf.FPDF.alias_nb_pages))។
ចំណាំនៃរបៀបប្រើប្រាស [set_y](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_y) ដែលអោយយើងកំណត់ទីតាំងអក្សឈរ ពីលើមកក្រោម។

មានមុខងារពិសេសមួយផ្សេងទៀតដែលអាចប្រើបាន: គឺការចុះបន្ទាត់ទៅទំព័រថ្មីដោយស្វ័យប្រវត្តិខណៈពេលវាទៅដល់ចំនុចទាល់នៃទំព័រ (នៅចំនុច 2 សង់ទីម៉ែតគម្លាតពីក្រោមមក) ពេលចុះបន្ទាត់វារក្សាពុម្ភអក្សរដដែល។ ថ្វីបើក្បាលទំព័រ និង បាតកថាទំព័រមានពុម្ភអក្សរផ្ទាល់គឺ (`helvetica`)តែតួរអត្ថបទនៅតែជាពុម្ភ `Times`។
យន្តការនៃការស្តារដោយស្វ័យប្រវត្តិនេះក៏អនុវត្តចំពោះពណ៌ និងទទឹងបន្ទាត់ផងដែរ។
ដែនកំណត់ដែលមានការញែកទំព័រអាចត្រូវបានកំណត់ជាមួយពាក្យថា  [set_auto_page_break](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_auto_page_break)។


## មេរៀនទី 3 - ចុះបន្ទាត់ និង ដាក់ពណ៌ ##

សូមបន្តជាមួយឧទាហរណ៍មួយដែលបោះពុម្ពកទំរង់ថាខណ្ឌយ៉ាងត្រឹមត្រូវ។ ដែលបង្ហាញពីការប្រើប្រាស់ពណ៌។

```python
{% include "../tutorial/tuto3.py" %}
```

[លទ្ធផលសម្រេច PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto3.pdf)

[អត្ថបទ Jules Verne](https://github.com/py-pdf/fpdf2/raw/master/tutorial/20k_c1.txt)

ប្រើ [get_string_width](fpdf/fpdf.html#fpdf.fpdf.FPDF.get_string_width) ប្រវែងនៃខ្សែពុម្ភអក្សរលើពុម្ភអក្សរកំពុងប្រើ ដែលប្រើដើម្បីគណនាទីតាំងជុំវិញចំណងជើង។ ហើយដាក់ពណ៌ដោយប្រើ (via [set_draw_color](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_draw_color) 
[set_fill_color](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_fill_color) និង 
[set_text_color](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_text_color)) ហើយកំណត់កំរ៉ាស់បន្ទាត់ 1 មីលីម៉ែត (ដោយតម្លៃដើម 0.2) និងប្រើ
[set_line_width](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_line_width)។ ចុងក្រោយ យើងទទួលបាន (ដាក់ប៉ារ៉ាម៉ែតចុងក្រោយដោយពាក្យថា “True” នោះបានន័យថាពណ៌ផ្ទៃក្រោយបានដាក់)។

វិធីសាស្រ្តក្នុងការបោះពុម្ភកថាខ័ណ្ឌពហុបន្ទាត់គឺ [multi_cell](fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell). អត្ថបទរក្សាទំរង់ដើមយ៉ាងប្រក្រតី។
រាល់បន្ទាត់ដែលដល់ចុងខាងស្តាំ ឬ ចង់ចុះបន្ទាត់ត្រូវប្រើ (`\n`)
ពេលយើងចុះបន្ទាត់ផ្ទៃថ្មីត្រូវបានបង្កើតដោយស្វ័យប្រវត្តិពីក្រោមបន្ទាត់កំពុងប្រើ។
ការចុះបន្ទាត់ដោយស្វ័យប្រវត្តិនិងប្រព្រឹត្តទៅនៅខាងចុងបំផុតនៃចន្លោះ ឬ soft-hyphen (`\u00ad`) នៅមុខអក្សរដែលត្រូវចុះ។
សញ្ញាត្រេជាអក្សរ និងត្រូវជំនួសដោយសញ្ញាត្រេធម្មតានៅពេលដែលវាភ្ជាប់ជាមួយបន្ទាត់ត្រូវចុះ មិនចឹងទេយើងរំលងវាចោលបាន។

មានកន្លែងពីរដែលអាចកំណត់លើឯកសារបានថាជាសម្បត្តិរបស់យើងបានគឺ: ចំណងជើង 
([set_title](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_title)) និង អ្នកសរសេរ
([set_author](fpdf/fpdf.html#fpdf.fpdf.FPDF.set_author)). ទាំងអស់នេះអាចបង្ហាញជាពីរអត្ថន័យ។
ទីមួយពេលបើកឯកសារជាមួយកម្មវិធី Acrobat Reader ចុចលើ File ពីមីនុយ
ហើយរើសយក Document Properties។ ទីពីរអាចរកវាឃើញពី plug-in ដោយប្រើ Right-Click ហើយរើសយកពាក្យ Document Properties។

## មេរៀនទី 4 - ពហុជួរឈរ ##

 នេះជាឧទារហ៍យោងពីលើកមុន តែត្រង់នេះយើងនឹងបង្ហាញពីរបៀបប្រើប្រាសពហុជួរឈរ។

```python
{% include "../tutorial/tuto4.py" %}
```

[លទ្ធផលសម្រេច PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto4.pdf)

[អត្ថបទ Jules Verne](https://github.com/py-pdf/fpdf2/raw/master/tutorial/20k_c1.txt)

_⚠️ This section has changed a lot and requires a new translation: <https://github.com/py-pdf/fpdf2/issues/267>_

English versions:

* [Tuto 4 - Multi Columns](https://py-pdf.github.io/fpdf2/Tutorial.html#tuto-4-multi-columns)
* [Documentation on TextColumns](https://py-pdf.github.io/fpdf2/TextColumns.html


## មេរៀនទី 5 - បង្កើតតារាង ##

ក្នុងមេរៀននេះនឹងពន្យល់អំពីការបង្កើតតារាងពីរផ្សេងគ្នា ដើម្បីមានភាពងាយស្រួលយើងមានឧទារហ៍ខ្លះៗអំពីការបង្កើតនេះ។

```python
{% include "../tutorial/tuto5.py" %}
```

[លទ្ធផលសម្រេច PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto5.pdf) -
[Countries CSV data](https://github.com/py-pdf/fpdf2/raw/master/tutorial/countries.txt)

មានមូលដ្ឋានក្នុងការធ្វើដោយជោគជ័យជាមួយឧទារហ៍នេះដោយដាក់ទិន្នន័យដោយប្រើ [`FPDF.table()`](https://py-pdf.github.io/fpdf2/Tables.html). វាមានភាពសម្មាញ់និងធ្វើបានលឿន។

តារាងទីពីរយើងនឹងធ្វើអោយប្រសើរជាងមុនរួមមានដូចជា: ដាក់ពណ៌ ដោយកំណត់ប្រវែងទទឹង បន្ថយបន្ទាត់កំពស់។
 តម្រឹមចំណងជើងចេញពីកណ្តាល រៀបជួរឈរដោយការប្តូរតម្លៃប្រវែងទទឹងវា និង ការកំណត់តម្រឹមខាងស្តាំ។
 ជាងនេះទៅទៀតនោះ គឹដកបន្ទាត់ផ្តេកចេញ។
 ធ្វើបែបនេះទៅបានដោយរើសយក `borders_layout` ដែលមានជម្រើសជាច្រើននៅទីនោះ:
 [`TableBordersLayout`](https://py-pdf.github.io/fpdf2/fpdf/enums.html#fpdf.enums.TableBordersLayout).

## មេរៀនទី 6 - បង្កើតតំណរជាមួយអត្ថបទ ##

ក្នុងមេរៀននេះយើងនឹងពន្យល់អំពីរបៀបជាច្រើនក្នុងការដាក់តំណរនៅលើឯកសារ pdf ហើយយើងក៏ដាក់តំណរដៅទៅប្រភពផ្សេងនៅក្រៅផងដែរ។

យើងនឹងបង្ហាញពីរបៀបជាច្រើនទៀតក្នុងការលេងម៉ូដអត្ថបទរួមមានដូចជាម៉ូដឌិត ទ្រេត មានបន្ទាត់ពីក្រោម (bold, italic, underline)។

```python
{% include "../tutorial/tuto6.py" %}
```

[លទ្ធផលសម្រេច PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto6.pdf) -
[fpdf2-logo](https://raw.githubusercontent.com/py-pdf/fpdf2/master/docs/fpdf2-logo.png)

របៀបថ្មីមួយទៀតក្នុងការបង្ហាញអត្ថបទដើម្បីបោះពុម្ភ
 [write()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.write)។ វាមានភាពស្រដៀងទៅនឹង
 [multi_cell()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell)
 ចំណែកភាពខុសគ្នាមាន:

- ការបញ្ចប់នូវបន្ទាត់គឺតម្រឹមខាងស្តាំ ហើយការចាប់បន្ទាត់ថ្មីគឺនៅខាងឆ្វេង។
- ទីតាំងកំពុងធ្វើការវាប្តូរទៅផ្នែកខាងចុងបំផុតនៃអត្ថបទ។

ដោយហេតុនេះយើងអាចសរសេរអត្ថបទជាកំណាត់ៗបាន ដោយការកំណាត់ម៉ូដខុសៗគ្នាតាមដែលយើងចង់បាន ហើយ បន្តទៅទៀតយើងចង់ដាក់វានៅកន្លែងណាក៏បាន។
ម្យ៉ាងវិញទៀត គុណវិបត្តិចម្បងរបស់វាគឺថាយើងមិនអាចតម្រឹម ឬ កែរអត្តបទច្រើនបន្ទាត់បានដូចយើងធ្វើវិធី [multi_cell()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell) ទេ។

គោលបំណងលើឧទារហ៍ទីមួយគឺអោយយើងរៀនប្រើ
 [write()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.write)
. នៅជំហានដំបូងនៃប្រយោគ យើងបានរៀនសរសេរនូវអត្ថបទដោយដោយរចនាបែបធម្មតា ហើយបន្ទាប់ទៀតយើងប្រើវិធី
 [set_font()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_font)
 តមកទៀតយើងរចនាដាក់បន្ទាត់ពីក្រោមពាក្យនៅចុងបញ្ចប់នៃប្រយោគ។

របៀបដាក់នូវតំណរភ្ជាប់ទៅទំព័រទីពីរយើងអាចប្រើវិធី
 [add_link()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.add_link)
ដែលបង្កើតនូវតំបន់ដែលយើងអាចចុចបានហៅថា "link" ហើយវារត់ទៅរកទំព័រមួយផ្សេងទៀតនៅលើឯកសារដែលយើងកំពុងបើក។

ដើម្បីបងតំណរទៅខាងកន្លែងផ្សេងទៀតតាមរយៈរូបភាពដោយប្រើ
 [image()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.image)
. ប្រើវិធីនេះដើម្បីភ្ជាប់តំណរទៅកាន់ប្រភពមួយផ្សេងទៀត ហើយតំណរនេះអាចត្រូវបានប្រើប្រាសជាមួយប្រភពខាងក្នុង និង ខាងក្រៅ។

ជំរើសមួយផ្សេងទៀតយើងអាចដាក់រចនាពុម្ភអក្សរទៅលើការដាក់តំណរភ្ជាប់តាមវិធី  `write_html()`។ អាចប្រើភាសារកូដ html  ដែលអោយយើងថែមអត្ថបទ ផ្លាស់ប្តូររចនាពុម្ភអក្សរ និង ដាក់តំណរភ្ជាប់(link) ដោយប្រើភាសា HTML។
