from Observable import Observable
import configvalues as conf

import gtk
import os



class Navigation(gtk.HBox, Observable):

    #
    # Constructor.
    #
    def __init__(self):

        gtk.HBox.__init__(self, gtk.TRUE, 0)
        # force left-to-right direction for the navigation buttons
        self.set_direction(gtk.TEXT_DIR_LTR)

        data = [(gtk.STOCK_GO_BACK, -1),
                (gtk.STOCK_GO_DOWN, 0),
                (gtk.STOCK_GO_FORWARD, 1)]

        self.__images = []

        for stock, step in data:
            img = gtk.Image()
            #img.set_from_stock(stock, 1)
            img.show()
            self.__images.append(img)
            
            self.add(img)
        #end for


    def send_click(self, x, y):

        
        px = x
        step = -1
        for img in self.__images:
            w, h = img.size_request()
            if (px < w): break
            else:
                px -= w
                step += 1 
        #end for

        self.update_observer(step)


    #
    # Configures the navigation buttons.
    #
    def set_config(self, config):

        self.__images[0].hide()
        self.__images[1].hide()
        self.__images[2].hide()

        path = config.get([conf.SKIN, conf.PATH])
        nav_prev = config.get([conf.SKIN, conf.GRAPHICS, conf.NAV_PREV])
        nav_next = config.get([conf.SKIN, conf.GRAPHICS, conf.NAV_NEXT])
        nav_home = config.get([conf.SKIN, conf.GRAPHICS, conf.NAV_HOME])

        if (nav_prev):
            self.__images[0].set_from_file(os.path.join(path, nav_prev))
            self.__images[0].show()
        if (nav_home):
            self.__images[1].set_from_file(os.path.join(path, nav_home))
            self.__images[1].show()
        if (nav_next):
            self.__images[2].set_from_file(os.path.join(path, nav_next))
            self.__images[2].show()
