/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*- */

/* Metacity X error handling */

/*
 * Copyright (C) 2001 Havoc Pennington
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef GDM_XERRORS_H
#define GDM_XERRORS_H

#include <glib.h>
#include <X11/Xlib.h>

typedef void (* GdmXErrorHandler) (Display     *dpy,
                                   XErrorEvent *error,
                                   gpointer     data);

void      gdm_xerrors_init    (void);

void      gdm_error_trap_push (void);
gint      gdm_error_trap_pop  (void);

#endif
