module Language.Haskell.GhcMod.Read where

import Text.Read (readPrec_to_S, readPrec, minPrec)
import qualified Text.ParserCombinators.ReadP as P
import Text.ParserCombinators.ReadPrec (lift)

-- This library (libraries/base) is derived from code from several
-- sources:

--   * Code from the GHC project which is largely (c) The University of
--     Glasgow, and distributable under a BSD-style license (see below),

--   * Code from the Haskell 98 Report which is (c) Simon Peyton Jones
--     and freely redistributable (but see the full license for
--     restrictions).

--   * Code from the Haskell Foreign Function Interface specification,
--     which is (c) Manuel M. T. Chakravarty and freely redistributable
--     (but see the full license for restrictions).

-- The full text of these licenses is reproduced below.  All of the
-- licenses are BSD-style or compatible.

-- -----------------------------------------------------------------------------

-- The Glasgow Haskell Compiler License

-- Copyright 2004, The University Court of the University of Glasgow.
-- All rights reserved.

-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are met:

-- - Redistributions of source code must retain the above copyright notice,
-- this list of conditions and the following disclaimer.

-- - Redistributions in binary form must reproduce the above copyright notice,
-- this list of conditions and the following disclaimer in the documentation
-- and/or other materials provided with the distribution.

-- - Neither name of the University nor the names of its contributors may be
-- used to endorse or promote products derived from this software without
-- specific prior written permission.

-- THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY COURT OF THE UNIVERSITY OF
-- GLASGOW AND THE CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
-- INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
-- FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
-- UNIVERSITY COURT OF THE UNIVERSITY OF GLASGOW OR THE CONTRIBUTORS BE LIABLE
-- FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
-- DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
-- SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
-- CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
-- LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
-- OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
-- DAMAGE.

-- -----------------------------------------------------------------------------

-- Code derived from the document "Report on the Programming Language
-- Haskell 98", is distributed under the following license:

--   Copyright (c) 2002 Simon Peyton Jones

--   The authors intend this Report to belong to the entire Haskell
--   community, and so we grant permission to copy and distribute it for
--   any purpose, provided that it is reproduced in its entirety,
--   including this Notice.  Modified versions of this Report may also be
--   copied and distributed for any purpose, provided that the modified
--   version is clearly presented as such, and that it does not claim to
--   be a definition of the Haskell 98 Language.

-- -----------------------------------------------------------------------------

-- Code derived from the document "The Haskell 98 Foreign Function
-- Interface, An Addendum to the Haskell 98 Report" is distributed under
-- the following license:

--   Copyright (c) 2002 Manuel M. T. Chakravarty

--   The authors intend this Report to belong to the entire Haskell
--   community, and so we grant permission to copy and distribute it for
--   any purpose, provided that it is reproduced in its entirety,
--   including this Notice.  Modified versions of this Report may also be
--   copied and distributed for any purpose, provided that the modified
--   version is clearly presented as such, and that it does not claim to
--   be a definition of the Haskell 98 Foreign Function Interface.

-- -----------------------------------------------------------------------------

readEither :: Read a => String -> Either String a
readEither s =
  case [ x | (x,"") <- readPrec_to_S read' minPrec s ] of
    [x] -> Right x
    []  -> Left "Prelude.read: no parse"
    _   -> Left "Prelude.read: ambiguous parse"
 where
  read' =
    do x <- readPrec
       lift P.skipSpaces
       return x

readMaybe :: Read a => String -> Maybe a
readMaybe s = case readEither s of
                Left _  -> Nothing
                Right a -> Just a
