/* gitg-ext-application.c generated by valac 0.34.7, the Vala compiler
 * generated from gitg-ext-application.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libgitg/libgitg.h"
#include <gee.h>


#define GITG_EXT_TYPE_APPLICATION (gitg_ext_application_get_type ())
#define GITG_EXT_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_APPLICATION, GitgExtApplication))
#define GITG_EXT_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_APPLICATION))
#define GITG_EXT_APPLICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_EXT_TYPE_APPLICATION, GitgExtApplicationIface))

typedef struct _GitgExtApplication GitgExtApplication;
typedef struct _GitgExtApplicationIface GitgExtApplicationIface;

#define GITG_EXT_TYPE_UI_ELEMENT (gitg_ext_ui_element_get_type ())
#define GITG_EXT_UI_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_UI_ELEMENT, GitgExtUIElement))
#define GITG_EXT_IS_UI_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_UI_ELEMENT))
#define GITG_EXT_UI_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_EXT_TYPE_UI_ELEMENT, GitgExtUIElementIface))

typedef struct _GitgExtUIElement GitgExtUIElement;
typedef struct _GitgExtUIElementIface GitgExtUIElementIface;

#define GITG_EXT_TYPE_ACTIVITY (gitg_ext_activity_get_type ())
#define GITG_EXT_ACTIVITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_ACTIVITY, GitgExtActivity))
#define GITG_EXT_IS_ACTIVITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_ACTIVITY))
#define GITG_EXT_ACTIVITY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_EXT_TYPE_ACTIVITY, GitgExtActivityIface))

typedef struct _GitgExtActivity GitgExtActivity;
typedef struct _GitgExtActivityIface GitgExtActivityIface;

#define GITG_EXT_TYPE_USER_QUERY (gitg_ext_user_query_get_type ())
#define GITG_EXT_USER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_USER_QUERY, GitgExtUserQuery))
#define GITG_EXT_USER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_EXT_TYPE_USER_QUERY, GitgExtUserQueryClass))
#define GITG_EXT_IS_USER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_USER_QUERY))
#define GITG_EXT_IS_USER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_EXT_TYPE_USER_QUERY))
#define GITG_EXT_USER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_EXT_TYPE_USER_QUERY, GitgExtUserQueryClass))

typedef struct _GitgExtUserQuery GitgExtUserQuery;
typedef struct _GitgExtUserQueryClass GitgExtUserQueryClass;

#define GITG_EXT_TYPE_MESSAGE_BUS (gitg_ext_message_bus_get_type ())
#define GITG_EXT_MESSAGE_BUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_MESSAGE_BUS, GitgExtMessageBus))
#define GITG_EXT_MESSAGE_BUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_EXT_TYPE_MESSAGE_BUS, GitgExtMessageBusClass))
#define GITG_EXT_IS_MESSAGE_BUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_MESSAGE_BUS))
#define GITG_EXT_IS_MESSAGE_BUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_EXT_TYPE_MESSAGE_BUS))
#define GITG_EXT_MESSAGE_BUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_EXT_TYPE_MESSAGE_BUS, GitgExtMessageBusClass))

typedef struct _GitgExtMessageBus GitgExtMessageBus;
typedef struct _GitgExtMessageBusClass GitgExtMessageBusClass;

#define GITG_EXT_TYPE_NOTIFICATIONS (gitg_ext_notifications_get_type ())
#define GITG_EXT_NOTIFICATIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_NOTIFICATIONS, GitgExtNotifications))
#define GITG_EXT_IS_NOTIFICATIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_NOTIFICATIONS))
#define GITG_EXT_NOTIFICATIONS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_EXT_TYPE_NOTIFICATIONS, GitgExtNotificationsIface))

typedef struct _GitgExtNotifications GitgExtNotifications;
typedef struct _GitgExtNotificationsIface GitgExtNotificationsIface;

#define GITG_EXT_TYPE_NOTIFICATION (gitg_ext_notification_get_type ())
#define GITG_EXT_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_NOTIFICATION, GitgExtNotification))
#define GITG_EXT_IS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_NOTIFICATION))
#define GITG_EXT_NOTIFICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_EXT_TYPE_NOTIFICATION, GitgExtNotificationIface))

typedef struct _GitgExtNotification GitgExtNotification;
typedef struct _GitgExtNotificationIface GitgExtNotificationIface;

#define GITG_EXT_TYPE_REMOTE_LOOKUP (gitg_ext_remote_lookup_get_type ())
#define GITG_EXT_REMOTE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_REMOTE_LOOKUP, GitgExtRemoteLookup))
#define GITG_EXT_IS_REMOTE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_REMOTE_LOOKUP))
#define GITG_EXT_REMOTE_LOOKUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_EXT_TYPE_REMOTE_LOOKUP, GitgExtRemoteLookupIface))

typedef struct _GitgExtRemoteLookup GitgExtRemoteLookup;
typedef struct _GitgExtRemoteLookupIface GitgExtRemoteLookupIface;

#define GITG_EXT_TYPE_EXTERNAL_CHANGE_HINT (gitg_ext_external_change_hint_get_type ())

struct _GitgExtUIElementIface {
	GTypeInterface parent_iface;
	gint (*negotiate_order) (GitgExtUIElement* self, GitgExtUIElement* other);
	void (*activate) (GitgExtUIElement* self);
	GitgExtApplication* (*get_application) (GitgExtUIElement* self);
	void (*set_application) (GitgExtUIElement* self, GitgExtApplication* value);
	gchar* (*get_id) (GitgExtUIElement* self);
	gchar* (*get_display_name) (GitgExtUIElement* self);
	gchar* (*get_description) (GitgExtUIElement* self);
	gchar* (*get_icon) (GitgExtUIElement* self);
	GtkWidget* (*get_widget) (GitgExtUIElement* self);
	gboolean (*get_available) (GitgExtUIElement* self);
	gboolean (*get_enabled) (GitgExtUIElement* self);
};

struct _GitgExtActivityIface {
	GTypeInterface parent_iface;
	gboolean (*is_default_for) (GitgExtActivity* self, const gchar* action);
};

struct _GitgExtNotificationIface {
	GTypeInterface parent_iface;
	GtkWidget* (*get_widget) (GitgExtNotification* self);
};

struct _GitgExtNotificationsIface {
	GTypeInterface parent_iface;
	void (*add) (GitgExtNotifications* self, GitgExtNotification* notification);
	void (*remove) (GitgExtNotifications* self, GitgExtNotification* notification, guint delay);
};

struct _GitgExtRemoteLookupIface {
	GTypeInterface parent_iface;
	GitgRemote* (*lookup) (GitgExtRemoteLookup* self, const gchar* name);
};

struct _GitgExtApplicationIface {
	GTypeInterface parent_iface;
	GgitSignature* (*get_verified_committer) (GitgExtApplication* self);
	GitgExtActivity* (*get_activity_by_id) (GitgExtApplication* self, const gchar* id);
	GitgExtActivity* (*set_activity_by_id) (GitgExtApplication* self, const gchar* id);
	void (*user_query) (GitgExtApplication* self, GitgExtUserQuery* query);
	void (*user_query_async) (GitgExtApplication* self, GitgExtUserQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GtkResponseType (*user_query_finish) (GitgExtApplication* self, GAsyncResult* _res_);
	void (*show_infobar) (GitgExtApplication* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType type);
	GitgExtApplication* (*open_new) (GitgExtApplication* self, GgitRepository* repository, const gchar* hint);
	void (*open_repository) (GitgExtApplication* self, GFile* path);
	GitgRepository* (*get_repository) (GitgExtApplication* self);
	void (*set_repository) (GitgExtApplication* self, GitgRepository* value);
	GitgExtMessageBus* (*get_message_bus) (GitgExtApplication* self);
	GitgExtActivity* (*get_current_activity) (GitgExtApplication* self);
	GeeMap* (*get_environment) (GitgExtApplication* self);
	GitgExtNotifications* (*get_notifications) (GitgExtApplication* self);
	gboolean (*get_busy) (GitgExtApplication* self);
	void (*set_busy) (GitgExtApplication* self, gboolean value);
	GitgExtRemoteLookup* (*get_remote_lookup) (GitgExtApplication* self);
};

typedef enum  {
	GITG_EXT_EXTERNAL_CHANGE_HINT_NONE = 0,
	GITG_EXT_EXTERNAL_CHANGE_HINT_REFS = 1 << 0,
	GITG_EXT_EXTERNAL_CHANGE_HINT_INDEX = 1 << 1
} GitgExtExternalChangeHint;



GType gitg_ext_ui_element_get_type (void) G_GNUC_CONST;
GType gitg_ext_activity_get_type (void) G_GNUC_CONST;
GType gitg_ext_user_query_get_type (void) G_GNUC_CONST;
GType gitg_ext_message_bus_get_type (void) G_GNUC_CONST;
GType gitg_ext_notification_get_type (void) G_GNUC_CONST;
GType gitg_ext_notifications_get_type (void) G_GNUC_CONST;
GType gitg_ext_remote_lookup_get_type (void) G_GNUC_CONST;
GType gitg_ext_application_get_type (void) G_GNUC_CONST;
GgitSignature* gitg_ext_application_get_verified_committer (GitgExtApplication* self);
GitgExtActivity* gitg_ext_application_get_activity_by_id (GitgExtApplication* self, const gchar* id);
GitgExtActivity* gitg_ext_application_set_activity_by_id (GitgExtApplication* self, const gchar* id);
void gitg_ext_application_user_query (GitgExtApplication* self, GitgExtUserQuery* query);
void gitg_ext_application_user_query_async (GitgExtApplication* self, GitgExtUserQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
GtkResponseType gitg_ext_application_user_query_finish (GitgExtApplication* self, GAsyncResult* _res_);
void gitg_ext_application_show_infobar (GitgExtApplication* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType type);
GitgExtApplication* gitg_ext_application_open_new (GitgExtApplication* self, GgitRepository* repository, const gchar* hint);
void gitg_ext_application_open_repository (GitgExtApplication* self, GFile* path);
GitgRepository* gitg_ext_application_get_repository (GitgExtApplication* self);
void gitg_ext_application_set_repository (GitgExtApplication* self, GitgRepository* value);
GitgExtMessageBus* gitg_ext_application_get_message_bus (GitgExtApplication* self);
GitgExtActivity* gitg_ext_application_get_current_activity (GitgExtApplication* self);
GeeMap* gitg_ext_application_get_environment (GitgExtApplication* self);
GitgExtNotifications* gitg_ext_application_get_notifications (GitgExtApplication* self);
gboolean gitg_ext_application_get_busy (GitgExtApplication* self);
void gitg_ext_application_set_busy (GitgExtApplication* self, gboolean value);
GitgExtRemoteLookup* gitg_ext_application_get_remote_lookup (GitgExtApplication* self);
GType gitg_ext_external_change_hint_get_type (void) G_GNUC_CONST;


/**
 * Get the committer signature and verify that both its name and
 * e-mail are set. If not, the application will show an approppriate
 * error message and return null.
 */
GgitSignature* gitg_ext_application_get_verified_committer (GitgExtApplication* self) {
#line 61 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_verified_committer (self);
#line 210 "gitg-ext-application.c"
}


/**
 * Set the current application main activity.
 *
 * @param id the id of the activity {@link UIElement.id}.
 *
 * @return the created new main activity, or ``null`` if no activity with the
 *         given id exists.
 */
GitgExtActivity* gitg_ext_application_get_activity_by_id (GitgExtApplication* self, const gchar* id) {
#line 76 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 76 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_activity_by_id (self, id);
#line 227 "gitg-ext-application.c"
}


GitgExtActivity* gitg_ext_application_set_activity_by_id (GitgExtApplication* self, const gchar* id) {
#line 77 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 77 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->set_activity_by_id (self, id);
#line 236 "gitg-ext-application.c"
}


void gitg_ext_application_user_query (GitgExtApplication* self, GitgExtUserQuery* query) {
#line 79 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	GITG_EXT_APPLICATION_GET_INTERFACE (self)->user_query (self, query);
#line 245 "gitg-ext-application.c"
}


void gitg_ext_application_user_query_async (GitgExtApplication* self, GitgExtUserQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	GITG_EXT_APPLICATION_GET_INTERFACE (self)->user_query_async (self, query, _callback_, _user_data_);
#line 252 "gitg-ext-application.c"
}


GtkResponseType gitg_ext_application_user_query_finish (GitgExtApplication* self, GAsyncResult* _res_) {
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->user_query_finish (self, _res_);
#line 259 "gitg-ext-application.c"
}


void gitg_ext_application_show_infobar (GitgExtApplication* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType type) {
#line 82 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	GITG_EXT_APPLICATION_GET_INTERFACE (self)->show_infobar (self, primary_msg, secondary_msg, type);
#line 268 "gitg-ext-application.c"
}


GitgExtApplication* gitg_ext_application_open_new (GitgExtApplication* self, GgitRepository* repository, const gchar* hint) {
#line 88 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 88 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->open_new (self, repository, hint);
#line 277 "gitg-ext-application.c"
}


void gitg_ext_application_open_repository (GitgExtApplication* self, GFile* path) {
#line 92 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	GITG_EXT_APPLICATION_GET_INTERFACE (self)->open_repository (self, path);
#line 286 "gitg-ext-application.c"
}


GitgRepository* gitg_ext_application_get_repository (GitgExtApplication* self) {
#line 36 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_repository (self);
#line 295 "gitg-ext-application.c"
}


void gitg_ext_application_set_repository (GitgExtApplication* self, GitgRepository* value) {
#line 36 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	GITG_EXT_APPLICATION_GET_INTERFACE (self)->set_repository (self, value);
#line 304 "gitg-ext-application.c"
}


GitgExtMessageBus* gitg_ext_application_get_message_bus (GitgExtApplication* self) {
#line 44 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_message_bus (self);
#line 313 "gitg-ext-application.c"
}


GitgExtActivity* gitg_ext_application_get_current_activity (GitgExtApplication* self) {
#line 49 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_current_activity (self);
#line 322 "gitg-ext-application.c"
}


GeeMap* gitg_ext_application_get_environment (GitgExtApplication* self) {
#line 54 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_environment (self);
#line 331 "gitg-ext-application.c"
}


GitgExtNotifications* gitg_ext_application_get_notifications (GitgExtApplication* self) {
#line 66 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_notifications (self);
#line 340 "gitg-ext-application.c"
}


gboolean gitg_ext_application_get_busy (GitgExtApplication* self) {
#line 86 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 86 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_busy (self);
#line 349 "gitg-ext-application.c"
}


void gitg_ext_application_set_busy (GitgExtApplication* self, gboolean value) {
#line 86 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	GITG_EXT_APPLICATION_GET_INTERFACE (self)->set_busy (self, value);
#line 358 "gitg-ext-application.c"
}


GitgExtRemoteLookup* gitg_ext_application_get_remote_lookup (GitgExtApplication* self) {
#line 90 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	return GITG_EXT_APPLICATION_GET_INTERFACE (self)->get_remote_lookup (self);
#line 367 "gitg-ext-application.c"
}


static void gitg_ext_application_base_init (GitgExtApplicationIface * iface) {
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	static gboolean initialized = FALSE;
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
	if (!initialized) {
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		initialized = TRUE;
#line 378 "gitg-ext-application.c"
		/**
		 * The currently open repository.
		 */
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 384 "gitg-ext-application.c"
		/**
		 * An application wide message bus over which plugins can communicate.
		 */
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("message-bus", "message-bus", "message-bus", GITG_EXT_TYPE_MESSAGE_BUS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 390 "gitg-ext-application.c"
		/**
		 * The current application main activity.
		 */
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("current-activity", "current-activity", "current-activity", GITG_EXT_TYPE_ACTIVITY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 396 "gitg-ext-application.c"
		/**
		 * The environment with which the application was opened.
		 */
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("environment", "environment", "environment", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 402 "gitg-ext-application.c"
		/**
		 * Get the notifications manager for the application.
		 */
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("notifications", "notifications", "notifications", GITG_EXT_TYPE_NOTIFICATIONS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("busy", "busy", "busy", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("remote-lookup", "remote-lookup", "remote-lookup", GITG_EXT_TYPE_REMOTE_LOOKUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_signal_new ("repository_changed_externally", GITG_EXT_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__FLAGS, G_TYPE_NONE, 1, GITG_EXT_TYPE_EXTERNAL_CHANGE_HINT);
#line 31 "/home/jesse/dev/gitg/libgitg-ext/gitg-ext-application.vala"
		g_signal_new ("repository_commits_changed", GITG_EXT_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 416 "gitg-ext-application.c"
	}
}


/**
 * Application is an interface to access the main gitg application.
 *
 * The application interface is provided to plugins to access the main gitg
 * application instance. It contains properties to access the currently open
 * repository as well as methods to open or create repositories.
 *
 */
GType gitg_ext_application_get_type (void) {
	static volatile gsize gitg_ext_application_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_ext_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgExtApplicationIface), (GBaseInitFunc) gitg_ext_application_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gitg_ext_application_type_id;
		gitg_ext_application_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgExtApplication", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gitg_ext_application_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gitg_ext_application_type_id__volatile, gitg_ext_application_type_id);
	}
	return gitg_ext_application_type_id__volatile;
}


GType gitg_ext_external_change_hint_get_type (void) {
	static volatile gsize gitg_ext_external_change_hint_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_ext_external_change_hint_type_id__volatile)) {
		static const GFlagsValue values[] = {{GITG_EXT_EXTERNAL_CHANGE_HINT_NONE, "GITG_EXT_EXTERNAL_CHANGE_HINT_NONE", "none"}, {GITG_EXT_EXTERNAL_CHANGE_HINT_REFS, "GITG_EXT_EXTERNAL_CHANGE_HINT_REFS", "refs"}, {GITG_EXT_EXTERNAL_CHANGE_HINT_INDEX, "GITG_EXT_EXTERNAL_CHANGE_HINT_INDEX", "index"}, {0, NULL, NULL}};
		GType gitg_ext_external_change_hint_type_id;
		gitg_ext_external_change_hint_type_id = g_flags_register_static ("GitgExtExternalChangeHint", values);
		g_once_init_leave (&gitg_ext_external_change_hint_type_id__volatile, gitg_ext_external_change_hint_type_id);
	}
	return gitg_ext_external_change_hint_type_id__volatile;
}



