/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef _GNOME_SCANNER_H_
#define _GNOME_SCANNER_H_

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "gnome-scan-plugin.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCANNER             (gnome_scanner_get_type ())
#define GNOME_SCANNER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCANNER, GnomeScanner))
#define GNOME_SCANNER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCANNER, GnomeScannerClass))
#define GNOME_IS_SCANNER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCANNER))
#define GNOME_IS_SCANNER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCANNER))
#define GNOME_SCANNER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCANNER, GnomeScannerClass))


typedef enum
{
  GNOME_SCANNER_UNKNOWN,
  GNOME_SCANNER_READY,
  GNOME_SCANNER_BUSY
} GnomeScannerStatus;


typedef struct _GnomeScannerClass GnomeScannerClass;
typedef struct _GnomeScanner GnomeScanner;
typedef gpointer GnomeScanEvent;

struct _GnomeScannerClass
{
  GnomeScanPluginClass parent_class;

  /* API */
  gchar*	(* get_output_format)	(GnomeScanner *Scanner);

  /* Signals */
  void		(* event)		(GnomeScanner *scanner,
					 GnomeScanEvent *event,
					 gpointer data);
  void		(* settings_changed)	(GnomeScanner *scanner,
					 gpointer data);
  void		(* status_changed)	(GnomeScanner *scanner);
};

/**
 * GnomeScanner:
 *
 * A #GnomeScanner publish all instance specific plugins parameters
 * and handle the real acquisition work (e.g. throug SANE, TWAIN,
 * etc.)
 **/
struct _GnomeScanner
{
  /*< private >*/
  GnomeScanPlugin parent_instance;
	
  /*< public >*/
  GnomeScannerStatus status;
};

GType			gnome_scanner_get_type		(void) G_GNUC_CONST;
const gchar*		gnome_scanner_get_icon_name	(GnomeScanner *scanner);
void			gnome_scanner_settings_changed	(GnomeScanner *scanner);
void			gnome_scanner_set_status	(GnomeScanner *scanner,
							 GnomeScannerStatus status);
GnomeScannerStatus	gnome_scanner_get_status	(GnomeScanner *scanner);
const gchar*		gnome_scanner_get_status_string	(GnomeScanner *scanner);
const gchar*		gnome_scanner_get_output_format	(GnomeScanner *scanner);

G_END_DECLS

#endif /* _GNOME_SCANNER_H_ */
