// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gtk {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Window : Gtk.Bin {

		public Window (IntPtr raw) : base(raw) {}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_new(int type);

		public Window (Gtk.WindowType type) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Window)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				names.Add ("type");
				vals.Add (new GLib.Value (type));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gtk_window_new((int) type);
		}

		[GLib.Property ("type")]
		public Gtk.WindowType Type {
			get {
				GLib.Value val = GetProperty ("type");
				Gtk.WindowType ret = (Gtk.WindowType) (Enum) val;
				val.Dispose ();
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_title(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_title(IntPtr raw, IntPtr title);

		[GLib.Property ("title")]
		public string Title {
			get  {
				IntPtr raw_ret = gtk_window_get_title(Handle);
				string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
				return ret;
			}
			set  {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_window_set_title(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_role(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_role(IntPtr raw, IntPtr role);

		[GLib.Property ("role")]
		public string Role {
			get  {
				IntPtr raw_ret = gtk_window_get_role(Handle);
				string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
				return ret;
			}
			set  {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_window_set_role(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_startup_id(IntPtr raw, IntPtr startup_id);

		[GLib.Property ("startup-id")]
		public string StartupId {
			set  {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_window_set_startup_id(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_resizable(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_resizable(IntPtr raw, bool resizable);

		[GLib.Property ("resizable")]
		public bool Resizable {
			get  {
				bool raw_ret = gtk_window_get_resizable(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_resizable(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_modal(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_modal(IntPtr raw, bool modal);

		[GLib.Property ("modal")]
		public bool Modal {
			get  {
				bool raw_ret = gtk_window_get_modal(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_modal(Handle, value);
			}
		}

		[GLib.Property ("window-position")]
		public Gtk.WindowPosition WindowPosition {
			get {
				GLib.Value val = GetProperty ("window-position");
				Gtk.WindowPosition ret = (Gtk.WindowPosition) (Enum) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value((Enum) value);
				SetProperty("window-position", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("default-width")]
		public int DefaultWidth {
			get {
				GLib.Value val = GetProperty ("default-width");
				int ret = (int) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("default-width", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("default-height")]
		public int DefaultHeight {
			get {
				GLib.Value val = GetProperty ("default-height");
				int ret = (int) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("default-height", val);
				val.Dispose ();
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_destroy_with_parent(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_destroy_with_parent(IntPtr raw, bool setting);

		[GLib.Property ("destroy-with-parent")]
		public bool DestroyWithParent {
			get  {
				bool raw_ret = gtk_window_get_destroy_with_parent(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_destroy_with_parent(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_hide_titlebar_when_maximized(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_hide_titlebar_when_maximized(IntPtr raw, bool setting);

		[GLib.Property ("hide-titlebar-when-maximized")]
		public bool HideTitlebarWhenMaximized {
			get  {
				bool raw_ret = gtk_window_get_hide_titlebar_when_maximized(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_hide_titlebar_when_maximized(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_icon(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_icon(IntPtr raw, IntPtr icon);

		[GLib.Property ("icon")]
		public Gdk.Pixbuf Icon {
			get  {
				IntPtr raw_ret = gtk_window_get_icon(Handle);
				Gdk.Pixbuf ret = GLib.Object.GetObject(raw_ret) as Gdk.Pixbuf;
				return ret;
			}
			set  {
				gtk_window_set_icon(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_mnemonics_visible(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_mnemonics_visible(IntPtr raw, bool setting);

		[GLib.Property ("mnemonics-visible")]
		public bool MnemonicsVisible {
			get  {
				bool raw_ret = gtk_window_get_mnemonics_visible(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_mnemonics_visible(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_focus_visible(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_focus_visible(IntPtr raw, bool setting);

		[GLib.Property ("focus-visible")]
		public bool FocusVisible {
			get  {
				bool raw_ret = gtk_window_get_focus_visible(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_focus_visible(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_icon_name(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_icon_name(IntPtr raw, IntPtr name);

		[GLib.Property ("icon-name")]
		public string IconName {
			get  {
				IntPtr raw_ret = gtk_window_get_icon_name(Handle);
				string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
				return ret;
			}
			set  {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_window_set_icon_name(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_screen(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_screen(IntPtr raw, IntPtr screen);

		[GLib.Property ("screen")]
		public new Gdk.Screen Screen {
			get  {
				IntPtr raw_ret = gtk_window_get_screen(Handle);
				Gdk.Screen ret = GLib.Object.GetObject(raw_ret) as Gdk.Screen;
				return ret;
			}
			set  {
				gtk_window_set_screen(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[GLib.Property ("is-active")]
		public bool IsActive {
			get {
				GLib.Value val = GetProperty ("is-active");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
		}

		[GLib.Property ("has-toplevel-focus")]
		public bool HasToplevelFocus {
			get {
				GLib.Value val = GetProperty ("has-toplevel-focus");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_window_get_type_hint(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_type_hint(IntPtr raw, int hint);

		[GLib.Property ("type-hint")]
		public Gdk.WindowTypeHint TypeHint {
			get  {
				int raw_ret = gtk_window_get_type_hint(Handle);
				Gdk.WindowTypeHint ret = (Gdk.WindowTypeHint) raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_type_hint(Handle, (int) value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_skip_taskbar_hint(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_skip_taskbar_hint(IntPtr raw, bool setting);

		[GLib.Property ("skip-taskbar-hint")]
		public bool SkipTaskbarHint {
			get  {
				bool raw_ret = gtk_window_get_skip_taskbar_hint(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_skip_taskbar_hint(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_skip_pager_hint(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_skip_pager_hint(IntPtr raw, bool setting);

		[GLib.Property ("skip-pager-hint")]
		public bool SkipPagerHint {
			get  {
				bool raw_ret = gtk_window_get_skip_pager_hint(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_skip_pager_hint(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_urgency_hint(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_urgency_hint(IntPtr raw, bool setting);

		[GLib.Property ("urgency-hint")]
		public bool UrgencyHint {
			get  {
				bool raw_ret = gtk_window_get_urgency_hint(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_urgency_hint(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_accept_focus(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_accept_focus(IntPtr raw, bool setting);

		[GLib.Property ("accept-focus")]
		public bool AcceptFocus {
			get  {
				bool raw_ret = gtk_window_get_accept_focus(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_accept_focus(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_focus_on_map(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_focus_on_map(IntPtr raw, bool setting);

		[GLib.Property ("focus-on-map")]
		public bool FocusOnMap {
			get  {
				bool raw_ret = gtk_window_get_focus_on_map(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_focus_on_map(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_decorated(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_decorated(IntPtr raw, bool setting);

		[GLib.Property ("decorated")]
		public bool Decorated {
			get  {
				bool raw_ret = gtk_window_get_decorated(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_decorated(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_deletable(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_deletable(IntPtr raw, bool setting);

		[GLib.Property ("deletable")]
		public bool Deletable {
			get  {
				bool raw_ret = gtk_window_get_deletable(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_deletable(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_has_resize_grip(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_has_resize_grip(IntPtr raw, bool value);

		[Obsolete]
		[GLib.Property ("has-resize-grip")]
		public bool HasResizeGrip {
			get  {
				bool raw_ret = gtk_window_get_has_resize_grip(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_has_resize_grip(Handle, value);
			}
		}

		[GLib.Property ("resize-grip-visible")]
		public bool ResizeGripVisible {
			get {
				GLib.Value val = GetProperty ("resize-grip-visible");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_window_get_gravity(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_gravity(IntPtr raw, int gravity);

		[GLib.Property ("gravity")]
		public Gdk.Gravity Gravity {
			get  {
				int raw_ret = gtk_window_get_gravity(Handle);
				Gdk.Gravity ret = (Gdk.Gravity) raw_ret;
				return ret;
			}
			set  {
				gtk_window_set_gravity(Handle, (int) value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_transient_for(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_transient_for(IntPtr raw, IntPtr parent);

		[GLib.Property ("transient-for")]
		public Gtk.Window TransientFor {
			get  {
				IntPtr raw_ret = gtk_window_get_transient_for(Handle);
				Gtk.Window ret = GLib.Object.GetObject(raw_ret) as Gtk.Window;
				return ret;
			}
			set  {
				gtk_window_set_transient_for(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_attached_to(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_attached_to(IntPtr raw, IntPtr attach_widget);

		[GLib.Property ("attached-to")]
		public Gtk.Widget AttachedTo {
			get  {
				IntPtr raw_ret = gtk_window_get_attached_to(Handle);
				Gtk.Widget ret = GLib.Object.GetObject(raw_ret) as Gtk.Widget;
				return ret;
			}
			set  {
				gtk_window_set_attached_to(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[GLib.Property ("is-maximized")]
		public bool Maximized {
			get {
				GLib.Value val = GetProperty ("is-maximized");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_application(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_application(IntPtr raw, IntPtr application);

		[GLib.Property ("application")]
		public Gtk.Application Application {
			get  {
				IntPtr raw_ret = gtk_window_get_application(Handle);
				Gtk.Application ret = GLib.Object.GetObject(raw_ret) as Gtk.Application;
				return ret;
			}
			set  {
				gtk_window_set_application(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[GLib.Property ("decoration-button-layout")]
		public string DecorationButtonLayout {
			get {
				GLib.Value val = GetProperty ("decoration-button-layout");
				string ret = (string) val;
				val.Dispose ();
				return ret;
			}
		}

		[GLib.Property ("decoration-resize-handle")]
		public int DecorationResizeHandle {
			get {
				GLib.Value val = GetProperty ("decoration-resize-handle");
				int ret = (int) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("decoration-resize-handle", val);
				val.Dispose ();
			}
		}

		[GLib.Signal("set-focus")]
		public event Gtk.SetFocusHandler SetFocus {
			add {
				this.AddSignalHandler ("set-focus", value, typeof (Gtk.SetFocusArgs));
			}
			remove {
				this.RemoveSignalHandler ("set-focus", value);
			}
		}

		[GLib.Signal("activate-focus")]
		public event System.EventHandler FocusActivated {
			add {
				this.AddSignalHandler ("activate-focus", value);
			}
			remove {
				this.RemoveSignalHandler ("activate-focus", value);
			}
		}

		[GLib.Signal("activate-default")]
		public event System.EventHandler DefaultActivated {
			add {
				this.AddSignalHandler ("activate-default", value);
			}
			remove {
				this.RemoveSignalHandler ("activate-default", value);
			}
		}

		[GLib.Signal("keys-changed")]
		public event System.EventHandler KeysChanged {
			add {
				this.AddSignalHandler ("keys-changed", value);
			}
			remove {
				this.RemoveSignalHandler ("keys-changed", value);
			}
		}

		[GLib.Signal("enable-debugging")]
		public event Gtk.EnableDebuggingHandler EnableDebugging {
			add {
				this.AddSignalHandler ("enable-debugging", value, typeof (Gtk.EnableDebuggingArgs));
			}
			remove {
				this.RemoveSignalHandler ("enable-debugging", value);
			}
		}

		static SetFocusNativeDelegate SetFocus_cb_delegate;
		static SetFocusNativeDelegate SetFocusVMCallback {
			get {
				if (SetFocus_cb_delegate == null)
					SetFocus_cb_delegate = new SetFocusNativeDelegate (SetFocus_cb);
				return SetFocus_cb_delegate;
			}
		}

		static void OverrideSetFocus (GLib.GType gtype)
		{
			OverrideSetFocus (gtype, SetFocusVMCallback);
		}

		static void OverrideSetFocus (GLib.GType gtype, SetFocusNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("set_focus"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void SetFocusNativeDelegate (IntPtr inst, IntPtr focus);

		static void SetFocus_cb (IntPtr inst, IntPtr focus)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				__obj.OnSetFocus (GLib.Object.GetObject(focus) as Gtk.Widget);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.Window), ConnectionMethod="OverrideSetFocus")]
		protected virtual void OnSetFocus (Gtk.Widget focus)
		{
			InternalSetFocus (focus);
		}

		private void InternalSetFocus (Gtk.Widget focus)
		{
			SetFocusNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("set_focus"));
				unmanaged = (SetFocusNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(SetFocusNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, focus == null ? IntPtr.Zero : focus.Handle);
		}

		static FocusActivatedNativeDelegate FocusActivated_cb_delegate;
		static FocusActivatedNativeDelegate FocusActivatedVMCallback {
			get {
				if (FocusActivated_cb_delegate == null)
					FocusActivated_cb_delegate = new FocusActivatedNativeDelegate (FocusActivated_cb);
				return FocusActivated_cb_delegate;
			}
		}

		static void OverrideFocusActivated (GLib.GType gtype)
		{
			OverrideFocusActivated (gtype, FocusActivatedVMCallback);
		}

		static void OverrideFocusActivated (GLib.GType gtype, FocusActivatedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("activate_focus"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void FocusActivatedNativeDelegate (IntPtr inst);

		static void FocusActivated_cb (IntPtr inst)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				__obj.OnFocusActivated ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.Window), ConnectionMethod="OverrideFocusActivated")]
		protected virtual void OnFocusActivated ()
		{
			InternalFocusActivated ();
		}

		private void InternalFocusActivated ()
		{
			FocusActivatedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("activate_focus"));
				unmanaged = (FocusActivatedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(FocusActivatedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static DefaultActivatedNativeDelegate DefaultActivated_cb_delegate;
		static DefaultActivatedNativeDelegate DefaultActivatedVMCallback {
			get {
				if (DefaultActivated_cb_delegate == null)
					DefaultActivated_cb_delegate = new DefaultActivatedNativeDelegate (DefaultActivated_cb);
				return DefaultActivated_cb_delegate;
			}
		}

		static void OverrideDefaultActivated (GLib.GType gtype)
		{
			OverrideDefaultActivated (gtype, DefaultActivatedVMCallback);
		}

		static void OverrideDefaultActivated (GLib.GType gtype, DefaultActivatedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("activate_default"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DefaultActivatedNativeDelegate (IntPtr inst);

		static void DefaultActivated_cb (IntPtr inst)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				__obj.OnDefaultActivated ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.Window), ConnectionMethod="OverrideDefaultActivated")]
		protected virtual void OnDefaultActivated ()
		{
			InternalDefaultActivated ();
		}

		private void InternalDefaultActivated ()
		{
			DefaultActivatedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("activate_default"));
				unmanaged = (DefaultActivatedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DefaultActivatedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static KeysChangedNativeDelegate KeysChanged_cb_delegate;
		static KeysChangedNativeDelegate KeysChangedVMCallback {
			get {
				if (KeysChanged_cb_delegate == null)
					KeysChanged_cb_delegate = new KeysChangedNativeDelegate (KeysChanged_cb);
				return KeysChanged_cb_delegate;
			}
		}

		static void OverrideKeysChanged (GLib.GType gtype)
		{
			OverrideKeysChanged (gtype, KeysChangedVMCallback);
		}

		static void OverrideKeysChanged (GLib.GType gtype, KeysChangedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("keys_changed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void KeysChangedNativeDelegate (IntPtr inst);

		static void KeysChanged_cb (IntPtr inst)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				__obj.OnKeysChanged ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.Window), ConnectionMethod="OverrideKeysChanged")]
		protected virtual void OnKeysChanged ()
		{
			InternalKeysChanged ();
		}

		private void InternalKeysChanged ()
		{
			KeysChangedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("keys_changed"));
				unmanaged = (KeysChangedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(KeysChangedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static EnableDebuggingNativeDelegate EnableDebugging_cb_delegate;
		static EnableDebuggingNativeDelegate EnableDebuggingVMCallback {
			get {
				if (EnableDebugging_cb_delegate == null)
					EnableDebugging_cb_delegate = new EnableDebuggingNativeDelegate (EnableDebugging_cb);
				return EnableDebugging_cb_delegate;
			}
		}

		static void OverrideEnableDebugging (GLib.GType gtype)
		{
			OverrideEnableDebugging (gtype, EnableDebuggingVMCallback);
		}

		static void OverrideEnableDebugging (GLib.GType gtype, EnableDebuggingNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("enable_debugging"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool EnableDebuggingNativeDelegate (IntPtr inst, bool toggle);

		static bool EnableDebugging_cb (IntPtr inst, bool toggle)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				bool __result;
				__result = __obj.OnEnableDebugging (toggle);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.Window), ConnectionMethod="OverrideEnableDebugging")]
		protected virtual bool OnEnableDebugging (bool toggle)
		{
			return InternalEnableDebugging (toggle);
		}

		private bool InternalEnableDebugging (bool toggle)
		{
			EnableDebuggingNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("enable_debugging"));
				unmanaged = (EnableDebuggingNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(EnableDebuggingNativeDelegate));
			}
			if (unmanaged == null) return false;

			bool __result = unmanaged (this.Handle, toggle);
			return __result;
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("set_focus"
							, Gtk.Bin.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // set_focus
							, null
							, "activate_focus"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("activate_focus"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // activate_focus
							, "set_focus"
							, "activate_default"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("activate_default"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // activate_default
							, "activate_focus"
							, "keys_changed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("keys_changed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // keys_changed
							, "activate_default"
							, "enable_debugging"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("enable_debugging"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // enable_debugging
							, "keys_changed"
							, "_gtk_reserved1"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved1"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved1
							, "enable_debugging"
							, "_gtk_reserved2"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved2"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved2
							, "_gtk_reserved1"
							, "_gtk_reserved3"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved3"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved3
							, "_gtk_reserved2"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_activate_default(IntPtr raw);

		public bool ActivateDefault() {
			bool raw_ret = gtk_window_activate_default(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_activate_focus(IntPtr raw);

		public bool ActivateFocus() {
			bool raw_ret = gtk_window_activate_focus(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_activate_key(IntPtr raw, IntPtr evnt);

		public bool ActivateKey(Gdk.EventKey evnt) {
			bool raw_ret = gtk_window_activate_key(Handle, evnt == null ? IntPtr.Zero : evnt.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_add_accel_group(IntPtr raw, IntPtr accel_group);

		public void AddAccelGroup(Gtk.AccelGroup accel_group) {
			gtk_window_add_accel_group(Handle, accel_group == null ? IntPtr.Zero : accel_group.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_add_mnemonic(IntPtr raw, uint keyval, IntPtr target);

		public void AddMnemonic(uint keyval, Gtk.Widget target) {
			gtk_window_add_mnemonic(Handle, keyval, target == null ? IntPtr.Zero : target.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_begin_move_drag(IntPtr raw, int button, int root_x, int root_y, uint timestamp);

		public void BeginMoveDrag(int button, int root_x, int root_y, uint timestamp) {
			gtk_window_begin_move_drag(Handle, button, root_x, root_y, timestamp);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_begin_resize_drag(IntPtr raw, int edge, int button, int root_x, int root_y, uint timestamp);

		public void BeginResizeDrag(Gdk.WindowEdge edge, int button, int root_x, int root_y, uint timestamp) {
			gtk_window_begin_resize_drag(Handle, (int) edge, button, root_x, root_y, timestamp);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_close(IntPtr raw);

		public void Close() {
			gtk_window_close(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_deiconify(IntPtr raw);

		public void Deiconify() {
			gtk_window_deiconify(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_fullscreen(IntPtr raw);

		public void Fullscreen() {
			gtk_window_fullscreen(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_fullscreen_on_monitor(IntPtr raw, IntPtr screen, int monitor);

		public void FullscreenOnMonitor(Gdk.Screen screen, int monitor) {
			gtk_window_fullscreen_on_monitor(Handle, screen == null ? IntPtr.Zero : screen.Handle, monitor);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_default_icon_name();

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_default_icon_name(IntPtr name);

		public static string DefaultIconName { 
			get {
				IntPtr raw_ret = gtk_window_get_default_icon_name();
				string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
				return ret;
			}
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_window_set_default_icon_name(native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_get_default_size(IntPtr raw, out int width, out int height);

		public void GetDefaultSize(out int width, out int height) {
			gtk_window_get_default_size(Handle, out width, out height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_default_widget(IntPtr raw);

		public Gtk.Widget DefaultWidget { 
			get {
				IntPtr raw_ret = gtk_window_get_default_widget(Handle);
				Gtk.Widget ret = GLib.Object.GetObject(raw_ret) as Gtk.Widget;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_focus(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_focus(IntPtr raw, IntPtr focus);

		public Gtk.Widget Focus { 
			get {
				IntPtr raw_ret = gtk_window_get_focus(Handle);
				Gtk.Widget ret = GLib.Object.GetObject(raw_ret) as Gtk.Widget;
				return ret;
			}
			set {
				gtk_window_set_focus(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_group(IntPtr raw);

		public Gtk.WindowGroup Group { 
			get {
				IntPtr raw_ret = gtk_window_get_group(Handle);
				Gtk.WindowGroup ret = GLib.Object.GetObject(raw_ret) as Gtk.WindowGroup;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_window_get_mnemonic_modifier(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_mnemonic_modifier(IntPtr raw, int modifier);

		public Gdk.ModifierType MnemonicModifier { 
			get {
				int raw_ret = gtk_window_get_mnemonic_modifier(Handle);
				Gdk.ModifierType ret = (Gdk.ModifierType) raw_ret;
				return ret;
			}
			set {
				gtk_window_set_mnemonic_modifier(Handle, (int) value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_get_position(IntPtr raw, out int root_x, out int root_y);

		public void GetPosition(out int root_x, out int root_y) {
			gtk_window_get_position(Handle, out root_x, out root_y);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_get_resize_grip_area(IntPtr raw, IntPtr rect);

		[Obsolete]
		public bool GetResizeGripArea(Gdk.Rectangle rect) {
			IntPtr native_rect = GLib.Marshaller.StructureToPtrAlloc (rect);
			bool raw_ret = gtk_window_get_resize_grip_area(Handle, native_rect);
			bool ret = raw_ret;
			Marshal.FreeHGlobal (native_rect);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_get_size(IntPtr raw, out int width, out int height);

		public void GetSize(out int width, out int height) {
			gtk_window_get_size(Handle, out width, out height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_titlebar(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_titlebar(IntPtr raw, IntPtr titlebar);

		public Gtk.Widget Titlebar { 
			get {
				IntPtr raw_ret = gtk_window_get_titlebar(Handle);
				Gtk.Widget ret = GLib.Object.GetObject(raw_ret) as Gtk.Widget;
				return ret;
			}
			set {
				gtk_window_set_titlebar(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gtk_window_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_window_get_window_type(IntPtr raw);

		public Gtk.WindowType WindowType { 
			get {
				int raw_ret = gtk_window_get_window_type(Handle);
				Gtk.WindowType ret = (Gtk.WindowType) raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_has_group(IntPtr raw);

		public bool HasGroup { 
			get {
				bool raw_ret = gtk_window_has_group(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_iconify(IntPtr raw);

		public void Iconify() {
			gtk_window_iconify(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_is_maximized(IntPtr raw);

		public bool IsMaximized { 
			get {
				bool raw_ret = gtk_window_is_maximized(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_window_list_toplevels();

		public static Gtk.Window[] ListToplevels() {
			IntPtr raw_ret = gtk_window_list_toplevels();
			Gtk.Window[] ret = (Gtk.Window[]) GLib.Marshaller.ListPtrToArray (raw_ret, typeof(GLib.List), true, false, typeof(Gtk.Window));
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_maximize(IntPtr raw);

		public void Maximize() {
			gtk_window_maximize(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_mnemonic_activate(IntPtr raw, uint keyval, int modifier);

		public bool MnemonicActivate(uint keyval, Gdk.ModifierType modifier) {
			bool raw_ret = gtk_window_mnemonic_activate(Handle, keyval, (int) modifier);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_move(IntPtr raw, int x, int y);

		public void Move(int x, int y) {
			gtk_window_move(Handle, x, y);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_parse_geometry(IntPtr raw, IntPtr geometry);

		[Obsolete]
		public bool ParseGeometry(string geometry) {
			IntPtr native_geometry = GLib.Marshaller.StringToPtrGStrdup (geometry);
			bool raw_ret = gtk_window_parse_geometry(Handle, native_geometry);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_geometry);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_present(IntPtr raw);

		public void Present() {
			gtk_window_present(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_present_with_time(IntPtr raw, uint timestamp);

		public void PresentWithTime(uint timestamp) {
			gtk_window_present_with_time(Handle, timestamp);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_propagate_key_event(IntPtr raw, IntPtr evnt);

		public bool PropagateKeyEvent(Gdk.EventKey evnt) {
			bool raw_ret = gtk_window_propagate_key_event(Handle, evnt == null ? IntPtr.Zero : evnt.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_remove_accel_group(IntPtr raw, IntPtr accel_group);

		public void RemoveAccelGroup(Gtk.AccelGroup accel_group) {
			gtk_window_remove_accel_group(Handle, accel_group == null ? IntPtr.Zero : accel_group.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_remove_mnemonic(IntPtr raw, uint keyval, IntPtr target);

		public void RemoveMnemonic(uint keyval, Gtk.Widget target) {
			gtk_window_remove_mnemonic(Handle, keyval, target == null ? IntPtr.Zero : target.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_reshow_with_initial_size(IntPtr raw);

		[Obsolete]
		public void ReshowWithInitialSize() {
			gtk_window_reshow_with_initial_size(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_resize(IntPtr raw, int width, int height);

		public void Resize(int width, int height) {
			gtk_window_resize(Handle, width, height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_window_resize_grip_is_visible(IntPtr raw);

		[Obsolete]
		public bool ResizeGripIsVisible() {
			bool raw_ret = gtk_window_resize_grip_is_visible(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_resize_to_geometry(IntPtr raw, int width, int height);

		[Obsolete]
		public void ResizeToGeometry(int width, int height) {
			gtk_window_resize_to_geometry(Handle, width, height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_auto_startup_notification(bool setting);

		public static bool AutoStartupNotification { 
			set {
				gtk_window_set_auto_startup_notification(value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_default(IntPtr raw, IntPtr default_widget);

		public Gtk.Widget Default { 
			set {
				gtk_window_set_default(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_default_geometry(IntPtr raw, int width, int height);

		[Obsolete]
		public void SetDefaultGeometry(int width, int height) {
			gtk_window_set_default_geometry(Handle, width, height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_default_icon(IntPtr icon);

		public static Gdk.Pixbuf DefaultIcon { 
			set {
				gtk_window_set_default_icon(value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool gtk_window_set_default_icon_from_file(IntPtr filename, out IntPtr err);

		public static unsafe bool SetDefaultIconFromFile(string filename) {
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gtk_window_set_default_icon_from_file(native_filename, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_default_size(IntPtr raw, int width, int height);

		public void SetDefaultSize(int width, int height) {
			gtk_window_set_default_size(Handle, width, height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_geometry_hints(IntPtr raw, IntPtr geometry_widget, IntPtr geometry, int geom_mask);

		public void SetGeometryHints(Gtk.Widget geometry_widget, Gdk.Geometry geometry, Gdk.WindowHints geom_mask) {
			IntPtr native_geometry = GLib.Marshaller.StructureToPtrAlloc (geometry);
			gtk_window_set_geometry_hints(Handle, geometry_widget == null ? IntPtr.Zero : geometry_widget.Handle, native_geometry, (int) geom_mask);
			Marshal.FreeHGlobal (native_geometry);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_has_user_ref_count(IntPtr raw, bool setting);

		public bool HasUserRefCount { 
			set {
				gtk_window_set_has_user_ref_count(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool gtk_window_set_icon_from_file(IntPtr raw, IntPtr filename, out IntPtr err);

		public unsafe bool SetIconFromFile(string filename) {
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gtk_window_set_icon_from_file(Handle, native_filename, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_interactive_debugging(bool enable);

		public static bool InteractiveDebugging { 
			set {
				gtk_window_set_interactive_debugging(value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_keep_above(IntPtr raw, bool setting);

		public bool KeepAbove { 
			set {
				gtk_window_set_keep_above(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_keep_below(IntPtr raw, bool setting);

		public bool KeepBelow { 
			set {
				gtk_window_set_keep_below(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_position(IntPtr raw, int position);

		public void SetPosition(Gtk.WindowPosition position) {
			gtk_window_set_position(Handle, (int) position);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_set_wmclass(IntPtr raw, IntPtr wmclass_name, IntPtr wmclass_class);

		[Obsolete]
		public void SetWmclass(string wmclass_name, string wmclass_class) {
			IntPtr native_wmclass_name = GLib.Marshaller.StringToPtrGStrdup (wmclass_name);
			IntPtr native_wmclass_class = GLib.Marshaller.StringToPtrGStrdup (wmclass_class);
			gtk_window_set_wmclass(Handle, native_wmclass_name, native_wmclass_class);
			GLib.Marshaller.Free (native_wmclass_name);
			GLib.Marshaller.Free (native_wmclass_class);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_stick(IntPtr raw);

		public void Stick() {
			gtk_window_stick(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_unfullscreen(IntPtr raw);

		public void Unfullscreen() {
			gtk_window_unfullscreen(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_unmaximize(IntPtr raw);

		public void Unmaximize() {
			gtk_window_unmaximize(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_window_unstick(IntPtr raw);

		public void Unstick() {
			gtk_window_unstick(Handle);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("priv"
							, Gtk.Bin.abi_info.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, null
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
