// Code generated by smithy-go-codegen DO NOT EDIT.

package rekognition

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rekognition/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Associates one or more faces with an existing UserID. Takes an array of FaceIds
// . Each FaceId that are present in the FaceIds list is associated with the
// provided UserID. The maximum number of total FaceIds per UserID is 100. The
// UserMatchThreshold parameter specifies the minimum user match confidence
// required for the face to be associated with a UserID that has at least one
// FaceID already associated. This ensures that the FaceIds are associated with
// the right UserID. The value ranges from 0-100 and default value is 75. If
// successful, an array of AssociatedFace objects containing the associated FaceIds
// is returned. If a given face is already associated with the given UserID , it
// will be ignored and will not be returned in the response. If a given face is
// already associated to a different UserID , isn't found in the collection,
// doesn’t meet the UserMatchThreshold , or there are already 100 faces associated
// with the UserID , it will be returned as part of an array of
// UnsuccessfulFaceAssociations. The UserStatus reflects the status of an
// operation which updates a UserID representation with a list of given faces. The
// UserStatus can be:
//   - ACTIVE - All associations or disassociations of FaceID(s) for a UserID are
//     complete.
//   - CREATED - A UserID has been created, but has no FaceID(s) associated with
//     it.
//   - UPDATING - A UserID is being updated and there are current associations or
//     disassociations of FaceID(s) taking place.
func (c *Client) AssociateFaces(ctx context.Context, params *AssociateFacesInput, optFns ...func(*Options)) (*AssociateFacesOutput, error) {
	if params == nil {
		params = &AssociateFacesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateFaces", params, optFns, c.addOperationAssociateFacesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateFacesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateFacesInput struct {

	// The ID of an existing collection containing the UserID.
	//
	// This member is required.
	CollectionId *string

	// An array of FaceIDs to associate with the UserID.
	//
	// This member is required.
	FaceIds []string

	// The ID for the existing UserID.
	//
	// This member is required.
	UserId *string

	// Idempotent token used to identify the request to AssociateFaces . If you use the
	// same token with multiple AssociateFaces requests, the same response is
	// returned. Use ClientRequestToken to prevent the same request from being
	// processed more than once.
	ClientRequestToken *string

	// An optional value specifying the minimum confidence in the UserID match to
	// return. The default value is 75.
	UserMatchThreshold *float32

	noSmithyDocumentSerde
}

type AssociateFacesOutput struct {

	// An array of AssociatedFace objects containing FaceIDs that are successfully
	// associated with the UserID is returned. Returned if the AssociateFaces action is
	// successful.
	AssociatedFaces []types.AssociatedFace

	// An array of UnsuccessfulAssociation objects containing FaceIDs that are not
	// successfully associated along with the reasons. Returned if the AssociateFaces
	// action is successful.
	UnsuccessfulFaceAssociations []types.UnsuccessfulFaceAssociation

	// The status of an update made to a UserID. Reflects if the UserID has been
	// updated for every requested change.
	UserStatus types.UserStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateFacesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpAssociateFaces{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpAssociateFaces{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssociateFaces"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opAssociateFacesMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpAssociateFacesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateFaces(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpAssociateFaces struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpAssociateFaces) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpAssociateFaces) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*AssociateFacesInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *AssociateFacesInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opAssociateFacesMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpAssociateFaces{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opAssociateFaces(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssociateFaces",
	}
}
