# Petition to open source Flash and Shockwave spec

[![Join the chat at https://gitter.im/open-source-flash/Lobby](https://badges.gitter.im/open-source-flash/Lobby.svg)](https://gitter.im/open-source-flash/Lobby?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) [![GitHub Stats](https://img.shields.io/badge/github-stats-ff5500.svg)](http://githubstats.com/pakastin/open-source-flash)

**Edit:** The first letter [is being written](https://github.com/pakastin/open-source-flash/blob/master/the-letter-to-adobe.md). If you want to contribute to it, you can either make pull requests or join the [Gitter chat](https://gitter.im/open-source-flash/Lobby?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) to help us organize it 

[Adobe is going to stop distributing and updating Flash player and the Shockwave player](https://blogs.adobe.com/conversations/2017/07/adobe-flash-update.html). That's ok.

However Flash along with its sister project Shockwave is an important piece of Internet history and killing Flash and Shockwave means future generations can't access the past. Games, experiments and websites would be forgotten.

Open sourcing Flash and the Shockwave spec would be a good solution to keep Flash and Shockwave projects alive safely for archive reasons. Don't know how, but that's the beauty of open source: you never know what will come up after you go open source! There might be a way to convert swf/fla/drc/dir to HTML5/canvas/webgl/webassembly, or some might write a standalone player for it. Another possibility would be to have a separate browser. __We're not saying Flash and Shockwave player should be preserved as is.__

We understand that there can be licensed components you might not be able to release. Simply leave them out with a note explaining what was removed. We will either bypass them, or replace them with open source alternatives.

__Star this repository to sign the petition.__ Pull requests are also welcome. Add cool Flash and Shockwave links here and reasons to open source Flash and Shockwave.

This petition will be delivered to Adobe.

♥ _[Contributors](https://github.com/pakastin/open-source-flash/graphs/contributors) and [signers](https://github.com/pakastin/open-source-flash/stargazers)_

## Discussion
- [Petition discussion on HN](https://news.ycombinator.com/item?id=14859740)
- [Should Adobe Open Source Flash](https://gitgalaxy.com/should-adobe-open-source-flash/)
- [Flash 2020 and the Future - Newgrounds](http://www.newgrounds.com/bbs/topic/1424896)
- https://twitter.com/bit101/status/889911479104933889
- https://twitter.com/fwa/status/889957817330917377
- https://twitter.com/TomFulp/status/889883079137005570
- https://twitter.com/tha_rami/status/890051049259663361
- [Gizmodo article](http://gizmodo.com/adobe-flash-fans-want-a-chance-to-fix-its-one-million-b-1797284544)
- [Petition discussion on Linux Subreddit](https://www.reddit.com/r/linux/comments/6pt1ve/adobe_flash_fans_want_a_chance_to_fix_its_one/)
- [Infoworld article](http://www.infoworld.com/article/3211348/web-development/petition-asks-adobe-to-open-source-flash.amp.html)
- [SD Times article](http://sdtimes.com/developer-creates-petition-open-source-flash-specification/)
- [MakeUseOf article](http://www.makeuseof.com/tag/developers-petition-adobe-open-source-flash/)
- [The Register article](https://www.theregister.co.uk/2017/07/31/petition_to_open_source_adobe_flash/)
- [The Inquirer article](https://www.theinquirer.net/inquirer/news/3014805/petition-to-keep-adobe-flash-alive-as-open-source-makes-us-want-to-cry)
- http://webwereld.nl/software/100140-maak-flash-open-source
- http://mobil.derstandard.at/2000061874513/Open-Source-Petition-Fans-wollen-Flash-weiterleben-lassen
- https://www.heise.de/amp/meldung/Petition-Flash-als-Open-Source-Rentner-3786837.html
- http://www.chip.pl/2017/07/adobe-flash-jako-open-source/
- http://www.oschina.net/news/87212/petition-to-open-source-flash-spec
- http://4pda.ru/2017/07/27/345658/
- https://www.xataka.com/aplicaciones/deberia-convertirse-adobe-flash-en-open-source-tres-razones-a-favor-y-tres-en-contra
- http://news.softpedia.com/news/adobe-should-open-source-flash-player-petition-requires-517227.shtml
- https://github.com/mozilla/shumway/issues/2438
- https://twitter.com/pakastin/status/892042787771879424
- https://techworld.idg.se/2.2524/1.686541/han-ska-radda-flash
- http://www.tivi.fi/Kaikki_uutiset/flash-playerin-lahdekoodia-vaaditaan-avoimeksi-6665757
- https://www.mikrobitti.fi/2017/07/adobea-vaaditaan-avaamaan-flash-playerin-lahdekoodi/
- https://thenextweb.com/dd/2017/07/28/instead-of-killing-flash-we-should-save-it-for-posterity/#.tnw_KXtAGuyp
- https://www.dunyahalleri.com/adobeye-flash-baskisi/
- https://opensource.srad.jp/story/17/07/30/0441200/
- https://nakedsecurity.sophos.com/2017/07/31/should-adobe-make-flash-open-source-poll/

## References
- [FWA - Flash... Don't Dance on your Dad's grave](https://medium.com/@fwa/flash-don-t-dance-on-your-dad-s-grave-f99287f175d)
- [Wikipedia: Web Archiving](https://en.wikipedia.org/wiki/Web_archiving)
- [Adobe open source](https://www.adobe.io/open/open-source.html)
- [Another petition](https://www.change.org/p/adobe-systems-make-flash-player-open-sourced)
- [Yet another petition](https://www.change.org/p/adobe-systems-make-flash-open-source-before-it-s-too-late)
- [History of Flash](http://mashable.com/2012/11/19/history-of-flash/)

## Flash and Shockwave as an art medium
Flash and Shockwave was a platform for creative expression in an exciting new medium with global reach at a time when sound and moving images were barely breaking into the internet. Many artists took the media and shaped it to their own style. These digital pieces were both mesmerizing and disturbing. 

We do lots to save and restore old manuscripts so, why not consider any interactive artworks that were developed on this platform and can't be ported truthfully to just a video format.

Feel free to add other interactive art projects, websites, games and experiments that you think deserve to be saved:
- [We Choose the Moon](http://wechoosethemoon.org/)
- [25 Most Impressive Flash Sites](http://www.beautifullife.info/web-design/25-most-impressive-flash-sites/)
- [Flyguy](https://en.wikipedia.org/wiki/Fly_Guy_(video_game))
- [Hoogerbrugge](http://nails.hoogerbrugge.com)
- [sofake](http://sofake.com)
- [WEFAIL](http://wefail.com)
- [dontclick.it](http://www.dontclick.it/)
- [Levitated](http://levitated.net/daily/index.html)
- [Flixel](http://flixel.org/)
- [Video of eye4u.com flash intro](https://www.youtube.com/watch?v=3aT4wt0fmGU)
- [Video of 2Advanced - Expansions](https://www.youtube.com/watch?v=SVm6d87ERYg)
- [Video of Who's We Studios](https://www.youtube.com/watch?v=Y6jIInoBrHQ)
- [Video of Xiao Xiao](https://www.youtube.com/watch?v=eplAQ3fEr8M)
- [Metal Gear Awesome](http://metalgear.wikia.com/wiki/Metal_Gear_Awesome)
- [Homestar Runner](http://homestarrunner.com)
- [Tales for the L33T: Romeo and Juliet, by Chris Coutts.](http://www.albinoblacksheep.com/flash/romjul)
- [Homestuck BETA](http://www.mspaintadventures.com/?s=5)
- [I Wish I Were the Moon](http://www.kongregate.com/games/danielben/i-wish-i-were-the-moon)
- [Cursor\*10](http://www.flashgamesplayer.com/online/Cursor-10.html)
- [Clock2D.com](https://www.clock2d.com/) - Alarm clock radio with themes, fullscreen, countdown, and sharing features.
- [Madness Combat Series](http://www.krinkels.net/index_anim1.html)
- [DICEWARS](http://www.gamedesign.jp/flash/dice/dice.html)
- [Chat Noir](http://www.gamedesign.jp/flash/chatnoir/chatnoir.html) (trap the cat)
- [The GROW games by EYEZMAZE](http://www.eyezmaze.com/) ([Wikipedia](https://en.wikipedia.org/wiki/GROW_(series)))
- [Club Penguin Rewritten](https://clubpenguinrewritten.pw/)
- [Full Fist: DeepFriedFunny.com](http://deepfriedfunny.com/)
- [Realm of the Mad God](http://realmofthemadgod.com/)
- [Amanita Design Games](http://amanita-design.net/games.html)
- [Beautifl - Flash Gallery of wonderfl](http://beautifl.net/)
- [Flashmixer](http://www.flashmixer.de)
- [Defend the wicket](https://www.miniclip.com/games/cricket-defend-the-wicket/en/)
- [Biomediaproject](http://biomediaproject.com) - Archive of all bionicle promotional material like Mata Nui Online Game and 
also has huge [archive of old lego flash and shockwave games](http://biomediaproject.com/bmp/files/LEGO/gms/).
- [Memento Mori]( http://mementomori-1.net/ ) - Remember that you have to die
- [Poke the bunny](http://www.platinumgrit.com/pokethebunny.htm)
- [Ishkur's Guide to Electronic Music](http://techno.org/electronic-music-guide/) ([Wikipedia](https://en.wikipedia.org/wiki/Ishkur's_Guide_to_Electronic_Music))
- [QWOP](http://www.foddy.net/Athletics.html) ([Wikipedia](https://en.wikipedia.org/wiki/QWOP))
- [Drugs and the brain](http://jellinek.nl/brain/)
- [Frog in a blender](http://joecartoon.com/games/play/65/Frog_in_a_Blender)

## Flash and Shockwave games
Some of these games will probably disappear if Flash gets killed:
- [Super Smash Flash 2](https://www.mcleodgaming.com/games/ssf2)
- [SuperFighters](https://mythologicinteractive.com/Superfighters)
- [Alien Hominid](http://www.newgrounds.com/portal/view/59593)
- [Abobo's Big Adventure](http://abobosbigadventure.com/)

## Current state of Flash and Shockwave preservation
There's already some projects to preserve Flash. The problem is that they're not complete, because of the closed source of Flash spec:
- [AJC Flash –> WebAssembly](https://github.com/JasonHuang3D/AJC-Flash-WebAssembly-Examples)
- [Gnash](https://www.gnu.org/software/gnash/)
- [Lightspark](https://lightspark.github.io/)
- [Shumway](https://mozilla.github.io/shumway/)
- [SWF specs](https://www.adobe.com/devnet/swf.html)
- https://en.wikipedia.org/wiki/Adobe_Flash#Open_source
- [Earthquake Project](https://github.com/Earthquake-Project) - Documenting formats and creating decompiler for Director/Shockwave files

## Available analysis
Projects that don't preserve Flash as such but provide knowledge about the file format:
- [Blitzableiter](https://github.com/rtezli/Blitzableiter)
    - [Blitzableiter presentation](http://www.recurity-labs.com/content/pub/FX_Blitzableiter_BHUSA2010.pdf)
- [FFDec](https://sourceforge.net/projects/ffdec/)
- [Schockabsorber](https://github.com/eriksoe/Schockabsorber) Contains interesting information about files made in adobe director for shockwave
- [phrack](http://phrack.org/issues/69/8.html) Mostly security information about shockwave files, but contains valuable low level information about the file format.

## Active developers communities
These communities thrive with the [Adobe AIR runtime](http://www.adobe.com/devnet/air/air-sdk-download.html). The Adobe AIR runtime enables developers to package the same code into native applications and games for Windows and Mac OS desktops as well as iOS and Android devices, reaching over a billion desktop systems and mobile app stores for over 500 million devices.
- [Starling](https://gamua.com/starling/) - The Cross Platform Game Engine used by thousands to publish GPU rendered games, it also uses the same famous Flash api for display list.
- [Feathers](https://feathersui.com/) - Feathers puts it all together in one package — blazing fast GPU powered graphics, an impressive number of skinning options, and an extensible component architecture to create a smooth and responsive experience.
- [RABCDA] (https://github.com/CyberShadow/RABCDAsm) - Robust ABC (ActionScript Bytecode) [Dis-]Assembler
- [Royal/asjs](https://github.com/apache/royale-asjs) - Flex SDK is now Royal-asjs maintained by Apache Team 

## Next generation community efforts for ActionScript
Here is a display of technologies, that are using `ActionScript` without being tied to Adobe
- [Apache FlexJS](http://flex.apache.org/) - The main application framework / layout engine configured with MXML. Originally created by Adobe, Flex is now
open source and developed by the folks at Apache.
- [FlexJS description](https://cwiki.apache.org/confluence/display/FLEX/FlexJS) - for more details
- [OpenFL](http://www.openfl.org/) - OpenFL uses the familiar Flash API, but goes everywhere that Flash Player cannot. publishing native, Flash and HTML5 applications using one seamless toolset.
- [NextGen ActionScript](https://nextgenactionscript.com/) - Use ActionScript in a web browser... without a plug-in. A website collecting tutorials and open source utilities for FlexJS and more.
- [blog post](https://joshblog.net/2015/introducing-nextgen-actionscript/) regarding the introduction of this website.
- [spriteflexjs](https://github.com/matrix3d/spriteflexjs/)  You can convert flash API into HTML5 API and convert stage3d API into webgl API.
  
OpenFL can compile code in Haxe into SWF, which means someone knows how to hack these binaries spec.
Theoretically, we can also use [Starling](https://gamua.com/starling/) to render into HTML canvas and WebGL instead of Adobe's Stage 3D and use the [Apache FlexJS](http://flex.apache.org/) compiler to transpile it into JavaScript. This induces the following flow - migrating Flash based source code into the web.

- [avmplus] (https://github.com/adobe/avmplus) AVM2 source code (flash player AVM1(?)AVM2 source code)
