/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pccbase;

import com.dsi.ant.plugins.antplus.pcc.defines.DeviceState;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestAccessResult;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PccReleaseHandle<T extends AntPluginPcc> {
    volatile boolean isClosed = false;
    protected boolean resultSent = false;
    private T receivedDevice = null;
    protected final Object stateLock = new Object();
    private final AntPluginPcc.IPluginAccessResultReceiver<T> mResultReceiver;
    private final AntPluginPcc.IDeviceStateChangeReceiver mStateReceiver;
    protected final AntPluginPcc.IPluginAccessResultReceiver<T> resultSink = new AntPluginPcc.IPluginAccessResultReceiver<T>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResultReceived(T result, RequestAccessResult resultCode, DeviceState initialDeviceState) {
            Object object = PccReleaseHandle.this.stateLock;
            synchronized (object) {
                if (PccReleaseHandle.this.isClosed) {
                    if (PccReleaseHandle.this.receivedDevice != null) {
                        PccReleaseHandle.this.receivedDevice.handleConnectionBroke("received device after death");
                    }
                } else {
                    PccReleaseHandle.this.receivedDevice = result;
                    PccReleaseHandle.this.resultSent = true;
                    PccReleaseHandle.this.mResultReceiver.onResultReceived(result, resultCode, initialDeviceState);
                }
            }
        }
    };
    protected final AntPluginPcc.IDeviceStateChangeReceiver stateSink = new AntPluginPcc.IDeviceStateChangeReceiver(){
        private boolean deadStateSent = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDeviceStateChange(DeviceState newDeviceState) {
            Object object = PccReleaseHandle.this.stateLock;
            synchronized (object) {
                if (PccReleaseHandle.this.isActive() && !this.deadStateSent) {
                    if (DeviceState.DEAD.equals((Object)newDeviceState)) {
                        this.deadStateSent = true;
                    }
                    PccReleaseHandle.this.mStateReceiver.onDeviceStateChange(newDeviceState);
                }
            }
        }
    };

    protected PccReleaseHandle(AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        this.mResultReceiver = resultReceiver;
        this.mStateReceiver = stateReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isClosed) {
                if (this.receivedDevice != null) {
                    ((AntPluginPcc)this.receivedDevice).releaseToken();
                    this.stateSink.onDeviceStateChange(DeviceState.DEAD);
                }
                if (!this.resultSent) {
                    this.resultSent = true;
                    this.mResultReceiver.onResultReceived(null, RequestAccessResult.USER_CANCELLED, DeviceState.DEAD);
                }
                this.isClosed = true;
                this.requestCancelled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.resultSent && !this.isClosed;
        }
    }

    protected abstract void requestCancelled();
}

