/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A data source formula.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataSourceFormula extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The data execution status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataExecutionStatus dataExecutionStatus;

  /**
   * The ID of the data source the formula is associated with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSourceId;

  /**
   * Output only. The data execution status.
   * @return value or {@code null} for none
   */
  public DataExecutionStatus getDataExecutionStatus() {
    return dataExecutionStatus;
  }

  /**
   * Output only. The data execution status.
   * @param dataExecutionStatus dataExecutionStatus or {@code null} for none
   */
  public DataSourceFormula setDataExecutionStatus(DataExecutionStatus dataExecutionStatus) {
    this.dataExecutionStatus = dataExecutionStatus;
    return this;
  }

  /**
   * The ID of the data source the formula is associated with.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * The ID of the data source the formula is associated with.
   * @param dataSourceId dataSourceId or {@code null} for none
   */
  public DataSourceFormula setDataSourceId(java.lang.String dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

  @Override
  public DataSourceFormula set(String fieldName, Object value) {
    return (DataSourceFormula) super.set(fieldName, value);
  }

  @Override
  public DataSourceFormula clone() {
    return (DataSourceFormula) super.clone();
  }

}
