
############################################################################
#    Copyright (C) 2005 by Fabio Marzocca                             #
#    thesaltydog@gmail.com                                                 #
#                            
#                                                  #
#    This program is free software; you can redistribute it and or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
#
# 
# 
############################################################################



#==============================================================================
#=== The class Application
#==============================================================================

package gtkorphan_app;

use gtkorphan_Config;
use Carp;
use File::Spec;
use strict ;
use Locale::gettext;
use POSIX qw(setlocale);
use POSIX qw(getuid);
use Encode qw(decode);
use Gtk2 -init ;
use Gtk2::GladeXML;
use constant NULL => 0;
use gtkorphan_ops;
use gtkorphan_cbk;

our ($gladexml,$AUTOLOAD);

	setlocale(LC_MESSAGES, "");
	textdomain(gtkorphan_Config->PACKAGE);    
	bind_textdomain_codeset(gtkorphan_Config->PACKAGE,"UTF-8");
	bindtextdomain(gtkorphan_Config->PACKAGE,
							gtkorphan_Config->DATADIR . '/locale');
							
#####################################################
sub _ {return decode("utf-8",dgettext( gtkorphan_Config->PACKAGE,$_[0]));}
######################################################

my %go_fields=(
	version => gtkorphan_Config->VERSION,
	# the main window
	window=>undef,
	# the about dialog window
	about=>undef,
	#the details window
    details_dlg=>undef,
	#the last chance window
    last_chance_dlg=>undef,
	#deborphan fullpath
	dorph=>undef,
	#icon path
	icon_path=>undef,
	#the statusbar
	statusbar => undef,
	#the notebook
	notebook => undef,
	#the treeviews
	list_orphaned =>undef,
	tv_regular => undef,
	model_regular => undef,
);


sub new{
	my $that =shift;
	my $classe=ref($that) ||$that;
	my $self={
		_permitted=>\%go_fields,%go_fields,};
	bless($self,$classe);

	gtkorphan_cbk::init ($self);
	gtkorphan_ops::init($self);

		
	#is user root?
	if (getuid() != 0) {
		gtkorphan_ops::message(_("You must run this program as the root user."),
							'GTK_MESSAGE_ERROR');
		exit 1;		
	}
	
	####################################################
	####### User Interface
	####################################################
	my $gladepath=File::Spec->catfile(gtkorphan_Config->PKGDATADIR,
	                                   'gtkorphan.glade');
	croak("Unable to find '$gladepath': $!") unless -f $gladepath;
		
	$gladexml = Gtk2::GladeXML->new($gladepath );
	$gladexml->signal_autoconnect_from_package('gtkorphan_cbk' );

	#### Initialization of the Application attributes
	$self->icon_path (File::Spec->catfile(
		(gtkorphan_Config->DATADIR, 'pixmaps'),
		"gtkorphan.png"));
	$self->about($gladexml->get_widget('about1' ));
	$self->details_dlg($gladexml->get_widget('details_dlg' ));
	$self->last_chance_dlg($gladexml->get_widget('last_chance_dlg' ));
	$self->window($gladexml->get_widget('window1' ));
	$self->notebook($gladexml->get_widget('notebook1' ));
	$self->statusbar($gladexml->get_widget('statusbar1' ));
	$self->window->set_icon(Gtk2::Gdk::Pixbuf->new_from_file($self->icon_path));
	$self->dorph(find_program_in_path("deborphan"));
	
	#is deborphan installed?
	if (!$self->dorph) {
		gtkorphan_ops::message("<span size='large' weight='bold'>".
			_("Cannot find deborphan!").
			"</span>\n".
			_("GtkOrphan needs deborphan to run."), 'GTK_MESSAGE_ERROR');
		exit;
	}
	#orphaned treeview SimpleList
	$self->list_orphaned(gtkorphan_ops::create_orphaned_treeview(
								$gladexml->get_widget('treeview1' )));
	($gladexml->get_widget('guess'))->set_active(0);
	gtkorphan_ops::find_orphaned("");
	gtkorphan_ops::alfa_sort('GTK_SORT_ASCENDING',0);
	
	#regular treeview 
	$self->tv_regular($gladexml->get_widget('treeview2' ));
	$self->model_regular(gtkorphan_ops::create_regular_treeview(
						$self->tv_regular));
	gtkorphan_ops::populate_regular("");
	gtkorphan_ops::alfa_sort('GTK_SORT_ASCENDING',1);
			
	return $self;

}

sub AUTOLOAD {
	my $self=shift;
	my $type=ref($self) or croak "$self is not an object";
	my $name=$AUTOLOAD;
	$name=~  s/.*:://;
	unless (exists $self->{_permitted}->{$name}) {
	croak "Cannot load  $name fields in class $type" ;}
	if (@_) {
		return $self->{$name}=shift;
	}else {
		return $self->{$name};
		}
}

sub DESTROY {}

	
sub find_program_in_path{
	my $file=shift;
    my $found_prog_and_path=NULL;
	my ($dir,$path);
     
       
       for $dir (split(/:/,$ENV{'PATH'})) {
          if(-x ($path="$dir/$file") ){
             $path=~s/\/\//\//g;  ## removing /bin//gzip like entry
             $found_prog_and_path = $path ;
			 last; 
          }
       }
    
     return($found_prog_and_path);
}



1 ;
