rs = (0xee,0xa6,0xa7,0x25,0x1c,0x1e,0x72,0x91
,0x6d,0x11,0xc2,0xcb,0x21,0x4d,0x3c,0x25
,0x25,0x39,0x12,0x1d,0x8e,0x23,0x4e,0x65
,0x2d,0x65,0x1f,0xa4,0xc8,0xcf,0xf8,0x80)

msg = (0x8e,0x99,0x3b,0x9f,0x48,0x68,0x12,0x73
        ,0xc2,0x96,0x50,0xba,0x32,0xfc,0x76,0xce
        ,0x48,0x33,0x2e,0xa7,0x16,0x4d,0x96,0xa4
        ,0x47,0x6f,0xb8,0xc5,0x31,0xa1,0x18,0x6a
        ,0xc0,0xdf,0xc1,0x7c,0x98,0xdc,0xe8,0x7b
        ,0x4d,0xa7,0xf0,0x11,0xec,0x48,0xc9,0x72
        ,0x71,0xd2,0xc2,0x0f,0x9b,0x92,0x8f,0xe2
        ,0x27,0x0d,0x6f,0xb8,0x63,0xd5,0x17,0x38
        ,0xb4,0x8e,0xee,0xe3,0x14,0xa7,0xcc,0x8a
        ,0xb9,0x32,0x16,0x45,0x48,0xe5,0x26,0xae
        ,0x90,0x22,0x43,0x68,0x51,0x7a,0xcf,0xea
        ,0xbd,0x6b,0xb3,0x73,0x2b,0xc0,0xe9,0xda
        ,0x99,0x83,0x2b,0x61,0xca,0x01,0xb6,0xde
        ,0x56,0x24,0x4a,0x9e,0x88,0xd5,0xf9,0xb3
        ,0x79,0x73,0xf6,0x22,0xa4,0x3d,0x14,0xa6
        ,0x59,0x9b,0x1f,0x65,0x4c,0xb4,0x5a,0x74
        ,0xe3,0x55,0xa5)

tag = (0xf3,0xff,0xc7,0x70,0x3f,0x94,0x00,0xe5
,0x2a,0x7d,0xfb,0x4b,0x3d,0x33,0x05,0xd9)

print len(msg)

WORD = 0xffffffff

def add(x, y):
    u = 0
    r = [0] * 17
    for i in range(17):
        u += (x[i] + y[i]) & WORD
        r[i] = u & 0xff
        u >>= 8
    return r

def reduce(x):
    r = list(x)
    u = 0

    for i in range(16):
        u += r[i]
        r[i] = u & 0xff
        u >>= 8
    u += r[16]
    r[16] = u & 3
    u = 5 * (u >> 2)

    for i in range(16):
        u += r[i]
        r[i] = u & 0xff
        u >>= 8
    u += r[16]
    r[16] = u

    return r

def modmul(x, y):
    r = [0] * 17
    for i in range(17):
        u = 0
        for j in range(i + 1):
            u += (x[j] * y[i - j]) & WORD
        for j in range(i + 1, 17):
            u += (320 * x[j] * y[i + 17 - j]) & WORD
        r[i] = u
    return reduce(r)

def dump(why, v):
    print '%s = %s' % (why, ' '.join('%08x' % x for x in v))

def freeze(x):
    # -2^130 - 5 in twos complement
    negative_130_5 = (5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252)

    r = add(x, negative_130_5)
    dump('minusp', r)
    negative = bool(x[16] >> 7)
    if negative:
        return r
    else:
        return x

def poly1305(msg, rs):
    r, s = list(rs[:16]), list(rs[16:])

    r[3] &= 15
    r[4] &= 252
    r[7] &= 15
    r[8] &= 252
    r[11] &= 15
    r[12] &= 252
    r[15] &= 15
    r.append(0)

    h = [0] * 17
    dump('r-init', r)
    dump('h-init', h)

    block = 0

    for offs in range(0, len(msg), 16):
        print '--- block %d ---' % block
        block += 1
        c = list(msg[offs:offs+16])
        c.append(1)
        while len(c) != 17: c.append(0)
        dump('c', c)

        h = add(h, c)
        dump('after-add', h)
        h = modmul(h, r)
        dump('after-mul', h)

    dump('end-block', h)
    h = freeze(h)
    dump('h', h)
    s.append(0)
    h = add(h, s)
    dump('final', h)
    return h[:16]

r = poly1305(msg, rs)
print repr([hex(x) for x in r])
