/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo;

import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.dom.INodeVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SpaceNormalizer implements INodeVisitor {

	public void accept(Node node) {

		if (node instanceof Text) {

			Text textNode = (Text) node;
			textNode.setData(XmlServices.normalizeText(textNode));
		}

		if (node instanceof Element) {

			Element elem = (Element) node;

			NamedNodeMap namedNodeMap = elem.getAttributes();

			for (int i = 0; i < namedNodeMap.getLength(); i++) {

				Node attrNode = namedNodeMap.item(i);

				if (attrNode instanceof Attr) {

					Attr attr = (Attr) attrNode;
					attr.setValue(XmlServices.normalizeText(attr.getValue()));
				}
			}
		}
	}

	@Override
	public void openTag(Node node) throws Exception {
		//

	}

	@Override
	public void closeTag(Node node) throws Exception {
		//
	}
}
