///////
   //    SchedulerEntry.h
   //    Scheduler Entry Class declaration
   //
   //    Class for interfacing the Schedule table of the DB
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: SchedulerEntry.h,v 1.23 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 14.09.1999
///////

#ifndef _SCHEDULERENTRY_H
#define _SCHEDULERENTRY_H

#ifdef HAVE_STD
#include <iostream>
#include <string>
#ifdef HAVE_NAMESPACES
using namespace std;
#endif
#else
#include <iostream.h>
#include <string.h>
#endif /* HAVE_STD */

#include <Object.h>
#include "_Server.h"

class SchedulerEntry : public Object
{

   // Write the object to the output
   friend ostream& operator <<( ostream&, const SchedulerEntry& );
   

   public:
   
      // Construction / Destruction
      SchedulerEntry();
      SchedulerEntry(const std::string &u);
      virtual ~SchedulerEntry();

      enum Schedule_Status
      {
         Url_Empty,           // Not yet assigned
         Url_ToBeRetrieved,
         Url_Retrieved,
         Url_CheckIfExists,
         Url_Checked,
         Url_BadQueryString,
         Url_BadExtension,
         Url_MaxHopCount,
         Url_FileProtocol,
         Url_EMail,
         Url_Javascript,
         Url_NotValidService,
         Url_Malformed,
         Url_MaxUrlsCount
      };


      // According to our limits, is this URL internal or external (or unknown)
      enum Schedule_Domain
      {
         Url_Unknown,      // Unknown domain for the URL
         Url_Internal,	   // Internal URL
         Url_External	   // External URL
      };

///////
   //    Public Interface
///////

      void Reset();
      void SetScheduleUrl(const std::string &u) { ScheduleUrl = u; }
      void SetIDSchedule (unsigned int id) { IDSchedule = id; }
      void SetIDServer (unsigned int id) { IDServer = id; }
      void SetIDReferer (unsigned int id) { IDReferer = id; }
      void SetHopCount (unsigned int hc) { HopCount = hc; }
      void SetServer (_Server *s);
      void SetMalformed (bool b) { is_malformed = b; }
      void SetStatus (Schedule_Status s) { Status = s; }
      void SetDomain (Schedule_Domain d) { Domain = d; }


      void SetNewUrl(const std::string &u);
                                       // New Url definition
                                       // Reset the schedule and assign the
                                       // status to "ToBeRetrieved" by default

      void RetrieveStatus (std::string &) const;  // Insert into a string the value
                                       // for the Status (converts a Schedule_Status
                                       // value into a std::string).
                                       
      void RetrieveDomain (std::string &) const;  // Insert into a string the value
                                       // for the Domain (converts a Schedule_Domain
                                       // value into a std::string).
                                       
      int SetStatus (const std::string &Status);  // Set the Schedule_Status value
                                             // depending on the Status string value
      
      int SetDomain (const std::string &Domain);  // Set the Schedule_Domain value
                                             // depending on the Domain string value
      
      const std::string &GetScheduleUrl() const { return ScheduleUrl; }
      unsigned int GetIDSchedule() const { return IDSchedule; }
      unsigned int GetIDServer() const { return IDServer; }
      Schedule_Status GetStatus() const { return Status; }
      Schedule_Domain GetDomain() const { return Domain; }
      const _Server *GetServer() const { return server; }
      unsigned int GetIDReferer() const { return IDReferer; }
      unsigned int GetHopCount() const { return HopCount; }
      bool IsMalformed() const { return is_malformed; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}

///////
   //    Protected attributes
///////

   protected:

      unsigned int IDSchedule;
      unsigned int IDServer;
      _Server *server;           // For accessing server information
      
      std::string ScheduleUrl;
      
      Schedule_Status Status;
      Schedule_Domain Domain;

      // ID of referring URL
      unsigned int IDReferer;
      
      // Hop count (number of clicks from the first accessed page)
      unsigned int HopCount;

      // Boolean flag for malformed url
      bool is_malformed;

///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level

};

#endif
