package CParse::Op::Shift;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;
use CParse::Op::Shift::Left;
use CParse::Op::Shift::Right;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $left = shift;
    my $right = shift;
    my $op = shift;

    return CParse::Op::Shift::Left->new($left, $right) if $op eq '<<';
    return CParse::Op::Shift::Right->new($left, $right) if $op eq '>>';
    die;
  }

1;
