#!/bin/sh

export LANG=C

projectname() {
  local project
  local proj
  project=$(basename ${1%.jucer})
  proj=$(basename ${project} | tr A-Z a-z)
  echo $project iem-plugin-${proj#iem-plugin-}
}

do_manpage() {
cat <<EOF
.TH IEM-PLUGIN-SUITE 1 "$(date -u -d @$(dpkg-parsechangelog -S Timestamp) +"%b, %d %Y")"
.SH NAME
iem-plugin-suite \- Standalone application of the IEMPluginSuite
.SH SYNOPSIS
EOF
 for p in "$@"; do
  projectname $p | while read project proj; do
    if [ -e "${project}/Builds/LinuxMakefile/build/${project}" ]; then
       cat <<EOF
.B ${proj}
.LP
EOF
    fi
  done
 done
 cat <<EOF
\&...
.SH DESCRIPTION
The \fBIEM Plug-in Suite\fP is an audio plugin suite created at the Institute of
Electronic Music and Acoustics (Graz, Austria).
It features Higher-Order Ambisonic plug-ins (up to 7th order), among them a
number of state of the art encoders, directional compressors, directivity
shapers, delay and reverb effects and analysis tools.

The standalone versions do not have any special cmdline arguments.
.PP
.SH AUTHOR
This manual page was written by IOhannes m zmölnig <umlaeute@debian.org>
for the Debian project (but may be used by others).
EOF
}

do_install() {
  projectname $1 | while read project proj; do
    cp ${project}/Builds/LinuxMakefile/build/${project}.so _vst/
    cp ${project}/Builds/LinuxMakefile/build/${project}    _bin/${proj} &&
    cp _man/iem-plugin-suite.1 _man/${proj}.1
  done
}

do_manpage $@ > _man/iem-plugin-suite.1

for x in "$@"; do
 do_install "$x"
done

rm -f _man/iem-plugin-suite.1
