/*
 LyricsScreenlet Copyright (C) 2009 by Marcel Dancak <dancakm@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <limits.h>
#include <Python.h>
#include <pygtk-2.0/pygobject.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

static PyObject*
set_icon_geometry  (PyObject *self, PyObject *args)
{
PyGObject *pyGtkWindow;
GdkWindow *window;
int        x;
int        y;
int        width;
int        height;

if (!PyArg_ParseTuple(args, "Oiiii", &pyGtkWindow, &x, &y, &width, &height)) {
		printf("wrong arguments\n");
		return Py_None;
	}
	window = GTK_WIDGET(pyGtkWindow->obj)->window;
	//printf("%d [%d, %d, %d, %d]\n", GDK_WINDOW_XID (window), x, y, width, height);
	
	gulong data[4] = {x, y, width, height};
	
	XChangeProperty (GDK_WINDOW_XDISPLAY(window), GDK_WINDOW_XID (window),
		gdk_x11_get_xatom_by_name_for_display (gdk_drawable_get_display (window),
		"_NET_WM_ICON_GEOMETRY"), XA_CARDINAL, 32, PropModeReplace, (guchar *)&data, 4);
		 
	return Py_None;
}

static PyMethodDef minimize_methods[] = {

    {"set_icon_geometry",  set_icon_geometry, METH_VARARGS, "descriptions later"},
    {NULL, NULL, 0, NULL}  /* Sentinel */
};

PyMODINIT_FUNC init_minimize(void)
{
    PyObject *m;

    m = Py_InitModule("_minimize", minimize_methods);
    if (m == NULL)
        return;
}
