// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.icons;

import com.intellij.openapi.util.IconLoader;

import javax.swing.*;

/**
 * NOTE THIS FILE IS AUTO-GENERATED
 * DO NOT EDIT IT BY HAND, run "Generate icon classes" configuration instead
 */
public class AllIcons {

  public final static class Actions {
    public static final Icon AddMulticaret = IconLoader.getIcon("/actions/AddMulticaret.svg"); // 16x16
    public static final Icon Annotate = IconLoader.getIcon("/actions/annotate.svg"); // 16x16
    public static final Icon Back = IconLoader.getIcon("/actions/back.svg"); // 16x16
    public static final Icon Cancel = IconLoader.getIcon("/actions/cancel.svg"); // 16x16
    public static final Icon ChangeView = IconLoader.getIcon("/actions/changeView.svg"); // 16x16
    public static final Icon Checked = IconLoader.getIcon("/actions/checked.png"); // 12x12
    public static final Icon Checked_selected = IconLoader.getIcon("/actions/checked_selected.png"); // 12x12
    public static final Icon Checked_small = IconLoader.getIcon("/actions/checked_small.png"); // 11x11
    public static final Icon Checked_small_selected = IconLoader.getIcon("/actions/checked_small_selected.png"); // 11x11
    public static final Icon CheckMulticaret = IconLoader.getIcon("/actions/CheckMulticaret.svg"); // 16x16
    public static final Icon CheckOut = IconLoader.getIcon("/actions/checkOut.svg"); // 16x16
    public static final Icon Clean = IconLoader.getIcon("/actions/clean.png"); // 16x16
    public static final Icon CleanLight = IconLoader.getIcon("/actions/cleanLight.png"); // 16x16
    public static final Icon Clear = IconLoader.getIcon("/actions/clear.png"); // 16x16
    public static final Icon Close = IconLoader.getIcon("/actions/close.svg"); // 16x16
    public static final Icon CloseHovered = IconLoader.getIcon("/actions/closeHovered.svg"); // 16x16
    public static final Icon CloseNew = IconLoader.getIcon("/actions/closeNew.png"); // 16x16
    public static final Icon CloseNewHovered = IconLoader.getIcon("/actions/closeNewHovered.png"); // 16x16
    public static final Icon Collapseall = IconLoader.getIcon("/actions/collapseall.svg"); // 16x16
    public static final Icon Commit = IconLoader.getIcon("/actions/commit.svg"); // 16x16
    public static final Icon Compile = IconLoader.getIcon("/actions/compile.svg"); // 16x16
    public static final Icon Copy = IconLoader.getIcon("/actions/copy.svg"); // 16x16
    public static final Icon Cross = IconLoader.getIcon("/actions/cross.png"); // 12x12
    public static final Icon DiagramDiff = IconLoader.getIcon("/actions/diagramDiff.svg"); // 16x16
    public static final Icon Diff = IconLoader.getIcon("/actions/diff.svg"); // 16x16
    public static final Icon DiffWithClipboard = IconLoader.getIcon("/actions/diffWithClipboard.svg"); // 16x16
    public static final Icon Download = IconLoader.getIcon("/actions/download.svg"); // 16x16
    public static final Icon Dump = IconLoader.getIcon("/actions/dump.svg"); // 16x16
    public static final Icon Edit = IconLoader.getIcon("/actions/edit.svg"); // 16x16
    public static final Icon EditSource = IconLoader.getIcon("/actions/editSource.svg"); // 16x16
    public static final Icon Execute = IconLoader.getIcon("/actions/execute.svg"); // 16x16
    public static final Icon Exit = IconLoader.getIcon("/actions/exit.svg"); // 16x16
    public static final Icon Expandall = IconLoader.getIcon("/actions/expandall.svg"); // 16x16
    public static final Icon Find = IconLoader.getIcon("/actions/find.svg"); // 16x16
    public static final Icon ForceRefresh = IconLoader.getIcon("/actions/forceRefresh.svg"); // 16x16
    public static final Icon Forward = IconLoader.getIcon("/actions/forward.svg"); // 16x16
    public static final Icon GC = IconLoader.getIcon("/actions/gc.svg"); // 16x16
    public static final Icon GroupBy = IconLoader.getIcon("/actions/groupBy.svg"); // 16x16
    public static final Icon GroupByClass = IconLoader.getIcon("/actions/GroupByClass.svg"); // 16x16
    public static final Icon GroupByFile = IconLoader.getIcon("/actions/GroupByFile.svg"); // 16x16
    public static final Icon GroupByMethod = IconLoader.getIcon("/actions/groupByMethod.svg"); // 16x16
    public static final Icon GroupByModule = IconLoader.getIcon("/actions/GroupByModule.svg"); // 16x16
    public static final Icon GroupByModuleGroup = IconLoader.getIcon("/actions/GroupByModuleGroup.svg"); // 16x16
    public static final Icon GroupByPackage = IconLoader.getIcon("/actions/GroupByPackage.svg"); // 16x16
    public static final Icon GroupByPrefix = IconLoader.getIcon("/actions/GroupByPrefix.svg"); // 16x16
    public static final Icon GroupByTestProduction = IconLoader.getIcon("/actions/groupByTestProduction.svg"); // 16x16
    public static final Icon Help = IconLoader.getIcon("/actions/help.svg"); // 16x16
    public static final Icon Highlighting = IconLoader.getIcon("/actions/highlighting.svg"); // 16x16
    public static final Icon Install = IconLoader.getIcon("/actions/install.svg"); // 16x16
    public static final Icon IntentionBulb = IconLoader.getIcon("/actions/intentionBulb.svg"); // 16x16
    public static final Icon Lightning = IconLoader.getIcon("/actions/lightning.svg"); // 16x16
    public static final Icon ListChanges = IconLoader.getIcon("/actions/listChanges.svg"); // 16x16
    public static final Icon ListFiles = IconLoader.getIcon("/actions/listFiles.svg"); // 16x16
    public static final Icon Menu_cut = IconLoader.getIcon("/actions/menu-cut.svg"); // 16x16
    public static final Icon Menu_open = IconLoader.getIcon("/actions/menu-open.svg"); // 16x16
    public static final Icon Menu_paste = IconLoader.getIcon("/actions/menu-paste.svg"); // 16x16
    public static final Icon Menu_saveall = IconLoader.getIcon("/actions/menu-saveall.svg"); // 16x16
    public static final Icon Module = IconLoader.getIcon("/actions/module.png"); // 16x16
    public static final Icon More = IconLoader.getIcon("/actions/more.svg"); // 16x16
    public static final Icon Move_to_button = IconLoader.getIcon("/actions/move-to-button.svg"); // 12x12
    public static final Icon MoveDown = IconLoader.getIcon("/actions/moveDown.svg"); // 16x16
    public static final Icon MoveTo2 = IconLoader.getIcon("/actions/MoveTo2.svg"); // 16x16
    public static final Icon MoveToAnotherChangelist = IconLoader.getIcon("/actions/moveToAnotherChangelist.png"); // 16x16
    public static final Icon MoveUp = IconLoader.getIcon("/actions/moveUp.svg"); // 16x16
    public static final Icon New = IconLoader.getIcon("/actions/new.svg"); // 16x16
    public static final Icon NewFolder = IconLoader.getIcon("/actions/newFolder.svg"); // 16x16
    public static final Icon NextOccurence = IconLoader.getIcon("/actions/nextOccurence.svg"); // 16x16
    public static final Icon OfflineMode = IconLoader.getIcon("/actions/offlineMode.svg"); // 16x16
    public static final Icon Pause = IconLoader.getIcon("/actions/pause.svg"); // 16x16
    public static final Icon PopFrame = IconLoader.getIcon("/actions/popFrame.svg"); // 16x16
    public static final Icon Preview = IconLoader.getIcon("/actions/preview.svg"); // 16x16
    public static final Icon PreviewDetails = IconLoader.getIcon("/actions/previewDetails.svg"); // 16x16
    public static final Icon PreviewDetailsVertically = IconLoader.getIcon("/actions/previewDetailsVertically.svg"); // 16x16
    public static final Icon PreviousOccurence = IconLoader.getIcon("/actions/previousOccurence.svg"); // 16x16
    public static final Icon Profile = IconLoader.getIcon("/actions/profile.svg"); // 16x16
    public static final Icon ProfileCPU = IconLoader.getIcon("/actions/profileCPU.svg"); // 16x16
    public static final Icon ProfileMemory = IconLoader.getIcon("/actions/profileMemory.svg"); // 16x16
    public static final Icon Properties = IconLoader.getIcon("/actions/properties.svg"); // 16x16
    public static final Icon QuickfixBulb = IconLoader.getIcon("/actions/quickfixBulb.svg"); // 16x16
    public static final Icon QuickfixOffBulb = IconLoader.getIcon("/actions/quickfixOffBulb.svg"); // 16x16
    public static final Icon RealIntentionBulb = IconLoader.getIcon("/actions/realIntentionBulb.svg"); // 16x16
    public static final Icon Redo = IconLoader.getIcon("/actions/redo.svg"); // 16x16
    public static final Icon RefactoringBulb = IconLoader.getIcon("/actions/refactoringBulb.svg"); // 16x16
    public static final Icon Refresh = IconLoader.getIcon("/actions/refresh.svg"); // 16x16
    public static final Icon RemoveMulticaret = IconLoader.getIcon("/actions/RemoveMulticaret.svg"); // 16x16
    public static final Icon Replace = IconLoader.getIcon("/actions/replace.svg"); // 16x16
    public static final Icon Rerun = IconLoader.getIcon("/actions/rerun.svg"); // 16x16
    public static final Icon Restart = IconLoader.getIcon("/actions/restart.svg"); // 16x16
    public static final Icon RestartDebugger = IconLoader.getIcon("/actions/restartDebugger.svg"); // 16x16
    public static final Icon Resume = IconLoader.getIcon("/actions/resume.svg"); // 16x16
    public static final Icon Rollback = IconLoader.getIcon("/actions/rollback.svg"); // 16x16
    public static final Icon Run_anything = IconLoader.getIcon("/actions/run_anything.svg"); // 16x16
    public static final Icon RunToCursor = IconLoader.getIcon("/actions/runToCursor.svg"); // 16x16
    public static final Icon Scratch = IconLoader.getIcon("/actions/scratch.svg"); // 16x16
    public static final Icon Search = IconLoader.getIcon("/actions/search.png"); // 16x16
    public static final Icon SearchNewLine = IconLoader.getIcon("/actions/searchNewLine.svg"); // 16x16
    public static final Icon SearchNewLineHover = IconLoader.getIcon("/actions/searchNewLineHover.svg"); // 16x16
    public static final Icon Selectall = IconLoader.getIcon("/actions/selectall.svg"); // 16x16
    public static final Icon SetDefault = IconLoader.getIcon("/actions/setDefault.svg"); // 16x16
    public static final Icon Share = IconLoader.getIcon("/actions/share.png"); // 14x14
    public static final Icon ShortcutFilter = IconLoader.getIcon("/actions/shortcutFilter.svg"); // 16x16
    public static final Icon Show = IconLoader.getIcon("/actions/show.svg"); // 16x16
    public static final Icon ShowAsTree = IconLoader.getIcon("/actions/showAsTree.svg"); // 16x16
    public static final Icon ShowHiddens = IconLoader.getIcon("/actions/showHiddens.svg"); // 16x16
    public static final Icon ShowImportStatements = IconLoader.getIcon("/actions/showImportStatements.svg"); // 16x16
    public static final Icon ShowReadAccess = IconLoader.getIcon("/actions/showReadAccess.svg"); // 16x16
    public static final Icon ShowWriteAccess = IconLoader.getIcon("/actions/showWriteAccess.svg"); // 16x16
    public static final Icon SplitHorizontally = IconLoader.getIcon("/actions/splitHorizontally.svg"); // 16x16
    public static final Icon SplitVertically = IconLoader.getIcon("/actions/splitVertically.svg"); // 16x16
    public static final Icon StartDebugger = IconLoader.getIcon("/actions/startDebugger.svg"); // 16x16
    public static final Icon StartMemoryProfile = IconLoader.getIcon("/actions/startMemoryProfile.svg"); // 16x16
    public static final Icon StepOut = IconLoader.getIcon("/actions/stepOut.svg"); // 16x16
    public static final Icon Stub = IconLoader.getIcon("/actions/stub.svg"); // 16x16
    public static final Icon Suspend = IconLoader.getIcon("/actions/suspend.svg"); // 16x16
    public static final Icon SwapPanels = IconLoader.getIcon("/actions/swapPanels.svg"); // 16x16
    public static final Icon SynchronizeScrolling = IconLoader.getIcon("/actions/synchronizeScrolling.svg"); // 16x16
    public static final Icon SyncPanels = IconLoader.getIcon("/actions/syncPanels.svg"); // 16x16
    public static final Icon ToggleSoftWrap = IconLoader.getIcon("/actions/toggleSoftWrap.svg"); // 16x16
    public static final Icon TraceInto = IconLoader.getIcon("/actions/traceInto.svg"); // 16x16
    public static final Icon TraceOver = IconLoader.getIcon("/actions/traceOver.svg"); // 16x16
    public static final Icon Undo = IconLoader.getIcon("/actions/undo.svg"); // 16x16
    public static final Icon Uninstall = IconLoader.getIcon("/actions/uninstall.svg"); // 16x16
    public static final Icon Unselectall = IconLoader.getIcon("/actions/unselectall.svg"); // 16x16
    public static final Icon Unshare = IconLoader.getIcon("/actions/unshare.png"); // 14x14
    public static final Icon Upload = IconLoader.getIcon("/actions/upload.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AddFacesSupport = IconLoader.getIcon("/actions/addFacesSupport.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AllLeft = IconLoader.getIcon("/actions/allLeft.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AllRight = IconLoader.getIcon("/actions/allRight.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.PreviousOccurence */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Browser_externalJavaDoc = AllIcons.Actions.PreviousOccurence;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Checked */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CheckedBlack = AllIcons.Actions.Checked;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Checked */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CheckedGrey = AllIcons.Actions.Checked;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.IntentionBulb */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CreateFromUsage = AllIcons.Actions.IntentionBulb;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CreatePatch = IconLoader.getIcon("/actions/createPatch.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Cancel */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Delete = AllIcons.Actions.Cancel;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Diff */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon DiffPreview = AllIcons.Actions.Diff;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Diff */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon DiffWithCurrent = AllIcons.Actions.Diff;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Down = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 - use J2EEIcons.ErDiagram */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ErDiagram = IconLoader.getIcon("/actions/erDiagram.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Remove */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Exclude = AllIcons.General.Remove;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.Export */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Export = AllIcons.ToolbarDecorator.Export;

    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon FileStatus = IconLoader.getIcon("/actions/fileStatus.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Filter */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Filter_small = AllIcons.General.Filter;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Find */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon FindPlain = AllIcons.Actions.Find;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon FindWhite = IconLoader.getIcon("/actions/findWhite.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Download */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Get = AllIcons.Actions.Download;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowLeft */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Left = AllIcons.General.ArrowLeft;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Find */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Menu_find = AllIcons.Actions.Find;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Help */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Menu_help = AllIcons.Actions.Help;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Replace */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Menu_replace = AllIcons.Actions.Replace;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Minimize = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Move_to_button */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Move_to_button_top = AllIcons.Actions.Move_to_button;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.MoveTo2 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon MoveToStandardPlace = AllIcons.Actions.MoveTo2;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Multicaret = IconLoader.getIcon("/actions/multicaret.svg");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Forward */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Nextfile = AllIcons.Actions.Forward;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Back */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Prevfile = AllIcons.Actions.Back;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon QuickList = IconLoader.getIcon("/actions/quickList.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon RealIntentionOffBulb = IconLoader.getIcon("/actions/realIntentionOffBulb.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Rollback */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Reset_to_default = AllIcons.Actions.Rollback;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Rollback */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Reset = AllIcons.Actions.Rollback;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Uninstall */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Reset_to_empty = AllIcons.Actions.Uninstall;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowRight */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Right = AllIcons.General.ArrowRight;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Preview */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ShowChangesOnly = AllIcons.Actions.Preview;

    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ShowViewer = IconLoader.getIcon("/actions/showViewer.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.MoveUp */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SortAsc = AllIcons.Actions.MoveUp;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.MoveDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SortDesc = AllIcons.Actions.MoveDown;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.SetDefault */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Submit1 = AllIcons.Actions.SetDefault;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Refresh */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SynchronizeFS = AllIcons.Actions.Refresh;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowUp */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon UP = AllIcons.General.ArrowUp;

  }

  public final static class CodeStyle {
    public static final Icon AddNewSectionRule = IconLoader.getIcon("/codeStyle/AddNewSectionRule.svg"); // 16x16

    public final static class Mac {

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.CodeStyle.AddNewSectionRule */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddNewSectionRule = AllIcons.CodeStyle.AddNewSectionRule;

    }

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.GearPlain */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Gear = AllIcons.General.GearPlain;

  }

  public final static class Css {

    /** @deprecated use 'icons.CssIcons' from 'intellij.css' module instead */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Atrule = IconLoader.getIcon("/css/atrule.png");

    /** @deprecated use 'icons.CssIcons' from 'intellij.css' module instead */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Import = IconLoader.getIcon("/css/import.png");

    /** @deprecated use 'icons.CssIcons' from 'intellij.css' module instead */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Property = IconLoader.getIcon("/css/property.png");

  }

  public final static class Darcula {

    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon DoubleComboArrow = IconLoader.getIcon("/darcula/doubleComboArrow.png");

    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TreeNodeCollapsed = IconLoader.getIcon("/darcula/treeNodeCollapsed.png");

    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TreeNodeExpanded = IconLoader.getIcon("/darcula/treeNodeExpanded.png");

  }

  public final static class Debugger {

    public final static class Actions {
      public static final Icon Force_run_to_cursor = IconLoader.getIcon("/debugger/actions/force_run_to_cursor.svg"); // 16x16
      public static final Icon Force_step_into = IconLoader.getIcon("/debugger/actions/force_step_into.svg"); // 16x16
      public static final Icon Force_step_over = IconLoader.getIcon("/debugger/actions/force_step_over.svg"); // 16x16

    }
    public static final Icon AddToWatch = IconLoader.getIcon("/debugger/addToWatch.svg"); // 16x16
    public static final Icon AttachToProcess = IconLoader.getIcon("/debugger/attachToProcess.svg"); // 16x16
    public static final Icon ClassLevelWatch = IconLoader.getIcon("/debugger/classLevelWatch.svg"); // 16x16
    public static final Icon Console = IconLoader.getIcon("/debugger/console.svg"); // 16x16
    public static final Icon Db_array = IconLoader.getIcon("/debugger/db_array.svg"); // 16x16
    public static final Icon Db_db_object = IconLoader.getIcon("/debugger/db_db_object.svg"); // 16x16
    public static final Icon Db_dep_field_breakpoint = IconLoader.getIcon("/debugger/db_dep_field_breakpoint.svg"); // 12x12
    public static final Icon Db_dep_line_breakpoint = IconLoader.getIcon("/debugger/db_dep_line_breakpoint.svg"); // 12x12
    public static final Icon Db_dep_method_breakpoint = IconLoader.getIcon("/debugger/db_dep_method_breakpoint.svg"); // 12x12
    public static final Icon Db_disabled_breakpoint = IconLoader.getIcon("/debugger/db_disabled_breakpoint.svg"); // 12x12
    public static final Icon Db_disabled_breakpoint_process = IconLoader.getIcon("/debugger/db_disabled_breakpoint_process.svg"); // 16x16
    public static final Icon Db_disabled_exception_breakpoint = IconLoader.getIcon("/debugger/db_disabled_exception_breakpoint.svg"); // 12x12
    public static final Icon Db_disabled_field_breakpoint = IconLoader.getIcon("/debugger/db_disabled_field_breakpoint.svg"); // 12x12
    public static final Icon Db_disabled_method_breakpoint = IconLoader.getIcon("/debugger/db_disabled_method_breakpoint.svg"); // 12x12
    public static final Icon Db_exception_breakpoint = IconLoader.getIcon("/debugger/db_exception_breakpoint.svg"); // 12x12
    public static final Icon Db_field_breakpoint = IconLoader.getIcon("/debugger/db_field_breakpoint.svg"); // 12x12
    public static final Icon Db_invalid_breakpoint = IconLoader.getIcon("/debugger/db_invalid_breakpoint.svg"); // 12x12
    public static final Icon Db_method_breakpoint = IconLoader.getIcon("/debugger/db_method_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_breakpoint = IconLoader.getIcon("/debugger/db_muted_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_dep_field_breakpoint = IconLoader.getIcon("/debugger/db_muted_dep_field_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_dep_line_breakpoint = IconLoader.getIcon("/debugger/db_muted_dep_line_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_dep_method_breakpoint = IconLoader.getIcon("/debugger/db_muted_dep_method_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_disabled_breakpoint = IconLoader.getIcon("/debugger/db_muted_disabled_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_disabled_field_breakpoint = IconLoader.getIcon("/debugger/db_muted_disabled_field_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_disabled_method_breakpoint = IconLoader.getIcon("/debugger/db_muted_disabled_method_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_field_breakpoint = IconLoader.getIcon("/debugger/db_muted_field_breakpoint.svg"); // 12x12
    public static final Icon Db_muted_method_breakpoint = IconLoader.getIcon("/debugger/db_muted_method_breakpoint.svg"); // 12x12
    public static final Icon Db_no_suspend_breakpoint = IconLoader.getIcon("/debugger/db_no_suspend_breakpoint.svg"); // 12x12
    public static final Icon Db_no_suspend_field_breakpoint = IconLoader.getIcon("/debugger/db_no_suspend_field_breakpoint.svg"); // 12x12
    public static final Icon Db_no_suspend_method_breakpoint = IconLoader.getIcon("/debugger/db_no_suspend_method_breakpoint.svg"); // 12x12
    public static final Icon Db_obsolete = IconLoader.getIcon("/debugger/db_obsolete.svg"); // 12x12
    public static final Icon Db_primitive = IconLoader.getIcon("/debugger/db_primitive.svg"); // 16x16
    public static final Icon Db_set_breakpoint = IconLoader.getIcon("/debugger/db_set_breakpoint.svg"); // 12x12
    public static final Icon Db_verified_breakpoint = IconLoader.getIcon("/debugger/db_verified_breakpoint.svg"); // 12x12
    public static final Icon Db_verified_field_breakpoint = IconLoader.getIcon("/debugger/db_verified_field_breakpoint.svg"); // 12x12
    public static final Icon Db_verified_method_breakpoint = IconLoader.getIcon("/debugger/db_verified_method_breakpoint.svg"); // 12x12
    public static final Icon Db_verified_no_suspend_breakpoint = IconLoader.getIcon("/debugger/db_verified_no_suspend_breakpoint.svg"); // 12x12
    public static final Icon Db_verified_no_suspend_field_breakpoint = IconLoader.getIcon("/debugger/db_verified_no_suspend_field_breakpoint.svg"); // 12x12
    public static final Icon Db_verified_no_suspend_method_breakpoint = IconLoader.getIcon("/debugger/db_verified_no_suspend_method_breakpoint.svg"); // 12x12
    public static final Icon Db_watch = IconLoader.getIcon("/debugger/db_watch.svg"); // 16x16
    public static final Icon EvaluateExpression = IconLoader.getIcon("/debugger/evaluateExpression.svg"); // 16x16
    public static final Icon Frame = IconLoader.getIcon("/debugger/frame.svg"); // 16x16
    public static final Icon KillProcess = IconLoader.getIcon("/debugger/killProcess.svg"); // 16x16
    public static final Icon LambdaBreakpoint = IconLoader.getIcon("/debugger/LambdaBreakpoint.svg"); // 12x12

    public final static class MemoryView {
      public static final Icon Active = IconLoader.getIcon("/debugger/memoryView/active.svg"); // 16x16

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Watch */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon ClassTracked = AllIcons.Debugger.Watch;

      /** @deprecated to be removed in IDEA 2020 */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon ToolWindowDisabled = IconLoader.getIcon("/debugger/memoryView/toolWindowDisabled.png");

      /** @deprecated to be removed in IDEA 2020 */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon ToolWindowEnabled = IconLoader.getIcon("/debugger/memoryView/toolWindowEnabled.png");

    }
    public static final Icon MultipleBreakpoints = IconLoader.getIcon("/debugger/MultipleBreakpoints.svg"); // 12x12
    public static final Icon MuteBreakpoints = IconLoader.getIcon("/debugger/muteBreakpoints.svg"); // 16x16
    public static final Icon Overhead = IconLoader.getIcon("/debugger/overhead.svg"); // 16x16
    public static final Icon Question_badge = IconLoader.getIcon("/debugger/question_badge.png"); // 6x9
    public static final Icon RestoreLayout = IconLoader.getIcon("/debugger/restoreLayout.svg"); // 16x16
    public static final Icon Selfreference = IconLoader.getIcon("/debugger/selfreference.svg"); // 16x16
    public static final Icon ShowCurrentFrame = IconLoader.getIcon("/debugger/showCurrentFrame.svg"); // 16x16
    public static final Icon SmartStepInto = IconLoader.getIcon("/debugger/smartStepInto.svg"); // 16x16
    public static final Icon ThreadAtBreakpoint = IconLoader.getIcon("/debugger/threadAtBreakpoint.svg"); // 16x16
    public static final Icon ThreadCurrent = IconLoader.getIcon("/debugger/threadCurrent.svg"); // 16x16
    public static final Icon ThreadFrozen = IconLoader.getIcon("/debugger/threadFrozen.svg"); // 16x16
    public static final Icon ThreadGroup = IconLoader.getIcon("/debugger/threadGroup.svg"); // 16x16
    public static final Icon ThreadGroupCurrent = IconLoader.getIcon("/debugger/threadGroupCurrent.svg"); // 16x16
    public static final Icon ThreadRunning = IconLoader.getIcon("/debugger/threadRunning.svg"); // 16x16
    public static final Icon Threads = IconLoader.getIcon("/debugger/threads.svg"); // 16x16

    public final static class ThreadStates {
      public static final Icon Daemon_sign = IconLoader.getIcon("/debugger/threadStates/daemon_sign.svg"); // 16x16
      public static final Icon Idle = IconLoader.getIcon("/debugger/threadStates/idle.svg"); // 16x16
      public static final Icon Socket = IconLoader.getIcon("/debugger/threadStates/socket.svg"); // 16x16

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.ProfileCPU */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon EdtBusy = AllIcons.Actions.ProfileCPU;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Lightning */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Exception = AllIcons.Actions.Lightning;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Menu_saveall */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon IO = AllIcons.Actions.Menu_saveall;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.MuteBreakpoints */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Locked = AllIcons.Debugger.MuteBreakpoints;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Pause */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Paused = AllIcons.Actions.Pause;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Resume */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Running = AllIcons.Actions.Resume;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Dump */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Threaddump = AllIcons.Actions.Dump;

    }
    public static final Icon ThreadSuspended = IconLoader.getIcon("/debugger/threadSuspended.svg"); // 16x16
    public static final Icon Value = IconLoader.getIcon("/debugger/value.svg"); // 16x16
    public static final Icon VariablesTab = IconLoader.getIcon("/debugger/variablesTab.svg"); // 16x16
    public static final Icon ViewBreakpoints = IconLoader.getIcon("/debugger/viewBreakpoints.svg"); // 16x16
    public static final Icon Watch = IconLoader.getIcon("/debugger/watch.svg"); // 16x16
    public static final Icon WatchLastReturnValue = IconLoader.getIcon("/debugger/watchLastReturnValue.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AutoVariablesMode = IconLoader.getIcon("/debugger/autoVariablesMode.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon BreakpointAlert = IconLoader.getIcon("/debugger/breakpointAlert.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Filter */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Class_filter = AllIcons.General.Filter;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Console */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CommandLine = AllIcons.Debugger.Console;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Console */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Console_log = AllIcons.Debugger.Console;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_dep_exception_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_field_warning_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_invalid_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_invalid_field_breakpoint = AllIcons.Debugger.Db_invalid_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_invalid_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_invalid_method_breakpoint = AllIcons.Debugger.Db_invalid_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_method_warning_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_dep_exception_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_disabled_breakpoint_process = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_disabled_exception_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_exception_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_field_warning_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_invalid_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_invalid_breakpoint = AllIcons.Debugger.Db_invalid_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_invalid_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_invalid_field_breakpoint = AllIcons.Debugger.Db_invalid_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_invalid_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_invalid_method_breakpoint = AllIcons.Debugger.Db_invalid_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_method_warning_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_muted_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_temporary_breakpoint = AllIcons.Debugger.Db_muted_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_muted_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_verified_breakpoint = AllIcons.Debugger.Db_muted_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_muted_field_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_verified_field_breakpoint = AllIcons.Debugger.Db_muted_field_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_muted_field_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_verified_method_breakpoint = AllIcons.Debugger.Db_muted_field_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_muted_verified_warning_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_set_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_pending_breakpoint = AllIcons.Debugger.Db_set_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_set_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_temporary_breakpoint = AllIcons.Debugger.Db_set_breakpoint;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Db_exception_breakpoint */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Db_verified_warning_breakpoint = AllIcons.Debugger.Db_exception_breakpoint;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Disable_value_calculation = IconLoader.getIcon("/debugger/disable_value_calculation.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Explosion = IconLoader.getIcon("/debugger/explosion.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Add */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon NewWatch = AllIcons.General.Add;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Frame */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon StackFrame = AllIcons.Debugger.Frame;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Console */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ToolConsole = AllIcons.Debugger.Console;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Debugger.Watch */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Watches = AllIcons.Debugger.Watch;

  }

  public final static class Diff {
    public static final Icon ApplyNotConflicts = IconLoader.getIcon("/diff/applyNotConflicts.svg"); // 16x16
    public static final Icon ApplyNotConflictsLeft = IconLoader.getIcon("/diff/applyNotConflictsLeft.svg"); // 16x16
    public static final Icon ApplyNotConflictsRight = IconLoader.getIcon("/diff/applyNotConflictsRight.svg"); // 16x16
    public static final Icon Arrow = IconLoader.getIcon("/diff/arrow.svg"); // 12x12
    public static final Icon ArrowLeftDown = IconLoader.getIcon("/diff/arrowLeftDown.svg"); // 12x12
    public static final Icon ArrowRight = IconLoader.getIcon("/diff/arrowRight.svg"); // 12x12
    public static final Icon ArrowRightDown = IconLoader.getIcon("/diff/arrowRightDown.svg"); // 12x12
    public static final Icon Compare3LeftMiddle = IconLoader.getIcon("/diff/compare3LeftMiddle.png"); // 16x16
    public static final Icon Compare3LeftRight = IconLoader.getIcon("/diff/compare3LeftRight.png"); // 16x16
    public static final Icon Compare3MiddleRight = IconLoader.getIcon("/diff/compare3MiddleRight.png"); // 16x16
    public static final Icon Compare4LeftBottom = IconLoader.getIcon("/diff/compare4LeftBottom.png"); // 16x16
    public static final Icon Compare4LeftMiddle = IconLoader.getIcon("/diff/compare4LeftMiddle.png"); // 16x16
    public static final Icon Compare4LeftRight = IconLoader.getIcon("/diff/compare4LeftRight.png"); // 16x16
    public static final Icon Compare4MiddleBottom = IconLoader.getIcon("/diff/compare4MiddleBottom.png"); // 16x16
    public static final Icon Compare4MiddleRight = IconLoader.getIcon("/diff/compare4MiddleRight.png"); // 16x16
    public static final Icon Compare4RightBottom = IconLoader.getIcon("/diff/compare4RightBottom.png"); // 16x16
    public static final Icon GutterCheckBox = IconLoader.getIcon("/diff/gutterCheckBox.svg"); // 12x12
    public static final Icon GutterCheckBoxSelected = IconLoader.getIcon("/diff/gutterCheckBoxSelected.svg"); // 12x12
    public static final Icon MagicResolve = IconLoader.getIcon("/diff/magicResolve.svg"); // 12x12
    public static final Icon MagicResolveToolbar = IconLoader.getIcon("/diff/magicResolveToolbar.svg"); // 16x16
    public static final Icon Remove = IconLoader.getIcon("/diff/remove.svg"); // 12x12

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Forward */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CurrentLine = AllIcons.Actions.Forward;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Diff */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Diff = AllIcons.Actions.Diff;

  }

  public final static class Duplicates {
    public static final Icon SendToTheLeft = IconLoader.getIcon("/duplicates/sendToTheLeft.png"); // 16x16
    public static final Icon SendToTheLeftGrayed = IconLoader.getIcon("/duplicates/sendToTheLeftGrayed.png"); // 16x16
    public static final Icon SendToTheRight = IconLoader.getIcon("/duplicates/sendToTheRight.png"); // 16x16
    public static final Icon SendToTheRightGrayed = IconLoader.getIcon("/duplicates/sendToTheRightGrayed.png"); // 16x16

  }

  public final static class FileTypes {
    public static final Icon AddAny = IconLoader.getIcon("/fileTypes/addAny.svg"); // 16x16
    public static final Icon Any_type = IconLoader.getIcon("/fileTypes/any_type.svg"); // 16x16
    public static final Icon Archive = IconLoader.getIcon("/fileTypes/archive.svg"); // 16x16
    public static final Icon AS = IconLoader.getIcon("/fileTypes/as.svg"); // 16x16
    public static final Icon Aspectj = IconLoader.getIcon("/fileTypes/aspectj.svg"); // 16x16
    public static final Icon Config = IconLoader.getIcon("/fileTypes/config.svg"); // 16x16
    public static final Icon Css = IconLoader.getIcon("/fileTypes/css.svg"); // 16x16
    public static final Icon Custom = IconLoader.getIcon("/fileTypes/custom.svg"); // 16x16
    public static final Icon Diagram = IconLoader.getIcon("/fileTypes/diagram.svg"); // 16x16
    public static final Icon Dtd = IconLoader.getIcon("/fileTypes/dtd.svg"); // 16x16
    public static final Icon Htaccess = IconLoader.getIcon("/fileTypes/htaccess.svg"); // 16x16
    public static final Icon Html = IconLoader.getIcon("/fileTypes/html.svg"); // 16x16
    public static final Icon Idl = IconLoader.getIcon("/fileTypes/idl.svg"); // 16x16
    public static final Icon Java = IconLoader.getIcon("/fileTypes/java.svg"); // 16x16
    public static final Icon JavaClass = IconLoader.getIcon("/fileTypes/javaClass.svg"); // 16x16
    public static final Icon JavaOutsideSource = IconLoader.getIcon("/fileTypes/javaOutsideSource.svg"); // 16x16
    public static final Icon JavaScript = IconLoader.getIcon("/fileTypes/javaScript.svg"); // 16x16
    public static final Icon Json = IconLoader.getIcon("/fileTypes/json.svg"); // 16x16
    public static final Icon JsonSchema = IconLoader.getIcon("/fileTypes/jsonSchema.svg"); // 16x16
    public static final Icon Jsp = IconLoader.getIcon("/fileTypes/jsp.svg"); // 16x16
    public static final Icon Jspx = IconLoader.getIcon("/fileTypes/jspx.svg"); // 16x16
    public static final Icon Manifest = IconLoader.getIcon("/fileTypes/manifest.svg"); // 16x16
    public static final Icon Properties = IconLoader.getIcon("/fileTypes/properties.svg"); // 16x16
    public static final Icon Text = IconLoader.getIcon("/fileTypes/text.svg"); // 16x16
    public static final Icon UiForm = IconLoader.getIcon("/fileTypes/uiForm.svg"); // 16x16
    public static final Icon Unknown = IconLoader.getIcon("/fileTypes/unknown.svg"); // 16x16
    public static final Icon WsdlFile = IconLoader.getIcon("/fileTypes/wsdlFile.svg"); // 16x16
    public static final Icon Xhtml = IconLoader.getIcon("/fileTypes/xhtml.svg"); // 16x16
    public static final Icon Xml = IconLoader.getIcon("/fileTypes/xml.svg"); // 16x16
    public static final Icon XsdFile = IconLoader.getIcon("/fileTypes/xsdFile.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use JsfIcons.Facelets */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Facelets = IconLoader.getIcon("/fileTypes/facelets.svg");

    /** @deprecated to be removed in IDEA 2020 - use JsfIcons.FacesConfig */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon FacesConfig = IconLoader.getIcon("/fileTypes/facesConfig.svg");

    /** @deprecated to be removed in IDEA 2020 - use JavaScriptPsiIcons.FileTypes.TypeScriptFile */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TypeScript = IconLoader.getIcon("/fileTypes/typeScript.svg");

  }

  public final static class General {
    public static final Icon ActualZoom = IconLoader.getIcon("/general/actualZoom.svg"); // 16x16
    public static final Icon Add = IconLoader.getIcon("/general/add.svg"); // 16x16
    public static final Icon AddJdk = IconLoader.getIcon("/general/addJdk.svg"); // 16x16
    public static final Icon ArrowDown = IconLoader.getIcon("/general/arrowDown.svg"); // 16x16
    public static final Icon ArrowDownSmall = IconLoader.getIcon("/general/arrowDownSmall.svg"); // 9x5
    public static final Icon ArrowLeft = IconLoader.getIcon("/general/arrowLeft.svg"); // 16x16
    public static final Icon ArrowRight = IconLoader.getIcon("/general/arrowRight.svg"); // 16x16
    public static final Icon ArrowSplitCenterH = IconLoader.getIcon("/general/arrowSplitCenterH.svg"); // 16x16
    public static final Icon ArrowSplitCenterV = IconLoader.getIcon("/general/arrowSplitCenterV.svg"); // 16x16
    public static final Icon ArrowUp = IconLoader.getIcon("/general/arrowUp.svg"); // 16x16
    public static final Icon AutoscrollFromSource = IconLoader.getIcon("/general/autoscrollFromSource.svg"); // 16x16
    public static final Icon AutoscrollToSource = IconLoader.getIcon("/general/autoscrollToSource.svg"); // 16x16
    public static final Icon Balloon = IconLoader.getIcon("/general/balloon.svg"); // 16x16
    public static final Icon BalloonClose = IconLoader.getIcon("/general/balloonClose.png"); // 32x32
    public static final Icon BalloonError = IconLoader.getIcon("/general/balloonError.svg"); // 16x16
    public static final Icon BalloonInformation = IconLoader.getIcon("/general/balloonInformation.svg"); // 16x16
    public static final Icon BalloonWarning = IconLoader.getIcon("/general/balloonWarning.svg"); // 16x16
    public static final Icon BalloonWarning12 = IconLoader.getIcon("/general/balloonWarning12.svg"); // 12x12
    public static final Icon CollapseComponent = IconLoader.getIcon("/general/collapseComponent.svg"); // 12x12
    public static final Icon CollapseComponentHover = IconLoader.getIcon("/general/collapseComponentHover.svg"); // 12x12
    public static final Icon ComboUpPassive = IconLoader.getIcon("/general/comboUpPassive.png"); // 16x16
    public static final Icon ContextHelp = IconLoader.getIcon("/general/contextHelp.svg"); // 16x16
    public static final Icon CopyHovered = IconLoader.getIcon("/general/copyHovered.svg"); // 16x16
    public static final Icon Divider = IconLoader.getIcon("/general/divider.svg"); // 2x19
    public static final Icon Dropdown = IconLoader.getIcon("/general/dropdown.svg"); // 16x16
    public static final Icon DropdownGutter = IconLoader.getIcon("/general/dropdownGutter.svg"); // 13x13
    public static final Icon Ellipsis = IconLoader.getIcon("/general/ellipsis.svg"); // 9x9
    public static final Icon Error = IconLoader.getIcon("/general/error.svg"); // 16x16
    public static final Icon ErrorDialog = IconLoader.getIcon("/general/errorDialog.svg"); // 32x32
    public static final Icon ExclMark = IconLoader.getIcon("/general/exclMark.svg"); // 16x16
    public static final Icon ExpandComponent = IconLoader.getIcon("/general/expandComponent.svg"); // 12x12
    public static final Icon ExpandComponentHover = IconLoader.getIcon("/general/expandComponentHover.svg"); // 12x12
    public static final Icon ExternalTools = IconLoader.getIcon("/general/externalTools.svg"); // 16x16
    public static final Icon Filter = IconLoader.getIcon("/general/filter.svg"); // 16x16
    public static final Icon FitContent = IconLoader.getIcon("/general/fitContent.svg"); // 16x16
    public static final Icon GearPlain = IconLoader.getIcon("/general/gearPlain.svg"); // 16x16
    public static final Icon HideToolWindow = IconLoader.getIcon("/general/hideToolWindow.svg"); // 16x16
    public static final Icon ImplementingMethod = IconLoader.getIcon("/general/implementingMethod.png"); // 10x14
    public static final Icon Information = IconLoader.getIcon("/general/information.svg"); // 16x16
    public static final Icon InformationDialog = IconLoader.getIcon("/general/informationDialog.svg"); // 32x32
    public static final Icon InheritedMethod = IconLoader.getIcon("/general/inheritedMethod.png"); // 11x14
    public static final Icon Inline_edit = IconLoader.getIcon("/general/inline_edit.svg"); // 16x16
    public static final Icon Inline_edit_hovered = IconLoader.getIcon("/general/inline_edit_hovered.svg"); // 16x16
    public static final Icon InlineAdd = IconLoader.getIcon("/general/inlineAdd.svg"); // 16x16
    public static final Icon InlineAddHover = IconLoader.getIcon("/general/inlineAddHover.svg"); // 16x16
    public static final Icon InspectionsError = IconLoader.getIcon("/general/inspectionsError.svg"); // 14x14
    public static final Icon InspectionsEye = IconLoader.getIcon("/general/inspectionsEye.svg"); // 14x14
    public static final Icon InspectionsOff = IconLoader.getIcon("/general/inspectionsOff.png"); // 16x16
    public static final Icon InspectionsOK = IconLoader.getIcon("/general/inspectionsOK.svg"); // 14x14
    public static final Icon InspectionsPause = IconLoader.getIcon("/general/inspectionsPause.svg"); // 14x14
    public static final Icon InspectionsTrafficOff = IconLoader.getIcon("/general/inspectionsTrafficOff.svg"); // 14x14
    public static final Icon InspectionsTypos = IconLoader.getIcon("/general/inspectionsTypos.svg"); // 14x14
    public static final Icon Layout = IconLoader.getIcon("/general/layout.svg"); // 16x16
    public static final Icon LayoutEditorOnly = IconLoader.getIcon("/general/layoutEditorOnly.svg"); // 16x16
    public static final Icon LayoutEditorPreview = IconLoader.getIcon("/general/layoutEditorPreview.svg"); // 16x16
    public static final Icon LayoutPreviewOnly = IconLoader.getIcon("/general/layoutPreviewOnly.svg"); // 16x16
    public static final Icon LinkDropTriangle = IconLoader.getIcon("/general/linkDropTriangle.svg"); // 14x14
    public static final Icon Locate = IconLoader.getIcon("/general/locate.svg"); // 16x16
    public static final Icon Modified = IconLoader.getIcon("/general/modified.svg"); // 24x16
    public static final Icon MoreTabs = IconLoader.getIcon("/general/moreTabs.svg"); // 16x16
    public static final Icon Mouse = IconLoader.getIcon("/general/mouse.svg"); // 16x16
    public static final Icon Note = IconLoader.getIcon("/general/note.svg"); // 16x16
    public static final Icon NotificationError = IconLoader.getIcon("/general/notificationError.svg"); // 24x24
    public static final Icon NotificationInfo = IconLoader.getIcon("/general/notificationInfo.svg"); // 24x24
    public static final Icon NotificationWarning = IconLoader.getIcon("/general/notificationWarning.svg"); // 24x24
    public static final Icon OpenDisk = IconLoader.getIcon("/general/openDisk.svg"); // 16x16
    public static final Icon OpenDiskHover = IconLoader.getIcon("/general/openDiskHover.svg"); // 16x16
    public static final Icon OverridenMethod = IconLoader.getIcon("/general/overridenMethod.png"); // 10x14
    public static final Icon OverridingMethod = IconLoader.getIcon("/general/overridingMethod.png"); // 10x14
    public static final Icon Pin_tab = IconLoader.getIcon("/general/pin_tab.svg"); // 16x16
    public static final Icon Print = IconLoader.getIcon("/general/print.svg"); // 16x16
    public static final Icon ProjectConfigurable = IconLoader.getIcon("/general/projectConfigurable.svg"); // 9x9
    public static final Icon ProjectStructure = IconLoader.getIcon("/general/projectStructure.svg"); // 16x16
    public static final Icon ProjectTab = IconLoader.getIcon("/general/projectTab.svg"); // 16x16
    public static final Icon QuestionDialog = IconLoader.getIcon("/general/questionDialog.svg"); // 32x32
    public static final Icon Remove = IconLoader.getIcon("/general/remove.svg"); // 16x16
    public static final Icon Reset = IconLoader.getIcon("/general/reset.svg"); // 16x16
    public static final Icon RunWithCoverage = IconLoader.getIcon("/general/runWithCoverage.svg"); // 16x16
    public static final Icon SafeMode = IconLoader.getIcon("/general/safeMode.png"); // 13x13
    public static final Icon SeparatorH = IconLoader.getIcon("/general/separatorH.png"); // 17x11
    public static final Icon Settings = IconLoader.getIcon("/general/settings.svg"); // 16x16
    public static final Icon Show_to_implement = IconLoader.getIcon("/general/show_to_implement.png"); // 16x16
    public static final Icon ShowWarning = IconLoader.getIcon("/general/showWarning.svg"); // 16x16
    public static final Icon SplitGlueH = IconLoader.getIcon("/general/splitGlueH.png"); // 6x17
    public static final Icon SplitGlueV = IconLoader.getIcon("/general/splitGlueV.png"); // 17x6
    public static final Icon TbHidden = IconLoader.getIcon("/general/tbHidden.svg"); // 16x16
    public static final Icon TbShown = IconLoader.getIcon("/general/tbShown.svg"); // 16x16
    public static final Icon Tip = IconLoader.getIcon("/general/tip.png"); // 32x32
    public static final Icon TodoDefault = IconLoader.getIcon("/general/todoDefault.svg"); // 16x16
    public static final Icon TodoImportant = IconLoader.getIcon("/general/todoImportant.svg"); // 16x16
    public static final Icon TodoQuestion = IconLoader.getIcon("/general/todoQuestion.svg"); // 16x16
    public static final Icon User = IconLoader.getIcon("/general/user.svg"); // 16x16
    public static final Icon Warning = IconLoader.getIcon("/general/warning.svg"); // 16x16
    public static final Icon WarningDecorator = IconLoader.getIcon("/general/warningDecorator.svg"); // 16x16
    public static final Icon WarningDialog = IconLoader.getIcon("/general/warningDialog.svg"); // 32x32
    public static final Icon Web = IconLoader.getIcon("/general/web.svg"); // 16x16
    public static final Icon ZoomIn = IconLoader.getIcon("/general/zoomIn.svg"); // 16x16
    public static final Icon ZoomOut = IconLoader.getIcon("/general/zoomOut.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Add */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AddFavoritesList = AllIcons.General.Add;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ArrowDown_white = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Pin_tab */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AutohideOff = AllIcons.General.Pin_tab;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Pin_tab */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AutohideOffInactive = AllIcons.General.Pin_tab;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Pin_tab */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AutohideOffPressed = AllIcons.General.Pin_tab;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Bullet = IconLoader.getIcon("/general/bullet.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Collapseall */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CollapseAll = AllIcons.Actions.Collapseall;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Collapseall */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CollapseAllHover = AllIcons.Actions.Collapseall;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Combo = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Combo2 = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Combo3 = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ComboArrow = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDownSmall */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ComboArrowDown = AllIcons.General.ArrowDownSmall;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowLeft */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ComboArrowLeft = AllIcons.General.ArrowLeft;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowLeft */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ComboArrowLeftPassive = AllIcons.General.ArrowLeft;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowRight */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ComboArrowRight = AllIcons.General.ArrowRight;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowRight */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ComboArrowRightPassive = AllIcons.General.ArrowRight;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ComboBoxButtonArrow = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ConfigurableDefault = IconLoader.getIcon("/general/configurableDefault.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Settings */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Configure = AllIcons.General.Settings;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Welcome.CreateNewProject */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CreateNewProject = AllIcons.Welcome.CreateNewProject;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.Import */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CreateNewProjectfromExistingFiles = AllIcons.ToolbarDecorator.Import;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.StartDebugger */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Debug = AllIcons.Actions.StartDebugger;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon DefaultKeymap = IconLoader.getIcon("/general/defaultKeymap.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon DownloadPlugin = IconLoader.getIcon("/general/downloadPlugin.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Settings */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon EditColors = AllIcons.General.Settings;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Edit */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon EditItemInSection = AllIcons.Actions.Edit;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ErrorsInProgress = IconLoader.getIcon("/general/errorsInProgress.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Expandall */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ExpandAll = AllIcons.Actions.Expandall;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Expandall */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ExpandAllHover = AllIcons.Actions.Expandall;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.Export */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ExportSettings = AllIcons.ToolbarDecorator.Export;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ExternalTools */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ExternalToolsSmall = AllIcons.General.ExternalTools;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.MoveTo2 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Floating = AllIcons.Actions.MoveTo2;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.GearPlain */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Gear = AllIcons.General.GearPlain;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon GearHover = IconLoader.getIcon("/general/gearHover.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Welcome.FromVCS */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon GetProjectfromVCS = AllIcons.Welcome.FromVCS;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ContextHelp */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Help = AllIcons.General.ContextHelp;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ContextHelp */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Help_small = AllIcons.General.ContextHelp;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideDown = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideDownHover = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideDownPart = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideDownPartHover = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideLeft = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideLeftHover = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideLeftPart = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideLeftPartHover = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideRight = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideRightHover = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideRightPart = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideRightPartHover = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.HideToolWindow */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideToolWindowInactive = AllIcons.General.HideToolWindow;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideWarnings = IconLoader.getIcon("/general/hideWarnings.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon IjLogo = IconLoader.getIcon("/general/ijLogo.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.Import */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ImportProject = AllIcons.ToolbarDecorator.Import;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.Import */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ImportSettings = AllIcons.ToolbarDecorator.Import;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Jdk = IconLoader.getIcon("/general/jdk.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon KeyboardShortcut = IconLoader.getIcon("/general/keyboardShortcut.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Keymap = IconLoader.getIcon("/general/keymap.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Locate */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon LocateHover = AllIcons.General.Locate;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon MacCorner = IconLoader.getIcon("/general/macCorner.png");

    /** @deprecated to be removed in IDEA 2020 - use EmptyIcon.ICON_16 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Mdot_empty = IconLoader.getIcon("/general/mdot-empty.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Mdot_white = IconLoader.getIcon("/general/mdot-white.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Mdot = IconLoader.getIcon("/general/mdot.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Vcs.History */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon MessageHistory = AllIcons.Vcs.History;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon MouseShortcut = IconLoader.getIcon("/general/mouseShortcut.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Menu_open */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon OpenProject = AllIcons.Actions.Menu_open;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.CopyOfFolder */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon PackagesTab = AllIcons.Nodes.CopyOfFolder;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon PasswordLock = IconLoader.getIcon("/general/passwordLock.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon PathVariables = IconLoader.getIcon("/general/pathVariables.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon PluginManager = IconLoader.getIcon("/general/pluginManager.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Progress = IconLoader.getIcon("/general/progress.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ProjectConfigurable */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ProjectConfigurableBanner = AllIcons.General.ProjectConfigurable;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ProjectConfigurable */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ProjectConfigurableSelected = AllIcons.General.ProjectConfigurable;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.GearPlain */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ProjectSettings = AllIcons.General.GearPlain;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Help */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ReadHelp = AllIcons.Actions.Help;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.ShowAsTree */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Recursive = AllIcons.Actions.ShowAsTree;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.RunConfigurations.TestState.Run */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Run = AllIcons.RunConfigurations.TestState.Run;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SearchEverywhereGear = IconLoader.getIcon("/general/searchEverywhereGear.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.GearPlain */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SecondaryGroup = AllIcons.General.GearPlain;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Show_to_override = IconLoader.getIcon("/general/show_to_override.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.ShowAsTree */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SmallConfigurableVcs = AllIcons.Actions.ShowAsTree;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowSplitCenterH */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SplitCenterH = AllIcons.General.ArrowSplitCenterH;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowSplitCenterV */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SplitCenterV = AllIcons.General.ArrowSplitCenterV;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SplitDown = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowLeft */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SplitLeft = AllIcons.General.ArrowLeft;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowRight */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SplitRight = AllIcons.General.ArrowRight;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowUp */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SplitUp = AllIcons.General.ArrowUp;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Tab_white_center = IconLoader.getIcon("/general/tab-white-center.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Tab_white_left = IconLoader.getIcon("/general/tab-white-left.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Tab_white_right = IconLoader.getIcon("/general/tab-white-right.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Tab_grey_bckgrnd = IconLoader.getIcon("/general/tab_grey_bckgrnd.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Tab_grey_left = IconLoader.getIcon("/general/tab_grey_left.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Tab_grey_left_inner = IconLoader.getIcon("/general/tab_grey_left_inner.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Tab_grey_right = IconLoader.getIcon("/general/tab_grey_right.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Tab_grey_right_inner = IconLoader.getIcon("/general/tab_grey_right_inner.png");

    /** @deprecated to be removed in IDEA 2020 - AllIcons.General.Settings */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TemplateProjectSettings = IconLoader.getIcon("/general/settings.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - AllIcons.General.ProjectStructure */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TemplateProjectStructure = IconLoader.getIcon("/general/projectStructure.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon UninstallPlugin = IconLoader.getIcon("/general/uninstallPlugin.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon WebSettings = IconLoader.getIcon("/general/webSettings.png");

  }

  public final static class Graph {
    public static final Icon ActualZoom = IconLoader.getIcon("/graph/actualZoom.svg"); // 16x16
    public static final Icon FitContent = IconLoader.getIcon("/graph/fitContent.svg"); // 16x16
    public static final Icon Grid = IconLoader.getIcon("/graph/grid.png"); // 16x16
    public static final Icon Layout = IconLoader.getIcon("/graph/layout.svg"); // 16x16
    public static final Icon NodeSelectionMode = IconLoader.getIcon("/graph/nodeSelectionMode.png"); // 16x16
    public static final Icon Print = IconLoader.getIcon("/graph/print.svg"); // 16x16
    public static final Icon PrintPreview = IconLoader.getIcon("/graph/printPreview.png"); // 16x16
    public static final Icon SnapToGrid = IconLoader.getIcon("/graph/snapToGrid.png"); // 16x16
    public static final Icon ZoomIn = IconLoader.getIcon("/graph/zoomIn.svg"); // 16x16
    public static final Icon ZoomOut = IconLoader.getIcon("/graph/zoomOut.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.Export */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Export = AllIcons.ToolbarDecorator.Export;

  }

  public final static class Gutter {
    public static final Icon Colors = IconLoader.getIcon("/gutter/colors.svg"); // 12x12
    public static final Icon ExtAnnotation = IconLoader.getIcon("/gutter/extAnnotation.svg"); // 12x12
    public static final Icon ImplementedMethod = IconLoader.getIcon("/gutter/implementedMethod.svg"); // 12x12
    public static final Icon ImplementingFunctionalInterface = IconLoader.getIcon("/gutter/implementingFunctionalInterface.svg"); // 12x12
    public static final Icon ImplementingMethod = IconLoader.getIcon("/gutter/implementingMethod.svg"); // 12x12
    public static final Icon Java9Service = IconLoader.getIcon("/gutter/java9Service.svg"); // 12x12
    public static final Icon OverridenMethod = IconLoader.getIcon("/gutter/overridenMethod.svg"); // 12x12
    public static final Icon OverridingMethod = IconLoader.getIcon("/gutter/overridingMethod.svg"); // 12x12
    public static final Icon RecursiveMethod = IconLoader.getIcon("/gutter/recursiveMethod.svg"); // 12x12
    public static final Icon SiblingInheritedMethod = IconLoader.getIcon("/gutter/siblingInheritedMethod.svg"); // 12x12
    public static final Icon Unique = IconLoader.getIcon("/gutter/unique.svg"); // 8x8

  }

  public final static class Hierarchy {
    public static final Icon Class = IconLoader.getIcon("/hierarchy/class.svg"); // 16x16
    public static final Icon MethodDefined = IconLoader.getIcon("/hierarchy/methodDefined.svg"); // 8x8
    public static final Icon MethodNotDefined = IconLoader.getIcon("/hierarchy/methodNotDefined.svg"); // 8x8
    public static final Icon ShouldDefineMethod = IconLoader.getIcon("/hierarchy/shouldDefineMethod.svg"); // 8x8
    public static final Icon Subtypes = IconLoader.getIcon("/hierarchy/subtypes.svg"); // 16x16
    public static final Icon Supertypes = IconLoader.getIcon("/hierarchy/supertypes.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Forward */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Base = AllIcons.Actions.Forward;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Hierarchy.Subtypes */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Callee = AllIcons.Hierarchy.Subtypes;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Hierarchy.Supertypes */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Caller = AllIcons.Hierarchy.Supertypes;

  }
  public static final Icon Icon = IconLoader.getIcon("/icon.png"); // 32x32
  public static final Icon Icon_128 = IconLoader.getIcon("/icon_128.png"); // 128x128
  public static final Icon Icon_CE = IconLoader.getIcon("/icon_CE.png"); // 32x32
  public static final Icon Icon_CE_128 = IconLoader.getIcon("/icon_CE_128.png"); // 128x128
  public static final Icon Icon_CE_256 = IconLoader.getIcon("/icon_CE_256.png"); // 256x256
  public static final Icon Icon_CE_512 = IconLoader.getIcon("/icon_CE_512.png"); // 512x512
  public static final Icon Icon_CE_64 = IconLoader.getIcon("/icon_CE_64.png"); // 64x64
  public static final Icon Icon_CEsmall = IconLoader.getIcon("/icon_CEsmall.png"); // 16x16
  public static final Icon Icon_small = IconLoader.getIcon("/icon_small.png"); // 16x16

  public final static class Icons {

    public final static class Ide {
      public static final Icon NextStep = IconLoader.getIcon("/icons/ide/nextStep.png"); // 12x12
      public static final Icon NextStepGrayed = IconLoader.getIcon("/icons/ide/nextStepGrayed.png"); // 12x12
      public static final Icon NextStepInverted = IconLoader.getIcon("/icons/ide/nextStepInverted.png"); // 12x12
      public static final Icon SpeedSearchPrompt = IconLoader.getIcon("/icons/ide/speedSearchPrompt.png"); // 16x16

    }

  }

  public final static class Ide {

    public final static class Dnd {
      public static final Icon Bottom = IconLoader.getIcon("/ide/dnd/bottom.png"); // 16x16
      public static final Icon Left = IconLoader.getIcon("/ide/dnd/left.png"); // 16x16
      public static final Icon Right = IconLoader.getIcon("/ide/dnd/right.png"); // 16x16
      public static final Icon Top = IconLoader.getIcon("/ide/dnd/top.png"); // 16x16

    }
    public static final Icon Error_notifications = IconLoader.getIcon("/ide/error_notifications.png"); // 16x16
    public static final Icon ErrorPoint = IconLoader.getIcon("/ide/errorPoint.png"); // 6x6
    public static final Icon External_link_arrow = IconLoader.getIcon("/ide/external_link_arrow.png"); // 14x14
    public static final Icon FatalError_read = IconLoader.getIcon("/ide/fatalError-read.svg"); // 16x16
    public static final Icon FatalError = IconLoader.getIcon("/ide/fatalError.svg"); // 16x16
    public static final Icon HectorNo = IconLoader.getIcon("/ide/hectorNo.png"); // 16x16
    public static final Icon HectorOff = IconLoader.getIcon("/ide/hectorOff.png"); // 16x16
    public static final Icon HectorOn = IconLoader.getIcon("/ide/hectorOn.png"); // 16x16
    public static final Icon HectorSyntax = IconLoader.getIcon("/ide/hectorSyntax.png"); // 16x16
    public static final Icon IncomingChangesOff = IconLoader.getIcon("/ide/incomingChangesOff.png"); // 16x16
    public static final Icon IncomingChangesOn = IconLoader.getIcon("/ide/incomingChangesOn.png"); // 16x16
    public static final Icon Info_notifications = IconLoader.getIcon("/ide/info_notifications.png"); // 16x16
    public static final Icon Link = IconLoader.getIcon("/ide/link.png"); // 12x12
    public static final Icon LocalScope = IconLoader.getIcon("/ide/localScope.svg"); // 16x16
    public static final Icon LookupAlphanumeric = IconLoader.getIcon("/ide/lookupAlphanumeric.png"); // 12x12
    public static final Icon LookupRelevance = IconLoader.getIcon("/ide/lookupRelevance.png"); // 12x12

    public final static class Macro {
      public static final Icon Recording_1 = IconLoader.getIcon("/ide/macro/recording_1.svg"); // 16x16
      public static final Icon Recording_2 = IconLoader.getIcon("/ide/macro/recording_2.svg"); // 16x16
      public static final Icon Recording_3 = IconLoader.getIcon("/ide/macro/recording_3.svg"); // 16x16
      public static final Icon Recording_4 = IconLoader.getIcon("/ide/macro/recording_4.svg"); // 16x16

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Suspend */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Recording_stop = AllIcons.Actions.Suspend;

    }
    public static final Icon NavBarSeparator = IconLoader.getIcon("/ide/NavBarSeparator.svg"); // 5x15
    public static final Icon NoNotifications13 = IconLoader.getIcon("/ide/noNotifications13.png"); // 13x13

    public final static class Notification {
      public static final Icon Close = IconLoader.getIcon("/ide/notification/close.svg"); // 16x16
      public static final Icon CloseHover = IconLoader.getIcon("/ide/notification/closeHover.svg"); // 16x16
      public static final Icon Collapse = IconLoader.getIcon("/ide/notification/collapse.svg"); // 16x16
      public static final Icon CollapseHover = IconLoader.getIcon("/ide/notification/collapseHover.svg"); // 16x16
      public static final Icon DropTriangle = IconLoader.getIcon("/ide/notification/dropTriangle.svg"); // 16x16
      public static final Icon ErrorEvents = IconLoader.getIcon("/ide/notification/errorEvents.svg"); // 13x13
      public static final Icon Expand = IconLoader.getIcon("/ide/notification/expand.svg"); // 16x16
      public static final Icon ExpandHover = IconLoader.getIcon("/ide/notification/expandHover.svg"); // 16x16
      public static final Icon Gear = IconLoader.getIcon("/ide/notification/gear.svg"); // 16x16
      public static final Icon GearHover = IconLoader.getIcon("/ide/notification/gearHover.svg"); // 16x16
      public static final Icon InfoEvents = IconLoader.getIcon("/ide/notification/infoEvents.svg"); // 13x13
      public static final Icon NoEvents = IconLoader.getIcon("/ide/notification/noEvents.svg"); // 13x13

      public final static class Shadow {
        public static final Icon Bottom_left = IconLoader.getIcon("/ide/notification/shadow/bottom-left.png"); // 14x16
        public static final Icon Bottom_right = IconLoader.getIcon("/ide/notification/shadow/bottom-right.png"); // 14x16
        public static final Icon Bottom = IconLoader.getIcon("/ide/notification/shadow/bottom.png"); // 4x8
        public static final Icon Left = IconLoader.getIcon("/ide/notification/shadow/left.png"); // 6x4
        public static final Icon Right = IconLoader.getIcon("/ide/notification/shadow/right.png"); // 6x4
        public static final Icon Top_left = IconLoader.getIcon("/ide/notification/shadow/top-left.png"); // 14x12
        public static final Icon Top_right = IconLoader.getIcon("/ide/notification/shadow/top-right.png"); // 14x12
        public static final Icon Top = IconLoader.getIcon("/ide/notification/shadow/top.png"); // 4x4

      }
      public static final Icon WarningEvents = IconLoader.getIcon("/ide/notification/warningEvents.svg"); // 13x13

    }
    public static final Icon Notifications = IconLoader.getIcon("/ide/notifications.png"); // 16x16
    public static final Icon OutgoingChangesOn = IconLoader.getIcon("/ide/outgoingChangesOn.png"); // 16x16
    public static final Icon Pipette = IconLoader.getIcon("/ide/pipette.svg"); // 16x16
    public static final Icon Pipette_rollover = IconLoader.getIcon("/ide/pipette_rollover.svg"); // 16x16
    public static final Icon Rating = IconLoader.getIcon("/ide/rating.svg"); // 11x11
    public static final Icon Rating1 = IconLoader.getIcon("/ide/rating1.svg"); // 11x11
    public static final Icon Rating2 = IconLoader.getIcon("/ide/rating2.svg"); // 11x11
    public static final Icon Rating3 = IconLoader.getIcon("/ide/rating3.svg"); // 11x11
    public static final Icon Rating4 = IconLoader.getIcon("/ide/rating4.svg"); // 11x11
    public static final Icon Readonly = IconLoader.getIcon("/ide/readonly.svg"); // 16x16
    public static final Icon Readwrite = IconLoader.getIcon("/ide/readwrite.svg"); // 16x16

    public final static class Shadow {
      public static final Icon Bottom_left = IconLoader.getIcon("/ide/shadow/bottom-left.svg"); // 18x22
      public static final Icon Bottom_right = IconLoader.getIcon("/ide/shadow/bottom-right.svg"); // 18x22
      public static final Icon Bottom = IconLoader.getIcon("/ide/shadow/bottom.svg"); // 4x14
      public static final Icon Left = IconLoader.getIcon("/ide/shadow/left.svg"); // 11x4

      public final static class Popup {
        public static final Icon Bottom_left = IconLoader.getIcon("/ide/shadow/popup/bottom-left.png"); // 20x20
        public static final Icon Bottom_right = IconLoader.getIcon("/ide/shadow/popup/bottom-right.png"); // 20x20
        public static final Icon Bottom = IconLoader.getIcon("/ide/shadow/popup/bottom.png"); // 1x10
        public static final Icon Left = IconLoader.getIcon("/ide/shadow/popup/left.png"); // 7x1
        public static final Icon Right = IconLoader.getIcon("/ide/shadow/popup/right.png"); // 7x1
        public static final Icon Top_left = IconLoader.getIcon("/ide/shadow/popup/top-left.png"); // 14x14
        public static final Icon Top_right = IconLoader.getIcon("/ide/shadow/popup/top-right.png"); // 14x14
        public static final Icon Top = IconLoader.getIcon("/ide/shadow/popup/top.png"); // 1x4

      }
      public static final Icon Right = IconLoader.getIcon("/ide/shadow/right.svg"); // 11x4
      public static final Icon Top_left = IconLoader.getIcon("/ide/shadow/top-left.svg"); // 18x14
      public static final Icon Top_right = IconLoader.getIcon("/ide/shadow/top-right.svg"); // 18x14
      public static final Icon Top = IconLoader.getIcon("/ide/shadow/top.svg"); // 4x7

    }
    public static final Icon Statusbar_arrows = IconLoader.getIcon("/ide/statusbar_arrows.png"); // 7x10
    public static final Icon UpDown = IconLoader.getIcon("/ide/upDown.png"); // 16x16
    public static final Icon Warning_notifications = IconLoader.getIcon("/ide/warning_notifications.png"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Ide.FatalError_read */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon EmptyFatalError = AllIcons.Ide.FatalError_read;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Ide.FatalError */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Error = AllIcons.Ide.FatalError;

  }
  public static final Icon Idea_logo_background = IconLoader.getIcon("/idea_logo_background.png"); // 500x500
  public static final Icon Idea_logo_welcome = IconLoader.getIcon("/idea_logo_welcome.png"); // 100x100

  public final static class Javaee {
    public static final Icon Application_xml = IconLoader.getIcon("/javaee/application_xml.svg"); // 16x16
    public static final Icon BuildOnFrameDeactivation = IconLoader.getIcon("/javaee/buildOnFrameDeactivation.svg"); // 16x16
    public static final Icon Ejb_jar_xml = IconLoader.getIcon("/javaee/ejb-jar_xml.svg"); // 16x16
    public static final Icon EjbClass = IconLoader.getIcon("/javaee/ejbClass.svg"); // 16x16
    public static final Icon EjbModule = IconLoader.getIcon("/javaee/ejbModule.svg"); // 16x16
    public static final Icon EmbeddedAttributeOverlay = IconLoader.getIcon("/javaee/embeddedAttributeOverlay.svg"); // 16x16
    public static final Icon EntityBean = IconLoader.getIcon("/javaee/entityBean.svg"); // 16x16
    public static final Icon Home = IconLoader.getIcon("/javaee/home.svg"); // 16x16
    public static final Icon InheritedAttributeOverlay = IconLoader.getIcon("/javaee/inheritedAttributeOverlay.svg"); // 16x16
    public static final Icon InterceptorClass = IconLoader.getIcon("/javaee/interceptorClass.svg"); // 16x16
    public static final Icon InterceptorMethod = IconLoader.getIcon("/javaee/interceptorMethod.svg"); // 16x16
    public static final Icon JavaeeAppModule = IconLoader.getIcon("/javaee/JavaeeAppModule.svg"); // 16x16
    public static final Icon JpaFacet = IconLoader.getIcon("/javaee/jpaFacet.svg"); // 16x16
    public static final Icon MessageBean = IconLoader.getIcon("/javaee/messageBean.svg"); // 16x16
    public static final Icon PersistenceAttribute = IconLoader.getIcon("/javaee/persistenceAttribute.svg"); // 16x16
    public static final Icon PersistenceEmbeddable = IconLoader.getIcon("/javaee/persistenceEmbeddable.svg"); // 16x16
    public static final Icon PersistenceEntity = IconLoader.getIcon("/javaee/persistenceEntity.svg"); // 16x16
    public static final Icon PersistenceEntityListener = IconLoader.getIcon("/javaee/persistenceEntityListener.svg"); // 16x16
    public static final Icon PersistenceId = IconLoader.getIcon("/javaee/persistenceId.svg"); // 16x16
    public static final Icon PersistenceIdRelationship = IconLoader.getIcon("/javaee/persistenceIdRelationship.svg"); // 16x16
    public static final Icon PersistenceMappedSuperclass = IconLoader.getIcon("/javaee/persistenceMappedSuperclass.svg"); // 16x16
    public static final Icon PersistenceRelationship = IconLoader.getIcon("/javaee/persistenceRelationship.svg"); // 16x16
    public static final Icon PersistenceUnit = IconLoader.getIcon("/javaee/persistenceUnit.svg"); // 16x16
    public static final Icon Remote = IconLoader.getIcon("/javaee/remote.svg"); // 16x16
    public static final Icon SessionBean = IconLoader.getIcon("/javaee/sessionBean.svg"); // 16x16
    public static final Icon UpdateRunningApplication = IconLoader.getIcon("/javaee/updateRunningApplication.svg"); // 16x16
    public static final Icon Web_xml = IconLoader.getIcon("/javaee/web_xml.svg"); // 16x16
    public static final Icon WebModule = IconLoader.getIcon("/javaee/webModule.svg"); // 16x16
    public static final Icon WebModuleGroup = IconLoader.getIcon("/javaee/webModuleGroup.svg"); // 16x16
    public static final Icon WebService = IconLoader.getIcon("/javaee/WebService.svg"); // 16x16
    public static final Icon WebServiceClient = IconLoader.getIcon("/javaee/WebServiceClient.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon DataSourceImport = IconLoader.getIcon("/javaee/dataSourceImport.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon DbSchemaImportBig = IconLoader.getIcon("/javaee/dbSchemaImportBig.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon EntityBeanBig = IconLoader.getIcon("/javaee/entityBeanBig.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Interface */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Local = AllIcons.Nodes.Interface;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Javaee.Home */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon LocalHome = AllIcons.Javaee.Home;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Javaee.WebService */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon WebService2 = AllIcons.Javaee.WebService;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Javaee.WebServiceClient */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon WebServiceClient2 = AllIcons.Javaee.WebServiceClient;

  }

  public final static class Json {
    public static final Icon Array = IconLoader.getIcon("/json/array.png"); // 16x16
    public static final Icon Object = IconLoader.getIcon("/json/object.png"); // 16x16
    public static final Icon Property_braces = IconLoader.getIcon("/json/property_braces.png"); // 16x16
    public static final Icon Property_brackets = IconLoader.getIcon("/json/property_brackets.png"); // 16x16

  }
  public static final Icon Logo_welcomeScreen = IconLoader.getIcon("/Logo_welcomeScreen.png"); // 80x80
  public static final Icon Logo_welcomeScreen_CE = IconLoader.getIcon("/Logo_welcomeScreen_CE.png"); // 80x80

  public final static class Mac {
    public static final Icon AppIconOk512 = IconLoader.getIcon("/mac/appIconOk512.png"); // 55x55
    public static final Icon Text = IconLoader.getIcon("/mac/text.png"); // 32x32
    public static final Icon Tree_black_right_arrow = IconLoader.getIcon("/mac/tree_black_right_arrow.png"); // 11x11
    public static final Icon Tree_white_down_arrow = IconLoader.getIcon("/mac/tree_white_down_arrow.png"); // 11x11
    public static final Icon Tree_white_right_arrow = IconLoader.getIcon("/mac/tree_white_right_arrow.png"); // 11x11
    public static final Icon YosemiteOptionButtonSelector = IconLoader.getIcon("/mac/yosemiteOptionButtonSelector.png"); // 8x12

  }

  public final static class Modules {
    public static final Icon AddExcludedRoot = IconLoader.getIcon("/modules/addExcludedRoot.svg"); // 16x16
    public static final Icon Annotation = IconLoader.getIcon("/modules/annotation.svg"); // 16x16
    public static final Icon DeleteContentFolder = IconLoader.getIcon("/modules/deleteContentFolder.png"); // 9x9
    public static final Icon DeleteContentFolderRollover = IconLoader.getIcon("/modules/deleteContentFolderRollover.png"); // 9x9
    public static final Icon DeleteContentRoot = IconLoader.getIcon("/modules/deleteContentRoot.png"); // 9x9
    public static final Icon DeleteContentRootRollover = IconLoader.getIcon("/modules/deleteContentRootRollover.png"); // 9x9
    public static final Icon EditFolder = IconLoader.getIcon("/modules/editFolder.svg"); // 16x16
    public static final Icon ExcludedGeneratedRoot = IconLoader.getIcon("/modules/excludedGeneratedRoot.svg"); // 16x16
    public static final Icon ExcludeRoot = IconLoader.getIcon("/modules/excludeRoot.svg"); // 16x16
    public static final Icon GeneratedFolder = IconLoader.getIcon("/modules/generatedFolder.svg"); // 16x16
    public static final Icon GeneratedSourceRoot = IconLoader.getIcon("/modules/generatedSourceRoot.svg"); // 16x16
    public static final Icon GeneratedTestRoot = IconLoader.getIcon("/modules/generatedTestRoot.svg"); // 16x16
    public static final Icon Output = IconLoader.getIcon("/modules/output.svg"); // 16x16
    public static final Icon ResourcesRoot = IconLoader.getIcon("/modules/resourcesRoot.svg"); // 16x16
    public static final Icon SourceRoot = IconLoader.getIcon("/modules/sourceRoot.svg"); // 16x16
    public static final Icon SourceRootFileLayer = IconLoader.getIcon("/modules/sourceRootFileLayer.png"); // 16x16
    public static final Icon Split = IconLoader.getIcon("/modules/split.svg"); // 16x16
    public static final Icon TestResourcesRoot = IconLoader.getIcon("/modules/testResourcesRoot.svg"); // 16x16
    public static final Icon TestRoot = IconLoader.getIcon("/modules/testRoot.svg"); // 16x16

    public final static class Types {

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.User */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon UserDefined = AllIcons.General.User;

    }
    public static final Icon UnloadedModule = IconLoader.getIcon("/modules/unloadedModule.svg"); // 16x16
    public static final Icon UnmarkWebroot = IconLoader.getIcon("/modules/unmarkWebroot.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Add */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AddContentEntry = AllIcons.General.Add;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Edit */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Edit = AllIcons.Actions.Edit;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.PpLib */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Library = AllIcons.Nodes.PpLib;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Vcs.Merge */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Merge = AllIcons.Vcs.Merge;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.ModuleGroup */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ModulesNode = AllIcons.Nodes.ModuleGroup;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Inline_edit */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SetPackagePrefix = AllIcons.General.Inline_edit;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Inline_edit_hovered */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SetPackagePrefixRollover = AllIcons.General.Inline_edit_hovered;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Package */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SourceFolder = AllIcons.Nodes.Package;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Sources = IconLoader.getIcon("/modules/sources.svg");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.TestSourceFolder */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestSourceFolder = AllIcons.Nodes.TestSourceFolder;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.WebFolder */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon WebRoot = AllIcons.Nodes.WebFolder;

  }

  public final static class Nodes {
    public static final Icon AbstractClass = IconLoader.getIcon("/nodes/abstractClass.svg"); // 16x16
    public static final Icon AbstractException = IconLoader.getIcon("/nodes/abstractException.svg"); // 16x16
    public static final Icon AbstractMethod = IconLoader.getIcon("/nodes/abstractMethod.svg"); // 16x16
    public static final Icon Annotationtype = IconLoader.getIcon("/nodes/annotationtype.svg"); // 16x16
    public static final Icon AnonymousClass = IconLoader.getIcon("/nodes/anonymousClass.svg"); // 16x16
    public static final Icon Artifact = IconLoader.getIcon("/nodes/artifact.svg"); // 16x16
    public static final Icon Aspect = IconLoader.getIcon("/nodes/aspect.svg"); // 16x16
    public static final Icon C_plocal = IconLoader.getIcon("/nodes/c_plocal.svg"); // 16x16
    public static final Icon C_private = IconLoader.getIcon("/nodes/c_private.svg"); // 16x16
    public static final Icon C_protected = IconLoader.getIcon("/nodes/c_protected.svg"); // 16x16
    public static final Icon C_public = IconLoader.getIcon("/nodes/c_public.svg"); // 16x16
    public static final Icon Class = IconLoader.getIcon("/nodes/class.svg"); // 16x16
    public static final Icon ClassInitializer = IconLoader.getIcon("/nodes/classInitializer.svg"); // 16x16
    public static final Icon CompiledClassesFolder = IconLoader.getIcon("/nodes/compiledClassesFolder.svg"); // 16x16
    public static final Icon Constant = IconLoader.getIcon("/nodes/constant.svg"); // 16x16
    public static final Icon CopyOfFolder = IconLoader.getIcon("/nodes/copyOfFolder.svg"); // 16x16
    public static final Icon CustomRegion = IconLoader.getIcon("/nodes/customRegion.svg"); // 16x16
    public static final Icon Cvs_global = IconLoader.getIcon("/nodes/cvs_global.svg"); // 16x16
    public static final Icon Cvs_roots = IconLoader.getIcon("/nodes/cvs_roots.svg"); // 16x16
    public static final Icon DataColumn = IconLoader.getIcon("/nodes/dataColumn.svg"); // 16x16
    public static final Icon DataSchema = IconLoader.getIcon("/nodes/dataSchema.svg"); // 16x16
    public static final Icon DataSource = IconLoader.getIcon("/nodes/DataSource.svg"); // 16x16
    public static final Icon DataTables = IconLoader.getIcon("/nodes/DataTables.svg"); // 16x16
    public static final Icon DataView = IconLoader.getIcon("/nodes/dataView.svg"); // 16x16
    public static final Icon Deploy = IconLoader.getIcon("/nodes/deploy.svg"); // 16x16
    public static final Icon Desktop = IconLoader.getIcon("/nodes/desktop.svg"); // 16x16
    public static final Icon Ejb = IconLoader.getIcon("/nodes/ejb.svg"); // 16x16
    public static final Icon EjbBusinessMethod = IconLoader.getIcon("/nodes/ejbBusinessMethod.svg"); // 16x16
    public static final Icon EjbCmpField = IconLoader.getIcon("/nodes/ejbCmpField.svg"); // 16x16
    public static final Icon EjbCmrField = IconLoader.getIcon("/nodes/ejbCmrField.svg"); // 16x16
    public static final Icon EjbCreateMethod = IconLoader.getIcon("/nodes/ejbCreateMethod.svg"); // 16x16
    public static final Icon EjbFinderMethod = IconLoader.getIcon("/nodes/ejbFinderMethod.svg"); // 16x16
    public static final Icon EjbPrimaryKeyClass = IconLoader.getIcon("/nodes/ejbPrimaryKeyClass.svg"); // 16x16
    public static final Icon EjbReference = IconLoader.getIcon("/nodes/ejbReference.svg"); // 16x16
    public static final Icon EmptyNode = IconLoader.getIcon("/nodes/emptyNode.svg"); // 16x16
    public static final Icon EnterpriseProject = IconLoader.getIcon("/nodes/enterpriseProject.svg"); // 16x16
    public static final Icon EntryPoints = IconLoader.getIcon("/nodes/entryPoints.svg"); // 16x16
    public static final Icon Enum = IconLoader.getIcon("/nodes/enum.svg"); // 16x16
    public static final Icon ErrorIntroduction = IconLoader.getIcon("/nodes/errorIntroduction.svg"); // 16x16
    public static final Icon ErrorMark = IconLoader.getIcon("/nodes/errorMark.svg"); // 16x16
    public static final Icon ExceptionClass = IconLoader.getIcon("/nodes/exceptionClass.svg"); // 16x16
    public static final Icon ExcludedFromCompile = IconLoader.getIcon("/nodes/excludedFromCompile.svg"); // 16x16
    public static final Icon ExtractedFolder = IconLoader.getIcon("/nodes/extractedFolder.svg"); // 16x16
    public static final Icon Favorite = IconLoader.getIcon("/nodes/favorite.svg"); // 16x16
    public static final Icon Field = IconLoader.getIcon("/nodes/field.svg"); // 16x16
    public static final Icon FieldPK = IconLoader.getIcon("/nodes/fieldPK.svg"); // 16x16
    public static final Icon FinalMark = IconLoader.getIcon("/nodes/finalMark.svg"); // 16x16
    public static final Icon Folder = IconLoader.getIcon("/nodes/folder.svg"); // 16x16
    public static final Icon Function = IconLoader.getIcon("/nodes/function.svg"); // 16x16
    public static final Icon HomeFolder = IconLoader.getIcon("/nodes/homeFolder.svg"); // 16x16
    public static final Icon IdeaModule = IconLoader.getIcon("/nodes/ideaModule.svg"); // 16x16
    public static final Icon IdeaProject = IconLoader.getIcon("/nodes/ideaProject.svg"); // 16x16
    public static final Icon InspectionResults = IconLoader.getIcon("/nodes/inspectionResults.svg"); // 16x16
    public static final Icon Interface = IconLoader.getIcon("/nodes/interface.svg"); // 16x16
    public static final Icon J2eeParameter = IconLoader.getIcon("/nodes/j2eeParameter.svg"); // 16x16
    public static final Icon JarDirectory = IconLoader.getIcon("/nodes/jarDirectory.svg"); // 16x16
    public static final Icon JavaDocFolder = IconLoader.getIcon("/nodes/javaDocFolder.svg"); // 16x16
    public static final Icon JavaModule = IconLoader.getIcon("/nodes/javaModule.svg"); // 16x16
    public static final Icon JavaModuleRoot = IconLoader.getIcon("/nodes/javaModuleRoot.svg"); // 16x16

    public final static class Jsf {
      public static final Icon Component = IconLoader.getIcon("/nodes/jsf/component.svg"); // 16x16
      public static final Icon Converter = IconLoader.getIcon("/nodes/jsf/converter.svg"); // 16x16
      public static final Icon General = IconLoader.getIcon("/nodes/jsf/general.svg"); // 16x16
      public static final Icon ManagedBean = IconLoader.getIcon("/nodes/jsf/managedBean.svg"); // 16x16
      public static final Icon NavigationRule = IconLoader.getIcon("/nodes/jsf/navigationRule.svg"); // 16x16
      public static final Icon Renderer = IconLoader.getIcon("/nodes/jsf/renderer.svg"); // 16x16
      public static final Icon RenderKit = IconLoader.getIcon("/nodes/jsf/renderKit.svg"); // 16x16
      public static final Icon Validator = IconLoader.getIcon("/nodes/jsf/validator.svg"); // 16x16

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Parameter */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon GenericValue = AllIcons.Nodes.Parameter;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.UpFolder */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon NavigationCase = AllIcons.Nodes.UpFolder;

    }
    public static final Icon Jsr45 = IconLoader.getIcon("/nodes/jsr45.svg"); // 16x16
    public static final Icon JunitTestMark = IconLoader.getIcon("/nodes/junitTestMark.svg"); // 16x16
    public static final Icon KeymapAnt = IconLoader.getIcon("/nodes/keymapAnt.svg"); // 16x16
    public static final Icon KeymapEditor = IconLoader.getIcon("/nodes/keymapEditor.svg"); // 16x16
    public static final Icon KeymapMainMenu = IconLoader.getIcon("/nodes/keymapMainMenu.svg"); // 16x16
    public static final Icon KeymapOther = IconLoader.getIcon("/nodes/keymapOther.svg"); // 16x16
    public static final Icon KeymapTools = IconLoader.getIcon("/nodes/keymapTools.svg"); // 16x16
    public static final Icon Locked = IconLoader.getIcon("/nodes/locked.svg"); // 16x16
    public static final Icon Method = IconLoader.getIcon("/nodes/method.svg"); // 16x16
    public static final Icon MethodReference = IconLoader.getIcon("/nodes/methodReference.svg"); // 16x16
    public static final Icon Module = IconLoader.getIcon("/nodes/Module.svg"); // 16x16
    public static final Icon ModuleGroup = IconLoader.getIcon("/nodes/moduleGroup.svg"); // 16x16
    public static final Icon NativeLibrariesFolder = IconLoader.getIcon("/nodes/nativeLibrariesFolder.svg"); // 16x16
    public static final Icon NewParameter = IconLoader.getIcon("/nodes/newParameter.svg"); // 16x16
    public static final Icon NodePlaceholder = IconLoader.getIcon("/nodes/nodePlaceholder.svg"); // 16x16
    public static final Icon NotFavoriteOnHover = IconLoader.getIcon("/nodes/notFavoriteOnHover.svg"); // 16x16
    public static final Icon ObjectTypeAttribute = IconLoader.getIcon("/nodes/objectTypeAttribute.svg"); // 16x16
    public static final Icon Package = IconLoader.getIcon("/nodes/package.svg"); // 16x16
    public static final Icon Padlock = IconLoader.getIcon("/nodes/padlock.svg"); // 16x16
    public static final Icon Parameter = IconLoader.getIcon("/nodes/parameter.svg"); // 16x16
    public static final Icon Plugin = IconLoader.getIcon("/nodes/plugin.svg"); // 16x16
    public static final Icon PluginJB = IconLoader.getIcon("/nodes/pluginJB.svg"); // 16x16
    public static final Icon PluginLogo = IconLoader.getIcon("/nodes/pluginLogo.svg"); // 32x32
    public static final Icon Pluginnotinstalled = IconLoader.getIcon("/nodes/pluginnotinstalled.svg"); // 16x16
    public static final Icon Pluginobsolete = IconLoader.getIcon("/nodes/pluginobsolete.svg"); // 16x16
    public static final Icon PluginRestart = IconLoader.getIcon("/nodes/pluginRestart.svg"); // 16x16
    public static final Icon PpInvalid = IconLoader.getIcon("/nodes/ppInvalid.svg"); // 16x16
    public static final Icon PpJar = IconLoader.getIcon("/nodes/ppJar.svg"); // 16x16
    public static final Icon PpJdk = IconLoader.getIcon("/nodes/ppJdk.svg"); // 16x16
    public static final Icon PpLib = IconLoader.getIcon("/nodes/ppLib.svg"); // 16x16
    public static final Icon PpLibFolder = IconLoader.getIcon("/nodes/ppLibFolder.svg"); // 16x16
    public static final Icon PpWeb = IconLoader.getIcon("/nodes/ppWeb.svg"); // 16x16
    public static final Icon Project = IconLoader.getIcon("/nodes/project.svg"); // 16x16
    public static final Icon Property = IconLoader.getIcon("/nodes/property.svg"); // 16x16
    public static final Icon PropertyRead = IconLoader.getIcon("/nodes/propertyRead.svg"); // 16x16
    public static final Icon PropertyReadStatic = IconLoader.getIcon("/nodes/propertyReadStatic.svg"); // 16x16
    public static final Icon PropertyReadWrite = IconLoader.getIcon("/nodes/propertyReadWrite.svg"); // 16x16
    public static final Icon PropertyReadWriteStatic = IconLoader.getIcon("/nodes/propertyReadWriteStatic.svg"); // 16x16
    public static final Icon PropertyWrite = IconLoader.getIcon("/nodes/propertyWrite.svg"); // 16x16
    public static final Icon PropertyWriteStatic = IconLoader.getIcon("/nodes/propertyWriteStatic.svg"); // 16x16
    public static final Icon Read_access = IconLoader.getIcon("/nodes/read-access.svg"); // 16x16
    public static final Icon ResourceBundle = IconLoader.getIcon("/nodes/resourceBundle.svg"); // 16x16
    public static final Icon RunnableMark = IconLoader.getIcon("/nodes/runnableMark.svg"); // 16x16
    public static final Icon Rw_access = IconLoader.getIcon("/nodes/rw-access.svg"); // 16x16
    public static final Icon SecurityRole = IconLoader.getIcon("/nodes/securityRole.svg"); // 16x16
    public static final Icon Servlet = IconLoader.getIcon("/nodes/servlet.svg"); // 16x16
    public static final Icon Shared = IconLoader.getIcon("/nodes/shared.svg"); // 16x16
    public static final Icon SortBySeverity = IconLoader.getIcon("/nodes/sortBySeverity.svg"); // 16x16
    public static final Icon Static = IconLoader.getIcon("/nodes/static.svg"); // 16x16
    public static final Icon StaticMark = IconLoader.getIcon("/nodes/staticMark.svg"); // 16x16
    public static final Icon Symlink = IconLoader.getIcon("/nodes/symlink.svg"); // 16x16
    public static final Icon TabAlert = IconLoader.getIcon("/nodes/tabAlert.svg"); // 16x16
    public static final Icon TabPin = IconLoader.getIcon("/nodes/tabPin.svg"); // 16x16
    public static final Icon Tag = IconLoader.getIcon("/nodes/tag.svg"); // 16x16
    public static final Icon Test = IconLoader.getIcon("/nodes/test.svg"); // 16x16
    public static final Icon TestGroup = IconLoader.getIcon("/nodes/testGroup.svg"); // 16x16
    public static final Icon TestIgnored = IconLoader.getIcon("/nodes/testIgnored.svg"); // 16x16
    public static final Icon TestSourceFolder = IconLoader.getIcon("/nodes/testSourceFolder.svg"); // 16x16
    public static final Icon Type = IconLoader.getIcon("/nodes/type.svg"); // 16x16
    public static final Icon Undeploy = IconLoader.getIcon("/nodes/undeploy.svg"); // 16x16
    public static final Icon UnknownJdk = IconLoader.getIcon("/nodes/unknownJdk.svg"); // 16x16
    public static final Icon UpFolder = IconLoader.getIcon("/nodes/upFolder.svg"); // 16x16
    public static final Icon UpLevel = IconLoader.getIcon("/nodes/upLevel.svg"); // 16x16
    public static final Icon Variable = IconLoader.getIcon("/nodes/variable.svg"); // 16x16
    public static final Icon WarningIntroduction = IconLoader.getIcon("/nodes/warningIntroduction.svg"); // 16x16
    public static final Icon WebFolder = IconLoader.getIcon("/nodes/webFolder.svg"); // 16x16
    public static final Icon Weblistener = IconLoader.getIcon("/nodes/weblistener.svg"); // 16x16
    public static final Icon Write_access = IconLoader.getIcon("/nodes/write-access.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Tag */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Advice = AllIcons.Nodes.Tag;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CollapseNode = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon DisabledPointcut = IconLoader.getIcon("/nodes/disabledPointcut.svg");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowRight */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ExpandNode = AllIcons.General.ArrowRight;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Favorite */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon FavoriteOnHover = AllIcons.Nodes.Favorite;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon NewException = IconLoader.getIcon("/nodes/newException.svg");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Folder */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon NewFolder = AllIcons.Nodes.Folder;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.TabPin */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon PinToolWindow = AllIcons.Nodes.TabPin;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon PluginUpdate = IconLoader.getIcon("/nodes/pluginUpdate.svg");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Pointcut = IconLoader.getIcon("/nodes/pointcut.svg");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Folder */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon PpFile = AllIcons.Nodes.Folder;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon PpWebLogo = IconLoader.getIcon("/nodes/ppWebLogo.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Package */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SourceFolder = AllIcons.Nodes.Package;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Folder */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TreeClosed = AllIcons.Nodes.Folder;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TreeCollapseNode = AllIcons.General.ArrowDown;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TreeDownArrow = IconLoader.getIcon("/nodes/treeDownArrow.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.ArrowRight */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TreeExpandNode = AllIcons.General.ArrowRight;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Folder */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TreeOpen = AllIcons.Nodes.Folder;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TreeRightArrow = IconLoader.getIcon("/nodes/treeRightArrow.png");

  }

  public final static class ObjectBrowser {
    public static final Icon AbbreviatePackageNames = IconLoader.getIcon("/objectBrowser/abbreviatePackageNames.png"); // 16x16
    public static final Icon CompactEmptyPackages = IconLoader.getIcon("/objectBrowser/compactEmptyPackages.svg"); // 16x16
    public static final Icon FlattenModules = IconLoader.getIcon("/objectBrowser/flattenModules.svg"); // 16x16
    public static final Icon FlattenPackages = IconLoader.getIcon("/objectBrowser/flattenPackages.svg"); // 16x16
    public static final Icon ShowEditorHighlighting = IconLoader.getIcon("/objectBrowser/showEditorHighlighting.png"); // 16x16
    public static final Icon ShowLibraryContents = IconLoader.getIcon("/objectBrowser/showLibraryContents.png"); // 16x16
    public static final Icon ShowMembers = IconLoader.getIcon("/objectBrowser/showMembers.png"); // 16x16
    public static final Icon SortByType = IconLoader.getIcon("/objectBrowser/sortByType.svg"); // 16x16
    public static final Icon Sorted = IconLoader.getIcon("/objectBrowser/sorted.svg"); // 16x16
    public static final Icon SortedByUsage = IconLoader.getIcon("/objectBrowser/sortedByUsage.svg"); // 16x16
    public static final Icon VisibilitySort = IconLoader.getIcon("/objectBrowser/visibilitySort.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.GroupByModule */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ShowModules = AllIcons.Actions.GroupByModule;

  }

  public final static class Plugins {
    public static final Icon Downloads = IconLoader.getIcon("/plugins/downloads.svg"); // 12x12
    public static final Icon ModifierInvalid = IconLoader.getIcon("/plugins/modifierInvalid.svg"); // 15x15
    public static final Icon ModifierJBLogo = IconLoader.getIcon("/plugins/modifierJBLogo.svg"); // 14x14
    public static final Icon PluginLogo = IconLoader.getIcon("/plugins/pluginLogo.svg"); // 40x40
    public static final Icon PluginLogo_40 = IconLoader.getIcon("/plugins/pluginLogo_40.png"); // 40x40
    public static final Icon PluginLogo_80 = IconLoader.getIcon("/plugins/pluginLogo_80.png"); // 80x80
    public static final Icon PluginLogoDisabled_40 = IconLoader.getIcon("/plugins/pluginLogoDisabled_40.png"); // 40x40
    public static final Icon PluginLogoDisabled_80 = IconLoader.getIcon("/plugins/pluginLogoDisabled_80.png"); // 80x80
    public static final Icon Rating = IconLoader.getIcon("/plugins/rating.svg"); // 12x12
    public static final Icon Updated = IconLoader.getIcon("/plugins/updated.svg"); // 12x12

  }

  public final static class Preferences {
    public static final Icon Appearance = IconLoader.getIcon("/preferences/Appearance.png"); // 32x32
    public static final Icon CodeStyle = IconLoader.getIcon("/preferences/CodeStyle.png"); // 32x32
    public static final Icon Compiler = IconLoader.getIcon("/preferences/Compiler.png"); // 32x32
    public static final Icon Editor = IconLoader.getIcon("/preferences/Editor.png"); // 32x32
    public static final Icon FileColors = IconLoader.getIcon("/preferences/FileColors.png"); // 32x32
    public static final Icon FileTypes = IconLoader.getIcon("/preferences/FileTypes.png"); // 32x32
    public static final Icon General = IconLoader.getIcon("/preferences/General.png"); // 32x32
    public static final Icon Keymap = IconLoader.getIcon("/preferences/Keymap.png"); // 32x32
    public static final Icon Plugins = IconLoader.getIcon("/preferences/Plugins.png"); // 32x32
    public static final Icon Updates = IconLoader.getIcon("/preferences/Updates.png"); // 32x32
    public static final Icon VersionControl = IconLoader.getIcon("/preferences/VersionControl.png"); // 32x32

  }

  public final static class Process {

    public final static class Big {
      public static final Icon Step_1 = IconLoader.getIcon("/process/big/step_1.svg"); // 32x32
      public static final Icon Step_2 = IconLoader.getIcon("/process/big/step_2.svg"); // 32x32
      public static final Icon Step_3 = IconLoader.getIcon("/process/big/step_3.svg"); // 32x32
      public static final Icon Step_4 = IconLoader.getIcon("/process/big/step_4.svg"); // 32x32
      public static final Icon Step_5 = IconLoader.getIcon("/process/big/step_5.svg"); // 32x32
      public static final Icon Step_6 = IconLoader.getIcon("/process/big/step_6.svg"); // 32x32
      public static final Icon Step_7 = IconLoader.getIcon("/process/big/step_7.svg"); // 32x32
      public static final Icon Step_8 = IconLoader.getIcon("/process/big/step_8.svg"); // 32x32
      public static final Icon Step_passive = IconLoader.getIcon("/process/big/step_passive.svg"); // 32x32

      /** @deprecated to be removed in IDEA 2020 */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Step_10 = IconLoader.getIcon("/process/big/step_4.svg"); // 32x32

      /** @deprecated to be removed in IDEA 2020 */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Step_11 = IconLoader.getIcon("/process/big/step_6.svg"); // 32x32

      /** @deprecated to be removed in IDEA 2020 */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Step_12 = IconLoader.getIcon("/process/big/step_8.svg"); // 32x32

      /** @deprecated to be removed in IDEA 2020 */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Step_9 = IconLoader.getIcon("/process/big/step_2.svg"); // 32x32

    }
    public static final Icon DisabledDebug = IconLoader.getIcon("/process/disabledDebug.png"); // 13x13
    public static final Icon DisabledRun = IconLoader.getIcon("/process/disabledRun.png"); // 13x13

    public final static class FS {
      public static final Icon Step_1 = IconLoader.getIcon("/process/fs/step_1.png"); // 16x16
      public static final Icon Step_10 = IconLoader.getIcon("/process/fs/step_10.png"); // 16x16
      public static final Icon Step_11 = IconLoader.getIcon("/process/fs/step_11.png"); // 16x16
      public static final Icon Step_12 = IconLoader.getIcon("/process/fs/step_12.png"); // 16x16
      public static final Icon Step_13 = IconLoader.getIcon("/process/fs/step_13.png"); // 16x16
      public static final Icon Step_14 = IconLoader.getIcon("/process/fs/step_14.png"); // 16x16
      public static final Icon Step_15 = IconLoader.getIcon("/process/fs/step_15.png"); // 16x16
      public static final Icon Step_16 = IconLoader.getIcon("/process/fs/step_16.png"); // 16x16
      public static final Icon Step_17 = IconLoader.getIcon("/process/fs/step_17.png"); // 16x16
      public static final Icon Step_18 = IconLoader.getIcon("/process/fs/step_18.png"); // 16x16
      public static final Icon Step_2 = IconLoader.getIcon("/process/fs/step_2.png"); // 16x16
      public static final Icon Step_3 = IconLoader.getIcon("/process/fs/step_3.png"); // 16x16
      public static final Icon Step_4 = IconLoader.getIcon("/process/fs/step_4.png"); // 16x16
      public static final Icon Step_5 = IconLoader.getIcon("/process/fs/step_5.png"); // 16x16
      public static final Icon Step_6 = IconLoader.getIcon("/process/fs/step_6.png"); // 16x16
      public static final Icon Step_7 = IconLoader.getIcon("/process/fs/step_7.png"); // 16x16
      public static final Icon Step_8 = IconLoader.getIcon("/process/fs/step_8.png"); // 16x16
      public static final Icon Step_9 = IconLoader.getIcon("/process/fs/step_9.png"); // 16x16
      public static final Icon Step_mask = IconLoader.getIcon("/process/fs/step_mask.png"); // 16x16
      public static final Icon Step_passive = IconLoader.getIcon("/process/fs/step_passive.png"); // 16x16

    }
    public static final Icon ProgressPause = IconLoader.getIcon("/process/progressPause.png"); // 14x14
    public static final Icon ProgressPauseHover = IconLoader.getIcon("/process/progressPauseHover.png"); // 14x14
    public static final Icon ProgressPauseSmall = IconLoader.getIcon("/process/progressPauseSmall.png"); // 12x12
    public static final Icon ProgressPauseSmallHover = IconLoader.getIcon("/process/progressPauseSmallHover.png"); // 12x12
    public static final Icon ProgressResume = IconLoader.getIcon("/process/progressResume.png"); // 14x14
    public static final Icon ProgressResumeHover = IconLoader.getIcon("/process/progressResumeHover.png"); // 14x14
    public static final Icon ProgressResumeSmall = IconLoader.getIcon("/process/progressResumeSmall.png"); // 12x12
    public static final Icon ProgressResumeSmallHover = IconLoader.getIcon("/process/progressResumeSmallHover.png"); // 12x12

    public final static class State {
      public static final Icon GreenOK = IconLoader.getIcon("/process/state/GreenOK.png"); // 16x16
      public static final Icon GreyProgr = IconLoader.getIcon("/process/state/GreyProgr.png"); // 16x16
      public static final Icon GreyProgr_1 = IconLoader.getIcon("/process/state/GreyProgr_1.png"); // 16x16
      public static final Icon GreyProgr_2 = IconLoader.getIcon("/process/state/GreyProgr_2.png"); // 16x16
      public static final Icon GreyProgr_3 = IconLoader.getIcon("/process/state/GreyProgr_3.png"); // 16x16
      public static final Icon GreyProgr_4 = IconLoader.getIcon("/process/state/GreyProgr_4.png"); // 16x16
      public static final Icon GreyProgr_5 = IconLoader.getIcon("/process/state/GreyProgr_5.png"); // 16x16
      public static final Icon GreyProgr_6 = IconLoader.getIcon("/process/state/GreyProgr_6.png"); // 16x16
      public static final Icon GreyProgr_7 = IconLoader.getIcon("/process/state/GreyProgr_7.png"); // 16x16
      public static final Icon GreyProgr_8 = IconLoader.getIcon("/process/state/GreyProgr_8.png"); // 16x16
      public static final Icon RedExcl = IconLoader.getIcon("/process/state/RedExcl.png"); // 16x16
      public static final Icon YellowStr = IconLoader.getIcon("/process/state/YellowStr.png"); // 16x16

    }
    public static final Icon Step_1 = IconLoader.getIcon("/process/step_1.svg"); // 16x16
    public static final Icon Step_2 = IconLoader.getIcon("/process/step_2.svg"); // 16x16
    public static final Icon Step_3 = IconLoader.getIcon("/process/step_3.svg"); // 16x16
    public static final Icon Step_4 = IconLoader.getIcon("/process/step_4.svg"); // 16x16
    public static final Icon Step_5 = IconLoader.getIcon("/process/step_5.svg"); // 16x16
    public static final Icon Step_6 = IconLoader.getIcon("/process/step_6.svg"); // 16x16
    public static final Icon Step_7 = IconLoader.getIcon("/process/step_7.svg"); // 16x16
    public static final Icon Step_8 = IconLoader.getIcon("/process/step_8.svg"); // 16x16
    public static final Icon Step_mask = IconLoader.getIcon("/process/step_mask.svg"); // 16x16
    public static final Icon Step_passive = IconLoader.getIcon("/process/step_passive.svg"); // 16x16
    public static final Icon Stop = IconLoader.getIcon("/process/stop.png"); // 14x14
    public static final Icon StopHovered = IconLoader.getIcon("/process/stopHovered.png"); // 14x14
    public static final Icon StopSmall = IconLoader.getIcon("/process/stopSmall.png"); // 12x12
    public static final Icon StopSmallHovered = IconLoader.getIcon("/process/stopSmallHovered.png"); // 12x12

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Step_10 = IconLoader.getIcon("/process/step_4.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Step_11 = IconLoader.getIcon("/process/step_6.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Step_12 = IconLoader.getIcon("/process/step_8.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Step_9 = IconLoader.getIcon("/process/step_2.svg"); // 16x16

  }

  public final static class Providers {
    public static final Icon Apache = IconLoader.getIcon("/providers/apache.png"); // 16x16
    public static final Icon ApacheDerby = IconLoader.getIcon("/providers/apacheDerby.png"); // 16x16
    public static final Icon Azure = IconLoader.getIcon("/providers/azure.png"); // 16x16
    public static final Icon Bea = IconLoader.getIcon("/providers/bea.png"); // 16x16
    public static final Icon Cassandra = IconLoader.getIcon("/providers/cassandra.svg"); // 16x16
    public static final Icon ClickHouse = IconLoader.getIcon("/providers/clickHouse.svg"); // 16x16
    public static final Icon Cvs = IconLoader.getIcon("/providers/cvs.png"); // 16x16
    public static final Icon DB2 = IconLoader.getIcon("/providers/DB2.png"); // 16x16
    public static final Icon Eclipse = IconLoader.getIcon("/providers/eclipse.png"); // 16x16
    public static final Icon Exasol = IconLoader.getIcon("/providers/exasol.png"); // 16x16
    public static final Icon H2 = IconLoader.getIcon("/providers/h2.png"); // 16x16
    public static final Icon Hibernate = IconLoader.getIcon("/providers/hibernate.png"); // 16x16
    public static final Icon Hsqldb = IconLoader.getIcon("/providers/hsqldb.png"); // 16x16
    public static final Icon Ibm = IconLoader.getIcon("/providers/ibm.png"); // 16x16
    public static final Icon Mariadb = IconLoader.getIcon("/providers/mariadb.png"); // 16x16
    public static final Icon Microsoft = IconLoader.getIcon("/providers/microsoft.png"); // 16x16
    public static final Icon Mysql = IconLoader.getIcon("/providers/mysql.png"); // 16x16
    public static final Icon Oracle = IconLoader.getIcon("/providers/oracle.png"); // 16x16
    public static final Icon Postgresql = IconLoader.getIcon("/providers/postgresql.png"); // 16x16
    public static final Icon Redshift = IconLoader.getIcon("/providers/redshift.png"); // 16x16
    public static final Icon Sqlite = IconLoader.getIcon("/providers/sqlite.png"); // 16x16
    public static final Icon SqlServer = IconLoader.getIcon("/providers/sqlServer.png"); // 16x16
    public static final Icon Sun = IconLoader.getIcon("/providers/sun.png"); // 16x16
    public static final Icon Sybase = IconLoader.getIcon("/providers/sybase.png"); // 16x16

  }

  public final static class RunConfigurations {
    public static final Icon Applet = IconLoader.getIcon("/runConfigurations/applet.svg"); // 16x16
    public static final Icon Application = IconLoader.getIcon("/runConfigurations/application.svg"); // 16x16
    public static final Icon HidePassed = IconLoader.getIcon("/runConfigurations/hidePassed.svg"); // 16x16
    public static final Icon IgnoredTest = IconLoader.getIcon("/runConfigurations/ignoredTest.svg"); // 16x16
    public static final Icon InvalidConfigurationLayer = IconLoader.getIcon("/runConfigurations/invalidConfigurationLayer.svg"); // 16x16
    public static final Icon Junit = IconLoader.getIcon("/runConfigurations/junit.svg"); // 16x16
    public static final Icon Remote = IconLoader.getIcon("/runConfigurations/remote.svg"); // 16x16
    public static final Icon RerunFailedTests = IconLoader.getIcon("/runConfigurations/rerunFailedTests.svg"); // 16x16
    public static final Icon Scroll_down = IconLoader.getIcon("/runConfigurations/scroll_down.svg"); // 16x16
    public static final Icon ShowIgnored = IconLoader.getIcon("/runConfigurations/showIgnored.svg"); // 16x16
    public static final Icon ShowPassed = IconLoader.getIcon("/runConfigurations/showPassed.svg"); // 16x16
    public static final Icon SortbyDuration = IconLoader.getIcon("/runConfigurations/sortbyDuration.svg"); // 16x16
    public static final Icon TestCustom = IconLoader.getIcon("/runConfigurations/testCustom.svg"); // 16x16
    public static final Icon TestError = IconLoader.getIcon("/runConfigurations/testError.svg"); // 16x16
    public static final Icon TestFailed = IconLoader.getIcon("/runConfigurations/testFailed.svg"); // 16x16
    public static final Icon TestIgnored = IconLoader.getIcon("/runConfigurations/testIgnored.svg"); // 16x16
    public static final Icon TestMark = IconLoader.getIcon("/runConfigurations/testMark.svg"); // 16x16
    public static final Icon TestNotRan = IconLoader.getIcon("/runConfigurations/testNotRan.svg"); // 16x16
    public static final Icon TestPassed = IconLoader.getIcon("/runConfigurations/testPassed.svg"); // 16x16
    public static final Icon TestPaused = IconLoader.getIcon("/runConfigurations/testPaused.svg"); // 16x16
    public static final Icon TestSkipped = IconLoader.getIcon("/runConfigurations/testSkipped.svg"); // 16x16

    public final static class TestState {
      public static final Icon Green2 = IconLoader.getIcon("/runConfigurations/testState/green2.png"); // 12x12
      public static final Icon Red2 = IconLoader.getIcon("/runConfigurations/testState/red2.png"); // 12x12
      public static final Icon Run = IconLoader.getIcon("/runConfigurations/testState/run.png"); // 12x12
      public static final Icon Run_run = IconLoader.getIcon("/runConfigurations/testState/run_run.png"); // 12x12
      public static final Icon Yellow2 = IconLoader.getIcon("/runConfigurations/testState/yellow2.png"); // 12x12

    }
    public static final Icon TestTerminated = IconLoader.getIcon("/runConfigurations/testTerminated.svg"); // 16x16
    public static final Icon TestUnknown = IconLoader.getIcon("/runConfigurations/testUnknown.svg"); // 16x16
    public static final Icon Tomcat = IconLoader.getIcon("/runConfigurations/tomcat.svg"); // 16x16
    public static final Icon ToolbarError = IconLoader.getIcon("/runConfigurations/toolbarError.svg"); // 16x16
    public static final Icon ToolbarFailed = IconLoader.getIcon("/runConfigurations/toolbarFailed.svg"); // 16x16
    public static final Icon ToolbarPassed = IconLoader.getIcon("/runConfigurations/toolbarPassed.svg"); // 16x16
    public static final Icon ToolbarSkipped = IconLoader.getIcon("/runConfigurations/toolbarSkipped.svg"); // 16x16
    public static final Icon ToolbarTerminated = IconLoader.getIcon("/runConfigurations/toolbarTerminated.svg"); // 16x16
    public static final Icon TrackCoverage = IconLoader.getIcon("/runConfigurations/trackCoverage.svg"); // 16x16
    public static final Icon Web_app = IconLoader.getIcon("/runConfigurations/web_app.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.BalloonError */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ConfigurationWarning = AllIcons.General.BalloonError;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon HideIgnored = IconLoader.getIcon("/runConfigurations/hideIgnored.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon IncludeNonStartedTests_Rerun = IconLoader.getIcon("/runConfigurations/includeNonStartedTests_Rerun.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon LoadingTree = IconLoader.getIcon("/runConfigurations/loadingTree.png");

    /** @deprecated to be removed in IDEA 2020 - use DatabaseIcons.ConsoleRun */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Ql_console = IconLoader.getIcon("/runConfigurations/ql_console.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Menu_saveall */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SaveTempConfig = AllIcons.Actions.Menu_saveall;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ScrollToStackTrace = IconLoader.getIcon("/runConfigurations/scrollToStackTrace.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SelectFirstDefect = IconLoader.getIcon("/runConfigurations/selectFirstDefect.png");

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon SourceAtException = IconLoader.getIcon("/runConfigurations/sourceAtException.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Process.Step_1 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestInProgress1 = AllIcons.Process.Step_1;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Process.Step_2 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestInProgress2 = AllIcons.Process.Step_2;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Process.Step_3 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestInProgress3 = AllIcons.Process.Step_3;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Process.Step_4 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestInProgress4 = AllIcons.Process.Step_4;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Process.Step_5 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestInProgress5 = AllIcons.Process.Step_5;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Process.Step_6 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestInProgress6 = AllIcons.Process.Step_6;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Process.Step_7 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestInProgress7 = AllIcons.Process.Step_7;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Process.Step_8 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TestInProgress8 = AllIcons.Process.Step_8;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Nodes.Jsf.Renderer */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon TrackTests = AllIcons.Nodes.Jsf.Renderer;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Help */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Unknown = AllIcons.Actions.Help;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.ListFiles */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Variables = AllIcons.Actions.ListFiles;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon WithCoverageLayer = IconLoader.getIcon("/runConfigurations/withCoverageLayer.png");

  }

  public final static class Scope {
    public static final Icon ChangedFiles = IconLoader.getIcon("/scope/changedFiles.svg"); // 16x16
    public static final Icon ChangedFilesAll = IconLoader.getIcon("/scope/changedFilesAll.svg"); // 16x16
    public static final Icon Problems = IconLoader.getIcon("/scope/problems.svg"); // 16x16
    public static final Icon Production = IconLoader.getIcon("/scope/production.svg"); // 16x16
    public static final Icon Scratches = IconLoader.getIcon("/scope/scratches.svg"); // 16x16
    public static final Icon Tests = IconLoader.getIcon("/scope/tests.svg"); // 16x16

  }

  public final static class Toolbar {
    public static final Icon Filterdups = IconLoader.getIcon("/toolbar/filterdups.svg"); // 16x16
    public static final Icon Unknown = IconLoader.getIcon("/toolbar/unknown.svg"); // 16x16

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.GroupByPackage */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Folders = AllIcons.Actions.GroupByPackage;

  }

  public final static class ToolbarDecorator {
    public static final Icon AddBlankLine = IconLoader.getIcon("/toolbarDecorator/addBlankLine.svg"); // 16x16
    public static final Icon AddClass = IconLoader.getIcon("/toolbarDecorator/addClass.svg"); // 16x16
    public static final Icon AddFolder = IconLoader.getIcon("/toolbarDecorator/addFolder.svg"); // 16x16
    public static final Icon AddIcon = IconLoader.getIcon("/toolbarDecorator/addIcon.svg"); // 16x16
    public static final Icon AddJira = IconLoader.getIcon("/toolbarDecorator/addJira.svg"); // 16x16
    public static final Icon AddLink = IconLoader.getIcon("/toolbarDecorator/addLink.svg"); // 16x16
    public static final Icon AddPattern = IconLoader.getIcon("/toolbarDecorator/addPattern.svg"); // 16x16
    public static final Icon AddRemoteDatasource = IconLoader.getIcon("/toolbarDecorator/addRemoteDatasource.svg"); // 16x16
    public static final Icon AddYouTrack = IconLoader.getIcon("/toolbarDecorator/addYouTrack.svg"); // 16x16
    public static final Icon Export = IconLoader.getIcon("/toolbarDecorator/export.svg"); // 16x16
    public static final Icon Import = IconLoader.getIcon("/toolbarDecorator/import.svg"); // 16x16

    public final static class Mac {

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Add */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Add = AllIcons.General.Add;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddBlankLine */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddBlankLine = AllIcons.ToolbarDecorator.AddBlankLine;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddClass */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddClass = AllIcons.ToolbarDecorator.AddClass;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddFolder */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddFolder = AllIcons.ToolbarDecorator.AddFolder;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddIcon */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddIcon = AllIcons.ToolbarDecorator.AddIcon;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddJira */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddJira = AllIcons.ToolbarDecorator.AddJira;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddLink */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddLink = AllIcons.ToolbarDecorator.AddLink;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddFolder */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddPackage = AllIcons.ToolbarDecorator.AddFolder;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddPattern */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddPattern = AllIcons.ToolbarDecorator.AddPattern;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddRemoteDatasource */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddRemoteDatasource = AllIcons.ToolbarDecorator.AddRemoteDatasource;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddYouTrack */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon AddYouTrack = AllIcons.ToolbarDecorator.AddYouTrack;

      /** @deprecated to be removed in IDEA 2020 */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Analyze = IconLoader.getIcon("/toolbarDecorator/mac/analyze.png");

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Edit */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Edit = AllIcons.Actions.Edit;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.MoveDown */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon MoveDown = AllIcons.Actions.MoveDown;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.MoveUp */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon MoveUp = AllIcons.Actions.MoveUp;

      /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Remove */
      @SuppressWarnings("unused")
      @Deprecated
      public static final Icon Remove = AllIcons.General.Remove;

    }

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Add */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Add = AllIcons.General.Add;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.AddFolder */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon AddPackage = AllIcons.ToolbarDecorator.AddFolder;

    /** @deprecated to be removed in IDEA 2020 */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Analyze = IconLoader.getIcon("/toolbarDecorator/analyze.png");

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Edit */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Edit = AllIcons.Actions.Edit;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.MoveDown */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon MoveDown = AllIcons.Actions.MoveDown;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.MoveUp */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon MoveUp = AllIcons.Actions.MoveUp;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Remove */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon Remove = AllIcons.General.Remove;

  }

  public final static class Toolwindows {
    public static final Icon Documentation = IconLoader.getIcon("/toolwindows/documentation.svg"); // 13x13
    public static final Icon Problems = IconLoader.getIcon("/toolwindows/problems.svg"); // 13x13
    public static final Icon ProblemsEmpty = IconLoader.getIcon("/toolwindows/problemsEmpty.svg"); // 13x13
    public static final Icon ToolWindowAnt = IconLoader.getIcon("/toolwindows/toolWindowAnt.svg"); // 13x13
    public static final Icon ToolWindowBuild = IconLoader.getIcon("/toolwindows/toolWindowBuild.svg"); // 13x13
    public static final Icon ToolWindowChanges = IconLoader.getIcon("/toolwindows/toolWindowChanges.svg"); // 13x13
    public static final Icon ToolWindowCommander = IconLoader.getIcon("/toolwindows/toolWindowCommander.png"); // 13x13
    public static final Icon ToolWindowCoverage = IconLoader.getIcon("/toolwindows/toolWindowCoverage.svg"); // 13x13
    public static final Icon ToolWindowCvs = IconLoader.getIcon("/toolwindows/toolWindowCvs.png"); // 13x13
    public static final Icon ToolWindowDebugger = IconLoader.getIcon("/toolwindows/toolWindowDebugger.svg"); // 13x13
    public static final Icon ToolWindowFavorites = IconLoader.getIcon("/toolwindows/toolWindowFavorites.svg"); // 13x13
    public static final Icon ToolWindowFind = IconLoader.getIcon("/toolwindows/toolWindowFind.svg"); // 13x13
    public static final Icon ToolWindowHierarchy = IconLoader.getIcon("/toolwindows/toolWindowHierarchy.svg"); // 13x13
    public static final Icon ToolWindowInspection = IconLoader.getIcon("/toolwindows/toolWindowInspection.svg"); // 13x13
    public static final Icon ToolWindowMessages = IconLoader.getIcon("/toolwindows/toolWindowMessages.svg"); // 13x13
    public static final Icon ToolWindowModuleDependencies = IconLoader.getIcon("/toolwindows/toolWindowModuleDependencies.svg"); // 13x13
    public static final Icon ToolWindowPalette = IconLoader.getIcon("/toolwindows/toolWindowPalette.svg"); // 13x13
    public static final Icon ToolWindowPreview = IconLoader.getIcon("/toolwindows/toolWindowPreview.png"); // 13x13
    public static final Icon ToolWindowProfiler = IconLoader.getIcon("/toolwindows/toolWindowProfiler.svg"); // 13x13
    public static final Icon ToolWindowProject = IconLoader.getIcon("/toolwindows/toolWindowProject.svg"); // 13x13
    public static final Icon ToolWindowRun = IconLoader.getIcon("/toolwindows/toolWindowRun.svg"); // 13x13
    public static final Icon ToolWindowStructure = IconLoader.getIcon("/toolwindows/toolWindowStructure.svg"); // 13x13
    public static final Icon ToolWindowTodo = IconLoader.getIcon("/toolwindows/toolWindowTodo.svg"); // 13x13
    public static final Icon WebToolWindow = IconLoader.getIcon("/toolwindows/webToolWindow.svg"); // 13x13

  }

  public final static class Vcs {
    public static final Icon Arrow_left = IconLoader.getIcon("/vcs/arrow_left.png"); // 16x16
    public static final Icon Arrow_right = IconLoader.getIcon("/vcs/arrow_right.png"); // 16x16
    public static final Icon Branch = IconLoader.getIcon("/vcs/branch.svg"); // 16x16
    public static final Icon Changelist = IconLoader.getIcon("/vcs/changelist.svg"); // 16x16
    public static final Icon CheckSpelling = IconLoader.getIcon("/vcs/checkSpelling.png"); // 16x16
    public static final Icon Equal = IconLoader.getIcon("/vcs/equal.png"); // 16x16
    public static final Icon History = IconLoader.getIcon("/vcs/history.svg"); // 16x16
    public static final Icon MapBase = IconLoader.getIcon("/vcs/mapBase.png"); // 16x16
    public static final Icon Merge = IconLoader.getIcon("/vcs/merge.svg"); // 16x16
    public static final Icon Not_equal = IconLoader.getIcon("/vcs/not_equal.png"); // 16x16
    public static final Icon Patch = IconLoader.getIcon("/vcs/patch.svg"); // 16x16
    public static final Icon Patch_applied = IconLoader.getIcon("/vcs/patch_applied.svg"); // 16x16
    public static final Icon Patch_file = IconLoader.getIcon("/vcs/patch_file.svg"); // 16x16
    public static final Icon Push = IconLoader.getIcon("/vcs/push.svg"); // 16x16
    public static final Icon Remove = IconLoader.getIcon("/vcs/remove.png"); // 16x16
    public static final Icon ResetStrip = IconLoader.getIcon("/vcs/resetStrip.png"); // 16x16
    public static final Icon RestoreDefaultSize = IconLoader.getIcon("/vcs/restoreDefaultSize.png"); // 16x16
    public static final Icon Shelve = IconLoader.getIcon("/vcs/Shelve.svg"); // 16x16
    public static final Icon ShelveSilent = IconLoader.getIcon("/vcs/shelveSilent.svg"); // 16x16
    public static final Icon ShowUnversionedFiles = IconLoader.getIcon("/vcs/ShowUnversionedFiles.png"); // 16x16
    public static final Icon StripDown = IconLoader.getIcon("/vcs/stripDown.png"); // 16x16
    public static final Icon StripNull = IconLoader.getIcon("/vcs/stripNull.png"); // 16x16
    public static final Icon StripUp = IconLoader.getIcon("/vcs/stripUp.png"); // 16x16
    public static final Icon Unshelve = IconLoader.getIcon("/vcs/Unshelve.svg"); // 16x16
    public static final Icon UnshelveSilent = IconLoader.getIcon("/vcs/unshelveSilent.svg"); // 16x16

    public final static class Vendors {
      public static final Icon Github = IconLoader.getIcon("/vcs/vendors/github.svg"); // 16x16

    }

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.ShowAsTree */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon MergeSourcesTree = AllIcons.Actions.ShowAsTree;

  }

  public final static class Webreferences {
    public static final Icon Server = IconLoader.getIcon("/webreferences/server.svg"); // 16x16

  }

  public final static class Welcome {
    public static final Icon CreateDesktopEntry = IconLoader.getIcon("/welcome/createDesktopEntry.png"); // 32x32
    public static final Icon CreateNewProject = IconLoader.getIcon("/welcome/createNewProject.svg"); // 16x16
    public static final Icon FromVCS = IconLoader.getIcon("/welcome/fromVCS.svg"); // 16x16

    public final static class Project {
      public static final Icon Remove_hover = IconLoader.getIcon("/welcome/project/remove-hover.png"); // 10x10
      public static final Icon Remove = IconLoader.getIcon("/welcome/project/remove.png"); // 10x10

    }
    public static final Icon Register = IconLoader.getIcon("/welcome/register.png"); // 32x32

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.Import */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon CreateNewProjectfromExistingFiles = AllIcons.ToolbarDecorator.Import;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.ToolbarDecorator.Import */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon ImportProject = AllIcons.ToolbarDecorator.Import;

    /** @deprecated to be removed in IDEA 2020 - use AllIcons.Actions.Menu_open */
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon OpenProject = AllIcons.Actions.Menu_open;

  }

  public final static class Windows {
    public static final Icon CloseActive = IconLoader.getIcon("/windows/closeActive.svg"); // 16x16
    public static final Icon CloseHover = IconLoader.getIcon("/windows/closeHover.svg"); // 16x16
    public static final Icon CloseInactive = IconLoader.getIcon("/windows/closeInactive.svg"); // 16x16
    public static final Icon CloseSmall = IconLoader.getIcon("/windows/closeSmall.svg"); // 16x16
    public static final Icon Help = IconLoader.getIcon("/windows/help.svg"); // 16x16
    public static final Icon HelpButton = IconLoader.getIcon("/windows/helpButton.svg"); // 16x16
    public static final Icon HelpButtonInactive = IconLoader.getIcon("/windows/helpButtonInactive.svg"); // 16x16
    public static final Icon HelpInactive = IconLoader.getIcon("/windows/helpInactive.svg"); // 16x16
    public static final Icon Maximize = IconLoader.getIcon("/windows/maximize.svg"); // 16x16
    public static final Icon MaximizeInactive = IconLoader.getIcon("/windows/maximizeInactive.svg"); // 16x16
    public static final Icon MaximizeSmall = IconLoader.getIcon("/windows/maximizeSmall.svg"); // 16x16
    public static final Icon Minimize = IconLoader.getIcon("/windows/minimize.svg"); // 16x16
    public static final Icon MinimizeInactive = IconLoader.getIcon("/windows/minimizeInactive.svg"); // 16x16
    public static final Icon MinimizeSmall = IconLoader.getIcon("/windows/minimizeSmall.svg"); // 16x16
    public static final Icon Restore = IconLoader.getIcon("/windows/restore.svg"); // 16x16
    public static final Icon RestoreInactive = IconLoader.getIcon("/windows/restoreInactive.svg"); // 16x16
    public static final Icon RestoreSmall = IconLoader.getIcon("/windows/restoreSmall.svg"); // 16x16

    public final static class Shadow {
      public static final Icon Bottom = IconLoader.getIcon("/windows/shadow/bottom.png"); // 1x13
      public static final Icon BottomLeft = IconLoader.getIcon("/windows/shadow/bottomLeft.png"); // 24x24
      public static final Icon BottomRight = IconLoader.getIcon("/windows/shadow/bottomRight.png"); // 24x24
      public static final Icon Left = IconLoader.getIcon("/windows/shadow/left.png"); // 13x1
      public static final Icon Right = IconLoader.getIcon("/windows/shadow/right.png"); // 13x1
      public static final Icon Top = IconLoader.getIcon("/windows/shadow/top.png"); // 1x13
      public static final Icon TopLeft = IconLoader.getIcon("/windows/shadow/topLeft.png"); // 24x24
      public static final Icon TopRight = IconLoader.getIcon("/windows/shadow/topRight.png"); // 24x24

    }
    public static final Icon WinHelp = IconLoader.getIcon("/windows/winHelp.png"); // 16x16

  }

  public final static class Xml {

    public final static class Browsers {
      public static final Icon Canary16 = IconLoader.getIcon("/xml/browsers/canary16.png"); // 16x16
      public static final Icon Chrome16 = IconLoader.getIcon("/xml/browsers/chrome16.png"); // 16x16
      public static final Icon Chromium16 = IconLoader.getIcon("/xml/browsers/chromium16.png"); // 16x16
      public static final Icon Edge16 = IconLoader.getIcon("/xml/browsers/edge16.png"); // 16x16
      public static final Icon Explorer16 = IconLoader.getIcon("/xml/browsers/explorer16.png"); // 16x16
      public static final Icon Firefox16 = IconLoader.getIcon("/xml/browsers/firefox16.png"); // 16x16
      public static final Icon Nwjs16 = IconLoader.getIcon("/xml/browsers/nwjs16.png"); // 16x16
      public static final Icon Opera16 = IconLoader.getIcon("/xml/browsers/opera16.png"); // 16x16
      public static final Icon Safari16 = IconLoader.getIcon("/xml/browsers/safari16.png"); // 16x16
      public static final Icon Yandex16 = IconLoader.getIcon("/xml/browsers/yandex16.png"); // 16x16

    }
    public static final Icon Css_class = IconLoader.getIcon("/xml/css_class.png"); // 16x16
    public static final Icon Html5 = IconLoader.getIcon("/xml/html5.png"); // 16x16
    public static final Icon Html_id = IconLoader.getIcon("/xml/html_id.png"); // 16x16

  }
}
