/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.util;

public class Base32 {
    private static final String base32Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] base32Lookup = new int[]{255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255};

    public static String encode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (byArray.length) {
            case 1: {
                n4 = 6;
                break;
            }
            case 2: {
                n4 = 4;
                break;
            }
            case 3: {
                n4 = 3;
                break;
            }
            case 4: {
                n4 = 1;
            }
        }
        StringBuffer stringBuffer = new StringBuffer((byArray.length + 7) * 8 / 5 + n4);
        while (n < byArray.length) {
            int n5;
            int n6 = n5 = byArray[n] >= 0 ? byArray[n] : byArray[n] + 256;
            if (n2 > 3) {
                int n7 = n + 1 < byArray.length ? (byArray[n + 1] >= 0 ? byArray[n + 1] : byArray[n + 1] + 256) : 0;
                n3 = n5 & 255 >> n2;
                n2 = (n2 + 5) % 8;
                n3 <<= n2;
                n3 |= n7 >> 8 - n2;
                ++n;
            } else {
                n3 = n5 >> 8 - (n2 + 5) & 0x1F;
                if ((n2 = (n2 + 5) % 8) == 0) {
                    ++n;
                }
            }
            stringBuffer.append(base32Chars.charAt(n3));
        }
        switch (byArray.length) {
            case 1: {
                stringBuffer.append("======");
                break;
            }
            case 2: {
                stringBuffer.append("====");
                break;
            }
            case 3: {
                stringBuffer.append("===");
                break;
            }
            case 4: {
                stringBuffer.append("=");
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        byte[] byArray = new byte[string.length() * 5 / 8];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n3;
            int n4 = string.charAt(i) - 48;
            if (n4 < 0 || n4 >= base32Lookup.length || (n3 = base32Lookup[n4]) == 255) continue;
            if (n <= 3) {
                if ((n = (n + 5) % 8) == 0) {
                    int n5 = n2++;
                    byArray[n5] = (byte)(byArray[n5] | n3);
                    if (n2 < byArray.length) continue;
                    break;
                }
                int n6 = n2;
                byArray[n6] = (byte)(byArray[n6] | n3 << 8 - n);
                continue;
            }
            n = (n + 5) % 8;
            int n7 = n2++;
            byArray[n7] = (byte)(byArray[n7] | n3 >>> n);
            if (n2 >= byArray.length) break;
            int n8 = n2;
            byArray[n8] = (byte)(byArray[n8] | n3 << 8 - n);
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Supply a Base32-encoded argument.");
            return;
        }
        System.out.println(" Original: " + stringArray[0]);
        byte[] byArray = Base32.decode(stringArray[0]);
        System.out.print("      Hex: ");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            System.out.print(Integer.toHexString(n + 256).substring(1));
        }
        System.out.println();
        System.out.println("Reencoded: " + Base32.encode(byArray));
    }
}

