/*
 * File    : OrderTypePanel.java
 * Created : 26-jun-2003 16:30
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2018 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.activities.text;

import edu.xtec.util.Options;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.09.16
 */
public class IdentifyTypePanel extends javax.swing.JPanel {

  Options options;
  protected static final Map<Options, IdentifyTypePanel> panels = new HashMap<Options, IdentifyTypePanel>(1);

  /** Creates new form OrderTypePanel */
  public IdentifyTypePanel(Options options) {
    this.options = options;
    initComponents();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  private void initComponents() { // GEN-BEGIN:initComponents
    bGroup = new javax.swing.ButtonGroup();
    identWordsBtn = new javax.swing.JRadioButton();
    identCharsBtn = new javax.swing.JRadioButton();

    setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

    identWordsBtn.setText(options.getMsg("edit_text_act_identWords"));
    bGroup.add(identWordsBtn);
    add(identWordsBtn);

    identCharsBtn.setText(options.getMsg("edit_text_act_identChars"));
    bGroup.add(identCharsBtn);
    add(identCharsBtn);
  } // GEN-END:initComponents

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JRadioButton identWordsBtn;
  private javax.swing.ButtonGroup bGroup;
  private javax.swing.JRadioButton identCharsBtn;
  // End of variables declaration//GEN-END:variables

  public static boolean editIdentify(Identify ident, Options options, Component parent) {
    IdentifyTypePanel idp = panels.get(options);
    if (idp == null) {
      idp = new IdentifyTypePanel(options);
      panels.put(options, idp);
    }
    boolean p = (ident.type == Identify.IDENTIFY_WORDS);
    idp.identCharsBtn.setSelected(!p);
    idp.identWordsBtn.setSelected(p);
    boolean result = options.getMessages().showInputDlg(parent, idp, "edit_text_act_type_title");
    if (result)
      ident.type = idp.identWordsBtn.isSelected() ? Identify.IDENTIFY_WORDS : Identify.IDENTIFY_CHARS;
    return result;
  }
}
