/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef ACCOUNT_H
#define ACCOUNT_H

#include <QObject>
#include <QString>
#include <QTimer>

#include <kio/job.h>
#include <KUrl>

#include "atomparser.h"

class Account : public QObject
{
    Q_OBJECT
public:
    Account(const QString &username, const QString &password);
    ~Account();

    void setCredentials(const QString &username, const QString &password);
    void checkMail(unsigned int timeout);

    bool hasNewMail() const;
    unsigned int messageCount() const;
    const QString& lastSender() const;
    const QString& lastSubject() const;

signals:
    void connectionSuccessful();
    void connectionError(const QString errorStr);

private slots:
    void slotAbortJob();
    void slotParseData(KJob *);

private:
    Account(const Account&);
    Account& operator=(const Account&);

    AtomParser *m_atomParser;

    QString m_username;
    QString m_password;
    unsigned int m_connectionTimeout;

    unsigned int m_lastMessageCount;
    unsigned int m_currentMessageCount;
    QString m_lastSender;
    QString m_lastSubject;

    KIO::Job *m_fileCopyJob;
    KUrl *m_atomFileUrl;
    KUrl *m_tmpFileUrl;
    QTimer *m_jobTimeoutTimer;
};

#endif // ACCOUNT_H
