# Copyright (C) 2007-2010 by Thomas Thelliez aka jblud
# Contact : <admin.kontrol@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2.0 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program; if not, write to
# the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# libsecuretcp is a cross platform and open source library (LGPLv3)
# written with the C++ programming language in 2010.
#
# libsecuretcp provides methods and cryptographic algorithms to build
# efficient and scalable authentification mechanisms with OTP (One Time Password).
# Dependencies : libxml2 OpenSSL, QtCore and QtNetwork.
#
# libsecuretcp provides a negociation mechanism between clients and servers to exchange
# asymetric and symetric keys (RSA | AES 256)
#

TEMPLATE = lib
CONFIG += lib_bundle
win32 {
        INCLUDEPATH += C:\\OpenSSL\\include C:\libxml2\lib\include\libxml2
        LIBS += -LC:\libxml2\lib\lib -lxml2 -LC:\\OpenSSL\\lib\\MinGW -leay32 -LC:\Qt\2010.02.1\mingw\lib -lws2_32 -lwsock32
}
linux-g++ {
        INCLUDEPATH += /usr/include/openssl /usr/include/libxml2
       LIBS += -L/usr/lib -lssl -lxml2
}
macx {
        INCLUDEPATH += /usr/include/openssl /usr/include/libxml2
        LIBS += -L/usr/lib -lcrypto  -lxml2
}
QT += core network
CONFIG *= release
unix:TARGET = securetcp$(TARGET_ADD)
macx:TARGET = securetcp$(TARGET_ADD)
win32:TARGET = securetcp
VERSION = 0.0.1
SOURCES += auth/auth_tcp_client.cpp \
auth/auth_server.cpp \
auth/auth_session.cpp \
auth/auth_commons.cpp \
crypto/rsa_utils.cpp \
crypto/sha256_utils.cpp \
crypto/aes_utils.cpp \
xml/xml.cpp \
xml/xml_parser.cpp \
utils/b64_utils.cpp

HEADERS += auth/auth_tcp_client.h \
auth/auth_server.h \
auth/auth_session.h \
auth/auth_commons.h \
xml/xml.h \
xml/xml_parser.h \
crypto/rsa_utils.h \
crypto/sha256_utils.h \
crypto/aes_utils.h \
utils/utils.h \
utils/b64_utils.h \
crypto/aes_wrapper.h

CONFIG(release) {
  DESTDIR       = ../bin
  RCC_DIR  = ../tmp
  OBJECTS_DIR  = ../tmp
  MOC_DIR  = ../tmp
}

CONFIG(release) {
  DESTDIR       = ../bin
  RCC_DIR  = ../tmp
  OBJECTS_DIR  = ../tmp
  MOC_DIR  = ../tmp
}
