/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef KOSDD_H
#define KOSDD_H

#include "osd.h"

#include <KDEDModule>

class KOsdD : public KDEDModule
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.kde.kosd") 

public:
    KOsdD(QObject* parent, const QList<QVariant>&);
    virtual ~KOsdD();

public slots:
    Q_SCRIPTABLE void showBattery(int percent, bool plugged);
    Q_SCRIPTABLE void showBrightness(int percent);
    Q_SCRIPTABLE void showVolume(int percent, bool muted);
    Q_SCRIPTABLE void showCustomSvg(const QString &svg, const QStringList &elements, const QString &text, int percent);
    Q_SCRIPTABLE void showCustomPixmap(const QString &pixmap, const QString &text, int percent);
    Q_SCRIPTABLE void parseConfiguration();

private:
    QPixmap* createPixmap(const QString &svg, const QStringList &elements);
    void paintSvg(const QString &svg, const QStringList &elements, QPixmap *pixmap);

private:
    class KOsdDPrivate;
    KOsdDPrivate *d;
};

#endif // KOSDD_H
