/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.completion.test;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/idea-completion/testData/smartMultiFile")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class MultiFileSmartCompletionTestGenerated extends AbstractMultiFileSmartCompletionTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInSmartMultiFile() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/smartMultiFile"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
    }

    @TestMetadata("AnonymousObjectGenericJava")
    public void testAnonymousObjectGenericJava() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/AnonymousObjectGenericJava/");
    }

    @TestMetadata("CallableReferenceNotImported")
    public void testCallableReferenceNotImported() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/CallableReferenceNotImported/");
    }

    @TestMetadata("CallablesInExcludedPackage")
    public void testCallablesInExcludedPackage() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/CallablesInExcludedPackage/");
    }

    @TestMetadata("FunctionFromAnotherPackage")
    public void testFunctionFromAnotherPackage() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/FunctionFromAnotherPackage/");
    }

    @TestMetadata("GenericInheritors1")
    public void testGenericInheritors1() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/GenericInheritors1/");
    }

    @TestMetadata("GenericInheritors2")
    public void testGenericInheritors2() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/GenericInheritors2/");
    }

    @TestMetadata("GenericInheritors3")
    public void testGenericInheritors3() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/GenericInheritors3/");
    }

    @TestMetadata("GenericInheritors4")
    public void testGenericInheritors4() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/GenericInheritors4/");
    }

    @TestMetadata("InheritorInTheSameFile")
    public void testInheritorInTheSameFile() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/InheritorInTheSameFile/");
    }

    @TestMetadata("Inheritors")
    public void testInheritors() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/Inheritors/");
    }

    @TestMetadata("InheritorsAndMultipleExpectedTypes")
    public void testInheritorsAndMultipleExpectedTypes() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/InheritorsAndMultipleExpectedTypes/");
    }

    @TestMetadata("JavaStaticMethodArgument")
    public void testJavaStaticMethodArgument() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/JavaStaticMethodArgument/");
    }

    @TestMetadata("JavaStaticMethodArgument2")
    public void testJavaStaticMethodArgument2() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/JavaStaticMethodArgument2/");
    }

    @TestMetadata("KT_8751")
    public void testKT_8751() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/KT_8751/");
    }

    @TestMetadata("KT_8751_2")
    public void testKT_8751_2() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/KT_8751_2/");
    }

    @TestMetadata("NestedClassAfterAs")
    public void testNestedClassAfterAs() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/NestedClassAfterAs/");
    }

    @TestMetadata("NoObjectDuplication")
    public void testNoObjectDuplication() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/NoObjectDuplication/");
    }

    @TestMetadata("NotImportedContains")
    public void testNotImportedContains() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/NotImportedContains/");
    }

    @TestMetadata("NotImportedGetValue")
    public void testNotImportedGetValue() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/NotImportedGetValue/");
    }

    @TestMetadata("StaticMembers1")
    public void testStaticMembers1() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/StaticMembers1/");
    }

    @TestMetadata("StaticMembers2")
    public void testStaticMembers2() throws Exception {
        runTest("idea/idea-completion/testData/smartMultiFile/StaticMembers2/");
    }
}
