package junit.test;

import java.awt.Point;

import junit.framework.TestCase;
import latexDraw.ui.components.Delimitor;
import latexDraw.util.LaTeXDrawPoint2D;

import org.junit.Before;
import org.junit.Test;

/** 
 * This class contains tests on the class Delimitor.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 06/26/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestDelimitor extends TestCase
{

	private final LaTeXDrawPoint2D	p0		= new LaTeXDrawPoint2D(0, 0);

	private final LaTeXDrawPoint2D	p1		= new LaTeXDrawPoint2D(1, 1);

	private final LaTeXDrawPoint2D	pNull	= null;

	private Delimitor				d1;



	@Override
	@Before
	public void setUp()
	{
		d1 = new Delimitor();
	}


	@Test
	public void testConstructors()
	{
		Delimitor d = new Delimitor(pNull);

		assertEquals(d.getCenter(), p0);

		d = new Delimitor();

		assertEquals(d.getCenter(), p0);

		d = new Delimitor(new LaTeXDrawPoint2D(0, 0));

		assertEquals(d.getCenter(), p0);
	}



	@Test
	public void getSetCenterXY()
	{
		try
		{
			d1.setCenter(null);
			fail();
		}catch(IllegalArgumentException e) { /* Good */ }

		try { d1.setCenter(p1); }
		catch(Exception e) { fail(); }

		if(p1 != d1.getCenter())
			fail();

		assertEquals(p1.x, d1.getX());
		assertEquals(p1.y, d1.getY());
	}


	@Test
	public void setColorSet1()
	{
		d1.setColorSet1();
		assertEquals(Delimitor.INTERIOR, d1.getInterior());
	}


	@Test
	public void setColorSet2()
	{
		d1.setColorSet2();
		assertEquals(Delimitor.INTERIOR_2, d1.getInterior());
	}


	@Test
	public void setColorSet3()
	{
		d1.setColorSet3();
		assertEquals(Delimitor.INTERIOR_3, d1.getInterior());
	}



	@Test
	public void setColorSet4()
	{
		d1.setColorSet4();
		assertEquals(Delimitor.INTERIOR_4, d1.getInterior());
	}



	@Test
	public void getSetDim()
	{
		try
		{
			d1.setDim(-1.);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }

		try
		{
			d1.setDim(0.);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }

		try { d1.setDim(1.); }
		catch(IllegalArgumentException e) { fail(); }

		assertEquals(d1.getDim(), 1.);
	}



	@Test
	public void setCoordinates()
	{
		try
		{
			d1.setCoordinates(pNull);
			fail();
		}catch(IllegalArgumentException e) { /* Good */ }

		try { d1.setCenter(p1); }
		catch(Exception e) { fail(); }

		assertEquals(p1, d1.getCenter());
	}



	@Test
	public void isIn()
	{
		d1.setCenter(p0);
		d1.setDim(10);
		Point tmpPt = null;

		assertFalse(d1.isIn(tmpPt));
		assertFalse(d1.isIn(pNull));
		assertFalse(d1.isIn(new LaTeXDrawPoint2D(0, 6)));
		assertFalse(d1.isIn(new LaTeXDrawPoint2D(0, -6)));
		assertFalse(d1.isIn(new LaTeXDrawPoint2D(6, 0)));
		assertFalse(d1.isIn(new LaTeXDrawPoint2D(-6, 0)));
		assertTrue(d1.isIn(new LaTeXDrawPoint2D(0, 5)));
		assertTrue(d1.isIn(new LaTeXDrawPoint2D(0, -5)));
		assertTrue(d1.isIn(new LaTeXDrawPoint2D(5, 0)));
		assertTrue(d1.isIn(new LaTeXDrawPoint2D(-5, 0)));
		assertTrue(d1.isIn(p1));
		assertTrue(d1.isIn(p0));
	}



	@Test
	public void testClone()
	{
		try
		{
			Delimitor clone = (Delimitor)d1.clone();

			assertEquals(clone.getCenter(), d1.getCenter());
			assertEquals(clone.getDim(), d1.getDim());
			assertEquals(clone.getInterior(), d1.getInterior());
			assertEquals(clone.getX(), d1.getX());
			assertEquals(clone.getY(), d1.getY());
		}
		catch(Exception e) { fail(); }
	}



	@Test
	public void testGetSetOpacity()
	{
		try
		{
			Delimitor.setOpacity(-2);
			fail();
		}catch(IllegalArgumentException e) { /* Good */ }

		try
		{
			Delimitor.setOpacity(300);
			fail();
		}catch(IllegalArgumentException e) { /* Good */ }

		try { Delimitor.setOpacity(100); }
		catch(Exception e) { fail(); }

		assertEquals(Delimitor.getOpacity(), 100);
	}
}
