//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


unit qt4;

{ Version : 2.1 }

{$mode objfpc}{$H+}

interface

uses Types;

{$MINENUMSIZE 4}


const
  QT_VERSION = 4 shl 16 + 5 shl 8 + 3;
  
  
{$IFDEF MSWINDOWS}
  Qt4PasLib = 'Qt4Pas5.dll';
{$ENDIF}

{$IFDEF HAIKU}
  Qt4PasLib = 'libQt4Pas.so.5';
{$ENDIF}

// Set qtopia yourself if using QTOPIA with QVFB on i386
// ppc386 -dQTOPIA
{$IFDEF CPUARM}
  {$DEFINE QTOPIA}
{$ENDIF}

{$IFDEF QTOPIA}
  Qt4PasLib = 'libQt4Pas.so.5';
{$ENDIF}

{$IFNDEF QTOPIA}
  {$IF DEFINED(LINUX) or DEFINED(FREEBSD) or DEFINED(NETBSD)}
    {$DEFINE BINUX}
    Qt4PasLib = 'libQt4Pas.so.5';
  {$ENDIF}
{$ENDIF}

{$IFDEF DARWIN}
  Qt4PasLib = '';
  {$LINKFRAMEWORK Qt4Pas}
{$ENDIF}



type

  PLong = ^Long;
{$ifdef CPU64 and not WIN64}
   Long = Int64;
{$else}
   Long = LongInt;
{$endif}
  
  

  QHookH = TMethod;
  PSizePolicy = ^TSizePolicy;
  TSizePolicy = packed record
    Data: Word;
  end;
  
  PQColor = ^TQColor;
  TQColor = packed record
    ColorSpec : LongInt;
    Alpha : word;
    r,g,b : word; 
    Pad : word;
   end;
 
  QtHandle = integer;
  PQReal = ^QReal;
  {$ifdef CPUARM}
    QReal = single;
  {$else}
    QReal = double;
  {$endif}

  PQRgb = ^QRgb;
  QRgb = longword;
  
  PPtrIntArray = ^TPtrIntArray;
  TPtrIntArray = array of PtrInt;
  
  PQRealArray = ^TQRealArray;
  TQRealArray = array of QReal;
  
  
const
  NilMethod : TMethod = (Code: nil; Data: nil); 

type

  PQtPoint = ^TQtPoint;
{$IFDEF DARWIN}
  TQtPoint = packed record 
    y : LongInt;
    x : LongInt;
  end;
{$ELSE}
  TQtPoint = packed record 
    x : LongInt;
    y : LongInt;
  end;
{$ENDIF}  

  PQtPointF = ^TQtPointF;
  TQtPointF = packed record 
    x : QReal;
    y : QReal;
  end;

  
{$IFDEF DARWIN}
    EventHandlerRef                     = ^LongInt;
    EventRef                            = ^LongInt;
    RgnHandle                           = ^LongInt;
    MenuHandle                          = ^LongInt;
    MenuRef                             = MenuHandle;
    EventHandlerCallRef                 = ^LongInt;
    CGImageRef                          = Pointer;    
{$ENDIF}


{$IFDEF MSWINDOWS}
  { Message structure }
  PMsg = ^tagMSG;
  tagMSG = packed record
    hwnd: LongWord;
    message: Cardinal;
    wParam: Longint;
    lParam: Longint;
    time: DWORD;
    pt: TPoint;
  end;

  // Extra Q to avoid name clash with other Pascal Units
  WINHANDLE = System.THandle;
  QHCURSOR = type WINHANDLE;
  QHPALETTE = type WINHANDLE;
  QHFONT = type WINHANDLE;
  QHDC = type WINHANDLE;
  QHBITMAP = type WINHANDLE;
  QHBRUSH = type WINHANDLE;
  QHPEN = type WINHANDLE;
  QHRGN = type WINHANDLE;
{$ENDIF}

{$IFDEF WIN32}
  Q_PID = type pointer;
{$ELSE}
  Q_PID = type int64;
{$ENDIF}


QAbstractFileEngineH = class(TObject) end;
QAuthenticatorH = class(TObject) end;
QBitArrayH = class(TObject) end;
QBrushH = class(TObject) end;
QByteArrayH = class(TObject) end;
QCharH = class(TObject) end;
QColorH = class(TObject) end;
QCursorH = class(TObject) end;
QDataStreamH = class(TObject) end;
QDateH = class(TObject) end;
QDateTimeH = class(TObject) end;
QDecorationH = class(TObject) end;
QDirH = class(TObject) end;
QEventH = class(TObject) end;
  QLCLMessageEventH = class(QEventH) end;
  QActionEventH = class(QEventH) end;
  QChildEventH = class(QEventH) end;
  QCloseEventH = class(QEventH) end;
  QDragLeaveEventH = class(QEventH) end;
  QDropEventH = class(QEventH) end;
    QDragMoveEventH = class(QDropEventH) end;
      QDragEnterEventH = class(QDragMoveEventH) end;
  QDynamicPropertyChangeEventH = class(QEventH) end;
  QFileOpenEventH = class(QEventH) end;
  QFocusEventH = class(QEventH) end;
  QHelpEventH = class(QEventH) end;
  QHideEventH = class(QEventH) end;
  QHoverEventH = class(QEventH) end;
  QIconDragEventH = class(QEventH) end;
  QInputEventH = class(QEventH) end;
    QContextMenuEventH = class(QInputEventH) end;
    QKeyEventH = class(QInputEventH) end;
    QMouseEventH = class(QInputEventH) end;
    QTabletEventH = class(QInputEventH) end;
    QWheelEventH = class(QInputEventH) end;
  QInputMethodEventH = class(QEventH) end;
  QMoveEventH = class(QEventH) end;
  QPaintEventH = class(QEventH) end;
  QResizeEventH = class(QEventH) end;
  QShortcutEventH = class(QEventH) end;
  QShowEventH = class(QEventH) end;
  QStatusTipEventH = class(QEventH) end;
  QTimerEventH = class(QEventH) end;
  QWhatsThisClickedEventH = class(QEventH) end;
  QWindowStateChangeEventH = class(QEventH) end;
QFileIconProviderH = class(TObject) end;
QFileInfoH = class(TObject) end;
QFlagH = class(TObject) end;
QFlagsH = class(TObject) end;
QFontH = class(TObject) end;
QFontDatabaseH = class(TObject) end;
QFontInfoH = class(TObject) end;
QFontMetricsH = class(TObject) end;
QFontMetricsFH = class(TObject) end;
QGradientH = class(TObject) end;
  QConicalGradientH = class(QGradientH) end;
  QLinearGradientH = class(QGradientH) end;
  QRadialGradientH = class(QGradientH) end;
QGraphicsItemH = class(TObject) end;
  QAbstractGraphicsShapeItemH = class(QGraphicsItemH) end;
    QGraphicsEllipseItemH = class(QAbstractGraphicsShapeItemH) end;
    QGraphicsPathItemH = class(QAbstractGraphicsShapeItemH) end;
    QGraphicsPolygonItemH = class(QAbstractGraphicsShapeItemH) end;
    QGraphicsRectItemH = class(QAbstractGraphicsShapeItemH) end;
    QGraphicsSimpleTextItemH = class(QAbstractGraphicsShapeItemH) end;
  QGraphicsItemGroupH = class(QGraphicsItemH) end;
  QGraphicsLineItemH = class(QGraphicsItemH) end;
  QGraphicsObjectH = class(QGraphicsItemH) end;
    QGraphicsTextItemH = class(QGraphicsObjectH) end;
    QGraphicsWidgetH = class(QGraphicsObjectH) end;
      QGraphicsProxyWidgetH = class(QGraphicsWidgetH) end;
  QGraphicsPixmapItemH = class(QGraphicsItemH) end;
QGraphicsLayoutItemH = class(TObject) end;
QHostAddressH = class(TObject) end;
QIconH = class(TObject) end;
QIconEngineH = class(TObject) end;
  QIconEngineV2H = class(QIconEngineH) end;
QImageIOHandlerH = class(TObject) end;
QImageReaderH = class(TObject) end;
QImageWriterH = class(TObject) end;
QItemEditorCreatorBaseH = class(TObject) end;
QItemEditorFactoryH = class(TObject) end;
QItemSelectionRangeH = class(TObject) end;
QKeySequenceH = class(TObject) end;
QLatin1StringH = class(TObject) end;
QLayoutItemH = class(TObject) end;
  QLayoutH = class(QLayoutItemH) end;
    QBoxLayoutH = class(QLayoutH) end;
      QHBoxLayoutH = class(QBoxLayoutH) end;
      QVBoxLayoutH = class(QBoxLayoutH) end;
    QGridLayoutH = class(QLayoutH) end;
    QStackedLayoutH = class(QLayoutH) end;
  QSpacerItemH = class(QLayoutItemH) end;
  QWidgetItemH = class(QLayoutItemH) end;
QLineH = class(TObject) end;
QLineFH = class(TObject) end;
QListH = class(TObject) end;
  QStringListH = class(QListH) end;
QListWidgetItemH = class(TObject) end;
QLocaleH = class(TObject) end;
QMetaClassInfoH = class(TObject) end;
QMetaEnumH = class(TObject) end;
QMetaMethodH = class(TObject) end;
QMetaObjectH = class(TObject) end;
QMetaPropertyH = class(TObject) end;
QModelIndexH = class(TObject) end;
QNetworkCookieH = class(TObject) end;
QNetworkProxyH = class(TObject) end;
QNetworkProxyFactoryH = class(TObject) end;
QNetworkProxyQueryH = class(TObject) end;
QNetworkRequestH = class(TObject) end;
QObjectH = class(TObject) end;
  QAbstractEventDispatcherH = class(QObjectH) end;
  QAbstractItemDelegateH = class(QObjectH) end;
    QItemDelegateH = class(QAbstractItemDelegateH) end;
      QLCLItemDelegateH = class(QItemDelegateH) end;
    QStyledItemDelegateH = class(QAbstractItemDelegateH) end;
  QAbstractItemModelH = class(QObjectH) end;
    QAbstractListModelH = class(QAbstractItemModelH) end;
    QAbstractProxyModelH = class(QAbstractItemModelH) end;
    QAbstractTableModelH = class(QAbstractItemModelH) end;
    QStandardItemModelH = class(QAbstractItemModelH) end;
  QAbstractNetworkCacheH = class(QObjectH) end;
  QAbstractTextDocumentLayoutH = class(QObjectH) end;
    QPlainTextDocumentLayoutH = class(QAbstractTextDocumentLayoutH) end;
  QActionH = class(QObjectH) end;
  QActionGroupH = class(QObjectH) end;
  QButtonGroupH = class(QObjectH) end;
  QClipboardH = class(QObjectH) end;
  QCompleterH = class(QObjectH) end;
  QCoreApplicationH = class(QObjectH) end;
    QApplicationH = class(QCoreApplicationH) end;
  QDragH = class(QObjectH) end;
  QEventLoopH = class(QObjectH) end;
  QFileSystemWatcherH = class(QObjectH) end;
  QGraphicsSceneH = class(QObjectH) end;
  QIODeviceH = class(QObjectH) end;
    QAbstractSocketH = class(QIODeviceH) end;
      QTcpSocketH = class(QAbstractSocketH) end;
        QSslSocketH = class(QTcpSocketH) end;
      QUdpSocketH = class(QAbstractSocketH) end;
    QFileH = class(QIODeviceH) end;
    QNetworkReplyH = class(QIODeviceH) end;
    QProcessH = class(QIODeviceH) end;
  QInputContextH = class(QObjectH) end;
  QItemSelectionModelH = class(QObjectH) end;
  QMimeDataH = class(QObjectH) end;
  QMovieH = class(QObjectH) end;
  QNetworkAccessManagerH = class(QObjectH) end;
  QNetworkCookieJarH = class(QObjectH) end;
    QLCLNetworkCookieJarH = class(QNetworkCookieJarH) end;
  QSessionManagerH = class(QObjectH) end;
  QSocketNotifierH = class(QObjectH) end;
  QStyleH = class(QObjectH) end;
  QSystemTrayIconH = class(QObjectH) end;
  QTcpServerH = class(QObjectH) end;
  QTextDocumentH = class(QObjectH) end;
  QTextObjectH = class(QObjectH) end;
    QTextBlockGroupH = class(QTextObjectH) end;
      QTextListH = class(QTextBlockGroupH) end;
    QTextFrameH = class(QTextObjectH) end;
      QTextTableH = class(QTextFrameH) end;
  QThreadH = class(QObjectH) end;
    QLCLThreadH = class(QThreadH) end;
  QTimerH = class(QObjectH) end;
  QTranslatorH = class(QObjectH) end;
  QUndoStackH = class(QObjectH) end;
  QValidatorH = class(QObjectH) end;
    QDoubleValidatorH = class(QValidatorH) end;
    QIntValidatorH = class(QValidatorH) end;
    QRegExpValidatorH = class(QValidatorH) end;
  QWebFrameH = class(QObjectH) end;
  QWebHistoryInterfaceH = class(QObjectH) end;
  QWebPageH = class(QObjectH) end;
    QLCLWebPageH = class(QWebPageH) end;
  QWebPluginFactoryH = class(QObjectH) end;
  QWidgetH = class(QObjectH) end;
    QAbstractButtonH = class(QWidgetH) end;
      QCheckBoxH = class(QAbstractButtonH) end;
      QPushButtonH = class(QAbstractButtonH) end;
      QRadioButtonH = class(QAbstractButtonH) end;
      QToolButtonH = class(QAbstractButtonH) end;
    QAbstractSliderH = class(QWidgetH) end;
      QScrollBarH = class(QAbstractSliderH) end;
      QSliderH = class(QAbstractSliderH) end;
    QAbstractSpinBoxH = class(QWidgetH) end;
      QLCLAbstractSpinBoxH = class(QAbstractSpinBoxH) end;
      QDoubleSpinBoxH = class(QAbstractSpinBoxH) end;
      QSpinBoxH = class(QAbstractSpinBoxH) end;
    QCalendarWidgetH = class(QWidgetH) end;
    QComboBoxH = class(QWidgetH) end;
    QDesktopWidgetH = class(QWidgetH) end;
    QDialogH = class(QWidgetH) end;
      QAbstractPrintDialogH = class(QDialogH) end;
        QPrintDialogH = class(QAbstractPrintDialogH) end;
      QColorDialogH = class(QDialogH) end;
      QFileDialogH = class(QDialogH) end;
      QFontDialogH = class(QDialogH) end;
      QInputDialogH = class(QDialogH) end;
      QMessageBoxH = class(QDialogH) end;
      QPageSetupDialogH = class(QDialogH) end;
      QPrintPreviewDialogH = class(QDialogH) end;
      QProgressDialogH = class(QDialogH) end;
    QDockWidgetH = class(QWidgetH) end;
    QFrameH = class(QWidgetH) end;
      QAbstractScrollAreaH = class(QFrameH) end;
        QLCLAbstractScrollAreaH = class(QAbstractScrollAreaH) end;
        QAbstractItemViewH = class(QAbstractScrollAreaH) end;
          QHeaderViewH = class(QAbstractItemViewH) end;
          QListViewH = class(QAbstractItemViewH) end;
            QListWidgetH = class(QListViewH) end;
          QTableViewH = class(QAbstractItemViewH) end;
            QTableWidgetH = class(QTableViewH) end;
          QTreeViewH = class(QAbstractItemViewH) end;
            QTreeWidgetH = class(QTreeViewH) end;
        QGraphicsViewH = class(QAbstractScrollAreaH) end;
        QMdiAreaH = class(QAbstractScrollAreaH) end;
        QPlainTextEditH = class(QAbstractScrollAreaH) end;
        QScrollAreaH = class(QAbstractScrollAreaH) end;
        QTextEditH = class(QAbstractScrollAreaH) end;
          QTextBrowserH = class(QTextEditH) end;
      QLCDNumberH = class(QFrameH) end;
      QLabelH = class(QFrameH) end;
      QSplitterH = class(QFrameH) end;
      QStackedWidgetH = class(QFrameH) end;
      QToolBoxH = class(QFrameH) end;
    QGroupBoxH = class(QWidgetH) end;
    QLineEditH = class(QWidgetH) end;
    QMainWindowH = class(QWidgetH) end;
    QMdiSubWindowH = class(QWidgetH) end;
    QMenuH = class(QWidgetH) end;
    QMenuBarH = class(QWidgetH) end;
    QPrintPreviewWidgetH = class(QWidgetH) end;
    QProgressBarH = class(QWidgetH) end;
    QRubberBandH = class(QWidgetH) end;
    QSizeGripH = class(QWidgetH) end;
    QSplitterHandleH = class(QWidgetH) end;
    QStatusBarH = class(QWidgetH) end;
    QTabBarH = class(QWidgetH) end;
    QTabWidgetH = class(QWidgetH) end;
      QLCLTabWidgetH = class(QTabWidgetH) end;
    QToolBarH = class(QWidgetH) end;
    QWebViewH = class(QWidgetH) end;
      QLCLWebViewH = class(QWebViewH) end;
QPaintDeviceH = class(TObject) end;
  QImageH = class(QPaintDeviceH) end;
  QPictureH = class(QPaintDeviceH) end;
  QPixmapH = class(QPaintDeviceH) end;
    QBitmapH = class(QPixmapH) end;
  QPrinterH = class(QPaintDeviceH) end;
QPaintEngineH = class(TObject) end;
QPainterH = class(TObject) end;
QPainterPathH = class(TObject) end;
QPainterPathStrokerH = class(TObject) end;
QPaletteH = class(TObject) end;
QPenH = class(TObject) end;
QPersistentModelIndexH = class(TObject) end;
QPointH = class(TObject) end;
QPointFH = class(TObject) end;
QPrintEngineH = class(TObject) end;
QPrinterInfoH = class(TObject) end;
QRectH = class(TObject) end;
QRectFH = class(TObject) end;
QRegExpH = class(TObject) end;
QRegionH = class(TObject) end;
QSizeH = class(TObject) end;
QSizeFH = class(TObject) end;
QSizePolicyH = class(TObject) end;
QSslCertificateH = class(TObject) end;
QSslCipherH = class(TObject) end;
QSslConfigurationH = class(TObject) end;
QSslErrorH = class(TObject) end;
QSslKeyH = class(TObject) end;
QStandardItemH = class(TObject) end;
QStringH = class(TObject) end;
QStyleFactoryH = class(TObject) end;
QStyleHintReturnH = class(TObject) end;
  QStyleHintReturnMaskH = class(QStyleHintReturnH) end;
  QStyleHintReturnVariantH = class(QStyleHintReturnH) end;
QStyleOptionH = class(TObject) end;
  QStyleOptionButtonH = class(QStyleOptionH) end;
  QStyleOptionComplexH = class(QStyleOptionH) end;
    QStyleOptionComboBoxH = class(QStyleOptionComplexH) end;
    QStyleOptionGroupBoxH = class(QStyleOptionComplexH) end;
    QStyleOptionQ3ListViewH = class(QStyleOptionComplexH) end;
    QStyleOptionSizeGripH = class(QStyleOptionComplexH) end;
    QStyleOptionSliderH = class(QStyleOptionComplexH) end;
    QStyleOptionSpinBoxH = class(QStyleOptionComplexH) end;
    QStyleOptionTitleBarH = class(QStyleOptionComplexH) end;
    QStyleOptionToolButtonH = class(QStyleOptionComplexH) end;
  QStyleOptionDockWidgetH = class(QStyleOptionH) end;
  QStyleOptionFocusRectH = class(QStyleOptionH) end;
  QStyleOptionFrameH = class(QStyleOptionH) end;
    QStyleOptionFrameV2H = class(QStyleOptionFrameH) end;
      QStyleOptionFrameV3H = class(QStyleOptionFrameV2H) end;
  QStyleOptionGraphicsItemH = class(QStyleOptionH) end;
  QStyleOptionHeaderH = class(QStyleOptionH) end;
  QStyleOptionMenuItemH = class(QStyleOptionH) end;
  QStyleOptionProgressBarH = class(QStyleOptionH) end;
    QStyleOptionProgressBarV2H = class(QStyleOptionProgressBarH) end;
  QStyleOptionQ3DockWindowH = class(QStyleOptionH) end;
  QStyleOptionQ3ListViewItemH = class(QStyleOptionH) end;
  QStyleOptionRubberBandH = class(QStyleOptionH) end;
  QStyleOptionTabH = class(QStyleOptionH) end;
    QStyleOptionTabV2H = class(QStyleOptionTabH) end;
      QStyleOptionTabV3H = class(QStyleOptionTabV2H) end;
  QStyleOptionTabBarBaseH = class(QStyleOptionH) end;
    QStyleOptionTabBarBaseV2H = class(QStyleOptionTabBarBaseH) end;
  QStyleOptionTabWidgetFrameH = class(QStyleOptionH) end;
  QStyleOptionToolBarH = class(QStyleOptionH) end;
  QStyleOptionToolBoxH = class(QStyleOptionH) end;
    QStyleOptionToolBoxV2H = class(QStyleOptionToolBoxH) end;
  QStyleOptionViewItemH = class(QStyleOptionH) end;
    QStyleOptionViewItemV2H = class(QStyleOptionViewItemH) end;
      QStyleOptionViewItemV3H = class(QStyleOptionViewItemV2H) end;
        QStyleOptionViewItemV4H = class(QStyleOptionViewItemV3H) end;
QSysInfoH = class(TObject) end;
QSystemLocaleH = class(TObject) end;
QTableWidgetItemH = class(TObject) end;
QTableWidgetSelectionRangeH = class(TObject) end;
QTextBlockH = class(TObject) end;
QTextCursorH = class(TObject) end;
QTextDocumentFragmentH = class(TObject) end;
QTextFormatH = class(TObject) end;
  QTextBlockFormatH = class(QTextFormatH) end;
  QTextCharFormatH = class(QTextFormatH) end;
    QTextImageFormatH = class(QTextCharFormatH) end;
  QTextFrameFormatH = class(QTextFormatH) end;
    QTextTableFormatH = class(QTextFrameFormatH) end;
QTextInlineObjectH = class(TObject) end;
QTextLayoutH = class(TObject) end;
QTextLineH = class(TObject) end;
QTextObjectInterfaceH = class(TObject) end;
QTextOptionH = class(TObject) end;
QTimeH = class(TObject) end;
QToolTipH = class(TObject) end;
QTransformH = class(TObject) end;
QTreeWidgetItemH = class(TObject) end;
QUrlH = class(TObject) end;
QVariantH = class(TObject) end;
QVectorH = class(TObject) end;
  QPolygonH = class(QVectorH) end;
  QPolygonFH = class(QVectorH) end;
QWSEventH = class(TObject) end;
QWebDatabaseH = class(TObject) end;
QWebHistoryH = class(TObject) end;
QWebHistoryItemH = class(TObject) end;
QWebHitTestResultH = class(TObject) end;
QWebSecurityOriginH = class(TObject) end;
QWebSettingsH = class(TObject) end;
QWhatsThisH = class(TObject) end;
QX11InfoH = class(TObject) end;
QMatrixH = class(TObject) end;

QPainterPathElementH = class(TObject) end;
QObject_hookH = class(TObject) end;
QCoreApplication_hookH = class(QObject_hookH) end;
QTimer_hookH = class(QObject_hookH) end;
QModelIndex_hookH = class(QObject_hookH) end;
QPersistentModelIndex_hookH = class(QObject_hookH) end;
QAbstractItemModel_hookH = class(QObject_hookH) end;
QAbstractTableModel_hookH = class(QAbstractItemModel_hookH) end;
QAbstractListModel_hookH = class(QAbstractItemModel_hookH) end;
QSocketNotifier_hookH = class(QObject_hookH) end;
QThread_hookH = class(QObject_hookH) end;
QIODevice_hookH = class(QObject_hookH) end;
QProcess_hookH = class(QIODevice_hookH) end;
QFileSystemWatcher_hookH = class(QObject_hookH) end;
QApplication_hookH = class(QCoreApplication_hookH) end;
QWidget_hookH = class(QObject_hookH) end;
QLayout_hookH = class(QObject_hookH) end;
QStackedLayout_hookH = class(QLayout_hookH) end;
QAction_hookH = class(QObject_hookH) end;
QActionGroup_hookH = class(QObject_hookH) end;
QClipboard_hookH = class(QObject_hookH) end;
QDesktopWidget_hookH = class(QWidget_hookH) end;
QDrag_hookH = class(QObject_hookH) end;
QAbstractTextDocumentLayout_hookH = class(QObject_hookH) end;
QTextObjectInterface_hookH = class(QObject_hookH) end;
QFrame_hookH = class(QWidget_hookH) end;
QStackedWidget_hookH = class(QFrame_hookH) end;
QAbstractScrollArea_hookH = class(QFrame_hookH) end;
QAbstractSlider_hookH = class(QWidget_hookH) end;
QScrollBar_hookH = class(QAbstractSlider_hookH) end;
QMenu_hookH = class(QWidget_hookH) end;
QMenuBar_hookH = class(QWidget_hookH) end;
QButtonGroup_hookH = class(QObject_hookH) end;
QAbstractButton_hookH = class(QWidget_hookH) end;
QPushButton_hookH = class(QAbstractButton_hookH) end;
QLineEdit_hookH = class(QWidget_hookH) end;
QPlainTextEdit_hookH = class(QAbstractScrollArea_hookH) end;
QPlainTextDocumentLayout_hookH = class(QAbstractTextDocumentLayout_hookH) end;
QTextEdit_hookH = class(QAbstractScrollArea_hookH) end;
QTabWidget_hookH = class(QWidget_hookH) end;
QMainWindow_hookH = class(QWidget_hookH) end;
QToolBar_hookH = class(QWidget_hookH) end;
QLCDNumber_hookH = class(QFrame_hookH) end;
QAbstractSpinBox_hookH = class(QWidget_hookH) end;
QSpinBox_hookH = class(QAbstractSpinBox_hookH) end;
QDoubleSpinBox_hookH = class(QAbstractSpinBox_hookH) end;
QSplitter_hookH = class(QFrame_hookH) end;
QSplitterHandle_hookH = class(QWidget_hookH) end;
QComboBox_hookH = class(QWidget_hookH) end;
QCheckBox_hookH = class(QAbstractButton_hookH) end;
QSlider_hookH = class(QAbstractSlider_hookH) end;
QTextBrowser_hookH = class(QTextEdit_hookH) end;
QLabel_hookH = class(QFrame_hookH) end;
QGroupBox_hookH = class(QWidget_hookH) end;
QDockWidget_hookH = class(QWidget_hookH) end;
QTabBar_hookH = class(QWidget_hookH) end;
QProgressBar_hookH = class(QWidget_hookH) end;
QStatusBar_hookH = class(QWidget_hookH) end;
QToolBox_hookH = class(QFrame_hookH) end;
QToolButton_hookH = class(QAbstractButton_hookH) end;
QMdiArea_hookH = class(QAbstractScrollArea_hookH) end;
QMdiSubWindow_hookH = class(QWidget_hookH) end;
QCalendarWidget_hookH = class(QWidget_hookH) end;
QPrintPreviewWidget_hookH = class(QWidget_hookH) end;
QAbstractItemView_hookH = class(QAbstractScrollArea_hookH) end;
QListView_hookH = class(QAbstractItemView_hookH) end;
QItemSelectionRange_hookH = class(QObject_hookH) end;
QItemSelectionModel_hookH = class(QObject_hookH) end;
QListWidgetItem_hookH = class(QObject_hookH) end;
QListWidget_hookH = class(QListView_hookH) end;
QTreeView_hookH = class(QAbstractItemView_hookH) end;
QTreeWidgetItem_hookH = class(QObject_hookH) end;
QTreeWidget_hookH = class(QTreeView_hookH) end;
QHeaderView_hookH = class(QAbstractItemView_hookH) end;
QStandardItem_hookH = class(QObject_hookH) end;
QStandardItemModel_hookH = class(QAbstractItemModel_hookH) end;
QAbstractItemDelegate_hookH = class(QObject_hookH) end;
QTableView_hookH = class(QAbstractItemView_hookH) end;
QTableWidgetSelectionRange_hookH = class(QObject_hookH) end;
QTableWidgetItem_hookH = class(QObject_hookH) end;
QTableWidget_hookH = class(QTableView_hookH) end;
QDialog_hookH = class(QWidget_hookH) end;
QFileDialog_hookH = class(QDialog_hookH) end;
QProgressDialog_hookH = class(QDialog_hookH) end;
QAbstractPrintDialog_hookH = class(QDialog_hookH) end;
QPrintDialog_hookH = class(QAbstractPrintDialog_hookH) end;
QPrintPreviewDialog_hookH = class(QDialog_hookH) end;
QSystemTrayIcon_hookH = class(QObject_hookH) end;
QGraphicsScene_hookH = class(QObject_hookH) end;
QAbstractSocket_hookH = class(QIODevice_hookH) end;
QUdpSocket_hookH = class(QAbstractSocket_hookH) end;
QTcpSocket_hookH = class(QAbstractSocket_hookH) end;
QTcpServer_hookH = class(QObject_hookH) end;
QNetworkAccessManager_hookH = class(QObject_hookH) end;
QNetworkReply_hookH = class(QIODevice_hookH) end;
QWebHitTestResult_hookH = class(QObject_hookH) end;
QWebFrame_hookH = class(QObject_hookH) end;
QWebSecurityOrigin_hookH = class(QObject_hookH) end;
QWebDatabase_hookH = class(QObject_hookH) end;
QWebHistoryItem_hookH = class(QObject_hookH) end;
QWebHistory_hookH = class(QObject_hookH) end;
QWebHistoryInterface_hookH = class(QObject_hookH) end;
QWebPage_hookH = class(QObject_hookH) end;
QWebSettings_hookH = class(QObject_hookH) end;
QWebView_hookH = class(QWidget_hookH) end;

  QCoreApplicationEventFilter = function(Msg:PChar;Res:PLong):boolean cdecl;
QAbstractEventDispatcherEventFilter = function(Msg:PChar):boolean cdecl;
QLCLItemDelegate_sizeHint_Override = procedure (option: QStyleOptionViewItemH; index: QModelIndexH; Size: PSize) of object cdecl;
QLCLItemDelegate_paint_Override = procedure (painter : QPainterH; option: QStyleOptionViewItemH; index: QModelIndexH) of object cdecl;
QLCLItemDelegate_createEditor_Override = procedure (parent : QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH; out editor: QWidgetH) of object cdecl; 
QLCLItemDelegate_setEditorData_Override = procedure (editor : QWidgetH; index: QModelIndexH) of object cdecl;
QLCLItemDelegate_setModelData_Override = procedure (editor : QWidgetH; model: QAbstractItemModelH; index: QModelIndexH) of object cdecl;
QLCLItemDelegate_updateEditorGeometry_Override = procedure (editor : QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH) of object cdecl;
QLCLItemDelegate_editorEvent_Override = procedure (event : QEventH; model: QAbstractItemModelH; option: QStyleOptionViewItemH; index: QModelIndexH; retval: PBoolean) of object cdecl;
QLCLAbstractScrollArea_viewportEvent_Override = procedure (event: QEventH; retval: PBoolean) of object cdecl;
QLCLWebPage_userAgentForUrl_Override = procedure(url : QUrlH;userAgent:PWideString) of object; cdecl;
QLCLWebView_createWindow_Override = function (WebWindowType : integer):QWebViewH of object cdecl;
QLCLThread_run_Override = procedure of object cdecl;
QLCLTreeWidgetItem_data_Override = procedure (column: Integer; role: Integer; retval: QVariantH) of object cdecl;

type
  QObjectEventFilter = function (Sender:QObjectH; Event: QEventH):boolean of object cdecl;
  QObject_destroyed_Event = procedure of object; cdecl;
  function QtPoint(X,Y:integer): TQtPoint;
  function QtPointF(X,Y:QReal): TQtPointF;
  function QObject_hook_create(handle : QObjectH) : QObject_hookH; cdecl; external Qt4PasLib name 'QObject_hook_create';
  procedure QObject_hook_destroy(handle : QObject_hookH ); cdecl; external Qt4PasLib name 'QObject_hook_destroy';
  procedure QObject_hook_hook_events(handle : QObject_hookH; hook : QObjectEventFilter); cdecl; external Qt4PasLib name 'QObject_hook_hook_events';
  procedure QObject_hook_hook_destroyed(handle : QObject_hookH; hook : QObject_destroyed_Event); cdecl; external Qt4PasLib name 'QObject_hook_hook_destroyed';

type
  QtGlobalColor = ( // Qt::GlobalColor (1)
    Qtcolor0, Qtcolor1, Qtblack, Qtwhite, QtdarkGray, Qtgray, QtlightGray, Qtred, Qtgreen, Qtblue, Qtcyan, Qtmagenta, Qtyellow, QtdarkRed, QtdarkGreen, QtdarkBlue, QtdarkCyan, QtdarkMagenta, 
    QtdarkYellow, Qttransparent );

  QtSortOrder = ( // Qt::SortOrder (1)
    QtAscendingOrder, QtDescendingOrder );

  QtTextElideMode = ( // Qt::TextElideMode (1)
    QtElideLeft, QtElideRight, QtElideMiddle, QtElideNone );

  QtBGMode = ( // Qt::BGMode (1)
    QtTransparentMode, QtOpaqueMode );

  QtArrowType = ( // Qt::ArrowType (1)
    QtNoArrow, QtUpArrow, QtDownArrow, QtLeftArrow, QtRightArrow );

  QtPenStyle = ( // Qt::PenStyle (1)
    QtNoPen, QtSolidLine, QtDashLine, QtDotLine, QtDashDotLine, QtDashDotDotLine, QtCustomDashLine );

  QtSizeMode = ( // Qt::SizeMode (1)
    QtAbsoluteSize, QtRelativeSize );

  QtUIEffect = ( // Qt::UIEffect (1)
    QtUI_General, QtUI_AnimateMenu, QtUI_FadeMenu, QtUI_AnimateCombo, QtUI_AnimateTooltip, QtUI_FadeTooltip, QtUI_AnimateToolBox );

  QtTextFormat = ( // Qt::TextFormat (1)
    QtPlainText, QtRichText, QtAutoText, QtLogText );

  QtAspectRatioMode = ( // Qt::AspectRatioMode (1)
    QtIgnoreAspectRatio, QtKeepAspectRatio, QtKeepAspectRatioByExpanding );

  QtAnchorAttribute = ( // Qt::AnchorAttribute (1)
    QtAnchorName, QtAnchorHref );

  QtTimeSpec = ( // Qt::TimeSpec (1)
    QtLocalTime, QtUTC, QtOffsetFromUTC );

  QtScrollBarPolicy = ( // Qt::ScrollBarPolicy (1)
    QtScrollBarAsNeeded, QtScrollBarAlwaysOff, QtScrollBarAlwaysOn );

  QtCaseSensitivity = ( // Qt::CaseSensitivity (1)
    QtCaseInsensitive, QtCaseSensitive );

  QtConnectionType = ( // Qt::ConnectionType (1)
    QtAutoConnection, QtDirectConnection, QtQueuedConnection, QtAutoCompatConnection, QtBlockingQueuedConnection );

  QtShortcutContext = ( // Qt::ShortcutContext (1)
    QtWidgetShortcut, QtWindowShortcut, QtApplicationShortcut, QtWidgetWithChildrenShortcut );

  QtFillRule = ( // Qt::FillRule (1)
    QtOddEvenFill, QtWindingFill );

  QtMaskMode = ( // Qt::MaskMode (1)
    QtMaskInColor, QtMaskOutColor );

  QtClipOperation = ( // Qt::ClipOperation (1)
    QtNoClip, QtReplaceClip, QtIntersectClip, QtUniteClip );

  QtTransformationMode = ( // Qt::TransformationMode (1)
    QtFastTransformation, QtSmoothTransformation );

  QtAxis = ( // Qt::Axis (1)
    QtXAxis, QtYAxis, QtZAxis );

  QtFocusReason = ( // Qt::FocusReason (1)
    QtMouseFocusReason, QtTabFocusReason, QtBacktabFocusReason, QtActiveWindowFocusReason, QtPopupFocusReason, QtShortcutFocusReason, QtMenuBarFocusReason, QtOtherFocusReason, QtNoFocusReason );

  QtContextMenuPolicy = ( // Qt::ContextMenuPolicy (1)
    QtNoContextMenu, QtDefaultContextMenu, QtActionsContextMenu, QtCustomContextMenu, QtPreventContextMenu );

  QtInputMethodQuery = ( // Qt::InputMethodQuery (1)
    QtImMicroFocus, QtImFont, QtImCursorPosition, QtImSurroundingText, QtImCurrentSelection );

  QtToolButtonStyle = ( // Qt::ToolButtonStyle (1)
    QtToolButtonIconOnly, QtToolButtonTextOnly, QtToolButtonTextBesideIcon, QtToolButtonTextUnderIcon );

  QtLayoutDirection = ( // Qt::LayoutDirection (1)
    QtLeftToRight, QtRightToLeft, QtLayoutDirectionAuto );

  QtCheckState = ( // Qt::CheckState (1)
    QtUnchecked, QtPartiallyChecked, QtChecked );

  QtWindowModality = ( // Qt::WindowModality (1)
    QtNonModal, QtWindowModal, QtApplicationModal );

  QtSizeHint = ( // Qt::SizeHint (1)
    QtMinimumSize, QtPreferredSize, QtMaximumSize, QtMinimumDescent, QtNSizeHints );

  QtWindowFrameSection = ( // Qt::WindowFrameSection (1)
    QtNoSection, QtLeftSection, QtTopLeftSection, QtTopSection, QtTopRightSection, QtRightSection, QtBottomRightSection, QtBottomSection, QtBottomLeftSection, QtTitleBarArea );

  QtHitTestAccuracy = ( // Qt::HitTestAccuracy (1)
    QtHitTestAccuracy_dummy );

type
  QtKeyboardModifier = cardinal; // Qt::KeyboardModifier
  QtKeyboardModifiers = QtKeyboardModifier; //QFlags<> (3)
const
  QtNoModifier =   $00000000;
  QtShiftModifier =   $02000000;
  QtControlModifier =   $04000000;
  QtAltModifier =   $08000000;
  QtMetaModifier =   $10000000;
  QtKeypadModifier =   $20000000;
  QtGroupSwitchModifier =   $40000000;
  QtKeyboardModifierMask =   $fe000000;

type
  QtMouseButton = cardinal; // Qt::MouseButton
  QtMouseButtons = QtMouseButton; //QFlags<> (3)
const
  QtNoButton =   $00000000;
  QtLeftButton =   $00000001;
  QtRightButton =   $00000002;
  QtMidButton =   $00000004;
  QtXButton1 =   $00000008;
  QtXButton2 =   $00000010;
  QtMouseButtonMask =   $000000ff;

type
  QtOrientation = cardinal; // Qt::Orientation
  QtOrientations = QtOrientation; //QFlags<> (3)
const
  QtHorizontal =   $1;
  QtVertical =   $2;

type
  QtWindowState = cardinal; // Qt::WindowState
  QtWindowStates = QtWindowState; //QFlags<> (3)
const
  QtWindowNoState =   $00000000;
  QtWindowMinimized =   $00000001;
  QtWindowMaximized =   $00000002;
  QtWindowFullScreen =   $00000004;
  QtWindowActive =   $00000008;


type
  QtApplicationAttribute = (  //Qt::ApplicationAttribute (2)
    QtAA_ImmediateWidgetCreation = 0,
    QtAA_MSWindowsUseDirect3DByDefault = 1,
    QtAA_DontShowIconsInMenus = 2,
    QtAA_NativeWindows = 3,
    QtAA_DontCreateNativeWidgetSiblings = 4,
    QtAA_MacPluginApplication = 5,
    {$IFDEF DARWIN}
    QtAA_DontUseNativeMenuBar = 6, {$note QtAA_DontUseNativeMenuBar added for darwin and wince qt >=4.6 compat issue #20897}
    QtAA_MacDontSwapCtrlAndMeta = 7, {$note QtAA_MacDontSwapCtrlAndMeta added for darwin qt >=4.6 compat issue #20897}
    {$ENDIF}
    QtAA_AttributeCount );

type
  QtImageConversionFlag = cardinal; // Qt::ImageConversionFlag
  QtImageConversionFlags = QtImageConversionFlag; //QFlags<> (3)
const
  QtColorMode_Mask =   $00000003;
  QtAutoColor =   $00000000;
  QtColorOnly =   $00000003;
  QtMonoOnly =   $00000002;
  QtAlphaDither_Mask =   $0000000c;
  QtThresholdAlphaDither =   $00000000;
  QtOrderedAlphaDither =   $00000004;
  QtDiffuseAlphaDither =   $00000008;
  QtNoAlpha =   $0000000c;
  QtDither_Mask =   $00000030;
  QtDiffuseDither =   $00000000;
  QtOrderedDither =   $00000010;
  QtThresholdDither =   $00000020;
  QtDitherMode_Mask =   $000000c0;
  QtAutoDither =   $00000000;
  QtPreferDither =   $00000040;
  QtAvoidDither =   $00000080;
  QtNoOpaqueDetection =   $00000100;


type
  QtPenCapStyle = (  //Qt::PenCapStyle (2)
    QtFlatCap = $00,
    QtSquareCap = $10,
    QtRoundCap = $20,
    QtMPenCapStyle = $30 );

  QtPenJoinStyle = (  //Qt::PenJoinStyle (2)
    QtMiterJoin = $00,
    QtBevelJoin = $40,
    QtRoundJoin = $80,
    QtSvgMiterJoin = $100,
    QtMPenJoinStyle = $1c0 );

  QtBrushStyle = (  //Qt::BrushStyle (2)
    QtNoBrush,
    QtSolidPattern,
    QtDense1Pattern,
    QtDense2Pattern,
    QtDense3Pattern,
    QtDense4Pattern,
    QtDense5Pattern,
    QtDense6Pattern,
    QtDense7Pattern,
    QtHorPattern,
    QtVerPattern,
    QtCrossPattern,
    QtBDiagPattern,
    QtFDiagPattern,
    QtDiagCrossPattern,
    QtLinearGradientPattern,
    QtRadialGradientPattern,
    QtConicalGradientPattern,
    QtTexturePattern = 24 );

  QtDockWidgetAreaSizes = (  //Qt::DockWidgetAreaSizes (2)
    QtNDockWidgetAreas = 4 );

  QtToolBarAreaSizes = (  //Qt::ToolBarAreaSizes (2)
    QtNToolBarAreas = 4 );

  QtDayOfWeek = (  //Qt::DayOfWeek (2)
    QtMonday = 1,
    QtTuesday = 2,
    QtWednesday = 3,
    QtThursday = 4,
    QtFriday = 5,
    QtSaturday = 6,
    QtSunday = 7 );

  QtCorner = (  //Qt::Corner (2)
    QtTopLeftCorner = $00000,
    QtTopRightCorner = $00001,
    QtBottomLeftCorner = $00002,
    QtBottomRightCorner = $00003 );

  QtItemSelectionMode = (  //Qt::ItemSelectionMode (2)
    QtContainsItemShape = $0,
    QtIntersectsItemShape = $1,
    QtContainsItemBoundingRect = $2,
    QtIntersectsItemBoundingRect = $3 );

type
  QtDropAction = cardinal; // Qt::DropAction
  QtDropActions = QtDropAction; //QFlags<> (3)
const
  QtCopyAction =   $1;
  QtMoveAction =   $2;
  QtLinkAction =   $4;
  QtActionMask =   $ff;
  QtTargetMoveAction =   $8002;
  QtIgnoreAction =   $0;


type
  QtItemDataRole = (  //Qt::ItemDataRole (2)
    QtDisplayRole = 0,
    QtDecorationRole = 1,
    QtEditRole = 2,
    QtToolTipRole = 3,
    QtStatusTipRole = 4,
    QtWhatsThisRole = 5,
    QtFontRole = 6,
    QtTextAlignmentRole = 7,
    QtBackgroundColorRole = 8,
//  QtBackgroundRole = 8 {duplicate},
    QtForegroundRole = 9,
//  QtTextColorRole = 9 {duplicate},
    QtCheckStateRole = 10,
    QtAccessibleTextRole = 11,
    QtAccessibleDescriptionRole = 12,
    QtSizeHintRole = 13,
    QtDisplayPropertyRole = 27,
    QtDecorationPropertyRole = 28,
    QtToolTipPropertyRole = 29,
    QtStatusTipPropertyRole = 30,
    QtWhatsThisPropertyRole = 31,
    QtUserRole = 32 );

type
  QtItemFlag = cardinal; // Qt::ItemFlag
  QtItemFlags = QtItemFlag; //QFlags<> (3)
const
  QtNoItemFlags =   0;
  QtItemIsSelectable =   1;
  QtItemIsEditable =   2;
  QtItemIsDragEnabled =   4;
  QtItemIsDropEnabled =   8;
  QtItemIsUserCheckable =   16;
  QtItemIsEnabled =   32;
  QtItemIsTristate =   64;

type
  QtMatchFlag = cardinal; // Qt::MatchFlag
  QtMatchFlags = QtMatchFlag; //QFlags<> (3)
const
  QtMatchExactly =   0;
  QtMatchContains =   1;
  QtMatchStartsWith =   2;
  QtMatchEndsWith =   3;
  QtMatchRegExp =   4;
  QtMatchWildcard =   5;
  QtMatchFixedString =   8;
  QtMatchCaseSensitive =   16;
  QtMatchWrap =   32;
  QtMatchRecursive =   64;


type
  QtEventPriority = (  //Qt::EventPriority (2)
    QtLowEventPriority = -1,
    QtNormalEventPriority = 0,
    QtHighEventPriority = 1 );


type
  QInternalRelayoutType = ( // QInternal::RelayoutType (1)
    QInternalRelayoutNormal, QInternalRelayoutDragging, QInternalRelayoutDropped );

  QInternalCallback = ( // QInternal::Callback (1)
    QInternalConnectCallback, QInternalDisconnectCallback, QInternalAdoptCurrentThread, QInternalEventNotifyCallback, QInternalLastCallback );

  QInternalInternalFunction = ( // QInternal::InternalFunction (1)
    QInternalCreateThreadForAdoption, QInternalRefAdoptedThread, QInternalDerefAdoptedThread, QInternalSetCurrentThreadToMainThread, QInternalSetQObjectSender, QInternalGetQObjectSender, 
    QInternalResetQObjectSender, QInternalLastInternalFunction );

  QInternalDockPosition = ( // QInternal::DockPosition (1)
    QInternalLeftDock, QInternalRightDock, QInternalTopDock, QInternalBottomDock, QInternalDockCount );

  QInternalPaintDeviceFlags = (  //QInternal::PaintDeviceFlags (2)
    QInternalUnknownDevice = $00,
    QInternalWidget = $01,
    QInternalPixmap = $02,
    QInternalImage = $03,
    QInternalPrinter = $04,
    QInternalPicture = $05,
    QInternalPbuffer = $06,
    QInternalFramebufferObject = $07,
    QInternalCustomRaster = $08,
    QInternalMacQuartz = $09 );

type
  QtModifier = cardinal; //  Qt::Modifier (4)

const
    QtMETA = 268435456 { $10000000 };
    QtSHIFT = 33554432 { $2000000 };
    QtCTRL = 67108864 { $4000000 };
    QtALT = 134217728 { $8000000 };
    QtMODIFIER_MASK = 4261412864 { $fe000000 };
    QtUNICODE_ACCEL = 0 { $0 };

type
  QtFocusPolicy = cardinal; //  Qt::FocusPolicy (4)

const
    QtNoFocus = 0 { $0 };
    QtTabFocus = 1 { $1 };
    QtClickFocus = 2 { $2 };
    QtStrongFocus = 11 { $b };
    QtWheelFocus = 15 { $f };

type
  QtAlignmentFlag = cardinal; //  Qt::AlignmentFlag (4)
  QtAlignment = QtAlignmentFlag; // QFlags<>

const
    QtAlignLeft = 1 { $1 };
    QtAlignLeading = 1 { $1 };
    QtAlignRight = 2 { $2 };
    QtAlignTrailing = 2 { $2 };
    QtAlignHCenter = 4 { $4 };
    QtAlignJustify = 8 { $8 };
    QtAlignAbsolute = 16 { $10 };
    QtAlignHorizontal_Mask = 31 { $1f };
    QtAlignTop = 32 { $20 };
    QtAlignBottom = 64 { $40 };
    QtAlignVCenter = 128 { $80 };
    QtAlignVertical_Mask = 224 { $e0 };
    QtAlignCenter = 132 { $84 };

type
  QtWindowType = cardinal; //  Qt::WindowType (4)
  QtWindowFlags = QtWindowType; // QFlags<>

const
    QtWidget = 0 { $0 };
    QtWindow = 1 { $1 };
    QtDialog = 3 { $3 };
    QtSheet = 5 { $5 };
    QtDrawer = 7 { $7 };
    QtPopup = 9 { $9 };
    QtTool = 11 { $b };
    QtToolTip = 13 { $d };
    QtSplashScreen = 15 { $f };
    QtDesktop = 17 { $11 };
    QtSubWindow = 18 { $12 };
    QtWindowType_Mask = 255 { $ff };
    QtMSWindowsFixedSizeDialogHint = 256 { $100 };
    QtMSWindowsOwnDC = 512 { $200 };
    QtX11BypassWindowManagerHint = 1024 { $400 };
    QtFramelessWindowHint = 2048 { $800 };
    QtWindowTitleHint = 4096 { $1000 };
    QtWindowSystemMenuHint = 8192 { $2000 };
    QtWindowMinimizeButtonHint = 16384 { $4000 };
    QtWindowMaximizeButtonHint = 32768 { $8000 };
    QtWindowMinMaxButtonsHint = 49152 { $c000 };
    QtWindowContextHelpButtonHint = 65536 { $10000 };
    QtWindowShadeButtonHint = 131072 { $20000 };
    QtWindowStaysOnTopHint = 262144 { $40000 };
    QtCustomizeWindowHint = 33554432 { $2000000 };
    QtWindowStaysOnBottomHint = 67108864 { $4000000 };
    QtWindowCloseButtonHint = 134217728 { $8000000 };
    QtMacWindowToolBarButtonHint = 268435456 { $10000000 };
    QtBypassGraphicsProxyWidget = 536870912 { $20000000 };
    QtWindowOkButtonHint = 524288 { $80000 };
    QtWindowCancelButtonHint = 1048576 { $100000 };

type
  QtWidgetAttribute = cardinal; //  Qt::WidgetAttribute (4)

const
    QtWA_Disabled = 0 { $0 };
    QtWA_UnderMouse = 1 { $1 };
    QtWA_MouseTracking = 2 { $2 };
    QtWA_ContentsPropagated = 3 { $3 };
    QtWA_OpaquePaintEvent = 4 { $4 };
    QtWA_NoBackground = 4 { $4 };
    QtWA_StaticContents = 5 { $5 };
    QtWA_LaidOut = 7 { $7 };
    QtWA_PaintOnScreen = 8 { $8 };
    QtWA_NoSystemBackground = 9 { $9 };
    QtWA_UpdatesDisabled = 10 { $a };
    QtWA_Mapped = 11 { $b };
    QtWA_MacNoClickThrough = 12 { $c };
    QtWA_PaintOutsidePaintEvent = 13 { $d };
    QtWA_InputMethodEnabled = 14 { $e };
    QtWA_WState_Visible = 15 { $f };
    QtWA_WState_Hidden = 16 { $10 };
    QtWA_ForceDisabled = 32 { $20 };
    QtWA_KeyCompression = 33 { $21 };
    QtWA_PendingMoveEvent = 34 { $22 };
    QtWA_PendingResizeEvent = 35 { $23 };
    QtWA_SetPalette = 36 { $24 };
    QtWA_SetFont = 37 { $25 };
    QtWA_SetCursor = 38 { $26 };
    QtWA_NoChildEventsFromChildren = 39 { $27 };
    QtWA_WindowModified = 41 { $29 };
    QtWA_Resized = 42 { $2a };
    QtWA_Moved = 43 { $2b };
    QtWA_PendingUpdate = 44 { $2c };
    QtWA_InvalidSize = 45 { $2d };
    QtWA_MacBrushedMetal = 46 { $2e };
    QtWA_MacMetalStyle = 46 { $2e };
    QtWA_CustomWhatsThis = 47 { $2f };
    QtWA_LayoutOnEntireRect = 48 { $30 };
    QtWA_OutsideWSRange = 49 { $31 };
    QtWA_GrabbedShortcut = 50 { $32 };
    QtWA_TransparentForMouseEvents = 51 { $33 };
    QtWA_PaintUnclipped = 52 { $34 };
    QtWA_SetWindowIcon = 53 { $35 };
    QtWA_NoMouseReplay = 54 { $36 };
    QtWA_DeleteOnClose = 55 { $37 };
    QtWA_RightToLeft = 56 { $38 };
    QtWA_SetLayoutDirection = 57 { $39 };
    QtWA_NoChildEventsForParent = 58 { $3a };
    QtWA_ForceUpdatesDisabled = 59 { $3b };
    QtWA_WState_Created = 60 { $3c };
    QtWA_WState_CompressKeys = 61 { $3d };
    QtWA_WState_InPaintEvent = 62 { $3e };
    QtWA_WState_Reparented = 63 { $3f };
    QtWA_WState_ConfigPending = 64 { $40 };
    QtWA_WState_Polished = 66 { $42 };
    QtWA_WState_DND = 67 { $43 };
    QtWA_WState_OwnSizePolicy = 68 { $44 };
    QtWA_WState_ExplicitShowHide = 69 { $45 };
    QtWA_ShowModal = 70 { $46 };
    QtWA_MouseNoMask = 71 { $47 };
    QtWA_GroupLeader = 72 { $48 };
    QtWA_NoMousePropagation = 73 { $49 };
    QtWA_Hover = 74 { $4a };
    QtWA_InputMethodTransparent = 75 { $4b };
    QtWA_QuitOnClose = 76 { $4c };
    QtWA_KeyboardFocusChange = 77 { $4d };
    QtWA_AcceptDrops = 78 { $4e };
    QtWA_DropSiteRegistered = 79 { $4f };
    QtWA_ForceAcceptDrops = 79 { $4f };
    QtWA_WindowPropagation = 80 { $50 };
    QtWA_NoX11EventCompression = 81 { $51 };
    QtWA_TintedBackground = 82 { $52 };
    QtWA_X11OpenGLOverlay = 83 { $53 };
    QtWA_AlwaysShowToolTips = 84 { $54 };
    QtWA_MacOpaqueSizeGrip = 85 { $55 };
    QtWA_SetStyle = 86 { $56 };
    QtWA_SetLocale = 87 { $57 };
    QtWA_MacShowFocusRect = 88 { $58 };
    QtWA_MacNormalSize = 89 { $59 };
    QtWA_MacSmallSize = 90 { $5a };
    QtWA_MacMiniSize = 91 { $5b };
    QtWA_LayoutUsesWidgetRect = 92 { $5c };
    QtWA_StyledBackground = 93 { $5d };
    QtWA_MSWindowsUseDirect3D = 94 { $5e };
    QtWA_CanHostQMdiSubWindowTitleBar = 95 { $5f };
    QtWA_MacAlwaysShowToolWindow = 96 { $60 };
    QtWA_StyleSheet = 97 { $61 };
    QtWA_ShowWithoutActivating = 98 { $62 };
    QtWA_X11BypassTransientForHint = 99 { $63 };
    QtWA_NativeWindow = 100 { $64 };
    QtWA_DontCreateNativeAncestors = 101 { $65 };
    QtWA_MacVariableSize = 102 { $66 };
    QtWA_DontShowOnScreen = 103 { $67 };
    QtWA_X11NetWmWindowTypeDesktop = 104 { $68 };
    QtWA_X11NetWmWindowTypeDock = 105 { $69 };
    QtWA_X11NetWmWindowTypeToolBar = 106 { $6a };
    QtWA_X11NetWmWindowTypeMenu = 107 { $6b };
    QtWA_X11NetWmWindowTypeUtility = 108 { $6c };
    QtWA_X11NetWmWindowTypeSplash = 109 { $6d };
    QtWA_X11NetWmWindowTypeDialog = 110 { $6e };
    QtWA_X11NetWmWindowTypeDropDownMenu = 111 { $6f };
    QtWA_X11NetWmWindowTypePopupMenu = 112 { $70 };
    QtWA_X11NetWmWindowTypeToolTip = 113 { $71 };
    QtWA_X11NetWmWindowTypeNotification = 114 { $72 };
    QtWA_X11NetWmWindowTypeCombo = 115 { $73 };
    QtWA_X11NetWmWindowTypeDND = 116 { $74 };
    QtWA_MacFrameworkScaled = 117 { $75 };
    QtWA_SetWindowModality = 118 { $76 };
    QtWA_WState_WindowOpacitySet = 119 { $77 };
    QtWA_TranslucentBackground = 120 { $78 };
    QtWA_AttributeCount = 121 { $79 };

type
  QtKey = cardinal; //  Qt::Key (4)

const
    QtKey_Escape = 16777216 { $1000000 };
    QtKey_Tab = 16777217 { $1000001 };
    QtKey_Backtab = 16777218 { $1000002 };
    QtKey_Backspace = 16777219 { $1000003 };
    QtKey_Return = 16777220 { $1000004 };
    QtKey_Enter = 16777221 { $1000005 };
    QtKey_Insert = 16777222 { $1000006 };
    QtKey_Delete = 16777223 { $1000007 };
    QtKey_Pause = 16777224 { $1000008 };
    QtKey_Print = 16777225 { $1000009 };
    QtKey_SysReq = 16777226 { $100000a };
    QtKey_Clear = 16777227 { $100000b };
    QtKey_Home = 16777232 { $1000010 };
    QtKey_End = 16777233 { $1000011 };
    QtKey_Left = 16777234 { $1000012 };
    QtKey_Up = 16777235 { $1000013 };
    QtKey_Right = 16777236 { $1000014 };
    QtKey_Down = 16777237 { $1000015 };
    QtKey_PageUp = 16777238 { $1000016 };
    QtKey_PageDown = 16777239 { $1000017 };
    QtKey_Shift = 16777248 { $1000020 };
    QtKey_Control = 16777249 { $1000021 };
    QtKey_Meta = 16777250 { $1000022 };
    QtKey_Alt = 16777251 { $1000023 };
    QtKey_CapsLock = 16777252 { $1000024 };
    QtKey_NumLock = 16777253 { $1000025 };
    QtKey_ScrollLock = 16777254 { $1000026 };
    QtKey_F1 = 16777264 { $1000030 };
    QtKey_F2 = 16777265 { $1000031 };
    QtKey_F3 = 16777266 { $1000032 };
    QtKey_F4 = 16777267 { $1000033 };
    QtKey_F5 = 16777268 { $1000034 };
    QtKey_F6 = 16777269 { $1000035 };
    QtKey_F7 = 16777270 { $1000036 };
    QtKey_F8 = 16777271 { $1000037 };
    QtKey_F9 = 16777272 { $1000038 };
    QtKey_F10 = 16777273 { $1000039 };
    QtKey_F11 = 16777274 { $100003a };
    QtKey_F12 = 16777275 { $100003b };
    QtKey_F13 = 16777276 { $100003c };
    QtKey_F14 = 16777277 { $100003d };
    QtKey_F15 = 16777278 { $100003e };
    QtKey_F16 = 16777279 { $100003f };
    QtKey_F17 = 16777280 { $1000040 };
    QtKey_F18 = 16777281 { $1000041 };
    QtKey_F19 = 16777282 { $1000042 };
    QtKey_F20 = 16777283 { $1000043 };
    QtKey_F21 = 16777284 { $1000044 };
    QtKey_F22 = 16777285 { $1000045 };
    QtKey_F23 = 16777286 { $1000046 };
    QtKey_F24 = 16777287 { $1000047 };
    QtKey_F25 = 16777288 { $1000048 };
    QtKey_F26 = 16777289 { $1000049 };
    QtKey_F27 = 16777290 { $100004a };
    QtKey_F28 = 16777291 { $100004b };
    QtKey_F29 = 16777292 { $100004c };
    QtKey_F30 = 16777293 { $100004d };
    QtKey_F31 = 16777294 { $100004e };
    QtKey_F32 = 16777295 { $100004f };
    QtKey_F33 = 16777296 { $1000050 };
    QtKey_F34 = 16777297 { $1000051 };
    QtKey_F35 = 16777298 { $1000052 };
    QtKey_Super_L = 16777299 { $1000053 };
    QtKey_Super_R = 16777300 { $1000054 };
    QtKey_Menu = 16777301 { $1000055 };
    QtKey_Hyper_L = 16777302 { $1000056 };
    QtKey_Hyper_R = 16777303 { $1000057 };
    QtKey_Help = 16777304 { $1000058 };
    QtKey_Direction_L = 16777305 { $1000059 };
    QtKey_Direction_R = 16777312 { $1000060 };
    QtKey_Space = 32 { $20 };
    QtKey_Any = 32 { $20 };
    QtKey_Exclam = 33 { $21 };
    QtKey_QuoteDbl = 34 { $22 };
    QtKey_NumberSign = 35 { $23 };
    QtKey_Dollar = 36 { $24 };
    QtKey_Percent = 37 { $25 };
    QtKey_Ampersand = 38 { $26 };
    QtKey_Apostrophe = 39 { $27 };
    QtKey_ParenLeft = 40 { $28 };
    QtKey_ParenRight = 41 { $29 };
    QtKey_Asterisk = 42 { $2a };
    QtKey_Plus = 43 { $2b };
    QtKey_Comma = 44 { $2c };
    QtKey_Minus = 45 { $2d };
    QtKey_Period = 46 { $2e };
    QtKey_Slash = 47 { $2f };
    QtKey_0 = 48 { $30 };
    QtKey_1 = 49 { $31 };
    QtKey_2 = 50 { $32 };
    QtKey_3 = 51 { $33 };
    QtKey_4 = 52 { $34 };
    QtKey_5 = 53 { $35 };
    QtKey_6 = 54 { $36 };
    QtKey_7 = 55 { $37 };
    QtKey_8 = 56 { $38 };
    QtKey_9 = 57 { $39 };
    QtKey_Colon = 58 { $3a };
    QtKey_Semicolon = 59 { $3b };
    QtKey_Less = 60 { $3c };
    QtKey_Equal = 61 { $3d };
    QtKey_Greater = 62 { $3e };
    QtKey_Question = 63 { $3f };
    QtKey_At = 64 { $40 };
    QtKey_A = 65 { $41 };
    QtKey_B = 66 { $42 };
    QtKey_C = 67 { $43 };
    QtKey_D = 68 { $44 };
    QtKey_E = 69 { $45 };
    QtKey_F = 70 { $46 };
    QtKey_G = 71 { $47 };
    QtKey_H = 72 { $48 };
    QtKey_I = 73 { $49 };
    QtKey_J = 74 { $4a };
    QtKey_K = 75 { $4b };
    QtKey_L = 76 { $4c };
    QtKey_M = 77 { $4d };
    QtKey_N = 78 { $4e };
    QtKey_O = 79 { $4f };
    QtKey_P = 80 { $50 };
    QtKey_Q = 81 { $51 };
    QtKey_R = 82 { $52 };
    QtKey_S = 83 { $53 };
    QtKey_T = 84 { $54 };
    QtKey_U = 85 { $55 };
    QtKey_V = 86 { $56 };
    QtKey_W = 87 { $57 };
    QtKey_X = 88 { $58 };
    QtKey_Y = 89 { $59 };
    QtKey_Z = 90 { $5a };
    QtKey_BracketLeft = 91 { $5b };
    QtKey_Backslash = 92 { $5c };
    QtKey_BracketRight = 93 { $5d };
    QtKey_AsciiCircum = 94 { $5e };
    QtKey_Underscore = 95 { $5f };
    QtKey_QuoteLeft = 96 { $60 };
    QtKey_BraceLeft = 123 { $7b };
    QtKey_Bar = 124 { $7c };
    QtKey_BraceRight = 125 { $7d };
    QtKey_AsciiTilde = 126 { $7e };
    QtKey_nobreakspace = 160 { $a0 };
    QtKey_exclamdown = 161 { $a1 };
    QtKey_cent = 162 { $a2 };
    QtKey_sterling = 163 { $a3 };
    QtKey_currency = 164 { $a4 };
    QtKey_yen = 165 { $a5 };
    QtKey_brokenbar = 166 { $a6 };
    QtKey_section = 167 { $a7 };
    QtKey_diaeresis = 168 { $a8 };
    QtKey_copyright = 169 { $a9 };
    QtKey_ordfeminine = 170 { $aa };
    QtKey_guillemotleft = 171 { $ab };
    QtKey_notsign = 172 { $ac };
    QtKey_hyphen = 173 { $ad };
    QtKey_registered = 174 { $ae };
    QtKey_macron = 175 { $af };
    QtKey_degree = 176 { $b0 };
    QtKey_plusminus = 177 { $b1 };
    QtKey_twosuperior = 178 { $b2 };
    QtKey_threesuperior = 179 { $b3 };
    QtKey_acute = 180 { $b4 };
    QtKey_mu = 181 { $b5 };
    QtKey_paragraph = 182 { $b6 };
    QtKey_periodcentered = 183 { $b7 };
    QtKey_cedilla = 184 { $b8 };
    QtKey_onesuperior = 185 { $b9 };
    QtKey_masculine = 186 { $ba };
    QtKey_guillemotright = 187 { $bb };
    QtKey_onequarter = 188 { $bc };
    QtKey_onehalf = 189 { $bd };
    QtKey_threequarters = 190 { $be };
    QtKey_questiondown = 191 { $bf };
    QtKey_Agrave = 192 { $c0 };
    QtKey_Aacute = 193 { $c1 };
    QtKey_Acircumflex = 194 { $c2 };
    QtKey_Atilde = 195 { $c3 };
    QtKey_Adiaeresis = 196 { $c4 };
    QtKey_Aring = 197 { $c5 };
    QtKey_AE = 198 { $c6 };
    QtKey_Ccedilla = 199 { $c7 };
    QtKey_Egrave = 200 { $c8 };
    QtKey_Eacute = 201 { $c9 };
    QtKey_Ecircumflex = 202 { $ca };
    QtKey_Ediaeresis = 203 { $cb };
    QtKey_Igrave = 204 { $cc };
    QtKey_Iacute = 205 { $cd };
    QtKey_Icircumflex = 206 { $ce };
    QtKey_Idiaeresis = 207 { $cf };
    QtKey_ETH = 208 { $d0 };
    QtKey_Ntilde = 209 { $d1 };
    QtKey_Ograve = 210 { $d2 };
    QtKey_Oacute = 211 { $d3 };
    QtKey_Ocircumflex = 212 { $d4 };
    QtKey_Otilde = 213 { $d5 };
    QtKey_Odiaeresis = 214 { $d6 };
    QtKey_multiply = 215 { $d7 };
    QtKey_Ooblique = 216 { $d8 };
    QtKey_Ugrave = 217 { $d9 };
    QtKey_Uacute = 218 { $da };
    QtKey_Ucircumflex = 219 { $db };
    QtKey_Udiaeresis = 220 { $dc };
    QtKey_Yacute = 221 { $dd };
    QtKey_THORN = 222 { $de };
    QtKey_ssharp = 223 { $df };
    QtKey_division = 247 { $f7 };
    QtKey_ydiaeresis = 255 { $ff };
    QtKey_AltGr = 16781571 { $1001103 };
    QtKey_Multi_key = 16781600 { $1001120 };
    QtKey_Codeinput = 16781623 { $1001137 };
    QtKey_SingleCandidate = 16781628 { $100113c };
    QtKey_MultipleCandidate = 16781629 { $100113d };
    QtKey_PreviousCandidate = 16781630 { $100113e };
    QtKey_Mode_switch = 16781694 { $100117e };
    QtKey_Kanji = 16781601 { $1001121 };
    QtKey_Muhenkan = 16781602 { $1001122 };
    QtKey_Henkan = 16781603 { $1001123 };
    QtKey_Romaji = 16781604 { $1001124 };
    QtKey_Hiragana = 16781605 { $1001125 };
    QtKey_Katakana = 16781606 { $1001126 };
    QtKey_Hiragana_Katakana = 16781607 { $1001127 };
    QtKey_Zenkaku = 16781608 { $1001128 };
    QtKey_Hankaku = 16781609 { $1001129 };
    QtKey_Zenkaku_Hankaku = 16781610 { $100112a };
    QtKey_Touroku = 16781611 { $100112b };
    QtKey_Massyo = 16781612 { $100112c };
    QtKey_Kana_Lock = 16781613 { $100112d };
    QtKey_Kana_Shift = 16781614 { $100112e };
    QtKey_Eisu_Shift = 16781615 { $100112f };
    QtKey_Eisu_toggle = 16781616 { $1001130 };
    QtKey_Hangul = 16781617 { $1001131 };
    QtKey_Hangul_Start = 16781618 { $1001132 };
    QtKey_Hangul_End = 16781619 { $1001133 };
    QtKey_Hangul_Hanja = 16781620 { $1001134 };
    QtKey_Hangul_Jamo = 16781621 { $1001135 };
    QtKey_Hangul_Romaja = 16781622 { $1001136 };
    QtKey_Hangul_Jeonja = 16781624 { $1001138 };
    QtKey_Hangul_Banja = 16781625 { $1001139 };
    QtKey_Hangul_PreHanja = 16781626 { $100113a };
    QtKey_Hangul_PostHanja = 16781627 { $100113b };
    QtKey_Hangul_Special = 16781631 { $100113f };
    QtKey_Dead_Grave = 16781904 { $1001250 };
    QtKey_Dead_Acute = 16781905 { $1001251 };
    QtKey_Dead_Circumflex = 16781906 { $1001252 };
    QtKey_Dead_Tilde = 16781907 { $1001253 };
    QtKey_Dead_Macron = 16781908 { $1001254 };
    QtKey_Dead_Breve = 16781909 { $1001255 };
    QtKey_Dead_Abovedot = 16781910 { $1001256 };
    QtKey_Dead_Diaeresis = 16781911 { $1001257 };
    QtKey_Dead_Abovering = 16781912 { $1001258 };
    QtKey_Dead_Doubleacute = 16781913 { $1001259 };
    QtKey_Dead_Caron = 16781914 { $100125a };
    QtKey_Dead_Cedilla = 16781915 { $100125b };
    QtKey_Dead_Ogonek = 16781916 { $100125c };
    QtKey_Dead_Iota = 16781917 { $100125d };
    QtKey_Dead_Voiced_Sound = 16781918 { $100125e };
    QtKey_Dead_Semivoiced_Sound = 16781919 { $100125f };
    QtKey_Dead_Belowdot = 16781920 { $1001260 };
    QtKey_Dead_Hook = 16781921 { $1001261 };
    QtKey_Dead_Horn = 16781922 { $1001262 };
    QtKey_Back = 16777313 { $1000061 };
    QtKey_Forward = 16777314 { $1000062 };
    QtKey_Stop = 16777315 { $1000063 };
    QtKey_Refresh = 16777316 { $1000064 };
    QtKey_VolumeDown = 16777328 { $1000070 };
    QtKey_VolumeMute = 16777329 { $1000071 };
    QtKey_VolumeUp = 16777330 { $1000072 };
    QtKey_BassBoost = 16777331 { $1000073 };
    QtKey_BassUp = 16777332 { $1000074 };
    QtKey_BassDown = 16777333 { $1000075 };
    QtKey_TrebleUp = 16777334 { $1000076 };
    QtKey_TrebleDown = 16777335 { $1000077 };
    QtKey_MediaPlay = 16777344 { $1000080 };
    QtKey_MediaStop = 16777345 { $1000081 };
    QtKey_MediaPrevious = 16777346 { $1000082 };
    QtKey_MediaNext = 16777347 { $1000083 };
    QtKey_MediaRecord = 16777348 { $1000084 };
    QtKey_HomePage = 16777360 { $1000090 };
    QtKey_Favorites = 16777361 { $1000091 };
    QtKey_Search = 16777362 { $1000092 };
    QtKey_Standby = 16777363 { $1000093 };
    QtKey_OpenUrl = 16777364 { $1000094 };
    QtKey_LaunchMail = 16777376 { $10000a0 };
    QtKey_LaunchMedia = 16777377 { $10000a1 };
    QtKey_Launch0 = 16777378 { $10000a2 };
    QtKey_Launch1 = 16777379 { $10000a3 };
    QtKey_Launch2 = 16777380 { $10000a4 };
    QtKey_Launch3 = 16777381 { $10000a5 };
    QtKey_Launch4 = 16777382 { $10000a6 };
    QtKey_Launch5 = 16777383 { $10000a7 };
    QtKey_Launch6 = 16777384 { $10000a8 };
    QtKey_Launch7 = 16777385 { $10000a9 };
    QtKey_Launch8 = 16777386 { $10000aa };
    QtKey_Launch9 = 16777387 { $10000ab };
    QtKey_LaunchA = 16777388 { $10000ac };
    QtKey_LaunchB = 16777389 { $10000ad };
    QtKey_LaunchC = 16777390 { $10000ae };
    QtKey_LaunchD = 16777391 { $10000af };
    QtKey_LaunchE = 16777392 { $10000b0 };
    QtKey_LaunchF = 16777393 { $10000b1 };
    QtKey_MediaLast = 16842751 { $100ffff };
    QtKey_Select = 16842752 { $1010000 };
    QtKey_Yes = 16842753 { $1010001 };
    QtKey_No = 16842754 { $1010002 };
    QtKey_Cancel = 16908289 { $1020001 };
    QtKey_Printer = 16908290 { $1020002 };
    QtKey_Execute = 16908291 { $1020003 };
    QtKey_Sleep = 16908292 { $1020004 };
    QtKey_Play = 16908293 { $1020005 };
    QtKey_Zoom = 16908294 { $1020006 };
    QtKey_Context1 = 17825792 { $1100000 };
    QtKey_Context2 = 17825793 { $1100001 };
    QtKey_Context3 = 17825794 { $1100002 };
    QtKey_Context4 = 17825795 { $1100003 };
    QtKey_Call = 17825796 { $1100004 };
    QtKey_Hangup = 17825797 { $1100005 };
    QtKey_Flip = 17825798 { $1100006 };
    QtKey_unknown = 33554431 { $1ffffff };

type
  QtCursorShape = cardinal; //  Qt::CursorShape (4)

const
    QtArrowCursor = 0 { $0 };
    QtUpArrowCursor = 1 { $1 };
    QtCrossCursor = 2 { $2 };
    QtWaitCursor = 3 { $3 };
    QtIBeamCursor = 4 { $4 };
    QtSizeVerCursor = 5 { $5 };
    QtSizeHorCursor = 6 { $6 };
    QtSizeBDiagCursor = 7 { $7 };
    QtSizeFDiagCursor = 8 { $8 };
    QtSizeAllCursor = 9 { $9 };
    QtBlankCursor = 10 { $a };
    QtSplitVCursor = 11 { $b };
    QtSplitHCursor = 12 { $c };
    QtPointingHandCursor = 13 { $d };
    QtForbiddenCursor = 14 { $e };
    QtWhatsThisCursor = 15 { $f };
    QtBusyCursor = 16 { $10 };
    QtOpenHandCursor = 17 { $11 };
    QtClosedHandCursor = 18 { $12 };
    QtLastCursor = 18 { $12 };
    QtBitmapCursor = 24 { $18 };
    QtCustomCursor = 25 { $19 };

type
  QtDockWidgetArea = cardinal; //  Qt::DockWidgetArea (4)
  QtDockWidgetAreas = QtDockWidgetArea; // QFlags<>

const
    QtLeftDockWidgetArea = 1 { $1 };
    QtRightDockWidgetArea = 2 { $2 };
    QtTopDockWidgetArea = 4 { $4 };
    QtBottomDockWidgetArea = 8 { $8 };
    QtDockWidgetArea_Mask = 15 { $f };
    QtAllDockWidgetAreas = 15 { $f };
    QtNoDockWidgetArea = 0 { $0 };

type
  QtToolBarArea = cardinal; //  Qt::ToolBarArea (4)
  QtToolBarAreas = QtToolBarArea; // QFlags<>

const
    QtLeftToolBarArea = 1 { $1 };
    QtRightToolBarArea = 2 { $2 };
    QtTopToolBarArea = 4 { $4 };
    QtBottomToolBarArea = 8 { $8 };
    QtToolBarArea_Mask = 15 { $f };
    QtAllToolBarAreas = 15 { $f };
    QtNoToolBarArea = 0 { $0 };

type
  QtDateFormat = cardinal; //  Qt::DateFormat (4)

const
    QtTextDate = 0 { $0 };
    QtISODate = 1 { $1 };
    QtSystemLocaleDate = 2 { $2 };
    QtLocalDate = 2 { $2 };
    QtLocaleDate = 3 { $3 };
    QtSystemLocaleShortDate = 4 { $4 };
    QtSystemLocaleLongDate = 5 { $5 };
    QtDefaultLocaleShortDate = 6 { $6 };
    QtDefaultLocaleLongDate = 7 { $7 };

type
  QtTextInteractionFlag = cardinal; //  Qt::TextInteractionFlag (4)
  QtTextInteractionFlags = QtTextInteractionFlag; // QFlags<>

const
    QtNoTextInteraction = 0 { $0 };
    QtTextSelectableByMouse = 1 { $1 };
    QtTextSelectableByKeyboard = 2 { $2 };
    QtLinksAccessibleByMouse = 4 { $4 };
    QtLinksAccessibleByKeyboard = 8 { $8 };
    QtTextEditable = 16 { $10 };
    QtTextEditorInteraction = 19 { $13 };
    QtTextBrowserInteraction = 13 { $d };



function QObject_create(parent: QObjectH = nil): QObjectH; cdecl; external Qt4PasLib name 'QObject_create';
procedure QObject_destroy(handle: QObjectH); cdecl; external Qt4PasLib name 'QObject_destroy'; 
function QObject_event(handle: QObjectH; p1: QEventH): Boolean; cdecl; external Qt4PasLib name 'QObject_event';
function QObject_eventFilter(handle: QObjectH; p1: QObjectH; p2: QEventH): Boolean; cdecl; external Qt4PasLib name 'QObject_eventFilter';
procedure QObject_tr(retval: PWideString; sourceText: PAnsiChar; comment: PAnsiChar = nil; n: Integer = -1); cdecl; external Qt4PasLib name 'QObject_tr';
procedure QObject_trUtf8(retval: PWideString; sourceText: PAnsiChar; comment: PAnsiChar = nil; n: Integer = -1); cdecl; external Qt4PasLib name 'QObject_trUtf8';
function QObject_metaObject(handle: QObjectH): QMetaObjectH; cdecl; external Qt4PasLib name 'QObject_metaObject';
procedure QObject_objectName(handle: QObjectH; retval: PWideString); cdecl; external Qt4PasLib name 'QObject_objectName';
procedure QObject_setObjectName(handle: QObjectH; name: PWideString); cdecl; external Qt4PasLib name 'QObject_setObjectName';
function QObject_isWidgetType(handle: QObjectH): Boolean; cdecl; external Qt4PasLib name 'QObject_isWidgetType';
function QObject_signalsBlocked(handle: QObjectH): Boolean; cdecl; external Qt4PasLib name 'QObject_signalsBlocked';
function QObject_blockSignals(handle: QObjectH; b: Boolean): Boolean; cdecl; external Qt4PasLib name 'QObject_blockSignals';
function QObject_thread(handle: QObjectH): QThreadH; cdecl; external Qt4PasLib name 'QObject_thread';
procedure QObject_moveToThread(handle: QObjectH; thread: QThreadH); cdecl; external Qt4PasLib name 'QObject_moveToThread';
function QObject_startTimer(handle: QObjectH; interval: Integer): Integer; cdecl; external Qt4PasLib name 'QObject_startTimer';
procedure QObject_killTimer(handle: QObjectH; id: Integer); cdecl; external Qt4PasLib name 'QObject_killTimer';
procedure QObject_children(handle: QObjectH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QObject_children';
procedure QObject_setParent(handle: QObjectH; p1: QObjectH); cdecl; external Qt4PasLib name 'QObject_setParent';
procedure QObject_installEventFilter(handle: QObjectH; p1: QObjectH); cdecl; external Qt4PasLib name 'QObject_installEventFilter';
procedure QObject_removeEventFilter(handle: QObjectH; p1: QObjectH); cdecl; external Qt4PasLib name 'QObject_removeEventFilter';
function QObject_connect(sender: QObjectH; signal: PAnsiChar; receiver: QObjectH; member: PAnsiChar; p5: QtConnectionType = QtAutoConnection): Boolean; cdecl; external Qt4PasLib name 'QObject_connect';
function QObject_connect(handle: QObjectH; sender: QObjectH; signal: PAnsiChar; member: PAnsiChar; _type: QtConnectionType = QtAutoConnection): Boolean; cdecl; external Qt4PasLib name 'QObject_connect2';
function QObject_disconnect(sender: QObjectH; signal: PAnsiChar; receiver: QObjectH; member: PAnsiChar): Boolean; cdecl; external Qt4PasLib name 'QObject_disconnect';
function QObject_disconnect(handle: QObjectH; receiver: QObjectH; member: PAnsiChar = nil): Boolean; cdecl; external Qt4PasLib name 'QObject_disconnect3';
procedure QObject_dumpObjectTree(handle: QObjectH); cdecl; external Qt4PasLib name 'QObject_dumpObjectTree';
procedure QObject_dumpObjectInfo(handle: QObjectH); cdecl; external Qt4PasLib name 'QObject_dumpObjectInfo';
function QObject_setProperty(handle: QObjectH; name: PAnsiChar; value: QVariantH): Boolean; cdecl; external Qt4PasLib name 'QObject_setProperty';
procedure QObject_property(handle: QObjectH; retval: QVariantH; name: PAnsiChar); cdecl; external Qt4PasLib name 'QObject_property';
function QObject_registerUserData(): LongWord; cdecl; external Qt4PasLib name 'QObject_registerUserData';
function QObject_parent(handle: QObjectH): QObjectH; cdecl; external Qt4PasLib name 'QObject_parent';
function QObject_inherits(handle: QObjectH; classname: PAnsiChar): Boolean; cdecl; external Qt4PasLib name 'QObject_inherits';
procedure QObject_deleteLater(handle: QObjectH); cdecl; external Qt4PasLib name 'QObject_deleteLater';

type
  QEventType = cardinal; //  QEvent::Type (4)

const
    QEventNone = 0 { $0 };
    QEventTimer = 1 { $1 };
    QEventMouseButtonPress = 2 { $2 };
    QEventMouseButtonRelease = 3 { $3 };
    QEventMouseButtonDblClick = 4 { $4 };
    QEventMouseMove = 5 { $5 };
    QEventKeyPress = 6 { $6 };
    QEventKeyRelease = 7 { $7 };
    QEventFocusIn = 8 { $8 };
    QEventFocusOut = 9 { $9 };
    QEventEnter = 10 { $a };
    QEventLeave = 11 { $b };
    QEventPaint = 12 { $c };
    QEventMove = 13 { $d };
    QEventResize = 14 { $e };
    QEventCreate = 15 { $f };
    QEventDestroy = 16 { $10 };
    QEventShow = 17 { $11 };
    QEventHide = 18 { $12 };
    QEventClose = 19 { $13 };
    QEventQuit = 20 { $14 };
    QEventParentChange = 21 { $15 };
    QEventParentAboutToChange = 131 { $83 };
    QEventThreadChange = 22 { $16 };
    QEventWindowActivate = 24 { $18 };
    QEventWindowDeactivate = 25 { $19 };
    QEventShowToParent = 26 { $1a };
    QEventHideToParent = 27 { $1b };
    QEventWheel = 31 { $1f };
    QEventWindowTitleChange = 33 { $21 };
    QEventWindowIconChange = 34 { $22 };
    QEventApplicationWindowIconChange = 35 { $23 };
    QEventApplicationFontChange = 36 { $24 };
    QEventApplicationLayoutDirectionChange = 37 { $25 };
    QEventApplicationPaletteChange = 38 { $26 };
    QEventPaletteChange = 39 { $27 };
    QEventClipboard = 40 { $28 };
    QEventSpeech = 42 { $2a };
    QEventMetaCall = 43 { $2b };
    QEventSockAct = 50 { $32 };
    QEventWinEventAct = 132 { $84 };
    QEventDeferredDelete = 52 { $34 };
    QEventDragEnter = 60 { $3c };
    QEventDragMove = 61 { $3d };
    QEventDragLeave = 62 { $3e };
    QEventDrop = 63 { $3f };
    QEventDragResponse = 64 { $40 };
    QEventChildAdded = 68 { $44 };
    QEventChildPolished = 69 { $45 };
    QEventChildRemoved = 71 { $47 };
    QEventShowWindowRequest = 73 { $49 };
    QEventPolishRequest = 74 { $4a };
    QEventPolish = 75 { $4b };
    QEventLayoutRequest = 76 { $4c };
    QEventUpdateRequest = 77 { $4d };
    QEventUpdateLater = 78 { $4e };
    QEventEmbeddingControl = 79 { $4f };
    QEventActivateControl = 80 { $50 };
    QEventDeactivateControl = 81 { $51 };
    QEventContextMenu = 82 { $52 };
    QEventInputMethod = 83 { $53 };
    QEventAccessibilityPrepare = 86 { $56 };
    QEventTabletMove = 87 { $57 };
    QEventLocaleChange = 88 { $58 };
    QEventLanguageChange = 89 { $59 };
    QEventLayoutDirectionChange = 90 { $5a };
    QEventStyle = 91 { $5b };
    QEventTabletPress = 92 { $5c };
    QEventTabletRelease = 93 { $5d };
    QEventOkRequest = 94 { $5e };
    QEventHelpRequest = 95 { $5f };
    QEventIconDrag = 96 { $60 };
    QEventFontChange = 97 { $61 };
    QEventEnabledChange = 98 { $62 };
    QEventActivationChange = 99 { $63 };
    QEventStyleChange = 100 { $64 };
    QEventIconTextChange = 101 { $65 };
    QEventModifiedChange = 102 { $66 };
    QEventMouseTrackingChange = 109 { $6d };
    QEventWindowBlocked = 103 { $67 };
    QEventWindowUnblocked = 104 { $68 };
    QEventWindowStateChange = 105 { $69 };
    QEventToolTip = 110 { $6e };
    QEventWhatsThis = 111 { $6f };
    QEventStatusTip = 112 { $70 };
    QEventActionChanged = 113 { $71 };
    QEventActionAdded = 114 { $72 };
    QEventActionRemoved = 115 { $73 };
    QEventFileOpen = 116 { $74 };
    QEventShortcut = 117 { $75 };
    QEventShortcutOverride = 51 { $33 };
    QEventWhatsThisClicked = 118 { $76 };
    QEventToolBarChange = 120 { $78 };
    QEventApplicationActivate = 121 { $79 };
    QEventApplicationActivated = 121 { $79 };
    QEventApplicationDeactivate = 122 { $7a };
    QEventApplicationDeactivated = 122 { $7a };
    QEventQueryWhatsThis = 123 { $7b };
    QEventEnterWhatsThisMode = 124 { $7c };
    QEventLeaveWhatsThisMode = 125 { $7d };
    QEventZOrderChange = 126 { $7e };
    QEventHoverEnter = 127 { $7f };
    QEventHoverLeave = 128 { $80 };
    QEventHoverMove = 129 { $81 };
    QEventAccessibilityHelp = 119 { $77 };
    QEventAccessibilityDescription = 130 { $82 };
    QEventAcceptDropsChange = 152 { $98 };
    QEventMenubarUpdated = 153 { $99 };
    QEventZeroTimerEvent = 154 { $9a };
    QEventGraphicsSceneMouseMove = 155 { $9b };
    QEventGraphicsSceneMousePress = 156 { $9c };
    QEventGraphicsSceneMouseRelease = 157 { $9d };
    QEventGraphicsSceneMouseDoubleClick = 158 { $9e };
    QEventGraphicsSceneContextMenu = 159 { $9f };
    QEventGraphicsSceneHoverEnter = 160 { $a0 };
    QEventGraphicsSceneHoverMove = 161 { $a1 };
    QEventGraphicsSceneHoverLeave = 162 { $a2 };
    QEventGraphicsSceneHelp = 163 { $a3 };
    QEventGraphicsSceneDragEnter = 164 { $a4 };
    QEventGraphicsSceneDragMove = 165 { $a5 };
    QEventGraphicsSceneDragLeave = 166 { $a6 };
    QEventGraphicsSceneDrop = 167 { $a7 };
    QEventGraphicsSceneWheel = 168 { $a8 };
    QEventKeyboardLayoutChange = 169 { $a9 };
    QEventDynamicPropertyChange = 170 { $aa };
    QEventTabletEnterProximity = 171 { $ab };
    QEventTabletLeaveProximity = 172 { $ac };
    QEventNonClientAreaMouseMove = 173 { $ad };
    QEventNonClientAreaMouseButtonPress = 174 { $ae };
    QEventNonClientAreaMouseButtonRelease = 175 { $af };
    QEventNonClientAreaMouseButtonDblClick = 176 { $b0 };
    QEventMacSizeChange = 177 { $b1 };
    QEventContentsRectChange = 178 { $b2 };
    QEventMacGLWindowChange = 179 { $b3 };
    QEventFutureCallOut = 180 { $b4 };
    QEventGraphicsSceneResize = 181 { $b5 };
    QEventGraphicsSceneMove = 182 { $b6 };
    QEventCursorChange = 183 { $b7 };
    QEventToolTipChange = 184 { $b8 };
    QEventNetworkReplyUpdated = 185 { $b9 };
    QEventGrabMouse = 186 { $ba };
    QEventUngrabMouse = 187 { $bb };
    QEventGrabKeyboard = 188 { $bc };
    QEventUngrabKeyboard = 189 { $bd };
    QEventCocoaRequestModal = 190 { $be };
    QEventMacGLClearDrawable = 191 { $bf };
    QEventUser = 1000 { $3e8 };
    QEventMaxUser = 65535 { $ffff };


function QEvent_create(_type: QEventType): QEventH; cdecl; external Qt4PasLib name 'QEvent_create';
procedure QEvent_destroy(handle: QEventH); cdecl; external Qt4PasLib name 'QEvent_destroy'; 
function QEvent_type(handle: QEventH): QEventType; cdecl; external Qt4PasLib name 'QEvent_type';
function QEvent_spontaneous(handle: QEventH): Boolean; cdecl; external Qt4PasLib name 'QEvent_spontaneous';
procedure QEvent_setAccepted(handle: QEventH; accepted: Boolean); cdecl; external Qt4PasLib name 'QEvent_setAccepted';
function QEvent_isAccepted(handle: QEventH): Boolean; cdecl; external Qt4PasLib name 'QEvent_isAccepted';
procedure QEvent_accept(handle: QEventH); cdecl; external Qt4PasLib name 'QEvent_accept';
procedure QEvent_ignore(handle: QEventH); cdecl; external Qt4PasLib name 'QEvent_ignore';
function QEvent_registerEventType(hint: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QEvent_registerEventType';

function QTimerEvent_create(timerId: Integer): QTimerEventH; cdecl; external Qt4PasLib name 'QTimerEvent_create';
procedure QTimerEvent_destroy(handle: QTimerEventH); cdecl; external Qt4PasLib name 'QTimerEvent_destroy'; 
function QTimerEvent_timerId(handle: QTimerEventH): Integer; cdecl; external Qt4PasLib name 'QTimerEvent_timerId';

function QChildEvent_create(_type: QEventType; child: QObjectH): QChildEventH; cdecl; external Qt4PasLib name 'QChildEvent_create';
procedure QChildEvent_destroy(handle: QChildEventH); cdecl; external Qt4PasLib name 'QChildEvent_destroy'; 
function QChildEvent_child(handle: QChildEventH): QObjectH; cdecl; external Qt4PasLib name 'QChildEvent_child';
function QChildEvent_added(handle: QChildEventH): Boolean; cdecl; external Qt4PasLib name 'QChildEvent_added';
function QChildEvent_polished(handle: QChildEventH): Boolean; cdecl; external Qt4PasLib name 'QChildEvent_polished';
function QChildEvent_removed(handle: QChildEventH): Boolean; cdecl; external Qt4PasLib name 'QChildEvent_removed';

function QDynamicPropertyChangeEvent_create(name: QByteArrayH): QDynamicPropertyChangeEventH; cdecl; external Qt4PasLib name 'QDynamicPropertyChangeEvent_create';
procedure QDynamicPropertyChangeEvent_destroy(handle: QDynamicPropertyChangeEventH); cdecl; external Qt4PasLib name 'QDynamicPropertyChangeEvent_destroy'; 
procedure QDynamicPropertyChangeEvent_propertyName(handle: QDynamicPropertyChangeEventH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QDynamicPropertyChangeEvent_propertyName';

type
  QEventLoopProcessEventsFlag = cardinal; // QEventLoop::ProcessEventsFlag
  QEventLoopProcessEventsFlags = QEventLoopProcessEventsFlag; //QFlags<> (3)
const
  QEventLoopAllEvents =   $00;
  QEventLoopExcludeUserInputEvents =   $01;
  QEventLoopExcludeSocketNotifiers =   $02;
  QEventLoopWaitForMoreEvents =   $04;
  QEventLoopX11ExcludeTimers =   $08;
  QEventLoopEventLoopExec =   $20;
  QEventLoopDialogExec =   $40;

function QEventLoop_create(parent: QObjectH = nil): QEventLoopH; cdecl; external Qt4PasLib name 'QEventLoop_create';
procedure QEventLoop_destroy(handle: QEventLoopH); cdecl; external Qt4PasLib name 'QEventLoop_destroy'; 
function QEventLoop_processEvents(handle: QEventLoopH; flags: QEventLoopProcessEventsFlags = QEventLoopAllEvents): Boolean; cdecl; external Qt4PasLib name 'QEventLoop_processEvents';
procedure QEventLoop_processEvents(handle: QEventLoopH; flags: QEventLoopProcessEventsFlags; maximumTime: Integer); cdecl; external Qt4PasLib name 'QEventLoop_processEvents2';
function QEventLoop_exec(handle: QEventLoopH; flags: QEventLoopProcessEventsFlags = QEventLoopAllEvents): Integer; cdecl; external Qt4PasLib name 'QEventLoop_exec';
procedure QEventLoop_exit(handle: QEventLoopH; returnCode: Integer = 0); cdecl; external Qt4PasLib name 'QEventLoop_exit';
function QEventLoop_isRunning(handle: QEventLoopH): Boolean; cdecl; external Qt4PasLib name 'QEventLoop_isRunning';
procedure QEventLoop_wakeUp(handle: QEventLoopH); cdecl; external Qt4PasLib name 'QEventLoop_wakeUp';
procedure QEventLoop_quit(handle: QEventLoopH); cdecl; external Qt4PasLib name 'QEventLoop_quit';

type
  QCoreApplicationEncoding = cardinal; //  QCoreApplication::Encoding (4)

const
    QCoreApplicationCodecForTr = 0 { $0 };
    QCoreApplicationUnicodeUTF8 = 1 { $1 };
    QCoreApplicationDefaultCodec = 0 { $0 };


function QCoreApplication_create(argc: PInteger; argv: PPAnsiChar): QCoreApplicationH; cdecl; external Qt4PasLib name 'QCoreApplication_create';
procedure QCoreApplication_destroy(handle: QCoreApplicationH); cdecl; external Qt4PasLib name 'QCoreApplication_destroy'; 
procedure QCoreApplication_arguments(retval: QStringListH); cdecl; external Qt4PasLib name 'QCoreApplication_arguments';
procedure QCoreApplication_setAttribute(attribute: QtApplicationAttribute; _on: Boolean = True); cdecl; external Qt4PasLib name 'QCoreApplication_setAttribute';
function QCoreApplication_testAttribute(attribute: QtApplicationAttribute): Boolean; cdecl; external Qt4PasLib name 'QCoreApplication_testAttribute';
procedure QCoreApplication_setOrganizationDomain(orgDomain: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_setOrganizationDomain';
procedure QCoreApplication_organizationDomain(retval: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_organizationDomain';
procedure QCoreApplication_setOrganizationName(orgName: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_setOrganizationName';
procedure QCoreApplication_organizationName(retval: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_organizationName';
procedure QCoreApplication_setApplicationName(application: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_setApplicationName';
procedure QCoreApplication_applicationName(retval: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_applicationName';
procedure QCoreApplication_setApplicationVersion(version: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_setApplicationVersion';
procedure QCoreApplication_applicationVersion(retval: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_applicationVersion';
function QCoreApplication_instance(): QCoreApplicationH; cdecl; external Qt4PasLib name 'QCoreApplication_instance';
function QCoreApplication_exec(): Integer; cdecl; external Qt4PasLib name 'QCoreApplication_exec';
procedure QCoreApplication_processEvents(flags: QEventLoopProcessEventsFlags = QEventLoopAllEvents); cdecl; external Qt4PasLib name 'QCoreApplication_processEvents';
procedure QCoreApplication_processEvents(flags: QEventLoopProcessEventsFlags; maxtime: Integer); cdecl; external Qt4PasLib name 'QCoreApplication_processEvents2';
procedure QCoreApplication_exit(retcode: Integer = 0); cdecl; external Qt4PasLib name 'QCoreApplication_exit';
function QCoreApplication_sendEvent(receiver: QObjectH; event: QEventH): Boolean; cdecl; external Qt4PasLib name 'QCoreApplication_sendEvent';
procedure QCoreApplication_postEvent(receiver: QObjectH; event: QEventH); cdecl; external Qt4PasLib name 'QCoreApplication_postEvent';
procedure QCoreApplication_postEvent(receiver: QObjectH; event: QEventH; priority: Integer); cdecl; external Qt4PasLib name 'QCoreApplication_postEvent2';
procedure QCoreApplication_sendPostedEvents(receiver: QObjectH; event_type: Integer); cdecl; external Qt4PasLib name 'QCoreApplication_sendPostedEvents';
procedure QCoreApplication_sendPostedEvents(); cdecl; external Qt4PasLib name 'QCoreApplication_sendPostedEvents2';
procedure QCoreApplication_removePostedEvents(receiver: QObjectH); cdecl; external Qt4PasLib name 'QCoreApplication_removePostedEvents';
procedure QCoreApplication_removePostedEvents(receiver: QObjectH; eventType: Integer); cdecl; external Qt4PasLib name 'QCoreApplication_removePostedEvents2';
function QCoreApplication_hasPendingEvents(): Boolean; cdecl; external Qt4PasLib name 'QCoreApplication_hasPendingEvents';
function QCoreApplication_notify(handle: QCoreApplicationH; p1: QObjectH; p2: QEventH): Boolean; cdecl; external Qt4PasLib name 'QCoreApplication_notify';
function QCoreApplication_startingUp(): Boolean; cdecl; external Qt4PasLib name 'QCoreApplication_startingUp';
function QCoreApplication_closingDown(): Boolean; cdecl; external Qt4PasLib name 'QCoreApplication_closingDown';
procedure QCoreApplication_applicationDirPath(retval: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_applicationDirPath';
procedure QCoreApplication_applicationFilePath(retval: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_applicationFilePath';
function QCoreApplication_applicationPid(): int64; cdecl; external Qt4PasLib name 'QCoreApplication_applicationPid';
procedure QCoreApplication_setLibraryPaths(p1: QStringListH); cdecl; external Qt4PasLib name 'QCoreApplication_setLibraryPaths';
procedure QCoreApplication_libraryPaths(retval: QStringListH); cdecl; external Qt4PasLib name 'QCoreApplication_libraryPaths';
procedure QCoreApplication_addLibraryPath(p1: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_addLibraryPath';
procedure QCoreApplication_removeLibraryPath(p1: PWideString); cdecl; external Qt4PasLib name 'QCoreApplication_removeLibraryPath';
procedure QCoreApplication_installTranslator(messageFile: QTranslatorH); cdecl; external Qt4PasLib name 'QCoreApplication_installTranslator';
procedure QCoreApplication_removeTranslator(messageFile: QTranslatorH); cdecl; external Qt4PasLib name 'QCoreApplication_removeTranslator';
procedure QCoreApplication_translate(retval: PWideString; context: PAnsiChar; key: PAnsiChar; disambiguation: PAnsiChar = nil; encoding: QCoreApplicationEncoding = QCoreApplicationCodecForTr); cdecl; external Qt4PasLib name 'QCoreApplication_translate';
procedure QCoreApplication_translate(retval: PWideString; context: PAnsiChar; key: PAnsiChar; disambiguation: PAnsiChar; encoding: QCoreApplicationEncoding; n: Integer); cdecl; external Qt4PasLib name 'QCoreApplication_translate2';
procedure QCoreApplication_flush(); cdecl; external Qt4PasLib name 'QCoreApplication_flush';
{$ifdef BINUX or DARWIN or QTOPIA }
procedure QCoreApplication_watchUnixSignal(signal: Integer; watch: Boolean); cdecl; external Qt4PasLib name 'QCoreApplication_watchUnixSignal';
{$endif}
function QCoreApplication_setEventFilter(handle: QCoreApplicationH; filter: QCoreApplicationEventFilter): QCoreApplicationEventFilter; cdecl; external Qt4PasLib name 'QCoreApplication_setEventFilter';
function QCoreApplication_filterEvent(handle: QCoreApplicationH; message: Pointer; result: PLong): Boolean; cdecl; external Qt4PasLib name 'QCoreApplication_filterEvent';
procedure QCoreApplication_quit(); cdecl; external Qt4PasLib name 'QCoreApplication_quit';
{$ifdef MSWINDOWS }
function QCoreApplication_winEventFilter(handle: QCoreApplicationH; message: PMsg; result: PLong): Boolean; cdecl; external Qt4PasLib name 'QCoreApplication_winEventFilter';
{$endif}


type
  QCoreApplication_aboutToQuit_Event = procedure () of object cdecl;
  QCoreApplication_unixSignal_Event = procedure (p1: Integer) of object cdecl;


function QTranslator_create(parent: QObjectH = nil): QTranslatorH; cdecl; external Qt4PasLib name 'QTranslator_create';
procedure QTranslator_destroy(handle: QTranslatorH); cdecl; external Qt4PasLib name 'QTranslator_destroy'; 
procedure QTranslator_translate(handle: QTranslatorH; retval: PWideString; context: PAnsiChar; sourceText: PAnsiChar; disambiguation: PAnsiChar = nil); cdecl; external Qt4PasLib name 'QTranslator_translate';
procedure QTranslator_translate(handle: QTranslatorH; retval: PWideString; context: PAnsiChar; sourceText: PAnsiChar; disambiguation: PAnsiChar; n: Integer); cdecl; external Qt4PasLib name 'QTranslator_translate2';
function QTranslator_isEmpty(handle: QTranslatorH): Boolean; cdecl; external Qt4PasLib name 'QTranslator_isEmpty';
function QTranslator_load(handle: QTranslatorH; filename: PWideString; directory: PWideString = nil; search_delimiters: PWideString = nil; suffix: PWideString = nil): Boolean; cdecl; external Qt4PasLib name 'QTranslator_load';
function QTranslator_load(handle: QTranslatorH; data: PByte; len: Integer): Boolean; cdecl; external Qt4PasLib name 'QTranslator_load2';

function QTimer_create(parent: QObjectH = nil): QTimerH; cdecl; external Qt4PasLib name 'QTimer_create';
procedure QTimer_destroy(handle: QTimerH); cdecl; external Qt4PasLib name 'QTimer_destroy'; 
function QTimer_isActive(handle: QTimerH): Boolean; cdecl; external Qt4PasLib name 'QTimer_isActive';
function QTimer_timerId(handle: QTimerH): Integer; cdecl; external Qt4PasLib name 'QTimer_timerId';
procedure QTimer_setInterval(handle: QTimerH; msec: Integer); cdecl; external Qt4PasLib name 'QTimer_setInterval';
function QTimer_interval(handle: QTimerH): Integer; cdecl; external Qt4PasLib name 'QTimer_interval';
procedure QTimer_setSingleShot(handle: QTimerH; singleShot: Boolean); cdecl; external Qt4PasLib name 'QTimer_setSingleShot';
function QTimer_isSingleShot(handle: QTimerH): Boolean; cdecl; external Qt4PasLib name 'QTimer_isSingleShot';
procedure QTimer_singleShot(msec: Integer; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QTimer_singleShot';
procedure QTimer_start(handle: QTimerH; msec: Integer); cdecl; external Qt4PasLib name 'QTimer_start';
procedure QTimer_start(handle: QTimerH); cdecl; external Qt4PasLib name 'QTimer_start2';
procedure QTimer_stop(handle: QTimerH); cdecl; external Qt4PasLib name 'QTimer_stop';


type
  QTimer_timeout_Event = procedure () of object cdecl;


type
  QVariantType = cardinal; //  QVariant::Type (4)

const
    QVariantInvalid = 0 { $0 };
    QVariantBool = 1 { $1 };
    QVariantInt = 2 { $2 };
    QVariantUInt = 3 { $3 };
    QVariantLongLong = 4 { $4 };
    QVariantULongLong = 5 { $5 };
    QVariantDouble = 6 { $6 };
    QVariantChar = 7 { $7 };
    QVariantMap = 8 { $8 };
    QVariantList = 9 { $9 };
    QVariantString = 10 { $a };
    QVariantStringList = 11 { $b };
    QVariantByteArray = 12 { $c };
    QVariantBitArray = 13 { $d };
    QVariantDate = 14 { $e };
    QVariantTime = 15 { $f };
    QVariantDateTime = 16 { $10 };
    QVariantUrl = 17 { $11 };
    QVariantLocale = 18 { $12 };
    QVariantRect = 19 { $13 };
    QVariantRectF = 20 { $14 };
    QVariantSize = 21 { $15 };
    QVariantSizeF = 22 { $16 };
    QVariantLine = 23 { $17 };
    QVariantLineF = 24 { $18 };
    QVariantPoint = 25 { $19 };
    QVariantPointF = 26 { $1a };
    QVariantRegExp = 27 { $1b };
    QVariantHash = 28 { $1c };
    QVariantLastCoreType = 28 { $1c };
    QVariantFont = 64 { $40 };
    QVariantPixmap = 65 { $41 };
    QVariantBrush = 66 { $42 };
    QVariantColor = 67 { $43 };
    QVariantPalette = 68 { $44 };
    QVariantIcon = 69 { $45 };
    QVariantImage = 70 { $46 };
    QVariantPolygon = 71 { $47 };
    QVariantRegion = 72 { $48 };
    QVariantBitmap = 73 { $49 };
    QVariantCursor = 74 { $4a };
    QVariantSizePolicy = 75 { $4b };
    QVariantKeySequence = 76 { $4c };
    QVariantPen = 77 { $4d };
    QVariantTextLength = 78 { $4e };
    QVariantTextFormat = 79 { $4f };
    QVariantMatrix = 80 { $50 };
    QVariantTransform = 81 { $51 };
    QVariantLastGuiType = 81 { $51 };
    QVariantUserType = 127 { $7f };
    QVariantLastType = 4294967295 { $ffffffff };


function QVariant_create(): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create';
procedure QVariant_destroy(handle: QVariantH); cdecl; external Qt4PasLib name 'QVariant_destroy'; 
function QVariant_create(_type: QVariantType): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create2';
function QVariant_create(typeOrUserType: Integer; copy: Pointer): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create3';
function QVariant_create(other: QVariantH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create4';
function QVariant_create(s: QDataStreamH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create5';
function QVariant_create(i: Integer): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create6';
function QVariant_create(ll: int64): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create8';
function QVariant_create(ull: qword): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create9';
function QVariant_create(b: Boolean): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create10';
function QVariant_create(d: Double): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create11';
function QVariant_create(str: PAnsiChar): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create12';
function QVariant_create(bytearray: QByteArrayH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create13';
function QVariant_create(bitarray: QBitArrayH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create14';
function QVariant_create(_string: PWideString): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create15';
function QVariant_create(_string: QLatin1StringH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create16';
function QVariant_create(stringlist: QStringListH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create17';
function QVariant_create(qchar: PWideChar): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create18';
function QVariant_create(date: QDateH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create19';
function QVariant_create(time: QTimeH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create20';
function QVariant_create(datetime: QDateTimeH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create21';
function QVariant_create(pt: PQtPointF): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create25';
function QVariant_create(line: QLineH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create26';
function QVariant_create(line: QLineFH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create27';
function QVariant_create(rect: PRect): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create28';
function QVariant_create(rect: QRectFH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create29';
function QVariant_create(url: QUrlH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create30';
function QVariant_create(locale: QLocaleH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create31';
function QVariant_create(regExp: QRegExpH): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create32';
function QVariant_create(color: QtGlobalColor): QVariantH; cdecl; external Qt4PasLib name 'QVariant_create33';
function QVariant_type(handle: QVariantH): QVariantType; cdecl; external Qt4PasLib name 'QVariant_type';
function QVariant_userType(handle: QVariantH): Integer; cdecl; external Qt4PasLib name 'QVariant_userType';
function QVariant_typeName(handle: QVariantH): PAnsiChar; cdecl; external Qt4PasLib name 'QVariant_typeName';
function QVariant_canConvert(handle: QVariantH; t: QVariantType): Boolean; cdecl; external Qt4PasLib name 'QVariant_canConvert';
function QVariant_convert(handle: QVariantH; t: QVariantType): Boolean; cdecl; external Qt4PasLib name 'QVariant_convert';
function QVariant_isValid(handle: QVariantH): Boolean; cdecl; external Qt4PasLib name 'QVariant_isValid';
function QVariant_isNull(handle: QVariantH): Boolean; cdecl; external Qt4PasLib name 'QVariant_isNull';
procedure QVariant_clear(handle: QVariantH); cdecl; external Qt4PasLib name 'QVariant_clear';
procedure QVariant_detach(handle: QVariantH); cdecl; external Qt4PasLib name 'QVariant_detach';
function QVariant_isDetached(handle: QVariantH): Boolean; cdecl; external Qt4PasLib name 'QVariant_isDetached';
function QVariant_toInt(handle: QVariantH; ok: PBoolean = nil): Integer; cdecl; external Qt4PasLib name 'QVariant_toInt';
function QVariant_toUInt(handle: QVariantH; ok: PBoolean = nil): LongWord; cdecl; external Qt4PasLib name 'QVariant_toUInt';
function QVariant_toLongLong(handle: QVariantH; ok: PBoolean = nil): int64; cdecl; external Qt4PasLib name 'QVariant_toLongLong';
function QVariant_toULongLong(handle: QVariantH; ok: PBoolean = nil): qword; cdecl; external Qt4PasLib name 'QVariant_toULongLong';
function QVariant_toBool(handle: QVariantH): Boolean; cdecl; external Qt4PasLib name 'QVariant_toBool';
function QVariant_toDouble(handle: QVariantH; ok: PBoolean = nil): Double; cdecl; external Qt4PasLib name 'QVariant_toDouble';
procedure QVariant_toByteArray(handle: QVariantH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QVariant_toByteArray';
procedure QVariant_toBitArray(handle: QVariantH; retval: QBitArrayH); cdecl; external Qt4PasLib name 'QVariant_toBitArray';
procedure QVariant_toString(handle: QVariantH; retval: PWideString); cdecl; external Qt4PasLib name 'QVariant_toString';
procedure QVariant_toStringList(handle: QVariantH; retval: QStringListH); cdecl; external Qt4PasLib name 'QVariant_toStringList';
procedure QVariant_toChar(handle: QVariantH; retval: PWideChar); cdecl; external Qt4PasLib name 'QVariant_toChar';
procedure QVariant_toDate(handle: QVariantH; retval: QDateH); cdecl; external Qt4PasLib name 'QVariant_toDate';
procedure QVariant_toTime(handle: QVariantH; retval: QTimeH); cdecl; external Qt4PasLib name 'QVariant_toTime';
procedure QVariant_toDateTime(handle: QVariantH; retval: QDateTimeH); cdecl; external Qt4PasLib name 'QVariant_toDateTime';
procedure QVariant_toPoint(handle: QVariantH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QVariant_toPoint';
procedure QVariant_toPointF(handle: QVariantH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QVariant_toPointF';
procedure QVariant_toRect(handle: QVariantH; retval: PRect); cdecl; external Qt4PasLib name 'QVariant_toRect';
procedure QVariant_toSize(handle: QVariantH; retval: PSize); cdecl; external Qt4PasLib name 'QVariant_toSize';
procedure QVariant_toSizeF(handle: QVariantH; retval: QSizeFH); cdecl; external Qt4PasLib name 'QVariant_toSizeF';
procedure QVariant_toLine(handle: QVariantH; retval: QLineH); cdecl; external Qt4PasLib name 'QVariant_toLine';
procedure QVariant_toLineF(handle: QVariantH; retval: QLineFH); cdecl; external Qt4PasLib name 'QVariant_toLineF';
procedure QVariant_toRectF(handle: QVariantH; retval: QRectFH); cdecl; external Qt4PasLib name 'QVariant_toRectF';
procedure QVariant_toUrl(handle: QVariantH; retval: QUrlH); cdecl; external Qt4PasLib name 'QVariant_toUrl';
procedure QVariant_toLocale(handle: QVariantH; retval: QLocaleH); cdecl; external Qt4PasLib name 'QVariant_toLocale';
procedure QVariant_toRegExp(handle: QVariantH; retval: QRegExpH); cdecl; external Qt4PasLib name 'QVariant_toRegExp';
procedure QVariant_load(handle: QVariantH; ds: QDataStreamH); cdecl; external Qt4PasLib name 'QVariant_load';
procedure QVariant_save(handle: QVariantH; ds: QDataStreamH); cdecl; external Qt4PasLib name 'QVariant_save';
function QVariant_typeToName(_type: QVariantType): PAnsiChar; cdecl; external Qt4PasLib name 'QVariant_typeToName';
function QVariant_nameToType(name: PAnsiChar): QVariantType; cdecl; external Qt4PasLib name 'QVariant_nameToType';
function QVariant_constData(handle: QVariantH): Pointer; cdecl; external Qt4PasLib name 'QVariant_constData';


type
  QMetaMethodAccess = ( // QMetaMethod::Access (1)
    QMetaMethodPrivate, QMetaMethodProtected, QMetaMethodPublic );

  QMetaMethodMethodType = ( // QMetaMethod::MethodType (1)
    QMetaMethodMethod, QMetaMethodSignal, QMetaMethodSlot, QMetaMethodConstructor );

  QMetaMethodAttributes = (  //QMetaMethod::Attributes (2)
    QMetaMethodCompatibility = $1,
    QMetaMethodCloned = $2,
    QMetaMethodScriptable = $4 );

function QMetaMethod_create(): QMetaMethodH; cdecl; external Qt4PasLib name 'QMetaMethod_create';
procedure QMetaMethod_destroy(handle: QMetaMethodH); cdecl; external Qt4PasLib name 'QMetaMethod_destroy'; 
function QMetaMethod_signature(handle: QMetaMethodH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaMethod_signature';
function QMetaMethod_typeName(handle: QMetaMethodH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaMethod_typeName';
function QMetaMethod_tag(handle: QMetaMethodH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaMethod_tag';
function QMetaMethod_access(handle: QMetaMethodH): QMetaMethodAccess; cdecl; external Qt4PasLib name 'QMetaMethod_access';
function QMetaMethod_methodType(handle: QMetaMethodH): QMetaMethodMethodType; cdecl; external Qt4PasLib name 'QMetaMethod_methodType';
function QMetaMethod_attributes(handle: QMetaMethodH): Integer; cdecl; external Qt4PasLib name 'QMetaMethod_attributes';
function QMetaMethod_enclosingMetaObject(handle: QMetaMethodH): QMetaObjectH; cdecl; external Qt4PasLib name 'QMetaMethod_enclosingMetaObject';

function QMetaEnum_create(): QMetaEnumH; cdecl; external Qt4PasLib name 'QMetaEnum_create';
procedure QMetaEnum_destroy(handle: QMetaEnumH); cdecl; external Qt4PasLib name 'QMetaEnum_destroy'; 
function QMetaEnum_name(handle: QMetaEnumH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaEnum_name';
function QMetaEnum_isFlag(handle: QMetaEnumH): Boolean; cdecl; external Qt4PasLib name 'QMetaEnum_isFlag';
function QMetaEnum_keyCount(handle: QMetaEnumH): Integer; cdecl; external Qt4PasLib name 'QMetaEnum_keyCount';
function QMetaEnum_key(handle: QMetaEnumH; index: Integer): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaEnum_key';
function QMetaEnum_value(handle: QMetaEnumH; index: Integer): Integer; cdecl; external Qt4PasLib name 'QMetaEnum_value';
function QMetaEnum_scope(handle: QMetaEnumH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaEnum_scope';
function QMetaEnum_keyToValue(handle: QMetaEnumH; key: PAnsiChar): Integer; cdecl; external Qt4PasLib name 'QMetaEnum_keyToValue';
function QMetaEnum_valueToKey(handle: QMetaEnumH; value: Integer): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaEnum_valueToKey';
function QMetaEnum_keysToValue(handle: QMetaEnumH; keys: PAnsiChar): Integer; cdecl; external Qt4PasLib name 'QMetaEnum_keysToValue';
procedure QMetaEnum_valueToKeys(handle: QMetaEnumH; retval: QByteArrayH; value: Integer); cdecl; external Qt4PasLib name 'QMetaEnum_valueToKeys';
function QMetaEnum_enclosingMetaObject(handle: QMetaEnumH): QMetaObjectH; cdecl; external Qt4PasLib name 'QMetaEnum_enclosingMetaObject';
function QMetaEnum_isValid(handle: QMetaEnumH): Boolean; cdecl; external Qt4PasLib name 'QMetaEnum_isValid';

function QMetaProperty_create(): QMetaPropertyH; cdecl; external Qt4PasLib name 'QMetaProperty_create';
procedure QMetaProperty_destroy(handle: QMetaPropertyH); cdecl; external Qt4PasLib name 'QMetaProperty_destroy'; 
function QMetaProperty_name(handle: QMetaPropertyH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaProperty_name';
function QMetaProperty_typeName(handle: QMetaPropertyH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaProperty_typeName';
function QMetaProperty_type(handle: QMetaPropertyH): QVariantType; cdecl; external Qt4PasLib name 'QMetaProperty_type';
function QMetaProperty_userType(handle: QMetaPropertyH): Integer; cdecl; external Qt4PasLib name 'QMetaProperty_userType';
function QMetaProperty_isReadable(handle: QMetaPropertyH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isReadable';
function QMetaProperty_isWritable(handle: QMetaPropertyH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isWritable';
function QMetaProperty_isResettable(handle: QMetaPropertyH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isResettable';
function QMetaProperty_isDesignable(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isDesignable';
function QMetaProperty_isScriptable(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isScriptable';
function QMetaProperty_isStored(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isStored';
function QMetaProperty_isEditable(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isEditable';
function QMetaProperty_isUser(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isUser';
function QMetaProperty_isFlagType(handle: QMetaPropertyH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isFlagType';
function QMetaProperty_isEnumType(handle: QMetaPropertyH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isEnumType';
procedure QMetaProperty_enumerator(handle: QMetaPropertyH; retval: QMetaEnumH); cdecl; external Qt4PasLib name 'QMetaProperty_enumerator';
function QMetaProperty_hasNotifySignal(handle: QMetaPropertyH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_hasNotifySignal';
procedure QMetaProperty_notifySignal(handle: QMetaPropertyH; retval: QMetaMethodH); cdecl; external Qt4PasLib name 'QMetaProperty_notifySignal';
function QMetaProperty_notifySignalIndex(handle: QMetaPropertyH): Integer; cdecl; external Qt4PasLib name 'QMetaProperty_notifySignalIndex';
procedure QMetaProperty_read(handle: QMetaPropertyH; retval: QVariantH; obj: QObjectH); cdecl; external Qt4PasLib name 'QMetaProperty_read';
function QMetaProperty_write(handle: QMetaPropertyH; obj: QObjectH; value: QVariantH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_write';
function QMetaProperty_reset(handle: QMetaPropertyH; obj: QObjectH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_reset';
function QMetaProperty_hasStdCppSet(handle: QMetaPropertyH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_hasStdCppSet';
function QMetaProperty_isValid(handle: QMetaPropertyH): Boolean; cdecl; external Qt4PasLib name 'QMetaProperty_isValid';
function QMetaProperty_enclosingMetaObject(handle: QMetaPropertyH): QMetaObjectH; cdecl; external Qt4PasLib name 'QMetaProperty_enclosingMetaObject';

function QMetaClassInfo_create(): QMetaClassInfoH; cdecl; external Qt4PasLib name 'QMetaClassInfo_create';
procedure QMetaClassInfo_destroy(handle: QMetaClassInfoH); cdecl; external Qt4PasLib name 'QMetaClassInfo_destroy'; 
function QMetaClassInfo_name(handle: QMetaClassInfoH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaClassInfo_name';
function QMetaClassInfo_value(handle: QMetaClassInfoH): PAnsiChar; cdecl; external Qt4PasLib name 'QMetaClassInfo_value';
function QMetaClassInfo_enclosingMetaObject(handle: QMetaClassInfoH): QMetaObjectH; cdecl; external Qt4PasLib name 'QMetaClassInfo_enclosingMetaObject';

function QModelIndex_create(): QModelIndexH; cdecl; external Qt4PasLib name 'QModelIndex_create';
procedure QModelIndex_destroy(handle: QModelIndexH); cdecl; external Qt4PasLib name 'QModelIndex_destroy'; 
function QModelIndex_create(other: QModelIndexH): QModelIndexH; cdecl; external Qt4PasLib name 'QModelIndex_create2';
function QModelIndex_row(handle: QModelIndexH): Integer; cdecl; external Qt4PasLib name 'QModelIndex_row';
function QModelIndex_column(handle: QModelIndexH): Integer; cdecl; external Qt4PasLib name 'QModelIndex_column';
function QModelIndex_internalPointer(handle: QModelIndexH): Pointer; cdecl; external Qt4PasLib name 'QModelIndex_internalPointer';
function QModelIndex_internalId(handle: QModelIndexH): int64; cdecl; external Qt4PasLib name 'QModelIndex_internalId';
procedure QModelIndex_parent(handle: QModelIndexH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QModelIndex_parent';
procedure QModelIndex_sibling(handle: QModelIndexH; retval: QModelIndexH; row: Integer; column: Integer); cdecl; external Qt4PasLib name 'QModelIndex_sibling';
procedure QModelIndex_child(handle: QModelIndexH; retval: QModelIndexH; row: Integer; column: Integer); cdecl; external Qt4PasLib name 'QModelIndex_child';
procedure QModelIndex_data(handle: QModelIndexH; retval: QVariantH; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt4PasLib name 'QModelIndex_data';
function QModelIndex_flags(handle: QModelIndexH): QtItemFlags; cdecl; external Qt4PasLib name 'QModelIndex_flags';
function QModelIndex_model(handle: QModelIndexH): QAbstractItemModelH; cdecl; external Qt4PasLib name 'QModelIndex_model';
function QModelIndex_isValid(handle: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QModelIndex_isValid';

function QPersistentModelIndex_create(): QPersistentModelIndexH; cdecl; external Qt4PasLib name 'QPersistentModelIndex_create';
procedure QPersistentModelIndex_destroy(handle: QPersistentModelIndexH); cdecl; external Qt4PasLib name 'QPersistentModelIndex_destroy'; 
function QPersistentModelIndex_create(index: QModelIndexH): QPersistentModelIndexH; cdecl; external Qt4PasLib name 'QPersistentModelIndex_create2';
function QPersistentModelIndex_create(other: QPersistentModelIndexH): QPersistentModelIndexH; cdecl; external Qt4PasLib name 'QPersistentModelIndex_create3';
function QPersistentModelIndex_row(handle: QPersistentModelIndexH): Integer; cdecl; external Qt4PasLib name 'QPersistentModelIndex_row';
function QPersistentModelIndex_column(handle: QPersistentModelIndexH): Integer; cdecl; external Qt4PasLib name 'QPersistentModelIndex_column';
function QPersistentModelIndex_internalPointer(handle: QPersistentModelIndexH): Pointer; cdecl; external Qt4PasLib name 'QPersistentModelIndex_internalPointer';
function QPersistentModelIndex_internalId(handle: QPersistentModelIndexH): int64; cdecl; external Qt4PasLib name 'QPersistentModelIndex_internalId';
procedure QPersistentModelIndex_parent(handle: QPersistentModelIndexH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QPersistentModelIndex_parent';
procedure QPersistentModelIndex_sibling(handle: QPersistentModelIndexH; retval: QModelIndexH; row: Integer; column: Integer); cdecl; external Qt4PasLib name 'QPersistentModelIndex_sibling';
procedure QPersistentModelIndex_child(handle: QPersistentModelIndexH; retval: QModelIndexH; row: Integer; column: Integer); cdecl; external Qt4PasLib name 'QPersistentModelIndex_child';
procedure QPersistentModelIndex_data(handle: QPersistentModelIndexH; retval: QVariantH; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt4PasLib name 'QPersistentModelIndex_data';
function QPersistentModelIndex_flags(handle: QPersistentModelIndexH): QtItemFlags; cdecl; external Qt4PasLib name 'QPersistentModelIndex_flags';
function QPersistentModelIndex_model(handle: QPersistentModelIndexH): QAbstractItemModelH; cdecl; external Qt4PasLib name 'QPersistentModelIndex_model';
function QPersistentModelIndex_isValid(handle: QPersistentModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QPersistentModelIndex_isValid';

function QAbstractItemModel_hasIndex(handle: QAbstractItemModelH; row: Integer; column: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_hasIndex';
procedure QAbstractItemModel_index(handle: QAbstractItemModelH; retval: QModelIndexH; row: Integer; column: Integer; parent: QModelIndexH = nil); cdecl; external Qt4PasLib name 'QAbstractItemModel_index';
procedure QAbstractItemModel_parent(handle: QAbstractItemModelH; retval: QModelIndexH; child: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemModel_parent';
procedure QAbstractItemModel_sibling(handle: QAbstractItemModelH; retval: QModelIndexH; row: Integer; column: Integer; idx: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemModel_sibling';
function QAbstractItemModel_rowCount(handle: QAbstractItemModelH; parent: QModelIndexH = nil): Integer; cdecl; external Qt4PasLib name 'QAbstractItemModel_rowCount';
function QAbstractItemModel_columnCount(handle: QAbstractItemModelH; parent: QModelIndexH = nil): Integer; cdecl; external Qt4PasLib name 'QAbstractItemModel_columnCount';
function QAbstractItemModel_hasChildren(handle: QAbstractItemModelH; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_hasChildren';
procedure QAbstractItemModel_data(handle: QAbstractItemModelH; retval: QVariantH; index: QModelIndexH; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt4PasLib name 'QAbstractItemModel_data';
function QAbstractItemModel_setData(handle: QAbstractItemModelH; index: QModelIndexH; value: QVariantH; role: QtItemDataRole = QtEditRole): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_setData';
procedure QAbstractItemModel_headerData(handle: QAbstractItemModelH; retval: QVariantH; section: Integer; orientation: QtOrientation; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt4PasLib name 'QAbstractItemModel_headerData';
function QAbstractItemModel_setHeaderData(handle: QAbstractItemModelH; section: Integer; orientation: QtOrientation; value: QVariantH; role: QtItemDataRole = QtEditRole): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_setHeaderData';
procedure QAbstractItemModel_mimeTypes(handle: QAbstractItemModelH; retval: QStringListH); cdecl; external Qt4PasLib name 'QAbstractItemModel_mimeTypes';
function QAbstractItemModel_dropMimeData(handle: QAbstractItemModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_dropMimeData';
function QAbstractItemModel_supportedDropActions(handle: QAbstractItemModelH): QtDropActions; cdecl; external Qt4PasLib name 'QAbstractItemModel_supportedDropActions';
function QAbstractItemModel_supportedDragActions(handle: QAbstractItemModelH): QtDropActions; cdecl; external Qt4PasLib name 'QAbstractItemModel_supportedDragActions';
procedure QAbstractItemModel_setSupportedDragActions(handle: QAbstractItemModelH; p1: QtDropActions); cdecl; external Qt4PasLib name 'QAbstractItemModel_setSupportedDragActions';
function QAbstractItemModel_insertRows(handle: QAbstractItemModelH; row: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_insertRows';
function QAbstractItemModel_insertColumns(handle: QAbstractItemModelH; column: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_insertColumns';
function QAbstractItemModel_removeRows(handle: QAbstractItemModelH; row: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_removeRows';
function QAbstractItemModel_removeColumns(handle: QAbstractItemModelH; column: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_removeColumns';
function QAbstractItemModel_insertRow(handle: QAbstractItemModelH; row: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_insertRow';
function QAbstractItemModel_insertColumn(handle: QAbstractItemModelH; column: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_insertColumn';
function QAbstractItemModel_removeRow(handle: QAbstractItemModelH; row: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_removeRow';
function QAbstractItemModel_removeColumn(handle: QAbstractItemModelH; column: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_removeColumn';
procedure QAbstractItemModel_fetchMore(handle: QAbstractItemModelH; parent: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemModel_fetchMore';
function QAbstractItemModel_canFetchMore(handle: QAbstractItemModelH; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_canFetchMore';
function QAbstractItemModel_flags(handle: QAbstractItemModelH; index: QModelIndexH): QtItemFlags; cdecl; external Qt4PasLib name 'QAbstractItemModel_flags';
procedure QAbstractItemModel_sort(handle: QAbstractItemModelH; column: Integer; order: QtSortOrder = QtAscendingOrder); cdecl; external Qt4PasLib name 'QAbstractItemModel_sort';
procedure QAbstractItemModel_buddy(handle: QAbstractItemModelH; retval: QModelIndexH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemModel_buddy';
procedure QAbstractItemModel_match(handle: QAbstractItemModelH; retval: PPtrIntArray; start: QModelIndexH; role: Integer; value: QVariantH; hits: Integer; flags: QtMatchFlags); cdecl; external Qt4PasLib name 'QAbstractItemModel_match';
procedure QAbstractItemModel_span(handle: QAbstractItemModelH; retval: PSize; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemModel_span';
function QAbstractItemModel_submit(handle: QAbstractItemModelH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemModel_submit';
procedure QAbstractItemModel_revert(handle: QAbstractItemModelH); cdecl; external Qt4PasLib name 'QAbstractItemModel_revert';

procedure QAbstractTableModel_index(handle: QAbstractTableModelH; retval: QModelIndexH; row: Integer; column: Integer; parent: QModelIndexH = nil); cdecl; external Qt4PasLib name 'QAbstractTableModel_index';
function QAbstractTableModel_dropMimeData(handle: QAbstractTableModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QAbstractTableModel_dropMimeData';

procedure QAbstractListModel_index(handle: QAbstractListModelH; retval: QModelIndexH; row: Integer; column: Integer = 0; parent: QModelIndexH = nil); cdecl; external Qt4PasLib name 'QAbstractListModel_index';
function QAbstractListModel_dropMimeData(handle: QAbstractListModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QAbstractListModel_dropMimeData';


type
  QAbstractItemModel_dataChanged_Event = procedure (topLeft: QModelIndexH; bottomRight: QModelIndexH) of object cdecl;
  QAbstractItemModel_headerDataChanged_Event = procedure (orientation: QtOrientation; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_layoutChanged_Event = procedure () of object cdecl;
  QAbstractItemModel_layoutAboutToBeChanged_Event = procedure () of object cdecl;
  QAbstractItemModel_rowsAboutToBeInserted_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_rowsInserted_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_rowsAboutToBeRemoved_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_rowsRemoved_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_columnsAboutToBeInserted_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_columnsInserted_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_columnsAboutToBeRemoved_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_columnsRemoved_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_modelAboutToBeReset_Event = procedure () of object cdecl;
  QAbstractItemModel_modelReset_Event = procedure () of object cdecl;


function QAbstractEventDispatcher_instance(thread: QThreadH = nil): QAbstractEventDispatcherH; cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_instance';
function QAbstractEventDispatcher_processEvents(handle: QAbstractEventDispatcherH; flags: QEventLoopProcessEventsFlags): Boolean; cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_processEvents';
function QAbstractEventDispatcher_hasPendingEvents(handle: QAbstractEventDispatcherH): Boolean; cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_hasPendingEvents';
procedure QAbstractEventDispatcher_registerSocketNotifier(handle: QAbstractEventDispatcherH; notifier: QSocketNotifierH); cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_registerSocketNotifier';
procedure QAbstractEventDispatcher_unregisterSocketNotifier(handle: QAbstractEventDispatcherH; notifier: QSocketNotifierH); cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_unregisterSocketNotifier';
function QAbstractEventDispatcher_registerTimer(handle: QAbstractEventDispatcherH; interval: Integer; _object: QObjectH): Integer; cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_registerTimer';
procedure QAbstractEventDispatcher_registerTimer(handle: QAbstractEventDispatcherH; timerId: Integer; interval: Integer; _object: QObjectH); cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_registerTimer2';
function QAbstractEventDispatcher_unregisterTimer(handle: QAbstractEventDispatcherH; timerId: Integer): Boolean; cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_unregisterTimer';
function QAbstractEventDispatcher_unregisterTimers(handle: QAbstractEventDispatcherH; _object: QObjectH): Boolean; cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_unregisterTimers';
procedure QAbstractEventDispatcher_wakeUp(handle: QAbstractEventDispatcherH); cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_wakeUp';
procedure QAbstractEventDispatcher_interrupt(handle: QAbstractEventDispatcherH); cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_interrupt';
procedure QAbstractEventDispatcher_flush(handle: QAbstractEventDispatcherH); cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_flush';
procedure QAbstractEventDispatcher_startingUp(handle: QAbstractEventDispatcherH); cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_startingUp';
procedure QAbstractEventDispatcher_closingDown(handle: QAbstractEventDispatcherH); cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_closingDown';
function QAbstractEventDispatcher_setEventFilter(handle: QAbstractEventDispatcherH; filter: QAbstractEventDispatcherEventFilter): QAbstractEventDispatcherEventFilter; cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_setEventFilter';
function QAbstractEventDispatcher_filterEvent(handle: QAbstractEventDispatcherH; message: Pointer): Boolean; cdecl; external Qt4PasLib name 'QAbstractEventDispatcher_filterEvent';

function QMimeData_create(): QMimeDataH; cdecl; external Qt4PasLib name 'QMimeData_create';
procedure QMimeData_destroy(handle: QMimeDataH); cdecl; external Qt4PasLib name 'QMimeData_destroy'; 
function QMimeData_hasUrls(handle: QMimeDataH): Boolean; cdecl; external Qt4PasLib name 'QMimeData_hasUrls';
procedure QMimeData_text(handle: QMimeDataH; retval: PWideString); cdecl; external Qt4PasLib name 'QMimeData_text';
procedure QMimeData_setText(handle: QMimeDataH; text: PWideString); cdecl; external Qt4PasLib name 'QMimeData_setText';
function QMimeData_hasText(handle: QMimeDataH): Boolean; cdecl; external Qt4PasLib name 'QMimeData_hasText';
procedure QMimeData_html(handle: QMimeDataH; retval: PWideString); cdecl; external Qt4PasLib name 'QMimeData_html';
procedure QMimeData_setHtml(handle: QMimeDataH; html: PWideString); cdecl; external Qt4PasLib name 'QMimeData_setHtml';
function QMimeData_hasHtml(handle: QMimeDataH): Boolean; cdecl; external Qt4PasLib name 'QMimeData_hasHtml';
procedure QMimeData_imageData(handle: QMimeDataH; retval: QVariantH); cdecl; external Qt4PasLib name 'QMimeData_imageData';
procedure QMimeData_setImageData(handle: QMimeDataH; image: QVariantH); cdecl; external Qt4PasLib name 'QMimeData_setImageData';
function QMimeData_hasImage(handle: QMimeDataH): Boolean; cdecl; external Qt4PasLib name 'QMimeData_hasImage';
procedure QMimeData_colorData(handle: QMimeDataH; retval: QVariantH); cdecl; external Qt4PasLib name 'QMimeData_colorData';
procedure QMimeData_setColorData(handle: QMimeDataH; color: QVariantH); cdecl; external Qt4PasLib name 'QMimeData_setColorData';
function QMimeData_hasColor(handle: QMimeDataH): Boolean; cdecl; external Qt4PasLib name 'QMimeData_hasColor';
procedure QMimeData_data(handle: QMimeDataH; retval: QByteArrayH; mimetype: PWideString); cdecl; external Qt4PasLib name 'QMimeData_data';
procedure QMimeData_setData(handle: QMimeDataH; mimetype: PWideString; data: QByteArrayH); cdecl; external Qt4PasLib name 'QMimeData_setData';
procedure QMimeData_removeFormat(handle: QMimeDataH; mimetype: PWideString); cdecl; external Qt4PasLib name 'QMimeData_removeFormat';
function QMimeData_hasFormat(handle: QMimeDataH; mimetype: PWideString): Boolean; cdecl; external Qt4PasLib name 'QMimeData_hasFormat';
procedure QMimeData_formats(handle: QMimeDataH; retval: QStringListH); cdecl; external Qt4PasLib name 'QMimeData_formats';
procedure QMimeData_clear(handle: QMimeDataH); cdecl; external Qt4PasLib name 'QMimeData_clear';


type
  QSocketNotifierType = ( // QSocketNotifier::Type (1)
    QSocketNotifierRead, QSocketNotifierWrite, QSocketNotifierException );

function QSocketNotifier_create(socket: Integer; p2: QSocketNotifierType; parent: QObjectH = nil): QSocketNotifierH; cdecl; external Qt4PasLib name 'QSocketNotifier_create';
procedure QSocketNotifier_destroy(handle: QSocketNotifierH); cdecl; external Qt4PasLib name 'QSocketNotifier_destroy'; 
function QSocketNotifier_socket(handle: QSocketNotifierH): Integer; cdecl; external Qt4PasLib name 'QSocketNotifier_socket';
function QSocketNotifier_type(handle: QSocketNotifierH): QSocketNotifierType; cdecl; external Qt4PasLib name 'QSocketNotifier_type';
function QSocketNotifier_isEnabled(handle: QSocketNotifierH): Boolean; cdecl; external Qt4PasLib name 'QSocketNotifier_isEnabled';
procedure QSocketNotifier_setEnabled(handle: QSocketNotifierH; p1: Boolean); cdecl; external Qt4PasLib name 'QSocketNotifier_setEnabled';


type
  QSocketNotifier_activated_Event = procedure (socket: Integer) of object cdecl;



type
  QThreadPriority = ( // QThread::Priority (1)
    QThreadIdlePriority, QThreadLowestPriority, QThreadLowPriority, QThreadNormalPriority, QThreadHighPriority, QThreadHighestPriority, QThreadTimeCriticalPriority, QThreadInheritPriority );

function QThread_currentThreadId(): QtHANDLE; cdecl; external Qt4PasLib name 'QThread_currentThreadId';
function QThread_currentThread(): QThreadH; cdecl; external Qt4PasLib name 'QThread_currentThread';
function QThread_idealThreadCount(): Integer; cdecl; external Qt4PasLib name 'QThread_idealThreadCount';
procedure QThread_yieldCurrentThread(); cdecl; external Qt4PasLib name 'QThread_yieldCurrentThread';
function QThread_create(parent: QObjectH = nil): QThreadH; cdecl; external Qt4PasLib name 'QThread_create';
procedure QThread_destroy(handle: QThreadH); cdecl; external Qt4PasLib name 'QThread_destroy'; 
procedure QThread_setPriority(handle: QThreadH; priority: QThreadPriority); cdecl; external Qt4PasLib name 'QThread_setPriority';
function QThread_priority(handle: QThreadH): QThreadPriority; cdecl; external Qt4PasLib name 'QThread_priority';
function QThread_isFinished(handle: QThreadH): Boolean; cdecl; external Qt4PasLib name 'QThread_isFinished';
function QThread_isRunning(handle: QThreadH): Boolean; cdecl; external Qt4PasLib name 'QThread_isRunning';
procedure QThread_setStackSize(handle: QThreadH; stackSize: LongWord); cdecl; external Qt4PasLib name 'QThread_setStackSize';
function QThread_stackSize(handle: QThreadH): LongWord; cdecl; external Qt4PasLib name 'QThread_stackSize';
procedure QThread_exit(handle: QThreadH; retcode: Integer = 0); cdecl; external Qt4PasLib name 'QThread_exit';
procedure QThread_start(handle: QThreadH; p1: QThreadPriority = QThreadInheritPriority); cdecl; external Qt4PasLib name 'QThread_start';
procedure QThread_terminate(handle: QThreadH); cdecl; external Qt4PasLib name 'QThread_terminate';
procedure QThread_quit(handle: QThreadH); cdecl; external Qt4PasLib name 'QThread_quit';
function QThread_wait(handle: QThreadH; time: Longword): Boolean; cdecl; external Qt4PasLib name 'QThread_wait';


type
  QThread_started_Event = procedure () of object cdecl;
  QThread_finished_Event = procedure () of object cdecl;
  QThread_terminated_Event = procedure () of object cdecl;


function QLCLThread_create(parent: QObjectH = nil): QLCLThreadH; cdecl; external Qt4PasLib name 'QLCLThread_create';
procedure QLCLThread_destroy(handle: QLCLThreadH); cdecl; external Qt4PasLib name 'QLCLThread_destroy'; 
procedure QLCLThread_override_run(handle: QLCLThreadH; hook: QLCLThread_run_Override); cdecl; external Qt4PasLib name 'QLCLThread_override_run';
function QLCLThread_exec(handle: QLCLThreadH): Integer; cdecl; external Qt4PasLib name 'QLCLThread_exec';


type
  QCharDirection = ( // QChar::Direction (1)
    QCharDirL, QCharDirR, QCharDirEN, QCharDirES, QCharDirET, QCharDirAN, QCharDirCS, QCharDirB, QCharDirS, QCharDirWS, QCharDirON, QCharDirLRE, QCharDirLRO, QCharDirAL, QCharDirRLE, QCharDirRLO, 
    QCharDirPDF, QCharDirNSM, QCharDirBN );

  QCharDecomposition = ( // QChar::Decomposition (1)
    QCharNoDecomposition, QCharCanonical, QCharFont, QCharNoBreak, QCharInitial, QCharMedial, QCharFinal, QCharIsolated, QCharCircle, QCharSuper, QCharSub, QCharVertical, QCharWide, QCharNarrow, 
    QCharSmall, QCharSquare, QCharCompat, QCharFraction );

  QCharJoining = ( // QChar::Joining (1)
    QCharOtherJoining, QCharDual, QCharRight, QCharCenter );

  QCharUnicodeVersion = ( // QChar::UnicodeVersion (1)
    QCharUnicode_Unassigned, QCharUnicode_1_1, QCharUnicode_2_0, QCharUnicode_2_1_2, QCharUnicode_3_0, QCharUnicode_3_1, QCharUnicode_3_2, QCharUnicode_4_0, QCharUnicode_4_1, QCharUnicode_5_0 );

  QCharSpecialCharacter = (  //QChar::SpecialCharacter (2)
    QCharNull = $0000,
    QCharNbsp = $00a0,
    QCharLineSeparator = $2028,
    QCharParagraphSeparator = $2029,
    QCharByteOrderMark = $feff,
    QCharObjectReplacementCharacter = $fffc,
    QCharReplacementCharacter = $fffd,
    QCharByteOrderSwapped = $fffe );

  QCharCombiningClass = (  //QChar::CombiningClass (2)
    QCharCombining_BelowLeftAttached = 200,
    QCharCombining_BelowAttached = 202,
    QCharCombining_BelowRightAttached = 204,
    QCharCombining_LeftAttached = 208,
    QCharCombining_RightAttached = 210,
    QCharCombining_AboveLeftAttached = 212,
    QCharCombining_AboveAttached = 214,
    QCharCombining_AboveRightAttached = 216,
    QCharCombining_BelowLeft = 218,
    QCharCombining_Below = 220,
    QCharCombining_BelowRight = 222,
    QCharCombining_Left = 224,
    QCharCombining_Right = 226,
    QCharCombining_AboveLeft = 228,
    QCharCombining_Above = 230,
    QCharCombining_AboveRight = 232,
    QCharCombining_DoubleBelow = 233,
    QCharCombining_DoubleAbove = 234,
    QCharCombining_IotaSubscript = 240 );

type
  QCharCategory = cardinal; //  QChar::Category (4)

const
    QCharNoCategory = 0 { $0 };
    QCharMark_NonSpacing = 1 { $1 };
    QCharMark_SpacingCombining = 2 { $2 };
    QCharMark_Enclosing = 3 { $3 };
    QCharNumber_DecimalDigit = 4 { $4 };
    QCharNumber_Letter = 5 { $5 };
    QCharNumber_Other = 6 { $6 };
    QCharSeparator_Space = 7 { $7 };
    QCharSeparator_Line = 8 { $8 };
    QCharSeparator_Paragraph = 9 { $9 };
    QCharOther_Control = 10 { $a };
    QCharOther_Format = 11 { $b };
    QCharOther_Surrogate = 12 { $c };
    QCharOther_PrivateUse = 13 { $d };
    QCharOther_NotAssigned = 14 { $e };
    QCharLetter_Uppercase = 15 { $f };
    QCharLetter_Lowercase = 16 { $10 };
    QCharLetter_Titlecase = 17 { $11 };
    QCharLetter_Modifier = 18 { $12 };
    QCharLetter_Other = 19 { $13 };
    QCharPunctuation_Connector = 20 { $14 };
    QCharPunctuation_Dash = 21 { $15 };
    QCharPunctuation_Open = 22 { $16 };
    QCharPunctuation_Close = 23 { $17 };
    QCharPunctuation_InitialQuote = 24 { $18 };
    QCharPunctuation_FinalQuote = 25 { $19 };
    QCharPunctuation_Other = 26 { $1a };
    QCharSymbol_Math = 27 { $1b };
    QCharSymbol_Currency = 28 { $1c };
    QCharSymbol_Modifier = 29 { $1d };
    QCharSymbol_Other = 30 { $1e };
    QCharPunctuation_Dask = 21 { $15 };


function QChar_create(): QCharH; cdecl; external Qt4PasLib name 'QChar_create';
procedure QChar_destroy(handle: QCharH); cdecl; external Qt4PasLib name 'QChar_destroy'; 
function QChar_create(c: char): QCharH; cdecl; external Qt4PasLib name 'QChar_create2';
function QChar_create(c: char; r: char): QCharH; cdecl; external Qt4PasLib name 'QChar_create4';
function QChar_create(rc: Word): QCharH; cdecl; external Qt4PasLib name 'QChar_create5';
function QChar_create(rc: ShortInt): QCharH; cdecl; external Qt4PasLib name 'QChar_create6';
function QChar_create(rc: LongWord): QCharH; cdecl; external Qt4PasLib name 'QChar_create7';
function QChar_create(rc: Integer): QCharH; cdecl; external Qt4PasLib name 'QChar_create8';
function QChar_create(sc: QCharSpecialCharacter): QCharH; cdecl; external Qt4PasLib name 'QChar_create9';
function QChar_category(handle: QCharH): QCharCategory; cdecl; external Qt4PasLib name 'QChar_category';
function QChar_direction(handle: QCharH): QCharDirection; cdecl; external Qt4PasLib name 'QChar_direction';
function QChar_joining(handle: QCharH): QCharJoining; cdecl; external Qt4PasLib name 'QChar_joining';
function QChar_hasMirrored(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_hasMirrored';
function QChar_combiningClass(handle: QCharH): char; cdecl; external Qt4PasLib name 'QChar_combiningClass';
procedure QChar_mirroredChar(handle: QCharH; retval: PWideChar); cdecl; external Qt4PasLib name 'QChar_mirroredChar';
procedure QChar_decomposition(handle: QCharH; retval: PWideString); cdecl; external Qt4PasLib name 'QChar_decomposition';
function QChar_decompositionTag(handle: QCharH): QCharDecomposition; cdecl; external Qt4PasLib name 'QChar_decompositionTag';
function QChar_digitValue(handle: QCharH): Integer; cdecl; external Qt4PasLib name 'QChar_digitValue';
procedure QChar_toLower(handle: QCharH; retval: PWideChar); cdecl; external Qt4PasLib name 'QChar_toLower';
procedure QChar_toUpper(handle: QCharH; retval: PWideChar); cdecl; external Qt4PasLib name 'QChar_toUpper';
procedure QChar_toTitleCase(handle: QCharH; retval: PWideChar); cdecl; external Qt4PasLib name 'QChar_toTitleCase';
procedure QChar_toCaseFolded(handle: QCharH; retval: PWideChar); cdecl; external Qt4PasLib name 'QChar_toCaseFolded';
function QChar_unicodeVersion(handle: QCharH): QCharUnicodeVersion; cdecl; external Qt4PasLib name 'QChar_unicodeVersion';
function QChar_toAscii(handle: QCharH): char; cdecl; external Qt4PasLib name 'QChar_toAscii';
function QChar_toLatin1(handle: QCharH): char; cdecl; external Qt4PasLib name 'QChar_toLatin1';
function QChar_unicode(handle: QCharH): Word; cdecl; external Qt4PasLib name 'QChar_unicode';
procedure QChar_fromAscii(retval: PWideChar; c: char); cdecl; external Qt4PasLib name 'QChar_fromAscii';
procedure QChar_fromLatin1(retval: PWideChar; c: char); cdecl; external Qt4PasLib name 'QChar_fromLatin1';
function QChar_isNull(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isNull';
function QChar_isPrint(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isPrint';
function QChar_isPunct(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isPunct';
function QChar_isSpace(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isSpace';
function QChar_isMark(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isMark';
function QChar_isLetter(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isLetter';
function QChar_isNumber(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isNumber';
function QChar_isLetterOrNumber(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isLetterOrNumber';
function QChar_isDigit(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isDigit';
function QChar_isSymbol(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isSymbol';
function QChar_isLower(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isLower';
function QChar_isUpper(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isUpper';
function QChar_isTitleCase(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isTitleCase';
function QChar_isHighSurrogate(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isHighSurrogate';
function QChar_isLowSurrogate(handle: QCharH): Boolean; cdecl; external Qt4PasLib name 'QChar_isLowSurrogate';
function QChar_cell(handle: QCharH): char; cdecl; external Qt4PasLib name 'QChar_cell';
function QChar_row(handle: QCharH): char; cdecl; external Qt4PasLib name 'QChar_row';
procedure QChar_setCell(handle: QCharH; cell: char); cdecl; external Qt4PasLib name 'QChar_setCell';
procedure QChar_setRow(handle: QCharH; row: char); cdecl; external Qt4PasLib name 'QChar_setRow';
function QChar_surrogateToUcs4(high: Word; low: Word): LongWord; cdecl; external Qt4PasLib name 'QChar_surrogateToUcs4';
function QChar_surrogateToUcs4(high: PWideChar; low: PWideChar): LongWord; cdecl; external Qt4PasLib name 'QChar_surrogateToUcs42';
function QChar_highSurrogate(ucs4: LongWord): Word; cdecl; external Qt4PasLib name 'QChar_highSurrogate';
function QChar_lowSurrogate(ucs4: LongWord): Word; cdecl; external Qt4PasLib name 'QChar_lowSurrogate';

function QSize_create(): QSizeH; cdecl; external Qt4PasLib name 'QSize_create';
procedure QSize_destroy(handle: QSizeH); cdecl; external Qt4PasLib name 'QSize_destroy'; 
function QSize_create(w: Integer; h: Integer): QSizeH; cdecl; external Qt4PasLib name 'QSize_create2';
function QSize_isNull(handle: QSizeH): Boolean; cdecl; external Qt4PasLib name 'QSize_isNull';
function QSize_isEmpty(handle: QSizeH): Boolean; cdecl; external Qt4PasLib name 'QSize_isEmpty';
function QSize_isValid(handle: QSizeH): Boolean; cdecl; external Qt4PasLib name 'QSize_isValid';
function QSize_width(handle: QSizeH): Integer; cdecl; external Qt4PasLib name 'QSize_width';
function QSize_height(handle: QSizeH): Integer; cdecl; external Qt4PasLib name 'QSize_height';
procedure QSize_setWidth(handle: QSizeH; w: Integer); cdecl; external Qt4PasLib name 'QSize_setWidth';
procedure QSize_setHeight(handle: QSizeH; h: Integer); cdecl; external Qt4PasLib name 'QSize_setHeight';
procedure QSize_transpose(handle: QSizeH); cdecl; external Qt4PasLib name 'QSize_transpose';
procedure QSize_scale(handle: QSizeH; w: Integer; h: Integer; mode: QtAspectRatioMode); cdecl; external Qt4PasLib name 'QSize_scale';
procedure QSize_scale(handle: QSizeH; s: PSize; mode: QtAspectRatioMode); cdecl; external Qt4PasLib name 'QSize_scale2';
procedure QSize_expandedTo(handle: QSizeH; retval: PSize; p1: PSize); cdecl; external Qt4PasLib name 'QSize_expandedTo';
procedure QSize_boundedTo(handle: QSizeH; retval: PSize; p1: PSize); cdecl; external Qt4PasLib name 'QSize_boundedTo';
function QSize_rwidth(handle: QSizeH): PInteger; cdecl; external Qt4PasLib name 'QSize_rwidth';
function QSize_rheight(handle: QSizeH): PInteger; cdecl; external Qt4PasLib name 'QSize_rheight';

function QSizeF_create(): QSizeFH; cdecl; external Qt4PasLib name 'QSizeF_create';
procedure QSizeF_destroy(handle: QSizeFH); cdecl; external Qt4PasLib name 'QSizeF_destroy'; 
function QSizeF_create(sz: PSize): QSizeFH; cdecl; external Qt4PasLib name 'QSizeF_create2';
function QSizeF_create(w: qreal; h: qreal): QSizeFH; cdecl; external Qt4PasLib name 'QSizeF_create3';
function QSizeF_isNull(handle: QSizeFH): Boolean; cdecl; external Qt4PasLib name 'QSizeF_isNull';
function QSizeF_isEmpty(handle: QSizeFH): Boolean; cdecl; external Qt4PasLib name 'QSizeF_isEmpty';
function QSizeF_isValid(handle: QSizeFH): Boolean; cdecl; external Qt4PasLib name 'QSizeF_isValid';
function QSizeF_width(handle: QSizeFH): qreal; cdecl; external Qt4PasLib name 'QSizeF_width';
function QSizeF_height(handle: QSizeFH): qreal; cdecl; external Qt4PasLib name 'QSizeF_height';
procedure QSizeF_setWidth(handle: QSizeFH; w: qreal); cdecl; external Qt4PasLib name 'QSizeF_setWidth';
procedure QSizeF_setHeight(handle: QSizeFH; h: qreal); cdecl; external Qt4PasLib name 'QSizeF_setHeight';
procedure QSizeF_transpose(handle: QSizeFH); cdecl; external Qt4PasLib name 'QSizeF_transpose';
procedure QSizeF_scale(handle: QSizeFH; w: qreal; h: qreal; mode: QtAspectRatioMode); cdecl; external Qt4PasLib name 'QSizeF_scale';
procedure QSizeF_scale(handle: QSizeFH; s: QSizeFH; mode: QtAspectRatioMode); cdecl; external Qt4PasLib name 'QSizeF_scale2';
procedure QSizeF_expandedTo(handle: QSizeFH; retval: QSizeFH; p1: QSizeFH); cdecl; external Qt4PasLib name 'QSizeF_expandedTo';
procedure QSizeF_boundedTo(handle: QSizeFH; retval: QSizeFH; p1: QSizeFH); cdecl; external Qt4PasLib name 'QSizeF_boundedTo';
function QSizeF_rwidth(handle: QSizeFH): PQReal; cdecl; external Qt4PasLib name 'QSizeF_rwidth';
function QSizeF_rheight(handle: QSizeFH): PQReal; cdecl; external Qt4PasLib name 'QSizeF_rheight';
procedure QSizeF_toSize(handle: QSizeFH; retval: PSize); cdecl; external Qt4PasLib name 'QSizeF_toSize';


type
  QStringSplitBehavior = ( // QString::SplitBehavior (1)
    QStringKeepEmptyParts, QStringSkipEmptyParts );

  QStringNormalizationForm = ( // QString::NormalizationForm (1)
    QStringNormalizationForm_D, QStringNormalizationForm_C, QStringNormalizationForm_KD, QStringNormalizationForm_KC );

type
  QStringSectionFlag = cardinal; // QString::SectionFlag
  QStringSectionFlags = QStringSectionFlag; //QFlags<> (3)
const
  QStringSectionDefault =   $00;
  QStringSectionSkipEmpty =   $01;
  QStringSectionIncludeLeadingSep =   $02;
  QStringSectionIncludeTrailingSep =   $04;
  QStringSectionCaseInsensitiveSeps =   $08;

function QString_create(): QStringH; cdecl; external Qt4PasLib name 'QString_create';
procedure QString_destroy(handle: QStringH); cdecl; external Qt4PasLib name 'QString_destroy'; 
function QString_create(unicode: PWideChar; size: Integer): QStringH; cdecl; external Qt4PasLib name 'QString_create2';
function QString_create(c: PWideChar): QStringH; cdecl; external Qt4PasLib name 'QString_create3';
function QString_create(size: Integer; c: PWideChar): QStringH; cdecl; external Qt4PasLib name 'QString_create4';
function QString_create(latin1: QLatin1StringH): QStringH; cdecl; external Qt4PasLib name 'QString_create5';
function QString_create(p1: PWideString): QStringH; cdecl; external Qt4PasLib name 'QString_create6';
function QString_size(handle: QStringH): Integer; cdecl; external Qt4PasLib name 'QString_size';
function QString_count(handle: QStringH): Integer; cdecl; external Qt4PasLib name 'QString_count';
function QString_length(handle: QStringH): Integer; cdecl; external Qt4PasLib name 'QString_length';
function QString_isEmpty(handle: QStringH): Boolean; cdecl; external Qt4PasLib name 'QString_isEmpty';
procedure QString_resize(handle: QStringH; size: Integer); cdecl; external Qt4PasLib name 'QString_resize';
procedure QString_fill(handle: QStringH; retval: PWideString; c: PWideChar; size: Integer = -1); cdecl; external Qt4PasLib name 'QString_fill';
procedure QString_truncate(handle: QStringH; pos: Integer); cdecl; external Qt4PasLib name 'QString_truncate';
procedure QString_chop(handle: QStringH; n: Integer); cdecl; external Qt4PasLib name 'QString_chop';
function QString_capacity(handle: QStringH): Integer; cdecl; external Qt4PasLib name 'QString_capacity';
procedure QString_reserve(handle: QStringH; size: Integer); cdecl; external Qt4PasLib name 'QString_reserve';
procedure QString_squeeze(handle: QStringH); cdecl; external Qt4PasLib name 'QString_squeeze';
function QString_unicode(handle: QStringH): PWideChar; cdecl; external Qt4PasLib name 'QString_unicode';
function QString_data(handle: QStringH): PWideChar; cdecl; external Qt4PasLib name 'QString_data';
function QString_constData(handle: QStringH): PWideChar; cdecl; external Qt4PasLib name 'QString_constData';
procedure QString_detach(handle: QStringH); cdecl; external Qt4PasLib name 'QString_detach';
function QString_isDetached(handle: QStringH): Boolean; cdecl; external Qt4PasLib name 'QString_isDetached';
procedure QString_clear(handle: QStringH); cdecl; external Qt4PasLib name 'QString_clear';
procedure QString_at(handle: QStringH; retval: PWideChar; i: Integer); cdecl; external Qt4PasLib name 'QString_at';
procedure QString_arg(handle: QStringH; retval: PWideString; a: int64; fieldwidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg';
procedure QString_arg(handle: QStringH; retval: PWideString; a: qword; fieldwidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg2';
procedure QString_arg(handle: QStringH; retval: PWideString; a: Longword; fieldwidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg4';
procedure QString_arg(handle: QStringH; retval: PWideString; a: ShortInt; fieldWidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg7';
procedure QString_arg(handle: QStringH; retval: PWideString; a: Word; fieldWidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg8';
procedure QString_arg(handle: QStringH; retval: PWideString; a: Double; fieldWidth: Integer; fmt: char; prec: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg9';
procedure QString_arg(handle: QStringH; retval: PWideString; a: char; fieldWidth: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg10';
procedure QString_arg(handle: QStringH; retval: PWideString; a: PWideChar; fieldWidth: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg11';
procedure QString_arg(handle: QStringH; retval: PWideString; a: PWideString; fieldWidth: Integer; fillChar: PWideChar); cdecl; external Qt4PasLib name 'QString_arg12';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString); cdecl; external Qt4PasLib name 'QString_arg13';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString); cdecl; external Qt4PasLib name 'QString_arg14';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString); cdecl; external Qt4PasLib name 'QString_arg15';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString); cdecl; external Qt4PasLib name 'QString_arg16';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString; a6: PWideString); cdecl; external Qt4PasLib name 'QString_arg17';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString; a6: PWideString; a7: PWideString); cdecl; external Qt4PasLib name 'QString_arg18';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString; a6: PWideString; a7: PWideString; a8: PWideString); cdecl; external Qt4PasLib name 'QString_arg19';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString; a6: PWideString; a7: PWideString; a8: PWideString; a9: PWideString); cdecl; external Qt4PasLib name 'QString_arg20';
function QString_indexOf(handle: QStringH; c: PWideChar; from: Integer = 0; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_indexOf';
function QString_indexOf(handle: QStringH; s: PWideString; from: Integer = 0; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_indexOf2';
function QString_indexOf(handle: QStringH; s: QLatin1StringH; from: Integer = 0; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_indexOf3';
function QString_lastIndexOf(handle: QStringH; c: PWideChar; from: Integer = -1; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_lastIndexOf';
function QString_lastIndexOf(handle: QStringH; s: PWideString; from: Integer = -1; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_lastIndexOf2';
function QString_lastIndexOf(handle: QStringH; s: QLatin1StringH; from: Integer = -1; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_lastIndexOf3';
function QString_contains(handle: QStringH; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive): boolean; cdecl; external Qt4PasLib name 'QString_contains';
function QString_contains(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): boolean; cdecl; external Qt4PasLib name 'QString_contains2';
function QString_count(handle: QStringH; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_count2';
function QString_count(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_count3';
function QString_indexOf(handle: QStringH; p1: QRegExpH; from: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QString_indexOf4';
function QString_lastIndexOf(handle: QStringH; p1: QRegExpH; from: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QString_lastIndexOf4';
function QString_contains(handle: QStringH; rx: QRegExpH): boolean; cdecl; external Qt4PasLib name 'QString_contains3';
function QString_count(handle: QStringH; p1: QRegExpH): Integer; cdecl; external Qt4PasLib name 'QString_count4';
procedure QString_section(handle: QStringH; retval: PWideString; sep: PWideChar; start: Integer; _end: Integer = -1; flags: QStringSectionFlags = QStringSectionDefault); cdecl; external Qt4PasLib name 'QString_section';
procedure QString_section(handle: QStringH; retval: PWideString; in_sep: PWideString; start: Integer; _end: Integer = -1; flags: QStringSectionFlags = QStringSectionDefault); cdecl; external Qt4PasLib name 'QString_section2';
procedure QString_section(handle: QStringH; retval: PWideString; reg: QRegExpH; start: Integer; _end: Integer = -1; flags: QStringSectionFlags = QStringSectionDefault); cdecl; external Qt4PasLib name 'QString_section3';
procedure QString_left(handle: QStringH; retval: PWideString; n: Integer); cdecl; external Qt4PasLib name 'QString_left';
procedure QString_right(handle: QStringH; retval: PWideString; n: Integer); cdecl; external Qt4PasLib name 'QString_right';
procedure QString_mid(handle: QStringH; retval: PWideString; position: Integer; n: Integer = -1); cdecl; external Qt4PasLib name 'QString_mid';
function QString_startsWith(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt4PasLib name 'QString_startsWith';
function QString_startsWith(handle: QStringH; s: QLatin1StringH; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt4PasLib name 'QString_startsWith2';
function QString_startsWith(handle: QStringH; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt4PasLib name 'QString_startsWith3';
function QString_endsWith(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt4PasLib name 'QString_endsWith';
function QString_endsWith(handle: QStringH; s: QLatin1StringH; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt4PasLib name 'QString_endsWith2';
function QString_endsWith(handle: QStringH; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt4PasLib name 'QString_endsWith3';
procedure QString_leftJustified(handle: QStringH; retval: PWideString; width: Integer; fill: PWideChar; trunc: Boolean = False); cdecl; external Qt4PasLib name 'QString_leftJustified';
procedure QString_rightJustified(handle: QStringH; retval: PWideString; width: Integer; fill: PWideChar; trunc: Boolean = False); cdecl; external Qt4PasLib name 'QString_rightJustified';
procedure QString_toLower(handle: QStringH; retval: PWideString); cdecl; external Qt4PasLib name 'QString_toLower';
procedure QString_toUpper(handle: QStringH; retval: PWideString); cdecl; external Qt4PasLib name 'QString_toUpper';
procedure QString_toCaseFolded(handle: QStringH; retval: PWideString); cdecl; external Qt4PasLib name 'QString_toCaseFolded';
procedure QString_trimmed(handle: QStringH; retval: PWideString); cdecl; external Qt4PasLib name 'QString_trimmed';
procedure QString_simplified(handle: QStringH; retval: PWideString); cdecl; external Qt4PasLib name 'QString_simplified';
procedure QString_insert(handle: QStringH; retval: PWideString; i: Integer; c: PWideChar); cdecl; external Qt4PasLib name 'QString_insert';
procedure QString_insert(handle: QStringH; retval: PWideString; i: Integer; uc: PWideChar; len: Integer); cdecl; external Qt4PasLib name 'QString_insert2';
procedure QString_insert(handle: QStringH; retval: PWideString; i: Integer; s: PWideString); cdecl; external Qt4PasLib name 'QString_insert3';
procedure QString_insert(handle: QStringH; retval: PWideString; i: Integer; s: QLatin1StringH); cdecl; external Qt4PasLib name 'QString_insert4';
procedure QString_append(handle: QStringH; retval: PWideString; c: PWideChar); cdecl; external Qt4PasLib name 'QString_append';
procedure QString_append(handle: QStringH; retval: PWideString; s: PWideString); cdecl; external Qt4PasLib name 'QString_append2';
procedure QString_append(handle: QStringH; retval: PWideString; s: QLatin1StringH); cdecl; external Qt4PasLib name 'QString_append3';
procedure QString_prepend(handle: QStringH; retval: PWideString; c: PWideChar); cdecl; external Qt4PasLib name 'QString_prepend';
procedure QString_prepend(handle: QStringH; retval: PWideString; s: PWideString); cdecl; external Qt4PasLib name 'QString_prepend2';
procedure QString_prepend(handle: QStringH; retval: PWideString; s: QLatin1StringH); cdecl; external Qt4PasLib name 'QString_prepend3';
procedure QString_remove(handle: QStringH; retval: PWideString; i: Integer; len: Integer); cdecl; external Qt4PasLib name 'QString_remove';
procedure QString_remove(handle: QStringH; retval: PWideString; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_remove2';
procedure QString_remove(handle: QStringH; retval: PWideString; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_remove3';
procedure QString_replace(handle: QStringH; retval: PWideString; i: Integer; len: Integer; after: PWideChar); cdecl; external Qt4PasLib name 'QString_replace';
procedure QString_replace(handle: QStringH; retval: PWideString; i: Integer; len: Integer; s: PWideChar; slen: Integer); cdecl; external Qt4PasLib name 'QString_replace2';
procedure QString_replace(handle: QStringH; retval: PWideString; i: Integer; len: Integer; after: PWideString); cdecl; external Qt4PasLib name 'QString_replace3';
procedure QString_replace(handle: QStringH; retval: PWideString; before: PWideChar; after: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_replace4';
procedure QString_replace(handle: QStringH; retval: PWideString; before: PWideChar; blen: Integer; after: PWideChar; alen: Integer; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_replace5';
procedure QString_replace(handle: QStringH; retval: PWideString; before: QLatin1StringH; after: QLatin1StringH; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_replace6';
procedure QString_replace(handle: QStringH; retval: PWideString; before: QLatin1StringH; after: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_replace7';
procedure QString_replace(handle: QStringH; retval: PWideString; before: PWideString; after: QLatin1StringH; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_replace8';
procedure QString_replace(handle: QStringH; retval: PWideString; before: PWideString; after: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_replace9';
procedure QString_replace(handle: QStringH; retval: PWideString; c: PWideChar; after: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_replace10';
procedure QString_replace(handle: QStringH; retval: PWideString; c: PWideChar; after: QLatin1StringH; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_replace11';
procedure QString_replace(handle: QStringH; retval: PWideString; rx: QRegExpH; after: PWideString); cdecl; external Qt4PasLib name 'QString_replace12';
procedure QString_remove(handle: QStringH; retval: PWideString; rx: QRegExpH); cdecl; external Qt4PasLib name 'QString_remove4';
procedure QString_split(handle: QStringH; retval: QStringListH; sep: PWideString; behavior: QStringSplitBehavior = QStringKeepEmptyParts; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_split';
procedure QString_split(handle: QStringH; retval: QStringListH; sep: PWideChar; behavior: QStringSplitBehavior = QStringKeepEmptyParts; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QString_split2';
procedure QString_split(handle: QStringH; retval: QStringListH; sep: QRegExpH; behavior: QStringSplitBehavior = QStringKeepEmptyParts); cdecl; external Qt4PasLib name 'QString_split3';
procedure QString_normalized(handle: QStringH; retval: PWideString; mode: QStringNormalizationForm); cdecl; external Qt4PasLib name 'QString_normalized';
procedure QString_normalized(handle: QStringH; retval: PWideString; mode: QStringNormalizationForm; version: QCharUnicodeVersion); cdecl; external Qt4PasLib name 'QString_normalized2';
procedure QString_repeated(handle: QStringH; retval: PWideString; times: Integer); cdecl; external Qt4PasLib name 'QString_repeated';
function QString_utf16(handle: QStringH): PWord; cdecl; external Qt4PasLib name 'QString_utf16';
procedure QString_toAscii(handle: QStringH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QString_toAscii';
procedure QString_toLatin1(handle: QStringH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QString_toLatin1';
procedure QString_toUtf8(handle: QStringH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QString_toUtf8';
procedure QString_toLocal8Bit(handle: QStringH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QString_toLocal8Bit';
procedure QString_fromAscii(retval: PWideString; p1: PAnsiChar; size: Integer = -1); cdecl; external Qt4PasLib name 'QString_fromAscii';
procedure QString_fromLatin1(retval: PWideString; p1: PAnsiChar; size: Integer = -1); cdecl; external Qt4PasLib name 'QString_fromLatin1';
procedure QString_fromUtf8(retval: PWideString; p1: PAnsiChar; size: Integer = -1); cdecl; external Qt4PasLib name 'QString_fromUtf8';
procedure QString_fromLocal8Bit(retval: PWideString; p1: PAnsiChar; size: Integer = -1); cdecl; external Qt4PasLib name 'QString_fromLocal8Bit';
procedure QString_fromUtf16(retval: PWideString; p1: PWord; size: Integer = -1); cdecl; external Qt4PasLib name 'QString_fromUtf16';
procedure QString_fromUcs4(retval: PWideString; p1: PLongWord; size: Integer = -1); cdecl; external Qt4PasLib name 'QString_fromUcs4';
procedure QString_fromRawData(retval: PWideString; p1: PWideChar; size: Integer); cdecl; external Qt4PasLib name 'QString_fromRawData';
function QString_toWCharArray(handle: QStringH; _array: PWideChar): Integer; cdecl; external Qt4PasLib name 'QString_toWCharArray';
procedure QString_fromWCharArray(retval: PWideString; p1: PWideChar; size: Integer = -1); cdecl; external Qt4PasLib name 'QString_fromWCharArray';
procedure QString_setUnicode(handle: QStringH; retval: PWideString; unicode: PWideChar; size: Integer); cdecl; external Qt4PasLib name 'QString_setUnicode';
procedure QString_setUtf16(handle: QStringH; retval: PWideString; utf16: PWord; size: Integer); cdecl; external Qt4PasLib name 'QString_setUtf16';
function QString_compare(handle: QStringH; s: PWideString): Integer; cdecl; external Qt4PasLib name 'QString_compare';
function QString_compare(handle: QStringH; s: PWideString; cs: QtCaseSensitivity): Integer; cdecl; external Qt4PasLib name 'QString_compare2';
function QString_compare(handle: QStringH; other: QLatin1StringH; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_compare3';
function QString_compare(s1: PWideString; s2: PWideString): Integer; cdecl; external Qt4PasLib name 'QString_compare4';
function QString_compare(s1: PWideString; s2: PWideString; cs: QtCaseSensitivity): Integer; cdecl; external Qt4PasLib name 'QString_compare5';
function QString_compare(s1: PWideString; s2: QLatin1StringH; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_compare6';
function QString_compare(s1: QLatin1StringH; s2: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QString_compare7';
function QString_localeAwareCompare(handle: QStringH; s: PWideString): Integer; cdecl; external Qt4PasLib name 'QString_localeAwareCompare';
function QString_localeAwareCompare(s1: PWideString; s2: PWideString): Integer; cdecl; external Qt4PasLib name 'QString_localeAwareCompare2';
function QString_toShort(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): ShortInt; cdecl; external Qt4PasLib name 'QString_toShort';
function QString_toUShort(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): Word; cdecl; external Qt4PasLib name 'QString_toUShort';
function QString_toInt(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): Integer; cdecl; external Qt4PasLib name 'QString_toInt';
function QString_toUInt(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): LongWord; cdecl; external Qt4PasLib name 'QString_toUInt';
function QString_toLong(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): Long; cdecl; external Qt4PasLib name 'QString_toLong';
function QString_toULong(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): Longword; cdecl; external Qt4PasLib name 'QString_toULong';
function QString_toLongLong(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): int64; cdecl; external Qt4PasLib name 'QString_toLongLong';
function QString_toULongLong(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): qword; cdecl; external Qt4PasLib name 'QString_toULongLong';
function QString_toFloat(handle: QStringH; ok: PBoolean = nil): Single; cdecl; external Qt4PasLib name 'QString_toFloat';
function QString_toDouble(handle: QStringH; ok: PBoolean = nil): Double; cdecl; external Qt4PasLib name 'QString_toDouble';
procedure QString_setNum(handle: QStringH; retval: PWideString; p1: ShortInt; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_setNum';
procedure QString_setNum(handle: QStringH; retval: PWideString; p1: Word; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_setNum2';
procedure QString_setNum(handle: QStringH; retval: PWideString; p1: Integer; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_setNum3';
procedure QString_setNum(handle: QStringH; retval: PWideString; p1: LongWord; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_setNum4';
procedure QString_setNum(handle: QStringH; retval: PWideString; p1: int64; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_setNum7';
procedure QString_setNum(handle: QStringH; retval: PWideString; p1: qword; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_setNum8';
procedure QString_setNum(handle: QStringH; retval: PWideString; p1: Single; f: char; prec: Integer = 6); cdecl; external Qt4PasLib name 'QString_setNum9';
procedure QString_setNum(handle: QStringH; retval: PWideString; p1: Double; f: char; prec: Integer = 6); cdecl; external Qt4PasLib name 'QString_setNum10';
procedure QString_number(retval: PWideString; p1: Integer; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_number';
procedure QString_number(retval: PWideString; p1: LongWord; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_number2';
procedure QString_number(retval: PWideString; p1: int64; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_number5';
procedure QString_number(retval: PWideString; p1: qword; base: Integer = 10); cdecl; external Qt4PasLib name 'QString_number6';
procedure QString_number(retval: PWideString; p1: Double; f: char; prec: Integer = 6); cdecl; external Qt4PasLib name 'QString_number7';
function QString_create(ch: PAnsiChar): QStringH; cdecl; external Qt4PasLib name 'QString_create7';
function QString_create(a: QByteArrayH): QStringH; cdecl; external Qt4PasLib name 'QString_create8';
procedure QString_prepend(handle: QStringH; retval: PWideString; s: PAnsiChar); cdecl; external Qt4PasLib name 'QString_prepend4';
procedure QString_prepend(handle: QStringH; retval: PWideString; s: QByteArrayH); cdecl; external Qt4PasLib name 'QString_prepend5';
procedure QString_append(handle: QStringH; retval: PWideString; s: PAnsiChar); cdecl; external Qt4PasLib name 'QString_append4';
procedure QString_append(handle: QStringH; retval: PWideString; s: QByteArrayH); cdecl; external Qt4PasLib name 'QString_append5';
procedure QString_push_back(handle: QStringH; c: PWideChar); cdecl; external Qt4PasLib name 'QString_push_back';
procedure QString_push_back(handle: QStringH; s: PWideString); cdecl; external Qt4PasLib name 'QString_push_back2';
procedure QString_push_front(handle: QStringH; c: PWideChar); cdecl; external Qt4PasLib name 'QString_push_front';
procedure QString_push_front(handle: QStringH; s: PWideString); cdecl; external Qt4PasLib name 'QString_push_front2';
function QString_isNull(handle: QStringH): Boolean; cdecl; external Qt4PasLib name 'QString_isNull';
function QString_isSimpleText(handle: QStringH): Boolean; cdecl; external Qt4PasLib name 'QString_isSimpleText';
function QString_isRightToLeft(handle: QStringH): Boolean; cdecl; external Qt4PasLib name 'QString_isRightToLeft';

function QLatin1String_create(s: PAnsiChar): QLatin1StringH; cdecl; external Qt4PasLib name 'QLatin1String_create';
procedure QLatin1String_destroy(handle: QLatin1StringH); cdecl; external Qt4PasLib name 'QLatin1String_destroy'; 
function QLatin1String_latin1(handle: QLatin1StringH): PAnsiChar; cdecl; external Qt4PasLib name 'QLatin1String_latin1';

function QStringList_create(): QStringListH; cdecl; external Qt4PasLib name 'QStringList_create';
procedure QStringList_destroy(handle: QStringListH); cdecl; external Qt4PasLib name 'QStringList_destroy'; 
function QStringList_create(i: PWideString): QStringListH; cdecl; external Qt4PasLib name 'QStringList_create2';
function QStringList_create(l: QStringListH): QStringListH; cdecl; external Qt4PasLib name 'QStringList_create3';
procedure QStringList_sort(handle: QStringListH); cdecl; external Qt4PasLib name 'QStringList_sort';
function QStringList_removeDuplicates(handle: QStringListH): Integer; cdecl; external Qt4PasLib name 'QStringList_removeDuplicates';
procedure QStringList_join(handle: QStringListH; retval: PWideString; sep: PWideString); cdecl; external Qt4PasLib name 'QStringList_join';
procedure QStringList_filter(handle: QStringListH; retval: QStringListH; str: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt4PasLib name 'QStringList_filter';
function QStringList_contains(handle: QStringListH; str: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): boolean; cdecl; external Qt4PasLib name 'QStringList_contains';
function QStringList_replaceInStrings(handle: QStringListH; before: PWideString; after: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): QStringListH; cdecl; external Qt4PasLib name 'QStringList_replaceInStrings';
procedure QStringList_filter(handle: QStringListH; retval: QStringListH; rx: QRegExpH); cdecl; external Qt4PasLib name 'QStringList_filter2';
function QStringList_replaceInStrings(handle: QStringListH; rx: QRegExpH; after: PWideString): QStringListH; cdecl; external Qt4PasLib name 'QStringList_replaceInStrings2';
function QStringList_indexOf(handle: QStringListH; rx: QRegExpH; from: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QStringList_indexOf';
function QStringList_lastIndexOf(handle: QStringListH; rx: QRegExpH; from: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QStringList_lastIndexOf';
function QStringList_size(handle: QStringListH): Integer; cdecl; external Qt4PasLib name 'QStringList_size';
function QStringList_isEmpty(handle: QStringListH): Boolean; cdecl; external Qt4PasLib name 'QStringList_isEmpty';
procedure QStringList_clear(handle: QStringListH); cdecl; external Qt4PasLib name 'QStringList_clear';
procedure QStringList_at(handle: QStringListH; retval: PWideString; i: Integer); cdecl; external Qt4PasLib name 'QStringList_at';
procedure QStringList_append(handle: QStringListH; s: PWideString); cdecl; external Qt4PasLib name 'QStringList_append';
procedure QStringList_prepend(handle: QStringListH; s: PWideString); cdecl; external Qt4PasLib name 'QStringList_prepend';
procedure QStringList_insert(handle: QStringListH; i: Integer; s: PWideString); cdecl; external Qt4PasLib name 'QStringList_insert';
procedure QStringList_replace(handle: QStringListH; i: Integer; s: PWideString); cdecl; external Qt4PasLib name 'QStringList_replace';
procedure QStringList_removeAt(handle: QStringListH; i: Integer); cdecl; external Qt4PasLib name 'QStringList_removeAt';
function QStringList_removeAll(handle: QStringListH; s: PWideString): Integer; cdecl; external Qt4PasLib name 'QStringList_removeAll';
procedure QStringList_takeAt(handle: QStringListH; retval: PWideString; i: Integer); cdecl; external Qt4PasLib name 'QStringList_takeAt';
procedure QStringList_takeFirst(handle: QStringListH; retval: PWideString); cdecl; external Qt4PasLib name 'QStringList_takeFirst';
procedure QStringList_takeLast(handle: QStringListH; retval: PWideString); cdecl; external Qt4PasLib name 'QStringList_takeLast';
procedure QStringList_move(handle: QStringListH; from: Integer; _to: Integer); cdecl; external Qt4PasLib name 'QStringList_move';
procedure QStringList_swap(handle: QStringListH; i: Integer; j: Integer); cdecl; external Qt4PasLib name 'QStringList_swap';

function QRect_create(): QRectH; cdecl; external Qt4PasLib name 'QRect_create';
procedure QRect_destroy(handle: QRectH); cdecl; external Qt4PasLib name 'QRect_destroy'; 
function QRect_create(topleft: PQtPoint; bottomright: PQtPoint): QRectH; cdecl; external Qt4PasLib name 'QRect_create2';
function QRect_create(topleft: PQtPoint; size: PSize): QRectH; cdecl; external Qt4PasLib name 'QRect_create3';
function QRect_create(left: Integer; top: Integer; width: Integer; height: Integer): QRectH; cdecl; external Qt4PasLib name 'QRect_create4';
function QRect_isNull(handle: QRectH): Boolean; cdecl; external Qt4PasLib name 'QRect_isNull';
function QRect_isEmpty(handle: QRectH): Boolean; cdecl; external Qt4PasLib name 'QRect_isEmpty';
function QRect_isValid(handle: QRectH): Boolean; cdecl; external Qt4PasLib name 'QRect_isValid';
function QRect_left(handle: QRectH): Integer; cdecl; external Qt4PasLib name 'QRect_left';
function QRect_top(handle: QRectH): Integer; cdecl; external Qt4PasLib name 'QRect_top';
function QRect_right(handle: QRectH): Integer; cdecl; external Qt4PasLib name 'QRect_right';
function QRect_bottom(handle: QRectH): Integer; cdecl; external Qt4PasLib name 'QRect_bottom';
procedure QRect_normalized(handle: QRectH; retval: PRect); cdecl; external Qt4PasLib name 'QRect_normalized';
function QRect_x(handle: QRectH): Integer; cdecl; external Qt4PasLib name 'QRect_x';
function QRect_y(handle: QRectH): Integer; cdecl; external Qt4PasLib name 'QRect_y';
procedure QRect_setLeft(handle: QRectH; pos: Integer); cdecl; external Qt4PasLib name 'QRect_setLeft';
procedure QRect_setTop(handle: QRectH; pos: Integer); cdecl; external Qt4PasLib name 'QRect_setTop';
procedure QRect_setRight(handle: QRectH; pos: Integer); cdecl; external Qt4PasLib name 'QRect_setRight';
procedure QRect_setBottom(handle: QRectH; pos: Integer); cdecl; external Qt4PasLib name 'QRect_setBottom';
procedure QRect_setX(handle: QRectH; x: Integer); cdecl; external Qt4PasLib name 'QRect_setX';
procedure QRect_setY(handle: QRectH; y: Integer); cdecl; external Qt4PasLib name 'QRect_setY';
procedure QRect_setTopLeft(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_setTopLeft';
procedure QRect_setBottomRight(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_setBottomRight';
procedure QRect_setTopRight(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_setTopRight';
procedure QRect_setBottomLeft(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_setBottomLeft';
procedure QRect_topLeft(handle: QRectH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QRect_topLeft';
procedure QRect_bottomRight(handle: QRectH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QRect_bottomRight';
procedure QRect_topRight(handle: QRectH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QRect_topRight';
procedure QRect_bottomLeft(handle: QRectH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QRect_bottomLeft';
procedure QRect_center(handle: QRectH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QRect_center';
procedure QRect_moveLeft(handle: QRectH; pos: Integer); cdecl; external Qt4PasLib name 'QRect_moveLeft';
procedure QRect_moveTop(handle: QRectH; pos: Integer); cdecl; external Qt4PasLib name 'QRect_moveTop';
procedure QRect_moveRight(handle: QRectH; pos: Integer); cdecl; external Qt4PasLib name 'QRect_moveRight';
procedure QRect_moveBottom(handle: QRectH; pos: Integer); cdecl; external Qt4PasLib name 'QRect_moveBottom';
procedure QRect_moveTopLeft(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_moveTopLeft';
procedure QRect_moveBottomRight(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_moveBottomRight';
procedure QRect_moveTopRight(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_moveTopRight';
procedure QRect_moveBottomLeft(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_moveBottomLeft';
procedure QRect_moveCenter(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_moveCenter';
procedure QRect_translate(handle: QRectH; dx: Integer; dy: Integer); cdecl; external Qt4PasLib name 'QRect_translate';
procedure QRect_translate(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_translate2';
procedure QRect_translated(handle: QRectH; retval: PRect; dx: Integer; dy: Integer); cdecl; external Qt4PasLib name 'QRect_translated';
procedure QRect_translated(handle: QRectH; retval: PRect; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_translated2';
procedure QRect_moveTo(handle: QRectH; x: Integer; t: Integer); cdecl; external Qt4PasLib name 'QRect_moveTo';
procedure QRect_moveTo(handle: QRectH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRect_moveTo2';
procedure QRect_setRect(handle: QRectH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QRect_setRect';
procedure QRect_getRect(handle: QRectH; x: PInteger; y: PInteger; w: PInteger; h: PInteger); cdecl; external Qt4PasLib name 'QRect_getRect';
procedure QRect_setCoords(handle: QRectH; x1: Integer; y1: Integer; x2: Integer; y2: Integer); cdecl; external Qt4PasLib name 'QRect_setCoords';
procedure QRect_getCoords(handle: QRectH; x1: PInteger; y1: PInteger; x2: PInteger; y2: PInteger); cdecl; external Qt4PasLib name 'QRect_getCoords';
procedure QRect_adjust(handle: QRectH; x1: Integer; y1: Integer; x2: Integer; y2: Integer); cdecl; external Qt4PasLib name 'QRect_adjust';
procedure QRect_adjusted(handle: QRectH; retval: PRect; x1: Integer; y1: Integer; x2: Integer; y2: Integer); cdecl; external Qt4PasLib name 'QRect_adjusted';
procedure QRect_size(handle: QRectH; retval: PSize); cdecl; external Qt4PasLib name 'QRect_size';
function QRect_width(handle: QRectH): Integer; cdecl; external Qt4PasLib name 'QRect_width';
function QRect_height(handle: QRectH): Integer; cdecl; external Qt4PasLib name 'QRect_height';
procedure QRect_setWidth(handle: QRectH; w: Integer); cdecl; external Qt4PasLib name 'QRect_setWidth';
procedure QRect_setHeight(handle: QRectH; h: Integer); cdecl; external Qt4PasLib name 'QRect_setHeight';
procedure QRect_setSize(handle: QRectH; s: PSize); cdecl; external Qt4PasLib name 'QRect_setSize';
function QRect_contains(handle: QRectH; p: PQtPoint; proper: Boolean = False): Boolean; cdecl; external Qt4PasLib name 'QRect_contains';
function QRect_contains(handle: QRectH; x: Integer; y: Integer): Boolean; cdecl; external Qt4PasLib name 'QRect_contains2';
function QRect_contains(handle: QRectH; x: Integer; y: Integer; proper: Boolean): Boolean; cdecl; external Qt4PasLib name 'QRect_contains3';
function QRect_contains(handle: QRectH; r: PRect; proper: Boolean = False): Boolean; cdecl; external Qt4PasLib name 'QRect_contains4';
procedure QRect_unite(handle: QRectH; retval: PRect; r: PRect); cdecl; external Qt4PasLib name 'QRect_unite';
procedure QRect_united(handle: QRectH; retval: PRect; other: PRect); cdecl; external Qt4PasLib name 'QRect_united';
procedure QRect_intersect(handle: QRectH; retval: PRect; r: PRect); cdecl; external Qt4PasLib name 'QRect_intersect';
procedure QRect_intersected(handle: QRectH; retval: PRect; other: PRect); cdecl; external Qt4PasLib name 'QRect_intersected';
function QRect_intersects(handle: QRectH; r: PRect): Boolean; cdecl; external Qt4PasLib name 'QRect_intersects';

function QRectF_create(): QRectFH; cdecl; external Qt4PasLib name 'QRectF_create';
procedure QRectF_destroy(handle: QRectFH); cdecl; external Qt4PasLib name 'QRectF_destroy'; 
function QRectF_create(topleft: PQtPointF; size: QSizeFH): QRectFH; cdecl; external Qt4PasLib name 'QRectF_create2';
function QRectF_create(topleft: PQtPointF; bottomRight: PQtPointF): QRectFH; cdecl; external Qt4PasLib name 'QRectF_create3';
function QRectF_create(left: qreal; top: qreal; width: qreal; height: qreal): QRectFH; cdecl; external Qt4PasLib name 'QRectF_create4';
function QRectF_create(rect: PRect): QRectFH; cdecl; external Qt4PasLib name 'QRectF_create5';
function QRectF_isNull(handle: QRectFH): Boolean; cdecl; external Qt4PasLib name 'QRectF_isNull';
function QRectF_isEmpty(handle: QRectFH): Boolean; cdecl; external Qt4PasLib name 'QRectF_isEmpty';
function QRectF_isValid(handle: QRectFH): Boolean; cdecl; external Qt4PasLib name 'QRectF_isValid';
procedure QRectF_normalized(handle: QRectFH; retval: QRectFH); cdecl; external Qt4PasLib name 'QRectF_normalized';
function QRectF_left(handle: QRectFH): qreal; cdecl; external Qt4PasLib name 'QRectF_left';
function QRectF_top(handle: QRectFH): qreal; cdecl; external Qt4PasLib name 'QRectF_top';
function QRectF_right(handle: QRectFH): qreal; cdecl; external Qt4PasLib name 'QRectF_right';
function QRectF_bottom(handle: QRectFH): qreal; cdecl; external Qt4PasLib name 'QRectF_bottom';
function QRectF_x(handle: QRectFH): qreal; cdecl; external Qt4PasLib name 'QRectF_x';
function QRectF_y(handle: QRectFH): qreal; cdecl; external Qt4PasLib name 'QRectF_y';
procedure QRectF_setLeft(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_setLeft';
procedure QRectF_setTop(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_setTop';
procedure QRectF_setRight(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_setRight';
procedure QRectF_setBottom(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_setBottom';
procedure QRectF_setX(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_setX';
procedure QRectF_setY(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_setY';
procedure QRectF_topLeft(handle: QRectFH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_topLeft';
procedure QRectF_bottomRight(handle: QRectFH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_bottomRight';
procedure QRectF_topRight(handle: QRectFH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_topRight';
procedure QRectF_bottomLeft(handle: QRectFH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_bottomLeft';
procedure QRectF_center(handle: QRectFH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_center';
procedure QRectF_setTopLeft(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_setTopLeft';
procedure QRectF_setBottomRight(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_setBottomRight';
procedure QRectF_setTopRight(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_setTopRight';
procedure QRectF_setBottomLeft(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_setBottomLeft';
procedure QRectF_moveLeft(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_moveLeft';
procedure QRectF_moveTop(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_moveTop';
procedure QRectF_moveRight(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_moveRight';
procedure QRectF_moveBottom(handle: QRectFH; pos: qreal); cdecl; external Qt4PasLib name 'QRectF_moveBottom';
procedure QRectF_moveTopLeft(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_moveTopLeft';
procedure QRectF_moveBottomRight(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_moveBottomRight';
procedure QRectF_moveTopRight(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_moveTopRight';
procedure QRectF_moveBottomLeft(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_moveBottomLeft';
procedure QRectF_moveCenter(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_moveCenter';
procedure QRectF_translate(handle: QRectFH; dx: qreal; dy: qreal); cdecl; external Qt4PasLib name 'QRectF_translate';
procedure QRectF_translate(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_translate2';
procedure QRectF_translated(handle: QRectFH; retval: QRectFH; dx: qreal; dy: qreal); cdecl; external Qt4PasLib name 'QRectF_translated';
procedure QRectF_translated(handle: QRectFH; retval: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_translated2';
procedure QRectF_moveTo(handle: QRectFH; x: qreal; t: qreal); cdecl; external Qt4PasLib name 'QRectF_moveTo';
procedure QRectF_moveTo(handle: QRectFH; p: PQtPointF); cdecl; external Qt4PasLib name 'QRectF_moveTo2';
procedure QRectF_setRect(handle: QRectFH; x: qreal; y: qreal; w: qreal; h: qreal); cdecl; external Qt4PasLib name 'QRectF_setRect';
procedure QRectF_getRect(handle: QRectFH; x: PQReal; y: PQReal; w: PQReal; h: PQReal); cdecl; external Qt4PasLib name 'QRectF_getRect';
procedure QRectF_setCoords(handle: QRectFH; x1: qreal; y1: qreal; x2: qreal; y2: qreal); cdecl; external Qt4PasLib name 'QRectF_setCoords';
procedure QRectF_getCoords(handle: QRectFH; x1: PQReal; y1: PQReal; x2: PQReal; y2: PQReal); cdecl; external Qt4PasLib name 'QRectF_getCoords';
procedure QRectF_adjust(handle: QRectFH; x1: qreal; y1: qreal; x2: qreal; y2: qreal); cdecl; external Qt4PasLib name 'QRectF_adjust';
procedure QRectF_adjusted(handle: QRectFH; retval: QRectFH; x1: qreal; y1: qreal; x2: qreal; y2: qreal); cdecl; external Qt4PasLib name 'QRectF_adjusted';
procedure QRectF_size(handle: QRectFH; retval: QSizeFH); cdecl; external Qt4PasLib name 'QRectF_size';
function QRectF_width(handle: QRectFH): qreal; cdecl; external Qt4PasLib name 'QRectF_width';
function QRectF_height(handle: QRectFH): qreal; cdecl; external Qt4PasLib name 'QRectF_height';
procedure QRectF_setWidth(handle: QRectFH; w: qreal); cdecl; external Qt4PasLib name 'QRectF_setWidth';
procedure QRectF_setHeight(handle: QRectFH; h: qreal); cdecl; external Qt4PasLib name 'QRectF_setHeight';
procedure QRectF_setSize(handle: QRectFH; s: QSizeFH); cdecl; external Qt4PasLib name 'QRectF_setSize';
function QRectF_contains(handle: QRectFH; p: PQtPointF): Boolean; cdecl; external Qt4PasLib name 'QRectF_contains';
function QRectF_contains(handle: QRectFH; x: qreal; y: qreal): Boolean; cdecl; external Qt4PasLib name 'QRectF_contains2';
function QRectF_contains(handle: QRectFH; r: QRectFH): Boolean; cdecl; external Qt4PasLib name 'QRectF_contains3';
procedure QRectF_unite(handle: QRectFH; retval: QRectFH; r: QRectFH); cdecl; external Qt4PasLib name 'QRectF_unite';
procedure QRectF_united(handle: QRectFH; retval: QRectFH; other: QRectFH); cdecl; external Qt4PasLib name 'QRectF_united';
procedure QRectF_intersect(handle: QRectFH; retval: QRectFH; r: QRectFH); cdecl; external Qt4PasLib name 'QRectF_intersect';
procedure QRectF_intersected(handle: QRectFH; retval: QRectFH; other: QRectFH); cdecl; external Qt4PasLib name 'QRectF_intersected';
function QRectF_intersects(handle: QRectFH; r: QRectFH): Boolean; cdecl; external Qt4PasLib name 'QRectF_intersects';
procedure QRectF_toRect(handle: QRectFH; retval: PRect); cdecl; external Qt4PasLib name 'QRectF_toRect';
procedure QRectF_toAlignedRect(handle: QRectFH; retval: PRect); cdecl; external Qt4PasLib name 'QRectF_toAlignedRect';


type
  QDateMonthNameType = (  //QDate::MonthNameType (2)
    QDateDateFormat = 0,
    QDateStandaloneFormat );

function QDate_create(): QDateH; cdecl; external Qt4PasLib name 'QDate_create';
procedure QDate_destroy(handle: QDateH); cdecl; external Qt4PasLib name 'QDate_destroy'; 
function QDate_create(y: Integer; m: Integer; d: Integer): QDateH; cdecl; external Qt4PasLib name 'QDate_create2';
function QDate_isNull(handle: QDateH): Boolean; cdecl; external Qt4PasLib name 'QDate_isNull';
function QDate_isValid(handle: QDateH): Boolean; cdecl; external Qt4PasLib name 'QDate_isValid';
function QDate_year(handle: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_year';
function QDate_month(handle: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_month';
function QDate_day(handle: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_day';
function QDate_dayOfWeek(handle: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_dayOfWeek';
function QDate_dayOfYear(handle: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_dayOfYear';
function QDate_daysInMonth(handle: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_daysInMonth';
function QDate_daysInYear(handle: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_daysInYear';
function QDate_weekNumber(handle: QDateH; yearNum: PInteger = nil): Integer; cdecl; external Qt4PasLib name 'QDate_weekNumber';
procedure QDate_shortMonthName(retval: PWideString; month: Integer); cdecl; external Qt4PasLib name 'QDate_shortMonthName';
procedure QDate_shortMonthName(retval: PWideString; month: Integer; _type: QDateMonthNameType); cdecl; external Qt4PasLib name 'QDate_shortMonthName2';
procedure QDate_shortDayName(retval: PWideString; weekday: Integer); cdecl; external Qt4PasLib name 'QDate_shortDayName';
procedure QDate_shortDayName(retval: PWideString; weekday: Integer; _type: QDateMonthNameType); cdecl; external Qt4PasLib name 'QDate_shortDayName2';
procedure QDate_longMonthName(retval: PWideString; month: Integer); cdecl; external Qt4PasLib name 'QDate_longMonthName';
procedure QDate_longMonthName(retval: PWideString; month: Integer; _type: QDateMonthNameType); cdecl; external Qt4PasLib name 'QDate_longMonthName2';
procedure QDate_longDayName(retval: PWideString; weekday: Integer); cdecl; external Qt4PasLib name 'QDate_longDayName';
procedure QDate_longDayName(retval: PWideString; weekday: Integer; _type: QDateMonthNameType); cdecl; external Qt4PasLib name 'QDate_longDayName2';
procedure QDate_toString(handle: QDateH; retval: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt4PasLib name 'QDate_toString';
procedure QDate_toString(handle: QDateH; retval: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QDate_toString2';
function QDate_setYMD(handle: QDateH; y: Integer; m: Integer; d: Integer): Boolean; cdecl; external Qt4PasLib name 'QDate_setYMD';
function QDate_setDate(handle: QDateH; year: Integer; month: Integer; day: Integer): Boolean; cdecl; external Qt4PasLib name 'QDate_setDate';
procedure QDate_getDate(handle: QDateH; year: PInteger; month: PInteger; day: PInteger); cdecl; external Qt4PasLib name 'QDate_getDate';
procedure QDate_addDays(handle: QDateH; retval: QDateH; days: Integer); cdecl; external Qt4PasLib name 'QDate_addDays';
procedure QDate_addMonths(handle: QDateH; retval: QDateH; months: Integer); cdecl; external Qt4PasLib name 'QDate_addMonths';
procedure QDate_addYears(handle: QDateH; retval: QDateH; years: Integer); cdecl; external Qt4PasLib name 'QDate_addYears';
function QDate_daysTo(handle: QDateH; p1: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_daysTo';
procedure QDate_currentDate(retval: QDateH); cdecl; external Qt4PasLib name 'QDate_currentDate';
procedure QDate_fromString(retval: QDateH; s: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt4PasLib name 'QDate_fromString';
procedure QDate_fromString(retval: QDateH; s: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QDate_fromString2';
function QDate_isValid(y: Integer; m: Integer; d: Integer): Boolean; cdecl; external Qt4PasLib name 'QDate_isValid2';
function QDate_isLeapYear(year: Integer): Boolean; cdecl; external Qt4PasLib name 'QDate_isLeapYear';
function QDate_gregorianToJulian(y: Integer; m: Integer; d: Integer): LongWord; cdecl; external Qt4PasLib name 'QDate_gregorianToJulian';
procedure QDate_julianToGregorian(jd: LongWord; y: PInteger; m: PInteger; d: PInteger); cdecl; external Qt4PasLib name 'QDate_julianToGregorian';
procedure QDate_fromJulianDay(retval: QDateH; jd: Integer); cdecl; external Qt4PasLib name 'QDate_fromJulianDay';
function QDate_toJulianDay(handle: QDateH): Integer; cdecl; external Qt4PasLib name 'QDate_toJulianDay';

function QTime_create(): QTimeH; cdecl; external Qt4PasLib name 'QTime_create';
procedure QTime_destroy(handle: QTimeH); cdecl; external Qt4PasLib name 'QTime_destroy'; 
function QTime_create(h: Integer; m: Integer; s: Integer = 0; ms: Integer = 0): QTimeH; cdecl; external Qt4PasLib name 'QTime_create2';
function QTime_isNull(handle: QTimeH): Boolean; cdecl; external Qt4PasLib name 'QTime_isNull';
function QTime_isValid(handle: QTimeH): Boolean; cdecl; external Qt4PasLib name 'QTime_isValid';
function QTime_hour(handle: QTimeH): Integer; cdecl; external Qt4PasLib name 'QTime_hour';
function QTime_minute(handle: QTimeH): Integer; cdecl; external Qt4PasLib name 'QTime_minute';
function QTime_second(handle: QTimeH): Integer; cdecl; external Qt4PasLib name 'QTime_second';
function QTime_msec(handle: QTimeH): Integer; cdecl; external Qt4PasLib name 'QTime_msec';
procedure QTime_toString(handle: QTimeH; retval: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt4PasLib name 'QTime_toString';
procedure QTime_toString(handle: QTimeH; retval: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QTime_toString2';
function QTime_setHMS(handle: QTimeH; h: Integer; m: Integer; s: Integer; ms: Integer = 0): Boolean; cdecl; external Qt4PasLib name 'QTime_setHMS';
procedure QTime_addSecs(handle: QTimeH; retval: QTimeH; secs: Integer); cdecl; external Qt4PasLib name 'QTime_addSecs';
function QTime_secsTo(handle: QTimeH; p1: QTimeH): Integer; cdecl; external Qt4PasLib name 'QTime_secsTo';
procedure QTime_addMSecs(handle: QTimeH; retval: QTimeH; ms: Integer); cdecl; external Qt4PasLib name 'QTime_addMSecs';
function QTime_msecsTo(handle: QTimeH; p1: QTimeH): Integer; cdecl; external Qt4PasLib name 'QTime_msecsTo';
procedure QTime_currentTime(retval: QTimeH); cdecl; external Qt4PasLib name 'QTime_currentTime';
procedure QTime_fromString(retval: QTimeH; s: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt4PasLib name 'QTime_fromString';
procedure QTime_fromString(retval: QTimeH; s: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QTime_fromString2';
function QTime_isValid(h: Integer; m: Integer; s: Integer; ms: Integer = 0): Boolean; cdecl; external Qt4PasLib name 'QTime_isValid2';
procedure QTime_start(handle: QTimeH); cdecl; external Qt4PasLib name 'QTime_start';
function QTime_restart(handle: QTimeH): Integer; cdecl; external Qt4PasLib name 'QTime_restart';
function QTime_elapsed(handle: QTimeH): Integer; cdecl; external Qt4PasLib name 'QTime_elapsed';

function QDateTime_create(): QDateTimeH; cdecl; external Qt4PasLib name 'QDateTime_create';
procedure QDateTime_destroy(handle: QDateTimeH); cdecl; external Qt4PasLib name 'QDateTime_destroy'; 
function QDateTime_create(p1: QDateH): QDateTimeH; cdecl; external Qt4PasLib name 'QDateTime_create2';
function QDateTime_create(p1: QDateH; p2: QTimeH; spec: QtTimeSpec = QtLocalTime): QDateTimeH; cdecl; external Qt4PasLib name 'QDateTime_create3';
function QDateTime_create(other: QDateTimeH): QDateTimeH; cdecl; external Qt4PasLib name 'QDateTime_create4';
function QDateTime_isNull(handle: QDateTimeH): Boolean; cdecl; external Qt4PasLib name 'QDateTime_isNull';
function QDateTime_isValid(handle: QDateTimeH): Boolean; cdecl; external Qt4PasLib name 'QDateTime_isValid';
procedure QDateTime_date(handle: QDateTimeH; retval: QDateH); cdecl; external Qt4PasLib name 'QDateTime_date';
procedure QDateTime_time(handle: QDateTimeH; retval: QTimeH); cdecl; external Qt4PasLib name 'QDateTime_time';
function QDateTime_timeSpec(handle: QDateTimeH): QtTimeSpec; cdecl; external Qt4PasLib name 'QDateTime_timeSpec';
function QDateTime_toTime_t(handle: QDateTimeH): LongWord; cdecl; external Qt4PasLib name 'QDateTime_toTime_t';
procedure QDateTime_setDate(handle: QDateTimeH; date: QDateH); cdecl; external Qt4PasLib name 'QDateTime_setDate';
procedure QDateTime_setTime(handle: QDateTimeH; time: QTimeH); cdecl; external Qt4PasLib name 'QDateTime_setTime';
procedure QDateTime_setTimeSpec(handle: QDateTimeH; spec: QtTimeSpec); cdecl; external Qt4PasLib name 'QDateTime_setTimeSpec';
procedure QDateTime_setTime_t(handle: QDateTimeH; secsSince1Jan1970UTC: LongWord); cdecl; external Qt4PasLib name 'QDateTime_setTime_t';
procedure QDateTime_toString(handle: QDateTimeH; retval: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt4PasLib name 'QDateTime_toString';
procedure QDateTime_toString(handle: QDateTimeH; retval: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QDateTime_toString2';
procedure QDateTime_addDays(handle: QDateTimeH; retval: QDateTimeH; days: Integer); cdecl; external Qt4PasLib name 'QDateTime_addDays';
procedure QDateTime_addMonths(handle: QDateTimeH; retval: QDateTimeH; months: Integer); cdecl; external Qt4PasLib name 'QDateTime_addMonths';
procedure QDateTime_addYears(handle: QDateTimeH; retval: QDateTimeH; years: Integer); cdecl; external Qt4PasLib name 'QDateTime_addYears';
procedure QDateTime_addSecs(handle: QDateTimeH; retval: QDateTimeH; secs: Integer); cdecl; external Qt4PasLib name 'QDateTime_addSecs';
procedure QDateTime_addMSecs(handle: QDateTimeH; retval: QDateTimeH; msecs: int64); cdecl; external Qt4PasLib name 'QDateTime_addMSecs';
procedure QDateTime_toTimeSpec(handle: QDateTimeH; retval: QDateTimeH; spec: QtTimeSpec); cdecl; external Qt4PasLib name 'QDateTime_toTimeSpec';
procedure QDateTime_toLocalTime(handle: QDateTimeH; retval: QDateTimeH); cdecl; external Qt4PasLib name 'QDateTime_toLocalTime';
procedure QDateTime_toUTC(handle: QDateTimeH; retval: QDateTimeH); cdecl; external Qt4PasLib name 'QDateTime_toUTC';
function QDateTime_daysTo(handle: QDateTimeH; p1: QDateTimeH): Integer; cdecl; external Qt4PasLib name 'QDateTime_daysTo';
function QDateTime_secsTo(handle: QDateTimeH; p1: QDateTimeH): Integer; cdecl; external Qt4PasLib name 'QDateTime_secsTo';
procedure QDateTime_setUtcOffset(handle: QDateTimeH; seconds: Integer); cdecl; external Qt4PasLib name 'QDateTime_setUtcOffset';
function QDateTime_utcOffset(handle: QDateTimeH): Integer; cdecl; external Qt4PasLib name 'QDateTime_utcOffset';
procedure QDateTime_currentDateTime(retval: QDateTimeH); cdecl; external Qt4PasLib name 'QDateTime_currentDateTime';
procedure QDateTime_fromString(retval: QDateTimeH; s: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt4PasLib name 'QDateTime_fromString';
procedure QDateTime_fromString(retval: QDateTimeH; s: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QDateTime_fromString2';
procedure QDateTime_fromTime_t(retval: QDateTimeH; secsSince1Jan1970UTC: LongWord); cdecl; external Qt4PasLib name 'QDateTime_fromTime_t';

function QByteArray_create(): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_create';
procedure QByteArray_destroy(handle: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_destroy'; 
function QByteArray_create(p1: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_create2';
function QByteArray_create(p1: PAnsiChar; size: Integer): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_create3';
function QByteArray_create(size: Integer; c: char): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_create4';
function QByteArray_create(p1: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_create5';
function QByteArray_size(handle: QByteArrayH): Integer; cdecl; external Qt4PasLib name 'QByteArray_size';
function QByteArray_isEmpty(handle: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QByteArray_isEmpty';
procedure QByteArray_resize(handle: QByteArrayH; size: Integer); cdecl; external Qt4PasLib name 'QByteArray_resize';
function QByteArray_fill(handle: QByteArrayH; c: char; size: Integer = -1): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_fill';
function QByteArray_capacity(handle: QByteArrayH): Integer; cdecl; external Qt4PasLib name 'QByteArray_capacity';
procedure QByteArray_reserve(handle: QByteArrayH; size: Integer); cdecl; external Qt4PasLib name 'QByteArray_reserve';
procedure QByteArray_squeeze(handle: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_squeeze';
function QByteArray_data(handle: QByteArrayH): PAnsiChar; cdecl; external Qt4PasLib name 'QByteArray_data';
function QByteArray_constData(handle: QByteArrayH): PAnsiChar; cdecl; external Qt4PasLib name 'QByteArray_constData';
procedure QByteArray_detach(handle: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_detach';
function QByteArray_isDetached(handle: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QByteArray_isDetached';
procedure QByteArray_clear(handle: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_clear';
function QByteArray_at(handle: QByteArrayH; i: Integer): char; cdecl; external Qt4PasLib name 'QByteArray_at';
function QByteArray_indexOf(handle: QByteArrayH; c: char; from: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QByteArray_indexOf';
function QByteArray_indexOf(handle: QByteArrayH; c: PAnsiChar; from: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QByteArray_indexOf2';
function QByteArray_indexOf(handle: QByteArrayH; a: QByteArrayH; from: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QByteArray_indexOf3';
function QByteArray_lastIndexOf(handle: QByteArrayH; c: char; from: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QByteArray_lastIndexOf';
function QByteArray_lastIndexOf(handle: QByteArrayH; c: PAnsiChar; from: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QByteArray_lastIndexOf2';
function QByteArray_lastIndexOf(handle: QByteArrayH; a: QByteArrayH; from: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QByteArray_lastIndexOf3';
function QByteArray_contains(handle: QByteArrayH; c: char): boolean; cdecl; external Qt4PasLib name 'QByteArray_contains';
function QByteArray_contains(handle: QByteArrayH; a: PAnsiChar): boolean; cdecl; external Qt4PasLib name 'QByteArray_contains2';
function QByteArray_contains(handle: QByteArrayH; a: QByteArrayH): boolean; cdecl; external Qt4PasLib name 'QByteArray_contains3';
function QByteArray_count(handle: QByteArrayH; c: char): Integer; cdecl; external Qt4PasLib name 'QByteArray_count';
function QByteArray_count(handle: QByteArrayH; a: PAnsiChar): Integer; cdecl; external Qt4PasLib name 'QByteArray_count2';
function QByteArray_count(handle: QByteArrayH; a: QByteArrayH): Integer; cdecl; external Qt4PasLib name 'QByteArray_count3';
procedure QByteArray_left(handle: QByteArrayH; retval: QByteArrayH; len: Integer); cdecl; external Qt4PasLib name 'QByteArray_left';
procedure QByteArray_right(handle: QByteArrayH; retval: QByteArrayH; len: Integer); cdecl; external Qt4PasLib name 'QByteArray_right';
procedure QByteArray_mid(handle: QByteArrayH; retval: QByteArrayH; index: Integer; len: Integer = -1); cdecl; external Qt4PasLib name 'QByteArray_mid';
function QByteArray_startsWith(handle: QByteArrayH; a: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QByteArray_startsWith';
function QByteArray_startsWith(handle: QByteArrayH; c: char): Boolean; cdecl; external Qt4PasLib name 'QByteArray_startsWith2';
function QByteArray_startsWith(handle: QByteArrayH; c: PAnsiChar): Boolean; cdecl; external Qt4PasLib name 'QByteArray_startsWith3';
function QByteArray_endsWith(handle: QByteArrayH; a: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QByteArray_endsWith';
function QByteArray_endsWith(handle: QByteArrayH; c: char): Boolean; cdecl; external Qt4PasLib name 'QByteArray_endsWith2';
function QByteArray_endsWith(handle: QByteArrayH; c: PAnsiChar): Boolean; cdecl; external Qt4PasLib name 'QByteArray_endsWith3';
procedure QByteArray_truncate(handle: QByteArrayH; pos: Integer); cdecl; external Qt4PasLib name 'QByteArray_truncate';
procedure QByteArray_chop(handle: QByteArrayH; n: Integer); cdecl; external Qt4PasLib name 'QByteArray_chop';
procedure QByteArray_toLower(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_toLower';
procedure QByteArray_toUpper(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_toUpper';
procedure QByteArray_trimmed(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_trimmed';
procedure QByteArray_simplified(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_simplified';
procedure QByteArray_leftJustified(handle: QByteArrayH; retval: QByteArrayH; width: Integer; fill: char; truncate: Boolean = False); cdecl; external Qt4PasLib name 'QByteArray_leftJustified';
procedure QByteArray_rightJustified(handle: QByteArrayH; retval: QByteArrayH; width: Integer; fill: char; truncate: Boolean = False); cdecl; external Qt4PasLib name 'QByteArray_rightJustified';
function QByteArray_prepend(handle: QByteArrayH; c: char): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_prepend';
function QByteArray_prepend(handle: QByteArrayH; s: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_prepend2';
function QByteArray_prepend(handle: QByteArrayH; a: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_prepend3';
function QByteArray_append(handle: QByteArrayH; c: char): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_append';
function QByteArray_append(handle: QByteArrayH; s: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_append2';
function QByteArray_append(handle: QByteArrayH; s: PAnsiChar; len: Integer): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_append3';
function QByteArray_append(handle: QByteArrayH; a: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_append4';
function QByteArray_insert(handle: QByteArrayH; i: Integer; c: char): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_insert';
function QByteArray_insert(handle: QByteArrayH; i: Integer; s: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_insert2';
function QByteArray_insert(handle: QByteArrayH; i: Integer; a: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_insert3';
function QByteArray_remove(handle: QByteArrayH; index: Integer; len: Integer): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_remove';
function QByteArray_replace(handle: QByteArrayH; index: Integer; len: Integer; s: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace';
function QByteArray_replace(handle: QByteArrayH; index: Integer; len: Integer; s: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace2';
function QByteArray_replace(handle: QByteArrayH; before: char; after: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace3';
function QByteArray_replace(handle: QByteArrayH; before: char; after: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace4';
function QByteArray_replace(handle: QByteArrayH; before: PAnsiChar; after: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace5';
function QByteArray_replace(handle: QByteArrayH; before: PAnsiChar; bsize: Integer; after: PAnsiChar; asize: Integer): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace6';
function QByteArray_replace(handle: QByteArrayH; before: QByteArrayH; after: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace7';
function QByteArray_replace(handle: QByteArrayH; before: QByteArrayH; after: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace8';
function QByteArray_replace(handle: QByteArrayH; before: PAnsiChar; after: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace9';
function QByteArray_replace(handle: QByteArrayH; before: char; after: char): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace10';
procedure QByteArray_repeated(handle: QByteArrayH; retval: QByteArrayH; times: Integer); cdecl; external Qt4PasLib name 'QByteArray_repeated';
function QByteArray_append(handle: QByteArrayH; s: PWideString): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_append5';
function QByteArray_insert(handle: QByteArrayH; i: Integer; s: PWideString): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_insert4';
function QByteArray_replace(handle: QByteArrayH; before: PWideString; after: PAnsiChar): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace11';
function QByteArray_replace(handle: QByteArrayH; c: char; after: PWideString): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace12';
function QByteArray_replace(handle: QByteArrayH; before: PWideString; after: QByteArrayH): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_replace13';
function QByteArray_indexOf(handle: QByteArrayH; s: PWideString; from: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QByteArray_indexOf4';
function QByteArray_lastIndexOf(handle: QByteArrayH; s: PWideString; from: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QByteArray_lastIndexOf4';
function QByteArray_toShort(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): ShortInt; cdecl; external Qt4PasLib name 'QByteArray_toShort';
function QByteArray_toUShort(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): Word; cdecl; external Qt4PasLib name 'QByteArray_toUShort';
function QByteArray_toInt(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): Integer; cdecl; external Qt4PasLib name 'QByteArray_toInt';
function QByteArray_toUInt(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): LongWord; cdecl; external Qt4PasLib name 'QByteArray_toUInt';
function QByteArray_toLong(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): Long; cdecl; external Qt4PasLib name 'QByteArray_toLong';
function QByteArray_toULong(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): Longword; cdecl; external Qt4PasLib name 'QByteArray_toULong';
function QByteArray_toLongLong(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): int64; cdecl; external Qt4PasLib name 'QByteArray_toLongLong';
function QByteArray_toULongLong(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): qword; cdecl; external Qt4PasLib name 'QByteArray_toULongLong';
function QByteArray_toFloat(handle: QByteArrayH; ok: PBoolean = nil): Single; cdecl; external Qt4PasLib name 'QByteArray_toFloat';
function QByteArray_toDouble(handle: QByteArrayH; ok: PBoolean = nil): Double; cdecl; external Qt4PasLib name 'QByteArray_toDouble';
procedure QByteArray_toBase64(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_toBase64';
procedure QByteArray_toHex(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_toHex';
procedure QByteArray_toPercentEncoding(handle: QByteArrayH; retval: QByteArrayH; exclude: QByteArrayH; include: QByteArrayH; percent: char); cdecl; external Qt4PasLib name 'QByteArray_toPercentEncoding';
function QByteArray_setNum(handle: QByteArrayH; p1: ShortInt; base: Integer = 10): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_setNum';
function QByteArray_setNum(handle: QByteArrayH; p1: Word; base: Integer = 10): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_setNum2';
function QByteArray_setNum(handle: QByteArrayH; p1: Integer; base: Integer = 10): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_setNum3';
function QByteArray_setNum(handle: QByteArrayH; p1: LongWord; base: Integer = 10): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_setNum4';
function QByteArray_setNum(handle: QByteArrayH; p1: int64; base: Integer = 10): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_setNum5';
function QByteArray_setNum(handle: QByteArrayH; p1: qword; base: Integer = 10): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_setNum6';
function QByteArray_setNum(handle: QByteArrayH; p1: Single; f: char; prec: Integer = 6): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_setNum7';
function QByteArray_setNum(handle: QByteArrayH; p1: Double; f: char; prec: Integer = 6): QByteArrayH; cdecl; external Qt4PasLib name 'QByteArray_setNum8';
procedure QByteArray_number(retval: QByteArrayH; p1: Integer; base: Integer = 10); cdecl; external Qt4PasLib name 'QByteArray_number';
procedure QByteArray_number(retval: QByteArrayH; p1: LongWord; base: Integer = 10); cdecl; external Qt4PasLib name 'QByteArray_number2';
procedure QByteArray_number(retval: QByteArrayH; p1: int64; base: Integer = 10); cdecl; external Qt4PasLib name 'QByteArray_number3';
procedure QByteArray_number(retval: QByteArrayH; p1: qword; base: Integer = 10); cdecl; external Qt4PasLib name 'QByteArray_number4';
procedure QByteArray_number(retval: QByteArrayH; p1: Double; f: char; prec: Integer = 6); cdecl; external Qt4PasLib name 'QByteArray_number5';
procedure QByteArray_fromRawData(retval: QByteArrayH; p1: PAnsiChar; size: Integer); cdecl; external Qt4PasLib name 'QByteArray_fromRawData';
procedure QByteArray_fromBase64(retval: QByteArrayH; base64: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_fromBase64';
procedure QByteArray_fromHex(retval: QByteArrayH; hexEncoded: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_fromHex';
procedure QByteArray_fromPercentEncoding(retval: QByteArrayH; pctEncoded: QByteArrayH; percent: char); cdecl; external Qt4PasLib name 'QByteArray_fromPercentEncoding';
procedure QByteArray_push_back(handle: QByteArrayH; c: char); cdecl; external Qt4PasLib name 'QByteArray_push_back';
procedure QByteArray_push_back(handle: QByteArrayH; c: PAnsiChar); cdecl; external Qt4PasLib name 'QByteArray_push_back2';
procedure QByteArray_push_back(handle: QByteArrayH; a: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_push_back3';
procedure QByteArray_push_front(handle: QByteArrayH; c: char); cdecl; external Qt4PasLib name 'QByteArray_push_front';
procedure QByteArray_push_front(handle: QByteArrayH; c: PAnsiChar); cdecl; external Qt4PasLib name 'QByteArray_push_front2';
procedure QByteArray_push_front(handle: QByteArrayH; a: QByteArrayH); cdecl; external Qt4PasLib name 'QByteArray_push_front3';
function QByteArray_count(handle: QByteArrayH): Integer; cdecl; external Qt4PasLib name 'QByteArray_count4';
function QByteArray_length(handle: QByteArrayH): Integer; cdecl; external Qt4PasLib name 'QByteArray_length';
function QByteArray_isNull(handle: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QByteArray_isNull';



type
  QSystemLocaleQueryType = ( // QSystemLocale::QueryType (1)
    QSystemLocaleLanguageId, QSystemLocaleCountryId, QSystemLocaleDecimalPoint, QSystemLocaleGroupSeparator, QSystemLocaleZeroDigit, QSystemLocaleNegativeSign, QSystemLocaleDateFormatLong, 
    QSystemLocaleDateFormatShort, QSystemLocaleTimeFormatLong, QSystemLocaleTimeFormatShort, QSystemLocaleDayNameLong, QSystemLocaleDayNameShort, QSystemLocaleMonthNameLong, QSystemLocaleMonthNameShort, 
    QSystemLocaleDateToStringLong, QSystemLocaleDateToStringShort, QSystemLocaleTimeToStringLong, QSystemLocaleTimeToStringShort, QSystemLocaleDateTimeFormatLong, QSystemLocaleDateTimeFormatShort, 
    QSystemLocaleDateTimeToStringLong, QSystemLocaleDateTimeToStringShort, QSystemLocaleMeasurementSystem, QSystemLocalePositiveSign, QSystemLocaleAMText, QSystemLocalePMText );


type
  QLocaleMeasurementSystem = ( // QLocale::MeasurementSystem (1)
    QLocaleMetricSystem, QLocaleImperialSystem );

  QLocaleFormatType = ( // QLocale::FormatType (1)
    QLocaleLongFormat, QLocaleShortFormat, QLocaleNarrowFormat );

type
  QLocaleNumberOption = cardinal; // QLocale::NumberOption
  QLocaleNumberOptions = QLocaleNumberOption; //QFlags<> (3)
const
  QLocaleOmitGroupSeparator =   $01;
  QLocaleRejectGroupSeparator =   $02;

type
  QLocaleLanguage = cardinal; //  QLocale::Language (4)

const
    QLocaleC = 1 { $1 };
    QLocaleAbkhazian = 2 { $2 };
    QLocaleAfan = 3 { $3 };
    QLocaleAfar = 4 { $4 };
    QLocaleAfrikaans = 5 { $5 };
    QLocaleAlbanian = 6 { $6 };
    QLocaleAmharic = 7 { $7 };
    QLocaleArabic = 8 { $8 };
    QLocaleArmenian = 9 { $9 };
    QLocaleAssamese = 10 { $a };
    QLocaleAymara = 11 { $b };
    QLocaleAzerbaijani = 12 { $c };
    QLocaleBashkir = 13 { $d };
    QLocaleBasque = 14 { $e };
    QLocaleBengali = 15 { $f };
    QLocaleBhutani = 16 { $10 };
    QLocaleBihari = 17 { $11 };
    QLocaleBislama = 18 { $12 };
    QLocaleBreton = 19 { $13 };
    QLocaleBulgarian = 20 { $14 };
    QLocaleBurmese = 21 { $15 };
    QLocaleByelorussian = 22 { $16 };
    QLocaleCambodian = 23 { $17 };
    QLocaleCatalan = 24 { $18 };
    QLocaleChinese = 25 { $19 };
    QLocaleCorsican = 26 { $1a };
    QLocaleCroatian = 27 { $1b };
    QLocaleCzech = 28 { $1c };
    QLocaleDanish = 29 { $1d };
    QLocaleDutch = 30 { $1e };
    QLocaleEnglish = 31 { $1f };
    QLocaleEsperanto = 32 { $20 };
    QLocaleEstonian = 33 { $21 };
    QLocaleFaroese = 34 { $22 };
    QLocaleFijiLanguage = 35 { $23 };
    QLocaleFinnish = 36 { $24 };
    QLocaleFrench = 37 { $25 };
    QLocaleFrisian = 38 { $26 };
    QLocaleGaelic = 39 { $27 };
    QLocaleGalician = 40 { $28 };
    QLocaleGeorgian = 41 { $29 };
    QLocaleGerman = 42 { $2a };
    QLocaleGreek = 43 { $2b };
    QLocaleGreenlandic = 44 { $2c };
    QLocaleGuarani = 45 { $2d };
    QLocaleGujarati = 46 { $2e };
    QLocaleHausa = 47 { $2f };
    QLocaleHebrew = 48 { $30 };
    QLocaleHindi = 49 { $31 };
    QLocaleHungarian = 50 { $32 };
    QLocaleIcelandic = 51 { $33 };
    QLocaleIndonesian = 52 { $34 };
    QLocaleInterlingua = 53 { $35 };
    QLocaleInterlingue = 54 { $36 };
    QLocaleInuktitut = 55 { $37 };
    QLocaleInupiak = 56 { $38 };
    QLocaleIrish = 57 { $39 };
    QLocaleItalian = 58 { $3a };
    QLocaleJapanese = 59 { $3b };
    QLocaleJavanese = 60 { $3c };
    QLocaleKannada = 61 { $3d };
    QLocaleKashmiri = 62 { $3e };
    QLocaleKazakh = 63 { $3f };
    QLocaleKinyarwanda = 64 { $40 };
    QLocaleKirghiz = 65 { $41 };
    QLocaleKorean = 66 { $42 };
    QLocaleKurdish = 67 { $43 };
    QLocaleKurundi = 68 { $44 };
    QLocaleLaothian = 69 { $45 };
    QLocaleLatin = 70 { $46 };
    QLocaleLatvian = 71 { $47 };
    QLocaleLingala = 72 { $48 };
    QLocaleLithuanian = 73 { $49 };
    QLocaleMacedonian = 74 { $4a };
    QLocaleMalagasy = 75 { $4b };
    QLocaleMalay = 76 { $4c };
    QLocaleMalayalam = 77 { $4d };
    QLocaleMaltese = 78 { $4e };
    QLocaleMaori = 79 { $4f };
    QLocaleMarathi = 80 { $50 };
    QLocaleMoldavian = 81 { $51 };
    QLocaleMongolian = 82 { $52 };
    QLocaleNauruLanguage = 83 { $53 };
    QLocaleNepali = 84 { $54 };
    QLocaleNorwegian = 85 { $55 };
    QLocaleNorwegianBokmal = 85 { $55 };
    QLocaleOccitan = 86 { $56 };
    QLocaleOriya = 87 { $57 };
    QLocalePashto = 88 { $58 };
    QLocalePersian = 89 { $59 };
    QLocalePolish = 90 { $5a };
    QLocalePortuguese = 91 { $5b };
    QLocalePunjabi = 92 { $5c };
    QLocaleQuechua = 93 { $5d };
    QLocaleRhaetoRomance = 94 { $5e };
    QLocaleRomanian = 95 { $5f };
    QLocaleRussian = 96 { $60 };
    QLocaleSamoan = 97 { $61 };
    QLocaleSangho = 98 { $62 };
    QLocaleSanskrit = 99 { $63 };
    QLocaleSerbian = 100 { $64 };
    QLocaleSerboCroatian = 101 { $65 };
    QLocaleSesotho = 102 { $66 };
    QLocaleSetswana = 103 { $67 };
    QLocaleShona = 104 { $68 };
    QLocaleSindhi = 105 { $69 };
    QLocaleSinghalese = 106 { $6a };
    QLocaleSiswati = 107 { $6b };
    QLocaleSlovak = 108 { $6c };
    QLocaleSlovenian = 109 { $6d };
    QLocaleSomali = 110 { $6e };
    QLocaleSpanish = 111 { $6f };
    QLocaleSundanese = 112 { $70 };
    QLocaleSwahili = 113 { $71 };
    QLocaleSwedish = 114 { $72 };
    QLocaleTagalog = 115 { $73 };
    QLocaleTajik = 116 { $74 };
    QLocaleTamil = 117 { $75 };
    QLocaleTatar = 118 { $76 };
    QLocaleTelugu = 119 { $77 };
    QLocaleThai = 120 { $78 };
    QLocaleTibetan = 121 { $79 };
    QLocaleTigrinya = 122 { $7a };
    QLocaleTongaLanguage = 123 { $7b };
    QLocaleTsonga = 124 { $7c };
    QLocaleTurkish = 125 { $7d };
    QLocaleTurkmen = 126 { $7e };
    QLocaleTwi = 127 { $7f };
    QLocaleUigur = 128 { $80 };
    QLocaleUkrainian = 129 { $81 };
    QLocaleUrdu = 130 { $82 };
    QLocaleUzbek = 131 { $83 };
    QLocaleVietnamese = 132 { $84 };
    QLocaleVolapuk = 133 { $85 };
    QLocaleWelsh = 134 { $86 };
    QLocaleWolof = 135 { $87 };
    QLocaleXhosa = 136 { $88 };
    QLocaleYiddish = 137 { $89 };
    QLocaleYoruba = 138 { $8a };
    QLocaleZhuang = 139 { $8b };
    QLocaleZulu = 140 { $8c };
    QLocaleNorwegianNynorsk = 141 { $8d };
    QLocaleNynorsk = 141 { $8d };
    QLocaleBosnian = 142 { $8e };
    QLocaleDivehi = 143 { $8f };
    QLocaleManx = 144 { $90 };
    QLocaleCornish = 145 { $91 };
    QLocaleAkan = 146 { $92 };
    QLocaleKonkani = 147 { $93 };
    QLocaleGa = 148 { $94 };
    QLocaleIgbo = 149 { $95 };
    QLocaleKamba = 150 { $96 };
    QLocaleSyriac = 151 { $97 };
    QLocaleBlin = 152 { $98 };
    QLocaleGeez = 153 { $99 };
    QLocaleKoro = 154 { $9a };
    QLocaleSidamo = 155 { $9b };
    QLocaleAtsam = 156 { $9c };
    QLocaleTigre = 157 { $9d };
    QLocaleJju = 158 { $9e };
    QLocaleFriulian = 159 { $9f };
    QLocaleVenda = 160 { $a0 };
    QLocaleEwe = 161 { $a1 };
    QLocaleWalamo = 162 { $a2 };
    QLocaleHawaiian = 163 { $a3 };
    QLocaleTyap = 164 { $a4 };
    QLocaleChewa = 165 { $a5 };
    QLocaleLastLanguage = 165 { $a5 };

type
  QLocaleCountry = cardinal; //  QLocale::Country (4)

const
    QLocaleAnyCountry = 0 { $0 };
    QLocaleAfghanistan = 1 { $1 };
    QLocaleAlbania = 2 { $2 };
    QLocaleAlgeria = 3 { $3 };
    QLocaleAmericanSamoa = 4 { $4 };
    QLocaleAndorra = 5 { $5 };
    QLocaleAngola = 6 { $6 };
    QLocaleAnguilla = 7 { $7 };
    QLocaleAntarctica = 8 { $8 };
    QLocaleAntiguaAndBarbuda = 9 { $9 };
    QLocaleArgentina = 10 { $a };
    QLocaleArmenia = 11 { $b };
    QLocaleAruba = 12 { $c };
    QLocaleAustralia = 13 { $d };
    QLocaleAustria = 14 { $e };
    QLocaleAzerbaijan = 15 { $f };
    QLocaleBahamas = 16 { $10 };
    QLocaleBahrain = 17 { $11 };
    QLocaleBangladesh = 18 { $12 };
    QLocaleBarbados = 19 { $13 };
    QLocaleBelarus = 20 { $14 };
    QLocaleBelgium = 21 { $15 };
    QLocaleBelize = 22 { $16 };
    QLocaleBenin = 23 { $17 };
    QLocaleBermuda = 24 { $18 };
    QLocaleBhutan = 25 { $19 };
    QLocaleBolivia = 26 { $1a };
    QLocaleBosniaAndHerzegowina = 27 { $1b };
    QLocaleBotswana = 28 { $1c };
    QLocaleBouvetIsland = 29 { $1d };
    QLocaleBrazil = 30 { $1e };
    QLocaleBritishIndianOceanTerritory = 31 { $1f };
    QLocaleBruneiDarussalam = 32 { $20 };
    QLocaleBulgaria = 33 { $21 };
    QLocaleBurkinaFaso = 34 { $22 };
    QLocaleBurundi = 35 { $23 };
    QLocaleCambodia = 36 { $24 };
    QLocaleCameroon = 37 { $25 };
    QLocaleCanada = 38 { $26 };
    QLocaleCapeVerde = 39 { $27 };
    QLocaleCaymanIslands = 40 { $28 };
    QLocaleCentralAfricanRepublic = 41 { $29 };
    QLocaleChad = 42 { $2a };
    QLocaleChile = 43 { $2b };
    QLocaleChina = 44 { $2c };
    QLocaleChristmasIsland = 45 { $2d };
    QLocaleCocosIslands = 46 { $2e };
    QLocaleColombia = 47 { $2f };
    QLocaleComoros = 48 { $30 };
    QLocaleDemocraticRepublicOfCongo = 49 { $31 };
    QLocalePeoplesRepublicOfCongo = 50 { $32 };
    QLocaleCookIslands = 51 { $33 };
    QLocaleCostaRica = 52 { $34 };
    QLocaleIvoryCoast = 53 { $35 };
    QLocaleCroatia = 54 { $36 };
    QLocaleCuba = 55 { $37 };
    QLocaleCyprus = 56 { $38 };
    QLocaleCzechRepublic = 57 { $39 };
    QLocaleDenmark = 58 { $3a };
    QLocaleDjibouti = 59 { $3b };
    QLocaleDominica = 60 { $3c };
    QLocaleDominicanRepublic = 61 { $3d };
    QLocaleEastTimor = 62 { $3e };
    QLocaleEcuador = 63 { $3f };
    QLocaleEgypt = 64 { $40 };
    QLocaleElSalvador = 65 { $41 };
    QLocaleEquatorialGuinea = 66 { $42 };
    QLocaleEritrea = 67 { $43 };
    QLocaleEstonia = 68 { $44 };
    QLocaleEthiopia = 69 { $45 };
    QLocaleFalklandIslands = 70 { $46 };
    QLocaleFaroeIslands = 71 { $47 };
    QLocaleFijiCountry = 72 { $48 };
    QLocaleFinland = 73 { $49 };
    QLocaleFrance = 74 { $4a };
    QLocaleMetropolitanFrance = 75 { $4b };
    QLocaleFrenchGuiana = 76 { $4c };
    QLocaleFrenchPolynesia = 77 { $4d };
    QLocaleFrenchSouthernTerritories = 78 { $4e };
    QLocaleGabon = 79 { $4f };
    QLocaleGambia = 80 { $50 };
    QLocaleGeorgia = 81 { $51 };
    QLocaleGermany = 82 { $52 };
    QLocaleGhana = 83 { $53 };
    QLocaleGibraltar = 84 { $54 };
    QLocaleGreece = 85 { $55 };
    QLocaleGreenland = 86 { $56 };
    QLocaleGrenada = 87 { $57 };
    QLocaleGuadeloupe = 88 { $58 };
    QLocaleGuam = 89 { $59 };
    QLocaleGuatemala = 90 { $5a };
    QLocaleGuinea = 91 { $5b };
    QLocaleGuineaBissau = 92 { $5c };
    QLocaleGuyana = 93 { $5d };
    QLocaleHaiti = 94 { $5e };
    QLocaleHeardAndMcDonaldIslands = 95 { $5f };
    QLocaleHonduras = 96 { $60 };
    QLocaleHongKong = 97 { $61 };
    QLocaleHungary = 98 { $62 };
    QLocaleIceland = 99 { $63 };
    QLocaleIndia = 100 { $64 };
    QLocaleIndonesia = 101 { $65 };
    QLocaleIran = 102 { $66 };
    QLocaleIraq = 103 { $67 };
    QLocaleIreland = 104 { $68 };
    QLocaleIsrael = 105 { $69 };
    QLocaleItaly = 106 { $6a };
    QLocaleJamaica = 107 { $6b };
    QLocaleJapan = 108 { $6c };
    QLocaleJordan = 109 { $6d };
    QLocaleKazakhstan = 110 { $6e };
    QLocaleKenya = 111 { $6f };
    QLocaleKiribati = 112 { $70 };
    QLocaleDemocraticRepublicOfKorea = 113 { $71 };
    QLocaleRepublicOfKorea = 114 { $72 };
    QLocaleKuwait = 115 { $73 };
    QLocaleKyrgyzstan = 116 { $74 };
    QLocaleLao = 117 { $75 };
    QLocaleLatvia = 118 { $76 };
    QLocaleLebanon = 119 { $77 };
    QLocaleLesotho = 120 { $78 };
    QLocaleLiberia = 121 { $79 };
    QLocaleLibyanArabJamahiriya = 122 { $7a };
    QLocaleLiechtenstein = 123 { $7b };
    QLocaleLithuania = 124 { $7c };
    QLocaleLuxembourg = 125 { $7d };
    QLocaleMacau = 126 { $7e };
    QLocaleMacedonia = 127 { $7f };
    QLocaleMadagascar = 128 { $80 };
    QLocaleMalawi = 129 { $81 };
    QLocaleMalaysia = 130 { $82 };
    QLocaleMaldives = 131 { $83 };
    QLocaleMali = 132 { $84 };
    QLocaleMalta = 133 { $85 };
    QLocaleMarshallIslands = 134 { $86 };
    QLocaleMartinique = 135 { $87 };
    QLocaleMauritania = 136 { $88 };
    QLocaleMauritius = 137 { $89 };
    QLocaleMayotte = 138 { $8a };
    QLocaleMexico = 139 { $8b };
    QLocaleMicronesia = 140 { $8c };
    QLocaleMoldova = 141 { $8d };
    QLocaleMonaco = 142 { $8e };
    QLocaleMongolia = 143 { $8f };
    QLocaleMontserrat = 144 { $90 };
    QLocaleMorocco = 145 { $91 };
    QLocaleMozambique = 146 { $92 };
    QLocaleMyanmar = 147 { $93 };
    QLocaleNamibia = 148 { $94 };
    QLocaleNauruCountry = 149 { $95 };
    QLocaleNepal = 150 { $96 };
    QLocaleNetherlands = 151 { $97 };
    QLocaleNetherlandsAntilles = 152 { $98 };
    QLocaleNewCaledonia = 153 { $99 };
    QLocaleNewZealand = 154 { $9a };
    QLocaleNicaragua = 155 { $9b };
    QLocaleNiger = 156 { $9c };
    QLocaleNigeria = 157 { $9d };
    QLocaleNiue = 158 { $9e };
    QLocaleNorfolkIsland = 159 { $9f };
    QLocaleNorthernMarianaIslands = 160 { $a0 };
    QLocaleNorway = 161 { $a1 };
    QLocaleOman = 162 { $a2 };
    QLocalePakistan = 163 { $a3 };
    QLocalePalau = 164 { $a4 };
    QLocalePalestinianTerritory = 165 { $a5 };
    QLocalePanama = 166 { $a6 };
    QLocalePapuaNewGuinea = 167 { $a7 };
    QLocaleParaguay = 168 { $a8 };
    QLocalePeru = 169 { $a9 };
    QLocalePhilippines = 170 { $aa };
    QLocalePitcairn = 171 { $ab };
    QLocalePoland = 172 { $ac };
    QLocalePortugal = 173 { $ad };
    QLocalePuertoRico = 174 { $ae };
    QLocaleQatar = 175 { $af };
    QLocaleReunion = 176 { $b0 };
    QLocaleRomania = 177 { $b1 };
    QLocaleRussianFederation = 178 { $b2 };
    QLocaleRwanda = 179 { $b3 };
    QLocaleSaintKittsAndNevis = 180 { $b4 };
    QLocaleStLucia = 181 { $b5 };
    QLocaleStVincentAndTheGrenadines = 182 { $b6 };
    QLocaleSamoa = 183 { $b7 };
    QLocaleSanMarino = 184 { $b8 };
    QLocaleSaoTomeAndPrincipe = 185 { $b9 };
    QLocaleSaudiArabia = 186 { $ba };
    QLocaleSenegal = 187 { $bb };
    QLocaleSeychelles = 188 { $bc };
    QLocaleSierraLeone = 189 { $bd };
    QLocaleSingapore = 190 { $be };
    QLocaleSlovakia = 191 { $bf };
    QLocaleSlovenia = 192 { $c0 };
    QLocaleSolomonIslands = 193 { $c1 };
    QLocaleSomalia = 194 { $c2 };
    QLocaleSouthAfrica = 195 { $c3 };
    QLocaleSouthGeorgiaAndTheSouthSandwichIslands = 196 { $c4 };
    QLocaleSpain = 197 { $c5 };
    QLocaleSriLanka = 198 { $c6 };
    QLocaleStHelena = 199 { $c7 };
    QLocaleStPierreAndMiquelon = 200 { $c8 };
    QLocaleSudan = 201 { $c9 };
    QLocaleSuriname = 202 { $ca };
    QLocaleSvalbardAndJanMayenIslands = 203 { $cb };
    QLocaleSwaziland = 204 { $cc };
    QLocaleSweden = 205 { $cd };
    QLocaleSwitzerland = 206 { $ce };
    QLocaleSyrianArabRepublic = 207 { $cf };
    QLocaleTaiwan = 208 { $d0 };
    QLocaleTajikistan = 209 { $d1 };
    QLocaleTanzania = 210 { $d2 };
    QLocaleThailand = 211 { $d3 };
    QLocaleTogo = 212 { $d4 };
    QLocaleTokelau = 213 { $d5 };
    QLocaleTongaCountry = 214 { $d6 };
    QLocaleTrinidadAndTobago = 215 { $d7 };
    QLocaleTunisia = 216 { $d8 };
    QLocaleTurkey = 217 { $d9 };
    QLocaleTurkmenistan = 218 { $da };
    QLocaleTurksAndCaicosIslands = 219 { $db };
    QLocaleTuvalu = 220 { $dc };
    QLocaleUganda = 221 { $dd };
    QLocaleUkraine = 222 { $de };
    QLocaleUnitedArabEmirates = 223 { $df };
    QLocaleUnitedKingdom = 224 { $e0 };
    QLocaleUnitedStates = 225 { $e1 };
    QLocaleUnitedStatesMinorOutlyingIslands = 226 { $e2 };
    QLocaleUruguay = 227 { $e3 };
    QLocaleUzbekistan = 228 { $e4 };
    QLocaleVanuatu = 229 { $e5 };
    QLocaleVaticanCityState = 230 { $e6 };
    QLocaleVenezuela = 231 { $e7 };
    QLocaleVietNam = 232 { $e8 };
    QLocaleBritishVirginIslands = 233 { $e9 };
    QLocaleUSVirginIslands = 234 { $ea };
    QLocaleWallisAndFutunaIslands = 235 { $eb };
    QLocaleWesternSahara = 236 { $ec };
    QLocaleYemen = 237 { $ed };
    QLocaleYugoslavia = 238 { $ee };
    QLocaleZambia = 239 { $ef };
    QLocaleZimbabwe = 240 { $f0 };
    QLocaleSerbiaAndMontenegro = 241 { $f1 };
    QLocaleLastCountry = 241 { $f1 };


function QSystemLocale_create(): QSystemLocaleH; cdecl; external Qt4PasLib name 'QSystemLocale_create';
procedure QSystemLocale_destroy(handle: QSystemLocaleH); cdecl; external Qt4PasLib name 'QSystemLocale_destroy'; 
procedure QSystemLocale_fallbackLocale(handle: QSystemLocaleH; retval: QLocaleH); cdecl; external Qt4PasLib name 'QSystemLocale_fallbackLocale';

function QLocale_create(): QLocaleH; cdecl; external Qt4PasLib name 'QLocale_create';
procedure QLocale_destroy(handle: QLocaleH); cdecl; external Qt4PasLib name 'QLocale_destroy'; 
function QLocale_create(name: PWideString): QLocaleH; cdecl; external Qt4PasLib name 'QLocale_create2';
function QLocale_create(language: QLocaleLanguage; country: QLocaleCountry = QLocaleAnyCountry): QLocaleH; cdecl; external Qt4PasLib name 'QLocale_create3';
function QLocale_create(other: QLocaleH): QLocaleH; cdecl; external Qt4PasLib name 'QLocale_create4';
function QLocale_language(handle: QLocaleH): QLocaleLanguage; cdecl; external Qt4PasLib name 'QLocale_language';
function QLocale_country(handle: QLocaleH): QLocaleCountry; cdecl; external Qt4PasLib name 'QLocale_country';
procedure QLocale_name(handle: QLocaleH; retval: PWideString); cdecl; external Qt4PasLib name 'QLocale_name';
function QLocale_toShort(handle: QLocaleH; s: PWideString; ok: PBoolean = nil; base: Integer = 0): ShortInt; cdecl; external Qt4PasLib name 'QLocale_toShort';
function QLocale_toUShort(handle: QLocaleH; s: PWideString; ok: PBoolean = nil; base: Integer = 0): Word; cdecl; external Qt4PasLib name 'QLocale_toUShort';
function QLocale_toInt(handle: QLocaleH; s: PWideString; ok: PBoolean = nil; base: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QLocale_toInt';
function QLocale_toUInt(handle: QLocaleH; s: PWideString; ok: PBoolean = nil; base: Integer = 0): LongWord; cdecl; external Qt4PasLib name 'QLocale_toUInt';
function QLocale_toLongLong(handle: QLocaleH; s: PWideString; ok: PBoolean = nil; base: Integer = 0): int64; cdecl; external Qt4PasLib name 'QLocale_toLongLong';
function QLocale_toULongLong(handle: QLocaleH; s: PWideString; ok: PBoolean = nil; base: Integer = 0): int64; cdecl; external Qt4PasLib name 'QLocale_toULongLong';
function QLocale_toFloat(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): Single; cdecl; external Qt4PasLib name 'QLocale_toFloat';
function QLocale_toDouble(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): Double; cdecl; external Qt4PasLib name 'QLocale_toDouble';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: int64); cdecl; external Qt4PasLib name 'QLocale_toString';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: qword); cdecl; external Qt4PasLib name 'QLocale_toString2';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: ShortInt); cdecl; external Qt4PasLib name 'QLocale_toString3';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: Word); cdecl; external Qt4PasLib name 'QLocale_toString4';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: Integer); cdecl; external Qt4PasLib name 'QLocale_toString5';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: LongWord); cdecl; external Qt4PasLib name 'QLocale_toString6';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: Double; f: char; prec: Integer = 6); cdecl; external Qt4PasLib name 'QLocale_toString7';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: Single; f: char; prec: Integer = 6); cdecl; external Qt4PasLib name 'QLocale_toString8';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; date: QDateH; formatStr: PWideString); cdecl; external Qt4PasLib name 'QLocale_toString9';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; date: QDateH; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_toString10';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; time: QTimeH; formatStr: PWideString); cdecl; external Qt4PasLib name 'QLocale_toString11';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; time: QTimeH; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_toString12';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; dateTime: QDateTimeH; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_toString13';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; dateTime: QDateTimeH; format: PWideString); cdecl; external Qt4PasLib name 'QLocale_toString14';
procedure QLocale_dateFormat(handle: QLocaleH; retval: PWideString; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_dateFormat';
procedure QLocale_timeFormat(handle: QLocaleH; retval: PWideString; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_timeFormat';
procedure QLocale_dateTimeFormat(handle: QLocaleH; retval: PWideString; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_dateTimeFormat';
procedure QLocale_toDate(handle: QLocaleH; retval: QDateH; _string: PWideString; p2: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_toDate';
procedure QLocale_toTime(handle: QLocaleH; retval: QTimeH; _string: PWideString; p2: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_toTime';
procedure QLocale_toDateTime(handle: QLocaleH; retval: QDateTimeH; _string: PWideString; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_toDateTime';
procedure QLocale_toDate(handle: QLocaleH; retval: QDateH; _string: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QLocale_toDate2';
procedure QLocale_toTime(handle: QLocaleH; retval: QTimeH; _string: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QLocale_toTime2';
procedure QLocale_toDateTime(handle: QLocaleH; retval: QDateTimeH; _string: PWideString; format: PWideString); cdecl; external Qt4PasLib name 'QLocale_toDateTime2';
procedure QLocale_decimalPoint(handle: QLocaleH; retval: PWideChar); cdecl; external Qt4PasLib name 'QLocale_decimalPoint';
procedure QLocale_groupSeparator(handle: QLocaleH; retval: PWideChar); cdecl; external Qt4PasLib name 'QLocale_groupSeparator';
procedure QLocale_percent(handle: QLocaleH; retval: PWideChar); cdecl; external Qt4PasLib name 'QLocale_percent';
procedure QLocale_zeroDigit(handle: QLocaleH; retval: PWideChar); cdecl; external Qt4PasLib name 'QLocale_zeroDigit';
procedure QLocale_negativeSign(handle: QLocaleH; retval: PWideChar); cdecl; external Qt4PasLib name 'QLocale_negativeSign';
procedure QLocale_positiveSign(handle: QLocaleH; retval: PWideChar); cdecl; external Qt4PasLib name 'QLocale_positiveSign';
procedure QLocale_exponential(handle: QLocaleH; retval: PWideChar); cdecl; external Qt4PasLib name 'QLocale_exponential';
procedure QLocale_monthName(handle: QLocaleH; retval: PWideString; p1: Integer; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_monthName';
procedure QLocale_standaloneMonthName(handle: QLocaleH; retval: PWideString; p1: Integer; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_standaloneMonthName';
procedure QLocale_dayName(handle: QLocaleH; retval: PWideString; p1: Integer; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_dayName';
procedure QLocale_standaloneDayName(handle: QLocaleH; retval: PWideString; p1: Integer; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt4PasLib name 'QLocale_standaloneDayName';
procedure QLocale_amText(handle: QLocaleH; retval: PWideString); cdecl; external Qt4PasLib name 'QLocale_amText';
procedure QLocale_pmText(handle: QLocaleH; retval: PWideString); cdecl; external Qt4PasLib name 'QLocale_pmText';
function QLocale_measurementSystem(handle: QLocaleH): QLocaleMeasurementSystem; cdecl; external Qt4PasLib name 'QLocale_measurementSystem';
procedure QLocale_languageToString(retval: PWideString; language: QLocaleLanguage); cdecl; external Qt4PasLib name 'QLocale_languageToString';
procedure QLocale_countryToString(retval: PWideString; country: QLocaleCountry); cdecl; external Qt4PasLib name 'QLocale_countryToString';
procedure QLocale_setDefault(locale: QLocaleH); cdecl; external Qt4PasLib name 'QLocale_setDefault';
procedure QLocale_c(retval: QLocaleH); cdecl; external Qt4PasLib name 'QLocale_c';
procedure QLocale_system(retval: QLocaleH); cdecl; external Qt4PasLib name 'QLocale_system';
procedure QLocale_setNumberOptions(handle: QLocaleH; options: QLocaleNumberOptions); cdecl; external Qt4PasLib name 'QLocale_setNumberOptions';
function QLocale_numberOptions(handle: QLocaleH): QLocaleNumberOptions; cdecl; external Qt4PasLib name 'QLocale_numberOptions';

type
  QIODeviceOpenModeFlag = cardinal; //  QIODevice::OpenModeFlag (4)
  QIODeviceOpenMode = QIODeviceOpenModeFlag; // QFlags<>

const
    QIODeviceNotOpen = 0 { $0 };
    QIODeviceReadOnly = 1 { $1 };
    QIODeviceWriteOnly = 2 { $2 };
    QIODeviceReadWrite = 3 { $3 };
    QIODeviceAppend = 4 { $4 };
    QIODeviceTruncate = 8 { $8 };
    QIODeviceText = 16 { $10 };
    QIODeviceUnbuffered = 32 { $20 };


function QIODevice_openMode(handle: QIODeviceH): QIODeviceOpenMode; cdecl; external Qt4PasLib name 'QIODevice_openMode';
procedure QIODevice_setTextModeEnabled(handle: QIODeviceH; enabled: Boolean); cdecl; external Qt4PasLib name 'QIODevice_setTextModeEnabled';
function QIODevice_isTextModeEnabled(handle: QIODeviceH): Boolean; cdecl; external Qt4PasLib name 'QIODevice_isTextModeEnabled';
function QIODevice_isOpen(handle: QIODeviceH): Boolean; cdecl; external Qt4PasLib name 'QIODevice_isOpen';
function QIODevice_isReadable(handle: QIODeviceH): Boolean; cdecl; external Qt4PasLib name 'QIODevice_isReadable';
function QIODevice_isWritable(handle: QIODeviceH): Boolean; cdecl; external Qt4PasLib name 'QIODevice_isWritable';
function QIODevice_isSequential(handle: QIODeviceH): Boolean; cdecl; external Qt4PasLib name 'QIODevice_isSequential';
function QIODevice_open(handle: QIODeviceH; mode: QIODeviceOpenMode): Boolean; cdecl; external Qt4PasLib name 'QIODevice_open';
procedure QIODevice_close(handle: QIODeviceH); cdecl; external Qt4PasLib name 'QIODevice_close';
function QIODevice_pos(handle: QIODeviceH): int64; cdecl; external Qt4PasLib name 'QIODevice_pos';
function QIODevice_size(handle: QIODeviceH): int64; cdecl; external Qt4PasLib name 'QIODevice_size';
function QIODevice_seek(handle: QIODeviceH; pos: int64): Boolean; cdecl; external Qt4PasLib name 'QIODevice_seek';
function QIODevice_atEnd(handle: QIODeviceH): Boolean; cdecl; external Qt4PasLib name 'QIODevice_atEnd';
function QIODevice_reset(handle: QIODeviceH): Boolean; cdecl; external Qt4PasLib name 'QIODevice_reset';
function QIODevice_bytesAvailable(handle: QIODeviceH): int64; cdecl; external Qt4PasLib name 'QIODevice_bytesAvailable';
function QIODevice_bytesToWrite(handle: QIODeviceH): int64; cdecl; external Qt4PasLib name 'QIODevice_bytesToWrite';
function QIODevice_read(handle: QIODeviceH; data: PAnsiChar; maxlen: int64): int64; cdecl; external Qt4PasLib name 'QIODevice_read';
procedure QIODevice_read(handle: QIODeviceH; retval: QByteArrayH; maxlen: int64); cdecl; external Qt4PasLib name 'QIODevice_read2';
procedure QIODevice_readAll(handle: QIODeviceH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QIODevice_readAll';
function QIODevice_readLine(handle: QIODeviceH; data: PAnsiChar; maxlen: int64): int64; cdecl; external Qt4PasLib name 'QIODevice_readLine';
procedure QIODevice_readLine(handle: QIODeviceH; retval: QByteArrayH; maxlen: int64 = 0); cdecl; external Qt4PasLib name 'QIODevice_readLine2';
function QIODevice_canReadLine(handle: QIODeviceH): Boolean; cdecl; external Qt4PasLib name 'QIODevice_canReadLine';
function QIODevice_write(handle: QIODeviceH; data: PAnsiChar; len: int64): int64; cdecl; external Qt4PasLib name 'QIODevice_write';
function QIODevice_write(handle: QIODeviceH; data: PAnsiChar): int64; cdecl; external Qt4PasLib name 'QIODevice_write2';
function QIODevice_write(handle: QIODeviceH; data: QByteArrayH): int64; cdecl; external Qt4PasLib name 'QIODevice_write3';
function QIODevice_peek(handle: QIODeviceH; data: PAnsiChar; maxlen: int64): int64; cdecl; external Qt4PasLib name 'QIODevice_peek';
procedure QIODevice_peek(handle: QIODeviceH; retval: QByteArrayH; maxlen: int64); cdecl; external Qt4PasLib name 'QIODevice_peek2';
function QIODevice_waitForReadyRead(handle: QIODeviceH; msecs: Integer): Boolean; cdecl; external Qt4PasLib name 'QIODevice_waitForReadyRead';
function QIODevice_waitForBytesWritten(handle: QIODeviceH; msecs: Integer): Boolean; cdecl; external Qt4PasLib name 'QIODevice_waitForBytesWritten';
procedure QIODevice_ungetChar(handle: QIODeviceH; c: char); cdecl; external Qt4PasLib name 'QIODevice_ungetChar';
function QIODevice_putChar(handle: QIODeviceH; c: char): Boolean; cdecl; external Qt4PasLib name 'QIODevice_putChar';
function QIODevice_getChar(handle: QIODeviceH; c: PAnsiChar): Boolean; cdecl; external Qt4PasLib name 'QIODevice_getChar';
procedure QIODevice_errorString(handle: QIODeviceH; retval: PWideString); cdecl; external Qt4PasLib name 'QIODevice_errorString';


type
  QIODevice_readyRead_Event = procedure () of object cdecl;
  QIODevice_bytesWritten_Event = procedure (bytes: int64) of object cdecl;
  QIODevice_aboutToClose_Event = procedure () of object cdecl;
  QIODevice_readChannelFinished_Event = procedure () of object cdecl;



type
  QProcessProcessError = ( // QProcess::ProcessError (1)
    QProcessFailedToStart, QProcessCrashed, QProcessTimedout, QProcessReadError, QProcessWriteError, QProcessUnknownError );

  QProcessProcessState = ( // QProcess::ProcessState (1)
    QProcessNotRunning, QProcessStarting, QProcessRunning );

  QProcessProcessChannel = ( // QProcess::ProcessChannel (1)
    QProcessStandardOutput, QProcessStandardError );

  QProcessProcessChannelMode = ( // QProcess::ProcessChannelMode (1)
    QProcessSeparateChannels, QProcessMergedChannels, QProcessForwardedChannels );

  QProcessExitStatus = ( // QProcess::ExitStatus (1)
    QProcessNormalExit, QProcessCrashExit );

function QProcess_create(parent: QObjectH = nil): QProcessH; cdecl; external Qt4PasLib name 'QProcess_create';
procedure QProcess_destroy(handle: QProcessH); cdecl; external Qt4PasLib name 'QProcess_destroy'; 
procedure QProcess_start(handle: QProcessH; _program: PWideString; arguments: QStringListH; mode: QIODeviceOpenMode); cdecl; external Qt4PasLib name 'QProcess_start';
procedure QProcess_start(handle: QProcessH; _program: PWideString; mode: QIODeviceOpenMode); cdecl; external Qt4PasLib name 'QProcess_start2';
function QProcess_readChannelMode(handle: QProcessH): QProcessProcessChannelMode; cdecl; external Qt4PasLib name 'QProcess_readChannelMode';
procedure QProcess_setReadChannelMode(handle: QProcessH; mode: QProcessProcessChannelMode); cdecl; external Qt4PasLib name 'QProcess_setReadChannelMode';
function QProcess_processChannelMode(handle: QProcessH): QProcessProcessChannelMode; cdecl; external Qt4PasLib name 'QProcess_processChannelMode';
procedure QProcess_setProcessChannelMode(handle: QProcessH; mode: QProcessProcessChannelMode); cdecl; external Qt4PasLib name 'QProcess_setProcessChannelMode';
function QProcess_readChannel(handle: QProcessH): QProcessProcessChannel; cdecl; external Qt4PasLib name 'QProcess_readChannel';
procedure QProcess_setReadChannel(handle: QProcessH; channel: QProcessProcessChannel); cdecl; external Qt4PasLib name 'QProcess_setReadChannel';
procedure QProcess_closeReadChannel(handle: QProcessH; channel: QProcessProcessChannel); cdecl; external Qt4PasLib name 'QProcess_closeReadChannel';
procedure QProcess_closeWriteChannel(handle: QProcessH); cdecl; external Qt4PasLib name 'QProcess_closeWriteChannel';
procedure QProcess_setStandardInputFile(handle: QProcessH; fileName: PWideString); cdecl; external Qt4PasLib name 'QProcess_setStandardInputFile';
procedure QProcess_setStandardOutputFile(handle: QProcessH; fileName: PWideString; mode: QIODeviceOpenMode); cdecl; external Qt4PasLib name 'QProcess_setStandardOutputFile';
procedure QProcess_setStandardErrorFile(handle: QProcessH; fileName: PWideString; mode: QIODeviceOpenMode); cdecl; external Qt4PasLib name 'QProcess_setStandardErrorFile';
procedure QProcess_setStandardOutputProcess(handle: QProcessH; destination: QProcessH); cdecl; external Qt4PasLib name 'QProcess_setStandardOutputProcess';
procedure QProcess_workingDirectory(handle: QProcessH; retval: PWideString); cdecl; external Qt4PasLib name 'QProcess_workingDirectory';
procedure QProcess_setWorkingDirectory(handle: QProcessH; dir: PWideString); cdecl; external Qt4PasLib name 'QProcess_setWorkingDirectory';
procedure QProcess_setEnvironment(handle: QProcessH; environment: QStringListH); cdecl; external Qt4PasLib name 'QProcess_setEnvironment';
procedure QProcess_environment(handle: QProcessH; retval: QStringListH); cdecl; external Qt4PasLib name 'QProcess_environment';
function QProcess_error(handle: QProcessH): QProcessProcessError; cdecl; external Qt4PasLib name 'QProcess_error';
function QProcess_state(handle: QProcessH): QProcessProcessState; cdecl; external Qt4PasLib name 'QProcess_state';
function QProcess_pid(handle: QProcessH): Q_PID; cdecl; external Qt4PasLib name 'QProcess_pid';
function QProcess_waitForStarted(handle: QProcessH; msecs: Integer = 30000): Boolean; cdecl; external Qt4PasLib name 'QProcess_waitForStarted';
function QProcess_waitForReadyRead(handle: QProcessH; msecs: Integer = 30000): Boolean; cdecl; external Qt4PasLib name 'QProcess_waitForReadyRead';
function QProcess_waitForBytesWritten(handle: QProcessH; msecs: Integer = 30000): Boolean; cdecl; external Qt4PasLib name 'QProcess_waitForBytesWritten';
function QProcess_waitForFinished(handle: QProcessH; msecs: Integer = 30000): Boolean; cdecl; external Qt4PasLib name 'QProcess_waitForFinished';
procedure QProcess_readAllStandardOutput(handle: QProcessH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QProcess_readAllStandardOutput';
procedure QProcess_readAllStandardError(handle: QProcessH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QProcess_readAllStandardError';
function QProcess_exitCode(handle: QProcessH): Integer; cdecl; external Qt4PasLib name 'QProcess_exitCode';
function QProcess_exitStatus(handle: QProcessH): QProcessExitStatus; cdecl; external Qt4PasLib name 'QProcess_exitStatus';
function QProcess_bytesAvailable(handle: QProcessH): int64; cdecl; external Qt4PasLib name 'QProcess_bytesAvailable';
function QProcess_bytesToWrite(handle: QProcessH): int64; cdecl; external Qt4PasLib name 'QProcess_bytesToWrite';
function QProcess_isSequential(handle: QProcessH): Boolean; cdecl; external Qt4PasLib name 'QProcess_isSequential';
function QProcess_canReadLine(handle: QProcessH): Boolean; cdecl; external Qt4PasLib name 'QProcess_canReadLine';
procedure QProcess_close(handle: QProcessH); cdecl; external Qt4PasLib name 'QProcess_close';
function QProcess_atEnd(handle: QProcessH): Boolean; cdecl; external Qt4PasLib name 'QProcess_atEnd';
function QProcess_execute(_program: PWideString; arguments: QStringListH): Integer; cdecl; external Qt4PasLib name 'QProcess_execute';
function QProcess_execute(_program: PWideString): Integer; cdecl; external Qt4PasLib name 'QProcess_execute2';
function QProcess_startDetached(_program: PWideString; arguments: QStringListH; workingDirectory: PWideString; pid: pint64 = nil): Boolean; cdecl; external Qt4PasLib name 'QProcess_startDetached';
function QProcess_startDetached(_program: PWideString; arguments: QStringListH): Boolean; cdecl; external Qt4PasLib name 'QProcess_startDetached2';
function QProcess_startDetached(_program: PWideString): Boolean; cdecl; external Qt4PasLib name 'QProcess_startDetached3';
procedure QProcess_systemEnvironment(retval: QStringListH); cdecl; external Qt4PasLib name 'QProcess_systemEnvironment';
procedure QProcess_terminate(handle: QProcessH); cdecl; external Qt4PasLib name 'QProcess_terminate';
procedure QProcess_kill(handle: QProcessH); cdecl; external Qt4PasLib name 'QProcess_kill';


type
  QProcess_started_Event = procedure () of object cdecl;
  QProcess_finished_Event = procedure (exitCode: Integer) of object cdecl;
  QProcess_finished2_Event = procedure (exitCode: Integer; exitStatus: QProcessExitStatus) of object cdecl;
  QProcess_error_Event = procedure (error: QProcessProcessError) of object cdecl;
  QProcess_stateChanged_Event = procedure (state: QProcessProcessState) of object cdecl;
  QProcess_readyReadStandardOutput_Event = procedure () of object cdecl;
  QProcess_readyReadStandardError_Event = procedure () of object cdecl;



type
  QFileFileError = (  //QFile::FileError (2)
    QFileNoError = 0,
    QFileReadError = 1,
    QFileWriteError = 2,
    QFileFatalError = 3,
    QFileResourceError = 4,
    QFileOpenError = 5,
    QFileAbortError = 6,
    QFileTimeOutError = 7,
    QFileUnspecifiedError = 8,
    QFileRemoveError = 9,
    QFileRenameError = 10,
    QFilePositionError = 11,
    QFileResizeError = 12,
    QFilePermissionsError = 13,
    QFileCopyError = 14 );

type
  QFilePermission = cardinal; // QFile::Permission
  QFilePermissions = QFilePermission; //QFlags<> (3)
const
  QFileReadOwner =   $4000;
  QFileWriteOwner =   $2000;
  QFileExeOwner =   $1000;
  QFileReadUser =   $0400;
  QFileWriteUser =   $0200;
  QFileExeUser =   $0100;
  QFileReadGroup =   $0040;
  QFileWriteGroup =   $0020;
  QFileExeGroup =   $0010;
  QFileReadOther =   $0004;
  QFileWriteOther =   $0002;
  QFileExeOther =   $0001;


type
  QFileMemoryMapFlags = (  //QFile::MemoryMapFlags (2)
    QFileNoOptions = 0 );

function QFile_create(): QFileH; cdecl; external Qt4PasLib name 'QFile_create';
procedure QFile_destroy(handle: QFileH); cdecl; external Qt4PasLib name 'QFile_destroy'; 
function QFile_create(name: PWideString): QFileH; cdecl; external Qt4PasLib name 'QFile_create2';
function QFile_create(parent: QObjectH): QFileH; cdecl; external Qt4PasLib name 'QFile_create3';
function QFile_create(name: PWideString; parent: QObjectH): QFileH; cdecl; external Qt4PasLib name 'QFile_create4';
function QFile_error(handle: QFileH): QFileFileError; cdecl; external Qt4PasLib name 'QFile_error';
procedure QFile_unsetError(handle: QFileH); cdecl; external Qt4PasLib name 'QFile_unsetError';
procedure QFile_fileName(handle: QFileH; retval: PWideString); cdecl; external Qt4PasLib name 'QFile_fileName';
procedure QFile_setFileName(handle: QFileH; name: PWideString); cdecl; external Qt4PasLib name 'QFile_setFileName';
procedure QFile_encodeName(retval: QByteArrayH; fileName: PWideString); cdecl; external Qt4PasLib name 'QFile_encodeName';
procedure QFile_decodeName(retval: PWideString; localFileName: QByteArrayH); cdecl; external Qt4PasLib name 'QFile_decodeName';
procedure QFile_decodeName(retval: PWideString; localFileName: PAnsiChar); cdecl; external Qt4PasLib name 'QFile_decodeName2';
function QFile_exists(handle: QFileH): Boolean; cdecl; external Qt4PasLib name 'QFile_exists';
function QFile_exists(fileName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFile_exists2';
procedure QFile_readLink(handle: QFileH; retval: PWideString); cdecl; external Qt4PasLib name 'QFile_readLink';
procedure QFile_readLink(retval: PWideString; fileName: PWideString); cdecl; external Qt4PasLib name 'QFile_readLink2';
procedure QFile_symLinkTarget(handle: QFileH; retval: PWideString); cdecl; external Qt4PasLib name 'QFile_symLinkTarget';
procedure QFile_symLinkTarget(retval: PWideString; fileName: PWideString); cdecl; external Qt4PasLib name 'QFile_symLinkTarget2';
function QFile_remove(handle: QFileH): Boolean; cdecl; external Qt4PasLib name 'QFile_remove';
function QFile_remove(fileName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFile_remove2';
function QFile_rename(handle: QFileH; newName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFile_rename';
function QFile_rename(oldName: PWideString; newName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFile_rename2';
function QFile_link(handle: QFileH; newName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFile_link';
function QFile_link(oldname: PWideString; newName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFile_link2';
function QFile_copy(handle: QFileH; newName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFile_copy';
function QFile_copy(fileName: PWideString; newName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFile_copy2';
function QFile_isSequential(handle: QFileH): Boolean; cdecl; external Qt4PasLib name 'QFile_isSequential';
function QFile_open(handle: QFileH; flags: QIODeviceOpenMode): Boolean; cdecl; external Qt4PasLib name 'QFile_open';
function QFile_open(handle: QFileH; fd: Integer; flags: QIODeviceOpenMode): Boolean; cdecl; external Qt4PasLib name 'QFile_open2';
procedure QFile_close(handle: QFileH); cdecl; external Qt4PasLib name 'QFile_close';
function QFile_size(handle: QFileH): int64; cdecl; external Qt4PasLib name 'QFile_size';
function QFile_pos(handle: QFileH): int64; cdecl; external Qt4PasLib name 'QFile_pos';
function QFile_seek(handle: QFileH; offset: int64): Boolean; cdecl; external Qt4PasLib name 'QFile_seek';
function QFile_atEnd(handle: QFileH): Boolean; cdecl; external Qt4PasLib name 'QFile_atEnd';
function QFile_flush(handle: QFileH): Boolean; cdecl; external Qt4PasLib name 'QFile_flush';
function QFile_resize(handle: QFileH; sz: int64): Boolean; cdecl; external Qt4PasLib name 'QFile_resize';
function QFile_resize(filename: PWideString; sz: int64): Boolean; cdecl; external Qt4PasLib name 'QFile_resize2';
function QFile_permissions(handle: QFileH): QFilePermissions; cdecl; external Qt4PasLib name 'QFile_permissions';
function QFile_permissions(filename: PWideString): QFilePermissions; cdecl; external Qt4PasLib name 'QFile_permissions2';
function QFile_setPermissions(handle: QFileH; permissionSpec: QFilePermissions): Boolean; cdecl; external Qt4PasLib name 'QFile_setPermissions';
function QFile_setPermissions(filename: PWideString; permissionSpec: QFilePermissions): Boolean; cdecl; external Qt4PasLib name 'QFile_setPermissions2';
function QFile_handle(handle: QFileH): Integer; cdecl; external Qt4PasLib name 'QFile_handle';
function QFile_map(handle: QFileH; offset: int64; size: int64; flags: QFileMemoryMapFlags = QFileNoOptions): PByte; cdecl; external Qt4PasLib name 'QFile_map';
function QFile_unmap(handle: QFileH; address: PByte): Boolean; cdecl; external Qt4PasLib name 'QFile_unmap';
function QFile_fileEngine(handle: QFileH): QAbstractFileEngineH; cdecl; external Qt4PasLib name 'QFile_fileEngine';

function QFileInfo_create(): QFileInfoH; cdecl; external Qt4PasLib name 'QFileInfo_create';
procedure QFileInfo_destroy(handle: QFileInfoH); cdecl; external Qt4PasLib name 'QFileInfo_destroy'; 
function QFileInfo_create(_file: PWideString): QFileInfoH; cdecl; external Qt4PasLib name 'QFileInfo_create2';
function QFileInfo_create(_file: QFileH): QFileInfoH; cdecl; external Qt4PasLib name 'QFileInfo_create3';
function QFileInfo_create(dir: QDirH; _file: PWideString): QFileInfoH; cdecl; external Qt4PasLib name 'QFileInfo_create4';
function QFileInfo_create(fileinfo: QFileInfoH): QFileInfoH; cdecl; external Qt4PasLib name 'QFileInfo_create5';
procedure QFileInfo_setFile(handle: QFileInfoH; _file: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_setFile';
procedure QFileInfo_setFile(handle: QFileInfoH; _file: QFileH); cdecl; external Qt4PasLib name 'QFileInfo_setFile2';
procedure QFileInfo_setFile(handle: QFileInfoH; dir: QDirH; _file: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_setFile3';
function QFileInfo_exists(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_exists';
procedure QFileInfo_refresh(handle: QFileInfoH); cdecl; external Qt4PasLib name 'QFileInfo_refresh';
procedure QFileInfo_filePath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_filePath';
procedure QFileInfo_absoluteFilePath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_absoluteFilePath';
procedure QFileInfo_canonicalFilePath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_canonicalFilePath';
procedure QFileInfo_fileName(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_fileName';
procedure QFileInfo_baseName(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_baseName';
procedure QFileInfo_completeBaseName(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_completeBaseName';
procedure QFileInfo_suffix(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_suffix';
procedure QFileInfo_bundleName(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_bundleName';
procedure QFileInfo_completeSuffix(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_completeSuffix';
procedure QFileInfo_path(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_path';
procedure QFileInfo_absolutePath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_absolutePath';
procedure QFileInfo_canonicalPath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_canonicalPath';
procedure QFileInfo_dir(handle: QFileInfoH; retval: QDirH); cdecl; external Qt4PasLib name 'QFileInfo_dir';
procedure QFileInfo_absoluteDir(handle: QFileInfoH; retval: QDirH); cdecl; external Qt4PasLib name 'QFileInfo_absoluteDir';
function QFileInfo_isReadable(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isReadable';
function QFileInfo_isWritable(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isWritable';
function QFileInfo_isExecutable(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isExecutable';
function QFileInfo_isHidden(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isHidden';
function QFileInfo_isRelative(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isRelative';
function QFileInfo_isAbsolute(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isAbsolute';
function QFileInfo_makeAbsolute(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_makeAbsolute';
function QFileInfo_isFile(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isFile';
function QFileInfo_isDir(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isDir';
function QFileInfo_isSymLink(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isSymLink';
function QFileInfo_isRoot(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isRoot';
function QFileInfo_isBundle(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_isBundle';
procedure QFileInfo_readLink(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_readLink';
procedure QFileInfo_symLinkTarget(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_symLinkTarget';
procedure QFileInfo_owner(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_owner';
function QFileInfo_ownerId(handle: QFileInfoH): LongWord; cdecl; external Qt4PasLib name 'QFileInfo_ownerId';
procedure QFileInfo_group(handle: QFileInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileInfo_group';
function QFileInfo_groupId(handle: QFileInfoH): LongWord; cdecl; external Qt4PasLib name 'QFileInfo_groupId';
function QFileInfo_permission(handle: QFileInfoH; permissions: QFilePermissions): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_permission';
function QFileInfo_permissions(handle: QFileInfoH): QFilePermissions; cdecl; external Qt4PasLib name 'QFileInfo_permissions';
function QFileInfo_size(handle: QFileInfoH): int64; cdecl; external Qt4PasLib name 'QFileInfo_size';
procedure QFileInfo_created(handle: QFileInfoH; retval: QDateTimeH); cdecl; external Qt4PasLib name 'QFileInfo_created';
procedure QFileInfo_lastModified(handle: QFileInfoH; retval: QDateTimeH); cdecl; external Qt4PasLib name 'QFileInfo_lastModified';
procedure QFileInfo_lastRead(handle: QFileInfoH; retval: QDateTimeH); cdecl; external Qt4PasLib name 'QFileInfo_lastRead';
procedure QFileInfo_detach(handle: QFileInfoH); cdecl; external Qt4PasLib name 'QFileInfo_detach';
function QFileInfo_caching(handle: QFileInfoH): Boolean; cdecl; external Qt4PasLib name 'QFileInfo_caching';
procedure QFileInfo_setCaching(handle: QFileInfoH; _on: Boolean); cdecl; external Qt4PasLib name 'QFileInfo_setCaching';

type
  QDirSortFlag = cardinal; // QDir::SortFlag
  QDirSortFlags = QDirSortFlag; //QFlags<> (3)
const
  QDirName =   $00;
  QDirTime =   $01;
  QDirSize =   $02;
  QDirUnsorted =   $03;
  QDirSortByMask =   $03;
  QDirDirsFirst =   $04;
  QDirReversed =   $08;
  QDirIgnoreCase =   $10;
  QDirDirsLast =   $20;
  QDirLocaleAware =   $40;
  QDirType =   $80;
  QDirNoSort =   -1;

type
  QDirFilter = cardinal; //  QDir::Filter (4)
  QDirFilters = QDirFilter; // QFlags<>

const
    QDirDirs = 1 { $1 };
    QDirFiles = 2 { $2 };
    QDirDrives = 4 { $4 };
    QDirNoSymLinks = 8 { $8 };
    QDirAllEntries = 7 { $7 };
    QDirTypeMask = 15 { $f };
    QDirReadable = 16 { $10 };
    QDirWritable = 32 { $20 };
    QDirExecutable = 64 { $40 };
    QDirPermissionMask = 112 { $70 };
    QDirModified = 128 { $80 };
    QDirHidden = 256 { $100 };
    QDirSystem = 512 { $200 };
    QDirAccessMask = 1008 { $3f0 };
    QDirAllDirs = 1024 { $400 };
    QDirCaseSensitive = 2048 { $800 };
    QDirNoDotAndDotDot = 4096 { $1000 };
    QDirNoFilter = 4294967295 { $ffffffff };


function QDir_create(p1: QDirH): QDirH; cdecl; external Qt4PasLib name 'QDir_create';
procedure QDir_destroy(handle: QDirH); cdecl; external Qt4PasLib name 'QDir_destroy'; 
function QDir_create(path: PWideString = nil): QDirH; cdecl; external Qt4PasLib name 'QDir_create2';
function QDir_create(path: PWideString; nameFilter: PWideString; sort: QDirSortFlags; filter: QDirFilters = QDirAllEntries): QDirH; cdecl; external Qt4PasLib name 'QDir_create3';
procedure QDir_setPath(handle: QDirH; path: PWideString); cdecl; external Qt4PasLib name 'QDir_setPath';
procedure QDir_path(handle: QDirH; retval: PWideString); cdecl; external Qt4PasLib name 'QDir_path';
procedure QDir_absolutePath(handle: QDirH; retval: PWideString); cdecl; external Qt4PasLib name 'QDir_absolutePath';
procedure QDir_canonicalPath(handle: QDirH; retval: PWideString); cdecl; external Qt4PasLib name 'QDir_canonicalPath';
procedure QDir_addResourceSearchPath(path: PWideString); cdecl; external Qt4PasLib name 'QDir_addResourceSearchPath';
procedure QDir_setSearchPaths(prefix: PWideString; searchPaths: QStringListH); cdecl; external Qt4PasLib name 'QDir_setSearchPaths';
procedure QDir_addSearchPath(prefix: PWideString; path: PWideString); cdecl; external Qt4PasLib name 'QDir_addSearchPath';
procedure QDir_searchPaths(retval: QStringListH; prefix: PWideString); cdecl; external Qt4PasLib name 'QDir_searchPaths';
procedure QDir_dirName(handle: QDirH; retval: PWideString); cdecl; external Qt4PasLib name 'QDir_dirName';
procedure QDir_filePath(handle: QDirH; retval: PWideString; fileName: PWideString); cdecl; external Qt4PasLib name 'QDir_filePath';
procedure QDir_absoluteFilePath(handle: QDirH; retval: PWideString; fileName: PWideString); cdecl; external Qt4PasLib name 'QDir_absoluteFilePath';
procedure QDir_relativeFilePath(handle: QDirH; retval: PWideString; fileName: PWideString); cdecl; external Qt4PasLib name 'QDir_relativeFilePath';
procedure QDir_toNativeSeparators(retval: PWideString; pathName: PWideString); cdecl; external Qt4PasLib name 'QDir_toNativeSeparators';
procedure QDir_fromNativeSeparators(retval: PWideString; pathName: PWideString); cdecl; external Qt4PasLib name 'QDir_fromNativeSeparators';
function QDir_cd(handle: QDirH; dirName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_cd';
function QDir_cdUp(handle: QDirH): Boolean; cdecl; external Qt4PasLib name 'QDir_cdUp';
procedure QDir_nameFilters(handle: QDirH; retval: QStringListH); cdecl; external Qt4PasLib name 'QDir_nameFilters';
procedure QDir_setNameFilters(handle: QDirH; nameFilters: QStringListH); cdecl; external Qt4PasLib name 'QDir_setNameFilters';
function QDir_filter(handle: QDirH): QDirFilters; cdecl; external Qt4PasLib name 'QDir_filter';
procedure QDir_setFilter(handle: QDirH; filter: QDirFilters); cdecl; external Qt4PasLib name 'QDir_setFilter';
function QDir_sorting(handle: QDirH): QDirSortFlags; cdecl; external Qt4PasLib name 'QDir_sorting';
procedure QDir_setSorting(handle: QDirH; sort: QDirSortFlags); cdecl; external Qt4PasLib name 'QDir_setSorting';
function QDir_count(handle: QDirH): LongWord; cdecl; external Qt4PasLib name 'QDir_count';
procedure QDir_nameFiltersFromString(retval: QStringListH; nameFilter: PWideString); cdecl; external Qt4PasLib name 'QDir_nameFiltersFromString';
procedure QDir_entryList(handle: QDirH; retval: QStringListH; filters: QDirFilters = QDirNoFilter; sort: QDirSortFlags = QDirNoSort); cdecl; external Qt4PasLib name 'QDir_entryList';
procedure QDir_entryList(handle: QDirH; retval: QStringListH; nameFilters: QStringListH; filters: QDirFilters = QDirNoFilter; sort: QDirSortFlags = QDirNoSort); cdecl; external Qt4PasLib name 'QDir_entryList2';
procedure QDir_entryInfoList(handle: QDirH; retval: PPtrIntArray; filters: QDirFilters = QDirNoFilter; sort: QDirSortFlags = QDirNoSort); cdecl; external Qt4PasLib name 'QDir_entryInfoList';
procedure QDir_entryInfoList(handle: QDirH; retval: PPtrIntArray; nameFilters: QStringListH; filters: QDirFilters = QDirNoFilter; sort: QDirSortFlags = QDirNoSort); cdecl; external Qt4PasLib name 'QDir_entryInfoList2';
function QDir_mkdir(handle: QDirH; dirName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_mkdir';
function QDir_rmdir(handle: QDirH; dirName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_rmdir';
function QDir_mkpath(handle: QDirH; dirPath: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_mkpath';
function QDir_rmpath(handle: QDirH; dirPath: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_rmpath';
function QDir_isReadable(handle: QDirH): Boolean; cdecl; external Qt4PasLib name 'QDir_isReadable';
function QDir_exists(handle: QDirH): Boolean; cdecl; external Qt4PasLib name 'QDir_exists';
function QDir_isRoot(handle: QDirH): Boolean; cdecl; external Qt4PasLib name 'QDir_isRoot';
function QDir_isRelativePath(path: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_isRelativePath';
function QDir_isAbsolutePath(path: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_isAbsolutePath';
function QDir_isRelative(handle: QDirH): Boolean; cdecl; external Qt4PasLib name 'QDir_isRelative';
function QDir_isAbsolute(handle: QDirH): Boolean; cdecl; external Qt4PasLib name 'QDir_isAbsolute';
function QDir_makeAbsolute(handle: QDirH): Boolean; cdecl; external Qt4PasLib name 'QDir_makeAbsolute';
function QDir_remove(handle: QDirH; fileName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_remove';
function QDir_rename(handle: QDirH; oldName: PWideString; newName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_rename';
function QDir_exists(handle: QDirH; name: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_exists2';
procedure QDir_drives(retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QDir_drives';
procedure QDir_separator(retval: PWideChar); cdecl; external Qt4PasLib name 'QDir_separator';
function QDir_setCurrent(path: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_setCurrent';
procedure QDir_current(retval: QDirH); cdecl; external Qt4PasLib name 'QDir_current';
procedure QDir_currentPath(retval: PWideString); cdecl; external Qt4PasLib name 'QDir_currentPath';
procedure QDir_home(retval: QDirH); cdecl; external Qt4PasLib name 'QDir_home';
procedure QDir_homePath(retval: PWideString); cdecl; external Qt4PasLib name 'QDir_homePath';
procedure QDir_root(retval: QDirH); cdecl; external Qt4PasLib name 'QDir_root';
procedure QDir_rootPath(retval: PWideString); cdecl; external Qt4PasLib name 'QDir_rootPath';
procedure QDir_temp(retval: QDirH); cdecl; external Qt4PasLib name 'QDir_temp';
procedure QDir_tempPath(retval: PWideString); cdecl; external Qt4PasLib name 'QDir_tempPath';
function QDir_match(filters: QStringListH; fileName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_match';
function QDir_match(filter: PWideString; fileName: PWideString): Boolean; cdecl; external Qt4PasLib name 'QDir_match2';
procedure QDir_cleanPath(retval: PWideString; path: PWideString); cdecl; external Qt4PasLib name 'QDir_cleanPath';
procedure QDir_refresh(handle: QDirH); cdecl; external Qt4PasLib name 'QDir_refresh';


type
  QUrlParsingMode = ( // QUrl::ParsingMode (1)
    QUrlTolerantMode, QUrlStrictMode );

type
  QUrlFormattingOption = cardinal; //  QUrl::FormattingOption (4)
  QUrlFormattingOptions = QUrlFormattingOption; // QFlags<>

const
    QUrlNone = 0 { $0 };
    QUrlRemoveScheme = 1 { $1 };
    QUrlRemovePassword = 2 { $2 };
    QUrlRemoveUserInfo = 6 { $6 };
    QUrlRemovePort = 8 { $8 };
    QUrlRemoveAuthority = 30 { $1e };
    QUrlRemovePath = 32 { $20 };
    QUrlRemoveQuery = 64 { $40 };
    QUrlRemoveFragment = 128 { $80 };
    QUrlStripTrailingSlash = 65536 { $10000 };


function QUrl_create(): QUrlH; cdecl; external Qt4PasLib name 'QUrl_create';
procedure QUrl_destroy(handle: QUrlH); cdecl; external Qt4PasLib name 'QUrl_destroy'; 
function QUrl_create(url: PWideString): QUrlH; cdecl; external Qt4PasLib name 'QUrl_create2';
function QUrl_create(url: PWideString; mode: QUrlParsingMode): QUrlH; cdecl; external Qt4PasLib name 'QUrl_create3';
function QUrl_create(copy: QUrlH): QUrlH; cdecl; external Qt4PasLib name 'QUrl_create4';
procedure QUrl_setUrl(handle: QUrlH; url: PWideString); cdecl; external Qt4PasLib name 'QUrl_setUrl';
procedure QUrl_setUrl(handle: QUrlH; url: PWideString; mode: QUrlParsingMode); cdecl; external Qt4PasLib name 'QUrl_setUrl2';
procedure QUrl_setEncodedUrl(handle: QUrlH; url: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_setEncodedUrl';
procedure QUrl_setEncodedUrl(handle: QUrlH; url: QByteArrayH; mode: QUrlParsingMode); cdecl; external Qt4PasLib name 'QUrl_setEncodedUrl2';
function QUrl_isValid(handle: QUrlH): Boolean; cdecl; external Qt4PasLib name 'QUrl_isValid';
function QUrl_isEmpty(handle: QUrlH): Boolean; cdecl; external Qt4PasLib name 'QUrl_isEmpty';
procedure QUrl_clear(handle: QUrlH); cdecl; external Qt4PasLib name 'QUrl_clear';
procedure QUrl_setScheme(handle: QUrlH; scheme: PWideString); cdecl; external Qt4PasLib name 'QUrl_setScheme';
procedure QUrl_scheme(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_scheme';
procedure QUrl_setAuthority(handle: QUrlH; authority: PWideString); cdecl; external Qt4PasLib name 'QUrl_setAuthority';
procedure QUrl_authority(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_authority';
procedure QUrl_setUserInfo(handle: QUrlH; userInfo: PWideString); cdecl; external Qt4PasLib name 'QUrl_setUserInfo';
procedure QUrl_userInfo(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_userInfo';
procedure QUrl_setUserName(handle: QUrlH; userName: PWideString); cdecl; external Qt4PasLib name 'QUrl_setUserName';
procedure QUrl_userName(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_userName';
procedure QUrl_setEncodedUserName(handle: QUrlH; userName: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_setEncodedUserName';
procedure QUrl_encodedUserName(handle: QUrlH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_encodedUserName';
procedure QUrl_setPassword(handle: QUrlH; password: PWideString); cdecl; external Qt4PasLib name 'QUrl_setPassword';
procedure QUrl_password(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_password';
procedure QUrl_setEncodedPassword(handle: QUrlH; password: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_setEncodedPassword';
procedure QUrl_encodedPassword(handle: QUrlH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_encodedPassword';
procedure QUrl_setHost(handle: QUrlH; host: PWideString); cdecl; external Qt4PasLib name 'QUrl_setHost';
procedure QUrl_host(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_host';
procedure QUrl_setEncodedHost(handle: QUrlH; host: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_setEncodedHost';
procedure QUrl_encodedHost(handle: QUrlH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_encodedHost';
procedure QUrl_setPort(handle: QUrlH; port: Integer); cdecl; external Qt4PasLib name 'QUrl_setPort';
function QUrl_port(handle: QUrlH): Integer; cdecl; external Qt4PasLib name 'QUrl_port';
function QUrl_port(handle: QUrlH; defaultPort: Integer): Integer; cdecl; external Qt4PasLib name 'QUrl_port2';
procedure QUrl_setPath(handle: QUrlH; path: PWideString); cdecl; external Qt4PasLib name 'QUrl_setPath';
procedure QUrl_path(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_path';
procedure QUrl_setEncodedPath(handle: QUrlH; path: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_setEncodedPath';
procedure QUrl_encodedPath(handle: QUrlH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_encodedPath';
function QUrl_hasQuery(handle: QUrlH): Boolean; cdecl; external Qt4PasLib name 'QUrl_hasQuery';
procedure QUrl_setEncodedQuery(handle: QUrlH; query: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_setEncodedQuery';
procedure QUrl_encodedQuery(handle: QUrlH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_encodedQuery';
procedure QUrl_setQueryDelimiters(handle: QUrlH; valueDelimiter: char; pairDelimiter: char); cdecl; external Qt4PasLib name 'QUrl_setQueryDelimiters';
function QUrl_queryValueDelimiter(handle: QUrlH): char; cdecl; external Qt4PasLib name 'QUrl_queryValueDelimiter';
function QUrl_queryPairDelimiter(handle: QUrlH): char; cdecl; external Qt4PasLib name 'QUrl_queryPairDelimiter';
procedure QUrl_addQueryItem(handle: QUrlH; key: PWideString; value: PWideString); cdecl; external Qt4PasLib name 'QUrl_addQueryItem';
function QUrl_hasQueryItem(handle: QUrlH; key: PWideString): Boolean; cdecl; external Qt4PasLib name 'QUrl_hasQueryItem';
procedure QUrl_queryItemValue(handle: QUrlH; retval: PWideString; key: PWideString); cdecl; external Qt4PasLib name 'QUrl_queryItemValue';
procedure QUrl_allQueryItemValues(handle: QUrlH; retval: QStringListH; key: PWideString); cdecl; external Qt4PasLib name 'QUrl_allQueryItemValues';
procedure QUrl_removeQueryItem(handle: QUrlH; key: PWideString); cdecl; external Qt4PasLib name 'QUrl_removeQueryItem';
procedure QUrl_removeAllQueryItems(handle: QUrlH; key: PWideString); cdecl; external Qt4PasLib name 'QUrl_removeAllQueryItems';
procedure QUrl_addEncodedQueryItem(handle: QUrlH; key: QByteArrayH; value: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_addEncodedQueryItem';
function QUrl_hasEncodedQueryItem(handle: QUrlH; key: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QUrl_hasEncodedQueryItem';
procedure QUrl_encodedQueryItemValue(handle: QUrlH; retval: QByteArrayH; key: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_encodedQueryItemValue';
procedure QUrl_removeEncodedQueryItem(handle: QUrlH; key: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_removeEncodedQueryItem';
procedure QUrl_removeAllEncodedQueryItems(handle: QUrlH; key: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_removeAllEncodedQueryItems';
procedure QUrl_setFragment(handle: QUrlH; fragment: PWideString); cdecl; external Qt4PasLib name 'QUrl_setFragment';
procedure QUrl_fragment(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_fragment';
procedure QUrl_setEncodedFragment(handle: QUrlH; fragment: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_setEncodedFragment';
procedure QUrl_encodedFragment(handle: QUrlH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_encodedFragment';
function QUrl_hasFragment(handle: QUrlH): Boolean; cdecl; external Qt4PasLib name 'QUrl_hasFragment';
procedure QUrl_resolved(handle: QUrlH; retval: QUrlH; relative: QUrlH); cdecl; external Qt4PasLib name 'QUrl_resolved';
function QUrl_isRelative(handle: QUrlH): Boolean; cdecl; external Qt4PasLib name 'QUrl_isRelative';
function QUrl_isParentOf(handle: QUrlH; url: QUrlH): Boolean; cdecl; external Qt4PasLib name 'QUrl_isParentOf';
procedure QUrl_fromLocalFile(retval: QUrlH; localfile: PWideString); cdecl; external Qt4PasLib name 'QUrl_fromLocalFile';
procedure QUrl_toLocalFile(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_toLocalFile';
procedure QUrl_toString(handle: QUrlH; retval: PWideString; options: QUrlFormattingOptions = QUrlNone); cdecl; external Qt4PasLib name 'QUrl_toString';
procedure QUrl_toEncoded(handle: QUrlH; retval: QByteArrayH; options: QUrlFormattingOptions = QUrlNone); cdecl; external Qt4PasLib name 'QUrl_toEncoded';
procedure QUrl_fromEncoded(retval: QUrlH; url: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_fromEncoded';
procedure QUrl_fromEncoded(retval: QUrlH; url: QByteArrayH; mode: QUrlParsingMode); cdecl; external Qt4PasLib name 'QUrl_fromEncoded2';
procedure QUrl_detach(handle: QUrlH); cdecl; external Qt4PasLib name 'QUrl_detach';
function QUrl_isDetached(handle: QUrlH): Boolean; cdecl; external Qt4PasLib name 'QUrl_isDetached';
procedure QUrl_fromPercentEncoding(retval: PWideString; p1: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_fromPercentEncoding';
procedure QUrl_toPercentEncoding(retval: QByteArrayH; p1: PWideString; exclude: QByteArrayH = nil; include: QByteArrayH = nil); cdecl; external Qt4PasLib name 'QUrl_toPercentEncoding';
procedure QUrl_fromPunycode(retval: PWideString; p1: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_fromPunycode';
procedure QUrl_toPunycode(retval: QByteArrayH; p1: PWideString); cdecl; external Qt4PasLib name 'QUrl_toPunycode';
procedure QUrl_fromAce(retval: PWideString; p1: QByteArrayH); cdecl; external Qt4PasLib name 'QUrl_fromAce';
procedure QUrl_toAce(retval: QByteArrayH; p1: PWideString); cdecl; external Qt4PasLib name 'QUrl_toAce';
procedure QUrl_idnWhitelist(retval: QStringListH); cdecl; external Qt4PasLib name 'QUrl_idnWhitelist';
procedure QUrl_setIdnWhitelist(p1: QStringListH); cdecl; external Qt4PasLib name 'QUrl_setIdnWhitelist';
procedure QUrl_errorString(handle: QUrlH; retval: PWideString); cdecl; external Qt4PasLib name 'QUrl_errorString';

function QFileSystemWatcher_create(parent: QObjectH = nil): QFileSystemWatcherH; cdecl; external Qt4PasLib name 'QFileSystemWatcher_create';
procedure QFileSystemWatcher_destroy(handle: QFileSystemWatcherH); cdecl; external Qt4PasLib name 'QFileSystemWatcher_destroy'; 
function QFileSystemWatcher_create(paths: QStringListH; parent: QObjectH = nil): QFileSystemWatcherH; cdecl; external Qt4PasLib name 'QFileSystemWatcher_create2';
procedure QFileSystemWatcher_addPath(handle: QFileSystemWatcherH; _file: PWideString); cdecl; external Qt4PasLib name 'QFileSystemWatcher_addPath';
procedure QFileSystemWatcher_addPaths(handle: QFileSystemWatcherH; files: QStringListH); cdecl; external Qt4PasLib name 'QFileSystemWatcher_addPaths';
procedure QFileSystemWatcher_removePath(handle: QFileSystemWatcherH; _file: PWideString); cdecl; external Qt4PasLib name 'QFileSystemWatcher_removePath';
procedure QFileSystemWatcher_removePaths(handle: QFileSystemWatcherH; files: QStringListH); cdecl; external Qt4PasLib name 'QFileSystemWatcher_removePaths';
procedure QFileSystemWatcher_files(handle: QFileSystemWatcherH; retval: QStringListH); cdecl; external Qt4PasLib name 'QFileSystemWatcher_files';
procedure QFileSystemWatcher_directories(handle: QFileSystemWatcherH; retval: QStringListH); cdecl; external Qt4PasLib name 'QFileSystemWatcher_directories';


type
  QFileSystemWatcher_fileChanged_Event = procedure (path: PWideString) of object cdecl;
  QFileSystemWatcher_directoryChanged_Event = procedure (path: PWideString) of object cdecl;



type
  QApplicationType = ( // QApplication::Type (1)
    QApplicationTty, QApplicationGuiClient, QApplicationGuiServer );

  QApplicationColorSpec = (  //QApplication::ColorSpec (2)
    QApplicationNormalColor = 0,
    QApplicationCustomColor = 1,
    QApplicationManyColor = 2 );

function QApplication_create(argc: PInteger; argv: PPAnsiChar; p3: Integer = QT_VERSION): QApplicationH; cdecl; external Qt4PasLib name 'QApplication_create';
procedure QApplication_destroy(handle: QApplicationH); cdecl; external Qt4PasLib name 'QApplication_destroy'; 
function QApplication_create(argc: PInteger; argv: PPAnsiChar; GUIenabled: Boolean; p4: Integer = QT_VERSION): QApplicationH; cdecl; external Qt4PasLib name 'QApplication_create2';
function QApplication_create(argc: PInteger; argv: PPAnsiChar; p3: QApplicationType; p4: Integer = QT_VERSION): QApplicationH; cdecl; external Qt4PasLib name 'QApplication_create3';
{$ifdef BINUX }
function QApplication_create(dpy: PDisplay; visual: QtHANDLE = 0; cmap: QtHANDLE = 0; p4: Integer = QT_VERSION): QApplicationH; cdecl; external Qt4PasLib name 'QApplication_create4';
function QApplication_create(dpy: PDisplay; argc: PInteger; argv: PPAnsiChar; visual: QtHANDLE = 0; cmap: QtHANDLE = 0; p6: Integer = QT_VERSION): QApplicationH; cdecl; external Qt4PasLib name 'QApplication_create5';
{$endif}
function QApplication_type(): QApplicationType; cdecl; external Qt4PasLib name 'QApplication_type';
function QApplication_style(): QStyleH; cdecl; external Qt4PasLib name 'QApplication_style';
procedure QApplication_setStyle(p1: QStyleH); cdecl; external Qt4PasLib name 'QApplication_setStyle';
function QApplication_setStyle(p1: PWideString): QStyleH; cdecl; external Qt4PasLib name 'QApplication_setStyle2';
function QApplication_colorSpec(): Integer; cdecl; external Qt4PasLib name 'QApplication_colorSpec';
procedure QApplication_setColorSpec(p1: Integer); cdecl; external Qt4PasLib name 'QApplication_setColorSpec';
procedure QApplication_setGraphicsSystem(p1: PWideString); cdecl; external Qt4PasLib name 'QApplication_setGraphicsSystem';
function QApplication_overrideCursor(): QCursorH; cdecl; external Qt4PasLib name 'QApplication_overrideCursor';
procedure QApplication_setOverrideCursor(p1: QCursorH); cdecl; external Qt4PasLib name 'QApplication_setOverrideCursor';
procedure QApplication_changeOverrideCursor(p1: QCursorH); cdecl; external Qt4PasLib name 'QApplication_changeOverrideCursor';
procedure QApplication_restoreOverrideCursor(); cdecl; external Qt4PasLib name 'QApplication_restoreOverrideCursor';
procedure QApplication_palette(retval: QPaletteH); cdecl; external Qt4PasLib name 'QApplication_palette';
procedure QApplication_palette(retval: QPaletteH; p1: QWidgetH); cdecl; external Qt4PasLib name 'QApplication_palette2';
procedure QApplication_palette(retval: QPaletteH; className: PAnsiChar); cdecl; external Qt4PasLib name 'QApplication_palette3';
procedure QApplication_setPalette(p1: QPaletteH; className: PAnsiChar = nil); cdecl; external Qt4PasLib name 'QApplication_setPalette';
procedure QApplication_font(retval: QFontH); cdecl; external Qt4PasLib name 'QApplication_font';
procedure QApplication_font(retval: QFontH; p1: QWidgetH); cdecl; external Qt4PasLib name 'QApplication_font2';
procedure QApplication_font(retval: QFontH; className: PAnsiChar); cdecl; external Qt4PasLib name 'QApplication_font3';
procedure QApplication_setFont(p1: QFontH; className: PAnsiChar = nil); cdecl; external Qt4PasLib name 'QApplication_setFont';
procedure QApplication_fontMetrics(retval: QFontMetricsH); cdecl; external Qt4PasLib name 'QApplication_fontMetrics';
procedure QApplication_setWindowIcon(icon: QIconH); cdecl; external Qt4PasLib name 'QApplication_setWindowIcon';
procedure QApplication_windowIcon(retval: QIconH); cdecl; external Qt4PasLib name 'QApplication_windowIcon';
function QApplication_desktop(): QDesktopWidgetH; cdecl; external Qt4PasLib name 'QApplication_desktop';
function QApplication_activePopupWidget(): QWidgetH; cdecl; external Qt4PasLib name 'QApplication_activePopupWidget';
function QApplication_activeModalWidget(): QWidgetH; cdecl; external Qt4PasLib name 'QApplication_activeModalWidget';
function QApplication_clipboard(): QClipboardH; cdecl; external Qt4PasLib name 'QApplication_clipboard';
function QApplication_focusWidget(): QWidgetH; cdecl; external Qt4PasLib name 'QApplication_focusWidget';
function QApplication_activeWindow(): QWidgetH; cdecl; external Qt4PasLib name 'QApplication_activeWindow';
procedure QApplication_setActiveWindow(act: QWidgetH); cdecl; external Qt4PasLib name 'QApplication_setActiveWindow';
function QApplication_widgetAt(p: PQtPoint): QWidgetH; cdecl; external Qt4PasLib name 'QApplication_widgetAt';
function QApplication_widgetAt(x: Integer; y: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QApplication_widgetAt2';
function QApplication_topLevelAt(p: PQtPoint): QWidgetH; cdecl; external Qt4PasLib name 'QApplication_topLevelAt';
function QApplication_topLevelAt(x: Integer; y: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QApplication_topLevelAt2';
procedure QApplication_syncX(); cdecl; external Qt4PasLib name 'QApplication_syncX';
procedure QApplication_beep(); cdecl; external Qt4PasLib name 'QApplication_beep';
procedure QApplication_alert(widget: QWidgetH; duration: Integer = 0); cdecl; external Qt4PasLib name 'QApplication_alert';
function QApplication_keyboardModifiers(): QtKeyboardModifiers; cdecl; external Qt4PasLib name 'QApplication_keyboardModifiers';
function QApplication_mouseButtons(): QtMouseButtons; cdecl; external Qt4PasLib name 'QApplication_mouseButtons';
procedure QApplication_setDesktopSettingsAware(p1: Boolean); cdecl; external Qt4PasLib name 'QApplication_setDesktopSettingsAware';
function QApplication_desktopSettingsAware(): Boolean; cdecl; external Qt4PasLib name 'QApplication_desktopSettingsAware';
procedure QApplication_setCursorFlashTime(p1: Integer); cdecl; external Qt4PasLib name 'QApplication_setCursorFlashTime';
function QApplication_cursorFlashTime(): Integer; cdecl; external Qt4PasLib name 'QApplication_cursorFlashTime';
procedure QApplication_setDoubleClickInterval(p1: Integer); cdecl; external Qt4PasLib name 'QApplication_setDoubleClickInterval';
function QApplication_doubleClickInterval(): Integer; cdecl; external Qt4PasLib name 'QApplication_doubleClickInterval';
procedure QApplication_setKeyboardInputInterval(p1: Integer); cdecl; external Qt4PasLib name 'QApplication_setKeyboardInputInterval';
function QApplication_keyboardInputInterval(): Integer; cdecl; external Qt4PasLib name 'QApplication_keyboardInputInterval';
procedure QApplication_setWheelScrollLines(p1: Integer); cdecl; external Qt4PasLib name 'QApplication_setWheelScrollLines';
function QApplication_wheelScrollLines(): Integer; cdecl; external Qt4PasLib name 'QApplication_wheelScrollLines';
procedure QApplication_setGlobalStrut(p1: PSize); cdecl; external Qt4PasLib name 'QApplication_setGlobalStrut';
procedure QApplication_globalStrut(retval: PSize); cdecl; external Qt4PasLib name 'QApplication_globalStrut';
procedure QApplication_setStartDragTime(ms: Integer); cdecl; external Qt4PasLib name 'QApplication_setStartDragTime';
function QApplication_startDragTime(): Integer; cdecl; external Qt4PasLib name 'QApplication_startDragTime';
procedure QApplication_setStartDragDistance(l: Integer); cdecl; external Qt4PasLib name 'QApplication_setStartDragDistance';
function QApplication_startDragDistance(): Integer; cdecl; external Qt4PasLib name 'QApplication_startDragDistance';
procedure QApplication_setLayoutDirection(direction: QtLayoutDirection); cdecl; external Qt4PasLib name 'QApplication_setLayoutDirection';
function QApplication_layoutDirection(): QtLayoutDirection; cdecl; external Qt4PasLib name 'QApplication_layoutDirection';
function QApplication_isRightToLeft(): Boolean; cdecl; external Qt4PasLib name 'QApplication_isRightToLeft';
function QApplication_isLeftToRight(): Boolean; cdecl; external Qt4PasLib name 'QApplication_isLeftToRight';
function QApplication_isEffectEnabled(p1: QtUIEffect): Boolean; cdecl; external Qt4PasLib name 'QApplication_isEffectEnabled';
procedure QApplication_setEffectEnabled(p1: QtUIEffect; enable: Boolean = True); cdecl; external Qt4PasLib name 'QApplication_setEffectEnabled';
{$ifdef BINUX }
function QApplication_x11EventFilter(handle: QApplicationH; p1: PEvent): Boolean; cdecl; external Qt4PasLib name 'QApplication_x11EventFilter';
function QApplication_x11ClientMessage(handle: QApplicationH; p1: QWidgetH; p2: PEvent; passive_only: Boolean): Integer; cdecl; external Qt4PasLib name 'QApplication_x11ClientMessage';
function QApplication_x11ProcessEvent(handle: QApplicationH; p1: PEvent): Integer; cdecl; external Qt4PasLib name 'QApplication_x11ProcessEvent';
{$endif}
{$ifdef BINUX or MSWINDOWS or DARWIN }
function QApplication_isSessionRestored(handle: QApplicationH): Boolean; cdecl; external Qt4PasLib name 'QApplication_isSessionRestored';
procedure QApplication_sessionId(handle: QApplicationH; retval: PWideString); cdecl; external Qt4PasLib name 'QApplication_sessionId';
procedure QApplication_sessionKey(handle: QApplicationH; retval: PWideString); cdecl; external Qt4PasLib name 'QApplication_sessionKey';
procedure QApplication_commitData(handle: QApplicationH; sm: QSessionManagerH); cdecl; external Qt4PasLib name 'QApplication_commitData';
procedure QApplication_saveState(handle: QApplicationH; sm: QSessionManagerH); cdecl; external Qt4PasLib name 'QApplication_saveState';
{$endif}
procedure QApplication_setInputContext(handle: QApplicationH; p1: QInputContextH); cdecl; external Qt4PasLib name 'QApplication_setInputContext';
function QApplication_inputContext(handle: QApplicationH): QInputContextH; cdecl; external Qt4PasLib name 'QApplication_inputContext';
procedure QApplication_keyboardInputLocale(retval: QLocaleH); cdecl; external Qt4PasLib name 'QApplication_keyboardInputLocale';
function QApplication_keyboardInputDirection(): QtLayoutDirection; cdecl; external Qt4PasLib name 'QApplication_keyboardInputDirection';
function QApplication_exec(): Integer; cdecl; external Qt4PasLib name 'QApplication_exec';
function QApplication_notify(handle: QApplicationH; p1: QObjectH; p2: QEventH): Boolean; cdecl; external Qt4PasLib name 'QApplication_notify';
procedure QApplication_setQuitOnLastWindowClosed(quit: Boolean); cdecl; external Qt4PasLib name 'QApplication_setQuitOnLastWindowClosed';
function QApplication_quitOnLastWindowClosed(): Boolean; cdecl; external Qt4PasLib name 'QApplication_quitOnLastWindowClosed';
procedure QApplication_styleSheet(handle: QApplicationH; retval: PWideString); cdecl; external Qt4PasLib name 'QApplication_styleSheet';
procedure QApplication_setStyleSheet(handle: QApplicationH; sheet: PWideString); cdecl; external Qt4PasLib name 'QApplication_setStyleSheet';
procedure QApplication_closeAllWindows(); cdecl; external Qt4PasLib name 'QApplication_closeAllWindows';
procedure QApplication_aboutQt(); cdecl; external Qt4PasLib name 'QApplication_aboutQt';
{$ifdef MSWINDOWS }
procedure QApplication_winFocus(handle: QApplicationH; p1: QWidgetH; p2: Boolean); cdecl; external Qt4PasLib name 'QApplication_winFocus';
procedure QApplication_winMouseButtonUp(); cdecl; external Qt4PasLib name 'QApplication_winMouseButtonUp';
{$endif}
{$ifdef DARWIN }
function QApplication_macEventFilter(handle: QApplicationH; p1: EventHandlerCallRef; p2: EventRef): Boolean; cdecl; external Qt4PasLib name 'QApplication_macEventFilter';
{$endif}
{$ifdef QTOPIA }
function QApplication_qwsEventFilter(handle: QApplicationH; p1: QWSEventH): Boolean; cdecl; external Qt4PasLib name 'QApplication_qwsEventFilter';
function QApplication_qwsProcessEvent(handle: QApplicationH; p1: QWSEventH): Integer; cdecl; external Qt4PasLib name 'QApplication_qwsProcessEvent';
procedure QApplication_qwsSetCustomColors(handle: QApplicationH; colortable: PQRgb; start: Integer; numColors: Integer); cdecl; external Qt4PasLib name 'QApplication_qwsSetCustomColors';
function QApplication_qwsDecoration(): QDecorationH; cdecl; external Qt4PasLib name 'QApplication_qwsDecoration';
procedure QApplication_qwsSetDecoration(p1: QDecorationH); cdecl; external Qt4PasLib name 'QApplication_qwsSetDecoration';
function QApplication_qwsSetDecoration(decoration: PWideString): QDecorationH; cdecl; external Qt4PasLib name 'QApplication_qwsSetDecoration2';
{$endif}


type
  QApplication_lastWindowClosed_Event = procedure () of object cdecl;
  QApplication_focusChanged_Event = procedure (old: QWidgetH; now: QWidgetH) of object cdecl;
  QApplication_fontDatabaseChanged_Event = procedure () of object cdecl;
{$ifdef BINUX or MSWINDOWS or DARWIN }
  QApplication_commitDataRequest_Event = procedure (sessionManager: QSessionManagerH) of object cdecl;
  QApplication_saveStateRequest_Event = procedure (sessionManager: QSessionManagerH) of object cdecl;
{$endif}


procedure QWhatsThis_enterWhatsThisMode(); cdecl; external Qt4PasLib name 'QWhatsThis_enterWhatsThisMode';
function QWhatsThis_inWhatsThisMode(): Boolean; cdecl; external Qt4PasLib name 'QWhatsThis_inWhatsThisMode';
procedure QWhatsThis_leaveWhatsThisMode(); cdecl; external Qt4PasLib name 'QWhatsThis_leaveWhatsThisMode';
procedure QWhatsThis_showText(pos: PQtPoint; text: PWideString; w: QWidgetH = nil); cdecl; external Qt4PasLib name 'QWhatsThis_showText';
procedure QWhatsThis_hideText(); cdecl; external Qt4PasLib name 'QWhatsThis_hideText';
function QWhatsThis_createAction(parent: QObjectH = nil): QActionH; cdecl; external Qt4PasLib name 'QWhatsThis_createAction';

type
  QPaletteColorGroup = cardinal; //  QPalette::ColorGroup (4)

const
    QPaletteActive = 0 { $0 };
    QPaletteDisabled = 1 { $1 };
    QPaletteInactive = 2 { $2 };
    QPaletteNColorGroups = 3 { $3 };
    QPaletteCurrent = 4 { $4 };
    QPaletteAll = 5 { $5 };
    QPaletteNormal = 0 { $0 };

type
  QPaletteColorRole = cardinal; //  QPalette::ColorRole (4)

const
    QPaletteWindowText = 0 { $0 };
    QPaletteButton = 1 { $1 };
    QPaletteLight = 2 { $2 };
    QPaletteMidlight = 3 { $3 };
    QPaletteDark = 4 { $4 };
    QPaletteMid = 5 { $5 };
    QPaletteText = 6 { $6 };
    QPaletteBrightText = 7 { $7 };
    QPaletteButtonText = 8 { $8 };
    QPaletteBase = 9 { $9 };
    QPaletteWindow = 10 { $a };
    QPaletteShadow = 11 { $b };
    QPaletteHighlight = 12 { $c };
    QPaletteHighlightedText = 13 { $d };
    QPaletteLink = 14 { $e };
    QPaletteLinkVisited = 15 { $f };
    QPaletteAlternateBase = 16 { $10 };
    QPaletteNoRole = 17 { $11 };
    QPaletteToolTipBase = 18 { $12 };
    QPaletteToolTipText = 19 { $13 };
    QPaletteNColorRoles = 20 { $14 };
    QPaletteForeground = 0 { $0 };
    QPaletteBackground = 10 { $a };


function QPalette_create(): QPaletteH; cdecl; external Qt4PasLib name 'QPalette_create';
procedure QPalette_destroy(handle: QPaletteH); cdecl; external Qt4PasLib name 'QPalette_destroy'; 
function QPalette_create(button: PQColor): QPaletteH; cdecl; external Qt4PasLib name 'QPalette_create2';
function QPalette_create(button: QtGlobalColor): QPaletteH; cdecl; external Qt4PasLib name 'QPalette_create3';
function QPalette_create(button: PQColor; window: PQColor): QPaletteH; cdecl; external Qt4PasLib name 'QPalette_create4';
function QPalette_create(windowText: QBrushH; button: QBrushH; light: QBrushH; dark: QBrushH; mid: QBrushH; text: QBrushH; bright_text: QBrushH; base: QBrushH; window: QBrushH): QPaletteH; cdecl; external Qt4PasLib name 'QPalette_create5';
function QPalette_create(windowText: PQColor; window: PQColor; light: PQColor; dark: PQColor; mid: PQColor; text: PQColor; base: PQColor): QPaletteH; cdecl; external Qt4PasLib name 'QPalette_create6';
function QPalette_create(palette: QPaletteH): QPaletteH; cdecl; external Qt4PasLib name 'QPalette_create7';
function QPalette_currentColorGroup(handle: QPaletteH): QPaletteColorGroup; cdecl; external Qt4PasLib name 'QPalette_currentColorGroup';
procedure QPalette_setCurrentColorGroup(handle: QPaletteH; cg: QPaletteColorGroup); cdecl; external Qt4PasLib name 'QPalette_setCurrentColorGroup';
function QPalette_color(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole): PQColor; cdecl; external Qt4PasLib name 'QPalette_color';
function QPalette_brush(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole): QBrushH; cdecl; external Qt4PasLib name 'QPalette_brush';
procedure QPalette_setColor(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole; color: PQColor); cdecl; external Qt4PasLib name 'QPalette_setColor';
procedure QPalette_setColor(handle: QPaletteH; cr: QPaletteColorRole; color: PQColor); cdecl; external Qt4PasLib name 'QPalette_setColor2';
procedure QPalette_setBrush(handle: QPaletteH; cr: QPaletteColorRole; brush: QBrushH); cdecl; external Qt4PasLib name 'QPalette_setBrush';
function QPalette_isBrushSet(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole): Boolean; cdecl; external Qt4PasLib name 'QPalette_isBrushSet';
procedure QPalette_setBrush(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole; brush: QBrushH); cdecl; external Qt4PasLib name 'QPalette_setBrush2';
procedure QPalette_setColorGroup(handle: QPaletteH; cr: QPaletteColorGroup; windowText: QBrushH; button: QBrushH; light: QBrushH; dark: QBrushH; mid: QBrushH; text: QBrushH; bright_text: QBrushH; base: QBrushH; window: QBrushH); cdecl; external Qt4PasLib name 'QPalette_setColorGroup';
function QPalette_isEqual(handle: QPaletteH; cr1: QPaletteColorGroup; cr2: QPaletteColorGroup): Boolean; cdecl; external Qt4PasLib name 'QPalette_isEqual';
function QPalette_color(handle: QPaletteH; cr: QPaletteColorRole): PQColor; cdecl; external Qt4PasLib name 'QPalette_color2';
function QPalette_brush(handle: QPaletteH; cr: QPaletteColorRole): QBrushH; cdecl; external Qt4PasLib name 'QPalette_brush2';
function QPalette_foreground(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_foreground';
function QPalette_windowText(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_windowText';
function QPalette_button(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_button';
function QPalette_light(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_light';
function QPalette_dark(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_dark';
function QPalette_mid(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_mid';
function QPalette_text(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_text';
function QPalette_base(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_base';
function QPalette_alternateBase(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_alternateBase';
function QPalette_toolTipBase(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_toolTipBase';
function QPalette_toolTipText(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_toolTipText';
function QPalette_background(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_background';
function QPalette_window(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_window';
function QPalette_midlight(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_midlight';
function QPalette_brightText(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_brightText';
function QPalette_buttonText(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_buttonText';
function QPalette_shadow(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_shadow';
function QPalette_highlight(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_highlight';
function QPalette_highlightedText(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_highlightedText';
function QPalette_link(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_link';
function QPalette_linkVisited(handle: QPaletteH): QBrushH; cdecl; external Qt4PasLib name 'QPalette_linkVisited';
function QPalette_isCopyOf(handle: QPaletteH; p: QPaletteH): Boolean; cdecl; external Qt4PasLib name 'QPalette_isCopyOf';
function QPalette_serialNumber(handle: QPaletteH): Integer; cdecl; external Qt4PasLib name 'QPalette_serialNumber';
function QPalette_cacheKey(handle: QPaletteH): int64; cdecl; external Qt4PasLib name 'QPalette_cacheKey';
procedure QPalette_resolve(handle: QPaletteH; retval: QPaletteH; p1: QPaletteH); cdecl; external Qt4PasLib name 'QPalette_resolve';
function QPalette_resolve(handle: QPaletteH): LongWord; cdecl; external Qt4PasLib name 'QPalette_resolve2';
procedure QPalette_resolve(handle: QPaletteH; mask: LongWord); cdecl; external Qt4PasLib name 'QPalette_resolve3';


type
  QSizePolicyPolicyFlag = (  //QSizePolicy::PolicyFlag (2)
    QSizePolicyGrowFlag = 1,
    QSizePolicyExpandFlag = 2,
    QSizePolicyShrinkFlag = 4,
    QSizePolicyIgnoreFlag = 8 );

type
  QSizePolicyControlType = cardinal; // QSizePolicy::ControlType
  QSizePolicyControlTypes = QSizePolicyControlType; //QFlags<> (3)
const
  QSizePolicyDefaultType =   $00000001;
  QSizePolicyButtonBox =   $00000002;
  QSizePolicyCheckBox =   $00000004;
  QSizePolicyComboBox =   $00000008;
  QSizePolicyFrame =   $00000010;
  QSizePolicyGroupBox =   $00000020;
  QSizePolicyLabel =   $00000040;
  QSizePolicyLine =   $00000080;
  QSizePolicyLineEdit =   $00000100;
  QSizePolicyPushButton =   $00000200;
  QSizePolicyRadioButton =   $00000400;
  QSizePolicySlider =   $00000800;
  QSizePolicySpinBox =   $00001000;
  QSizePolicyTabWidget =   $00002000;
  QSizePolicyToolButton =   $00004000;

type
  QSizePolicyPolicy = cardinal; //  QSizePolicy::Policy (4)

const
    QSizePolicyFixed = 0 { $0 };
    QSizePolicyMinimum = 1 { $1 };
    QSizePolicyMaximum = 4 { $4 };
    QSizePolicyPreferred = 5 { $5 };
    QSizePolicyMinimumExpanding = 3 { $3 };
    QSizePolicyExpanding = 7 { $7 };
    QSizePolicyIgnored = 13 { $d };



type
  QKeySequenceStandardKey = ( // QKeySequence::StandardKey (1)
    QKeySequenceUnknownKey, QKeySequenceHelpContents, QKeySequenceWhatsThis, QKeySequenceOpen, QKeySequenceClose, QKeySequenceSave, QKeySequenceNew, QKeySequenceDelete, QKeySequenceCut, 
    QKeySequenceCopy, QKeySequencePaste, QKeySequenceUndo, QKeySequenceRedo, QKeySequenceBack, QKeySequenceForward, QKeySequenceRefresh, QKeySequenceZoomIn, QKeySequenceZoomOut, QKeySequencePrint, 
    QKeySequenceAddTab, QKeySequenceNextChild, QKeySequencePreviousChild, QKeySequenceFind, QKeySequenceFindNext, QKeySequenceFindPrevious, QKeySequenceReplace, QKeySequenceSelectAll, QKeySequenceBold, 
    QKeySequenceItalic, QKeySequenceUnderline, QKeySequenceMoveToNextChar, QKeySequenceMoveToPreviousChar, QKeySequenceMoveToNextWord, QKeySequenceMoveToPreviousWord, QKeySequenceMoveToNextLine, 
    QKeySequenceMoveToPreviousLine, QKeySequenceMoveToNextPage, QKeySequenceMoveToPreviousPage, QKeySequenceMoveToStartOfLine, QKeySequenceMoveToEndOfLine, QKeySequenceMoveToStartOfBlock, 
    QKeySequenceMoveToEndOfBlock, QKeySequenceMoveToStartOfDocument, QKeySequenceMoveToEndOfDocument, QKeySequenceSelectNextChar, QKeySequenceSelectPreviousChar, QKeySequenceSelectNextWord, 
    QKeySequenceSelectPreviousWord, QKeySequenceSelectNextLine, QKeySequenceSelectPreviousLine, QKeySequenceSelectNextPage, QKeySequenceSelectPreviousPage, QKeySequenceSelectStartOfLine, 
    QKeySequenceSelectEndOfLine, QKeySequenceSelectStartOfBlock, QKeySequenceSelectEndOfBlock, QKeySequenceSelectStartOfDocument, QKeySequenceSelectEndOfDocument, QKeySequenceDeleteStartOfWord, 
    QKeySequenceDeleteEndOfWord, QKeySequenceDeleteEndOfLine, QKeySequenceInsertParagraphSeparator, QKeySequenceInsertLineSeparator, QKeySequenceSaveAs );

  QKeySequenceSequenceMatch = ( // QKeySequence::SequenceMatch (1)
    QKeySequenceNoMatch, QKeySequencePartialMatch, QKeySequenceExactMatch );

  QKeySequenceSequenceFormat = ( // QKeySequence::SequenceFormat (1)
    QKeySequenceNativeText, QKeySequencePortableText );

function QKeySequence_create(): QKeySequenceH; cdecl; external Qt4PasLib name 'QKeySequence_create';
procedure QKeySequence_destroy(handle: QKeySequenceH); cdecl; external Qt4PasLib name 'QKeySequence_destroy'; 
function QKeySequence_create(key: PWideString): QKeySequenceH; cdecl; external Qt4PasLib name 'QKeySequence_create2';
function QKeySequence_create(k1: Integer; k2: Integer = 0; k3: Integer = 0; k4: Integer = 0): QKeySequenceH; cdecl; external Qt4PasLib name 'QKeySequence_create3';
function QKeySequence_create(ks: QKeySequenceH): QKeySequenceH; cdecl; external Qt4PasLib name 'QKeySequence_create4';
function QKeySequence_create(key: QKeySequenceStandardKey): QKeySequenceH; cdecl; external Qt4PasLib name 'QKeySequence_create5';
function QKeySequence_count(handle: QKeySequenceH): LongWord; cdecl; external Qt4PasLib name 'QKeySequence_count';
function QKeySequence_isEmpty(handle: QKeySequenceH): Boolean; cdecl; external Qt4PasLib name 'QKeySequence_isEmpty';
procedure QKeySequence_toString(handle: QKeySequenceH; retval: PWideString; format: QKeySequenceSequenceFormat = QKeySequencePortableText); cdecl; external Qt4PasLib name 'QKeySequence_toString';
procedure QKeySequence_fromString(retval: QKeySequenceH; str: PWideString; format: QKeySequenceSequenceFormat = QKeySequencePortableText); cdecl; external Qt4PasLib name 'QKeySequence_fromString';
function QKeySequence_matches(handle: QKeySequenceH; seq: QKeySequenceH): QKeySequenceSequenceMatch; cdecl; external Qt4PasLib name 'QKeySequence_matches';
procedure QKeySequence_mnemonic(retval: QKeySequenceH; text: PWideString); cdecl; external Qt4PasLib name 'QKeySequence_mnemonic';
function QKeySequence_isDetached(handle: QKeySequenceH): Boolean; cdecl; external Qt4PasLib name 'QKeySequence_isDetached';

type
  QWidgetRenderFlag = cardinal; // QWidget::RenderFlag
  QWidgetRenderFlags = QWidgetRenderFlag; //QFlags<> (3)
const
  QWidgetDrawWindowBackground =   $1;
  QWidgetDrawChildren =   $2;
  QWidgetIgnoreMask =   $4;


function QWidget_create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_create';
procedure QWidget_destroy(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_destroy'; 
function QWidget_devType(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_devType';
function QWidget_winId(handle: QWidgetH): LongWord; cdecl; external Qt4PasLib name 'QWidget_winId';
procedure QWidget_createWinId(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_createWinId';
function QWidget_internalWinId(handle: QWidgetH): LongWord; cdecl; external Qt4PasLib name 'QWidget_internalWinId';
function QWidget_effectiveWinId(handle: QWidgetH): LongWord; cdecl; external Qt4PasLib name 'QWidget_effectiveWinId';
function QWidget_style(handle: QWidgetH): QStyleH; cdecl; external Qt4PasLib name 'QWidget_style';
procedure QWidget_setStyle(handle: QWidgetH; p1: QStyleH); cdecl; external Qt4PasLib name 'QWidget_setStyle';
function QWidget_isTopLevel(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isTopLevel';
function QWidget_isWindow(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isWindow';
function QWidget_isModal(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isModal';
function QWidget_windowModality(handle: QWidgetH): QtWindowModality; cdecl; external Qt4PasLib name 'QWidget_windowModality';
procedure QWidget_setWindowModality(handle: QWidgetH; windowModality: QtWindowModality); cdecl; external Qt4PasLib name 'QWidget_setWindowModality';
function QWidget_isEnabled(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isEnabled';
function QWidget_isEnabledTo(handle: QWidgetH; p1: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isEnabledTo';
function QWidget_isEnabledToTLW(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isEnabledToTLW';
procedure QWidget_setEnabled(handle: QWidgetH; p1: Boolean); cdecl; external Qt4PasLib name 'QWidget_setEnabled';
procedure QWidget_setDisabled(handle: QWidgetH; p1: Boolean); cdecl; external Qt4PasLib name 'QWidget_setDisabled';
procedure QWidget_setWindowModified(handle: QWidgetH; p1: Boolean); cdecl; external Qt4PasLib name 'QWidget_setWindowModified';
procedure QWidget_frameGeometry(handle: QWidgetH; retval: PRect); cdecl; external Qt4PasLib name 'QWidget_frameGeometry';
procedure QWidget_geometry(handle: QWidgetH; retval: PRect); cdecl; external Qt4PasLib name 'QWidget_geometry';
procedure QWidget_normalGeometry(handle: QWidgetH; retval: PRect); cdecl; external Qt4PasLib name 'QWidget_normalGeometry';
function QWidget_x(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_x';
function QWidget_y(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_y';
procedure QWidget_pos(handle: QWidgetH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QWidget_pos';
procedure QWidget_frameSize(handle: QWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QWidget_frameSize';
procedure QWidget_size(handle: QWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QWidget_size';
function QWidget_width(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_width';
function QWidget_height(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_height';
procedure QWidget_rect(handle: QWidgetH; retval: PRect); cdecl; external Qt4PasLib name 'QWidget_rect';
procedure QWidget_childrenRect(handle: QWidgetH; retval: PRect); cdecl; external Qt4PasLib name 'QWidget_childrenRect';
procedure QWidget_childrenRegion(handle: QWidgetH; retval: QRegionH); cdecl; external Qt4PasLib name 'QWidget_childrenRegion';
procedure QWidget_minimumSize(handle: QWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QWidget_minimumSize';
procedure QWidget_maximumSize(handle: QWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QWidget_maximumSize';
function QWidget_minimumWidth(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_minimumWidth';
function QWidget_minimumHeight(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_minimumHeight';
function QWidget_maximumWidth(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_maximumWidth';
function QWidget_maximumHeight(handle: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QWidget_maximumHeight';
procedure QWidget_setMinimumSize(handle: QWidgetH; p1: PSize); cdecl; external Qt4PasLib name 'QWidget_setMinimumSize';
procedure QWidget_setMinimumSize(handle: QWidgetH; minw: Integer; minh: Integer); cdecl; external Qt4PasLib name 'QWidget_setMinimumSize2';
procedure QWidget_setMaximumSize(handle: QWidgetH; p1: PSize); cdecl; external Qt4PasLib name 'QWidget_setMaximumSize';
procedure QWidget_setMaximumSize(handle: QWidgetH; maxw: Integer; maxh: Integer); cdecl; external Qt4PasLib name 'QWidget_setMaximumSize2';
procedure QWidget_setMinimumWidth(handle: QWidgetH; minw: Integer); cdecl; external Qt4PasLib name 'QWidget_setMinimumWidth';
procedure QWidget_setMinimumHeight(handle: QWidgetH; minh: Integer); cdecl; external Qt4PasLib name 'QWidget_setMinimumHeight';
procedure QWidget_setMaximumWidth(handle: QWidgetH; maxw: Integer); cdecl; external Qt4PasLib name 'QWidget_setMaximumWidth';
procedure QWidget_setMaximumHeight(handle: QWidgetH; maxh: Integer); cdecl; external Qt4PasLib name 'QWidget_setMaximumHeight';
procedure QWidget_sizeIncrement(handle: QWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QWidget_sizeIncrement';
procedure QWidget_setSizeIncrement(handle: QWidgetH; p1: PSize); cdecl; external Qt4PasLib name 'QWidget_setSizeIncrement';
procedure QWidget_setSizeIncrement(handle: QWidgetH; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QWidget_setSizeIncrement2';
procedure QWidget_baseSize(handle: QWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QWidget_baseSize';
procedure QWidget_setBaseSize(handle: QWidgetH; p1: PSize); cdecl; external Qt4PasLib name 'QWidget_setBaseSize';
procedure QWidget_setBaseSize(handle: QWidgetH; basew: Integer; baseh: Integer); cdecl; external Qt4PasLib name 'QWidget_setBaseSize2';
procedure QWidget_setFixedSize(handle: QWidgetH; p1: PSize); cdecl; external Qt4PasLib name 'QWidget_setFixedSize';
procedure QWidget_setFixedSize(handle: QWidgetH; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QWidget_setFixedSize2';
procedure QWidget_setFixedWidth(handle: QWidgetH; w: Integer); cdecl; external Qt4PasLib name 'QWidget_setFixedWidth';
procedure QWidget_setFixedHeight(handle: QWidgetH; h: Integer); cdecl; external Qt4PasLib name 'QWidget_setFixedHeight';
procedure QWidget_mapToGlobal(handle: QWidgetH; retval: PQtPoint; p1: PQtPoint); cdecl; external Qt4PasLib name 'QWidget_mapToGlobal';
procedure QWidget_mapFromGlobal(handle: QWidgetH; retval: PQtPoint; p1: PQtPoint); cdecl; external Qt4PasLib name 'QWidget_mapFromGlobal';
procedure QWidget_mapToParent(handle: QWidgetH; retval: PQtPoint; p1: PQtPoint); cdecl; external Qt4PasLib name 'QWidget_mapToParent';
procedure QWidget_mapFromParent(handle: QWidgetH; retval: PQtPoint; p1: PQtPoint); cdecl; external Qt4PasLib name 'QWidget_mapFromParent';
procedure QWidget_mapTo(handle: QWidgetH; retval: PQtPoint; p1: QWidgetH; p2: PQtPoint); cdecl; external Qt4PasLib name 'QWidget_mapTo';
procedure QWidget_mapFrom(handle: QWidgetH; retval: PQtPoint; p1: QWidgetH; p2: PQtPoint); cdecl; external Qt4PasLib name 'QWidget_mapFrom';
function QWidget_window(handle: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_window';
function QWidget_nativeParentWidget(handle: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_nativeParentWidget';
function QWidget_topLevelWidget(handle: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_topLevelWidget';
function QWidget_palette(handle: QWidgetH): QPaletteH; cdecl; external Qt4PasLib name 'QWidget_palette';
procedure QWidget_setPalette(handle: QWidgetH; p1: QPaletteH); cdecl; external Qt4PasLib name 'QWidget_setPalette';
procedure QWidget_setBackgroundRole(handle: QWidgetH; p1: QPaletteColorRole); cdecl; external Qt4PasLib name 'QWidget_setBackgroundRole';
function QWidget_backgroundRole(handle: QWidgetH): QPaletteColorRole; cdecl; external Qt4PasLib name 'QWidget_backgroundRole';
procedure QWidget_setForegroundRole(handle: QWidgetH; p1: QPaletteColorRole); cdecl; external Qt4PasLib name 'QWidget_setForegroundRole';
function QWidget_foregroundRole(handle: QWidgetH): QPaletteColorRole; cdecl; external Qt4PasLib name 'QWidget_foregroundRole';
function QWidget_font(handle: QWidgetH): QFontH; cdecl; external Qt4PasLib name 'QWidget_font';
procedure QWidget_setFont(handle: QWidgetH; p1: QFontH); cdecl; external Qt4PasLib name 'QWidget_setFont';
procedure QWidget_fontMetrics(handle: QWidgetH; retval: QFontMetricsH); cdecl; external Qt4PasLib name 'QWidget_fontMetrics';
procedure QWidget_fontInfo(handle: QWidgetH; retval: QFontInfoH); cdecl; external Qt4PasLib name 'QWidget_fontInfo';
procedure QWidget_cursor(handle: QWidgetH; retval: QCursorH); cdecl; external Qt4PasLib name 'QWidget_cursor';
procedure QWidget_setCursor(handle: QWidgetH; p1: QCursorH); cdecl; external Qt4PasLib name 'QWidget_setCursor';
procedure QWidget_unsetCursor(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_unsetCursor';
procedure QWidget_setMouseTracking(handle: QWidgetH; enable: Boolean); cdecl; external Qt4PasLib name 'QWidget_setMouseTracking';
function QWidget_hasMouseTracking(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_hasMouseTracking';
function QWidget_underMouse(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_underMouse';
procedure QWidget_setMask(handle: QWidgetH; p1: QBitmapH); cdecl; external Qt4PasLib name 'QWidget_setMask';
procedure QWidget_setMask(handle: QWidgetH; p1: QRegionH); cdecl; external Qt4PasLib name 'QWidget_setMask2';
procedure QWidget_mask(handle: QWidgetH; retval: QRegionH); cdecl; external Qt4PasLib name 'QWidget_mask';
procedure QWidget_clearMask(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_clearMask';
procedure QWidget_render(handle: QWidgetH; target: QPaintDeviceH; targetOffset: PQtPoint; sourceRegion: QRegionH; renderFlags: QWidgetRenderFlags); cdecl; external Qt4PasLib name 'QWidget_render';
procedure QWidget_render(handle: QWidgetH; painter: QPainterH; targetOffset: PQtPoint; sourceRegion: QRegionH; renderFlags: QWidgetRenderFlags); cdecl; external Qt4PasLib name 'QWidget_render2';
procedure QWidget_setWindowTitle(handle: QWidgetH; p1: PWideString); cdecl; external Qt4PasLib name 'QWidget_setWindowTitle';
procedure QWidget_setStyleSheet(handle: QWidgetH; styleSheet: PWideString); cdecl; external Qt4PasLib name 'QWidget_setStyleSheet';
procedure QWidget_styleSheet(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_styleSheet';
procedure QWidget_windowTitle(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_windowTitle';
procedure QWidget_setWindowIcon(handle: QWidgetH; icon: QIconH); cdecl; external Qt4PasLib name 'QWidget_setWindowIcon';
procedure QWidget_windowIcon(handle: QWidgetH; retval: QIconH); cdecl; external Qt4PasLib name 'QWidget_windowIcon';
procedure QWidget_setWindowIconText(handle: QWidgetH; p1: PWideString); cdecl; external Qt4PasLib name 'QWidget_setWindowIconText';
procedure QWidget_windowIconText(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_windowIconText';
procedure QWidget_setWindowRole(handle: QWidgetH; p1: PWideString); cdecl; external Qt4PasLib name 'QWidget_setWindowRole';
procedure QWidget_windowRole(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_windowRole';
procedure QWidget_setWindowFilePath(handle: QWidgetH; filePath: PWideString); cdecl; external Qt4PasLib name 'QWidget_setWindowFilePath';
procedure QWidget_windowFilePath(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_windowFilePath';
procedure QWidget_setWindowOpacity(handle: QWidgetH; level: qreal); cdecl; external Qt4PasLib name 'QWidget_setWindowOpacity';
function QWidget_windowOpacity(handle: QWidgetH): qreal; cdecl; external Qt4PasLib name 'QWidget_windowOpacity';
function QWidget_isWindowModified(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isWindowModified';
procedure QWidget_setToolTip(handle: QWidgetH; p1: PWideString); cdecl; external Qt4PasLib name 'QWidget_setToolTip';
procedure QWidget_toolTip(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_toolTip';
procedure QWidget_setStatusTip(handle: QWidgetH; p1: PWideString); cdecl; external Qt4PasLib name 'QWidget_setStatusTip';
procedure QWidget_statusTip(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_statusTip';
procedure QWidget_setWhatsThis(handle: QWidgetH; p1: PWideString); cdecl; external Qt4PasLib name 'QWidget_setWhatsThis';
procedure QWidget_whatsThis(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_whatsThis';
procedure QWidget_accessibleName(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_accessibleName';
procedure QWidget_setAccessibleName(handle: QWidgetH; name: PWideString); cdecl; external Qt4PasLib name 'QWidget_setAccessibleName';
procedure QWidget_accessibleDescription(handle: QWidgetH; retval: PWideString); cdecl; external Qt4PasLib name 'QWidget_accessibleDescription';
procedure QWidget_setAccessibleDescription(handle: QWidgetH; description: PWideString); cdecl; external Qt4PasLib name 'QWidget_setAccessibleDescription';
procedure QWidget_setLayoutDirection(handle: QWidgetH; direction: QtLayoutDirection); cdecl; external Qt4PasLib name 'QWidget_setLayoutDirection';
function QWidget_layoutDirection(handle: QWidgetH): QtLayoutDirection; cdecl; external Qt4PasLib name 'QWidget_layoutDirection';
procedure QWidget_unsetLayoutDirection(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_unsetLayoutDirection';
procedure QWidget_setLocale(handle: QWidgetH; locale: QLocaleH); cdecl; external Qt4PasLib name 'QWidget_setLocale';
procedure QWidget_locale(handle: QWidgetH; retval: QLocaleH); cdecl; external Qt4PasLib name 'QWidget_locale';
procedure QWidget_unsetLocale(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_unsetLocale';
function QWidget_isRightToLeft(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isRightToLeft';
function QWidget_isLeftToRight(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isLeftToRight';
procedure QWidget_setFocus(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_setFocus';
function QWidget_isActiveWindow(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isActiveWindow';
procedure QWidget_activateWindow(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_activateWindow';
procedure QWidget_clearFocus(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_clearFocus';
procedure QWidget_setFocus(handle: QWidgetH; reason: QtFocusReason); cdecl; external Qt4PasLib name 'QWidget_setFocus2';
function QWidget_focusPolicy(handle: QWidgetH): QtFocusPolicy; cdecl; external Qt4PasLib name 'QWidget_focusPolicy';
procedure QWidget_setFocusPolicy(handle: QWidgetH; policy: QtFocusPolicy); cdecl; external Qt4PasLib name 'QWidget_setFocusPolicy';
function QWidget_hasFocus(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_hasFocus';
procedure QWidget_setTabOrder(p1: QWidgetH; p2: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_setTabOrder';
procedure QWidget_setFocusProxy(handle: QWidgetH; p1: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_setFocusProxy';
function QWidget_focusProxy(handle: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_focusProxy';
function QWidget_contextMenuPolicy(handle: QWidgetH): QtContextMenuPolicy; cdecl; external Qt4PasLib name 'QWidget_contextMenuPolicy';
procedure QWidget_setContextMenuPolicy(handle: QWidgetH; policy: QtContextMenuPolicy); cdecl; external Qt4PasLib name 'QWidget_setContextMenuPolicy';
procedure QWidget_grabMouse(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_grabMouse';
procedure QWidget_grabMouse(handle: QWidgetH; p1: QCursorH); cdecl; external Qt4PasLib name 'QWidget_grabMouse2';
procedure QWidget_releaseMouse(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_releaseMouse';
procedure QWidget_grabKeyboard(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_grabKeyboard';
procedure QWidget_releaseKeyboard(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_releaseKeyboard';
function QWidget_grabShortcut(handle: QWidgetH; key: QKeySequenceH; context: QtShortcutContext = QtWindowShortcut): Integer; cdecl; external Qt4PasLib name 'QWidget_grabShortcut';
procedure QWidget_releaseShortcut(handle: QWidgetH; id: Integer); cdecl; external Qt4PasLib name 'QWidget_releaseShortcut';
procedure QWidget_setShortcutEnabled(handle: QWidgetH; id: Integer; enable: Boolean = True); cdecl; external Qt4PasLib name 'QWidget_setShortcutEnabled';
procedure QWidget_setShortcutAutoRepeat(handle: QWidgetH; id: Integer; enable: Boolean = True); cdecl; external Qt4PasLib name 'QWidget_setShortcutAutoRepeat';
function QWidget_mouseGrabber(): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_mouseGrabber';
function QWidget_keyboardGrabber(): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_keyboardGrabber';
function QWidget_updatesEnabled(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_updatesEnabled';
procedure QWidget_setUpdatesEnabled(handle: QWidgetH; enable: Boolean); cdecl; external Qt4PasLib name 'QWidget_setUpdatesEnabled';
function QWidget_graphicsProxyWidget(handle: QWidgetH): QGraphicsProxyWidgetH; cdecl; external Qt4PasLib name 'QWidget_graphicsProxyWidget';
procedure QWidget_update(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_update';
procedure QWidget_repaint(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_repaint';
procedure QWidget_update(handle: QWidgetH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QWidget_update2';
procedure QWidget_update(handle: QWidgetH; p1: PRect); cdecl; external Qt4PasLib name 'QWidget_update3';
procedure QWidget_update(handle: QWidgetH; p1: QRegionH); cdecl; external Qt4PasLib name 'QWidget_update4';
procedure QWidget_repaint(handle: QWidgetH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QWidget_repaint2';
procedure QWidget_repaint(handle: QWidgetH; p1: PRect); cdecl; external Qt4PasLib name 'QWidget_repaint3';
procedure QWidget_repaint(handle: QWidgetH; p1: QRegionH); cdecl; external Qt4PasLib name 'QWidget_repaint4';
procedure QWidget_setVisible(handle: QWidgetH; visible: Boolean); cdecl; external Qt4PasLib name 'QWidget_setVisible';
procedure QWidget_setHidden(handle: QWidgetH; hidden: Boolean); cdecl; external Qt4PasLib name 'QWidget_setHidden';
procedure QWidget_show(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_show';
procedure QWidget_hide(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_hide';
procedure QWidget_setShown(handle: QWidgetH; shown: Boolean); cdecl; external Qt4PasLib name 'QWidget_setShown';
procedure QWidget_showMinimized(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_showMinimized';
procedure QWidget_showMaximized(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_showMaximized';
procedure QWidget_showFullScreen(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_showFullScreen';
procedure QWidget_showNormal(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_showNormal';
function QWidget_close(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_close';
procedure QWidget_raise(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_raise';
procedure QWidget_lower(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_lower';
procedure QWidget_stackUnder(handle: QWidgetH; p1: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_stackUnder';
procedure QWidget_move(handle: QWidgetH; x: Integer; y: Integer); cdecl; external Qt4PasLib name 'QWidget_move';
procedure QWidget_move(handle: QWidgetH; p1: PQtPoint); cdecl; external Qt4PasLib name 'QWidget_move2';
procedure QWidget_resize(handle: QWidgetH; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QWidget_resize';
procedure QWidget_resize(handle: QWidgetH; p1: PSize); cdecl; external Qt4PasLib name 'QWidget_resize2';
procedure QWidget_setGeometry(handle: QWidgetH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QWidget_setGeometry';
procedure QWidget_setGeometry(handle: QWidgetH; p1: PRect); cdecl; external Qt4PasLib name 'QWidget_setGeometry2';
procedure QWidget_saveGeometry(handle: QWidgetH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QWidget_saveGeometry';
function QWidget_restoreGeometry(handle: QWidgetH; geometry: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QWidget_restoreGeometry';
procedure QWidget_adjustSize(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_adjustSize';
function QWidget_isVisible(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isVisible';
function QWidget_isVisibleTo(handle: QWidgetH; p1: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isVisibleTo';
function QWidget_isHidden(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isHidden';
function QWidget_isMinimized(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isMinimized';
function QWidget_isMaximized(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isMaximized';
function QWidget_isFullScreen(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isFullScreen';
function QWidget_windowState(handle: QWidgetH): QtWindowStates; cdecl; external Qt4PasLib name 'QWidget_windowState';
procedure QWidget_setWindowState(handle: QWidgetH; state: QtWindowStates); cdecl; external Qt4PasLib name 'QWidget_setWindowState';
procedure QWidget_overrideWindowState(handle: QWidgetH; state: QtWindowStates); cdecl; external Qt4PasLib name 'QWidget_overrideWindowState';
procedure QWidget_sizeHint(handle: QWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QWidget_sizeHint';
procedure QWidget_minimumSizeHint(handle: QWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QWidget_minimumSizeHint';
procedure QWidget_sizePolicy(handle: QWidgetH; retval: PSizePolicy); cdecl; external Qt4PasLib name 'QWidget_sizePolicy';
procedure QWidget_setSizePolicy(handle: QWidgetH; p1: PSizePolicy); cdecl; external Qt4PasLib name 'QWidget_setSizePolicy';
procedure QWidget_setSizePolicy(handle: QWidgetH; horizontal: QSizePolicyPolicy; vertical: QSizePolicyPolicy); cdecl; external Qt4PasLib name 'QWidget_setSizePolicy2';
function QWidget_heightForWidth(handle: QWidgetH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QWidget_heightForWidth';
procedure QWidget_visibleRegion(handle: QWidgetH; retval: QRegionH); cdecl; external Qt4PasLib name 'QWidget_visibleRegion';
procedure QWidget_setContentsMargins(handle: QWidgetH; left: Integer; top: Integer; right: Integer; bottom: Integer); cdecl; external Qt4PasLib name 'QWidget_setContentsMargins';
procedure QWidget_getContentsMargins(handle: QWidgetH; left: PInteger; top: PInteger; right: PInteger; bottom: PInteger); cdecl; external Qt4PasLib name 'QWidget_getContentsMargins';
procedure QWidget_contentsRect(handle: QWidgetH; retval: PRect); cdecl; external Qt4PasLib name 'QWidget_contentsRect';
function QWidget_layout(handle: QWidgetH): QLayoutH; cdecl; external Qt4PasLib name 'QWidget_layout';
procedure QWidget_setLayout(handle: QWidgetH; p1: QLayoutH); cdecl; external Qt4PasLib name 'QWidget_setLayout';
procedure QWidget_updateGeometry(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_updateGeometry';
procedure QWidget_setParent(handle: QWidgetH; parent: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_setParent';
procedure QWidget_setParent(handle: QWidgetH; parent: QWidgetH; f: QtWindowFlags); cdecl; external Qt4PasLib name 'QWidget_setParent2';
procedure QWidget_scroll(handle: QWidgetH; dx: Integer; dy: Integer); cdecl; external Qt4PasLib name 'QWidget_scroll';
procedure QWidget_scroll(handle: QWidgetH; dx: Integer; dy: Integer; p3: PRect); cdecl; external Qt4PasLib name 'QWidget_scroll2';
function QWidget_focusWidget(handle: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_focusWidget';
function QWidget_nextInFocusChain(handle: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_nextInFocusChain';
function QWidget_acceptDrops(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_acceptDrops';
procedure QWidget_setAcceptDrops(handle: QWidgetH; _on: Boolean); cdecl; external Qt4PasLib name 'QWidget_setAcceptDrops';
procedure QWidget_addAction(handle: QWidgetH; action: QActionH); cdecl; external Qt4PasLib name 'QWidget_addAction';
procedure QWidget_addActions(handle: QWidgetH; actions: PPtrIntArray); cdecl; external Qt4PasLib name 'QWidget_addActions';
procedure QWidget_insertAction(handle: QWidgetH; before: QActionH; action: QActionH); cdecl; external Qt4PasLib name 'QWidget_insertAction';
procedure QWidget_insertActions(handle: QWidgetH; before: QActionH; actions: PPtrIntArray); cdecl; external Qt4PasLib name 'QWidget_insertActions';
procedure QWidget_removeAction(handle: QWidgetH; action: QActionH); cdecl; external Qt4PasLib name 'QWidget_removeAction';
procedure QWidget_actions(handle: QWidgetH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QWidget_actions';
function QWidget_parentWidget(handle: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_parentWidget';
procedure QWidget_setWindowFlags(handle: QWidgetH; _type: QtWindowFlags); cdecl; external Qt4PasLib name 'QWidget_setWindowFlags';
function QWidget_windowFlags(handle: QWidgetH): QtWindowFlags; cdecl; external Qt4PasLib name 'QWidget_windowFlags';
procedure QWidget_overrideWindowFlags(handle: QWidgetH; _type: QtWindowFlags); cdecl; external Qt4PasLib name 'QWidget_overrideWindowFlags';
function QWidget_windowType(handle: QWidgetH): QtWindowType; cdecl; external Qt4PasLib name 'QWidget_windowType';
function QWidget_find(p1: LongWord): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_find';
function QWidget_childAt(handle: QWidgetH; x: Integer; y: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_childAt';
function QWidget_childAt(handle: QWidgetH; p: PQtPoint): QWidgetH; cdecl; external Qt4PasLib name 'QWidget_childAt2';
{$ifdef BINUX }
function QWidget_x11Info(handle: QWidgetH): QX11InfoH; cdecl; external Qt4PasLib name 'QWidget_x11Info';
function QWidget_x11PictureHandle(handle: QWidgetH): QtHANDLE; cdecl; external Qt4PasLib name 'QWidget_x11PictureHandle';
{$endif}
{$ifdef BINUX or DARWIN or QTOPIA }
function QWidget_handle(handle: QWidgetH): QtHANDLE; cdecl; external Qt4PasLib name 'QWidget_handle';
{$endif}
procedure QWidget_setAttribute(handle: QWidgetH; p1: QtWidgetAttribute; _on: Boolean = True); cdecl; external Qt4PasLib name 'QWidget_setAttribute';
function QWidget_testAttribute(handle: QWidgetH; p1: QtWidgetAttribute): Boolean; cdecl; external Qt4PasLib name 'QWidget_testAttribute';
function QWidget_paintEngine(handle: QWidgetH): QPaintEngineH; cdecl; external Qt4PasLib name 'QWidget_paintEngine';
procedure QWidget_ensurePolished(handle: QWidgetH); cdecl; external Qt4PasLib name 'QWidget_ensurePolished';
function QWidget_inputContext(handle: QWidgetH): QInputContextH; cdecl; external Qt4PasLib name 'QWidget_inputContext';
procedure QWidget_setInputContext(handle: QWidgetH; p1: QInputContextH); cdecl; external Qt4PasLib name 'QWidget_setInputContext';
function QWidget_isAncestorOf(handle: QWidgetH; child: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_isAncestorOf';
function QWidget_autoFillBackground(handle: QWidgetH): Boolean; cdecl; external Qt4PasLib name 'QWidget_autoFillBackground';
procedure QWidget_setAutoFillBackground(handle: QWidgetH; enabled: Boolean); cdecl; external Qt4PasLib name 'QWidget_setAutoFillBackground';
procedure QWidget_inputMethodQuery(handle: QWidgetH; retval: QVariantH; p1: QtInputMethodQuery); cdecl; external Qt4PasLib name 'QWidget_inputMethodQuery';
{$ifdef MSWINDOWS }
function QWidget_getDC(handle: QWidgetH): QHDC; cdecl; external Qt4PasLib name 'QWidget_getDC';
procedure QWidget_releaseDC(handle: QWidgetH; p1: QHDC); cdecl; external Qt4PasLib name 'QWidget_releaseDC';
{$endif}
{$ifdef DARWIN }
function QWidget_macQDHandle(handle: QWidgetH): QtHANDLE; cdecl; external Qt4PasLib name 'QWidget_macQDHandle';
function QWidget_macCGHandle(handle: QWidgetH): QtHANDLE; cdecl; external Qt4PasLib name 'QWidget_macCGHandle';
{$endif}
function QWidget_to_QPaintDevice(handle: QWidgetH): QPaintDeviceH; cdecl; external Qt4PasLib name 'QWidget_to_QPaintDevice';

type
  QWidget_customContextMenuRequested_Event = procedure (pos: PQtPoint) of object cdecl;


procedure QLayoutItem_sizeHint(handle: QLayoutItemH; retval: PSize); cdecl; external Qt4PasLib name 'QLayoutItem_sizeHint';
procedure QLayoutItem_minimumSize(handle: QLayoutItemH; retval: PSize); cdecl; external Qt4PasLib name 'QLayoutItem_minimumSize';
procedure QLayoutItem_maximumSize(handle: QLayoutItemH; retval: PSize); cdecl; external Qt4PasLib name 'QLayoutItem_maximumSize';
function QLayoutItem_expandingDirections(handle: QLayoutItemH): QtOrientations; cdecl; external Qt4PasLib name 'QLayoutItem_expandingDirections';
procedure QLayoutItem_setGeometry(handle: QLayoutItemH; p1: PRect); cdecl; external Qt4PasLib name 'QLayoutItem_setGeometry';
procedure QLayoutItem_geometry(handle: QLayoutItemH; retval: PRect); cdecl; external Qt4PasLib name 'QLayoutItem_geometry';
function QLayoutItem_isEmpty(handle: QLayoutItemH): Boolean; cdecl; external Qt4PasLib name 'QLayoutItem_isEmpty';
function QLayoutItem_hasHeightForWidth(handle: QLayoutItemH): Boolean; cdecl; external Qt4PasLib name 'QLayoutItem_hasHeightForWidth';
function QLayoutItem_heightForWidth(handle: QLayoutItemH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QLayoutItem_heightForWidth';
function QLayoutItem_minimumHeightForWidth(handle: QLayoutItemH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QLayoutItem_minimumHeightForWidth';
procedure QLayoutItem_invalidate(handle: QLayoutItemH); cdecl; external Qt4PasLib name 'QLayoutItem_invalidate';
function QLayoutItem_widget(handle: QLayoutItemH): QWidgetH; cdecl; external Qt4PasLib name 'QLayoutItem_widget';
function QLayoutItem_layout(handle: QLayoutItemH): QLayoutH; cdecl; external Qt4PasLib name 'QLayoutItem_layout';
function QLayoutItem_spacerItem(handle: QLayoutItemH): QSpacerItemH; cdecl; external Qt4PasLib name 'QLayoutItem_spacerItem';
function QLayoutItem_alignment(handle: QLayoutItemH): QtAlignment; cdecl; external Qt4PasLib name 'QLayoutItem_alignment';
procedure QLayoutItem_setAlignment(handle: QLayoutItemH; a: QtAlignment); cdecl; external Qt4PasLib name 'QLayoutItem_setAlignment';
function QLayoutItem_controlTypes(handle: QLayoutItemH): QSizePolicyControlTypes; cdecl; external Qt4PasLib name 'QLayoutItem_controlTypes';

function QSpacerItem_create(w: Integer; h: Integer; hData: QSizePolicyPolicy = QSizePolicyMinimum; vData: QSizePolicyPolicy = QSizePolicyMinimum): QSpacerItemH; cdecl; external Qt4PasLib name 'QSpacerItem_create';
procedure QSpacerItem_destroy(handle: QSpacerItemH); cdecl; external Qt4PasLib name 'QSpacerItem_destroy'; 
procedure QSpacerItem_changeSize(handle: QSpacerItemH; w: Integer; h: Integer; hData: QSizePolicyPolicy = QSizePolicyMinimum; vData: QSizePolicyPolicy = QSizePolicyMinimum); cdecl; external Qt4PasLib name 'QSpacerItem_changeSize';
procedure QSpacerItem_sizeHint(handle: QSpacerItemH; retval: PSize); cdecl; external Qt4PasLib name 'QSpacerItem_sizeHint';
procedure QSpacerItem_minimumSize(handle: QSpacerItemH; retval: PSize); cdecl; external Qt4PasLib name 'QSpacerItem_minimumSize';
procedure QSpacerItem_maximumSize(handle: QSpacerItemH; retval: PSize); cdecl; external Qt4PasLib name 'QSpacerItem_maximumSize';
function QSpacerItem_expandingDirections(handle: QSpacerItemH): QtOrientations; cdecl; external Qt4PasLib name 'QSpacerItem_expandingDirections';
function QSpacerItem_isEmpty(handle: QSpacerItemH): Boolean; cdecl; external Qt4PasLib name 'QSpacerItem_isEmpty';
procedure QSpacerItem_setGeometry(handle: QSpacerItemH; p1: PRect); cdecl; external Qt4PasLib name 'QSpacerItem_setGeometry';
procedure QSpacerItem_geometry(handle: QSpacerItemH; retval: PRect); cdecl; external Qt4PasLib name 'QSpacerItem_geometry';
function QSpacerItem_spacerItem(handle: QSpacerItemH): QSpacerItemH; cdecl; external Qt4PasLib name 'QSpacerItem_spacerItem';

function QWidgetItem_create(w: QWidgetH): QWidgetItemH; cdecl; external Qt4PasLib name 'QWidgetItem_create';
procedure QWidgetItem_destroy(handle: QWidgetItemH); cdecl; external Qt4PasLib name 'QWidgetItem_destroy'; 
procedure QWidgetItem_sizeHint(handle: QWidgetItemH; retval: PSize); cdecl; external Qt4PasLib name 'QWidgetItem_sizeHint';
procedure QWidgetItem_minimumSize(handle: QWidgetItemH; retval: PSize); cdecl; external Qt4PasLib name 'QWidgetItem_minimumSize';
procedure QWidgetItem_maximumSize(handle: QWidgetItemH; retval: PSize); cdecl; external Qt4PasLib name 'QWidgetItem_maximumSize';
function QWidgetItem_expandingDirections(handle: QWidgetItemH): QtOrientations; cdecl; external Qt4PasLib name 'QWidgetItem_expandingDirections';
function QWidgetItem_isEmpty(handle: QWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QWidgetItem_isEmpty';
procedure QWidgetItem_setGeometry(handle: QWidgetItemH; p1: PRect); cdecl; external Qt4PasLib name 'QWidgetItem_setGeometry';
procedure QWidgetItem_geometry(handle: QWidgetItemH; retval: PRect); cdecl; external Qt4PasLib name 'QWidgetItem_geometry';
function QWidgetItem_widget(handle: QWidgetItemH): QWidgetH; cdecl; external Qt4PasLib name 'QWidgetItem_widget';
function QWidgetItem_hasHeightForWidth(handle: QWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QWidgetItem_hasHeightForWidth';
function QWidgetItem_heightForWidth(handle: QWidgetItemH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QWidgetItem_heightForWidth';


type
  QLayoutSizeConstraint = ( // QLayout::SizeConstraint (1)
    QLayoutSetDefaultConstraint, QLayoutSetNoConstraint, QLayoutSetMinimumSize, QLayoutSetFixedSize, QLayoutSetMaximumSize, QLayoutSetMinAndMaxSize );

function QLayout_margin(handle: QLayoutH): Integer; cdecl; external Qt4PasLib name 'QLayout_margin';
function QLayout_spacing(handle: QLayoutH): Integer; cdecl; external Qt4PasLib name 'QLayout_spacing';
procedure QLayout_setMargin(handle: QLayoutH; p1: Integer); cdecl; external Qt4PasLib name 'QLayout_setMargin';
procedure QLayout_setSpacing(handle: QLayoutH; p1: Integer); cdecl; external Qt4PasLib name 'QLayout_setSpacing';
procedure QLayout_setContentsMargins(handle: QLayoutH; left: Integer; top: Integer; right: Integer; bottom: Integer); cdecl; external Qt4PasLib name 'QLayout_setContentsMargins';
procedure QLayout_getContentsMargins(handle: QLayoutH; left: PInteger; top: PInteger; right: PInteger; bottom: PInteger); cdecl; external Qt4PasLib name 'QLayout_getContentsMargins';
procedure QLayout_contentsRect(handle: QLayoutH; retval: PRect); cdecl; external Qt4PasLib name 'QLayout_contentsRect';
function QLayout_setAlignment(handle: QLayoutH; w: QWidgetH; alignment: QtAlignment): Boolean; cdecl; external Qt4PasLib name 'QLayout_setAlignment';
function QLayout_setAlignment(handle: QLayoutH; l: QLayoutH; alignment: QtAlignment): Boolean; cdecl; external Qt4PasLib name 'QLayout_setAlignment2';
procedure QLayout_setSizeConstraint(handle: QLayoutH; p1: QLayoutSizeConstraint); cdecl; external Qt4PasLib name 'QLayout_setSizeConstraint';
function QLayout_sizeConstraint(handle: QLayoutH): QLayoutSizeConstraint; cdecl; external Qt4PasLib name 'QLayout_sizeConstraint';
procedure QLayout_setMenuBar(handle: QLayoutH; w: QWidgetH); cdecl; external Qt4PasLib name 'QLayout_setMenuBar';
function QLayout_menuBar(handle: QLayoutH): QWidgetH; cdecl; external Qt4PasLib name 'QLayout_menuBar';
function QLayout_parentWidget(handle: QLayoutH): QWidgetH; cdecl; external Qt4PasLib name 'QLayout_parentWidget';
procedure QLayout_invalidate(handle: QLayoutH); cdecl; external Qt4PasLib name 'QLayout_invalidate';
procedure QLayout_geometry(handle: QLayoutH; retval: PRect); cdecl; external Qt4PasLib name 'QLayout_geometry';
function QLayout_activate(handle: QLayoutH): Boolean; cdecl; external Qt4PasLib name 'QLayout_activate';
procedure QLayout_update(handle: QLayoutH); cdecl; external Qt4PasLib name 'QLayout_update';
procedure QLayout_addWidget(handle: QLayoutH; w: QWidgetH); cdecl; external Qt4PasLib name 'QLayout_addWidget';
procedure QLayout_addItem(handle: QLayoutH; p1: QLayoutItemH); cdecl; external Qt4PasLib name 'QLayout_addItem';
procedure QLayout_removeWidget(handle: QLayoutH; w: QWidgetH); cdecl; external Qt4PasLib name 'QLayout_removeWidget';
procedure QLayout_removeItem(handle: QLayoutH; p1: QLayoutItemH); cdecl; external Qt4PasLib name 'QLayout_removeItem';
function QLayout_expandingDirections(handle: QLayoutH): QtOrientations; cdecl; external Qt4PasLib name 'QLayout_expandingDirections';
procedure QLayout_minimumSize(handle: QLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QLayout_minimumSize';
procedure QLayout_maximumSize(handle: QLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QLayout_maximumSize';
procedure QLayout_setGeometry(handle: QLayoutH; p1: PRect); cdecl; external Qt4PasLib name 'QLayout_setGeometry';
function QLayout_itemAt(handle: QLayoutH; index: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QLayout_itemAt';
function QLayout_takeAt(handle: QLayoutH; index: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QLayout_takeAt';
function QLayout_indexOf(handle: QLayoutH; p1: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QLayout_indexOf';
function QLayout_count(handle: QLayoutH): Integer; cdecl; external Qt4PasLib name 'QLayout_count';
function QLayout_isEmpty(handle: QLayoutH): Boolean; cdecl; external Qt4PasLib name 'QLayout_isEmpty';
function QLayout_totalHeightForWidth(handle: QLayoutH; w: Integer): Integer; cdecl; external Qt4PasLib name 'QLayout_totalHeightForWidth';
procedure QLayout_totalMinimumSize(handle: QLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QLayout_totalMinimumSize';
procedure QLayout_totalMaximumSize(handle: QLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QLayout_totalMaximumSize';
procedure QLayout_totalSizeHint(handle: QLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QLayout_totalSizeHint';
function QLayout_layout(handle: QLayoutH): QLayoutH; cdecl; external Qt4PasLib name 'QLayout_layout';
procedure QLayout_setEnabled(handle: QLayoutH; p1: Boolean); cdecl; external Qt4PasLib name 'QLayout_setEnabled';
function QLayout_isEnabled(handle: QLayoutH): Boolean; cdecl; external Qt4PasLib name 'QLayout_isEnabled';
procedure QLayout_closestAcceptableSize(retval: PSize; w: QWidgetH; s: PSize); cdecl; external Qt4PasLib name 'QLayout_closestAcceptableSize';
function QLayout_to_QLayoutItem(handle: QLayoutH): QLayoutItemH; cdecl; external Qt4PasLib name 'QLayout_to_QLayoutItem';
type
  QBoxLayoutDirection = cardinal; //  QBoxLayout::Direction (4)

const
    QBoxLayoutLeftToRight = 0 { $0 };
    QBoxLayoutRightToLeft = 1 { $1 };
    QBoxLayoutTopToBottom = 2 { $2 };
    QBoxLayoutBottomToTop = 3 { $3 };
    QBoxLayoutDown = 2 { $2 };
    QBoxLayoutUp = 3 { $3 };


function QBoxLayout_create(p1: QBoxLayoutDirection; parent: QWidgetH = nil): QBoxLayoutH; cdecl; external Qt4PasLib name 'QBoxLayout_create';
procedure QBoxLayout_destroy(handle: QBoxLayoutH); cdecl; external Qt4PasLib name 'QBoxLayout_destroy'; 
function QBoxLayout_direction(handle: QBoxLayoutH): QBoxLayoutDirection; cdecl; external Qt4PasLib name 'QBoxLayout_direction';
procedure QBoxLayout_setDirection(handle: QBoxLayoutH; p1: QBoxLayoutDirection); cdecl; external Qt4PasLib name 'QBoxLayout_setDirection';
procedure QBoxLayout_addSpacing(handle: QBoxLayoutH; size: Integer); cdecl; external Qt4PasLib name 'QBoxLayout_addSpacing';
procedure QBoxLayout_addStretch(handle: QBoxLayoutH; stretch: Integer = 0); cdecl; external Qt4PasLib name 'QBoxLayout_addStretch';
procedure QBoxLayout_addSpacerItem(handle: QBoxLayoutH; spacerItem: QSpacerItemH); cdecl; external Qt4PasLib name 'QBoxLayout_addSpacerItem';
procedure QBoxLayout_addWidget(handle: QBoxLayoutH; p1: QWidgetH; stretch: Integer = 0; alignment: QtAlignment = 0); cdecl; external Qt4PasLib name 'QBoxLayout_addWidget';
procedure QBoxLayout_addLayout(handle: QBoxLayoutH; layout: QLayoutH; stretch: Integer = 0); cdecl; external Qt4PasLib name 'QBoxLayout_addLayout';
procedure QBoxLayout_addStrut(handle: QBoxLayoutH; p1: Integer); cdecl; external Qt4PasLib name 'QBoxLayout_addStrut';
procedure QBoxLayout_addItem(handle: QBoxLayoutH; p1: QLayoutItemH); cdecl; external Qt4PasLib name 'QBoxLayout_addItem';
procedure QBoxLayout_insertSpacing(handle: QBoxLayoutH; index: Integer; size: Integer); cdecl; external Qt4PasLib name 'QBoxLayout_insertSpacing';
procedure QBoxLayout_insertStretch(handle: QBoxLayoutH; index: Integer; stretch: Integer = 0); cdecl; external Qt4PasLib name 'QBoxLayout_insertStretch';
procedure QBoxLayout_insertSpacerItem(handle: QBoxLayoutH; index: Integer; spacerItem: QSpacerItemH); cdecl; external Qt4PasLib name 'QBoxLayout_insertSpacerItem';
procedure QBoxLayout_insertWidget(handle: QBoxLayoutH; index: Integer; widget: QWidgetH; stretch: Integer = 0; alignment: QtAlignment = 0); cdecl; external Qt4PasLib name 'QBoxLayout_insertWidget';
procedure QBoxLayout_insertLayout(handle: QBoxLayoutH; index: Integer; layout: QLayoutH; stretch: Integer = 0); cdecl; external Qt4PasLib name 'QBoxLayout_insertLayout';
function QBoxLayout_spacing(handle: QBoxLayoutH): Integer; cdecl; external Qt4PasLib name 'QBoxLayout_spacing';
procedure QBoxLayout_setSpacing(handle: QBoxLayoutH; spacing: Integer); cdecl; external Qt4PasLib name 'QBoxLayout_setSpacing';
function QBoxLayout_setStretchFactor(handle: QBoxLayoutH; w: QWidgetH; stretch: Integer): Boolean; cdecl; external Qt4PasLib name 'QBoxLayout_setStretchFactor';
function QBoxLayout_setStretchFactor(handle: QBoxLayoutH; l: QLayoutH; stretch: Integer): Boolean; cdecl; external Qt4PasLib name 'QBoxLayout_setStretchFactor2';
procedure QBoxLayout_setStretch(handle: QBoxLayoutH; index: Integer; stretch: Integer); cdecl; external Qt4PasLib name 'QBoxLayout_setStretch';
function QBoxLayout_stretch(handle: QBoxLayoutH; index: Integer): Integer; cdecl; external Qt4PasLib name 'QBoxLayout_stretch';
procedure QBoxLayout_sizeHint(handle: QBoxLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QBoxLayout_sizeHint';
procedure QBoxLayout_minimumSize(handle: QBoxLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QBoxLayout_minimumSize';
procedure QBoxLayout_maximumSize(handle: QBoxLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QBoxLayout_maximumSize';
function QBoxLayout_hasHeightForWidth(handle: QBoxLayoutH): Boolean; cdecl; external Qt4PasLib name 'QBoxLayout_hasHeightForWidth';
function QBoxLayout_heightForWidth(handle: QBoxLayoutH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QBoxLayout_heightForWidth';
function QBoxLayout_minimumHeightForWidth(handle: QBoxLayoutH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QBoxLayout_minimumHeightForWidth';
function QBoxLayout_expandingDirections(handle: QBoxLayoutH): QtOrientations; cdecl; external Qt4PasLib name 'QBoxLayout_expandingDirections';
procedure QBoxLayout_invalidate(handle: QBoxLayoutH); cdecl; external Qt4PasLib name 'QBoxLayout_invalidate';
function QBoxLayout_itemAt(handle: QBoxLayoutH; p1: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QBoxLayout_itemAt';
function QBoxLayout_takeAt(handle: QBoxLayoutH; p1: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QBoxLayout_takeAt';
function QBoxLayout_count(handle: QBoxLayoutH): Integer; cdecl; external Qt4PasLib name 'QBoxLayout_count';
procedure QBoxLayout_setGeometry(handle: QBoxLayoutH; p1: PRect); cdecl; external Qt4PasLib name 'QBoxLayout_setGeometry';

function QHBoxLayout_create(): QHBoxLayoutH; cdecl; external Qt4PasLib name 'QHBoxLayout_create';
procedure QHBoxLayout_destroy(handle: QHBoxLayoutH); cdecl; external Qt4PasLib name 'QHBoxLayout_destroy'; 
function QHBoxLayout_create(parent: QWidgetH): QHBoxLayoutH; cdecl; external Qt4PasLib name 'QHBoxLayout_create2';

function QVBoxLayout_create(): QVBoxLayoutH; cdecl; external Qt4PasLib name 'QVBoxLayout_create';
procedure QVBoxLayout_destroy(handle: QVBoxLayoutH); cdecl; external Qt4PasLib name 'QVBoxLayout_destroy'; 
function QVBoxLayout_create(parent: QWidgetH): QVBoxLayoutH; cdecl; external Qt4PasLib name 'QVBoxLayout_create2';


type
  QStackedLayoutStackingMode = ( // QStackedLayout::StackingMode (1)
    QStackedLayoutStackOne, QStackedLayoutStackAll );

function QStackedLayout_create(): QStackedLayoutH; cdecl; external Qt4PasLib name 'QStackedLayout_create';
procedure QStackedLayout_destroy(handle: QStackedLayoutH); cdecl; external Qt4PasLib name 'QStackedLayout_destroy'; 
function QStackedLayout_create(parent: QWidgetH): QStackedLayoutH; cdecl; external Qt4PasLib name 'QStackedLayout_create2';
function QStackedLayout_create(parentLayout: QLayoutH): QStackedLayoutH; cdecl; external Qt4PasLib name 'QStackedLayout_create3';
function QStackedLayout_addWidget(handle: QStackedLayoutH; w: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QStackedLayout_addWidget';
function QStackedLayout_insertWidget(handle: QStackedLayoutH; index: Integer; w: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QStackedLayout_insertWidget';
function QStackedLayout_currentWidget(handle: QStackedLayoutH): QWidgetH; cdecl; external Qt4PasLib name 'QStackedLayout_currentWidget';
function QStackedLayout_currentIndex(handle: QStackedLayoutH): Integer; cdecl; external Qt4PasLib name 'QStackedLayout_currentIndex';
function QStackedLayout_widget(handle: QStackedLayoutH; p1: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QStackedLayout_widget';
function QStackedLayout_count(handle: QStackedLayoutH): Integer; cdecl; external Qt4PasLib name 'QStackedLayout_count';
function QStackedLayout_stackingMode(handle: QStackedLayoutH): QStackedLayoutStackingMode; cdecl; external Qt4PasLib name 'QStackedLayout_stackingMode';
procedure QStackedLayout_setStackingMode(handle: QStackedLayoutH; stackingMode: QStackedLayoutStackingMode); cdecl; external Qt4PasLib name 'QStackedLayout_setStackingMode';
procedure QStackedLayout_addItem(handle: QStackedLayoutH; item: QLayoutItemH); cdecl; external Qt4PasLib name 'QStackedLayout_addItem';
procedure QStackedLayout_sizeHint(handle: QStackedLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QStackedLayout_sizeHint';
procedure QStackedLayout_minimumSize(handle: QStackedLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QStackedLayout_minimumSize';
function QStackedLayout_itemAt(handle: QStackedLayoutH; p1: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QStackedLayout_itemAt';
function QStackedLayout_takeAt(handle: QStackedLayoutH; p1: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QStackedLayout_takeAt';
procedure QStackedLayout_setGeometry(handle: QStackedLayoutH; rect: PRect); cdecl; external Qt4PasLib name 'QStackedLayout_setGeometry';
procedure QStackedLayout_setCurrentIndex(handle: QStackedLayoutH; index: Integer); cdecl; external Qt4PasLib name 'QStackedLayout_setCurrentIndex';
procedure QStackedLayout_setCurrentWidget(handle: QStackedLayoutH; w: QWidgetH); cdecl; external Qt4PasLib name 'QStackedLayout_setCurrentWidget';


type
  QStackedLayout_widgetRemoved_Event = procedure (index: Integer) of object cdecl;
  QStackedLayout_currentChanged_Event = procedure (index: Integer) of object cdecl;



type
  QActionMenuRole = ( // QAction::MenuRole (1)
    QActionNoRole, QActionTextHeuristicRole, QActionApplicationSpecificRole, QActionAboutQtRole, QActionAboutRole, QActionPreferencesRole, QActionQuitRole );

  QActionActionEvent = ( // QAction::ActionEvent (1)
    QActionTrigger, QActionHover );

function QAction_create(parent: QObjectH): QActionH; cdecl; external Qt4PasLib name 'QAction_create';
procedure QAction_destroy(handle: QActionH); cdecl; external Qt4PasLib name 'QAction_destroy'; 
function QAction_create(text: PWideString; parent: QObjectH): QActionH; cdecl; external Qt4PasLib name 'QAction_create2';
function QAction_create(icon: QIconH; text: PWideString; parent: QObjectH): QActionH; cdecl; external Qt4PasLib name 'QAction_create3';
procedure QAction_setActionGroup(handle: QActionH; group: QActionGroupH); cdecl; external Qt4PasLib name 'QAction_setActionGroup';
function QAction_actionGroup(handle: QActionH): QActionGroupH; cdecl; external Qt4PasLib name 'QAction_actionGroup';
procedure QAction_setIcon(handle: QActionH; icon: QIconH); cdecl; external Qt4PasLib name 'QAction_setIcon';
procedure QAction_icon(handle: QActionH; retval: QIconH); cdecl; external Qt4PasLib name 'QAction_icon';
procedure QAction_setText(handle: QActionH; text: PWideString); cdecl; external Qt4PasLib name 'QAction_setText';
procedure QAction_text(handle: QActionH; retval: PWideString); cdecl; external Qt4PasLib name 'QAction_text';
procedure QAction_setIconText(handle: QActionH; text: PWideString); cdecl; external Qt4PasLib name 'QAction_setIconText';
procedure QAction_iconText(handle: QActionH; retval: PWideString); cdecl; external Qt4PasLib name 'QAction_iconText';
procedure QAction_setToolTip(handle: QActionH; tip: PWideString); cdecl; external Qt4PasLib name 'QAction_setToolTip';
procedure QAction_toolTip(handle: QActionH; retval: PWideString); cdecl; external Qt4PasLib name 'QAction_toolTip';
procedure QAction_setStatusTip(handle: QActionH; statusTip: PWideString); cdecl; external Qt4PasLib name 'QAction_setStatusTip';
procedure QAction_statusTip(handle: QActionH; retval: PWideString); cdecl; external Qt4PasLib name 'QAction_statusTip';
procedure QAction_setWhatsThis(handle: QActionH; what: PWideString); cdecl; external Qt4PasLib name 'QAction_setWhatsThis';
procedure QAction_whatsThis(handle: QActionH; retval: PWideString); cdecl; external Qt4PasLib name 'QAction_whatsThis';
function QAction_menu(handle: QActionH): QMenuH; cdecl; external Qt4PasLib name 'QAction_menu';
procedure QAction_setMenu(handle: QActionH; menu: QMenuH); cdecl; external Qt4PasLib name 'QAction_setMenu';
procedure QAction_setSeparator(handle: QActionH; b: Boolean); cdecl; external Qt4PasLib name 'QAction_setSeparator';
function QAction_isSeparator(handle: QActionH): Boolean; cdecl; external Qt4PasLib name 'QAction_isSeparator';
procedure QAction_setShortcut(handle: QActionH; shortcut: QKeySequenceH); cdecl; external Qt4PasLib name 'QAction_setShortcut';
procedure QAction_shortcut(handle: QActionH; retval: QKeySequenceH); cdecl; external Qt4PasLib name 'QAction_shortcut';
procedure QAction_setShortcuts(handle: QActionH; p1: QKeySequenceStandardKey); cdecl; external Qt4PasLib name 'QAction_setShortcuts2';
procedure QAction_setShortcutContext(handle: QActionH; context: QtShortcutContext); cdecl; external Qt4PasLib name 'QAction_setShortcutContext';
function QAction_shortcutContext(handle: QActionH): QtShortcutContext; cdecl; external Qt4PasLib name 'QAction_shortcutContext';
procedure QAction_setAutoRepeat(handle: QActionH; p1: Boolean); cdecl; external Qt4PasLib name 'QAction_setAutoRepeat';
function QAction_autoRepeat(handle: QActionH): Boolean; cdecl; external Qt4PasLib name 'QAction_autoRepeat';
procedure QAction_setFont(handle: QActionH; font: QFontH); cdecl; external Qt4PasLib name 'QAction_setFont';
procedure QAction_font(handle: QActionH; retval: QFontH); cdecl; external Qt4PasLib name 'QAction_font';
procedure QAction_setCheckable(handle: QActionH; p1: Boolean); cdecl; external Qt4PasLib name 'QAction_setCheckable';
function QAction_isCheckable(handle: QActionH): Boolean; cdecl; external Qt4PasLib name 'QAction_isCheckable';
procedure QAction_data(handle: QActionH; retval: QVariantH); cdecl; external Qt4PasLib name 'QAction_data';
procedure QAction_setData(handle: QActionH; _var: QVariantH); cdecl; external Qt4PasLib name 'QAction_setData';
function QAction_isChecked(handle: QActionH): Boolean; cdecl; external Qt4PasLib name 'QAction_isChecked';
function QAction_isEnabled(handle: QActionH): Boolean; cdecl; external Qt4PasLib name 'QAction_isEnabled';
function QAction_isVisible(handle: QActionH): Boolean; cdecl; external Qt4PasLib name 'QAction_isVisible';
procedure QAction_activate(handle: QActionH; event: QActionActionEvent); cdecl; external Qt4PasLib name 'QAction_activate';
function QAction_showStatusText(handle: QActionH; widget: QWidgetH = nil): Boolean; cdecl; external Qt4PasLib name 'QAction_showStatusText';
procedure QAction_setMenuRole(handle: QActionH; menuRole: QActionMenuRole); cdecl; external Qt4PasLib name 'QAction_setMenuRole';
function QAction_menuRole(handle: QActionH): QActionMenuRole; cdecl; external Qt4PasLib name 'QAction_menuRole';
procedure QAction_setIconVisibleInMenu(handle: QActionH; visible: Boolean); cdecl; external Qt4PasLib name 'QAction_setIconVisibleInMenu';
function QAction_isIconVisibleInMenu(handle: QActionH): Boolean; cdecl; external Qt4PasLib name 'QAction_isIconVisibleInMenu';
function QAction_parentWidget(handle: QActionH): QWidgetH; cdecl; external Qt4PasLib name 'QAction_parentWidget';
procedure QAction_associatedWidgets(handle: QActionH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QAction_associatedWidgets';
procedure QAction_associatedGraphicsWidgets(handle: QActionH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QAction_associatedGraphicsWidgets';
procedure QAction_trigger(handle: QActionH); cdecl; external Qt4PasLib name 'QAction_trigger';
procedure QAction_hover(handle: QActionH); cdecl; external Qt4PasLib name 'QAction_hover';
procedure QAction_setChecked(handle: QActionH; p1: Boolean); cdecl; external Qt4PasLib name 'QAction_setChecked';
procedure QAction_toggle(handle: QActionH); cdecl; external Qt4PasLib name 'QAction_toggle';
procedure QAction_setEnabled(handle: QActionH; p1: Boolean); cdecl; external Qt4PasLib name 'QAction_setEnabled';
procedure QAction_setDisabled(handle: QActionH; b: Boolean); cdecl; external Qt4PasLib name 'QAction_setDisabled';
procedure QAction_setVisible(handle: QActionH; p1: Boolean); cdecl; external Qt4PasLib name 'QAction_setVisible';


type
  QAction_changed_Event = procedure () of object cdecl;
  QAction_triggered_Event = procedure (checked: Boolean = False) of object cdecl;
  QAction_triggered2_Event = procedure () of object cdecl;
  QAction_hovered_Event = procedure () of object cdecl;
  QAction_toggled_Event = procedure (p1: Boolean) of object cdecl;


function QActionGroup_create(parent: QObjectH): QActionGroupH; cdecl; external Qt4PasLib name 'QActionGroup_create';
procedure QActionGroup_destroy(handle: QActionGroupH); cdecl; external Qt4PasLib name 'QActionGroup_destroy'; 
function QActionGroup_addAction(handle: QActionGroupH; a: QActionH): QActionH; cdecl; external Qt4PasLib name 'QActionGroup_addAction';
function QActionGroup_addAction(handle: QActionGroupH; text: PWideString): QActionH; cdecl; external Qt4PasLib name 'QActionGroup_addAction2';
function QActionGroup_addAction(handle: QActionGroupH; icon: QIconH; text: PWideString): QActionH; cdecl; external Qt4PasLib name 'QActionGroup_addAction3';
procedure QActionGroup_removeAction(handle: QActionGroupH; a: QActionH); cdecl; external Qt4PasLib name 'QActionGroup_removeAction';
procedure QActionGroup_actions(handle: QActionGroupH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QActionGroup_actions';
function QActionGroup_checkedAction(handle: QActionGroupH): QActionH; cdecl; external Qt4PasLib name 'QActionGroup_checkedAction';
function QActionGroup_isExclusive(handle: QActionGroupH): Boolean; cdecl; external Qt4PasLib name 'QActionGroup_isExclusive';
function QActionGroup_isEnabled(handle: QActionGroupH): Boolean; cdecl; external Qt4PasLib name 'QActionGroup_isEnabled';
function QActionGroup_isVisible(handle: QActionGroupH): Boolean; cdecl; external Qt4PasLib name 'QActionGroup_isVisible';
procedure QActionGroup_setEnabled(handle: QActionGroupH; p1: Boolean); cdecl; external Qt4PasLib name 'QActionGroup_setEnabled';
procedure QActionGroup_setDisabled(handle: QActionGroupH; b: Boolean); cdecl; external Qt4PasLib name 'QActionGroup_setDisabled';
procedure QActionGroup_setVisible(handle: QActionGroupH; p1: Boolean); cdecl; external Qt4PasLib name 'QActionGroup_setVisible';
procedure QActionGroup_setExclusive(handle: QActionGroupH; p1: Boolean); cdecl; external Qt4PasLib name 'QActionGroup_setExclusive';


type
  QActionGroup_triggered_Event = procedure (p1: QActionH) of object cdecl;
  QActionGroup_selected_Event = procedure (p1: QActionH) of object cdecl;
  QActionGroup_hovered_Event = procedure (p1: QActionH) of object cdecl;



type
  QTabletEventTabletDevice = ( // QTabletEvent::TabletDevice (1)
    QTabletEventNoDevice, QTabletEventPuck, QTabletEventStylus, QTabletEventAirbrush, QTabletEventFourDMouse, QTabletEventXFreeEraser, QTabletEventRotationStylus );

  QTabletEventPointerType = ( // QTabletEvent::PointerType (1)
    QTabletEventUnknownPointer, QTabletEventPen, QTabletEventCursor, QTabletEventEraser );


type
  QContextMenuEventReason = ( // QContextMenuEvent::Reason (1)
    QContextMenuEventMouse, QContextMenuEventKeyboard, QContextMenuEventOther );


type
  QInputMethodEventAttributeType = ( // QInputMethodEvent::AttributeType (1)
    QInputMethodEventTextFormat, QInputMethodEventCursor, QInputMethodEventLanguage, QInputMethodEventRuby );

function QInputEvent_create(_type: QEventType; modifiers: QtKeyboardModifiers = QtNoModifier): QInputEventH; cdecl; external Qt4PasLib name 'QInputEvent_create';
procedure QInputEvent_destroy(handle: QInputEventH); cdecl; external Qt4PasLib name 'QInputEvent_destroy'; 
function QInputEvent_modifiers(handle: QInputEventH): QtKeyboardModifiers; cdecl; external Qt4PasLib name 'QInputEvent_modifiers';

function QMouseEvent_create(_type: QEventType; pos: PQtPoint; button: QtMouseButton; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QMouseEventH; cdecl; external Qt4PasLib name 'QMouseEvent_create';
procedure QMouseEvent_destroy(handle: QMouseEventH); cdecl; external Qt4PasLib name 'QMouseEvent_destroy'; 
function QMouseEvent_create(_type: QEventType; pos: PQtPoint; globalPos: PQtPoint; button: QtMouseButton; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QMouseEventH; cdecl; external Qt4PasLib name 'QMouseEvent_create2';
function QMouseEvent_pos(handle: QMouseEventH): PQtPoint; cdecl; external Qt4PasLib name 'QMouseEvent_pos';
function QMouseEvent_globalPos(handle: QMouseEventH): PQtPoint; cdecl; external Qt4PasLib name 'QMouseEvent_globalPos';
function QMouseEvent_x(handle: QMouseEventH): Integer; cdecl; external Qt4PasLib name 'QMouseEvent_x';
function QMouseEvent_y(handle: QMouseEventH): Integer; cdecl; external Qt4PasLib name 'QMouseEvent_y';
function QMouseEvent_globalX(handle: QMouseEventH): Integer; cdecl; external Qt4PasLib name 'QMouseEvent_globalX';
function QMouseEvent_globalY(handle: QMouseEventH): Integer; cdecl; external Qt4PasLib name 'QMouseEvent_globalY';
function QMouseEvent_button(handle: QMouseEventH): QtMouseButton; cdecl; external Qt4PasLib name 'QMouseEvent_button';
function QMouseEvent_buttons(handle: QMouseEventH): QtMouseButtons; cdecl; external Qt4PasLib name 'QMouseEvent_buttons';
function QMouseEvent_createExtendedMouseEvent(_type: QEventType; pos: PQtPointF; globalPos: PQtPoint; button: QtMouseButton; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QMouseEventH; cdecl; external Qt4PasLib name 'QMouseEvent_createExtendedMouseEvent';
function QMouseEvent_hasExtendedInfo(handle: QMouseEventH): Boolean; cdecl; external Qt4PasLib name 'QMouseEvent_hasExtendedInfo';
procedure QMouseEvent_posF(handle: QMouseEventH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QMouseEvent_posF';

function QHoverEvent_create(_type: QEventType; pos: PQtPoint; oldPos: PQtPoint): QHoverEventH; cdecl; external Qt4PasLib name 'QHoverEvent_create';
procedure QHoverEvent_destroy(handle: QHoverEventH); cdecl; external Qt4PasLib name 'QHoverEvent_destroy'; 
function QHoverEvent_pos(handle: QHoverEventH): PQtPoint; cdecl; external Qt4PasLib name 'QHoverEvent_pos';
function QHoverEvent_oldPos(handle: QHoverEventH): PQtPoint; cdecl; external Qt4PasLib name 'QHoverEvent_oldPos';

function QWheelEvent_create(pos: PQtPoint; delta: Integer; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers; orient: QtOrientation = QtVertical): QWheelEventH; cdecl; external Qt4PasLib name 'QWheelEvent_create';
procedure QWheelEvent_destroy(handle: QWheelEventH); cdecl; external Qt4PasLib name 'QWheelEvent_destroy'; 
function QWheelEvent_create(pos: PQtPoint; globalPos: PQtPoint; delta: Integer; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers; orient: QtOrientation = QtVertical): QWheelEventH; cdecl; external Qt4PasLib name 'QWheelEvent_create2';
function QWheelEvent_delta(handle: QWheelEventH): Integer; cdecl; external Qt4PasLib name 'QWheelEvent_delta';
function QWheelEvent_pos(handle: QWheelEventH): PQtPoint; cdecl; external Qt4PasLib name 'QWheelEvent_pos';
function QWheelEvent_globalPos(handle: QWheelEventH): PQtPoint; cdecl; external Qt4PasLib name 'QWheelEvent_globalPos';
function QWheelEvent_x(handle: QWheelEventH): Integer; cdecl; external Qt4PasLib name 'QWheelEvent_x';
function QWheelEvent_y(handle: QWheelEventH): Integer; cdecl; external Qt4PasLib name 'QWheelEvent_y';
function QWheelEvent_globalX(handle: QWheelEventH): Integer; cdecl; external Qt4PasLib name 'QWheelEvent_globalX';
function QWheelEvent_globalY(handle: QWheelEventH): Integer; cdecl; external Qt4PasLib name 'QWheelEvent_globalY';
function QWheelEvent_buttons(handle: QWheelEventH): QtMouseButtons; cdecl; external Qt4PasLib name 'QWheelEvent_buttons';
function QWheelEvent_orientation(handle: QWheelEventH): QtOrientation; cdecl; external Qt4PasLib name 'QWheelEvent_orientation';

function QTabletEvent_create(t: QEventType; pos: PQtPoint; globalPos: PQtPoint; hiResGlobalPos: PQtPointF; device: Integer; pointerType: Integer; pressure: qreal; xTilt: Integer; yTilt: Integer; tangentialPressure: qreal; rotation: qreal; z: Integer; keyState: QtKeyboardModifiers; uniqueID: int64): QTabletEventH; cdecl; external Qt4PasLib name 'QTabletEvent_create';
procedure QTabletEvent_destroy(handle: QTabletEventH); cdecl; external Qt4PasLib name 'QTabletEvent_destroy'; 
function QTabletEvent_pos(handle: QTabletEventH): PQtPoint; cdecl; external Qt4PasLib name 'QTabletEvent_pos';
function QTabletEvent_globalPos(handle: QTabletEventH): PQtPoint; cdecl; external Qt4PasLib name 'QTabletEvent_globalPos';
function QTabletEvent_hiResGlobalPos(handle: QTabletEventH): PQtPointF; cdecl; external Qt4PasLib name 'QTabletEvent_hiResGlobalPos';
function QTabletEvent_x(handle: QTabletEventH): Integer; cdecl; external Qt4PasLib name 'QTabletEvent_x';
function QTabletEvent_y(handle: QTabletEventH): Integer; cdecl; external Qt4PasLib name 'QTabletEvent_y';
function QTabletEvent_globalX(handle: QTabletEventH): Integer; cdecl; external Qt4PasLib name 'QTabletEvent_globalX';
function QTabletEvent_globalY(handle: QTabletEventH): Integer; cdecl; external Qt4PasLib name 'QTabletEvent_globalY';
function QTabletEvent_hiResGlobalX(handle: QTabletEventH): qreal; cdecl; external Qt4PasLib name 'QTabletEvent_hiResGlobalX';
function QTabletEvent_hiResGlobalY(handle: QTabletEventH): qreal; cdecl; external Qt4PasLib name 'QTabletEvent_hiResGlobalY';
function QTabletEvent_device(handle: QTabletEventH): QTabletEventTabletDevice; cdecl; external Qt4PasLib name 'QTabletEvent_device';
function QTabletEvent_pointerType(handle: QTabletEventH): QTabletEventPointerType; cdecl; external Qt4PasLib name 'QTabletEvent_pointerType';
function QTabletEvent_uniqueId(handle: QTabletEventH): int64; cdecl; external Qt4PasLib name 'QTabletEvent_uniqueId';
function QTabletEvent_pressure(handle: QTabletEventH): qreal; cdecl; external Qt4PasLib name 'QTabletEvent_pressure';
function QTabletEvent_z(handle: QTabletEventH): Integer; cdecl; external Qt4PasLib name 'QTabletEvent_z';
function QTabletEvent_tangentialPressure(handle: QTabletEventH): qreal; cdecl; external Qt4PasLib name 'QTabletEvent_tangentialPressure';
function QTabletEvent_rotation(handle: QTabletEventH): qreal; cdecl; external Qt4PasLib name 'QTabletEvent_rotation';
function QTabletEvent_xTilt(handle: QTabletEventH): Integer; cdecl; external Qt4PasLib name 'QTabletEvent_xTilt';
function QTabletEvent_yTilt(handle: QTabletEventH): Integer; cdecl; external Qt4PasLib name 'QTabletEvent_yTilt';

function QKeyEvent_create(_type: QEventType; key: Integer; modifiers: QtKeyboardModifiers; text: PWideString = nil; autorep: Boolean = False; count: Word = 1): QKeyEventH; cdecl; external Qt4PasLib name 'QKeyEvent_create';
procedure QKeyEvent_destroy(handle: QKeyEventH); cdecl; external Qt4PasLib name 'QKeyEvent_destroy'; 
function QKeyEvent_key(handle: QKeyEventH): Integer; cdecl; external Qt4PasLib name 'QKeyEvent_key';
function QKeyEvent_matches(handle: QKeyEventH; key: QKeySequenceStandardKey): Boolean; cdecl; external Qt4PasLib name 'QKeyEvent_matches';
function QKeyEvent_modifiers(handle: QKeyEventH): QtKeyboardModifiers; cdecl; external Qt4PasLib name 'QKeyEvent_modifiers';
procedure QKeyEvent_text(handle: QKeyEventH; retval: PWideString); cdecl; external Qt4PasLib name 'QKeyEvent_text';
function QKeyEvent_isAutoRepeat(handle: QKeyEventH): Boolean; cdecl; external Qt4PasLib name 'QKeyEvent_isAutoRepeat';
function QKeyEvent_count(handle: QKeyEventH): Integer; cdecl; external Qt4PasLib name 'QKeyEvent_count';
function QKeyEvent_createExtendedKeyEvent(_type: QEventType; key: Integer; modifiers: QtKeyboardModifiers; nativeScanCode: LongWord; nativeVirtualKey: LongWord; nativeModifiers: LongWord; text: PWideString = nil; autorep: Boolean = False; count: Word = 1): QKeyEventH; cdecl; external Qt4PasLib name 'QKeyEvent_createExtendedKeyEvent';
function QKeyEvent_hasExtendedInfo(handle: QKeyEventH): Boolean; cdecl; external Qt4PasLib name 'QKeyEvent_hasExtendedInfo';
function QKeyEvent_nativeScanCode(handle: QKeyEventH): LongWord; cdecl; external Qt4PasLib name 'QKeyEvent_nativeScanCode';
function QKeyEvent_nativeVirtualKey(handle: QKeyEventH): LongWord; cdecl; external Qt4PasLib name 'QKeyEvent_nativeVirtualKey';
function QKeyEvent_nativeModifiers(handle: QKeyEventH): LongWord; cdecl; external Qt4PasLib name 'QKeyEvent_nativeModifiers';

function QFocusEvent_create(_type: QEventType; reason: QtFocusReason = QtOtherFocusReason): QFocusEventH; cdecl; external Qt4PasLib name 'QFocusEvent_create';
procedure QFocusEvent_destroy(handle: QFocusEventH); cdecl; external Qt4PasLib name 'QFocusEvent_destroy'; 
function QFocusEvent_gotFocus(handle: QFocusEventH): Boolean; cdecl; external Qt4PasLib name 'QFocusEvent_gotFocus';
function QFocusEvent_lostFocus(handle: QFocusEventH): Boolean; cdecl; external Qt4PasLib name 'QFocusEvent_lostFocus';
function QFocusEvent_reason(handle: QFocusEventH): QtFocusReason; cdecl; external Qt4PasLib name 'QFocusEvent_reason';

function QPaintEvent_create(paintRegion: QRegionH): QPaintEventH; cdecl; external Qt4PasLib name 'QPaintEvent_create';
procedure QPaintEvent_destroy(handle: QPaintEventH); cdecl; external Qt4PasLib name 'QPaintEvent_destroy'; 
function QPaintEvent_create(paintRect: PRect): QPaintEventH; cdecl; external Qt4PasLib name 'QPaintEvent_create2';
procedure QPaintEvent_rect(handle: QPaintEventH; retval: PRect); cdecl; external Qt4PasLib name 'QPaintEvent_rect';
function QPaintEvent_region(handle: QPaintEventH): QRegionH; cdecl; external Qt4PasLib name 'QPaintEvent_region';

function QMoveEvent_create(pos: PQtPoint; oldPos: PQtPoint): QMoveEventH; cdecl; external Qt4PasLib name 'QMoveEvent_create';
procedure QMoveEvent_destroy(handle: QMoveEventH); cdecl; external Qt4PasLib name 'QMoveEvent_destroy'; 
function QMoveEvent_pos(handle: QMoveEventH): PQtPoint; cdecl; external Qt4PasLib name 'QMoveEvent_pos';
function QMoveEvent_oldPos(handle: QMoveEventH): PQtPoint; cdecl; external Qt4PasLib name 'QMoveEvent_oldPos';

function QResizeEvent_create(size: PSize; oldSize: PSize): QResizeEventH; cdecl; external Qt4PasLib name 'QResizeEvent_create';
procedure QResizeEvent_destroy(handle: QResizeEventH); cdecl; external Qt4PasLib name 'QResizeEvent_destroy'; 
function QResizeEvent_size(handle: QResizeEventH): PSize; cdecl; external Qt4PasLib name 'QResizeEvent_size';
function QResizeEvent_oldSize(handle: QResizeEventH): PSize; cdecl; external Qt4PasLib name 'QResizeEvent_oldSize';

function QCloseEvent_create(): QCloseEventH; cdecl; external Qt4PasLib name 'QCloseEvent_create';
procedure QCloseEvent_destroy(handle: QCloseEventH); cdecl; external Qt4PasLib name 'QCloseEvent_destroy'; 

function QIconDragEvent_create(): QIconDragEventH; cdecl; external Qt4PasLib name 'QIconDragEvent_create';
procedure QIconDragEvent_destroy(handle: QIconDragEventH); cdecl; external Qt4PasLib name 'QIconDragEvent_destroy'; 

function QShowEvent_create(): QShowEventH; cdecl; external Qt4PasLib name 'QShowEvent_create';
procedure QShowEvent_destroy(handle: QShowEventH); cdecl; external Qt4PasLib name 'QShowEvent_destroy'; 

function QHideEvent_create(): QHideEventH; cdecl; external Qt4PasLib name 'QHideEvent_create';
procedure QHideEvent_destroy(handle: QHideEventH); cdecl; external Qt4PasLib name 'QHideEvent_destroy'; 

function QContextMenuEvent_create(reason: QContextMenuEventReason; pos: PQtPoint; globalPos: PQtPoint; modifiers: QtKeyboardModifiers): QContextMenuEventH; cdecl; external Qt4PasLib name 'QContextMenuEvent_create';
procedure QContextMenuEvent_destroy(handle: QContextMenuEventH); cdecl; external Qt4PasLib name 'QContextMenuEvent_destroy'; 
function QContextMenuEvent_create(reason: QContextMenuEventReason; pos: PQtPoint; globalPos: PQtPoint): QContextMenuEventH; cdecl; external Qt4PasLib name 'QContextMenuEvent_create2';
function QContextMenuEvent_create(reason: QContextMenuEventReason; pos: PQtPoint): QContextMenuEventH; cdecl; external Qt4PasLib name 'QContextMenuEvent_create3';
function QContextMenuEvent_x(handle: QContextMenuEventH): Integer; cdecl; external Qt4PasLib name 'QContextMenuEvent_x';
function QContextMenuEvent_y(handle: QContextMenuEventH): Integer; cdecl; external Qt4PasLib name 'QContextMenuEvent_y';
function QContextMenuEvent_globalX(handle: QContextMenuEventH): Integer; cdecl; external Qt4PasLib name 'QContextMenuEvent_globalX';
function QContextMenuEvent_globalY(handle: QContextMenuEventH): Integer; cdecl; external Qt4PasLib name 'QContextMenuEvent_globalY';
function QContextMenuEvent_pos(handle: QContextMenuEventH): PQtPoint; cdecl; external Qt4PasLib name 'QContextMenuEvent_pos';
function QContextMenuEvent_globalPos(handle: QContextMenuEventH): PQtPoint; cdecl; external Qt4PasLib name 'QContextMenuEvent_globalPos';
function QContextMenuEvent_reason(handle: QContextMenuEventH): QContextMenuEventReason; cdecl; external Qt4PasLib name 'QContextMenuEvent_reason';

function QInputMethodEvent_create(): QInputMethodEventH; cdecl; external Qt4PasLib name 'QInputMethodEvent_create';
procedure QInputMethodEvent_destroy(handle: QInputMethodEventH); cdecl; external Qt4PasLib name 'QInputMethodEvent_destroy'; 
procedure QInputMethodEvent_setCommitString(handle: QInputMethodEventH; commitString: PWideString; replaceFrom: Integer = 0; replaceLength: Integer = 0); cdecl; external Qt4PasLib name 'QInputMethodEvent_setCommitString';
procedure QInputMethodEvent_preeditString(handle: QInputMethodEventH; retval: PWideString); cdecl; external Qt4PasLib name 'QInputMethodEvent_preeditString';
procedure QInputMethodEvent_commitString(handle: QInputMethodEventH; retval: PWideString); cdecl; external Qt4PasLib name 'QInputMethodEvent_commitString';
function QInputMethodEvent_replacementStart(handle: QInputMethodEventH): Integer; cdecl; external Qt4PasLib name 'QInputMethodEvent_replacementStart';
function QInputMethodEvent_replacementLength(handle: QInputMethodEventH): Integer; cdecl; external Qt4PasLib name 'QInputMethodEvent_replacementLength';
function QInputMethodEvent_create(other: QInputMethodEventH): QInputMethodEventH; cdecl; external Qt4PasLib name 'QInputMethodEvent_create3';

function QDropEvent_create(pos: PQtPoint; actions: QtDropActions; data: QMimeDataH; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers; _type: QEventType): QDropEventH; cdecl; external Qt4PasLib name 'QDropEvent_create';
procedure QDropEvent_destroy(handle: QDropEventH); cdecl; external Qt4PasLib name 'QDropEvent_destroy'; 
function QDropEvent_pos(handle: QDropEventH): PQtPoint; cdecl; external Qt4PasLib name 'QDropEvent_pos';
function QDropEvent_mouseButtons(handle: QDropEventH): QtMouseButtons; cdecl; external Qt4PasLib name 'QDropEvent_mouseButtons';
function QDropEvent_keyboardModifiers(handle: QDropEventH): QtKeyboardModifiers; cdecl; external Qt4PasLib name 'QDropEvent_keyboardModifiers';
function QDropEvent_possibleActions(handle: QDropEventH): QtDropActions; cdecl; external Qt4PasLib name 'QDropEvent_possibleActions';
function QDropEvent_proposedAction(handle: QDropEventH): QtDropAction; cdecl; external Qt4PasLib name 'QDropEvent_proposedAction';
procedure QDropEvent_acceptProposedAction(handle: QDropEventH); cdecl; external Qt4PasLib name 'QDropEvent_acceptProposedAction';
function QDropEvent_dropAction(handle: QDropEventH): QtDropAction; cdecl; external Qt4PasLib name 'QDropEvent_dropAction';
procedure QDropEvent_setDropAction(handle: QDropEventH; action: QtDropAction); cdecl; external Qt4PasLib name 'QDropEvent_setDropAction';
function QDropEvent_source(handle: QDropEventH): QWidgetH; cdecl; external Qt4PasLib name 'QDropEvent_source';
function QDropEvent_mimeData(handle: QDropEventH): QMimeDataH; cdecl; external Qt4PasLib name 'QDropEvent_mimeData';
function QDropEvent_format(handle: QDropEventH; n: Integer = 0): PAnsiChar; cdecl; external Qt4PasLib name 'QDropEvent_format';
procedure QDropEvent_encodedData(handle: QDropEventH; retval: QByteArrayH; p1: PAnsiChar); cdecl; external Qt4PasLib name 'QDropEvent_encodedData';
function QDropEvent_provides(handle: QDropEventH; p1: PAnsiChar): Boolean; cdecl; external Qt4PasLib name 'QDropEvent_provides';

function QDragMoveEvent_create(pos: PQtPoint; actions: QtDropActions; data: QMimeDataH; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers; _type: QEventType): QDragMoveEventH; cdecl; external Qt4PasLib name 'QDragMoveEvent_create';
procedure QDragMoveEvent_destroy(handle: QDragMoveEventH); cdecl; external Qt4PasLib name 'QDragMoveEvent_destroy'; 
procedure QDragMoveEvent_answerRect(handle: QDragMoveEventH; retval: PRect); cdecl; external Qt4PasLib name 'QDragMoveEvent_answerRect';
procedure QDragMoveEvent_accept(handle: QDragMoveEventH); cdecl; external Qt4PasLib name 'QDragMoveEvent_accept';
procedure QDragMoveEvent_ignore(handle: QDragMoveEventH); cdecl; external Qt4PasLib name 'QDragMoveEvent_ignore';
procedure QDragMoveEvent_accept(handle: QDragMoveEventH; r: PRect); cdecl; external Qt4PasLib name 'QDragMoveEvent_accept2';
procedure QDragMoveEvent_ignore(handle: QDragMoveEventH; r: PRect); cdecl; external Qt4PasLib name 'QDragMoveEvent_ignore2';

function QDragEnterEvent_create(pos: PQtPoint; actions: QtDropActions; data: QMimeDataH; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QDragEnterEventH; cdecl; external Qt4PasLib name 'QDragEnterEvent_create';
procedure QDragEnterEvent_destroy(handle: QDragEnterEventH); cdecl; external Qt4PasLib name 'QDragEnterEvent_destroy'; 

function QDragLeaveEvent_create(): QDragLeaveEventH; cdecl; external Qt4PasLib name 'QDragLeaveEvent_create';
procedure QDragLeaveEvent_destroy(handle: QDragLeaveEventH); cdecl; external Qt4PasLib name 'QDragLeaveEvent_destroy'; 

function QHelpEvent_create(_type: QEventType; pos: PQtPoint; globalPos: PQtPoint): QHelpEventH; cdecl; external Qt4PasLib name 'QHelpEvent_create';
procedure QHelpEvent_destroy(handle: QHelpEventH); cdecl; external Qt4PasLib name 'QHelpEvent_destroy'; 
function QHelpEvent_x(handle: QHelpEventH): Integer; cdecl; external Qt4PasLib name 'QHelpEvent_x';
function QHelpEvent_y(handle: QHelpEventH): Integer; cdecl; external Qt4PasLib name 'QHelpEvent_y';
function QHelpEvent_globalX(handle: QHelpEventH): Integer; cdecl; external Qt4PasLib name 'QHelpEvent_globalX';
function QHelpEvent_globalY(handle: QHelpEventH): Integer; cdecl; external Qt4PasLib name 'QHelpEvent_globalY';
function QHelpEvent_pos(handle: QHelpEventH): PQtPoint; cdecl; external Qt4PasLib name 'QHelpEvent_pos';
function QHelpEvent_globalPos(handle: QHelpEventH): PQtPoint; cdecl; external Qt4PasLib name 'QHelpEvent_globalPos';

function QStatusTipEvent_create(tip: PWideString): QStatusTipEventH; cdecl; external Qt4PasLib name 'QStatusTipEvent_create';
procedure QStatusTipEvent_destroy(handle: QStatusTipEventH); cdecl; external Qt4PasLib name 'QStatusTipEvent_destroy'; 
procedure QStatusTipEvent_tip(handle: QStatusTipEventH; retval: PWideString); cdecl; external Qt4PasLib name 'QStatusTipEvent_tip';

function QWhatsThisClickedEvent_create(href: PWideString): QWhatsThisClickedEventH; cdecl; external Qt4PasLib name 'QWhatsThisClickedEvent_create';
procedure QWhatsThisClickedEvent_destroy(handle: QWhatsThisClickedEventH); cdecl; external Qt4PasLib name 'QWhatsThisClickedEvent_destroy'; 
procedure QWhatsThisClickedEvent_href(handle: QWhatsThisClickedEventH; retval: PWideString); cdecl; external Qt4PasLib name 'QWhatsThisClickedEvent_href';

function QActionEvent_create(_type: Integer; action: QActionH; before: QActionH = nil): QActionEventH; cdecl; external Qt4PasLib name 'QActionEvent_create';
procedure QActionEvent_destroy(handle: QActionEventH); cdecl; external Qt4PasLib name 'QActionEvent_destroy'; 
function QActionEvent_action(handle: QActionEventH): QActionH; cdecl; external Qt4PasLib name 'QActionEvent_action';
function QActionEvent_before(handle: QActionEventH): QActionH; cdecl; external Qt4PasLib name 'QActionEvent_before';

function QFileOpenEvent_create(_file: PWideString): QFileOpenEventH; cdecl; external Qt4PasLib name 'QFileOpenEvent_create';
procedure QFileOpenEvent_destroy(handle: QFileOpenEventH); cdecl; external Qt4PasLib name 'QFileOpenEvent_destroy'; 
procedure QFileOpenEvent_file(handle: QFileOpenEventH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileOpenEvent_file';

function QShortcutEvent_create(key: QKeySequenceH; id: Integer; ambiguous: Boolean = False): QShortcutEventH; cdecl; external Qt4PasLib name 'QShortcutEvent_create';
procedure QShortcutEvent_destroy(handle: QShortcutEventH); cdecl; external Qt4PasLib name 'QShortcutEvent_destroy'; 
function QShortcutEvent_key(handle: QShortcutEventH): QKeySequenceH; cdecl; external Qt4PasLib name 'QShortcutEvent_key';
function QShortcutEvent_shortcutId(handle: QShortcutEventH): Integer; cdecl; external Qt4PasLib name 'QShortcutEvent_shortcutId';
function QShortcutEvent_isAmbiguous(handle: QShortcutEventH): Boolean; cdecl; external Qt4PasLib name 'QShortcutEvent_isAmbiguous';

function QWindowStateChangeEvent_create(aOldState: QtWindowStates): QWindowStateChangeEventH; cdecl; external Qt4PasLib name 'QWindowStateChangeEvent_create';
procedure QWindowStateChangeEvent_destroy(handle: QWindowStateChangeEventH); cdecl; external Qt4PasLib name 'QWindowStateChangeEvent_destroy'; 
function QWindowStateChangeEvent_create(aOldState: QtWindowStates; isOverride: Boolean): QWindowStateChangeEventH; cdecl; external Qt4PasLib name 'QWindowStateChangeEvent_create2';
function QWindowStateChangeEvent_oldState(handle: QWindowStateChangeEventH): QtWindowStates; cdecl; external Qt4PasLib name 'QWindowStateChangeEvent_oldState';
function QWindowStateChangeEvent_isOverride(handle: QWindowStateChangeEventH): Boolean; cdecl; external Qt4PasLib name 'QWindowStateChangeEvent_isOverride';

function QLCLMessageEvent_create(aType: QEventType): QLCLMessageEventH; cdecl; external Qt4PasLib name 'QLCLMessageEvent_create';
procedure QLCLMessageEvent_destroy(handle: QLCLMessageEventH); cdecl; external Qt4PasLib name 'QLCLMessageEvent_destroy'; 
function QLCLMessageEvent_create(aType: QEventType; aMsg: PTRUINT; aWParam: PTRUINT; aLParam: PTRUINT; aMsgResult: PTRUINT): QLCLMessageEventH; cdecl; external Qt4PasLib name 'QLCLMessageEvent_create2';
function QLCLMessageEvent_getMsg(handle: QLCLMessageEventH): PTRUINT; cdecl; external Qt4PasLib name 'QLCLMessageEvent_getMsg';
function QLCLMessageEvent_getWParam(handle: QLCLMessageEventH): PTRUINT; cdecl; external Qt4PasLib name 'QLCLMessageEvent_getWParam';
function QLCLMessageEvent_getLParam(handle: QLCLMessageEventH): PTRUINT; cdecl; external Qt4PasLib name 'QLCLMessageEvent_getLParam';
function QLCLMessageEvent_getMsgResult(handle: QLCLMessageEventH): PTRUINT; cdecl; external Qt4PasLib name 'QLCLMessageEvent_getMsgResult';
procedure QLCLMessageEvent_setMsg(handle: QLCLMessageEventH; Value: PTRUINT); cdecl; external Qt4PasLib name 'QLCLMessageEvent_setMsg';
procedure QLCLMessageEvent_setWParam(handle: QLCLMessageEventH; Value: PTRUINT); cdecl; external Qt4PasLib name 'QLCLMessageEvent_setWParam';
procedure QLCLMessageEvent_setLParam(handle: QLCLMessageEventH; Value: PTRUINT); cdecl; external Qt4PasLib name 'QLCLMessageEvent_setLParam';
procedure QLCLMessageEvent_setMsgResult(handle: QLCLMessageEventH; Value: PTRUINT); cdecl; external Qt4PasLib name 'QLCLMessageEvent_setMsgResult';

function QCursor_create(): QCursorH; cdecl; external Qt4PasLib name 'QCursor_create';
procedure QCursor_destroy(handle: QCursorH); cdecl; external Qt4PasLib name 'QCursor_destroy'; 
function QCursor_create(shape: QtCursorShape): QCursorH; cdecl; external Qt4PasLib name 'QCursor_create2';
function QCursor_create(bitmap: QBitmapH; mask: QBitmapH; hotX: Integer = -1; hotY: Integer = -1): QCursorH; cdecl; external Qt4PasLib name 'QCursor_create3';
function QCursor_create(pixmap: QPixmapH; hotX: Integer = -1; hotY: Integer = -1): QCursorH; cdecl; external Qt4PasLib name 'QCursor_create4';
function QCursor_create(cursor: QCursorH): QCursorH; cdecl; external Qt4PasLib name 'QCursor_create5';
function QCursor_shape(handle: QCursorH): QtCursorShape; cdecl; external Qt4PasLib name 'QCursor_shape';
procedure QCursor_setShape(handle: QCursorH; newShape: QtCursorShape); cdecl; external Qt4PasLib name 'QCursor_setShape';
function QCursor_bitmap(handle: QCursorH): QBitmapH; cdecl; external Qt4PasLib name 'QCursor_bitmap';
function QCursor_mask(handle: QCursorH): QBitmapH; cdecl; external Qt4PasLib name 'QCursor_mask';
procedure QCursor_pixmap(handle: QCursorH; retval: QPixmapH); cdecl; external Qt4PasLib name 'QCursor_pixmap';
procedure QCursor_hotSpot(handle: QCursorH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QCursor_hotSpot';
procedure QCursor_pos(retval: PQtPoint); cdecl; external Qt4PasLib name 'QCursor_pos';
procedure QCursor_setPos(x: Integer; y: Integer); cdecl; external Qt4PasLib name 'QCursor_setPos';
procedure QCursor_setPos(p: PQtPoint); cdecl; external Qt4PasLib name 'QCursor_setPos2';
{$ifdef BINUX or DARWIN }
function QCursor_handle(handle: QCursorH): QtHANDLE; cdecl; external Qt4PasLib name 'QCursor_handle';
{$endif}
{$ifdef BINUX }
function QCursor_create(cursor: QtHANDLE): QCursorH; cdecl; external Qt4PasLib name 'QCursor_create6';
function QCursor_x11Screen(): Integer; cdecl; external Qt4PasLib name 'QCursor_x11Screen';
{$endif}
{$ifdef MSWINDOWS }
function QCursor_handle(handle: QCursorH): QHCURSOR; cdecl; external Qt4PasLib name 'QCursor_handle2';
function QCursor_create(cursor: QHCURSOR): QCursorH; cdecl; external Qt4PasLib name 'QCursor_create7';
{$endif}
{$ifdef QTOPIA }
function QCursor_handle(handle: QCursorH): Integer; cdecl; external Qt4PasLib name 'QCursor_handle3';
{$endif}

function QGridLayout_create(parent: QWidgetH): QGridLayoutH; cdecl; external Qt4PasLib name 'QGridLayout_create';
procedure QGridLayout_destroy(handle: QGridLayoutH); cdecl; external Qt4PasLib name 'QGridLayout_destroy'; 
function QGridLayout_create(): QGridLayoutH; cdecl; external Qt4PasLib name 'QGridLayout_create2';
procedure QGridLayout_sizeHint(handle: QGridLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QGridLayout_sizeHint';
procedure QGridLayout_minimumSize(handle: QGridLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QGridLayout_minimumSize';
procedure QGridLayout_maximumSize(handle: QGridLayoutH; retval: PSize); cdecl; external Qt4PasLib name 'QGridLayout_maximumSize';
procedure QGridLayout_setHorizontalSpacing(handle: QGridLayoutH; spacing: Integer); cdecl; external Qt4PasLib name 'QGridLayout_setHorizontalSpacing';
function QGridLayout_horizontalSpacing(handle: QGridLayoutH): Integer; cdecl; external Qt4PasLib name 'QGridLayout_horizontalSpacing';
procedure QGridLayout_setVerticalSpacing(handle: QGridLayoutH; spacing: Integer); cdecl; external Qt4PasLib name 'QGridLayout_setVerticalSpacing';
function QGridLayout_verticalSpacing(handle: QGridLayoutH): Integer; cdecl; external Qt4PasLib name 'QGridLayout_verticalSpacing';
procedure QGridLayout_setSpacing(handle: QGridLayoutH; spacing: Integer); cdecl; external Qt4PasLib name 'QGridLayout_setSpacing';
function QGridLayout_spacing(handle: QGridLayoutH): Integer; cdecl; external Qt4PasLib name 'QGridLayout_spacing';
procedure QGridLayout_setRowStretch(handle: QGridLayoutH; row: Integer; stretch: Integer); cdecl; external Qt4PasLib name 'QGridLayout_setRowStretch';
procedure QGridLayout_setColumnStretch(handle: QGridLayoutH; column: Integer; stretch: Integer); cdecl; external Qt4PasLib name 'QGridLayout_setColumnStretch';
function QGridLayout_rowStretch(handle: QGridLayoutH; row: Integer): Integer; cdecl; external Qt4PasLib name 'QGridLayout_rowStretch';
function QGridLayout_columnStretch(handle: QGridLayoutH; column: Integer): Integer; cdecl; external Qt4PasLib name 'QGridLayout_columnStretch';
procedure QGridLayout_setRowMinimumHeight(handle: QGridLayoutH; row: Integer; minSize: Integer); cdecl; external Qt4PasLib name 'QGridLayout_setRowMinimumHeight';
procedure QGridLayout_setColumnMinimumWidth(handle: QGridLayoutH; column: Integer; minSize: Integer); cdecl; external Qt4PasLib name 'QGridLayout_setColumnMinimumWidth';
function QGridLayout_rowMinimumHeight(handle: QGridLayoutH; row: Integer): Integer; cdecl; external Qt4PasLib name 'QGridLayout_rowMinimumHeight';
function QGridLayout_columnMinimumWidth(handle: QGridLayoutH; column: Integer): Integer; cdecl; external Qt4PasLib name 'QGridLayout_columnMinimumWidth';
function QGridLayout_columnCount(handle: QGridLayoutH): Integer; cdecl; external Qt4PasLib name 'QGridLayout_columnCount';
function QGridLayout_rowCount(handle: QGridLayoutH): Integer; cdecl; external Qt4PasLib name 'QGridLayout_rowCount';
procedure QGridLayout_cellRect(handle: QGridLayoutH; retval: PRect; row: Integer; column: Integer); cdecl; external Qt4PasLib name 'QGridLayout_cellRect';
function QGridLayout_hasHeightForWidth(handle: QGridLayoutH): Boolean; cdecl; external Qt4PasLib name 'QGridLayout_hasHeightForWidth';
function QGridLayout_heightForWidth(handle: QGridLayoutH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QGridLayout_heightForWidth';
function QGridLayout_minimumHeightForWidth(handle: QGridLayoutH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QGridLayout_minimumHeightForWidth';
function QGridLayout_expandingDirections(handle: QGridLayoutH): QtOrientations; cdecl; external Qt4PasLib name 'QGridLayout_expandingDirections';
procedure QGridLayout_invalidate(handle: QGridLayoutH); cdecl; external Qt4PasLib name 'QGridLayout_invalidate';
procedure QGridLayout_addWidget(handle: QGridLayoutH; w: QWidgetH); cdecl; external Qt4PasLib name 'QGridLayout_addWidget';
procedure QGridLayout_addWidget(handle: QGridLayoutH; p1: QWidgetH; row: Integer; column: Integer; p4: QtAlignment = 0); cdecl; external Qt4PasLib name 'QGridLayout_addWidget2';
procedure QGridLayout_addWidget(handle: QGridLayoutH; p1: QWidgetH; row: Integer; column: Integer; rowSpan: Integer; columnSpan: Integer; p6: QtAlignment = 0); cdecl; external Qt4PasLib name 'QGridLayout_addWidget3';
procedure QGridLayout_addLayout(handle: QGridLayoutH; p1: QLayoutH; row: Integer; column: Integer; p4: QtAlignment = 0); cdecl; external Qt4PasLib name 'QGridLayout_addLayout';
procedure QGridLayout_addLayout(handle: QGridLayoutH; p1: QLayoutH; row: Integer; column: Integer; rowSpan: Integer; columnSpan: Integer; p6: QtAlignment = 0); cdecl; external Qt4PasLib name 'QGridLayout_addLayout2';
procedure QGridLayout_setOriginCorner(handle: QGridLayoutH; p1: QtCorner); cdecl; external Qt4PasLib name 'QGridLayout_setOriginCorner';
function QGridLayout_originCorner(handle: QGridLayoutH): QtCorner; cdecl; external Qt4PasLib name 'QGridLayout_originCorner';
function QGridLayout_itemAt(handle: QGridLayoutH; index: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QGridLayout_itemAt';
function QGridLayout_itemAtPosition(handle: QGridLayoutH; row: Integer; column: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QGridLayout_itemAtPosition';
function QGridLayout_takeAt(handle: QGridLayoutH; index: Integer): QLayoutItemH; cdecl; external Qt4PasLib name 'QGridLayout_takeAt';
function QGridLayout_count(handle: QGridLayoutH): Integer; cdecl; external Qt4PasLib name 'QGridLayout_count';
procedure QGridLayout_setGeometry(handle: QGridLayoutH; p1: PRect); cdecl; external Qt4PasLib name 'QGridLayout_setGeometry';
procedure QGridLayout_addItem(handle: QGridLayoutH; item: QLayoutItemH; row: Integer; column: Integer; rowSpan: Integer = 1; columnSpan: Integer = 1; p6: QtAlignment = 0); cdecl; external Qt4PasLib name 'QGridLayout_addItem';
procedure QGridLayout_setDefaultPositioning(handle: QGridLayoutH; n: Integer; orient: QtOrientation); cdecl; external Qt4PasLib name 'QGridLayout_setDefaultPositioning';
procedure QGridLayout_getItemPosition(handle: QGridLayoutH; idx: Integer; row: PInteger; column: PInteger; rowSpan: PInteger; columnSpan: PInteger); cdecl; external Qt4PasLib name 'QGridLayout_getItemPosition';

type
  QClipboardMode = cardinal; //  QClipboard::Mode (4)

const
    QClipboardClipboard = 0 { $0 };
    QClipboardSelection = 1 { $1 };
    QClipboardFindBuffer = 2 { $2 };
    QClipboardLastMode = 2 { $2 };


procedure QClipboard_clear(handle: QClipboardH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_clear';
function QClipboard_supportsSelection(handle: QClipboardH): Boolean; cdecl; external Qt4PasLib name 'QClipboard_supportsSelection';
function QClipboard_supportsFindBuffer(handle: QClipboardH): Boolean; cdecl; external Qt4PasLib name 'QClipboard_supportsFindBuffer';
function QClipboard_ownsSelection(handle: QClipboardH): Boolean; cdecl; external Qt4PasLib name 'QClipboard_ownsSelection';
function QClipboard_ownsClipboard(handle: QClipboardH): Boolean; cdecl; external Qt4PasLib name 'QClipboard_ownsClipboard';
function QClipboard_ownsFindBuffer(handle: QClipboardH): Boolean; cdecl; external Qt4PasLib name 'QClipboard_ownsFindBuffer';
procedure QClipboard_text(handle: QClipboardH; retval: PWideString; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_text';
procedure QClipboard_text(handle: QClipboardH; retval: PWideString; subtype: PWideString; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_text2';
procedure QClipboard_setText(handle: QClipboardH; p1: PWideString; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_setText';
function QClipboard_mimeData(handle: QClipboardH; mode: QClipboardMode = QClipboardClipboard): QMimeDataH; cdecl; external Qt4PasLib name 'QClipboard_mimeData';
procedure QClipboard_setMimeData(handle: QClipboardH; data: QMimeDataH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_setMimeData';
procedure QClipboard_image(handle: QClipboardH; retval: QImageH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_image';
procedure QClipboard_pixmap(handle: QClipboardH; retval: QPixmapH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_pixmap';
procedure QClipboard_setImage(handle: QClipboardH; p1: QImageH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_setImage';
procedure QClipboard_setPixmap(handle: QClipboardH; p1: QPixmapH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt4PasLib name 'QClipboard_setPixmap';


type
  QClipboard_changed_Event = procedure (mode: QClipboardMode) of object cdecl;
  QClipboard_selectionChanged_Event = procedure () of object cdecl;
  QClipboard_findBufferChanged_Event = procedure () of object cdecl;
  QClipboard_dataChanged_Event = procedure () of object cdecl;


function QDesktopWidget_create(): QDesktopWidgetH; cdecl; external Qt4PasLib name 'QDesktopWidget_create';
procedure QDesktopWidget_destroy(handle: QDesktopWidgetH); cdecl; external Qt4PasLib name 'QDesktopWidget_destroy'; 
function QDesktopWidget_isVirtualDesktop(handle: QDesktopWidgetH): Boolean; cdecl; external Qt4PasLib name 'QDesktopWidget_isVirtualDesktop';
function QDesktopWidget_numScreens(handle: QDesktopWidgetH): Integer; cdecl; external Qt4PasLib name 'QDesktopWidget_numScreens';
function QDesktopWidget_primaryScreen(handle: QDesktopWidgetH): Integer; cdecl; external Qt4PasLib name 'QDesktopWidget_primaryScreen';
function QDesktopWidget_screenNumber(handle: QDesktopWidgetH; widget: QWidgetH = nil): Integer; cdecl; external Qt4PasLib name 'QDesktopWidget_screenNumber';
function QDesktopWidget_screenNumber(handle: QDesktopWidgetH; p1: PQtPoint): Integer; cdecl; external Qt4PasLib name 'QDesktopWidget_screenNumber2';
function QDesktopWidget_screen(handle: QDesktopWidgetH; screen: Integer = -1): QWidgetH; cdecl; external Qt4PasLib name 'QDesktopWidget_screen';
procedure QDesktopWidget_screenGeometry(handle: QDesktopWidgetH; retval: PRect; screen: Integer = -1); cdecl; external Qt4PasLib name 'QDesktopWidget_screenGeometry';
procedure QDesktopWidget_screenGeometry(handle: QDesktopWidgetH; retval: PRect; widget: QWidgetH); cdecl; external Qt4PasLib name 'QDesktopWidget_screenGeometry2';
procedure QDesktopWidget_screenGeometry(handle: QDesktopWidgetH; retval: PRect; point: PQtPoint); cdecl; external Qt4PasLib name 'QDesktopWidget_screenGeometry3';
procedure QDesktopWidget_availableGeometry(handle: QDesktopWidgetH; retval: PRect; screen: Integer = -1); cdecl; external Qt4PasLib name 'QDesktopWidget_availableGeometry';
procedure QDesktopWidget_availableGeometry(handle: QDesktopWidgetH; retval: PRect; widget: QWidgetH); cdecl; external Qt4PasLib name 'QDesktopWidget_availableGeometry2';
procedure QDesktopWidget_availableGeometry(handle: QDesktopWidgetH; retval: PRect; point: PQtPoint); cdecl; external Qt4PasLib name 'QDesktopWidget_availableGeometry3';


type
  QDesktopWidget_resized_Event = procedure (p1: Integer) of object cdecl;
  QDesktopWidget_workAreaResized_Event = procedure (p1: Integer) of object cdecl;


procedure QToolTip_showText(pos: PQtPoint; text: PWideString; w: QWidgetH = nil); cdecl; external Qt4PasLib name 'QToolTip_showText';
procedure QToolTip_showText(pos: PQtPoint; text: PWideString; w: QWidgetH; rect: PRect); cdecl; external Qt4PasLib name 'QToolTip_showText2';
procedure QToolTip_hideText(); cdecl; external Qt4PasLib name 'QToolTip_hideText';
function QToolTip_isVisible(): Boolean; cdecl; external Qt4PasLib name 'QToolTip_isVisible';
procedure QToolTip_text(retval: PWideString); cdecl; external Qt4PasLib name 'QToolTip_text';
procedure QToolTip_palette(retval: QPaletteH); cdecl; external Qt4PasLib name 'QToolTip_palette';
procedure QToolTip_setPalette(p1: QPaletteH); cdecl; external Qt4PasLib name 'QToolTip_setPalette';
procedure QToolTip_font(retval: QFontH); cdecl; external Qt4PasLib name 'QToolTip_font';
procedure QToolTip_setFont(p1: QFontH); cdecl; external Qt4PasLib name 'QToolTip_setFont';

{$ifdef BINUX }
function QX11Info_create(): QX11InfoH; cdecl; external Qt4PasLib name 'QX11Info_create';
procedure QX11Info_destroy(handle: QX11InfoH); cdecl; external Qt4PasLib name 'QX11Info_destroy'; 
function QX11Info_create(other: QX11InfoH): QX11InfoH; cdecl; external Qt4PasLib name 'QX11Info_create2';
function QX11Info_display(): PDisplay; cdecl; external Qt4PasLib name 'QX11Info_display';
function QX11Info_appClass(): PAnsiChar; cdecl; external Qt4PasLib name 'QX11Info_appClass';
function QX11Info_screen(handle: QX11InfoH): Integer; cdecl; external Qt4PasLib name 'QX11Info_screen';
function QX11Info_depth(handle: QX11InfoH): Integer; cdecl; external Qt4PasLib name 'QX11Info_depth';
function QX11Info_cells(handle: QX11InfoH): Integer; cdecl; external Qt4PasLib name 'QX11Info_cells';
function QX11Info_colormap(handle: QX11InfoH): QtHANDLE; cdecl; external Qt4PasLib name 'QX11Info_colormap';
function QX11Info_defaultColormap(handle: QX11InfoH): Boolean; cdecl; external Qt4PasLib name 'QX11Info_defaultColormap';
function QX11Info_visual(handle: QX11InfoH): Pointer; cdecl; external Qt4PasLib name 'QX11Info_visual';
function QX11Info_defaultVisual(handle: QX11InfoH): Boolean; cdecl; external Qt4PasLib name 'QX11Info_defaultVisual';
function QX11Info_appScreen(): Integer; cdecl; external Qt4PasLib name 'QX11Info_appScreen';
function QX11Info_appDepth(screen: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QX11Info_appDepth';
function QX11Info_appCells(screen: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QX11Info_appCells';
function QX11Info_appColormap(screen: Integer = -1): QtHANDLE; cdecl; external Qt4PasLib name 'QX11Info_appColormap';
function QX11Info_appVisual(screen: Integer = -1): Pointer; cdecl; external Qt4PasLib name 'QX11Info_appVisual';
function QX11Info_appRootWindow(screen: Integer = -1): QtHANDLE; cdecl; external Qt4PasLib name 'QX11Info_appRootWindow';
function QX11Info_appDefaultColormap(screen: Integer = -1): Boolean; cdecl; external Qt4PasLib name 'QX11Info_appDefaultColormap';
function QX11Info_appDefaultVisual(screen: Integer = -1): Boolean; cdecl; external Qt4PasLib name 'QX11Info_appDefaultVisual';
function QX11Info_appDpiX(screen: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QX11Info_appDpiX';
function QX11Info_appDpiY(screen: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QX11Info_appDpiY';
procedure QX11Info_setAppDpiX(screen: Integer; dpi: Integer); cdecl; external Qt4PasLib name 'QX11Info_setAppDpiX';
procedure QX11Info_setAppDpiY(screen: Integer; dpi: Integer); cdecl; external Qt4PasLib name 'QX11Info_setAppDpiY';
function QX11Info_appTime(): Longword; cdecl; external Qt4PasLib name 'QX11Info_appTime';
function QX11Info_appUserTime(): Longword; cdecl; external Qt4PasLib name 'QX11Info_appUserTime';
procedure QX11Info_setAppTime(time: Longword); cdecl; external Qt4PasLib name 'QX11Info_setAppTime';
procedure QX11Info_setAppUserTime(time: Longword); cdecl; external Qt4PasLib name 'QX11Info_setAppUserTime';
function QX11Info_isCompositingManagerRunning(): Boolean; cdecl; external Qt4PasLib name 'QX11Info_isCompositingManagerRunning';
{$endif}

function QDrag_create(dragSource: QWidgetH): QDragH; cdecl; external Qt4PasLib name 'QDrag_create';
procedure QDrag_destroy(handle: QDragH); cdecl; external Qt4PasLib name 'QDrag_destroy'; 
procedure QDrag_setMimeData(handle: QDragH; data: QMimeDataH); cdecl; external Qt4PasLib name 'QDrag_setMimeData';
function QDrag_mimeData(handle: QDragH): QMimeDataH; cdecl; external Qt4PasLib name 'QDrag_mimeData';
procedure QDrag_setPixmap(handle: QDragH; p1: QPixmapH); cdecl; external Qt4PasLib name 'QDrag_setPixmap';
procedure QDrag_pixmap(handle: QDragH; retval: QPixmapH); cdecl; external Qt4PasLib name 'QDrag_pixmap';
procedure QDrag_setHotSpot(handle: QDragH; hotspot: PQtPoint); cdecl; external Qt4PasLib name 'QDrag_setHotSpot';
procedure QDrag_hotSpot(handle: QDragH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QDrag_hotSpot';
function QDrag_source(handle: QDragH): QWidgetH; cdecl; external Qt4PasLib name 'QDrag_source';
function QDrag_target(handle: QDragH): QWidgetH; cdecl; external Qt4PasLib name 'QDrag_target';
function QDrag_start(handle: QDragH; supportedActions: QtDropActions = QtCopyAction): QtDropAction; cdecl; external Qt4PasLib name 'QDrag_start';
function QDrag_exec(handle: QDragH; supportedActions: QtDropActions = QtMoveAction): QtDropAction; cdecl; external Qt4PasLib name 'QDrag_exec';
function QDrag_exec(handle: QDragH; supportedActions: QtDropActions; defaultAction: QtDropAction): QtDropAction; cdecl; external Qt4PasLib name 'QDrag_exec2';
procedure QDrag_setDragCursor(handle: QDragH; cursor: QPixmapH; action: QtDropAction); cdecl; external Qt4PasLib name 'QDrag_setDragCursor';


type
  QDrag_actionChanged_Event = procedure (action: QtDropAction) of object cdecl;
  QDrag_targetChanged_Event = procedure (newTarget: QWidgetH) of object cdecl;



type
  QColorSpec = ( // QColor::Spec (1)
    QColorInvalid, QColorRgb, QColorHsv, QColorCmyk );

function QColor_create(): QColorH; cdecl; external Qt4PasLib name 'QColor_create';
procedure QColor_destroy(handle: QColorH); cdecl; external Qt4PasLib name 'QColor_destroy'; 
function QColor_create(color: QtGlobalColor): QColorH; cdecl; external Qt4PasLib name 'QColor_create2';
function QColor_create(r: Integer; g: Integer; b: Integer; a: Integer = 255): QColorH; cdecl; external Qt4PasLib name 'QColor_create3';
function QColor_create(rgb: QRgb): QColorH; cdecl; external Qt4PasLib name 'QColor_create4';
function QColor_create(name: PWideString): QColorH; cdecl; external Qt4PasLib name 'QColor_create5';
function QColor_create(name: PAnsiChar): QColorH; cdecl; external Qt4PasLib name 'QColor_create6';
function QColor_create(color: PQColor): QColorH; cdecl; external Qt4PasLib name 'QColor_create7';
function QColor_create(spec: QColorSpec): QColorH; cdecl; external Qt4PasLib name 'QColor_create8';
function QColor_isValid(handle: QColorH): Boolean; cdecl; external Qt4PasLib name 'QColor_isValid';
procedure QColor_name(handle: QColorH; retval: PWideString); cdecl; external Qt4PasLib name 'QColor_name';
procedure QColor_setNamedColor(handle: QColorH; name: PWideString); cdecl; external Qt4PasLib name 'QColor_setNamedColor';
procedure QColor_colorNames(retval: QStringListH); cdecl; external Qt4PasLib name 'QColor_colorNames';
function QColor_spec(handle: QColorH): QColorSpec; cdecl; external Qt4PasLib name 'QColor_spec';
function QColor_alpha(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_alpha';
procedure QColor_setAlpha(handle: QColorH; alpha: Integer); cdecl; external Qt4PasLib name 'QColor_setAlpha';
function QColor_alphaF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_alphaF';
procedure QColor_setAlphaF(handle: QColorH; alpha: qreal); cdecl; external Qt4PasLib name 'QColor_setAlphaF';
function QColor_red(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_red';
function QColor_green(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_green';
function QColor_blue(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_blue';
procedure QColor_setRed(handle: QColorH; red: Integer); cdecl; external Qt4PasLib name 'QColor_setRed';
procedure QColor_setGreen(handle: QColorH; green: Integer); cdecl; external Qt4PasLib name 'QColor_setGreen';
procedure QColor_setBlue(handle: QColorH; blue: Integer); cdecl; external Qt4PasLib name 'QColor_setBlue';
function QColor_redF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_redF';
function QColor_greenF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_greenF';
function QColor_blueF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_blueF';
procedure QColor_setRedF(handle: QColorH; red: qreal); cdecl; external Qt4PasLib name 'QColor_setRedF';
procedure QColor_setGreenF(handle: QColorH; green: qreal); cdecl; external Qt4PasLib name 'QColor_setGreenF';
procedure QColor_setBlueF(handle: QColorH; blue: qreal); cdecl; external Qt4PasLib name 'QColor_setBlueF';
procedure QColor_getRgb(handle: QColorH; r: PInteger; g: PInteger; b: PInteger; a: PInteger = nil); cdecl; external Qt4PasLib name 'QColor_getRgb';
procedure QColor_setRgb(handle: QColorH; r: Integer; g: Integer; b: Integer; a: Integer = 255); cdecl; external Qt4PasLib name 'QColor_setRgb';
procedure QColor_getRgbF(handle: QColorH; r: PQReal; g: PQReal; b: PQReal; a: PQReal = nil); cdecl; external Qt4PasLib name 'QColor_getRgbF';
procedure QColor_setRgbF(handle: QColorH; r: qreal; g: qreal; b: qreal; a: qreal = 1.0); cdecl; external Qt4PasLib name 'QColor_setRgbF';
function QColor_rgba(handle: QColorH): QRgb; cdecl; external Qt4PasLib name 'QColor_rgba';
procedure QColor_setRgba(handle: QColorH; rgba: QRgb); cdecl; external Qt4PasLib name 'QColor_setRgba';
function QColor_rgb(handle: QColorH): QRgb; cdecl; external Qt4PasLib name 'QColor_rgb';
procedure QColor_setRgb(handle: QColorH; rgb: QRgb); cdecl; external Qt4PasLib name 'QColor_setRgb2';
function QColor_hue(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_hue';
function QColor_saturation(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_saturation';
function QColor_value(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_value';
function QColor_hueF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_hueF';
function QColor_saturationF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_saturationF';
function QColor_valueF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_valueF';
procedure QColor_getHsv(handle: QColorH; h: PInteger; s: PInteger; v: PInteger; a: PInteger = nil); cdecl; external Qt4PasLib name 'QColor_getHsv';
procedure QColor_setHsv(handle: QColorH; h: Integer; s: Integer; v: Integer; a: Integer = 255); cdecl; external Qt4PasLib name 'QColor_setHsv';
procedure QColor_getHsvF(handle: QColorH; h: PQReal; s: PQReal; v: PQReal; a: PQReal = nil); cdecl; external Qt4PasLib name 'QColor_getHsvF';
procedure QColor_setHsvF(handle: QColorH; h: qreal; s: qreal; v: qreal; a: qreal = 1.0); cdecl; external Qt4PasLib name 'QColor_setHsvF';
function QColor_cyan(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_cyan';
function QColor_magenta(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_magenta';
function QColor_yellow(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_yellow';
function QColor_black(handle: QColorH): Integer; cdecl; external Qt4PasLib name 'QColor_black';
function QColor_cyanF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_cyanF';
function QColor_magentaF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_magentaF';
function QColor_yellowF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_yellowF';
function QColor_blackF(handle: QColorH): qreal; cdecl; external Qt4PasLib name 'QColor_blackF';
procedure QColor_getCmyk(handle: QColorH; c: PInteger; m: PInteger; y: PInteger; k: PInteger; a: PInteger = nil); cdecl; external Qt4PasLib name 'QColor_getCmyk';
procedure QColor_setCmyk(handle: QColorH; c: Integer; m: Integer; y: Integer; k: Integer; a: Integer = 255); cdecl; external Qt4PasLib name 'QColor_setCmyk';
procedure QColor_getCmykF(handle: QColorH; c: PQReal; m: PQReal; y: PQReal; k: PQReal; a: PQReal = nil); cdecl; external Qt4PasLib name 'QColor_getCmykF';
procedure QColor_setCmykF(handle: QColorH; c: qreal; m: qreal; y: qreal; k: qreal; a: qreal = 1.0); cdecl; external Qt4PasLib name 'QColor_setCmykF';
procedure QColor_toRgb(handle: QColorH; retval: PQColor); cdecl; external Qt4PasLib name 'QColor_toRgb';
procedure QColor_toHsv(handle: QColorH; retval: PQColor); cdecl; external Qt4PasLib name 'QColor_toHsv';
procedure QColor_toCmyk(handle: QColorH; retval: PQColor); cdecl; external Qt4PasLib name 'QColor_toCmyk';
procedure QColor_convertTo(handle: QColorH; retval: PQColor; colorSpec: QColorSpec); cdecl; external Qt4PasLib name 'QColor_convertTo';
procedure QColor_fromRgb(retval: PQColor; rgb: QRgb); cdecl; external Qt4PasLib name 'QColor_fromRgb';
procedure QColor_fromRgba(retval: PQColor; rgba: QRgb); cdecl; external Qt4PasLib name 'QColor_fromRgba';
procedure QColor_fromRgb(retval: PQColor; r: Integer; g: Integer; b: Integer; a: Integer = 255); cdecl; external Qt4PasLib name 'QColor_fromRgb2';
procedure QColor_fromRgbF(retval: PQColor; r: qreal; g: qreal; b: qreal; a: qreal = 1.0); cdecl; external Qt4PasLib name 'QColor_fromRgbF';
procedure QColor_fromHsv(retval: PQColor; h: Integer; s: Integer; v: Integer; a: Integer = 255); cdecl; external Qt4PasLib name 'QColor_fromHsv';
procedure QColor_fromHsvF(retval: PQColor; h: qreal; s: qreal; v: qreal; a: qreal = 1.0); cdecl; external Qt4PasLib name 'QColor_fromHsvF';
procedure QColor_fromCmyk(retval: PQColor; c: Integer; m: Integer; y: Integer; k: Integer; a: Integer = 255); cdecl; external Qt4PasLib name 'QColor_fromCmyk';
procedure QColor_fromCmykF(retval: PQColor; c: qreal; m: qreal; y: qreal; k: qreal; a: qreal = 1.0); cdecl; external Qt4PasLib name 'QColor_fromCmykF';
procedure QColor_light(handle: QColorH; retval: PQColor; f: Integer = 150); cdecl; external Qt4PasLib name 'QColor_light';
procedure QColor_lighter(handle: QColorH; retval: PQColor; f: Integer = 150); cdecl; external Qt4PasLib name 'QColor_lighter';
procedure QColor_dark(handle: QColorH; retval: PQColor; f: Integer = 200); cdecl; external Qt4PasLib name 'QColor_dark';
procedure QColor_darker(handle: QColorH; retval: PQColor; f: Integer = 200); cdecl; external Qt4PasLib name 'QColor_darker';
{$ifdef BINUX }
function QColor_allowX11ColorNames(): Boolean; cdecl; external Qt4PasLib name 'QColor_allowX11ColorNames';
procedure QColor_setAllowX11ColorNames(enabled: Boolean); cdecl; external Qt4PasLib name 'QColor_setAllowX11ColorNames';
{$endif}

function QMatrix_create(): QMatrixH; cdecl; external Qt4PasLib name 'QMatrix_create';
procedure QMatrix_destroy(handle: QMatrixH); cdecl; external Qt4PasLib name 'QMatrix_destroy'; 
function QMatrix_create(m11: qreal; m12: qreal; m21: qreal; m22: qreal; dx: qreal; dy: qreal): QMatrixH; cdecl; external Qt4PasLib name 'QMatrix_create2';
function QMatrix_create(matrix: QMatrixH): QMatrixH; cdecl; external Qt4PasLib name 'QMatrix_create3';
procedure QMatrix_setMatrix(handle: QMatrixH; m11: qreal; m12: qreal; m21: qreal; m22: qreal; dx: qreal; dy: qreal); cdecl; external Qt4PasLib name 'QMatrix_setMatrix';
function QMatrix_m11(handle: QMatrixH): qreal; cdecl; external Qt4PasLib name 'QMatrix_m11';
function QMatrix_m12(handle: QMatrixH): qreal; cdecl; external Qt4PasLib name 'QMatrix_m12';
function QMatrix_m21(handle: QMatrixH): qreal; cdecl; external Qt4PasLib name 'QMatrix_m21';
function QMatrix_m22(handle: QMatrixH): qreal; cdecl; external Qt4PasLib name 'QMatrix_m22';
function QMatrix_dx(handle: QMatrixH): qreal; cdecl; external Qt4PasLib name 'QMatrix_dx';
function QMatrix_dy(handle: QMatrixH): qreal; cdecl; external Qt4PasLib name 'QMatrix_dy';
procedure QMatrix_map(handle: QMatrixH; x: Integer; y: Integer; tx: PInteger; ty: PInteger); cdecl; external Qt4PasLib name 'QMatrix_map';
procedure QMatrix_map(handle: QMatrixH; x: qreal; y: qreal; tx: PQReal; ty: PQReal); cdecl; external Qt4PasLib name 'QMatrix_map2';
procedure QMatrix_mapRect(handle: QMatrixH; retval: PRect; p1: PRect); cdecl; external Qt4PasLib name 'QMatrix_mapRect';
procedure QMatrix_mapRect(handle: QMatrixH; retval: QRectFH; p1: QRectFH); cdecl; external Qt4PasLib name 'QMatrix_mapRect2';
procedure QMatrix_map(handle: QMatrixH; retval: PQtPoint; p: PQtPoint); cdecl; external Qt4PasLib name 'QMatrix_map3';
procedure QMatrix_map(handle: QMatrixH; retval: PQtPointF; p: PQtPointF); cdecl; external Qt4PasLib name 'QMatrix_map4';
procedure QMatrix_map(handle: QMatrixH; retval: QLineH; l: QLineH); cdecl; external Qt4PasLib name 'QMatrix_map5';
procedure QMatrix_map(handle: QMatrixH; retval: QLineFH; l: QLineFH); cdecl; external Qt4PasLib name 'QMatrix_map6';
procedure QMatrix_map(handle: QMatrixH; retval: QPolygonFH; a: QPolygonFH); cdecl; external Qt4PasLib name 'QMatrix_map7';
procedure QMatrix_map(handle: QMatrixH; retval: QPolygonH; a: QPolygonH); cdecl; external Qt4PasLib name 'QMatrix_map8';
procedure QMatrix_map(handle: QMatrixH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QMatrix_map9';
procedure QMatrix_map(handle: QMatrixH; retval: QPainterPathH; p: QPainterPathH); cdecl; external Qt4PasLib name 'QMatrix_map10';
procedure QMatrix_mapToPolygon(handle: QMatrixH; retval: QPolygonH; r: PRect); cdecl; external Qt4PasLib name 'QMatrix_mapToPolygon';
procedure QMatrix_reset(handle: QMatrixH); cdecl; external Qt4PasLib name 'QMatrix_reset';
function QMatrix_isIdentity(handle: QMatrixH): Boolean; cdecl; external Qt4PasLib name 'QMatrix_isIdentity';
function QMatrix_translate(handle: QMatrixH; dx: qreal; dy: qreal): QMatrixH; cdecl; external Qt4PasLib name 'QMatrix_translate';
function QMatrix_scale(handle: QMatrixH; sx: qreal; sy: qreal): QMatrixH; cdecl; external Qt4PasLib name 'QMatrix_scale';
function QMatrix_shear(handle: QMatrixH; sh: qreal; sv: qreal): QMatrixH; cdecl; external Qt4PasLib name 'QMatrix_shear';
function QMatrix_rotate(handle: QMatrixH; a: qreal): QMatrixH; cdecl; external Qt4PasLib name 'QMatrix_rotate';
function QMatrix_isInvertible(handle: QMatrixH): Boolean; cdecl; external Qt4PasLib name 'QMatrix_isInvertible';
function QMatrix_det(handle: QMatrixH): qreal; cdecl; external Qt4PasLib name 'QMatrix_det';
procedure QMatrix_inverted(handle: QMatrixH; retval: QMatrixH; invertible: PBoolean = nil); cdecl; external Qt4PasLib name 'QMatrix_inverted';


type
  QGradientType = ( // QGradient::Type (1)
    QGradientLinearGradient, QGradientRadialGradient, QGradientConicalGradient, QGradientNoGradient );

  QGradientSpread = ( // QGradient::Spread (1)
    QGradientPadSpread, QGradientReflectSpread, QGradientRepeatSpread );

  QGradientCoordinateMode = ( // QGradient::CoordinateMode (1)
    QGradientLogicalMode, QGradientStretchToDeviceMode, QGradientObjectBoundingMode );

  QGradientInterpolationMode = ( // QGradient::InterpolationMode (1)
    QGradientColorInterpolation, QGradientComponentInterpolation );

function QBrush_create(): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create';
procedure QBrush_destroy(handle: QBrushH); cdecl; external Qt4PasLib name 'QBrush_destroy'; 
function QBrush_create(bs: QtBrushStyle): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create2';
function QBrush_create(color: PQColor; bs: QtBrushStyle = QtSolidPattern): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create3';
function QBrush_create(color: QtGlobalColor; bs: QtBrushStyle = QtSolidPattern): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create4';
function QBrush_create(color: PQColor; pixmap: QPixmapH): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create5';
function QBrush_create(color: QtGlobalColor; pixmap: QPixmapH): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create6';
function QBrush_create(pixmap: QPixmapH): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create7';
function QBrush_create(image: QImageH): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create8';
function QBrush_create(brush: QBrushH): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create9';
function QBrush_create(gradient: QGradientH): QBrushH; cdecl; external Qt4PasLib name 'QBrush_create10';
function QBrush_style(handle: QBrushH): QtBrushStyle; cdecl; external Qt4PasLib name 'QBrush_style';
procedure QBrush_setStyle(handle: QBrushH; p1: QtBrushStyle); cdecl; external Qt4PasLib name 'QBrush_setStyle';
function QBrush_matrix(handle: QBrushH): QMatrixH; cdecl; external Qt4PasLib name 'QBrush_matrix';
procedure QBrush_setMatrix(handle: QBrushH; mat: QMatrixH); cdecl; external Qt4PasLib name 'QBrush_setMatrix';
procedure QBrush_transform(handle: QBrushH; retval: QTransformH); cdecl; external Qt4PasLib name 'QBrush_transform';
procedure QBrush_setTransform(handle: QBrushH; p1: QTransformH); cdecl; external Qt4PasLib name 'QBrush_setTransform';
procedure QBrush_texture(handle: QBrushH; retval: QPixmapH); cdecl; external Qt4PasLib name 'QBrush_texture';
procedure QBrush_setTexture(handle: QBrushH; pixmap: QPixmapH); cdecl; external Qt4PasLib name 'QBrush_setTexture';
procedure QBrush_textureImage(handle: QBrushH; retval: QImageH); cdecl; external Qt4PasLib name 'QBrush_textureImage';
procedure QBrush_setTextureImage(handle: QBrushH; image: QImageH); cdecl; external Qt4PasLib name 'QBrush_setTextureImage';
function QBrush_color(handle: QBrushH): PQColor; cdecl; external Qt4PasLib name 'QBrush_color';
procedure QBrush_setColor(handle: QBrushH; color: PQColor); cdecl; external Qt4PasLib name 'QBrush_setColor';
procedure QBrush_setColor(handle: QBrushH; color: QtGlobalColor); cdecl; external Qt4PasLib name 'QBrush_setColor2';
function QBrush_gradient(handle: QBrushH): QGradientH; cdecl; external Qt4PasLib name 'QBrush_gradient';
function QBrush_isOpaque(handle: QBrushH): Boolean; cdecl; external Qt4PasLib name 'QBrush_isOpaque';
function QBrush_isDetached(handle: QBrushH): Boolean; cdecl; external Qt4PasLib name 'QBrush_isDetached';

function QGradient_create(): QGradientH; cdecl; external Qt4PasLib name 'QGradient_create';
procedure QGradient_destroy(handle: QGradientH); cdecl; external Qt4PasLib name 'QGradient_destroy'; 
function QGradient_type(handle: QGradientH): QGradientType; cdecl; external Qt4PasLib name 'QGradient_type';
procedure QGradient_setSpread(handle: QGradientH; spread: QGradientSpread); cdecl; external Qt4PasLib name 'QGradient_setSpread';
function QGradient_spread(handle: QGradientH): QGradientSpread; cdecl; external Qt4PasLib name 'QGradient_spread';
procedure QGradient_setColorAt(handle: QGradientH; pos: qreal; color: PQColor); cdecl; external Qt4PasLib name 'QGradient_setColorAt';
function QGradient_coordinateMode(handle: QGradientH): QGradientCoordinateMode; cdecl; external Qt4PasLib name 'QGradient_coordinateMode';
procedure QGradient_setCoordinateMode(handle: QGradientH; mode: QGradientCoordinateMode); cdecl; external Qt4PasLib name 'QGradient_setCoordinateMode';
function QGradient_interpolationMode(handle: QGradientH): QGradientInterpolationMode; cdecl; external Qt4PasLib name 'QGradient_interpolationMode';
procedure QGradient_setInterpolationMode(handle: QGradientH; mode: QGradientInterpolationMode); cdecl; external Qt4PasLib name 'QGradient_setInterpolationMode';

function QLinearGradient_create(): QLinearGradientH; cdecl; external Qt4PasLib name 'QLinearGradient_create';
procedure QLinearGradient_destroy(handle: QLinearGradientH); cdecl; external Qt4PasLib name 'QLinearGradient_destroy'; 
function QLinearGradient_create(start: PQtPointF; finalStop: PQtPointF): QLinearGradientH; cdecl; external Qt4PasLib name 'QLinearGradient_create2';
function QLinearGradient_create(xStart: qreal; yStart: qreal; xFinalStop: qreal; yFinalStop: qreal): QLinearGradientH; cdecl; external Qt4PasLib name 'QLinearGradient_create3';
procedure QLinearGradient_start(handle: QLinearGradientH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QLinearGradient_start';
procedure QLinearGradient_setStart(handle: QLinearGradientH; start: PQtPointF); cdecl; external Qt4PasLib name 'QLinearGradient_setStart';
procedure QLinearGradient_setStart(handle: QLinearGradientH; x: qreal; y: qreal); cdecl; external Qt4PasLib name 'QLinearGradient_setStart2';
procedure QLinearGradient_finalStop(handle: QLinearGradientH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QLinearGradient_finalStop';
procedure QLinearGradient_setFinalStop(handle: QLinearGradientH; stop: PQtPointF); cdecl; external Qt4PasLib name 'QLinearGradient_setFinalStop';
procedure QLinearGradient_setFinalStop(handle: QLinearGradientH; x: qreal; y: qreal); cdecl; external Qt4PasLib name 'QLinearGradient_setFinalStop2';

function QRadialGradient_create(): QRadialGradientH; cdecl; external Qt4PasLib name 'QRadialGradient_create';
procedure QRadialGradient_destroy(handle: QRadialGradientH); cdecl; external Qt4PasLib name 'QRadialGradient_destroy'; 
function QRadialGradient_create(center: PQtPointF; radius: qreal; focalPoint: PQtPointF): QRadialGradientH; cdecl; external Qt4PasLib name 'QRadialGradient_create2';
function QRadialGradient_create(cx: qreal; cy: qreal; radius: qreal; fx: qreal; fy: qreal): QRadialGradientH; cdecl; external Qt4PasLib name 'QRadialGradient_create3';
function QRadialGradient_create(center: PQtPointF; radius: qreal): QRadialGradientH; cdecl; external Qt4PasLib name 'QRadialGradient_create4';
function QRadialGradient_create(cx: qreal; cy: qreal; radius: qreal): QRadialGradientH; cdecl; external Qt4PasLib name 'QRadialGradient_create5';
procedure QRadialGradient_center(handle: QRadialGradientH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QRadialGradient_center';
procedure QRadialGradient_setCenter(handle: QRadialGradientH; center: PQtPointF); cdecl; external Qt4PasLib name 'QRadialGradient_setCenter';
procedure QRadialGradient_setCenter(handle: QRadialGradientH; x: qreal; y: qreal); cdecl; external Qt4PasLib name 'QRadialGradient_setCenter2';
procedure QRadialGradient_focalPoint(handle: QRadialGradientH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QRadialGradient_focalPoint';
procedure QRadialGradient_setFocalPoint(handle: QRadialGradientH; focalPoint: PQtPointF); cdecl; external Qt4PasLib name 'QRadialGradient_setFocalPoint';
procedure QRadialGradient_setFocalPoint(handle: QRadialGradientH; x: qreal; y: qreal); cdecl; external Qt4PasLib name 'QRadialGradient_setFocalPoint2';
function QRadialGradient_radius(handle: QRadialGradientH): qreal; cdecl; external Qt4PasLib name 'QRadialGradient_radius';
procedure QRadialGradient_setRadius(handle: QRadialGradientH; radius: qreal); cdecl; external Qt4PasLib name 'QRadialGradient_setRadius';

function QConicalGradient_create(): QConicalGradientH; cdecl; external Qt4PasLib name 'QConicalGradient_create';
procedure QConicalGradient_destroy(handle: QConicalGradientH); cdecl; external Qt4PasLib name 'QConicalGradient_destroy'; 
function QConicalGradient_create(center: PQtPointF; startAngle: qreal): QConicalGradientH; cdecl; external Qt4PasLib name 'QConicalGradient_create2';
function QConicalGradient_create(cx: qreal; cy: qreal; startAngle: qreal): QConicalGradientH; cdecl; external Qt4PasLib name 'QConicalGradient_create3';
procedure QConicalGradient_center(handle: QConicalGradientH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QConicalGradient_center';
procedure QConicalGradient_setCenter(handle: QConicalGradientH; center: PQtPointF); cdecl; external Qt4PasLib name 'QConicalGradient_setCenter';
procedure QConicalGradient_setCenter(handle: QConicalGradientH; x: qreal; y: qreal); cdecl; external Qt4PasLib name 'QConicalGradient_setCenter2';
function QConicalGradient_angle(handle: QConicalGradientH): qreal; cdecl; external Qt4PasLib name 'QConicalGradient_angle';
procedure QConicalGradient_setAngle(handle: QConicalGradientH; angle: qreal); cdecl; external Qt4PasLib name 'QConicalGradient_setAngle';

function QPen_create(): QPenH; cdecl; external Qt4PasLib name 'QPen_create';
procedure QPen_destroy(handle: QPenH); cdecl; external Qt4PasLib name 'QPen_destroy'; 
function QPen_create(p1: QtPenStyle): QPenH; cdecl; external Qt4PasLib name 'QPen_create2';
function QPen_create(color: PQColor): QPenH; cdecl; external Qt4PasLib name 'QPen_create3';
function QPen_create(brush: QBrushH; width: qreal; s: QtPenStyle = QtSolidLine; c: QtPenCapStyle = QtSquareCap; j: QtPenJoinStyle = QtBevelJoin): QPenH; cdecl; external Qt4PasLib name 'QPen_create4';
function QPen_create(pen: QPenH): QPenH; cdecl; external Qt4PasLib name 'QPen_create5';
function QPen_style(handle: QPenH): QtPenStyle; cdecl; external Qt4PasLib name 'QPen_style';
procedure QPen_setStyle(handle: QPenH; p1: QtPenStyle); cdecl; external Qt4PasLib name 'QPen_setStyle';
procedure QPen_dashPattern(handle: QPenH; retval: PQRealArray); cdecl; external Qt4PasLib name 'QPen_dashPattern';
procedure QPen_setDashPattern(handle: QPenH; pattern: PQRealArray); cdecl; external Qt4PasLib name 'QPen_setDashPattern';
function QPen_dashOffset(handle: QPenH): qreal; cdecl; external Qt4PasLib name 'QPen_dashOffset';
procedure QPen_setDashOffset(handle: QPenH; doffset: qreal); cdecl; external Qt4PasLib name 'QPen_setDashOffset';
function QPen_miterLimit(handle: QPenH): qreal; cdecl; external Qt4PasLib name 'QPen_miterLimit';
procedure QPen_setMiterLimit(handle: QPenH; limit: qreal); cdecl; external Qt4PasLib name 'QPen_setMiterLimit';
function QPen_widthF(handle: QPenH): qreal; cdecl; external Qt4PasLib name 'QPen_widthF';
procedure QPen_setWidthF(handle: QPenH; width: qreal); cdecl; external Qt4PasLib name 'QPen_setWidthF';
function QPen_width(handle: QPenH): Integer; cdecl; external Qt4PasLib name 'QPen_width';
procedure QPen_setWidth(handle: QPenH; width: Integer); cdecl; external Qt4PasLib name 'QPen_setWidth';
procedure QPen_color(handle: QPenH; retval: PQColor); cdecl; external Qt4PasLib name 'QPen_color';
procedure QPen_setColor(handle: QPenH; color: PQColor); cdecl; external Qt4PasLib name 'QPen_setColor';
procedure QPen_brush(handle: QPenH; retval: QBrushH); cdecl; external Qt4PasLib name 'QPen_brush';
procedure QPen_setBrush(handle: QPenH; brush: QBrushH); cdecl; external Qt4PasLib name 'QPen_setBrush';
function QPen_isSolid(handle: QPenH): Boolean; cdecl; external Qt4PasLib name 'QPen_isSolid';
function QPen_capStyle(handle: QPenH): QtPenCapStyle; cdecl; external Qt4PasLib name 'QPen_capStyle';
procedure QPen_setCapStyle(handle: QPenH; pcs: QtPenCapStyle); cdecl; external Qt4PasLib name 'QPen_setCapStyle';
function QPen_joinStyle(handle: QPenH): QtPenJoinStyle; cdecl; external Qt4PasLib name 'QPen_joinStyle';
procedure QPen_setJoinStyle(handle: QPenH; pcs: QtPenJoinStyle); cdecl; external Qt4PasLib name 'QPen_setJoinStyle';
function QPen_isCosmetic(handle: QPenH): Boolean; cdecl; external Qt4PasLib name 'QPen_isCosmetic';
procedure QPen_setCosmetic(handle: QPenH; cosmetic: Boolean); cdecl; external Qt4PasLib name 'QPen_setCosmetic';
function QPen_isDetached(handle: QPenH): Boolean; cdecl; external Qt4PasLib name 'QPen_isDetached';

function QPolygon_create(): QPolygonH; cdecl; external Qt4PasLib name 'QPolygon_create';
procedure QPolygon_destroy(handle: QPolygonH); cdecl; external Qt4PasLib name 'QPolygon_destroy'; 
function QPolygon_create(size: Integer): QPolygonH; cdecl; external Qt4PasLib name 'QPolygon_create2';
function QPolygon_create(a: QPolygonH): QPolygonH; cdecl; external Qt4PasLib name 'QPolygon_create3';
function QPolygon_create(r: PRect; closed: Boolean = False): QPolygonH; cdecl; external Qt4PasLib name 'QPolygon_create4';
function QPolygon_create(nPoints: Integer; points: PInteger): QPolygonH; cdecl; external Qt4PasLib name 'QPolygon_create5';
procedure QPolygon_translate(handle: QPolygonH; dx: Integer; dy: Integer); cdecl; external Qt4PasLib name 'QPolygon_translate';
procedure QPolygon_translate(handle: QPolygonH; offset: PQtPoint); cdecl; external Qt4PasLib name 'QPolygon_translate2';
procedure QPolygon_boundingRect(handle: QPolygonH; retval: PRect); cdecl; external Qt4PasLib name 'QPolygon_boundingRect';
procedure QPolygon_point(handle: QPolygonH; i: Integer; x: PInteger; y: PInteger); cdecl; external Qt4PasLib name 'QPolygon_point';
procedure QPolygon_point(handle: QPolygonH; retval: PQtPoint; i: Integer); cdecl; external Qt4PasLib name 'QPolygon_point2';
procedure QPolygon_setPoint(handle: QPolygonH; index: Integer; x: Integer; y: Integer); cdecl; external Qt4PasLib name 'QPolygon_setPoint';
procedure QPolygon_setPoint(handle: QPolygonH; index: Integer; p: PQtPoint); cdecl; external Qt4PasLib name 'QPolygon_setPoint2';
procedure QPolygon_setPoints(handle: QPolygonH; nPoints: Integer; points: PInteger); cdecl; external Qt4PasLib name 'QPolygon_setPoints';
procedure QPolygon_putPoints(handle: QPolygonH; index: Integer; nPoints: Integer; points: PInteger); cdecl; external Qt4PasLib name 'QPolygon_putPoints';
procedure QPolygon_putPoints(handle: QPolygonH; index: Integer; nPoints: Integer; from: QPolygonH; fromIndex: Integer = 0); cdecl; external Qt4PasLib name 'QPolygon_putPoints3';
function QPolygon_containsPoint(handle: QPolygonH; pt: PQtPoint; fillRule: QtFillRule): Boolean; cdecl; external Qt4PasLib name 'QPolygon_containsPoint';
procedure QPolygon_united(handle: QPolygonH; retval: QPolygonH; r: QPolygonH); cdecl; external Qt4PasLib name 'QPolygon_united';
procedure QPolygon_intersected(handle: QPolygonH; retval: QPolygonH; r: QPolygonH); cdecl; external Qt4PasLib name 'QPolygon_intersected';
procedure QPolygon_subtracted(handle: QPolygonH; retval: QPolygonH; r: QPolygonH); cdecl; external Qt4PasLib name 'QPolygon_subtracted';

function QPolygonF_create(): QPolygonFH; cdecl; external Qt4PasLib name 'QPolygonF_create';
procedure QPolygonF_destroy(handle: QPolygonFH); cdecl; external Qt4PasLib name 'QPolygonF_destroy'; 
function QPolygonF_create(size: Integer): QPolygonFH; cdecl; external Qt4PasLib name 'QPolygonF_create2';
function QPolygonF_create(a: QPolygonFH): QPolygonFH; cdecl; external Qt4PasLib name 'QPolygonF_create3';
function QPolygonF_create(r: QRectFH): QPolygonFH; cdecl; external Qt4PasLib name 'QPolygonF_create4';
function QPolygonF_create(a: QPolygonH): QPolygonFH; cdecl; external Qt4PasLib name 'QPolygonF_create5';
procedure QPolygonF_translate(handle: QPolygonFH; dx: qreal; dy: qreal); cdecl; external Qt4PasLib name 'QPolygonF_translate';
procedure QPolygonF_translate(handle: QPolygonFH; offset: PQtPointF); cdecl; external Qt4PasLib name 'QPolygonF_translate2';
procedure QPolygonF_toPolygon(handle: QPolygonFH; retval: QPolygonH); cdecl; external Qt4PasLib name 'QPolygonF_toPolygon';
function QPolygonF_isClosed(handle: QPolygonFH): Boolean; cdecl; external Qt4PasLib name 'QPolygonF_isClosed';
procedure QPolygonF_boundingRect(handle: QPolygonFH; retval: QRectFH); cdecl; external Qt4PasLib name 'QPolygonF_boundingRect';
function QPolygonF_containsPoint(handle: QPolygonFH; pt: PQtPointF; fillRule: QtFillRule): Boolean; cdecl; external Qt4PasLib name 'QPolygonF_containsPoint';
procedure QPolygonF_united(handle: QPolygonFH; retval: QPolygonFH; r: QPolygonFH); cdecl; external Qt4PasLib name 'QPolygonF_united';
procedure QPolygonF_intersected(handle: QPolygonFH; retval: QPolygonFH; r: QPolygonFH); cdecl; external Qt4PasLib name 'QPolygonF_intersected';
procedure QPolygonF_subtracted(handle: QPolygonFH; retval: QPolygonFH; r: QPolygonFH); cdecl; external Qt4PasLib name 'QPolygonF_subtracted';


type
  QPainterCompositionMode = ( // QPainter::CompositionMode (1)
    QPainterCompositionMode_SourceOver, QPainterCompositionMode_DestinationOver, QPainterCompositionMode_Clear, QPainterCompositionMode_Source, QPainterCompositionMode_Destination, QPainterCompositionMode_SourceIn, 
    QPainterCompositionMode_DestinationIn, QPainterCompositionMode_SourceOut, QPainterCompositionMode_DestinationOut, QPainterCompositionMode_SourceAtop, QPainterCompositionMode_DestinationAtop, 
    QPainterCompositionMode_Xor, QPainterCompositionMode_Plus, QPainterCompositionMode_Multiply, QPainterCompositionMode_Screen, QPainterCompositionMode_Overlay, QPainterCompositionMode_Darken, 
    QPainterCompositionMode_Lighten, QPainterCompositionMode_ColorDodge, QPainterCompositionMode_ColorBurn, QPainterCompositionMode_HardLight, QPainterCompositionMode_SoftLight, QPainterCompositionMode_Difference, 
    QPainterCompositionMode_Exclusion, QPainterRasterOp_SourceOrDestination, QPainterRasterOp_SourceAndDestination, QPainterRasterOp_SourceXorDestination, QPainterRasterOp_NotSourceAndNotDestination, 
    QPainterRasterOp_NotSourceOrNotDestination, QPainterRasterOp_NotSourceXorDestination, QPainterRasterOp_NotSource, QPainterRasterOp_NotSourceAndDestination, QPainterRasterOp_SourceAndNotDestination );

type
  QPainterRenderHint = cardinal; // QPainter::RenderHint
  QPainterRenderHints = QPainterRenderHint; //QFlags<> (3)
const
  QPainterAntialiasing =   $01;
  QPainterTextAntialiasing =   $02;
  QPainterSmoothPixmapTransform =   $04;
  QPainterHighQualityAntialiasing =   $08;
  QPainterNonCosmeticDefaultPen =   $10;

function QPainter_create(): QPainterH; cdecl; external Qt4PasLib name 'QPainter_create';
procedure QPainter_destroy(handle: QPainterH); cdecl; external Qt4PasLib name 'QPainter_destroy'; 
function QPainter_create(p1: QPaintDeviceH): QPainterH; cdecl; external Qt4PasLib name 'QPainter_create2';
function QPainter_device(handle: QPainterH): QPaintDeviceH; cdecl; external Qt4PasLib name 'QPainter_device';
function QPainter_begin(handle: QPainterH; p1: QPaintDeviceH): Boolean; cdecl; external Qt4PasLib name 'QPainter_begin';
function QPainter_end(handle: QPainterH): Boolean; cdecl; external Qt4PasLib name 'QPainter_end';
function QPainter_isActive(handle: QPainterH): Boolean; cdecl; external Qt4PasLib name 'QPainter_isActive';
procedure QPainter_initFrom(handle: QPainterH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QPainter_initFrom';
procedure QPainter_setCompositionMode(handle: QPainterH; mode: QPainterCompositionMode); cdecl; external Qt4PasLib name 'QPainter_setCompositionMode';
function QPainter_compositionMode(handle: QPainterH): QPainterCompositionMode; cdecl; external Qt4PasLib name 'QPainter_compositionMode';
function QPainter_font(handle: QPainterH): QFontH; cdecl; external Qt4PasLib name 'QPainter_font';
procedure QPainter_setFont(handle: QPainterH; f: QFontH); cdecl; external Qt4PasLib name 'QPainter_setFont';
procedure QPainter_fontMetrics(handle: QPainterH; retval: QFontMetricsH); cdecl; external Qt4PasLib name 'QPainter_fontMetrics';
procedure QPainter_fontInfo(handle: QPainterH; retval: QFontInfoH); cdecl; external Qt4PasLib name 'QPainter_fontInfo';
procedure QPainter_setPen(handle: QPainterH; color: PQColor); cdecl; external Qt4PasLib name 'QPainter_setPen';
procedure QPainter_setPen(handle: QPainterH; pen: QPenH); cdecl; external Qt4PasLib name 'QPainter_setPen2';
procedure QPainter_setPen(handle: QPainterH; style: QtPenStyle); cdecl; external Qt4PasLib name 'QPainter_setPen3';
function QPainter_pen(handle: QPainterH): QPenH; cdecl; external Qt4PasLib name 'QPainter_pen';
procedure QPainter_setBrush(handle: QPainterH; brush: QBrushH); cdecl; external Qt4PasLib name 'QPainter_setBrush';
procedure QPainter_setBrush(handle: QPainterH; style: QtBrushStyle); cdecl; external Qt4PasLib name 'QPainter_setBrush2';
function QPainter_brush(handle: QPainterH): QBrushH; cdecl; external Qt4PasLib name 'QPainter_brush';
procedure QPainter_setBackgroundMode(handle: QPainterH; mode: QtBGMode); cdecl; external Qt4PasLib name 'QPainter_setBackgroundMode';
function QPainter_backgroundMode(handle: QPainterH): QtBGMode; cdecl; external Qt4PasLib name 'QPainter_backgroundMode';
procedure QPainter_brushOrigin(handle: QPainterH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QPainter_brushOrigin';
procedure QPainter_setBrushOrigin(handle: QPainterH; x: Integer; y: Integer); cdecl; external Qt4PasLib name 'QPainter_setBrushOrigin';
procedure QPainter_setBrushOrigin(handle: QPainterH; p1: PQtPoint); cdecl; external Qt4PasLib name 'QPainter_setBrushOrigin2';
procedure QPainter_setBrushOrigin(handle: QPainterH; p1: PQtPointF); cdecl; external Qt4PasLib name 'QPainter_setBrushOrigin3';
procedure QPainter_setBackground(handle: QPainterH; bg: QBrushH); cdecl; external Qt4PasLib name 'QPainter_setBackground';
function QPainter_background(handle: QPainterH): QBrushH; cdecl; external Qt4PasLib name 'QPainter_background';
function QPainter_opacity(handle: QPainterH): qreal; cdecl; external Qt4PasLib name 'QPainter_opacity';
procedure QPainter_setOpacity(handle: QPainterH; opacity: qreal); cdecl; external Qt4PasLib name 'QPainter_setOpacity';
procedure QPainter_clipRegion(handle: QPainterH; retval: QRegionH); cdecl; external Qt4PasLib name 'QPainter_clipRegion';
procedure QPainter_clipPath(handle: QPainterH; retval: QPainterPathH); cdecl; external Qt4PasLib name 'QPainter_clipPath';
procedure QPainter_setClipRect(handle: QPainterH; p1: QRectFH; op: QtClipOperation = QtReplaceClip); cdecl; external Qt4PasLib name 'QPainter_setClipRect';
procedure QPainter_setClipRect(handle: QPainterH; p1: PRect; op: QtClipOperation = QtReplaceClip); cdecl; external Qt4PasLib name 'QPainter_setClipRect2';
procedure QPainter_setClipRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; op: QtClipOperation = QtReplaceClip); cdecl; external Qt4PasLib name 'QPainter_setClipRect3';
procedure QPainter_setClipRegion(handle: QPainterH; p1: QRegionH; op: QtClipOperation = QtReplaceClip); cdecl; external Qt4PasLib name 'QPainter_setClipRegion';
procedure QPainter_setClipPath(handle: QPainterH; path: QPainterPathH; op: QtClipOperation = QtReplaceClip); cdecl; external Qt4PasLib name 'QPainter_setClipPath';
procedure QPainter_setClipping(handle: QPainterH; enable: Boolean); cdecl; external Qt4PasLib name 'QPainter_setClipping';
function QPainter_hasClipping(handle: QPainterH): Boolean; cdecl; external Qt4PasLib name 'QPainter_hasClipping';
procedure QPainter_save(handle: QPainterH); cdecl; external Qt4PasLib name 'QPainter_save';
procedure QPainter_restore(handle: QPainterH); cdecl; external Qt4PasLib name 'QPainter_restore';
procedure QPainter_setMatrix(handle: QPainterH; matrix: QMatrixH; combine: Boolean = False); cdecl; external Qt4PasLib name 'QPainter_setMatrix';
function QPainter_matrix(handle: QPainterH): QMatrixH; cdecl; external Qt4PasLib name 'QPainter_matrix';
function QPainter_deviceMatrix(handle: QPainterH): QMatrixH; cdecl; external Qt4PasLib name 'QPainter_deviceMatrix';
procedure QPainter_resetMatrix(handle: QPainterH); cdecl; external Qt4PasLib name 'QPainter_resetMatrix';
procedure QPainter_setTransform(handle: QPainterH; transform: QTransformH; combine: Boolean = False); cdecl; external Qt4PasLib name 'QPainter_setTransform';
function QPainter_transform(handle: QPainterH): QTransformH; cdecl; external Qt4PasLib name 'QPainter_transform';
function QPainter_deviceTransform(handle: QPainterH): QTransformH; cdecl; external Qt4PasLib name 'QPainter_deviceTransform';
procedure QPainter_resetTransform(handle: QPainterH); cdecl; external Qt4PasLib name 'QPainter_resetTransform';
procedure QPainter_setWorldMatrix(handle: QPainterH; matrix: QMatrixH; combine: Boolean = False); cdecl; external Qt4PasLib name 'QPainter_setWorldMatrix';
function QPainter_worldMatrix(handle: QPainterH): QMatrixH; cdecl; external Qt4PasLib name 'QPainter_worldMatrix';
procedure QPainter_setWorldTransform(handle: QPainterH; matrix: QTransformH; combine: Boolean = False); cdecl; external Qt4PasLib name 'QPainter_setWorldTransform';
function QPainter_worldTransform(handle: QPainterH): QTransformH; cdecl; external Qt4PasLib name 'QPainter_worldTransform';
procedure QPainter_combinedMatrix(handle: QPainterH; retval: QMatrixH); cdecl; external Qt4PasLib name 'QPainter_combinedMatrix';
procedure QPainter_combinedTransform(handle: QPainterH; retval: QTransformH); cdecl; external Qt4PasLib name 'QPainter_combinedTransform';
procedure QPainter_setMatrixEnabled(handle: QPainterH; enabled: Boolean); cdecl; external Qt4PasLib name 'QPainter_setMatrixEnabled';
function QPainter_matrixEnabled(handle: QPainterH): Boolean; cdecl; external Qt4PasLib name 'QPainter_matrixEnabled';
procedure QPainter_setWorldMatrixEnabled(handle: QPainterH; enabled: Boolean); cdecl; external Qt4PasLib name 'QPainter_setWorldMatrixEnabled';
function QPainter_worldMatrixEnabled(handle: QPainterH): Boolean; cdecl; external Qt4PasLib name 'QPainter_worldMatrixEnabled';
procedure QPainter_scale(handle: QPainterH; sx: qreal; sy: qreal); cdecl; external Qt4PasLib name 'QPainter_scale';
procedure QPainter_shear(handle: QPainterH; sh: qreal; sv: qreal); cdecl; external Qt4PasLib name 'QPainter_shear';
procedure QPainter_rotate(handle: QPainterH; a: qreal); cdecl; external Qt4PasLib name 'QPainter_rotate';
procedure QPainter_translate(handle: QPainterH; offset: PQtPointF); cdecl; external Qt4PasLib name 'QPainter_translate';
procedure QPainter_translate(handle: QPainterH; offset: PQtPoint); cdecl; external Qt4PasLib name 'QPainter_translate2';
procedure QPainter_translate(handle: QPainterH; dx: qreal; dy: qreal); cdecl; external Qt4PasLib name 'QPainter_translate3';
procedure QPainter_window(handle: QPainterH; retval: PRect); cdecl; external Qt4PasLib name 'QPainter_window';
procedure QPainter_setWindow(handle: QPainterH; window: PRect); cdecl; external Qt4PasLib name 'QPainter_setWindow';
procedure QPainter_setWindow(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QPainter_setWindow2';
procedure QPainter_viewport(handle: QPainterH; retval: PRect); cdecl; external Qt4PasLib name 'QPainter_viewport';
procedure QPainter_setViewport(handle: QPainterH; viewport: PRect); cdecl; external Qt4PasLib name 'QPainter_setViewport';
procedure QPainter_setViewport(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QPainter_setViewport2';
procedure QPainter_setViewTransformEnabled(handle: QPainterH; enable: Boolean); cdecl; external Qt4PasLib name 'QPainter_setViewTransformEnabled';
function QPainter_viewTransformEnabled(handle: QPainterH): Boolean; cdecl; external Qt4PasLib name 'QPainter_viewTransformEnabled';
procedure QPainter_strokePath(handle: QPainterH; path: QPainterPathH; pen: QPenH); cdecl; external Qt4PasLib name 'QPainter_strokePath';
procedure QPainter_fillPath(handle: QPainterH; path: QPainterPathH; brush: QBrushH); cdecl; external Qt4PasLib name 'QPainter_fillPath';
procedure QPainter_drawPath(handle: QPainterH; path: QPainterPathH); cdecl; external Qt4PasLib name 'QPainter_drawPath';
procedure QPainter_drawPoint(handle: QPainterH; pt: PQtPointF); cdecl; external Qt4PasLib name 'QPainter_drawPoint';
procedure QPainter_drawPoint(handle: QPainterH; p: PQtPoint); cdecl; external Qt4PasLib name 'QPainter_drawPoint2';
procedure QPainter_drawPoint(handle: QPainterH; x: Integer; y: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPoint3';
procedure QPainter_drawPoints(handle: QPainterH; points: PQtPointF; pointCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPoints';
procedure QPainter_drawPoints(handle: QPainterH; points: QPolygonFH); cdecl; external Qt4PasLib name 'QPainter_drawPoints2';
procedure QPainter_drawPoints(handle: QPainterH; points: PQtPoint; pointCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPoints3';
procedure QPainter_drawPoints(handle: QPainterH; points: QPolygonH); cdecl; external Qt4PasLib name 'QPainter_drawPoints4';
procedure QPainter_drawLine(handle: QPainterH; line: QLineFH); cdecl; external Qt4PasLib name 'QPainter_drawLine';
procedure QPainter_drawLine(handle: QPainterH; line: QLineH); cdecl; external Qt4PasLib name 'QPainter_drawLine2';
procedure QPainter_drawLine(handle: QPainterH; x1: Integer; y1: Integer; x2: Integer; y2: Integer); cdecl; external Qt4PasLib name 'QPainter_drawLine3';
procedure QPainter_drawLine(handle: QPainterH; p1: PQtPoint; p2: PQtPoint); cdecl; external Qt4PasLib name 'QPainter_drawLine4';
procedure QPainter_drawLine(handle: QPainterH; p1: PQtPointF; p2: PQtPointF); cdecl; external Qt4PasLib name 'QPainter_drawLine5';
procedure QPainter_drawLines(handle: QPainterH; lines: QLineFH; lineCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawLines';
procedure QPainter_drawLines(handle: QPainterH; pointPairs: PQtPointF; lineCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawLines2';
procedure QPainter_drawLines(handle: QPainterH; lines: QLineH; lineCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawLines3';
procedure QPainter_drawLines(handle: QPainterH; pointPairs: PQtPoint; lineCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawLines4';
procedure QPainter_drawRect(handle: QPainterH; rect: QRectFH); cdecl; external Qt4PasLib name 'QPainter_drawRect';
procedure QPainter_drawRect(handle: QPainterH; x1: Integer; y1: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QPainter_drawRect2';
procedure QPainter_drawRect(handle: QPainterH; rect: PRect); cdecl; external Qt4PasLib name 'QPainter_drawRect3';
procedure QPainter_drawRects(handle: QPainterH; rects: QRectFH; rectCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawRects';
procedure QPainter_drawRects(handle: QPainterH; rects: PRect; rectCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawRects2';
procedure QPainter_drawEllipse(handle: QPainterH; r: QRectFH); cdecl; external Qt4PasLib name 'QPainter_drawEllipse';
procedure QPainter_drawEllipse(handle: QPainterH; r: PRect); cdecl; external Qt4PasLib name 'QPainter_drawEllipse2';
procedure QPainter_drawEllipse(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QPainter_drawEllipse3';
procedure QPainter_drawEllipse(handle: QPainterH; center: PQtPointF; rx: qreal; ry: qreal); cdecl; external Qt4PasLib name 'QPainter_drawEllipse4';
procedure QPainter_drawEllipse(handle: QPainterH; center: PQtPoint; rx: Integer; ry: Integer); cdecl; external Qt4PasLib name 'QPainter_drawEllipse5';
procedure QPainter_drawPolyline(handle: QPainterH; points: PQtPointF; pointCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPolyline';
procedure QPainter_drawPolyline(handle: QPainterH; polyline: QPolygonFH); cdecl; external Qt4PasLib name 'QPainter_drawPolyline2';
procedure QPainter_drawPolyline(handle: QPainterH; points: PQtPoint; pointCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPolyline3';
procedure QPainter_drawPolyline(handle: QPainterH; polygon: QPolygonH); cdecl; external Qt4PasLib name 'QPainter_drawPolyline4';
procedure QPainter_drawPolygon(handle: QPainterH; points: PQtPointF; pointCount: Integer; fillRule: QtFillRule = QtOddEvenFill); cdecl; external Qt4PasLib name 'QPainter_drawPolygon';
procedure QPainter_drawPolygon(handle: QPainterH; polygon: QPolygonFH; fillRule: QtFillRule = QtOddEvenFill); cdecl; external Qt4PasLib name 'QPainter_drawPolygon2';
procedure QPainter_drawPolygon(handle: QPainterH; points: PQtPoint; pointCount: Integer; fillRule: QtFillRule = QtOddEvenFill); cdecl; external Qt4PasLib name 'QPainter_drawPolygon3';
procedure QPainter_drawPolygon(handle: QPainterH; polygon: QPolygonH; fillRule: QtFillRule = QtOddEvenFill); cdecl; external Qt4PasLib name 'QPainter_drawPolygon4';
procedure QPainter_drawConvexPolygon(handle: QPainterH; points: PQtPointF; pointCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawConvexPolygon';
procedure QPainter_drawConvexPolygon(handle: QPainterH; polygon: QPolygonFH); cdecl; external Qt4PasLib name 'QPainter_drawConvexPolygon2';
procedure QPainter_drawConvexPolygon(handle: QPainterH; points: PQtPoint; pointCount: Integer); cdecl; external Qt4PasLib name 'QPainter_drawConvexPolygon3';
procedure QPainter_drawConvexPolygon(handle: QPainterH; polygon: QPolygonH); cdecl; external Qt4PasLib name 'QPainter_drawConvexPolygon4';
procedure QPainter_drawArc(handle: QPainterH; rect: QRectFH; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawArc';
procedure QPainter_drawArc(handle: QPainterH; p1: PRect; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawArc2';
procedure QPainter_drawArc(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawArc3';
procedure QPainter_drawPie(handle: QPainterH; rect: QRectFH; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPie';
procedure QPainter_drawPie(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPie2';
procedure QPainter_drawPie(handle: QPainterH; p1: PRect; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPie3';
procedure QPainter_drawChord(handle: QPainterH; rect: QRectFH; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawChord';
procedure QPainter_drawChord(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawChord2';
procedure QPainter_drawChord(handle: QPainterH; p1: PRect; a: Integer; alen: Integer); cdecl; external Qt4PasLib name 'QPainter_drawChord3';
procedure QPainter_drawRoundedRect(handle: QPainterH; rect: QRectFH; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt4PasLib name 'QPainter_drawRoundedRect';
procedure QPainter_drawRoundedRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt4PasLib name 'QPainter_drawRoundedRect2';
procedure QPainter_drawRoundedRect(handle: QPainterH; rect: PRect; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt4PasLib name 'QPainter_drawRoundedRect3';
procedure QPainter_drawRoundRect(handle: QPainterH; r: QRectFH; xround: Integer = 25; yround: Integer = 25); cdecl; external Qt4PasLib name 'QPainter_drawRoundRect';
procedure QPainter_drawRoundRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; p5: Integer = 25; p6: Integer = 25); cdecl; external Qt4PasLib name 'QPainter_drawRoundRect2';
procedure QPainter_drawRoundRect(handle: QPainterH; r: PRect; xround: Integer = 25; yround: Integer = 25); cdecl; external Qt4PasLib name 'QPainter_drawRoundRect3';
procedure QPainter_drawTiledPixmap(handle: QPainterH; rect: QRectFH; pm: QPixmapH; offset: PQtPointF = nil); cdecl; external Qt4PasLib name 'QPainter_drawTiledPixmap';
procedure QPainter_drawTiledPixmap(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; p5: QPixmapH; sx: Integer = 0; sy: Integer = 0); cdecl; external Qt4PasLib name 'QPainter_drawTiledPixmap2';
procedure QPainter_drawTiledPixmap(handle: QPainterH; p1: PRect; p2: QPixmapH; p3: PQtPoint = nil); cdecl; external Qt4PasLib name 'QPainter_drawTiledPixmap3';
procedure QPainter_drawPicture(handle: QPainterH; p: PQtPointF; picture: QPictureH); cdecl; external Qt4PasLib name 'QPainter_drawPicture';
procedure QPainter_drawPicture(handle: QPainterH; x: Integer; y: Integer; picture: QPictureH); cdecl; external Qt4PasLib name 'QPainter_drawPicture2';
procedure QPainter_drawPicture(handle: QPainterH; p: PQtPoint; picture: QPictureH); cdecl; external Qt4PasLib name 'QPainter_drawPicture3';
procedure QPainter_drawPixmap(handle: QPainterH; targetRect: QRectFH; pixmap: QPixmapH; sourceRect: QRectFH); cdecl; external Qt4PasLib name 'QPainter_drawPixmap';
procedure QPainter_drawPixmap(handle: QPainterH; targetRect: PRect; pixmap: QPixmapH; sourceRect: PRect); cdecl; external Qt4PasLib name 'QPainter_drawPixmap2';
procedure QPainter_drawPixmap(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; pm: QPixmapH; sx: Integer; sy: Integer; sw: Integer; sh: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPixmap3';
procedure QPainter_drawPixmap(handle: QPainterH; x: Integer; y: Integer; pm: QPixmapH; sx: Integer; sy: Integer; sw: Integer; sh: Integer); cdecl; external Qt4PasLib name 'QPainter_drawPixmap4';
procedure QPainter_drawPixmap(handle: QPainterH; p: PQtPointF; pm: QPixmapH; sr: QRectFH); cdecl; external Qt4PasLib name 'QPainter_drawPixmap5';
procedure QPainter_drawPixmap(handle: QPainterH; p: PQtPoint; pm: QPixmapH; sr: PRect); cdecl; external Qt4PasLib name 'QPainter_drawPixmap6';
procedure QPainter_drawPixmap(handle: QPainterH; p: PQtPointF; pm: QPixmapH); cdecl; external Qt4PasLib name 'QPainter_drawPixmap7';
procedure QPainter_drawPixmap(handle: QPainterH; p: PQtPoint; pm: QPixmapH); cdecl; external Qt4PasLib name 'QPainter_drawPixmap8';
procedure QPainter_drawPixmap(handle: QPainterH; x: Integer; y: Integer; pm: QPixmapH); cdecl; external Qt4PasLib name 'QPainter_drawPixmap9';
procedure QPainter_drawPixmap(handle: QPainterH; r: PRect; pm: QPixmapH); cdecl; external Qt4PasLib name 'QPainter_drawPixmap10';
procedure QPainter_drawPixmap(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; pm: QPixmapH); cdecl; external Qt4PasLib name 'QPainter_drawPixmap11';
procedure QPainter_drawImage(handle: QPainterH; targetRect: QRectFH; image: QImageH; sourceRect: QRectFH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QPainter_drawImage';
procedure QPainter_drawImage(handle: QPainterH; targetRect: PRect; image: QImageH; sourceRect: PRect; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QPainter_drawImage2';
procedure QPainter_drawImage(handle: QPainterH; p: PQtPointF; image: QImageH; sr: QRectFH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QPainter_drawImage3';
procedure QPainter_drawImage(handle: QPainterH; p: PQtPoint; image: QImageH; sr: PRect; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QPainter_drawImage4';
procedure QPainter_drawImage(handle: QPainterH; r: QRectFH; image: QImageH); cdecl; external Qt4PasLib name 'QPainter_drawImage5';
procedure QPainter_drawImage(handle: QPainterH; r: PRect; image: QImageH); cdecl; external Qt4PasLib name 'QPainter_drawImage6';
procedure QPainter_drawImage(handle: QPainterH; p: PQtPointF; image: QImageH); cdecl; external Qt4PasLib name 'QPainter_drawImage7';
procedure QPainter_drawImage(handle: QPainterH; p: PQtPoint; image: QImageH); cdecl; external Qt4PasLib name 'QPainter_drawImage8';
procedure QPainter_drawImage(handle: QPainterH; x: Integer; y: Integer; image: QImageH; sx: Integer = 0; sy: Integer = 0; sw: Integer = -1; sh: Integer = -1; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QPainter_drawImage9';
procedure QPainter_setLayoutDirection(handle: QPainterH; direction: QtLayoutDirection); cdecl; external Qt4PasLib name 'QPainter_setLayoutDirection';
function QPainter_layoutDirection(handle: QPainterH): QtLayoutDirection; cdecl; external Qt4PasLib name 'QPainter_layoutDirection';
procedure QPainter_drawText(handle: QPainterH; p: PQtPointF; s: PWideString); cdecl; external Qt4PasLib name 'QPainter_drawText';
procedure QPainter_drawText(handle: QPainterH; p: PQtPoint; s: PWideString); cdecl; external Qt4PasLib name 'QPainter_drawText2';
procedure QPainter_drawText(handle: QPainterH; x: Integer; y: Integer; s: PWideString); cdecl; external Qt4PasLib name 'QPainter_drawText3';
procedure QPainter_drawText(handle: QPainterH; p: PQtPointF; str: PWideString; tf: Integer; justificationPadding: Integer); cdecl; external Qt4PasLib name 'QPainter_drawText4';
procedure QPainter_drawText(handle: QPainterH; r: QRectFH; flags: Integer; text: PWideString; br: QRectFH = nil); cdecl; external Qt4PasLib name 'QPainter_drawText5';
procedure QPainter_drawText(handle: QPainterH; r: PRect; flags: Integer; text: PWideString; br: PRect = nil); cdecl; external Qt4PasLib name 'QPainter_drawText6';
procedure QPainter_drawText(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; flags: Integer; text: PWideString; br: PRect = nil); cdecl; external Qt4PasLib name 'QPainter_drawText7';
procedure QPainter_drawText(handle: QPainterH; r: QRectFH; text: PWideString; o: QTextOptionH = nil); cdecl; external Qt4PasLib name 'QPainter_drawText8';
procedure QPainter_boundingRect(handle: QPainterH; retval: QRectFH; rect: QRectFH; flags: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QPainter_boundingRect';
procedure QPainter_boundingRect(handle: QPainterH; retval: PRect; rect: PRect; flags: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QPainter_boundingRect2';
procedure QPainter_boundingRect(handle: QPainterH; retval: PRect; x: Integer; y: Integer; w: Integer; h: Integer; flags: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QPainter_boundingRect3';
procedure QPainter_boundingRect(handle: QPainterH; retval: QRectFH; rect: QRectFH; text: PWideString; o: QTextOptionH = nil); cdecl; external Qt4PasLib name 'QPainter_boundingRect4';
procedure QPainter_fillRect(handle: QPainterH; p1: QRectFH; p2: QBrushH); cdecl; external Qt4PasLib name 'QPainter_fillRect';
procedure QPainter_fillRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; p5: QBrushH); cdecl; external Qt4PasLib name 'QPainter_fillRect2';
procedure QPainter_fillRect(handle: QPainterH; p1: PRect; p2: QBrushH); cdecl; external Qt4PasLib name 'QPainter_fillRect3';
procedure QPainter_fillRect(handle: QPainterH; p1: QRectFH; color: PQColor); cdecl; external Qt4PasLib name 'QPainter_fillRect4';
procedure QPainter_fillRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; color: PQColor); cdecl; external Qt4PasLib name 'QPainter_fillRect5';
procedure QPainter_fillRect(handle: QPainterH; p1: PRect; color: PQColor); cdecl; external Qt4PasLib name 'QPainter_fillRect6';
procedure QPainter_fillRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; c: QtGlobalColor); cdecl; external Qt4PasLib name 'QPainter_fillRect7';
procedure QPainter_fillRect(handle: QPainterH; r: PRect; c: QtGlobalColor); cdecl; external Qt4PasLib name 'QPainter_fillRect8';
procedure QPainter_fillRect(handle: QPainterH; r: QRectFH; c: QtGlobalColor); cdecl; external Qt4PasLib name 'QPainter_fillRect9';
procedure QPainter_fillRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; style: QtBrushStyle); cdecl; external Qt4PasLib name 'QPainter_fillRect10';
procedure QPainter_fillRect(handle: QPainterH; r: PRect; style: QtBrushStyle); cdecl; external Qt4PasLib name 'QPainter_fillRect11';
procedure QPainter_fillRect(handle: QPainterH; r: QRectFH; style: QtBrushStyle); cdecl; external Qt4PasLib name 'QPainter_fillRect12';
procedure QPainter_eraseRect(handle: QPainterH; p1: QRectFH); cdecl; external Qt4PasLib name 'QPainter_eraseRect';
procedure QPainter_eraseRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QPainter_eraseRect2';
procedure QPainter_eraseRect(handle: QPainterH; p1: PRect); cdecl; external Qt4PasLib name 'QPainter_eraseRect3';
procedure QPainter_setRenderHint(handle: QPainterH; hint: QPainterRenderHint; _on: Boolean = True); cdecl; external Qt4PasLib name 'QPainter_setRenderHint';
procedure QPainter_setRenderHints(handle: QPainterH; hints: QPainterRenderHints; _on: Boolean = True); cdecl; external Qt4PasLib name 'QPainter_setRenderHints';
function QPainter_renderHints(handle: QPainterH): QPainterRenderHints; cdecl; external Qt4PasLib name 'QPainter_renderHints';
function QPainter_testRenderHint(handle: QPainterH; hint: QPainterRenderHint): Boolean; cdecl; external Qt4PasLib name 'QPainter_testRenderHint';
function QPainter_paintEngine(handle: QPainterH): QPaintEngineH; cdecl; external Qt4PasLib name 'QPainter_paintEngine';
procedure QPainter_setRedirected(device: QPaintDeviceH; replacement: QPaintDeviceH; offset: PQtPoint = nil); cdecl; external Qt4PasLib name 'QPainter_setRedirected';
function QPainter_redirected(device: QPaintDeviceH; offset: PQtPoint = nil): QPaintDeviceH; cdecl; external Qt4PasLib name 'QPainter_redirected';
procedure QPainter_restoreRedirected(device: QPaintDeviceH); cdecl; external Qt4PasLib name 'QPainter_restoreRedirected';


type
  QPaintEnginePolygonDrawMode = ( // QPaintEngine::PolygonDrawMode (1)
    QPaintEngineOddEvenMode, QPaintEngineWindingMode, QPaintEngineConvexMode, QPaintEnginePolylineMode );

type
  QPaintEnginePaintEngineFeature = cardinal; // QPaintEngine::PaintEngineFeature
  QPaintEnginePaintEngineFeatures = QPaintEnginePaintEngineFeature; //QFlags<> (3)
const
  QPaintEnginePrimitiveTransform =   $00000001;
  QPaintEnginePatternTransform =   $00000002;
  QPaintEnginePixmapTransform =   $00000004;
  QPaintEnginePatternBrush =   $00000008;
  QPaintEngineLinearGradientFill =   $00000010;
  QPaintEngineRadialGradientFill =   $00000020;
  QPaintEngineConicalGradientFill =   $00000040;
  QPaintEngineAlphaBlend =   $00000080;
  QPaintEnginePorterDuff =   $00000100;
  QPaintEnginePainterPaths =   $00000200;
  QPaintEngineAntialiasing =   $00000400;
  QPaintEngineBrushStroke =   $00000800;
  QPaintEngineConstantOpacity =   $00001000;
  QPaintEngineMaskedBrush =   $00002000;
  QPaintEnginePerspectiveTransform =   $00004000;
  QPaintEngineBlendModes =   $00008000;
  QPaintEngineObjectBoundingModeGradients =   $00010000;
  QPaintEngineRasterOpModes =   $00020000;
  QPaintEnginePaintOutsidePaintEvent =   $20000000;
  QPaintEngineAllFeatures =   $ffffffff;

type
  QPaintEngineDirtyFlag = cardinal; // QPaintEngine::DirtyFlag
  QPaintEngineDirtyFlags = QPaintEngineDirtyFlag; //QFlags<> (3)
const
  QPaintEngineDirtyPen =   $0001;
  QPaintEngineDirtyBrush =   $0002;
  QPaintEngineDirtyBrushOrigin =   $0004;
  QPaintEngineDirtyFont =   $0008;
  QPaintEngineDirtyBackground =   $0010;
  QPaintEngineDirtyBackgroundMode =   $0020;
  QPaintEngineDirtyTransform =   $0040;
  QPaintEngineDirtyClipRegion =   $0080;
  QPaintEngineDirtyClipPath =   $0100;
  QPaintEngineDirtyHints =   $0200;
  QPaintEngineDirtyCompositionMode =   $0400;
  QPaintEngineDirtyClipEnabled =   $0800;
  QPaintEngineDirtyOpacity =   $1000;
  QPaintEngineAllDirty =   $ffff;


type
  QPaintEngineType = (  //QPaintEngine::Type (2)
    QPaintEngineX11,
    QPaintEngineWindows,
    QPaintEngineQuickDraw,
    QPaintEngineCoreGraphics,
    QPaintEngineMacPrinter,
    QPaintEngineQWindowSystem,
    QPaintEnginePostScript,
    QPaintEngineOpenGL,
    QPaintEnginePicture,
    QPaintEngineSVG,
    QPaintEngineRaster,
    QPaintEngineDirect3D,
    QPaintEnginePdf,
    QPaintEngineOpenVG,
    QPaintEngineUser = 50,
    QPaintEngineMaxUser = 100 );

function QPaintEngine_isActive(handle: QPaintEngineH): Boolean; cdecl; external Qt4PasLib name 'QPaintEngine_isActive';
procedure QPaintEngine_setActive(handle: QPaintEngineH; newState: Boolean); cdecl; external Qt4PasLib name 'QPaintEngine_setActive';
function QPaintEngine_begin(handle: QPaintEngineH; pdev: QPaintDeviceH): Boolean; cdecl; external Qt4PasLib name 'QPaintEngine_begin';
function QPaintEngine_end(handle: QPaintEngineH): Boolean; cdecl; external Qt4PasLib name 'QPaintEngine_end';
procedure QPaintEngine_drawRects(handle: QPaintEngineH; rects: PRect; rectCount: Integer); cdecl; external Qt4PasLib name 'QPaintEngine_drawRects';
procedure QPaintEngine_drawRects(handle: QPaintEngineH; rects: QRectFH; rectCount: Integer); cdecl; external Qt4PasLib name 'QPaintEngine_drawRects2';
procedure QPaintEngine_drawLines(handle: QPaintEngineH; lines: QLineH; lineCount: Integer); cdecl; external Qt4PasLib name 'QPaintEngine_drawLines';
procedure QPaintEngine_drawLines(handle: QPaintEngineH; lines: QLineFH; lineCount: Integer); cdecl; external Qt4PasLib name 'QPaintEngine_drawLines2';
procedure QPaintEngine_drawEllipse(handle: QPaintEngineH; r: QRectFH); cdecl; external Qt4PasLib name 'QPaintEngine_drawEllipse';
procedure QPaintEngine_drawEllipse(handle: QPaintEngineH; r: PRect); cdecl; external Qt4PasLib name 'QPaintEngine_drawEllipse2';
procedure QPaintEngine_drawPath(handle: QPaintEngineH; path: QPainterPathH); cdecl; external Qt4PasLib name 'QPaintEngine_drawPath';
procedure QPaintEngine_drawPoints(handle: QPaintEngineH; points: PQtPointF; pointCount: Integer); cdecl; external Qt4PasLib name 'QPaintEngine_drawPoints';
procedure QPaintEngine_drawPoints(handle: QPaintEngineH; points: PQtPoint; pointCount: Integer); cdecl; external Qt4PasLib name 'QPaintEngine_drawPoints2';
procedure QPaintEngine_drawPolygon(handle: QPaintEngineH; points: PQtPointF; pointCount: Integer; mode: QPaintEnginePolygonDrawMode); cdecl; external Qt4PasLib name 'QPaintEngine_drawPolygon';
procedure QPaintEngine_drawPolygon(handle: QPaintEngineH; points: PQtPoint; pointCount: Integer; mode: QPaintEnginePolygonDrawMode); cdecl; external Qt4PasLib name 'QPaintEngine_drawPolygon2';
procedure QPaintEngine_drawPixmap(handle: QPaintEngineH; r: QRectFH; pm: QPixmapH; sr: QRectFH); cdecl; external Qt4PasLib name 'QPaintEngine_drawPixmap';
procedure QPaintEngine_drawTiledPixmap(handle: QPaintEngineH; r: QRectFH; pixmap: QPixmapH; s: PQtPointF); cdecl; external Qt4PasLib name 'QPaintEngine_drawTiledPixmap';
procedure QPaintEngine_drawImage(handle: QPaintEngineH; r: QRectFH; pm: QImageH; sr: QRectFH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QPaintEngine_drawImage';
procedure QPaintEngine_setPaintDevice(handle: QPaintEngineH; device: QPaintDeviceH); cdecl; external Qt4PasLib name 'QPaintEngine_setPaintDevice';
function QPaintEngine_paintDevice(handle: QPaintEngineH): QPaintDeviceH; cdecl; external Qt4PasLib name 'QPaintEngine_paintDevice';
procedure QPaintEngine_setSystemClip(handle: QPaintEngineH; baseClip: QRegionH); cdecl; external Qt4PasLib name 'QPaintEngine_setSystemClip';
procedure QPaintEngine_systemClip(handle: QPaintEngineH; retval: QRegionH); cdecl; external Qt4PasLib name 'QPaintEngine_systemClip';
procedure QPaintEngine_setSystemRect(handle: QPaintEngineH; rect: PRect); cdecl; external Qt4PasLib name 'QPaintEngine_setSystemRect';
procedure QPaintEngine_systemRect(handle: QPaintEngineH; retval: PRect); cdecl; external Qt4PasLib name 'QPaintEngine_systemRect';
procedure QPaintEngine_coordinateOffset(handle: QPaintEngineH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QPaintEngine_coordinateOffset';
function QPaintEngine_type(handle: QPaintEngineH): QPaintEngineType; cdecl; external Qt4PasLib name 'QPaintEngine_type';
procedure QPaintEngine_fix_neg_rect(handle: QPaintEngineH; x: PInteger; y: PInteger; w: PInteger; h: PInteger); cdecl; external Qt4PasLib name 'QPaintEngine_fix_neg_rect';
function QPaintEngine_testDirty(handle: QPaintEngineH; df: QPaintEngineDirtyFlags): Boolean; cdecl; external Qt4PasLib name 'QPaintEngine_testDirty';
procedure QPaintEngine_setDirty(handle: QPaintEngineH; df: QPaintEngineDirtyFlags); cdecl; external Qt4PasLib name 'QPaintEngine_setDirty';
procedure QPaintEngine_clearDirty(handle: QPaintEngineH; df: QPaintEngineDirtyFlags); cdecl; external Qt4PasLib name 'QPaintEngine_clearDirty';
function QPaintEngine_hasFeature(handle: QPaintEngineH; feature: QPaintEnginePaintEngineFeatures): Boolean; cdecl; external Qt4PasLib name 'QPaintEngine_hasFeature';
function QPaintEngine_painter(handle: QPaintEngineH): QPainterH; cdecl; external Qt4PasLib name 'QPaintEngine_painter';
procedure QPaintEngine_syncState(handle: QPaintEngineH); cdecl; external Qt4PasLib name 'QPaintEngine_syncState';
function QPaintEngine_isExtended(handle: QPaintEngineH): Boolean; cdecl; external Qt4PasLib name 'QPaintEngine_isExtended';
{$ifdef MSWINDOWS }
function QPaintEngine_getDC(handle: QPaintEngineH): QHDC; cdecl; external Qt4PasLib name 'QPaintEngine_getDC';
procedure QPaintEngine_releaseDC(handle: QPaintEngineH; hdc: QHDC); cdecl; external Qt4PasLib name 'QPaintEngine_releaseDC';
{$endif}


type
  QPaintDevicePaintDeviceMetric = (  //QPaintDevice::PaintDeviceMetric (2)
    QPaintDevicePdmWidth = 1,
    QPaintDevicePdmHeight,
    QPaintDevicePdmWidthMM,
    QPaintDevicePdmHeightMM,
    QPaintDevicePdmNumColors,
    QPaintDevicePdmDepth,
    QPaintDevicePdmDpiX,
    QPaintDevicePdmDpiY,
    QPaintDevicePdmPhysicalDpiX,
    QPaintDevicePdmPhysicalDpiY );

function QPaintDevice_devType(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_devType';
function QPaintDevice_paintingActive(handle: QPaintDeviceH): Boolean; cdecl; external Qt4PasLib name 'QPaintDevice_paintingActive';
function QPaintDevice_paintEngine(handle: QPaintDeviceH): QPaintEngineH; cdecl; external Qt4PasLib name 'QPaintDevice_paintEngine';
function QPaintDevice_width(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_width';
function QPaintDevice_height(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_height';
function QPaintDevice_widthMM(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_widthMM';
function QPaintDevice_heightMM(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_heightMM';
function QPaintDevice_logicalDpiX(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_logicalDpiX';
function QPaintDevice_logicalDpiY(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_logicalDpiY';
function QPaintDevice_physicalDpiX(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_physicalDpiX';
function QPaintDevice_physicalDpiY(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_physicalDpiY';
function QPaintDevice_numColors(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_numColors';
function QPaintDevice_depth(handle: QPaintDeviceH): Integer; cdecl; external Qt4PasLib name 'QPaintDevice_depth';
{$ifdef MSWINDOWS }
function QPaintDevice_getDC(handle: QPaintDeviceH): QHDC; cdecl; external Qt4PasLib name 'QPaintDevice_getDC';
procedure QPaintDevice_releaseDC(handle: QPaintDeviceH; hdc: QHDC); cdecl; external Qt4PasLib name 'QPaintDevice_releaseDC';
{$endif}


type
  QRegionRegionType = ( // QRegion::RegionType (1)
    QRegionRectangle, QRegionEllipse );

function QRegion_create(): QRegionH; cdecl; external Qt4PasLib name 'QRegion_create';
procedure QRegion_destroy(handle: QRegionH); cdecl; external Qt4PasLib name 'QRegion_destroy'; 
function QRegion_create(x: Integer; y: Integer; w: Integer; h: Integer; t: QRegionRegionType = QRegionRectangle): QRegionH; cdecl; external Qt4PasLib name 'QRegion_create2';
function QRegion_create(r: PRect; t: QRegionRegionType = QRegionRectangle): QRegionH; cdecl; external Qt4PasLib name 'QRegion_create3';
function QRegion_create(pa: QPolygonH; fillRule: QtFillRule = QtOddEvenFill): QRegionH; cdecl; external Qt4PasLib name 'QRegion_create4';
function QRegion_create(region: QRegionH): QRegionH; cdecl; external Qt4PasLib name 'QRegion_create5';
function QRegion_create(bitmap: QBitmapH): QRegionH; cdecl; external Qt4PasLib name 'QRegion_create6';
function QRegion_isEmpty(handle: QRegionH): Boolean; cdecl; external Qt4PasLib name 'QRegion_isEmpty';
function QRegion_contains(handle: QRegionH; p: PQtPoint): Boolean; cdecl; external Qt4PasLib name 'QRegion_contains';
function QRegion_contains(handle: QRegionH; r: PRect): Boolean; cdecl; external Qt4PasLib name 'QRegion_contains2';
procedure QRegion_translate(handle: QRegionH; dx: Integer; dy: Integer); cdecl; external Qt4PasLib name 'QRegion_translate';
procedure QRegion_translate(handle: QRegionH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRegion_translate2';
procedure QRegion_translated(handle: QRegionH; retval: QRegionH; dx: Integer; dy: Integer); cdecl; external Qt4PasLib name 'QRegion_translated';
procedure QRegion_translated(handle: QRegionH; retval: QRegionH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRegion_translated2';
procedure QRegion_unite(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QRegion_unite';
procedure QRegion_unite(handle: QRegionH; retval: QRegionH; r: PRect); cdecl; external Qt4PasLib name 'QRegion_unite2';
procedure QRegion_intersect(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QRegion_intersect';
procedure QRegion_intersect(handle: QRegionH; retval: QRegionH; r: PRect); cdecl; external Qt4PasLib name 'QRegion_intersect2';
procedure QRegion_subtract(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QRegion_subtract';
procedure QRegion_eor(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QRegion_eor';
procedure QRegion_united(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QRegion_united';
procedure QRegion_united(handle: QRegionH; retval: QRegionH; r: PRect); cdecl; external Qt4PasLib name 'QRegion_united2';
procedure QRegion_intersected(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QRegion_intersected';
procedure QRegion_intersected(handle: QRegionH; retval: QRegionH; r: PRect); cdecl; external Qt4PasLib name 'QRegion_intersected2';
procedure QRegion_subtracted(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QRegion_subtracted';
procedure QRegion_xored(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QRegion_xored';
function QRegion_intersects(handle: QRegionH; r: QRegionH): Boolean; cdecl; external Qt4PasLib name 'QRegion_intersects';
function QRegion_intersects(handle: QRegionH; r: PRect): Boolean; cdecl; external Qt4PasLib name 'QRegion_intersects2';
procedure QRegion_boundingRect(handle: QRegionH; retval: PRect); cdecl; external Qt4PasLib name 'QRegion_boundingRect';
procedure QRegion_setRects(handle: QRegionH; rect: PRect; num: Integer); cdecl; external Qt4PasLib name 'QRegion_setRects';
function QRegion_numRects(handle: QRegionH): Integer; cdecl; external Qt4PasLib name 'QRegion_numRects';
{$ifdef BINUX }
function QRegion_handle(handle: QRegionH): Region; cdecl; external Qt4PasLib name 'QRegion_handle';
{$endif}
{$ifdef MSWINDOWS }
function QRegion_handle(handle: QRegionH): QHRGN; cdecl; external Qt4PasLib name 'QRegion_handle2';
{$endif}
{$ifdef DARWIN }
function QRegion_handle(handle: QRegionH): RgnHandle; cdecl; external Qt4PasLib name 'QRegion_handle3';
function QRegion_handle(handle: QRegionH; p1: Boolean): RgnHandle; cdecl; external Qt4PasLib name 'QRegion_handle4';
function QRegion_toHIMutableShape(handle: QRegionH): Pointer; cdecl; external Qt4PasLib name 'QRegion_toHIMutableShape';
procedure QRegion_fromHIShapeRef(retval: QRegionH; shape: Pointer); cdecl; external Qt4PasLib name 'QRegion_fromHIShapeRef';
{$endif}
{$ifdef QTOPIA }
function QRegion_handle(handle: QRegionH): Pointer; cdecl; external Qt4PasLib name 'QRegion_handle5';
{$endif}


type
  QPrinterPrinterMode = ( // QPrinter::PrinterMode (1)
    QPrinterScreenResolution, QPrinterPrinterResolution, QPrinterHighResolution );

  QPrinterOrientation = ( // QPrinter::Orientation (1)
    QPrinterPortrait, QPrinterLandscape );

  QPrinterPageOrder = ( // QPrinter::PageOrder (1)
    QPrinterFirstPageFirst, QPrinterLastPageFirst );

  QPrinterColorMode = ( // QPrinter::ColorMode (1)
    QPrinterGrayScale, QPrinterColor );

  QPrinterPaperSource = ( // QPrinter::PaperSource (1)
    QPrinterOnlyOne, QPrinterLower, QPrinterMiddle, QPrinterManual, QPrinterEnvelope, QPrinterEnvelopeManual, QPrinterAuto, QPrinterTractor, QPrinterSmallFormat, QPrinterLargeFormat, QPrinterLargeCapacity, 
    QPrinterCassette, QPrinterFormSource, QPrinterMaxPageSource );

  QPrinterPrinterState = ( // QPrinter::PrinterState (1)
    QPrinterIdle, QPrinterActive, QPrinterAborted, QPrinterError );

  QPrinterOutputFormat = ( // QPrinter::OutputFormat (1)
    QPrinterNativeFormat, QPrinterPdfFormat, QPrinterPostScriptFormat );

  QPrinterPrintRange = ( // QPrinter::PrintRange (1)
    QPrinterAllPages, QPrinterSelection, QPrinterPageRange );

  QPrinterUnit = ( // QPrinter::Unit (1)
    QPrinterMillimeter, QPrinterPoint, QPrinterInch, QPrinterPica, QPrinterDidot, QPrinterCicero, QPrinterDevicePixel );

  QPrinterDuplexMode = (  //QPrinter::DuplexMode (2)
    QPrinterDuplexNone = 0,
    QPrinterDuplexAuto,
    QPrinterDuplexLongSide,
    QPrinterDuplexShortSide );

type
  QPrinterPageSize = cardinal; //  QPrinter::PageSize (4)

const
    QPrinterA4 = 0 { $0 };
    QPrinterB5 = 1 { $1 };
    QPrinterLetter = 2 { $2 };
    QPrinterLegal = 3 { $3 };
    QPrinterExecutive = 4 { $4 };
    QPrinterA0 = 5 { $5 };
    QPrinterA1 = 6 { $6 };
    QPrinterA2 = 7 { $7 };
    QPrinterA3 = 8 { $8 };
    QPrinterA5 = 9 { $9 };
    QPrinterA6 = 10 { $a };
    QPrinterA7 = 11 { $b };
    QPrinterA8 = 12 { $c };
    QPrinterA9 = 13 { $d };
    QPrinterB0 = 14 { $e };
    QPrinterB1 = 15 { $f };
    QPrinterB10 = 16 { $10 };
    QPrinterB2 = 17 { $11 };
    QPrinterB3 = 18 { $12 };
    QPrinterB4 = 19 { $13 };
    QPrinterB6 = 20 { $14 };
    QPrinterB7 = 21 { $15 };
    QPrinterB8 = 22 { $16 };
    QPrinterB9 = 23 { $17 };
    QPrinterC5E = 24 { $18 };
    QPrinterComm10E = 25 { $19 };
    QPrinterDLE = 26 { $1a };
    QPrinterFolio = 27 { $1b };
    QPrinterLedger = 28 { $1c };
    QPrinterTabloid = 29 { $1d };
    QPrinterCustom = 30 { $1e };
    QPrinterNPageSize = 30 { $1e };
    QPrinterNPaperSize = 30 { $1e };


function QPrinter_create(mode: QPrinterPrinterMode = QPrinterScreenResolution): QPrinterH; cdecl; external Qt4PasLib name 'QPrinter_create';
procedure QPrinter_destroy(handle: QPrinterH); cdecl; external Qt4PasLib name 'QPrinter_destroy'; 
function QPrinter_create(printer: QPrinterInfoH; mode: QPrinterPrinterMode = QPrinterScreenResolution): QPrinterH; cdecl; external Qt4PasLib name 'QPrinter_create2';
function QPrinter_devType(handle: QPrinterH): Integer; cdecl; external Qt4PasLib name 'QPrinter_devType';
procedure QPrinter_setOutputFormat(handle: QPrinterH; format: QPrinterOutputFormat); cdecl; external Qt4PasLib name 'QPrinter_setOutputFormat';
function QPrinter_outputFormat(handle: QPrinterH): QPrinterOutputFormat; cdecl; external Qt4PasLib name 'QPrinter_outputFormat';
procedure QPrinter_setPrinterName(handle: QPrinterH; p1: PWideString); cdecl; external Qt4PasLib name 'QPrinter_setPrinterName';
procedure QPrinter_printerName(handle: QPrinterH; retval: PWideString); cdecl; external Qt4PasLib name 'QPrinter_printerName';
function QPrinter_isValid(handle: QPrinterH): Boolean; cdecl; external Qt4PasLib name 'QPrinter_isValid';
procedure QPrinter_setOutputFileName(handle: QPrinterH; p1: PWideString); cdecl; external Qt4PasLib name 'QPrinter_setOutputFileName';
procedure QPrinter_outputFileName(handle: QPrinterH; retval: PWideString); cdecl; external Qt4PasLib name 'QPrinter_outputFileName';
procedure QPrinter_setPrintProgram(handle: QPrinterH; p1: PWideString); cdecl; external Qt4PasLib name 'QPrinter_setPrintProgram';
procedure QPrinter_printProgram(handle: QPrinterH; retval: PWideString); cdecl; external Qt4PasLib name 'QPrinter_printProgram';
procedure QPrinter_setDocName(handle: QPrinterH; p1: PWideString); cdecl; external Qt4PasLib name 'QPrinter_setDocName';
procedure QPrinter_docName(handle: QPrinterH; retval: PWideString); cdecl; external Qt4PasLib name 'QPrinter_docName';
procedure QPrinter_setCreator(handle: QPrinterH; p1: PWideString); cdecl; external Qt4PasLib name 'QPrinter_setCreator';
procedure QPrinter_creator(handle: QPrinterH; retval: PWideString); cdecl; external Qt4PasLib name 'QPrinter_creator';
procedure QPrinter_setOrientation(handle: QPrinterH; p1: QPrinterOrientation); cdecl; external Qt4PasLib name 'QPrinter_setOrientation';
function QPrinter_orientation(handle: QPrinterH): QPrinterOrientation; cdecl; external Qt4PasLib name 'QPrinter_orientation';
procedure QPrinter_setPageSize(handle: QPrinterH; p1: QPrinterPageSize); cdecl; external Qt4PasLib name 'QPrinter_setPageSize';
function QPrinter_pageSize(handle: QPrinterH): QPrinterPageSize; cdecl; external Qt4PasLib name 'QPrinter_pageSize';
procedure QPrinter_setPaperSize(handle: QPrinterH; p1: QPrinterPageSize); cdecl; external Qt4PasLib name 'QPrinter_setPaperSize';
function QPrinter_paperSize(handle: QPrinterH): QPrinterPageSize; cdecl; external Qt4PasLib name 'QPrinter_paperSize';
procedure QPrinter_setPaperSize(handle: QPrinterH; paperSize: QSizeFH; _unit: QPrinterUnit); cdecl; external Qt4PasLib name 'QPrinter_setPaperSize2';
procedure QPrinter_paperSize(handle: QPrinterH; retval: QSizeFH; _unit: QPrinterUnit); cdecl; external Qt4PasLib name 'QPrinter_paperSize2';
procedure QPrinter_setPageOrder(handle: QPrinterH; p1: QPrinterPageOrder); cdecl; external Qt4PasLib name 'QPrinter_setPageOrder';
function QPrinter_pageOrder(handle: QPrinterH): QPrinterPageOrder; cdecl; external Qt4PasLib name 'QPrinter_pageOrder';
procedure QPrinter_setResolution(handle: QPrinterH; p1: Integer); cdecl; external Qt4PasLib name 'QPrinter_setResolution';
function QPrinter_resolution(handle: QPrinterH): Integer; cdecl; external Qt4PasLib name 'QPrinter_resolution';
procedure QPrinter_setColorMode(handle: QPrinterH; p1: QPrinterColorMode); cdecl; external Qt4PasLib name 'QPrinter_setColorMode';
function QPrinter_colorMode(handle: QPrinterH): QPrinterColorMode; cdecl; external Qt4PasLib name 'QPrinter_colorMode';
procedure QPrinter_setCollateCopies(handle: QPrinterH; collate: Boolean); cdecl; external Qt4PasLib name 'QPrinter_setCollateCopies';
function QPrinter_collateCopies(handle: QPrinterH): Boolean; cdecl; external Qt4PasLib name 'QPrinter_collateCopies';
procedure QPrinter_setFullPage(handle: QPrinterH; p1: Boolean); cdecl; external Qt4PasLib name 'QPrinter_setFullPage';
function QPrinter_fullPage(handle: QPrinterH): Boolean; cdecl; external Qt4PasLib name 'QPrinter_fullPage';
procedure QPrinter_setNumCopies(handle: QPrinterH; p1: Integer); cdecl; external Qt4PasLib name 'QPrinter_setNumCopies';
function QPrinter_numCopies(handle: QPrinterH): Integer; cdecl; external Qt4PasLib name 'QPrinter_numCopies';
procedure QPrinter_setPaperSource(handle: QPrinterH; p1: QPrinterPaperSource); cdecl; external Qt4PasLib name 'QPrinter_setPaperSource';
function QPrinter_paperSource(handle: QPrinterH): QPrinterPaperSource; cdecl; external Qt4PasLib name 'QPrinter_paperSource';
procedure QPrinter_setDuplex(handle: QPrinterH; duplex: QPrinterDuplexMode); cdecl; external Qt4PasLib name 'QPrinter_setDuplex';
function QPrinter_duplex(handle: QPrinterH): QPrinterDuplexMode; cdecl; external Qt4PasLib name 'QPrinter_duplex';
procedure QPrinter_supportedResolutions(handle: QPrinterH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QPrinter_supportedResolutions';
procedure QPrinter_setFontEmbeddingEnabled(handle: QPrinterH; enable: Boolean); cdecl; external Qt4PasLib name 'QPrinter_setFontEmbeddingEnabled';
function QPrinter_fontEmbeddingEnabled(handle: QPrinterH): Boolean; cdecl; external Qt4PasLib name 'QPrinter_fontEmbeddingEnabled';
procedure QPrinter_setDoubleSidedPrinting(handle: QPrinterH; enable: Boolean); cdecl; external Qt4PasLib name 'QPrinter_setDoubleSidedPrinting';
function QPrinter_doubleSidedPrinting(handle: QPrinterH): Boolean; cdecl; external Qt4PasLib name 'QPrinter_doubleSidedPrinting';
procedure QPrinter_paperRect(handle: QPrinterH; retval: PRect); cdecl; external Qt4PasLib name 'QPrinter_paperRect';
procedure QPrinter_pageRect(handle: QPrinterH; retval: PRect); cdecl; external Qt4PasLib name 'QPrinter_pageRect';
procedure QPrinter_paperRect(handle: QPrinterH; retval: QRectFH; p1: QPrinterUnit); cdecl; external Qt4PasLib name 'QPrinter_paperRect2';
procedure QPrinter_pageRect(handle: QPrinterH; retval: QRectFH; p1: QPrinterUnit); cdecl; external Qt4PasLib name 'QPrinter_pageRect2';
{$ifdef BINUX or DARWIN or QTOPIA }
procedure QPrinter_printerSelectionOption(handle: QPrinterH; retval: PWideString); cdecl; external Qt4PasLib name 'QPrinter_printerSelectionOption';
procedure QPrinter_setPrinterSelectionOption(handle: QPrinterH; p1: PWideString); cdecl; external Qt4PasLib name 'QPrinter_setPrinterSelectionOption';
{$endif}
function QPrinter_newPage(handle: QPrinterH): Boolean; cdecl; external Qt4PasLib name 'QPrinter_newPage';
function QPrinter_abort(handle: QPrinterH): Boolean; cdecl; external Qt4PasLib name 'QPrinter_abort';
function QPrinter_printerState(handle: QPrinterH): QPrinterPrinterState; cdecl; external Qt4PasLib name 'QPrinter_printerState';
function QPrinter_paintEngine(handle: QPrinterH): QPaintEngineH; cdecl; external Qt4PasLib name 'QPrinter_paintEngine';
function QPrinter_printEngine(handle: QPrinterH): QPrintEngineH; cdecl; external Qt4PasLib name 'QPrinter_printEngine';
procedure QPrinter_setFromTo(handle: QPrinterH; fromPage: Integer; toPage: Integer); cdecl; external Qt4PasLib name 'QPrinter_setFromTo';
function QPrinter_fromPage(handle: QPrinterH): Integer; cdecl; external Qt4PasLib name 'QPrinter_fromPage';
function QPrinter_toPage(handle: QPrinterH): Integer; cdecl; external Qt4PasLib name 'QPrinter_toPage';
procedure QPrinter_setPrintRange(handle: QPrinterH; range: QPrinterPrintRange); cdecl; external Qt4PasLib name 'QPrinter_setPrintRange';
function QPrinter_printRange(handle: QPrinterH): QPrinterPrintRange; cdecl; external Qt4PasLib name 'QPrinter_printRange';
procedure QPrinter_setPageMargins(handle: QPrinterH; left: qreal; top: qreal; right: qreal; bottom: qreal; _unit: QPrinterUnit); cdecl; external Qt4PasLib name 'QPrinter_setPageMargins';
procedure QPrinter_getPageMargins(handle: QPrinterH; left: PQReal; top: PQReal; right: PQReal; bottom: PQReal; _unit: QPrinterUnit); cdecl; external Qt4PasLib name 'QPrinter_getPageMargins';
{$ifdef MSWINDOWS }
procedure QPrinter_setWinPageSize(handle: QPrinterH; winPageSize: Integer); cdecl; external Qt4PasLib name 'QPrinter_setWinPageSize';
function QPrinter_winPageSize(handle: QPrinterH): Integer; cdecl; external Qt4PasLib name 'QPrinter_winPageSize';
function QPrinter_getDC(handle: QPrinterH): QHDC; cdecl; external Qt4PasLib name 'QPrinter_getDC';
procedure QPrinter_releaseDC(handle: QPrinterH; hdc: QHDC); cdecl; external Qt4PasLib name 'QPrinter_releaseDC';
{$endif}


type
  QPainterPathElementType = ( // QPainterPath::ElementType (1)
    QPainterPathMoveToElement, QPainterPathLineToElement, QPainterPathCurveToElement, QPainterPathCurveToDataElement );

function QPainterPath_create(): QPainterPathH; cdecl; external Qt4PasLib name 'QPainterPath_create';
procedure QPainterPath_destroy(handle: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_destroy'; 
function QPainterPath_create(startPoint: PQtPointF): QPainterPathH; cdecl; external Qt4PasLib name 'QPainterPath_create2';
function QPainterPath_create(other: QPainterPathH): QPainterPathH; cdecl; external Qt4PasLib name 'QPainterPath_create3';
procedure QPainterPath_closeSubpath(handle: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_closeSubpath';
procedure QPainterPath_moveTo(handle: QPainterPathH; p: PQtPointF); cdecl; external Qt4PasLib name 'QPainterPath_moveTo';
procedure QPainterPath_moveTo(handle: QPainterPathH; x: qreal; y: qreal); cdecl; external Qt4PasLib name 'QPainterPath_moveTo2';
procedure QPainterPath_lineTo(handle: QPainterPathH; p: PQtPointF); cdecl; external Qt4PasLib name 'QPainterPath_lineTo';
procedure QPainterPath_lineTo(handle: QPainterPathH; x: qreal; y: qreal); cdecl; external Qt4PasLib name 'QPainterPath_lineTo2';
procedure QPainterPath_arcMoveTo(handle: QPainterPathH; rect: QRectFH; angle: qreal); cdecl; external Qt4PasLib name 'QPainterPath_arcMoveTo';
procedure QPainterPath_arcMoveTo(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; angle: qreal); cdecl; external Qt4PasLib name 'QPainterPath_arcMoveTo2';
procedure QPainterPath_arcTo(handle: QPainterPathH; rect: QRectFH; startAngle: qreal; arcLength: qreal); cdecl; external Qt4PasLib name 'QPainterPath_arcTo';
procedure QPainterPath_arcTo(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; startAngle: qreal; arcLength: qreal); cdecl; external Qt4PasLib name 'QPainterPath_arcTo2';
procedure QPainterPath_cubicTo(handle: QPainterPathH; ctrlPt1: PQtPointF; ctrlPt2: PQtPointF; endPt: PQtPointF); cdecl; external Qt4PasLib name 'QPainterPath_cubicTo';
procedure QPainterPath_cubicTo(handle: QPainterPathH; ctrlPt1x: qreal; ctrlPt1y: qreal; ctrlPt2x: qreal; ctrlPt2y: qreal; endPtx: qreal; endPty: qreal); cdecl; external Qt4PasLib name 'QPainterPath_cubicTo2';
procedure QPainterPath_quadTo(handle: QPainterPathH; ctrlPt: PQtPointF; endPt: PQtPointF); cdecl; external Qt4PasLib name 'QPainterPath_quadTo';
procedure QPainterPath_quadTo(handle: QPainterPathH; ctrlPtx: qreal; ctrlPty: qreal; endPtx: qreal; endPty: qreal); cdecl; external Qt4PasLib name 'QPainterPath_quadTo2';
procedure QPainterPath_currentPosition(handle: QPainterPathH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QPainterPath_currentPosition';
procedure QPainterPath_addRect(handle: QPainterPathH; rect: QRectFH); cdecl; external Qt4PasLib name 'QPainterPath_addRect';
procedure QPainterPath_addRect(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal); cdecl; external Qt4PasLib name 'QPainterPath_addRect2';
procedure QPainterPath_addEllipse(handle: QPainterPathH; rect: QRectFH); cdecl; external Qt4PasLib name 'QPainterPath_addEllipse';
procedure QPainterPath_addEllipse(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal); cdecl; external Qt4PasLib name 'QPainterPath_addEllipse2';
procedure QPainterPath_addEllipse(handle: QPainterPathH; center: PQtPointF; rx: qreal; ry: qreal); cdecl; external Qt4PasLib name 'QPainterPath_addEllipse3';
procedure QPainterPath_addPolygon(handle: QPainterPathH; polygon: QPolygonFH); cdecl; external Qt4PasLib name 'QPainterPath_addPolygon';
procedure QPainterPath_addText(handle: QPainterPathH; point: PQtPointF; f: QFontH; text: PWideString); cdecl; external Qt4PasLib name 'QPainterPath_addText';
procedure QPainterPath_addText(handle: QPainterPathH; x: qreal; y: qreal; f: QFontH; text: PWideString); cdecl; external Qt4PasLib name 'QPainterPath_addText2';
procedure QPainterPath_addPath(handle: QPainterPathH; path: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_addPath';
procedure QPainterPath_addRegion(handle: QPainterPathH; region: QRegionH); cdecl; external Qt4PasLib name 'QPainterPath_addRegion';
procedure QPainterPath_addRoundedRect(handle: QPainterPathH; rect: QRectFH; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt4PasLib name 'QPainterPath_addRoundedRect';
procedure QPainterPath_addRoundedRect(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt4PasLib name 'QPainterPath_addRoundedRect2';
procedure QPainterPath_addRoundRect(handle: QPainterPathH; rect: QRectFH; xRnd: Integer; yRnd: Integer); cdecl; external Qt4PasLib name 'QPainterPath_addRoundRect';
procedure QPainterPath_addRoundRect(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; xRnd: Integer; yRnd: Integer); cdecl; external Qt4PasLib name 'QPainterPath_addRoundRect2';
procedure QPainterPath_addRoundRect(handle: QPainterPathH; rect: QRectFH; roundness: Integer); cdecl; external Qt4PasLib name 'QPainterPath_addRoundRect3';
procedure QPainterPath_addRoundRect(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; roundness: Integer); cdecl; external Qt4PasLib name 'QPainterPath_addRoundRect4';
procedure QPainterPath_connectPath(handle: QPainterPathH; path: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_connectPath';
function QPainterPath_contains(handle: QPainterPathH; pt: PQtPointF): Boolean; cdecl; external Qt4PasLib name 'QPainterPath_contains';
function QPainterPath_contains(handle: QPainterPathH; rect: QRectFH): Boolean; cdecl; external Qt4PasLib name 'QPainterPath_contains2';
function QPainterPath_intersects(handle: QPainterPathH; rect: QRectFH): Boolean; cdecl; external Qt4PasLib name 'QPainterPath_intersects';
procedure QPainterPath_boundingRect(handle: QPainterPathH; retval: QRectFH); cdecl; external Qt4PasLib name 'QPainterPath_boundingRect';
procedure QPainterPath_controlPointRect(handle: QPainterPathH; retval: QRectFH); cdecl; external Qt4PasLib name 'QPainterPath_controlPointRect';
function QPainterPath_fillRule(handle: QPainterPathH): QtFillRule; cdecl; external Qt4PasLib name 'QPainterPath_fillRule';
procedure QPainterPath_setFillRule(handle: QPainterPathH; fillRule: QtFillRule); cdecl; external Qt4PasLib name 'QPainterPath_setFillRule';
function QPainterPath_isEmpty(handle: QPainterPathH): Boolean; cdecl; external Qt4PasLib name 'QPainterPath_isEmpty';
procedure QPainterPath_toReversed(handle: QPainterPathH; retval: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_toReversed';
procedure QPainterPath_toFillPolygon(handle: QPainterPathH; retval: QPolygonFH; matrix: QMatrixH = nil); cdecl; external Qt4PasLib name 'QPainterPath_toFillPolygon';
procedure QPainterPath_toFillPolygon(handle: QPainterPathH; retval: QPolygonFH; matrix: QTransformH); cdecl; external Qt4PasLib name 'QPainterPath_toFillPolygon2';
function QPainterPath_elementCount(handle: QPainterPathH): Integer; cdecl; external Qt4PasLib name 'QPainterPath_elementCount';
function QPainterPath_elementAt(handle: QPainterPathH; i: Integer): QPainterPathElementH; cdecl; external Qt4PasLib name 'QPainterPath_elementAt';
procedure QPainterPath_setElementPositionAt(handle: QPainterPathH; i: Integer; x: qreal; y: qreal); cdecl; external Qt4PasLib name 'QPainterPath_setElementPositionAt';
function QPainterPath_length(handle: QPainterPathH): qreal; cdecl; external Qt4PasLib name 'QPainterPath_length';
function QPainterPath_percentAtLength(handle: QPainterPathH; t: qreal): qreal; cdecl; external Qt4PasLib name 'QPainterPath_percentAtLength';
procedure QPainterPath_pointAtPercent(handle: QPainterPathH; retval: PQtPointF; t: qreal); cdecl; external Qt4PasLib name 'QPainterPath_pointAtPercent';
function QPainterPath_angleAtPercent(handle: QPainterPathH; t: qreal): qreal; cdecl; external Qt4PasLib name 'QPainterPath_angleAtPercent';
function QPainterPath_slopeAtPercent(handle: QPainterPathH; t: qreal): qreal; cdecl; external Qt4PasLib name 'QPainterPath_slopeAtPercent';
function QPainterPath_intersects(handle: QPainterPathH; p: QPainterPathH): Boolean; cdecl; external Qt4PasLib name 'QPainterPath_intersects2';
function QPainterPath_contains(handle: QPainterPathH; p: QPainterPathH): Boolean; cdecl; external Qt4PasLib name 'QPainterPath_contains3';
procedure QPainterPath_united(handle: QPainterPathH; retval: QPainterPathH; r: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_united';
procedure QPainterPath_intersected(handle: QPainterPathH; retval: QPainterPathH; r: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_intersected';
procedure QPainterPath_subtracted(handle: QPainterPathH; retval: QPainterPathH; r: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_subtracted';
procedure QPainterPath_subtractedInverted(handle: QPainterPathH; retval: QPainterPathH; r: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_subtractedInverted';
procedure QPainterPath_simplified(handle: QPainterPathH; retval: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPath_simplified';


function QPainterPathStroker_create(): QPainterPathStrokerH; cdecl; external Qt4PasLib name 'QPainterPathStroker_create';
procedure QPainterPathStroker_destroy(handle: QPainterPathStrokerH); cdecl; external Qt4PasLib name 'QPainterPathStroker_destroy'; 
procedure QPainterPathStroker_setWidth(handle: QPainterPathStrokerH; width: qreal); cdecl; external Qt4PasLib name 'QPainterPathStroker_setWidth';
function QPainterPathStroker_width(handle: QPainterPathStrokerH): qreal; cdecl; external Qt4PasLib name 'QPainterPathStroker_width';
procedure QPainterPathStroker_setCapStyle(handle: QPainterPathStrokerH; style: QtPenCapStyle); cdecl; external Qt4PasLib name 'QPainterPathStroker_setCapStyle';
function QPainterPathStroker_capStyle(handle: QPainterPathStrokerH): QtPenCapStyle; cdecl; external Qt4PasLib name 'QPainterPathStroker_capStyle';
procedure QPainterPathStroker_setJoinStyle(handle: QPainterPathStrokerH; style: QtPenJoinStyle); cdecl; external Qt4PasLib name 'QPainterPathStroker_setJoinStyle';
function QPainterPathStroker_joinStyle(handle: QPainterPathStrokerH): QtPenJoinStyle; cdecl; external Qt4PasLib name 'QPainterPathStroker_joinStyle';
procedure QPainterPathStroker_setMiterLimit(handle: QPainterPathStrokerH; length: qreal); cdecl; external Qt4PasLib name 'QPainterPathStroker_setMiterLimit';
function QPainterPathStroker_miterLimit(handle: QPainterPathStrokerH): qreal; cdecl; external Qt4PasLib name 'QPainterPathStroker_miterLimit';
procedure QPainterPathStroker_setCurveThreshold(handle: QPainterPathStrokerH; threshold: qreal); cdecl; external Qt4PasLib name 'QPainterPathStroker_setCurveThreshold';
function QPainterPathStroker_curveThreshold(handle: QPainterPathStrokerH): qreal; cdecl; external Qt4PasLib name 'QPainterPathStroker_curveThreshold';
procedure QPainterPathStroker_setDashPattern(handle: QPainterPathStrokerH; p1: QtPenStyle); cdecl; external Qt4PasLib name 'QPainterPathStroker_setDashPattern';
procedure QPainterPathStroker_setDashPattern(handle: QPainterPathStrokerH; dashPattern: PQRealArray); cdecl; external Qt4PasLib name 'QPainterPathStroker_setDashPattern2';
procedure QPainterPathStroker_dashPattern(handle: QPainterPathStrokerH; retval: PQRealArray); cdecl; external Qt4PasLib name 'QPainterPathStroker_dashPattern';
procedure QPainterPathStroker_setDashOffset(handle: QPainterPathStrokerH; offset: qreal); cdecl; external Qt4PasLib name 'QPainterPathStroker_setDashOffset';
function QPainterPathStroker_dashOffset(handle: QPainterPathStrokerH): qreal; cdecl; external Qt4PasLib name 'QPainterPathStroker_dashOffset';
procedure QPainterPathStroker_createStroke(handle: QPainterPathStrokerH; retval: QPainterPathH; path: QPainterPathH); cdecl; external Qt4PasLib name 'QPainterPathStroker_createStroke';


type
  QTransformTransformationType = (  //QTransform::TransformationType (2)
    QTransformTxNone = $00,
    QTransformTxTranslate = $01,
    QTransformTxScale = $02,
    QTransformTxRotate = $04,
    QTransformTxShear = $08,
    QTransformTxProject = $10 );

function QTransform_create(): QTransformH; cdecl; external Qt4PasLib name 'QTransform_create';
procedure QTransform_destroy(handle: QTransformH); cdecl; external Qt4PasLib name 'QTransform_destroy'; 
function QTransform_create(h11: qreal; h12: qreal; h13: qreal; h21: qreal; h22: qreal; h23: qreal; h31: qreal; h32: qreal; h33: qreal = 1.0): QTransformH; cdecl; external Qt4PasLib name 'QTransform_create2';
function QTransform_create(h11: qreal; h12: qreal; h21: qreal; h22: qreal; dx: qreal; dy: qreal): QTransformH; cdecl; external Qt4PasLib name 'QTransform_create3';
function QTransform_create(mtx: QMatrixH): QTransformH; cdecl; external Qt4PasLib name 'QTransform_create4';
function QTransform_isAffine(handle: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_isAffine';
function QTransform_isIdentity(handle: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_isIdentity';
function QTransform_isInvertible(handle: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_isInvertible';
function QTransform_isScaling(handle: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_isScaling';
function QTransform_isRotating(handle: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_isRotating';
function QTransform_isTranslating(handle: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_isTranslating';
function QTransform_type(handle: QTransformH): QTransformTransformationType; cdecl; external Qt4PasLib name 'QTransform_type';
function QTransform_determinant(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_determinant';
function QTransform_det(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_det';
function QTransform_m11(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m11';
function QTransform_m12(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m12';
function QTransform_m13(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m13';
function QTransform_m21(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m21';
function QTransform_m22(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m22';
function QTransform_m23(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m23';
function QTransform_m31(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m31';
function QTransform_m32(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m32';
function QTransform_m33(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_m33';
function QTransform_dx(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_dx';
function QTransform_dy(handle: QTransformH): qreal; cdecl; external Qt4PasLib name 'QTransform_dy';
procedure QTransform_setMatrix(handle: QTransformH; m11: qreal; m12: qreal; m13: qreal; m21: qreal; m22: qreal; m23: qreal; m31: qreal; m32: qreal; m33: qreal); cdecl; external Qt4PasLib name 'QTransform_setMatrix';
procedure QTransform_inverted(handle: QTransformH; retval: QTransformH; invertible: PBoolean = nil); cdecl; external Qt4PasLib name 'QTransform_inverted';
procedure QTransform_adjoint(handle: QTransformH; retval: QTransformH); cdecl; external Qt4PasLib name 'QTransform_adjoint';
procedure QTransform_transposed(handle: QTransformH; retval: QTransformH); cdecl; external Qt4PasLib name 'QTransform_transposed';
function QTransform_translate(handle: QTransformH; dx: qreal; dy: qreal): QTransformH; cdecl; external Qt4PasLib name 'QTransform_translate';
function QTransform_scale(handle: QTransformH; sx: qreal; sy: qreal): QTransformH; cdecl; external Qt4PasLib name 'QTransform_scale';
function QTransform_shear(handle: QTransformH; sh: qreal; sv: qreal): QTransformH; cdecl; external Qt4PasLib name 'QTransform_shear';
function QTransform_rotate(handle: QTransformH; a: qreal; axis: QtAxis = QtZAxis): QTransformH; cdecl; external Qt4PasLib name 'QTransform_rotate';
function QTransform_rotateRadians(handle: QTransformH; a: qreal; axis: QtAxis = QtZAxis): QTransformH; cdecl; external Qt4PasLib name 'QTransform_rotateRadians';
function QTransform_squareToQuad(square: QPolygonFH; result: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_squareToQuad';
function QTransform_quadToSquare(quad: QPolygonFH; result: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_quadToSquare';
function QTransform_quadToQuad(one: QPolygonFH; two: QPolygonFH; result: QTransformH): Boolean; cdecl; external Qt4PasLib name 'QTransform_quadToQuad';
procedure QTransform_reset(handle: QTransformH); cdecl; external Qt4PasLib name 'QTransform_reset';
procedure QTransform_map(handle: QTransformH; retval: PQtPoint; p: PQtPoint); cdecl; external Qt4PasLib name 'QTransform_map';
procedure QTransform_map(handle: QTransformH; retval: PQtPointF; p: PQtPointF); cdecl; external Qt4PasLib name 'QTransform_map2';
procedure QTransform_map(handle: QTransformH; retval: QLineH; l: QLineH); cdecl; external Qt4PasLib name 'QTransform_map3';
procedure QTransform_map(handle: QTransformH; retval: QLineFH; l: QLineFH); cdecl; external Qt4PasLib name 'QTransform_map4';
procedure QTransform_map(handle: QTransformH; retval: QPolygonFH; a: QPolygonFH); cdecl; external Qt4PasLib name 'QTransform_map5';
procedure QTransform_map(handle: QTransformH; retval: QPolygonH; a: QPolygonH); cdecl; external Qt4PasLib name 'QTransform_map6';
procedure QTransform_map(handle: QTransformH; retval: QRegionH; r: QRegionH); cdecl; external Qt4PasLib name 'QTransform_map7';
procedure QTransform_map(handle: QTransformH; retval: QPainterPathH; p: QPainterPathH); cdecl; external Qt4PasLib name 'QTransform_map8';
procedure QTransform_mapToPolygon(handle: QTransformH; retval: QPolygonH; r: PRect); cdecl; external Qt4PasLib name 'QTransform_mapToPolygon';
procedure QTransform_mapRect(handle: QTransformH; retval: PRect; p1: PRect); cdecl; external Qt4PasLib name 'QTransform_mapRect';
procedure QTransform_mapRect(handle: QTransformH; retval: QRectFH; p1: QRectFH); cdecl; external Qt4PasLib name 'QTransform_mapRect2';
procedure QTransform_map(handle: QTransformH; x: Integer; y: Integer; tx: PInteger; ty: PInteger); cdecl; external Qt4PasLib name 'QTransform_map9';
procedure QTransform_map(handle: QTransformH; x: qreal; y: qreal; tx: PQReal; ty: PQReal); cdecl; external Qt4PasLib name 'QTransform_map10';
function QTransform_toAffine(handle: QTransformH): QMatrixH; cdecl; external Qt4PasLib name 'QTransform_toAffine';
procedure QTransform_fromTranslate(retval: QTransformH; dx: qreal; dy: qreal); cdecl; external Qt4PasLib name 'QTransform_fromTranslate';
procedure QTransform_fromScale(retval: QTransformH; dx: qreal; dy: qreal); cdecl; external Qt4PasLib name 'QTransform_fromScale';

function QPrinterInfo_create(): QPrinterInfoH; cdecl; external Qt4PasLib name 'QPrinterInfo_create';
procedure QPrinterInfo_destroy(handle: QPrinterInfoH); cdecl; external Qt4PasLib name 'QPrinterInfo_destroy'; 
function QPrinterInfo_create(src: QPrinterInfoH): QPrinterInfoH; cdecl; external Qt4PasLib name 'QPrinterInfo_create2';
function QPrinterInfo_create(printer: QPrinterH): QPrinterInfoH; cdecl; external Qt4PasLib name 'QPrinterInfo_create3';
procedure QPrinterInfo_printerName(handle: QPrinterInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QPrinterInfo_printerName';
function QPrinterInfo_isNull(handle: QPrinterInfoH): Boolean; cdecl; external Qt4PasLib name 'QPrinterInfo_isNull';
function QPrinterInfo_isDefault(handle: QPrinterInfoH): Boolean; cdecl; external Qt4PasLib name 'QPrinterInfo_isDefault';
procedure QPrinterInfo_supportedPaperSizes(handle: QPrinterInfoH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QPrinterInfo_supportedPaperSizes';
procedure QPrinterInfo_availablePrinters(retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QPrinterInfo_availablePrinters';
procedure QPrinterInfo_defaultPrinter(retval: QPrinterInfoH); cdecl; external Qt4PasLib name 'QPrinterInfo_defaultPrinter';


type
  QFontStyle = ( // QFont::Style (1)
    QFontStyleNormal, QFontStyleItalic, QFontStyleOblique );

  QFontCapitalization = ( // QFont::Capitalization (1)
    QFontMixedCase, QFontAllUppercase, QFontAllLowercase, QFontSmallCaps, QFontCapitalize );

  QFontSpacingType = ( // QFont::SpacingType (1)
    QFontPercentageSpacing, QFontAbsoluteSpacing );

  QFontStyleStrategy = (  //QFont::StyleStrategy (2)
    QFontPreferDefault = $0001,
    QFontPreferBitmap = $0002,
    QFontPreferDevice = $0004,
    QFontPreferOutline = $0008,
    QFontForceOutline = $0010,
    QFontPreferMatch = $0020,
    QFontPreferQuality = $0040,
    QFontPreferAntialias = $0080,
    QFontNoAntialias = $0100,
    QFontOpenGLCompatible = $0200,
    QFontNoFontMerging = $8000 );

  QFontWeight = (  //QFont::Weight (2)
    QFontLight = 25,
    QFontNormal = 50,
    QFontDemiBold = 63,
    QFontBold = 75,
    QFontBlack = 87 );

  QFontStretch = (  //QFont::Stretch (2)
    QFontUltraCondensed = 50,
    QFontExtraCondensed = 62,
    QFontCondensed = 75,
    QFontSemiCondensed = 87,
    QFontUnstretched = 100,
    QFontSemiExpanded = 112,
    QFontExpanded = 125,
    QFontExtraExpanded = 150,
    QFontUltraExpanded = 200 );

  QFontResolveProperties = (  //QFont::ResolveProperties (2)
    QFontFamilyResolved = $0001,
    QFontSizeResolved = $0002,
    QFontStyleHintResolved = $0004,
    QFontStyleStrategyResolved = $0008,
    QFontWeightResolved = $0010,
    QFontStyleResolved = $0020,
    QFontUnderlineResolved = $0040,
    QFontOverlineResolved = $0080,
    QFontStrikeOutResolved = $0100,
    QFontFixedPitchResolved = $0200,
    QFontStretchResolved = $0400,
    QFontKerningResolved = $0800,
    QFontCapitalizationResolved = $1000,
    QFontLetterSpacingResolved = $2000,
    QFontWordSpacingResolved = $4000,
    QFontAllPropertiesResolved = $7fff );

type
  QFontStyleHint = cardinal; //  QFont::StyleHint (4)

const
    QFontHelvetica = 0 { $0 };
    QFontSansSerif = 0 { $0 };
    QFontTimes = 1 { $1 };
    QFontSerif = 1 { $1 };
    QFontCourier = 2 { $2 };
    QFontTypeWriter = 2 { $2 };
    QFontOldEnglish = 3 { $3 };
    QFontDecorative = 3 { $3 };
    QFontSystem = 4 { $4 };
    QFontAnyStyle = 5 { $5 };


function QFont_create(): QFontH; cdecl; external Qt4PasLib name 'QFont_create';
procedure QFont_destroy(handle: QFontH); cdecl; external Qt4PasLib name 'QFont_destroy'; 
function QFont_create(family: PWideString; pointSize: Integer = -1; weight: Integer = -1; italic: Boolean = False): QFontH; cdecl; external Qt4PasLib name 'QFont_create2';
function QFont_create(p1: QFontH; pd: QPaintDeviceH): QFontH; cdecl; external Qt4PasLib name 'QFont_create3';
function QFont_create(p1: QFontH): QFontH; cdecl; external Qt4PasLib name 'QFont_create4';
procedure QFont_family(handle: QFontH; retval: PWideString); cdecl; external Qt4PasLib name 'QFont_family';
procedure QFont_setFamily(handle: QFontH; p1: PWideString); cdecl; external Qt4PasLib name 'QFont_setFamily';
function QFont_pointSize(handle: QFontH): Integer; cdecl; external Qt4PasLib name 'QFont_pointSize';
procedure QFont_setPointSize(handle: QFontH; p1: Integer); cdecl; external Qt4PasLib name 'QFont_setPointSize';
function QFont_pointSizeF(handle: QFontH): qreal; cdecl; external Qt4PasLib name 'QFont_pointSizeF';
procedure QFont_setPointSizeF(handle: QFontH; p1: qreal); cdecl; external Qt4PasLib name 'QFont_setPointSizeF';
function QFont_pixelSize(handle: QFontH): Integer; cdecl; external Qt4PasLib name 'QFont_pixelSize';
procedure QFont_setPixelSize(handle: QFontH; p1: Integer); cdecl; external Qt4PasLib name 'QFont_setPixelSize';
function QFont_weight(handle: QFontH): Integer; cdecl; external Qt4PasLib name 'QFont_weight';
procedure QFont_setWeight(handle: QFontH; p1: Integer); cdecl; external Qt4PasLib name 'QFont_setWeight';
function QFont_bold(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_bold';
procedure QFont_setBold(handle: QFontH; p1: Boolean); cdecl; external Qt4PasLib name 'QFont_setBold';
procedure QFont_setStyle(handle: QFontH; style: QFontStyle); cdecl; external Qt4PasLib name 'QFont_setStyle';
function QFont_style(handle: QFontH): QFontStyle; cdecl; external Qt4PasLib name 'QFont_style';
function QFont_italic(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_italic';
procedure QFont_setItalic(handle: QFontH; b: Boolean); cdecl; external Qt4PasLib name 'QFont_setItalic';
function QFont_underline(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_underline';
procedure QFont_setUnderline(handle: QFontH; p1: Boolean); cdecl; external Qt4PasLib name 'QFont_setUnderline';
function QFont_overline(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_overline';
procedure QFont_setOverline(handle: QFontH; p1: Boolean); cdecl; external Qt4PasLib name 'QFont_setOverline';
function QFont_strikeOut(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_strikeOut';
procedure QFont_setStrikeOut(handle: QFontH; p1: Boolean); cdecl; external Qt4PasLib name 'QFont_setStrikeOut';
function QFont_fixedPitch(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_fixedPitch';
procedure QFont_setFixedPitch(handle: QFontH; p1: Boolean); cdecl; external Qt4PasLib name 'QFont_setFixedPitch';
function QFont_kerning(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_kerning';
procedure QFont_setKerning(handle: QFontH; p1: Boolean); cdecl; external Qt4PasLib name 'QFont_setKerning';
function QFont_styleHint(handle: QFontH): QFontStyleHint; cdecl; external Qt4PasLib name 'QFont_styleHint';
function QFont_styleStrategy(handle: QFontH): QFontStyleStrategy; cdecl; external Qt4PasLib name 'QFont_styleStrategy';
procedure QFont_setStyleHint(handle: QFontH; p1: QFontStyleHint; p2: QFontStyleStrategy = QFontPreferDefault); cdecl; external Qt4PasLib name 'QFont_setStyleHint';
procedure QFont_setStyleStrategy(handle: QFontH; s: QFontStyleStrategy); cdecl; external Qt4PasLib name 'QFont_setStyleStrategy';
function QFont_stretch(handle: QFontH): Integer; cdecl; external Qt4PasLib name 'QFont_stretch';
procedure QFont_setStretch(handle: QFontH; p1: Integer); cdecl; external Qt4PasLib name 'QFont_setStretch';
function QFont_letterSpacing(handle: QFontH): qreal; cdecl; external Qt4PasLib name 'QFont_letterSpacing';
function QFont_letterSpacingType(handle: QFontH): QFontSpacingType; cdecl; external Qt4PasLib name 'QFont_letterSpacingType';
procedure QFont_setLetterSpacing(handle: QFontH; _type: QFontSpacingType; spacing: qreal); cdecl; external Qt4PasLib name 'QFont_setLetterSpacing';
function QFont_wordSpacing(handle: QFontH): qreal; cdecl; external Qt4PasLib name 'QFont_wordSpacing';
procedure QFont_setWordSpacing(handle: QFontH; spacing: qreal); cdecl; external Qt4PasLib name 'QFont_setWordSpacing';
procedure QFont_setCapitalization(handle: QFontH; p1: QFontCapitalization); cdecl; external Qt4PasLib name 'QFont_setCapitalization';
function QFont_capitalization(handle: QFontH): QFontCapitalization; cdecl; external Qt4PasLib name 'QFont_capitalization';
function QFont_rawMode(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_rawMode';
procedure QFont_setRawMode(handle: QFontH; p1: Boolean); cdecl; external Qt4PasLib name 'QFont_setRawMode';
function QFont_exactMatch(handle: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_exactMatch';
function QFont_isCopyOf(handle: QFontH; p1: QFontH): Boolean; cdecl; external Qt4PasLib name 'QFont_isCopyOf';
{$ifdef BINUX or DARWIN or QTOPIA }
function QFont_handle(handle: QFontH): QtHANDLE; cdecl; external Qt4PasLib name 'QFont_handle';
{$endif}
procedure QFont_setRawName(handle: QFontH; p1: PWideString); cdecl; external Qt4PasLib name 'QFont_setRawName';
procedure QFont_rawName(handle: QFontH; retval: PWideString); cdecl; external Qt4PasLib name 'QFont_rawName';
procedure QFont_key(handle: QFontH; retval: PWideString); cdecl; external Qt4PasLib name 'QFont_key';
procedure QFont_toString(handle: QFontH; retval: PWideString); cdecl; external Qt4PasLib name 'QFont_toString';
function QFont_fromString(handle: QFontH; p1: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFont_fromString';
procedure QFont_substitute(retval: PWideString; p1: PWideString); cdecl; external Qt4PasLib name 'QFont_substitute';
procedure QFont_substitutes(retval: QStringListH; p1: PWideString); cdecl; external Qt4PasLib name 'QFont_substitutes';
procedure QFont_substitutions(retval: QStringListH); cdecl; external Qt4PasLib name 'QFont_substitutions';
procedure QFont_insertSubstitution(p1: PWideString; p2: PWideString); cdecl; external Qt4PasLib name 'QFont_insertSubstitution';
procedure QFont_insertSubstitutions(p1: PWideString; p2: QStringListH); cdecl; external Qt4PasLib name 'QFont_insertSubstitutions';
procedure QFont_removeSubstitution(p1: PWideString); cdecl; external Qt4PasLib name 'QFont_removeSubstitution';
procedure QFont_initialize(); cdecl; external Qt4PasLib name 'QFont_initialize';
procedure QFont_cleanup(); cdecl; external Qt4PasLib name 'QFont_cleanup';
{$ifdef BINUX or MSWINDOWS or DARWIN }
procedure QFont_cacheStatistics(); cdecl; external Qt4PasLib name 'QFont_cacheStatistics';
{$endif}
procedure QFont_defaultFamily(handle: QFontH; retval: PWideString); cdecl; external Qt4PasLib name 'QFont_defaultFamily';
procedure QFont_lastResortFamily(handle: QFontH; retval: PWideString); cdecl; external Qt4PasLib name 'QFont_lastResortFamily';
procedure QFont_lastResortFont(handle: QFontH; retval: PWideString); cdecl; external Qt4PasLib name 'QFont_lastResortFont';
procedure QFont_resolve(handle: QFontH; retval: QFontH; p1: QFontH); cdecl; external Qt4PasLib name 'QFont_resolve';
function QFont_resolve(handle: QFontH): LongWord; cdecl; external Qt4PasLib name 'QFont_resolve2';
procedure QFont_resolve(handle: QFontH; mask: LongWord); cdecl; external Qt4PasLib name 'QFont_resolve3';
{$ifdef MSWINDOWS }
function QFont_handle(handle: QFontH): QHFONT; cdecl; external Qt4PasLib name 'QFont_handle2';
{$endif}
{$ifdef DARWIN }
function QFont_macFontID(handle: QFontH): LongWord; cdecl; external Qt4PasLib name 'QFont_macFontID';
{$endif}

type
  QFontDatabaseWritingSystem = cardinal; //  QFontDatabase::WritingSystem (4)

const
    QFontDatabaseAny = 0 { $0 };
    QFontDatabaseLatin = 1 { $1 };
    QFontDatabaseGreek = 2 { $2 };
    QFontDatabaseCyrillic = 3 { $3 };
    QFontDatabaseArmenian = 4 { $4 };
    QFontDatabaseHebrew = 5 { $5 };
    QFontDatabaseArabic = 6 { $6 };
    QFontDatabaseSyriac = 7 { $7 };
    QFontDatabaseThaana = 8 { $8 };
    QFontDatabaseDevanagari = 9 { $9 };
    QFontDatabaseBengali = 10 { $a };
    QFontDatabaseGurmukhi = 11 { $b };
    QFontDatabaseGujarati = 12 { $c };
    QFontDatabaseOriya = 13 { $d };
    QFontDatabaseTamil = 14 { $e };
    QFontDatabaseTelugu = 15 { $f };
    QFontDatabaseKannada = 16 { $10 };
    QFontDatabaseMalayalam = 17 { $11 };
    QFontDatabaseSinhala = 18 { $12 };
    QFontDatabaseThai = 19 { $13 };
    QFontDatabaseLao = 20 { $14 };
    QFontDatabaseTibetan = 21 { $15 };
    QFontDatabaseMyanmar = 22 { $16 };
    QFontDatabaseGeorgian = 23 { $17 };
    QFontDatabaseKhmer = 24 { $18 };
    QFontDatabaseSimplifiedChinese = 25 { $19 };
    QFontDatabaseTraditionalChinese = 26 { $1a };
    QFontDatabaseJapanese = 27 { $1b };
    QFontDatabaseKorean = 28 { $1c };
    QFontDatabaseVietnamese = 29 { $1d };
    QFontDatabaseSymbol = 30 { $1e };
    QFontDatabaseOther = 30 { $1e };
    QFontDatabaseOgham = 31 { $1f };
    QFontDatabaseRunic = 32 { $20 };
    QFontDatabaseWritingSystemsCount = 33 { $21 };


procedure QFontDatabase_standardSizes(retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QFontDatabase_standardSizes';
function QFontDatabase_create(): QFontDatabaseH; cdecl; external Qt4PasLib name 'QFontDatabase_create';
procedure QFontDatabase_destroy(handle: QFontDatabaseH); cdecl; external Qt4PasLib name 'QFontDatabase_destroy'; 
procedure QFontDatabase_writingSystems(handle: QFontDatabaseH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QFontDatabase_writingSystems';
procedure QFontDatabase_writingSystems(handle: QFontDatabaseH; retval: PPtrIntArray; family: PWideString); cdecl; external Qt4PasLib name 'QFontDatabase_writingSystems2';
procedure QFontDatabase_families(handle: QFontDatabaseH; retval: QStringListH; writingSystem: QFontDatabaseWritingSystem = QFontDatabaseAny); cdecl; external Qt4PasLib name 'QFontDatabase_families';
procedure QFontDatabase_styles(handle: QFontDatabaseH; retval: QStringListH; family: PWideString); cdecl; external Qt4PasLib name 'QFontDatabase_styles';
procedure QFontDatabase_pointSizes(handle: QFontDatabaseH; retval: PPtrIntArray; family: PWideString; style: PWideString = nil); cdecl; external Qt4PasLib name 'QFontDatabase_pointSizes';
procedure QFontDatabase_smoothSizes(handle: QFontDatabaseH; retval: PPtrIntArray; family: PWideString; style: PWideString); cdecl; external Qt4PasLib name 'QFontDatabase_smoothSizes';
procedure QFontDatabase_styleString(handle: QFontDatabaseH; retval: PWideString; font: QFontH); cdecl; external Qt4PasLib name 'QFontDatabase_styleString';
procedure QFontDatabase_styleString(handle: QFontDatabaseH; retval: PWideString; fontInfo: QFontInfoH); cdecl; external Qt4PasLib name 'QFontDatabase_styleString2';
procedure QFontDatabase_font(handle: QFontDatabaseH; retval: QFontH; family: PWideString; style: PWideString; pointSize: Integer); cdecl; external Qt4PasLib name 'QFontDatabase_font';
function QFontDatabase_isBitmapScalable(handle: QFontDatabaseH; family: PWideString; style: PWideString = nil): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_isBitmapScalable';
function QFontDatabase_isSmoothlyScalable(handle: QFontDatabaseH; family: PWideString; style: PWideString = nil): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_isSmoothlyScalable';
function QFontDatabase_isScalable(handle: QFontDatabaseH; family: PWideString; style: PWideString = nil): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_isScalable';
function QFontDatabase_isFixedPitch(handle: QFontDatabaseH; family: PWideString; style: PWideString = nil): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_isFixedPitch';
function QFontDatabase_italic(handle: QFontDatabaseH; family: PWideString; style: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_italic';
function QFontDatabase_bold(handle: QFontDatabaseH; family: PWideString; style: PWideString): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_bold';
function QFontDatabase_weight(handle: QFontDatabaseH; family: PWideString; style: PWideString): Integer; cdecl; external Qt4PasLib name 'QFontDatabase_weight';
procedure QFontDatabase_writingSystemName(retval: PWideString; writingSystem: QFontDatabaseWritingSystem); cdecl; external Qt4PasLib name 'QFontDatabase_writingSystemName';
procedure QFontDatabase_writingSystemSample(retval: PWideString; writingSystem: QFontDatabaseWritingSystem); cdecl; external Qt4PasLib name 'QFontDatabase_writingSystemSample';
function QFontDatabase_addApplicationFont(fileName: PWideString): Integer; cdecl; external Qt4PasLib name 'QFontDatabase_addApplicationFont';
function QFontDatabase_addApplicationFontFromData(fontData: QByteArrayH): Integer; cdecl; external Qt4PasLib name 'QFontDatabase_addApplicationFontFromData';
procedure QFontDatabase_applicationFontFamilies(retval: QStringListH; id: Integer); cdecl; external Qt4PasLib name 'QFontDatabase_applicationFontFamilies';
function QFontDatabase_removeApplicationFont(id: Integer): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_removeApplicationFont';
function QFontDatabase_removeAllApplicationFonts(): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_removeAllApplicationFonts';
function QFontDatabase_supportsThreadedFontRendering(): Boolean; cdecl; external Qt4PasLib name 'QFontDatabase_supportsThreadedFontRendering';


type
  QTextCursorMoveMode = ( // QTextCursor::MoveMode (1)
    QTextCursorMoveAnchor, QTextCursorKeepAnchor );

  QTextCursorMoveOperation = ( // QTextCursor::MoveOperation (1)
    QTextCursorNoMove, QTextCursorStart, QTextCursorUp, QTextCursorStartOfLine, QTextCursorStartOfBlock, QTextCursorStartOfWord, QTextCursorPreviousBlock, QTextCursorPreviousCharacter, 
    QTextCursorPreviousWord, QTextCursorLeft, QTextCursorWordLeft, QTextCursorEnd, QTextCursorDown, QTextCursorEndOfLine, QTextCursorEndOfWord, QTextCursorEndOfBlock, QTextCursorNextBlock, 
    QTextCursorNextCharacter, QTextCursorNextWord, QTextCursorRight, QTextCursorWordRight, QTextCursorNextCell, QTextCursorPreviousCell, QTextCursorNextRow, QTextCursorPreviousRow );

  QTextCursorSelectionType = ( // QTextCursor::SelectionType (1)
    QTextCursorWordUnderCursor, QTextCursorLineUnderCursor, QTextCursorBlockUnderCursor, QTextCursorDocument );

function QTextCursor_create(): QTextCursorH; cdecl; external Qt4PasLib name 'QTextCursor_create';
procedure QTextCursor_destroy(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_destroy'; 
function QTextCursor_create(document: QTextDocumentH): QTextCursorH; cdecl; external Qt4PasLib name 'QTextCursor_create2';
function QTextCursor_create(frame: QTextFrameH): QTextCursorH; cdecl; external Qt4PasLib name 'QTextCursor_create3';
function QTextCursor_create(block: QTextBlockH): QTextCursorH; cdecl; external Qt4PasLib name 'QTextCursor_create4';
function QTextCursor_create(cursor: QTextCursorH): QTextCursorH; cdecl; external Qt4PasLib name 'QTextCursor_create6';
function QTextCursor_isNull(handle: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_isNull';
procedure QTextCursor_setPosition(handle: QTextCursorH; pos: Integer; mode: QTextCursorMoveMode = QTextCursorMoveAnchor); cdecl; external Qt4PasLib name 'QTextCursor_setPosition';
function QTextCursor_position(handle: QTextCursorH): Integer; cdecl; external Qt4PasLib name 'QTextCursor_position';
function QTextCursor_anchor(handle: QTextCursorH): Integer; cdecl; external Qt4PasLib name 'QTextCursor_anchor';
procedure QTextCursor_insertText(handle: QTextCursorH; text: PWideString); cdecl; external Qt4PasLib name 'QTextCursor_insertText';
procedure QTextCursor_insertText(handle: QTextCursorH; text: PWideString; format: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextCursor_insertText2';
function QTextCursor_movePosition(handle: QTextCursorH; op: QTextCursorMoveOperation; p2: QTextCursorMoveMode = QTextCursorMoveAnchor; n: Integer = 1): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_movePosition';
function QTextCursor_visualNavigation(handle: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_visualNavigation';
procedure QTextCursor_setVisualNavigation(handle: QTextCursorH; b: Boolean); cdecl; external Qt4PasLib name 'QTextCursor_setVisualNavigation';
procedure QTextCursor_deleteChar(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_deleteChar';
procedure QTextCursor_deletePreviousChar(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_deletePreviousChar';
procedure QTextCursor_select(handle: QTextCursorH; selection: QTextCursorSelectionType); cdecl; external Qt4PasLib name 'QTextCursor_select';
function QTextCursor_hasSelection(handle: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_hasSelection';
function QTextCursor_hasComplexSelection(handle: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_hasComplexSelection';
procedure QTextCursor_removeSelectedText(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_removeSelectedText';
procedure QTextCursor_clearSelection(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_clearSelection';
function QTextCursor_selectionStart(handle: QTextCursorH): Integer; cdecl; external Qt4PasLib name 'QTextCursor_selectionStart';
function QTextCursor_selectionEnd(handle: QTextCursorH): Integer; cdecl; external Qt4PasLib name 'QTextCursor_selectionEnd';
procedure QTextCursor_selectedText(handle: QTextCursorH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextCursor_selectedText';
procedure QTextCursor_selection(handle: QTextCursorH; retval: QTextDocumentFragmentH); cdecl; external Qt4PasLib name 'QTextCursor_selection';
procedure QTextCursor_selectedTableCells(handle: QTextCursorH; firstRow: PInteger; numRows: PInteger; firstColumn: PInteger; numColumns: PInteger); cdecl; external Qt4PasLib name 'QTextCursor_selectedTableCells';
procedure QTextCursor_block(handle: QTextCursorH; retval: QTextBlockH); cdecl; external Qt4PasLib name 'QTextCursor_block';
procedure QTextCursor_charFormat(handle: QTextCursorH; retval: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextCursor_charFormat';
procedure QTextCursor_setCharFormat(handle: QTextCursorH; format: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextCursor_setCharFormat';
procedure QTextCursor_mergeCharFormat(handle: QTextCursorH; modifier: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextCursor_mergeCharFormat';
procedure QTextCursor_blockFormat(handle: QTextCursorH; retval: QTextBlockFormatH); cdecl; external Qt4PasLib name 'QTextCursor_blockFormat';
procedure QTextCursor_setBlockFormat(handle: QTextCursorH; format: QTextBlockFormatH); cdecl; external Qt4PasLib name 'QTextCursor_setBlockFormat';
procedure QTextCursor_mergeBlockFormat(handle: QTextCursorH; modifier: QTextBlockFormatH); cdecl; external Qt4PasLib name 'QTextCursor_mergeBlockFormat';
procedure QTextCursor_blockCharFormat(handle: QTextCursorH; retval: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextCursor_blockCharFormat';
procedure QTextCursor_setBlockCharFormat(handle: QTextCursorH; format: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextCursor_setBlockCharFormat';
procedure QTextCursor_mergeBlockCharFormat(handle: QTextCursorH; modifier: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextCursor_mergeBlockCharFormat';
function QTextCursor_atBlockStart(handle: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_atBlockStart';
function QTextCursor_atBlockEnd(handle: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_atBlockEnd';
function QTextCursor_atStart(handle: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_atStart';
function QTextCursor_atEnd(handle: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_atEnd';
procedure QTextCursor_insertBlock(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_insertBlock';
procedure QTextCursor_insertBlock(handle: QTextCursorH; format: QTextBlockFormatH); cdecl; external Qt4PasLib name 'QTextCursor_insertBlock2';
procedure QTextCursor_insertBlock(handle: QTextCursorH; format: QTextBlockFormatH; charFormat: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextCursor_insertBlock3';
function QTextCursor_currentList(handle: QTextCursorH): QTextListH; cdecl; external Qt4PasLib name 'QTextCursor_currentList';
function QTextCursor_insertTable(handle: QTextCursorH; rows: Integer; cols: Integer; format: QTextTableFormatH): QTextTableH; cdecl; external Qt4PasLib name 'QTextCursor_insertTable';
function QTextCursor_insertTable(handle: QTextCursorH; rows: Integer; cols: Integer): QTextTableH; cdecl; external Qt4PasLib name 'QTextCursor_insertTable2';
function QTextCursor_currentTable(handle: QTextCursorH): QTextTableH; cdecl; external Qt4PasLib name 'QTextCursor_currentTable';
function QTextCursor_insertFrame(handle: QTextCursorH; format: QTextFrameFormatH): QTextFrameH; cdecl; external Qt4PasLib name 'QTextCursor_insertFrame';
function QTextCursor_currentFrame(handle: QTextCursorH): QTextFrameH; cdecl; external Qt4PasLib name 'QTextCursor_currentFrame';
procedure QTextCursor_insertFragment(handle: QTextCursorH; fragment: QTextDocumentFragmentH); cdecl; external Qt4PasLib name 'QTextCursor_insertFragment';
procedure QTextCursor_insertHtml(handle: QTextCursorH; html: PWideString); cdecl; external Qt4PasLib name 'QTextCursor_insertHtml';
procedure QTextCursor_insertImage(handle: QTextCursorH; format: QTextImageFormatH); cdecl; external Qt4PasLib name 'QTextCursor_insertImage2';
procedure QTextCursor_insertImage(handle: QTextCursorH; name: PWideString); cdecl; external Qt4PasLib name 'QTextCursor_insertImage3';
procedure QTextCursor_insertImage(handle: QTextCursorH; image: QImageH; name: PWideString = nil); cdecl; external Qt4PasLib name 'QTextCursor_insertImage4';
procedure QTextCursor_beginEditBlock(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_beginEditBlock';
procedure QTextCursor_joinPreviousEditBlock(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_joinPreviousEditBlock';
procedure QTextCursor_endEditBlock(handle: QTextCursorH); cdecl; external Qt4PasLib name 'QTextCursor_endEditBlock';
function QTextCursor_isCopyOf(handle: QTextCursorH; other: QTextCursorH): Boolean; cdecl; external Qt4PasLib name 'QTextCursor_isCopyOf';
function QTextCursor_blockNumber(handle: QTextCursorH): Integer; cdecl; external Qt4PasLib name 'QTextCursor_blockNumber';
function QTextCursor_columnNumber(handle: QTextCursorH): Integer; cdecl; external Qt4PasLib name 'QTextCursor_columnNumber';
function QTextCursor_document(handle: QTextCursorH): QTextDocumentH; cdecl; external Qt4PasLib name 'QTextCursor_document';


type
  QTextOptionTabType = ( // QTextOption::TabType (1)
    QTextOptionLeftTab, QTextOptionRightTab, QTextOptionCenterTab, QTextOptionDelimiterTab );

  QTextOptionWrapMode = ( // QTextOption::WrapMode (1)
    QTextOptionNoWrap, QTextOptionWordWrap, QTextOptionManualWrap, QTextOptionWrapAnywhere, QTextOptionWrapAtWordBoundaryOrAnywhere );

type
  QTextOptionFlag = cardinal; // QTextOption::Flag
  QTextOptionFlags = QTextOptionFlag; //QFlags<> (3)
const
  QTextOptionShowTabsAndSpaces =   $1;
  QTextOptionShowLineAndParagraphSeparators =   $2;
  QTextOptionAddSpaceForLineAndParagraphSeparators =   $4;
  QTextOptionSuppressColors =   $8;
  QTextOptionIncludeTrailingSpaces =   $80000000;

function QTextOption_create(): QTextOptionH; cdecl; external Qt4PasLib name 'QTextOption_create';
procedure QTextOption_destroy(handle: QTextOptionH); cdecl; external Qt4PasLib name 'QTextOption_destroy'; 
function QTextOption_create(alignment: QtAlignment): QTextOptionH; cdecl; external Qt4PasLib name 'QTextOption_create2';
function QTextOption_create(o: QTextOptionH): QTextOptionH; cdecl; external Qt4PasLib name 'QTextOption_create3';
procedure QTextOption_setAlignment(handle: QTextOptionH; alignment: QtAlignment); cdecl; external Qt4PasLib name 'QTextOption_setAlignment';
function QTextOption_alignment(handle: QTextOptionH): QtAlignment; cdecl; external Qt4PasLib name 'QTextOption_alignment';
procedure QTextOption_setTextDirection(handle: QTextOptionH; aDirection: QtLayoutDirection); cdecl; external Qt4PasLib name 'QTextOption_setTextDirection';
function QTextOption_textDirection(handle: QTextOptionH): QtLayoutDirection; cdecl; external Qt4PasLib name 'QTextOption_textDirection';
procedure QTextOption_setWrapMode(handle: QTextOptionH; wrap: QTextOptionWrapMode); cdecl; external Qt4PasLib name 'QTextOption_setWrapMode';
function QTextOption_wrapMode(handle: QTextOptionH): QTextOptionWrapMode; cdecl; external Qt4PasLib name 'QTextOption_wrapMode';
procedure QTextOption_setFlags(handle: QTextOptionH; flags: QTextOptionFlags); cdecl; external Qt4PasLib name 'QTextOption_setFlags';
function QTextOption_flags(handle: QTextOptionH): QTextOptionFlags; cdecl; external Qt4PasLib name 'QTextOption_flags';
procedure QTextOption_setTabStop(handle: QTextOptionH; tabStop: qreal); cdecl; external Qt4PasLib name 'QTextOption_setTabStop';
function QTextOption_tabStop(handle: QTextOptionH): qreal; cdecl; external Qt4PasLib name 'QTextOption_tabStop';
procedure QTextOption_setTabArray(handle: QTextOptionH; tabStops: PPtrIntArray); cdecl; external Qt4PasLib name 'QTextOption_setTabArray';
procedure QTextOption_tabArray(handle: QTextOptionH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QTextOption_tabArray';
procedure QTextOption_setUseDesignMetrics(handle: QTextOptionH; b: Boolean); cdecl; external Qt4PasLib name 'QTextOption_setUseDesignMetrics';
function QTextOption_useDesignMetrics(handle: QTextOptionH): Boolean; cdecl; external Qt4PasLib name 'QTextOption_useDesignMetrics';

function QFontMetrics_create(p1: QFontH): QFontMetricsH; cdecl; external Qt4PasLib name 'QFontMetrics_create';
procedure QFontMetrics_destroy(handle: QFontMetricsH); cdecl; external Qt4PasLib name 'QFontMetrics_destroy'; 
function QFontMetrics_create(p1: QFontH; pd: QPaintDeviceH): QFontMetricsH; cdecl; external Qt4PasLib name 'QFontMetrics_create2';
function QFontMetrics_create(p1: QFontMetricsH): QFontMetricsH; cdecl; external Qt4PasLib name 'QFontMetrics_create3';
function QFontMetrics_ascent(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_ascent';
function QFontMetrics_descent(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_descent';
function QFontMetrics_height(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_height';
function QFontMetrics_leading(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_leading';
function QFontMetrics_lineSpacing(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_lineSpacing';
function QFontMetrics_minLeftBearing(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_minLeftBearing';
function QFontMetrics_minRightBearing(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_minRightBearing';
function QFontMetrics_maxWidth(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_maxWidth';
function QFontMetrics_xHeight(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_xHeight';
function QFontMetrics_averageCharWidth(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_averageCharWidth';
function QFontMetrics_inFont(handle: QFontMetricsH; p1: PWideChar): Boolean; cdecl; external Qt4PasLib name 'QFontMetrics_inFont';
function QFontMetrics_leftBearing(handle: QFontMetricsH; p1: PWideChar): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_leftBearing';
function QFontMetrics_rightBearing(handle: QFontMetricsH; p1: PWideChar): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_rightBearing';
function QFontMetrics_width(handle: QFontMetricsH; p1: PWideString; len: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_width';
function QFontMetrics_width(handle: QFontMetricsH; p1: PWideChar): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_width2';
function QFontMetrics_charWidth(handle: QFontMetricsH; str: PWideString; pos: Integer): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_charWidth';
procedure QFontMetrics_boundingRect(handle: QFontMetricsH; retval: PRect; p1: PWideChar); cdecl; external Qt4PasLib name 'QFontMetrics_boundingRect';
procedure QFontMetrics_boundingRect(handle: QFontMetricsH; retval: PRect; text: PWideString); cdecl; external Qt4PasLib name 'QFontMetrics_boundingRect2';
procedure QFontMetrics_boundingRect(handle: QFontMetricsH; retval: PRect; r: PRect; flags: Integer; text: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt4PasLib name 'QFontMetrics_boundingRect3';
procedure QFontMetrics_boundingRect(handle: QFontMetricsH; retval: PRect; x: Integer; y: Integer; w: Integer; h: Integer; flags: Integer; text: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt4PasLib name 'QFontMetrics_boundingRect4';
procedure QFontMetrics_size(handle: QFontMetricsH; retval: PSize; flags: Integer; str: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt4PasLib name 'QFontMetrics_size';
procedure QFontMetrics_tightBoundingRect(handle: QFontMetricsH; retval: PRect; text: PWideString); cdecl; external Qt4PasLib name 'QFontMetrics_tightBoundingRect';
procedure QFontMetrics_elidedText(handle: QFontMetricsH; retval: PWideString; text: PWideString; mode: QtTextElideMode; width: Integer; flags: Integer = 0); cdecl; external Qt4PasLib name 'QFontMetrics_elidedText';
function QFontMetrics_underlinePos(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_underlinePos';
function QFontMetrics_overlinePos(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_overlinePos';
function QFontMetrics_strikeOutPos(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_strikeOutPos';
function QFontMetrics_lineWidth(handle: QFontMetricsH): Integer; cdecl; external Qt4PasLib name 'QFontMetrics_lineWidth';

function QFontMetricsF_create(p1: QFontH): QFontMetricsFH; cdecl; external Qt4PasLib name 'QFontMetricsF_create';
procedure QFontMetricsF_destroy(handle: QFontMetricsFH); cdecl; external Qt4PasLib name 'QFontMetricsF_destroy'; 
function QFontMetricsF_create(p1: QFontH; pd: QPaintDeviceH): QFontMetricsFH; cdecl; external Qt4PasLib name 'QFontMetricsF_create2';
function QFontMetricsF_create(p1: QFontMetricsFH): QFontMetricsFH; cdecl; external Qt4PasLib name 'QFontMetricsF_create4';
function QFontMetricsF_ascent(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_ascent';
function QFontMetricsF_descent(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_descent';
function QFontMetricsF_height(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_height';
function QFontMetricsF_leading(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_leading';
function QFontMetricsF_lineSpacing(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_lineSpacing';
function QFontMetricsF_minLeftBearing(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_minLeftBearing';
function QFontMetricsF_minRightBearing(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_minRightBearing';
function QFontMetricsF_maxWidth(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_maxWidth';
function QFontMetricsF_xHeight(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_xHeight';
function QFontMetricsF_averageCharWidth(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_averageCharWidth';
function QFontMetricsF_inFont(handle: QFontMetricsFH; p1: PWideChar): Boolean; cdecl; external Qt4PasLib name 'QFontMetricsF_inFont';
function QFontMetricsF_leftBearing(handle: QFontMetricsFH; p1: PWideChar): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_leftBearing';
function QFontMetricsF_rightBearing(handle: QFontMetricsFH; p1: PWideChar): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_rightBearing';
function QFontMetricsF_width(handle: QFontMetricsFH; _string: PWideString): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_width';
function QFontMetricsF_width(handle: QFontMetricsFH; p1: PWideChar): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_width2';
procedure QFontMetricsF_boundingRect(handle: QFontMetricsFH; retval: QRectFH; _string: PWideString); cdecl; external Qt4PasLib name 'QFontMetricsF_boundingRect';
procedure QFontMetricsF_boundingRect(handle: QFontMetricsFH; retval: QRectFH; p1: PWideChar); cdecl; external Qt4PasLib name 'QFontMetricsF_boundingRect2';
procedure QFontMetricsF_boundingRect(handle: QFontMetricsFH; retval: QRectFH; r: QRectFH; flags: Integer; _string: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt4PasLib name 'QFontMetricsF_boundingRect3';
procedure QFontMetricsF_size(handle: QFontMetricsFH; retval: QSizeFH; flags: Integer; str: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt4PasLib name 'QFontMetricsF_size';
procedure QFontMetricsF_tightBoundingRect(handle: QFontMetricsFH; retval: QRectFH; text: PWideString); cdecl; external Qt4PasLib name 'QFontMetricsF_tightBoundingRect';
procedure QFontMetricsF_elidedText(handle: QFontMetricsFH; retval: PWideString; text: PWideString; mode: QtTextElideMode; width: qreal; flags: Integer = 0); cdecl; external Qt4PasLib name 'QFontMetricsF_elidedText';
function QFontMetricsF_underlinePos(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_underlinePos';
function QFontMetricsF_overlinePos(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_overlinePos';
function QFontMetricsF_strikeOutPos(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_strikeOutPos';
function QFontMetricsF_lineWidth(handle: QFontMetricsFH): qreal; cdecl; external Qt4PasLib name 'QFontMetricsF_lineWidth';

function QFontInfo_create(p1: QFontH): QFontInfoH; cdecl; external Qt4PasLib name 'QFontInfo_create';
procedure QFontInfo_destroy(handle: QFontInfoH); cdecl; external Qt4PasLib name 'QFontInfo_destroy'; 
function QFontInfo_create(p1: QFontInfoH): QFontInfoH; cdecl; external Qt4PasLib name 'QFontInfo_create2';
procedure QFontInfo_family(handle: QFontInfoH; retval: PWideString); cdecl; external Qt4PasLib name 'QFontInfo_family';
function QFontInfo_pixelSize(handle: QFontInfoH): Integer; cdecl; external Qt4PasLib name 'QFontInfo_pixelSize';
function QFontInfo_pointSize(handle: QFontInfoH): Integer; cdecl; external Qt4PasLib name 'QFontInfo_pointSize';
function QFontInfo_pointSizeF(handle: QFontInfoH): qreal; cdecl; external Qt4PasLib name 'QFontInfo_pointSizeF';
function QFontInfo_italic(handle: QFontInfoH): Boolean; cdecl; external Qt4PasLib name 'QFontInfo_italic';
function QFontInfo_style(handle: QFontInfoH): QFontStyle; cdecl; external Qt4PasLib name 'QFontInfo_style';
function QFontInfo_weight(handle: QFontInfoH): Integer; cdecl; external Qt4PasLib name 'QFontInfo_weight';
function QFontInfo_bold(handle: QFontInfoH): Boolean; cdecl; external Qt4PasLib name 'QFontInfo_bold';
function QFontInfo_underline(handle: QFontInfoH): Boolean; cdecl; external Qt4PasLib name 'QFontInfo_underline';
function QFontInfo_overline(handle: QFontInfoH): Boolean; cdecl; external Qt4PasLib name 'QFontInfo_overline';
function QFontInfo_strikeOut(handle: QFontInfoH): Boolean; cdecl; external Qt4PasLib name 'QFontInfo_strikeOut';
function QFontInfo_fixedPitch(handle: QFontInfoH): Boolean; cdecl; external Qt4PasLib name 'QFontInfo_fixedPitch';
function QFontInfo_styleHint(handle: QFontInfoH): QFontStyleHint; cdecl; external Qt4PasLib name 'QFontInfo_styleHint';
function QFontInfo_rawMode(handle: QFontInfoH): Boolean; cdecl; external Qt4PasLib name 'QFontInfo_rawMode';
function QFontInfo_exactMatch(handle: QFontInfoH): Boolean; cdecl; external Qt4PasLib name 'QFontInfo_exactMatch';


type
  QTextDocumentMetaInformation = ( // QTextDocument::MetaInformation (1)
    QTextDocumentDocumentTitle, QTextDocumentDocumentUrl );

type
  QTextDocumentFindFlag = cardinal; // QTextDocument::FindFlag
  QTextDocumentFindFlags = QTextDocumentFindFlag; //QFlags<> (3)
const
  QTextDocumentFindBackward =   $00001;
  QTextDocumentFindCaseSensitively =   $00002;
  QTextDocumentFindWholeWords =   $00004;


type
  QTextDocumentResourceType = (  //QTextDocument::ResourceType (2)
    QTextDocumentHtmlResource = 1,
    QTextDocumentImageResource = 2,
    QTextDocumentStyleSheetResource = 3,
    QTextDocumentUserResource = 100 );

function QTextDocument_create(parent: QObjectH = nil): QTextDocumentH; cdecl; external Qt4PasLib name 'QTextDocument_create';
procedure QTextDocument_destroy(handle: QTextDocumentH); cdecl; external Qt4PasLib name 'QTextDocument_destroy'; 
function QTextDocument_create(text: PWideString; parent: QObjectH = nil): QTextDocumentH; cdecl; external Qt4PasLib name 'QTextDocument_create2';
function QTextDocument_clone(handle: QTextDocumentH; parent: QObjectH = nil): QTextDocumentH; cdecl; external Qt4PasLib name 'QTextDocument_clone';
function QTextDocument_isEmpty(handle: QTextDocumentH): Boolean; cdecl; external Qt4PasLib name 'QTextDocument_isEmpty';
procedure QTextDocument_clear(handle: QTextDocumentH); cdecl; external Qt4PasLib name 'QTextDocument_clear';
procedure QTextDocument_setUndoRedoEnabled(handle: QTextDocumentH; enable: Boolean); cdecl; external Qt4PasLib name 'QTextDocument_setUndoRedoEnabled';
function QTextDocument_isUndoRedoEnabled(handle: QTextDocumentH): Boolean; cdecl; external Qt4PasLib name 'QTextDocument_isUndoRedoEnabled';
function QTextDocument_isUndoAvailable(handle: QTextDocumentH): Boolean; cdecl; external Qt4PasLib name 'QTextDocument_isUndoAvailable';
function QTextDocument_isRedoAvailable(handle: QTextDocumentH): Boolean; cdecl; external Qt4PasLib name 'QTextDocument_isRedoAvailable';
function QTextDocument_revision(handle: QTextDocumentH): Integer; cdecl; external Qt4PasLib name 'QTextDocument_revision';
procedure QTextDocument_setDocumentLayout(handle: QTextDocumentH; layout: QAbstractTextDocumentLayoutH); cdecl; external Qt4PasLib name 'QTextDocument_setDocumentLayout';
function QTextDocument_documentLayout(handle: QTextDocumentH): QAbstractTextDocumentLayoutH; cdecl; external Qt4PasLib name 'QTextDocument_documentLayout';
procedure QTextDocument_setMetaInformation(handle: QTextDocumentH; info: QTextDocumentMetaInformation; p2: PWideString); cdecl; external Qt4PasLib name 'QTextDocument_setMetaInformation';
procedure QTextDocument_metaInformation(handle: QTextDocumentH; retval: PWideString; info: QTextDocumentMetaInformation); cdecl; external Qt4PasLib name 'QTextDocument_metaInformation';
procedure QTextDocument_toHtml(handle: QTextDocumentH; retval: PWideString; encoding: QByteArrayH = nil); cdecl; external Qt4PasLib name 'QTextDocument_toHtml';
procedure QTextDocument_setHtml(handle: QTextDocumentH; html: PWideString); cdecl; external Qt4PasLib name 'QTextDocument_setHtml';
procedure QTextDocument_toPlainText(handle: QTextDocumentH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextDocument_toPlainText';
procedure QTextDocument_setPlainText(handle: QTextDocumentH; text: PWideString); cdecl; external Qt4PasLib name 'QTextDocument_setPlainText';
procedure QTextDocument_characterAt(handle: QTextDocumentH; retval: PWideChar; pos: Integer); cdecl; external Qt4PasLib name 'QTextDocument_characterAt';
procedure QTextDocument_find(handle: QTextDocumentH; retval: QTextCursorH; subString: PWideString; from: Integer = 0; options: QTextDocumentFindFlags = 0); cdecl; external Qt4PasLib name 'QTextDocument_find';
procedure QTextDocument_find(handle: QTextDocumentH; retval: QTextCursorH; subString: PWideString; from: QTextCursorH; options: QTextDocumentFindFlags = 0); cdecl; external Qt4PasLib name 'QTextDocument_find2';
procedure QTextDocument_find(handle: QTextDocumentH; retval: QTextCursorH; expr: QRegExpH; from: Integer = 0; options: QTextDocumentFindFlags = 0); cdecl; external Qt4PasLib name 'QTextDocument_find3';
procedure QTextDocument_find(handle: QTextDocumentH; retval: QTextCursorH; expr: QRegExpH; from: QTextCursorH; options: QTextDocumentFindFlags = 0); cdecl; external Qt4PasLib name 'QTextDocument_find4';
function QTextDocument_frameAt(handle: QTextDocumentH; pos: Integer): QTextFrameH; cdecl; external Qt4PasLib name 'QTextDocument_frameAt';
function QTextDocument_rootFrame(handle: QTextDocumentH): QTextFrameH; cdecl; external Qt4PasLib name 'QTextDocument_rootFrame';
function QTextDocument_object(handle: QTextDocumentH; objectIndex: Integer): QTextObjectH; cdecl; external Qt4PasLib name 'QTextDocument_object';
function QTextDocument_objectForFormat(handle: QTextDocumentH; p1: QTextFormatH): QTextObjectH; cdecl; external Qt4PasLib name 'QTextDocument_objectForFormat';
procedure QTextDocument_findBlock(handle: QTextDocumentH; retval: QTextBlockH; pos: Integer); cdecl; external Qt4PasLib name 'QTextDocument_findBlock';
procedure QTextDocument_findBlockByNumber(handle: QTextDocumentH; retval: QTextBlockH; blockNumber: Integer); cdecl; external Qt4PasLib name 'QTextDocument_findBlockByNumber';
procedure QTextDocument_findBlockByLineNumber(handle: QTextDocumentH; retval: QTextBlockH; blockNumber: Integer); cdecl; external Qt4PasLib name 'QTextDocument_findBlockByLineNumber';
procedure QTextDocument_begin(handle: QTextDocumentH; retval: QTextBlockH); cdecl; external Qt4PasLib name 'QTextDocument_begin';
procedure QTextDocument_end(handle: QTextDocumentH; retval: QTextBlockH); cdecl; external Qt4PasLib name 'QTextDocument_end';
procedure QTextDocument_firstBlock(handle: QTextDocumentH; retval: QTextBlockH); cdecl; external Qt4PasLib name 'QTextDocument_firstBlock';
procedure QTextDocument_lastBlock(handle: QTextDocumentH; retval: QTextBlockH); cdecl; external Qt4PasLib name 'QTextDocument_lastBlock';
procedure QTextDocument_setPageSize(handle: QTextDocumentH; size: QSizeFH); cdecl; external Qt4PasLib name 'QTextDocument_setPageSize';
procedure QTextDocument_pageSize(handle: QTextDocumentH; retval: QSizeFH); cdecl; external Qt4PasLib name 'QTextDocument_pageSize';
procedure QTextDocument_setDefaultFont(handle: QTextDocumentH; font: QFontH); cdecl; external Qt4PasLib name 'QTextDocument_setDefaultFont';
procedure QTextDocument_defaultFont(handle: QTextDocumentH; retval: QFontH); cdecl; external Qt4PasLib name 'QTextDocument_defaultFont';
function QTextDocument_pageCount(handle: QTextDocumentH): Integer; cdecl; external Qt4PasLib name 'QTextDocument_pageCount';
function QTextDocument_isModified(handle: QTextDocumentH): Boolean; cdecl; external Qt4PasLib name 'QTextDocument_isModified';
procedure QTextDocument_print(handle: QTextDocumentH; printer: QPrinterH); cdecl; external Qt4PasLib name 'QTextDocument_print';
procedure QTextDocument_resource(handle: QTextDocumentH; retval: QVariantH; _type: Integer; name: QUrlH); cdecl; external Qt4PasLib name 'QTextDocument_resource';
procedure QTextDocument_addResource(handle: QTextDocumentH; _type: Integer; name: QUrlH; resource: QVariantH); cdecl; external Qt4PasLib name 'QTextDocument_addResource';
procedure QTextDocument_markContentsDirty(handle: QTextDocumentH; from: Integer; length: Integer); cdecl; external Qt4PasLib name 'QTextDocument_markContentsDirty';
procedure QTextDocument_setUseDesignMetrics(handle: QTextDocumentH; b: Boolean); cdecl; external Qt4PasLib name 'QTextDocument_setUseDesignMetrics';
function QTextDocument_useDesignMetrics(handle: QTextDocumentH): Boolean; cdecl; external Qt4PasLib name 'QTextDocument_useDesignMetrics';
procedure QTextDocument_drawContents(handle: QTextDocumentH; painter: QPainterH; rect: QRectFH = nil); cdecl; external Qt4PasLib name 'QTextDocument_drawContents';
procedure QTextDocument_setTextWidth(handle: QTextDocumentH; width: qreal); cdecl; external Qt4PasLib name 'QTextDocument_setTextWidth';
function QTextDocument_textWidth(handle: QTextDocumentH): qreal; cdecl; external Qt4PasLib name 'QTextDocument_textWidth';
function QTextDocument_idealWidth(handle: QTextDocumentH): qreal; cdecl; external Qt4PasLib name 'QTextDocument_idealWidth';
function QTextDocument_indentWidth(handle: QTextDocumentH): qreal; cdecl; external Qt4PasLib name 'QTextDocument_indentWidth';
procedure QTextDocument_setIndentWidth(handle: QTextDocumentH; width: qreal); cdecl; external Qt4PasLib name 'QTextDocument_setIndentWidth';
function QTextDocument_documentMargin(handle: QTextDocumentH): qreal; cdecl; external Qt4PasLib name 'QTextDocument_documentMargin';
procedure QTextDocument_setDocumentMargin(handle: QTextDocumentH; margin: qreal); cdecl; external Qt4PasLib name 'QTextDocument_setDocumentMargin';
procedure QTextDocument_adjustSize(handle: QTextDocumentH); cdecl; external Qt4PasLib name 'QTextDocument_adjustSize';
procedure QTextDocument_size(handle: QTextDocumentH; retval: QSizeFH); cdecl; external Qt4PasLib name 'QTextDocument_size';
function QTextDocument_blockCount(handle: QTextDocumentH): Integer; cdecl; external Qt4PasLib name 'QTextDocument_blockCount';
function QTextDocument_lineCount(handle: QTextDocumentH): Integer; cdecl; external Qt4PasLib name 'QTextDocument_lineCount';
function QTextDocument_characterCount(handle: QTextDocumentH): Integer; cdecl; external Qt4PasLib name 'QTextDocument_characterCount';
procedure QTextDocument_setDefaultStyleSheet(handle: QTextDocumentH; sheet: PWideString); cdecl; external Qt4PasLib name 'QTextDocument_setDefaultStyleSheet';
procedure QTextDocument_defaultStyleSheet(handle: QTextDocumentH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextDocument_defaultStyleSheet';
procedure QTextDocument_undo(handle: QTextDocumentH; cursor: QTextCursorH); cdecl; external Qt4PasLib name 'QTextDocument_undo';
procedure QTextDocument_redo(handle: QTextDocumentH; cursor: QTextCursorH); cdecl; external Qt4PasLib name 'QTextDocument_redo';
function QTextDocument_maximumBlockCount(handle: QTextDocumentH): Integer; cdecl; external Qt4PasLib name 'QTextDocument_maximumBlockCount';
procedure QTextDocument_setMaximumBlockCount(handle: QTextDocumentH; maximum: Integer); cdecl; external Qt4PasLib name 'QTextDocument_setMaximumBlockCount';
procedure QTextDocument_defaultTextOption(handle: QTextDocumentH; retval: QTextOptionH); cdecl; external Qt4PasLib name 'QTextDocument_defaultTextOption';
procedure QTextDocument_setDefaultTextOption(handle: QTextDocumentH; option: QTextOptionH); cdecl; external Qt4PasLib name 'QTextDocument_setDefaultTextOption';
procedure QTextDocument_undo(handle: QTextDocumentH); cdecl; external Qt4PasLib name 'QTextDocument_undo2';
procedure QTextDocument_redo(handle: QTextDocumentH); cdecl; external Qt4PasLib name 'QTextDocument_redo2';
procedure QTextDocument_setModified(handle: QTextDocumentH; m: Boolean = True); cdecl; external Qt4PasLib name 'QTextDocument_setModified';

function QAbstractTextDocumentLayout_hitTest(handle: QAbstractTextDocumentLayoutH; point: PQtPointF; accuracy: QtHitTestAccuracy): Integer; cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_hitTest';
procedure QAbstractTextDocumentLayout_anchorAt(handle: QAbstractTextDocumentLayoutH; retval: PWideString; pos: PQtPointF); cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_anchorAt';
function QAbstractTextDocumentLayout_pageCount(handle: QAbstractTextDocumentLayoutH): Integer; cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_pageCount';
procedure QAbstractTextDocumentLayout_documentSize(handle: QAbstractTextDocumentLayoutH; retval: QSizeFH); cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_documentSize';
procedure QAbstractTextDocumentLayout_frameBoundingRect(handle: QAbstractTextDocumentLayoutH; retval: QRectFH; frame: QTextFrameH); cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_frameBoundingRect';
procedure QAbstractTextDocumentLayout_blockBoundingRect(handle: QAbstractTextDocumentLayoutH; retval: QRectFH; block: QTextBlockH); cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_blockBoundingRect';
procedure QAbstractTextDocumentLayout_setPaintDevice(handle: QAbstractTextDocumentLayoutH; device: QPaintDeviceH); cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_setPaintDevice';
function QAbstractTextDocumentLayout_paintDevice(handle: QAbstractTextDocumentLayoutH): QPaintDeviceH; cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_paintDevice';
function QAbstractTextDocumentLayout_document(handle: QAbstractTextDocumentLayoutH): QTextDocumentH; cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_document';
procedure QAbstractTextDocumentLayout_registerHandler(handle: QAbstractTextDocumentLayoutH; objectType: Integer; component: QObjectH); cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_registerHandler';
function QAbstractTextDocumentLayout_handlerForObject(handle: QAbstractTextDocumentLayoutH; objectType: Integer): QTextObjectInterfaceH; cdecl; external Qt4PasLib name 'QAbstractTextDocumentLayout_handlerForObject';

procedure QTextObjectInterface_intrinsicSize(handle: QTextObjectInterfaceH; retval: QSizeFH; doc: QTextDocumentH; posInDocument: Integer; format: QTextFormatH); cdecl; external Qt4PasLib name 'QTextObjectInterface_intrinsicSize';
procedure QTextObjectInterface_drawObject(handle: QTextObjectInterfaceH; painter: QPainterH; rect: QRectFH; doc: QTextDocumentH; posInDocument: Integer; format: QTextFormatH); cdecl; external Qt4PasLib name 'QTextObjectInterface_drawObject';


type
  QAbstractTextDocumentLayout_update_Event = procedure (p1: QRectFH) of object cdecl;
  QAbstractTextDocumentLayout_update2_Event = procedure () of object cdecl;
  QAbstractTextDocumentLayout_updateBlock_Event = procedure (block: QTextBlockH) of object cdecl;
  QAbstractTextDocumentLayout_documentSizeChanged_Event = procedure (newSize: QSizeFH) of object cdecl;
  QAbstractTextDocumentLayout_pageCountChanged_Event = procedure (newPages: Integer) of object cdecl;



type
  QTextLayoutCursorMode = ( // QTextLayout::CursorMode (1)
    QTextLayoutSkipCharacters, QTextLayoutSkipWords );


type
  QTextLineEdge = ( // QTextLine::Edge (1)
    QTextLineLeading, QTextLineTrailing );

  QTextLineCursorPosition = ( // QTextLine::CursorPosition (1)
    QTextLineCursorBetweenCharacters, QTextLineCursorOnCharacter );

function QTextInlineObject_create(): QTextInlineObjectH; cdecl; external Qt4PasLib name 'QTextInlineObject_create';
procedure QTextInlineObject_destroy(handle: QTextInlineObjectH); cdecl; external Qt4PasLib name 'QTextInlineObject_destroy'; 
function QTextInlineObject_isValid(handle: QTextInlineObjectH): Boolean; cdecl; external Qt4PasLib name 'QTextInlineObject_isValid';
procedure QTextInlineObject_rect(handle: QTextInlineObjectH; retval: QRectFH); cdecl; external Qt4PasLib name 'QTextInlineObject_rect';
function QTextInlineObject_width(handle: QTextInlineObjectH): qreal; cdecl; external Qt4PasLib name 'QTextInlineObject_width';
function QTextInlineObject_ascent(handle: QTextInlineObjectH): qreal; cdecl; external Qt4PasLib name 'QTextInlineObject_ascent';
function QTextInlineObject_descent(handle: QTextInlineObjectH): qreal; cdecl; external Qt4PasLib name 'QTextInlineObject_descent';
function QTextInlineObject_height(handle: QTextInlineObjectH): qreal; cdecl; external Qt4PasLib name 'QTextInlineObject_height';
function QTextInlineObject_textDirection(handle: QTextInlineObjectH): QtLayoutDirection; cdecl; external Qt4PasLib name 'QTextInlineObject_textDirection';
procedure QTextInlineObject_setWidth(handle: QTextInlineObjectH; w: qreal); cdecl; external Qt4PasLib name 'QTextInlineObject_setWidth';
procedure QTextInlineObject_setAscent(handle: QTextInlineObjectH; a: qreal); cdecl; external Qt4PasLib name 'QTextInlineObject_setAscent';
procedure QTextInlineObject_setDescent(handle: QTextInlineObjectH; d: qreal); cdecl; external Qt4PasLib name 'QTextInlineObject_setDescent';
function QTextInlineObject_textPosition(handle: QTextInlineObjectH): Integer; cdecl; external Qt4PasLib name 'QTextInlineObject_textPosition';
function QTextInlineObject_formatIndex(handle: QTextInlineObjectH): Integer; cdecl; external Qt4PasLib name 'QTextInlineObject_formatIndex';
procedure QTextInlineObject_format(handle: QTextInlineObjectH; retval: QTextFormatH); cdecl; external Qt4PasLib name 'QTextInlineObject_format';

function QTextLayout_create(): QTextLayoutH; cdecl; external Qt4PasLib name 'QTextLayout_create';
procedure QTextLayout_destroy(handle: QTextLayoutH); cdecl; external Qt4PasLib name 'QTextLayout_destroy'; 
function QTextLayout_create(text: PWideString): QTextLayoutH; cdecl; external Qt4PasLib name 'QTextLayout_create2';
function QTextLayout_create(text: PWideString; font: QFontH; paintdevice: QPaintDeviceH = nil): QTextLayoutH; cdecl; external Qt4PasLib name 'QTextLayout_create3';
function QTextLayout_create(b: QTextBlockH): QTextLayoutH; cdecl; external Qt4PasLib name 'QTextLayout_create4';
procedure QTextLayout_setFont(handle: QTextLayoutH; f: QFontH); cdecl; external Qt4PasLib name 'QTextLayout_setFont';
procedure QTextLayout_font(handle: QTextLayoutH; retval: QFontH); cdecl; external Qt4PasLib name 'QTextLayout_font';
procedure QTextLayout_setText(handle: QTextLayoutH; _string: PWideString); cdecl; external Qt4PasLib name 'QTextLayout_setText';
procedure QTextLayout_text(handle: QTextLayoutH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextLayout_text';
procedure QTextLayout_setTextOption(handle: QTextLayoutH; option: QTextOptionH); cdecl; external Qt4PasLib name 'QTextLayout_setTextOption';
procedure QTextLayout_textOption(handle: QTextLayoutH; retval: QTextOptionH); cdecl; external Qt4PasLib name 'QTextLayout_textOption';
procedure QTextLayout_setPreeditArea(handle: QTextLayoutH; position: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QTextLayout_setPreeditArea';
function QTextLayout_preeditAreaPosition(handle: QTextLayoutH): Integer; cdecl; external Qt4PasLib name 'QTextLayout_preeditAreaPosition';
procedure QTextLayout_preeditAreaText(handle: QTextLayoutH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextLayout_preeditAreaText';
procedure QTextLayout_clearAdditionalFormats(handle: QTextLayoutH); cdecl; external Qt4PasLib name 'QTextLayout_clearAdditionalFormats';
procedure QTextLayout_setCacheEnabled(handle: QTextLayoutH; enable: Boolean); cdecl; external Qt4PasLib name 'QTextLayout_setCacheEnabled';
function QTextLayout_cacheEnabled(handle: QTextLayoutH): Boolean; cdecl; external Qt4PasLib name 'QTextLayout_cacheEnabled';
procedure QTextLayout_beginLayout(handle: QTextLayoutH); cdecl; external Qt4PasLib name 'QTextLayout_beginLayout';
procedure QTextLayout_endLayout(handle: QTextLayoutH); cdecl; external Qt4PasLib name 'QTextLayout_endLayout';
procedure QTextLayout_clearLayout(handle: QTextLayoutH); cdecl; external Qt4PasLib name 'QTextLayout_clearLayout';
procedure QTextLayout_createLine(handle: QTextLayoutH; retval: QTextLineH); cdecl; external Qt4PasLib name 'QTextLayout_createLine';
function QTextLayout_lineCount(handle: QTextLayoutH): Integer; cdecl; external Qt4PasLib name 'QTextLayout_lineCount';
procedure QTextLayout_lineAt(handle: QTextLayoutH; retval: QTextLineH; i: Integer); cdecl; external Qt4PasLib name 'QTextLayout_lineAt';
procedure QTextLayout_lineForTextPosition(handle: QTextLayoutH; retval: QTextLineH; pos: Integer); cdecl; external Qt4PasLib name 'QTextLayout_lineForTextPosition';
function QTextLayout_isValidCursorPosition(handle: QTextLayoutH; pos: Integer): Boolean; cdecl; external Qt4PasLib name 'QTextLayout_isValidCursorPosition';
function QTextLayout_nextCursorPosition(handle: QTextLayoutH; oldPos: Integer; mode: QTextLayoutCursorMode = QTextLayoutSkipCharacters): Integer; cdecl; external Qt4PasLib name 'QTextLayout_nextCursorPosition';
function QTextLayout_previousCursorPosition(handle: QTextLayoutH; oldPos: Integer; mode: QTextLayoutCursorMode = QTextLayoutSkipCharacters): Integer; cdecl; external Qt4PasLib name 'QTextLayout_previousCursorPosition';
procedure QTextLayout_drawCursor(handle: QTextLayoutH; p: QPainterH; pos: PQtPointF; cursorPosition: Integer); cdecl; external Qt4PasLib name 'QTextLayout_drawCursor';
procedure QTextLayout_drawCursor(handle: QTextLayoutH; p: QPainterH; pos: PQtPointF; cursorPosition: Integer; width: Integer); cdecl; external Qt4PasLib name 'QTextLayout_drawCursor2';
procedure QTextLayout_position(handle: QTextLayoutH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QTextLayout_position';
procedure QTextLayout_setPosition(handle: QTextLayoutH; p: PQtPointF); cdecl; external Qt4PasLib name 'QTextLayout_setPosition';
procedure QTextLayout_boundingRect(handle: QTextLayoutH; retval: QRectFH); cdecl; external Qt4PasLib name 'QTextLayout_boundingRect';
function QTextLayout_minimumWidth(handle: QTextLayoutH): qreal; cdecl; external Qt4PasLib name 'QTextLayout_minimumWidth';
function QTextLayout_maximumWidth(handle: QTextLayoutH): qreal; cdecl; external Qt4PasLib name 'QTextLayout_maximumWidth';
procedure QTextLayout_setFlags(handle: QTextLayoutH; flags: Integer); cdecl; external Qt4PasLib name 'QTextLayout_setFlags';

function QTextLine_create(): QTextLineH; cdecl; external Qt4PasLib name 'QTextLine_create';
procedure QTextLine_destroy(handle: QTextLineH); cdecl; external Qt4PasLib name 'QTextLine_destroy'; 
function QTextLine_isValid(handle: QTextLineH): Boolean; cdecl; external Qt4PasLib name 'QTextLine_isValid';
procedure QTextLine_rect(handle: QTextLineH; retval: QRectFH); cdecl; external Qt4PasLib name 'QTextLine_rect';
function QTextLine_x(handle: QTextLineH): qreal; cdecl; external Qt4PasLib name 'QTextLine_x';
function QTextLine_y(handle: QTextLineH): qreal; cdecl; external Qt4PasLib name 'QTextLine_y';
function QTextLine_width(handle: QTextLineH): qreal; cdecl; external Qt4PasLib name 'QTextLine_width';
function QTextLine_ascent(handle: QTextLineH): qreal; cdecl; external Qt4PasLib name 'QTextLine_ascent';
function QTextLine_descent(handle: QTextLineH): qreal; cdecl; external Qt4PasLib name 'QTextLine_descent';
function QTextLine_height(handle: QTextLineH): qreal; cdecl; external Qt4PasLib name 'QTextLine_height';
function QTextLine_naturalTextWidth(handle: QTextLineH): qreal; cdecl; external Qt4PasLib name 'QTextLine_naturalTextWidth';
procedure QTextLine_naturalTextRect(handle: QTextLineH; retval: QRectFH); cdecl; external Qt4PasLib name 'QTextLine_naturalTextRect';
function QTextLine_cursorToX(handle: QTextLineH; cursorPos: PInteger; edge: QTextLineEdge = QTextLineLeading): qreal; cdecl; external Qt4PasLib name 'QTextLine_cursorToX';
function QTextLine_cursorToX(handle: QTextLineH; cursorPos: Integer; edge: QTextLineEdge = QTextLineLeading): qreal; cdecl; external Qt4PasLib name 'QTextLine_cursorToX2';
function QTextLine_xToCursor(handle: QTextLineH; x: qreal; p2: QTextLineCursorPosition = QTextLineCursorBetweenCharacters): Integer; cdecl; external Qt4PasLib name 'QTextLine_xToCursor';
procedure QTextLine_setLineWidth(handle: QTextLineH; width: qreal); cdecl; external Qt4PasLib name 'QTextLine_setLineWidth';
procedure QTextLine_setNumColumns(handle: QTextLineH; columns: Integer); cdecl; external Qt4PasLib name 'QTextLine_setNumColumns';
procedure QTextLine_setNumColumns(handle: QTextLineH; columns: Integer; alignmentWidth: qreal); cdecl; external Qt4PasLib name 'QTextLine_setNumColumns2';
procedure QTextLine_setPosition(handle: QTextLineH; pos: PQtPointF); cdecl; external Qt4PasLib name 'QTextLine_setPosition';
procedure QTextLine_position(handle: QTextLineH; retval: PQtPointF); cdecl; external Qt4PasLib name 'QTextLine_position';
function QTextLine_textStart(handle: QTextLineH): Integer; cdecl; external Qt4PasLib name 'QTextLine_textStart';
function QTextLine_textLength(handle: QTextLineH): Integer; cdecl; external Qt4PasLib name 'QTextLine_textLength';
function QTextLine_lineNumber(handle: QTextLineH): Integer; cdecl; external Qt4PasLib name 'QTextLine_lineNumber';


type
  QIconMode = ( // QIcon::Mode (1)
    QIconNormal, QIconDisabled, QIconActive, QIconSelected );

  QIconState = ( // QIcon::State (1)
    QIconOn, QIconOff );

function QIcon_create(): QIconH; cdecl; external Qt4PasLib name 'QIcon_create';
procedure QIcon_destroy(handle: QIconH); cdecl; external Qt4PasLib name 'QIcon_destroy'; 
function QIcon_create(pixmap: QPixmapH): QIconH; cdecl; external Qt4PasLib name 'QIcon_create2';
function QIcon_create(other: QIconH): QIconH; cdecl; external Qt4PasLib name 'QIcon_create3';
function QIcon_create(fileName: PWideString): QIconH; cdecl; external Qt4PasLib name 'QIcon_create4';
function QIcon_create(engine: QIconEngineH): QIconH; cdecl; external Qt4PasLib name 'QIcon_create5';
function QIcon_create(engine: QIconEngineV2H): QIconH; cdecl; external Qt4PasLib name 'QIcon_create6';
procedure QIcon_pixmap(handle: QIconH; retval: QPixmapH; size: PSize; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt4PasLib name 'QIcon_pixmap';
procedure QIcon_pixmap(handle: QIconH; retval: QPixmapH; w: Integer; h: Integer; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt4PasLib name 'QIcon_pixmap2';
procedure QIcon_pixmap(handle: QIconH; retval: QPixmapH; extent: Integer; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt4PasLib name 'QIcon_pixmap3';
procedure QIcon_actualSize(handle: QIconH; retval: PSize; size: PSize; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt4PasLib name 'QIcon_actualSize';
procedure QIcon_paint(handle: QIconH; painter: QPainterH; rect: PRect; alignment: QtAlignment = QtAlignCenter; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt4PasLib name 'QIcon_paint';
procedure QIcon_paint(handle: QIconH; painter: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; alignment: QtAlignment = QtAlignCenter; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt4PasLib name 'QIcon_paint2';
function QIcon_isNull(handle: QIconH): Boolean; cdecl; external Qt4PasLib name 'QIcon_isNull';
function QIcon_isDetached(handle: QIconH): Boolean; cdecl; external Qt4PasLib name 'QIcon_isDetached';
procedure QIcon_detach(handle: QIconH); cdecl; external Qt4PasLib name 'QIcon_detach';
function QIcon_serialNumber(handle: QIconH): Integer; cdecl; external Qt4PasLib name 'QIcon_serialNumber';
function QIcon_cacheKey(handle: QIconH): int64; cdecl; external Qt4PasLib name 'QIcon_cacheKey';
procedure QIcon_addPixmap(handle: QIconH; pixmap: QPixmapH; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt4PasLib name 'QIcon_addPixmap';
procedure QIcon_addFile(handle: QIconH; fileName: PWideString; size: PSize = nil; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt4PasLib name 'QIcon_addFile';

{$ifdef BINUX }

type
  QPixmapShareMode = ( // QPixmap::ShareMode (1)
    QPixmapImplicitlyShared, QPixmapExplicitlyShared );

{$endif}
{$ifdef MSWINDOWS }

type
  QPixmapHBitmapFormat = ( // QPixmap::HBitmapFormat (1)
    QPixmapNoAlpha, QPixmapPremultipliedAlpha, QPixmapAlpha );

{$endif}
function QPixmap_create(): QPixmapH; cdecl; external Qt4PasLib name 'QPixmap_create';
procedure QPixmap_destroy(handle: QPixmapH); cdecl; external Qt4PasLib name 'QPixmap_destroy'; 
function QPixmap_create(w: Integer; h: Integer): QPixmapH; cdecl; external Qt4PasLib name 'QPixmap_create2';
function QPixmap_create(p1: PSize): QPixmapH; cdecl; external Qt4PasLib name 'QPixmap_create3';
function QPixmap_create(fileName: PWideString; format: PAnsiChar = nil; flags: QtImageConversionFlags = QtAutoColor): QPixmapH; cdecl; external Qt4PasLib name 'QPixmap_create4';
function QPixmap_create(xpm: PAnsiChar): QPixmapH; cdecl; external Qt4PasLib name 'QPixmap_create5';
function QPixmap_create(p1: QPixmapH): QPixmapH; cdecl; external Qt4PasLib name 'QPixmap_create6';
function QPixmap_isNull(handle: QPixmapH): Boolean; cdecl; external Qt4PasLib name 'QPixmap_isNull';
function QPixmap_devType(handle: QPixmapH): Integer; cdecl; external Qt4PasLib name 'QPixmap_devType';
function QPixmap_width(handle: QPixmapH): Integer; cdecl; external Qt4PasLib name 'QPixmap_width';
function QPixmap_height(handle: QPixmapH): Integer; cdecl; external Qt4PasLib name 'QPixmap_height';
procedure QPixmap_size(handle: QPixmapH; retval: PSize); cdecl; external Qt4PasLib name 'QPixmap_size';
procedure QPixmap_rect(handle: QPixmapH; retval: PRect); cdecl; external Qt4PasLib name 'QPixmap_rect';
function QPixmap_depth(handle: QPixmapH): Integer; cdecl; external Qt4PasLib name 'QPixmap_depth';
function QPixmap_defaultDepth(): Integer; cdecl; external Qt4PasLib name 'QPixmap_defaultDepth';
procedure QPixmap_fill(handle: QPixmapH; fillColor: PQColor); cdecl; external Qt4PasLib name 'QPixmap_fill';
procedure QPixmap_fill(handle: QPixmapH; widget: QWidgetH; ofs: PQtPoint); cdecl; external Qt4PasLib name 'QPixmap_fill2';
procedure QPixmap_fill(handle: QPixmapH; widget: QWidgetH; xofs: Integer; yofs: Integer); cdecl; external Qt4PasLib name 'QPixmap_fill3';
procedure QPixmap_mask(handle: QPixmapH; retval: QBitmapH); cdecl; external Qt4PasLib name 'QPixmap_mask';
procedure QPixmap_setMask(handle: QPixmapH; p1: QBitmapH); cdecl; external Qt4PasLib name 'QPixmap_setMask';
procedure QPixmap_alphaChannel(handle: QPixmapH; retval: QPixmapH); cdecl; external Qt4PasLib name 'QPixmap_alphaChannel';
procedure QPixmap_setAlphaChannel(handle: QPixmapH; p1: QPixmapH); cdecl; external Qt4PasLib name 'QPixmap_setAlphaChannel';
function QPixmap_hasAlpha(handle: QPixmapH): Boolean; cdecl; external Qt4PasLib name 'QPixmap_hasAlpha';
function QPixmap_hasAlphaChannel(handle: QPixmapH): Boolean; cdecl; external Qt4PasLib name 'QPixmap_hasAlphaChannel';
procedure QPixmap_createHeuristicMask(handle: QPixmapH; retval: QBitmapH; clipTight: Boolean = True); cdecl; external Qt4PasLib name 'QPixmap_createHeuristicMask';
procedure QPixmap_createMaskFromColor(handle: QPixmapH; retval: QBitmapH; maskColor: PQColor); cdecl; external Qt4PasLib name 'QPixmap_createMaskFromColor';
procedure QPixmap_createMaskFromColor(handle: QPixmapH; retval: QBitmapH; maskColor: PQColor; mode: QtMaskMode); cdecl; external Qt4PasLib name 'QPixmap_createMaskFromColor2';
procedure QPixmap_grabWindow(retval: QPixmapH; p1: LongWord; x: Integer = 0; y: Integer = 0; w: Integer = -1; h: Integer = -1); cdecl; external Qt4PasLib name 'QPixmap_grabWindow';
procedure QPixmap_grabWidget(retval: QPixmapH; widget: QWidgetH; rect: PRect); cdecl; external Qt4PasLib name 'QPixmap_grabWidget';
procedure QPixmap_grabWidget(retval: QPixmapH; widget: QWidgetH; x: Integer = 0; y: Integer = 0; w: Integer = -1; h: Integer = -1); cdecl; external Qt4PasLib name 'QPixmap_grabWidget2';
procedure QPixmap_scaled(handle: QPixmapH; retval: QPixmapH; w: Integer; h: Integer; aspectMode: QtAspectRatioMode = QtIgnoreAspectRatio; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QPixmap_scaled';
procedure QPixmap_scaled(handle: QPixmapH; retval: QPixmapH; s: PSize; aspectMode: QtAspectRatioMode = QtIgnoreAspectRatio; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QPixmap_scaled2';
procedure QPixmap_scaledToWidth(handle: QPixmapH; retval: QPixmapH; w: Integer; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QPixmap_scaledToWidth';
procedure QPixmap_scaledToHeight(handle: QPixmapH; retval: QPixmapH; h: Integer; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QPixmap_scaledToHeight';
procedure QPixmap_transformed(handle: QPixmapH; retval: QPixmapH; p1: QMatrixH; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QPixmap_transformed';
procedure QPixmap_trueMatrix(retval: QMatrixH; m: QMatrixH; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QPixmap_trueMatrix';
procedure QPixmap_transformed(handle: QPixmapH; retval: QPixmapH; p1: QTransformH; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QPixmap_transformed2';
procedure QPixmap_trueMatrix(retval: QTransformH; m: QTransformH; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QPixmap_trueMatrix2';
procedure QPixmap_toImage(handle: QPixmapH; retval: QImageH); cdecl; external Qt4PasLib name 'QPixmap_toImage';
procedure QPixmap_fromImage(retval: QPixmapH; image: QImageH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QPixmap_fromImage';
function QPixmap_load(handle: QPixmapH; fileName: PWideString; format: PAnsiChar = nil; flags: QtImageConversionFlags = QtAutoColor): Boolean; cdecl; external Qt4PasLib name 'QPixmap_load';
function QPixmap_loadFromData(handle: QPixmapH; buf: PByte; len: LongWord; format: PAnsiChar = nil; flags: QtImageConversionFlags = QtAutoColor): Boolean; cdecl; external Qt4PasLib name 'QPixmap_loadFromData';
function QPixmap_loadFromData(handle: QPixmapH; data: QByteArrayH; format: PAnsiChar = nil; flags: QtImageConversionFlags = QtAutoColor): Boolean; cdecl; external Qt4PasLib name 'QPixmap_loadFromData2';
function QPixmap_save(handle: QPixmapH; fileName: PWideString; format: PAnsiChar = nil; quality: Integer = -1): Boolean; cdecl; external Qt4PasLib name 'QPixmap_save';
function QPixmap_save(handle: QPixmapH; device: QIODeviceH; format: PAnsiChar = nil; quality: Integer = -1): Boolean; cdecl; external Qt4PasLib name 'QPixmap_save2';
procedure QPixmap_copy(handle: QPixmapH; retval: QPixmapH; x: Integer; y: Integer; width: Integer; height: Integer); cdecl; external Qt4PasLib name 'QPixmap_copy';
procedure QPixmap_copy(handle: QPixmapH; retval: QPixmapH; rect: PRect = nil); cdecl; external Qt4PasLib name 'QPixmap_copy2';
function QPixmap_serialNumber(handle: QPixmapH): Integer; cdecl; external Qt4PasLib name 'QPixmap_serialNumber';
function QPixmap_cacheKey(handle: QPixmapH): int64; cdecl; external Qt4PasLib name 'QPixmap_cacheKey';
function QPixmap_isDetached(handle: QPixmapH): Boolean; cdecl; external Qt4PasLib name 'QPixmap_isDetached';
procedure QPixmap_detach(handle: QPixmapH); cdecl; external Qt4PasLib name 'QPixmap_detach';
function QPixmap_isQBitmap(handle: QPixmapH): Boolean; cdecl; external Qt4PasLib name 'QPixmap_isQBitmap';
{$ifdef BINUX }
procedure QPixmap_fromX11Pixmap(retval: QPixmapH; pixmap: QtHANDLE; mode: QPixmapShareMode = QPixmapImplicitlyShared); cdecl; external Qt4PasLib name 'QPixmap_fromX11Pixmap';
function QPixmap_x11SetDefaultScreen(screen: Integer): Integer; cdecl; external Qt4PasLib name 'QPixmap_x11SetDefaultScreen';
procedure QPixmap_x11SetScreen(handle: QPixmapH; screen: Integer); cdecl; external Qt4PasLib name 'QPixmap_x11SetScreen';
function QPixmap_x11Info(handle: QPixmapH): QX11InfoH; cdecl; external Qt4PasLib name 'QPixmap_x11Info';
function QPixmap_x11PictureHandle(handle: QPixmapH): QtHANDLE; cdecl; external Qt4PasLib name 'QPixmap_x11PictureHandle';
{$endif}
{$ifdef BINUX or QTOPIA }
function QPixmap_handle(handle: QPixmapH): QtHANDLE; cdecl; external Qt4PasLib name 'QPixmap_handle';
{$endif}
function QPixmap_paintEngine(handle: QPixmapH): QPaintEngineH; cdecl; external Qt4PasLib name 'QPixmap_paintEngine';
{$ifdef MSWINDOWS }
function QPixmap_toWinHBITMAP(handle: QPixmapH; format: QPixmapHBitmapFormat = QPixmapNoAlpha): QHBITMAP; cdecl; external Qt4PasLib name 'QPixmap_toWinHBITMAP';
procedure QPixmap_fromWinHBITMAP(retval: QPixmapH; hbitmap: QHBITMAP; format: QPixmapHBitmapFormat = QPixmapNoAlpha); cdecl; external Qt4PasLib name 'QPixmap_fromWinHBITMAP';
{$endif}
{$ifdef DARWIN }
function QPixmap_toMacCGImageRef(handle: QPixmapH): CGImageRef; cdecl; external Qt4PasLib name 'QPixmap_toMacCGImageRef';
procedure QPixmap_fromMacCGImageRef(retval: QPixmapH; image: CGImageRef); cdecl; external Qt4PasLib name 'QPixmap_fromMacCGImageRef';
function QPixmap_macQDHandle(handle: QPixmapH): QtHANDLE; cdecl; external Qt4PasLib name 'QPixmap_macQDHandle';
function QPixmap_macQDAlphaHandle(handle: QPixmapH): QtHANDLE; cdecl; external Qt4PasLib name 'QPixmap_macQDAlphaHandle';
function QPixmap_macCGHandle(handle: QPixmapH): QtHANDLE; cdecl; external Qt4PasLib name 'QPixmap_macCGHandle';
{$endif}
{$ifdef QTOPIA }
function QPixmap_qwsBits(handle: QPixmapH): PByte; cdecl; external Qt4PasLib name 'QPixmap_qwsBits';
function QPixmap_qwsBytesPerLine(handle: QPixmapH): Integer; cdecl; external Qt4PasLib name 'QPixmap_qwsBytesPerLine';
function QPixmap_clut(handle: QPixmapH): PQRgb; cdecl; external Qt4PasLib name 'QPixmap_clut';
function QPixmap_numCols(handle: QPixmapH): Integer; cdecl; external Qt4PasLib name 'QPixmap_numCols';
{$endif}


type
  QImageInvertMode = ( // QImage::InvertMode (1)
    QImageInvertRgb, QImageInvertRgba );

  QImageFormat = ( // QImage::Format (1)
    QImageFormat_Invalid, QImageFormat_Mono, QImageFormat_MonoLSB, QImageFormat_Indexed8, QImageFormat_RGB32, QImageFormat_ARGB32, QImageFormat_ARGB32_Premultiplied, QImageFormat_RGB16, 
    QImageFormat_ARGB8565_Premultiplied, QImageFormat_RGB666, QImageFormat_ARGB6666_Premultiplied, QImageFormat_RGB555, QImageFormat_ARGB8555_Premultiplied, QImageFormat_RGB888, QImageFormat_RGB444, 
    QImageFormat_ARGB4444_Premultiplied, QImageNImageFormats );

function QImage_create(): QImageH; cdecl; external Qt4PasLib name 'QImage_create';
procedure QImage_destroy(handle: QImageH); cdecl; external Qt4PasLib name 'QImage_destroy'; 
function QImage_create(size: PSize; format: QImageFormat): QImageH; cdecl; external Qt4PasLib name 'QImage_create2';
function QImage_create(width: Integer; height: Integer; format: QImageFormat): QImageH; cdecl; external Qt4PasLib name 'QImage_create3';
function QImage_create(data: PByte; width: Integer; height: Integer; format: QImageFormat): QImageH; cdecl; external Qt4PasLib name 'QImage_create4';
function QImage_create(data: PByte; width: Integer; height: Integer; bytesPerLine: Integer; format: QImageFormat): QImageH; cdecl; external Qt4PasLib name 'QImage_create6';
function QImage_create(xpm: PAnsiChar): QImageH; cdecl; external Qt4PasLib name 'QImage_create8';
function QImage_create(fileName: PWideString; format: PAnsiChar = nil): QImageH; cdecl; external Qt4PasLib name 'QImage_create9';
function QImage_create(fileName: PAnsiChar; format: PAnsiChar = nil): QImageH; cdecl; external Qt4PasLib name 'QImage_create10';
function QImage_create(p1: QImageH): QImageH; cdecl; external Qt4PasLib name 'QImage_create11';
function QImage_isNull(handle: QImageH): Boolean; cdecl; external Qt4PasLib name 'QImage_isNull';
function QImage_devType(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_devType';
procedure QImage_detach(handle: QImageH); cdecl; external Qt4PasLib name 'QImage_detach';
function QImage_isDetached(handle: QImageH): Boolean; cdecl; external Qt4PasLib name 'QImage_isDetached';
procedure QImage_copy(handle: QImageH; retval: QImageH; rect: PRect = nil); cdecl; external Qt4PasLib name 'QImage_copy';
procedure QImage_copy(handle: QImageH; retval: QImageH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QImage_copy2';
function QImage_format(handle: QImageH): QImageFormat; cdecl; external Qt4PasLib name 'QImage_format';
procedure QImage_convertToFormat(handle: QImageH; retval: QImageH; f: QImageFormat; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QImage_convertToFormat';
function QImage_width(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_width';
function QImage_height(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_height';
procedure QImage_size(handle: QImageH; retval: PSize); cdecl; external Qt4PasLib name 'QImage_size';
procedure QImage_rect(handle: QImageH; retval: PRect); cdecl; external Qt4PasLib name 'QImage_rect';
function QImage_depth(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_depth';
function QImage_numColors(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_numColors';
function QImage_color(handle: QImageH; i: Integer): QRgb; cdecl; external Qt4PasLib name 'QImage_color';
procedure QImage_setColor(handle: QImageH; i: Integer; c: QRgb); cdecl; external Qt4PasLib name 'QImage_setColor';
procedure QImage_setNumColors(handle: QImageH; p1: Integer); cdecl; external Qt4PasLib name 'QImage_setNumColors';
function QImage_allGray(handle: QImageH): Boolean; cdecl; external Qt4PasLib name 'QImage_allGray';
function QImage_isGrayscale(handle: QImageH): Boolean; cdecl; external Qt4PasLib name 'QImage_isGrayscale';
function QImage_bits(handle: QImageH): PByte; cdecl; external Qt4PasLib name 'QImage_bits';
function QImage_numBytes(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_numBytes';
function QImage_scanLine(handle: QImageH; p1: Integer): PByte; cdecl; external Qt4PasLib name 'QImage_scanLine';
function QImage_bytesPerLine(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_bytesPerLine';
function QImage_valid(handle: QImageH; x: Integer; y: Integer): Boolean; cdecl; external Qt4PasLib name 'QImage_valid';
function QImage_valid(handle: QImageH; pt: PQtPoint): Boolean; cdecl; external Qt4PasLib name 'QImage_valid2';
function QImage_pixelIndex(handle: QImageH; x: Integer; y: Integer): Integer; cdecl; external Qt4PasLib name 'QImage_pixelIndex';
function QImage_pixelIndex(handle: QImageH; pt: PQtPoint): Integer; cdecl; external Qt4PasLib name 'QImage_pixelIndex2';
function QImage_pixel(handle: QImageH; x: Integer; y: Integer): QRgb; cdecl; external Qt4PasLib name 'QImage_pixel';
function QImage_pixel(handle: QImageH; pt: PQtPoint): QRgb; cdecl; external Qt4PasLib name 'QImage_pixel2';
procedure QImage_setPixel(handle: QImageH; x: Integer; y: Integer; index_or_rgb: LongWord); cdecl; external Qt4PasLib name 'QImage_setPixel';
procedure QImage_setPixel(handle: QImageH; pt: PQtPoint; index_or_rgb: LongWord); cdecl; external Qt4PasLib name 'QImage_setPixel2';
procedure QImage_fill(handle: QImageH; pixel: LongWord); cdecl; external Qt4PasLib name 'QImage_fill';
function QImage_hasAlphaChannel(handle: QImageH): Boolean; cdecl; external Qt4PasLib name 'QImage_hasAlphaChannel';
procedure QImage_setAlphaChannel(handle: QImageH; alphaChannel: QImageH); cdecl; external Qt4PasLib name 'QImage_setAlphaChannel';
procedure QImage_alphaChannel(handle: QImageH; retval: QImageH); cdecl; external Qt4PasLib name 'QImage_alphaChannel';
procedure QImage_createAlphaMask(handle: QImageH; retval: QImageH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QImage_createAlphaMask';
procedure QImage_createHeuristicMask(handle: QImageH; retval: QImageH; clipTight: Boolean = True); cdecl; external Qt4PasLib name 'QImage_createHeuristicMask';
procedure QImage_createMaskFromColor(handle: QImageH; retval: QImageH; color: QRgb; mode: QtMaskMode = QtMaskInColor); cdecl; external Qt4PasLib name 'QImage_createMaskFromColor';
procedure QImage_scaled(handle: QImageH; retval: QImageH; w: Integer; h: Integer; aspectMode: QtAspectRatioMode = QtIgnoreAspectRatio; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QImage_scaled';
procedure QImage_scaled(handle: QImageH; retval: QImageH; s: PSize; aspectMode: QtAspectRatioMode = QtIgnoreAspectRatio; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QImage_scaled2';
procedure QImage_scaledToWidth(handle: QImageH; retval: QImageH; w: Integer; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QImage_scaledToWidth';
procedure QImage_scaledToHeight(handle: QImageH; retval: QImageH; h: Integer; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QImage_scaledToHeight';
procedure QImage_transformed(handle: QImageH; retval: QImageH; matrix: QMatrixH; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QImage_transformed';
procedure QImage_trueMatrix(retval: QMatrixH; p1: QMatrixH; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QImage_trueMatrix';
procedure QImage_transformed(handle: QImageH; retval: QImageH; matrix: QTransformH; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt4PasLib name 'QImage_transformed2';
procedure QImage_trueMatrix(retval: QTransformH; p1: QTransformH; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QImage_trueMatrix2';
procedure QImage_mirrored(handle: QImageH; retval: QImageH; horizontally: Boolean = False; vertically: Boolean = True); cdecl; external Qt4PasLib name 'QImage_mirrored';
procedure QImage_rgbSwapped(handle: QImageH; retval: QImageH); cdecl; external Qt4PasLib name 'QImage_rgbSwapped';
procedure QImage_invertPixels(handle: QImageH; p1: QImageInvertMode = QImageInvertRgb); cdecl; external Qt4PasLib name 'QImage_invertPixels';
function QImage_load(handle: QImageH; device: QIODeviceH; format: PAnsiChar): Boolean; cdecl; external Qt4PasLib name 'QImage_load';
function QImage_load(handle: QImageH; fileName: PWideString; format: PAnsiChar = nil): Boolean; cdecl; external Qt4PasLib name 'QImage_load2';
function QImage_loadFromData(handle: QImageH; buf: PByte; len: Integer; format: PAnsiChar = nil): Boolean; cdecl; external Qt4PasLib name 'QImage_loadFromData';
function QImage_loadFromData(handle: QImageH; data: QByteArrayH; aformat: PAnsiChar = nil): Boolean; cdecl; external Qt4PasLib name 'QImage_loadFromData2';
function QImage_save(handle: QImageH; fileName: PWideString; format: PAnsiChar = nil; quality: Integer = -1): Boolean; cdecl; external Qt4PasLib name 'QImage_save';
function QImage_save(handle: QImageH; device: QIODeviceH; format: PAnsiChar = nil; quality: Integer = -1): Boolean; cdecl; external Qt4PasLib name 'QImage_save2';
procedure QImage_fromData(retval: QImageH; data: PByte; size: Integer; format: PAnsiChar = nil); cdecl; external Qt4PasLib name 'QImage_fromData';
procedure QImage_fromData(retval: QImageH; data: QByteArrayH; format: PAnsiChar = nil); cdecl; external Qt4PasLib name 'QImage_fromData2';
function QImage_serialNumber(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_serialNumber';
function QImage_cacheKey(handle: QImageH): int64; cdecl; external Qt4PasLib name 'QImage_cacheKey';
function QImage_paintEngine(handle: QImageH): QPaintEngineH; cdecl; external Qt4PasLib name 'QImage_paintEngine';
function QImage_dotsPerMeterX(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_dotsPerMeterX';
function QImage_dotsPerMeterY(handle: QImageH): Integer; cdecl; external Qt4PasLib name 'QImage_dotsPerMeterY';
procedure QImage_setDotsPerMeterX(handle: QImageH; p1: Integer); cdecl; external Qt4PasLib name 'QImage_setDotsPerMeterX';
procedure QImage_setDotsPerMeterY(handle: QImageH; p1: Integer); cdecl; external Qt4PasLib name 'QImage_setDotsPerMeterY';
procedure QImage_offset(handle: QImageH; retval: PQtPoint); cdecl; external Qt4PasLib name 'QImage_offset';
procedure QImage_setOffset(handle: QImageH; p1: PQtPoint); cdecl; external Qt4PasLib name 'QImage_setOffset';
procedure QImage_textKeys(handle: QImageH; retval: QStringListH); cdecl; external Qt4PasLib name 'QImage_textKeys';
procedure QImage_text(handle: QImageH; retval: PWideString; key: PWideString = nil); cdecl; external Qt4PasLib name 'QImage_text';
procedure QImage_setText(handle: QImageH; key: PWideString; value: PWideString); cdecl; external Qt4PasLib name 'QImage_setText';
procedure QImage_text(handle: QImageH; retval: PWideString; key: PAnsiChar; lang: PAnsiChar = nil); cdecl; external Qt4PasLib name 'QImage_text2';
procedure QImage_textLanguages(handle: QImageH; retval: QStringListH); cdecl; external Qt4PasLib name 'QImage_textLanguages';
procedure QImage_setText(handle: QImageH; key: PAnsiChar; lang: PAnsiChar; p3: PWideString); cdecl; external Qt4PasLib name 'QImage_setText2';

function QBitmap_create(): QBitmapH; cdecl; external Qt4PasLib name 'QBitmap_create';
procedure QBitmap_destroy(handle: QBitmapH); cdecl; external Qt4PasLib name 'QBitmap_destroy'; 
function QBitmap_create(p1: QPixmapH): QBitmapH; cdecl; external Qt4PasLib name 'QBitmap_create2';
function QBitmap_create(w: Integer; h: Integer): QBitmapH; cdecl; external Qt4PasLib name 'QBitmap_create3';
function QBitmap_create(p1: PSize): QBitmapH; cdecl; external Qt4PasLib name 'QBitmap_create4';
function QBitmap_create(fileName: PWideString; format: PAnsiChar = nil): QBitmapH; cdecl; external Qt4PasLib name 'QBitmap_create5';
procedure QBitmap_clear(handle: QBitmapH); cdecl; external Qt4PasLib name 'QBitmap_clear';
procedure QBitmap_fromImage(retval: QBitmapH; image: QImageH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt4PasLib name 'QBitmap_fromImage';
procedure QBitmap_fromData(retval: QBitmapH; size: PSize; bits: PByte; monoFormat: QImageFormat = QImageFormat_MonoLSB); cdecl; external Qt4PasLib name 'QBitmap_fromData';
procedure QBitmap_transformed(handle: QBitmapH; retval: QBitmapH; p1: QMatrixH); cdecl; external Qt4PasLib name 'QBitmap_transformed';
procedure QBitmap_transformed(handle: QBitmapH; retval: QBitmapH; matrix: QTransformH); cdecl; external Qt4PasLib name 'QBitmap_transformed2';

function QPicture_create(formatVersion: Integer = -1): QPictureH; cdecl; external Qt4PasLib name 'QPicture_create';
procedure QPicture_destroy(handle: QPictureH); cdecl; external Qt4PasLib name 'QPicture_destroy'; 
function QPicture_create(p1: QPictureH): QPictureH; cdecl; external Qt4PasLib name 'QPicture_create2';
function QPicture_isNull(handle: QPictureH): Boolean; cdecl; external Qt4PasLib name 'QPicture_isNull';
function QPicture_devType(handle: QPictureH): Integer; cdecl; external Qt4PasLib name 'QPicture_devType';
function QPicture_size(handle: QPictureH): LongWord; cdecl; external Qt4PasLib name 'QPicture_size';
function QPicture_data(handle: QPictureH): PAnsiChar; cdecl; external Qt4PasLib name 'QPicture_data';
procedure QPicture_setData(handle: QPictureH; data: PAnsiChar; size: LongWord); cdecl; external Qt4PasLib name 'QPicture_setData';
function QPicture_play(handle: QPictureH; p: QPainterH): Boolean; cdecl; external Qt4PasLib name 'QPicture_play';
function QPicture_load(handle: QPictureH; dev: QIODeviceH; format: PAnsiChar = nil): Boolean; cdecl; external Qt4PasLib name 'QPicture_load';
function QPicture_load(handle: QPictureH; fileName: PWideString; format: PAnsiChar = nil): Boolean; cdecl; external Qt4PasLib name 'QPicture_load2';
function QPicture_save(handle: QPictureH; dev: QIODeviceH; format: PAnsiChar = nil): Boolean; cdecl; external Qt4PasLib name 'QPicture_save';
function QPicture_save(handle: QPictureH; fileName: PWideString; format: PAnsiChar = nil): Boolean; cdecl; external Qt4PasLib name 'QPicture_save2';
procedure QPicture_boundingRect(handle: QPictureH; retval: PRect); cdecl; external Qt4PasLib name 'QPicture_boundingRect';
procedure QPicture_setBoundingRect(handle: QPictureH; r: PRect); cdecl; external Qt4PasLib name 'QPicture_setBoundingRect';
procedure QPicture_detach(handle: QPictureH); cdecl; external Qt4PasLib name 'QPicture_detach';
function QPicture_isDetached(handle: QPictureH): Boolean; cdecl; external Qt4PasLib name 'QPicture_isDetached';
function QPicture_pictureFormat(fileName: PWideString): PAnsiChar; cdecl; external Qt4PasLib name 'QPicture_pictureFormat';
procedure QPicture_inputFormatList(retval: QStringListH); cdecl; external Qt4PasLib name 'QPicture_inputFormatList';
procedure QPicture_outputFormatList(retval: QStringListH); cdecl; external Qt4PasLib name 'QPicture_outputFormatList';
function QPicture_paintEngine(handle: QPictureH): QPaintEngineH; cdecl; external Qt4PasLib name 'QPicture_paintEngine';


type
  QImageIOHandlerImageOption = ( // QImageIOHandler::ImageOption (1)
    QImageIOHandlerSize, QImageIOHandlerClipRect, QImageIOHandlerDescription, QImageIOHandlerScaledClipRect, QImageIOHandlerScaledSize, QImageIOHandlerCompressionRatio, QImageIOHandlerGamma, 
    QImageIOHandlerQuality, QImageIOHandlerName, QImageIOHandlerSubType, QImageIOHandlerIncrementalReading, QImageIOHandlerEndianness, QImageIOHandlerAnimation, QImageIOHandlerBackgroundColor, 
    QImageIOHandlerImageFormat );

procedure QImageIOHandler_setDevice(handle: QImageIOHandlerH; device: QIODeviceH); cdecl; external Qt4PasLib name 'QImageIOHandler_setDevice';
function QImageIOHandler_device(handle: QImageIOHandlerH): QIODeviceH; cdecl; external Qt4PasLib name 'QImageIOHandler_device';
procedure QImageIOHandler_setFormat(handle: QImageIOHandlerH; format: QByteArrayH); cdecl; external Qt4PasLib name 'QImageIOHandler_setFormat';
procedure QImageIOHandler_format(handle: QImageIOHandlerH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QImageIOHandler_format';
procedure QImageIOHandler_name(handle: QImageIOHandlerH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QImageIOHandler_name';
function QImageIOHandler_canRead(handle: QImageIOHandlerH): Boolean; cdecl; external Qt4PasLib name 'QImageIOHandler_canRead';
function QImageIOHandler_read(handle: QImageIOHandlerH; image: QImageH): Boolean; cdecl; external Qt4PasLib name 'QImageIOHandler_read';
function QImageIOHandler_write(handle: QImageIOHandlerH; image: QImageH): Boolean; cdecl; external Qt4PasLib name 'QImageIOHandler_write';
procedure QImageIOHandler_option(handle: QImageIOHandlerH; retval: QVariantH; option: QImageIOHandlerImageOption); cdecl; external Qt4PasLib name 'QImageIOHandler_option';
procedure QImageIOHandler_setOption(handle: QImageIOHandlerH; option: QImageIOHandlerImageOption; value: QVariantH); cdecl; external Qt4PasLib name 'QImageIOHandler_setOption';
function QImageIOHandler_supportsOption(handle: QImageIOHandlerH; option: QImageIOHandlerImageOption): Boolean; cdecl; external Qt4PasLib name 'QImageIOHandler_supportsOption';
function QImageIOHandler_jumpToNextImage(handle: QImageIOHandlerH): Boolean; cdecl; external Qt4PasLib name 'QImageIOHandler_jumpToNextImage';
function QImageIOHandler_jumpToImage(handle: QImageIOHandlerH; imageNumber: Integer): Boolean; cdecl; external Qt4PasLib name 'QImageIOHandler_jumpToImage';
function QImageIOHandler_loopCount(handle: QImageIOHandlerH): Integer; cdecl; external Qt4PasLib name 'QImageIOHandler_loopCount';
function QImageIOHandler_imageCount(handle: QImageIOHandlerH): Integer; cdecl; external Qt4PasLib name 'QImageIOHandler_imageCount';
function QImageIOHandler_nextImageDelay(handle: QImageIOHandlerH): Integer; cdecl; external Qt4PasLib name 'QImageIOHandler_nextImageDelay';
function QImageIOHandler_currentImageNumber(handle: QImageIOHandlerH): Integer; cdecl; external Qt4PasLib name 'QImageIOHandler_currentImageNumber';
procedure QImageIOHandler_currentImageRect(handle: QImageIOHandlerH; retval: PRect); cdecl; external Qt4PasLib name 'QImageIOHandler_currentImageRect';


type
  QImageReaderImageReaderError = ( // QImageReader::ImageReaderError (1)
    QImageReaderUnknownError, QImageReaderFileNotFoundError, QImageReaderDeviceError, QImageReaderUnsupportedFormatError, QImageReaderInvalidDataError );

function QImageReader_create(): QImageReaderH; cdecl; external Qt4PasLib name 'QImageReader_create';
procedure QImageReader_destroy(handle: QImageReaderH); cdecl; external Qt4PasLib name 'QImageReader_destroy'; 
function QImageReader_create(device: QIODeviceH; format: QByteArrayH = nil): QImageReaderH; cdecl; external Qt4PasLib name 'QImageReader_create2';
function QImageReader_create(fileName: PWideString; format: QByteArrayH = nil): QImageReaderH; cdecl; external Qt4PasLib name 'QImageReader_create3';
procedure QImageReader_setFormat(handle: QImageReaderH; format: QByteArrayH); cdecl; external Qt4PasLib name 'QImageReader_setFormat';
procedure QImageReader_format(handle: QImageReaderH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QImageReader_format';
procedure QImageReader_setAutoDetectImageFormat(handle: QImageReaderH; enabled: Boolean); cdecl; external Qt4PasLib name 'QImageReader_setAutoDetectImageFormat';
function QImageReader_autoDetectImageFormat(handle: QImageReaderH): Boolean; cdecl; external Qt4PasLib name 'QImageReader_autoDetectImageFormat';
procedure QImageReader_setDevice(handle: QImageReaderH; device: QIODeviceH); cdecl; external Qt4PasLib name 'QImageReader_setDevice';
function QImageReader_device(handle: QImageReaderH): QIODeviceH; cdecl; external Qt4PasLib name 'QImageReader_device';
procedure QImageReader_setFileName(handle: QImageReaderH; fileName: PWideString); cdecl; external Qt4PasLib name 'QImageReader_setFileName';
procedure QImageReader_fileName(handle: QImageReaderH; retval: PWideString); cdecl; external Qt4PasLib name 'QImageReader_fileName';
procedure QImageReader_size(handle: QImageReaderH; retval: PSize); cdecl; external Qt4PasLib name 'QImageReader_size';
function QImageReader_imageFormat(handle: QImageReaderH): QImageFormat; cdecl; external Qt4PasLib name 'QImageReader_imageFormat';
procedure QImageReader_textKeys(handle: QImageReaderH; retval: QStringListH); cdecl; external Qt4PasLib name 'QImageReader_textKeys';
procedure QImageReader_text(handle: QImageReaderH; retval: PWideString; key: PWideString); cdecl; external Qt4PasLib name 'QImageReader_text';
procedure QImageReader_setClipRect(handle: QImageReaderH; rect: PRect); cdecl; external Qt4PasLib name 'QImageReader_setClipRect';
procedure QImageReader_clipRect(handle: QImageReaderH; retval: PRect); cdecl; external Qt4PasLib name 'QImageReader_clipRect';
procedure QImageReader_setScaledSize(handle: QImageReaderH; size: PSize); cdecl; external Qt4PasLib name 'QImageReader_setScaledSize';
procedure QImageReader_scaledSize(handle: QImageReaderH; retval: PSize); cdecl; external Qt4PasLib name 'QImageReader_scaledSize';
procedure QImageReader_setQuality(handle: QImageReaderH; quality: Integer); cdecl; external Qt4PasLib name 'QImageReader_setQuality';
function QImageReader_quality(handle: QImageReaderH): Integer; cdecl; external Qt4PasLib name 'QImageReader_quality';
procedure QImageReader_setScaledClipRect(handle: QImageReaderH; rect: PRect); cdecl; external Qt4PasLib name 'QImageReader_setScaledClipRect';
procedure QImageReader_scaledClipRect(handle: QImageReaderH; retval: PRect); cdecl; external Qt4PasLib name 'QImageReader_scaledClipRect';
procedure QImageReader_setBackgroundColor(handle: QImageReaderH; color: PQColor); cdecl; external Qt4PasLib name 'QImageReader_setBackgroundColor';
procedure QImageReader_backgroundColor(handle: QImageReaderH; retval: PQColor); cdecl; external Qt4PasLib name 'QImageReader_backgroundColor';
function QImageReader_supportsAnimation(handle: QImageReaderH): Boolean; cdecl; external Qt4PasLib name 'QImageReader_supportsAnimation';
function QImageReader_canRead(handle: QImageReaderH): Boolean; cdecl; external Qt4PasLib name 'QImageReader_canRead';
procedure QImageReader_read(handle: QImageReaderH; retval: QImageH); cdecl; external Qt4PasLib name 'QImageReader_read';
function QImageReader_jumpToNextImage(handle: QImageReaderH): Boolean; cdecl; external Qt4PasLib name 'QImageReader_jumpToNextImage';
function QImageReader_jumpToImage(handle: QImageReaderH; imageNumber: Integer): Boolean; cdecl; external Qt4PasLib name 'QImageReader_jumpToImage';
function QImageReader_loopCount(handle: QImageReaderH): Integer; cdecl; external Qt4PasLib name 'QImageReader_loopCount';
function QImageReader_imageCount(handle: QImageReaderH): Integer; cdecl; external Qt4PasLib name 'QImageReader_imageCount';
function QImageReader_nextImageDelay(handle: QImageReaderH): Integer; cdecl; external Qt4PasLib name 'QImageReader_nextImageDelay';
function QImageReader_currentImageNumber(handle: QImageReaderH): Integer; cdecl; external Qt4PasLib name 'QImageReader_currentImageNumber';
procedure QImageReader_currentImageRect(handle: QImageReaderH; retval: PRect); cdecl; external Qt4PasLib name 'QImageReader_currentImageRect';
function QImageReader_error(handle: QImageReaderH): QImageReaderImageReaderError; cdecl; external Qt4PasLib name 'QImageReader_error';
procedure QImageReader_errorString(handle: QImageReaderH; retval: PWideString); cdecl; external Qt4PasLib name 'QImageReader_errorString';
function QImageReader_supportsOption(handle: QImageReaderH; option: QImageIOHandlerImageOption): Boolean; cdecl; external Qt4PasLib name 'QImageReader_supportsOption';
procedure QImageReader_imageFormat(retval: QByteArrayH; fileName: PWideString); cdecl; external Qt4PasLib name 'QImageReader_imageFormat2';
procedure QImageReader_imageFormat(retval: QByteArrayH; device: QIODeviceH); cdecl; external Qt4PasLib name 'QImageReader_imageFormat3';


type
  QImageWriterImageWriterError = ( // QImageWriter::ImageWriterError (1)
    QImageWriterUnknownError, QImageWriterDeviceError, QImageWriterUnsupportedFormatError );

function QImageWriter_create(): QImageWriterH; cdecl; external Qt4PasLib name 'QImageWriter_create';
procedure QImageWriter_destroy(handle: QImageWriterH); cdecl; external Qt4PasLib name 'QImageWriter_destroy'; 
function QImageWriter_create(device: QIODeviceH; format: QByteArrayH): QImageWriterH; cdecl; external Qt4PasLib name 'QImageWriter_create2';
function QImageWriter_create(fileName: PWideString; format: QByteArrayH = nil): QImageWriterH; cdecl; external Qt4PasLib name 'QImageWriter_create3';
procedure QImageWriter_setFormat(handle: QImageWriterH; format: QByteArrayH); cdecl; external Qt4PasLib name 'QImageWriter_setFormat';
procedure QImageWriter_format(handle: QImageWriterH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QImageWriter_format';
procedure QImageWriter_setDevice(handle: QImageWriterH; device: QIODeviceH); cdecl; external Qt4PasLib name 'QImageWriter_setDevice';
function QImageWriter_device(handle: QImageWriterH): QIODeviceH; cdecl; external Qt4PasLib name 'QImageWriter_device';
procedure QImageWriter_setFileName(handle: QImageWriterH; fileName: PWideString); cdecl; external Qt4PasLib name 'QImageWriter_setFileName';
procedure QImageWriter_fileName(handle: QImageWriterH; retval: PWideString); cdecl; external Qt4PasLib name 'QImageWriter_fileName';
procedure QImageWriter_setQuality(handle: QImageWriterH; quality: Integer); cdecl; external Qt4PasLib name 'QImageWriter_setQuality';
function QImageWriter_quality(handle: QImageWriterH): Integer; cdecl; external Qt4PasLib name 'QImageWriter_quality';
procedure QImageWriter_setCompression(handle: QImageWriterH; compression: Integer); cdecl; external Qt4PasLib name 'QImageWriter_setCompression';
function QImageWriter_compression(handle: QImageWriterH): Integer; cdecl; external Qt4PasLib name 'QImageWriter_compression';
procedure QImageWriter_setGamma(handle: QImageWriterH; gamma: Single); cdecl; external Qt4PasLib name 'QImageWriter_setGamma';
function QImageWriter_gamma(handle: QImageWriterH): Single; cdecl; external Qt4PasLib name 'QImageWriter_gamma';
procedure QImageWriter_setDescription(handle: QImageWriterH; description: PWideString); cdecl; external Qt4PasLib name 'QImageWriter_setDescription';
procedure QImageWriter_description(handle: QImageWriterH; retval: PWideString); cdecl; external Qt4PasLib name 'QImageWriter_description';
procedure QImageWriter_setText(handle: QImageWriterH; key: PWideString; text: PWideString); cdecl; external Qt4PasLib name 'QImageWriter_setText';
function QImageWriter_canWrite(handle: QImageWriterH): Boolean; cdecl; external Qt4PasLib name 'QImageWriter_canWrite';
function QImageWriter_write(handle: QImageWriterH; image: QImageH): Boolean; cdecl; external Qt4PasLib name 'QImageWriter_write';
function QImageWriter_error(handle: QImageWriterH): QImageWriterImageWriterError; cdecl; external Qt4PasLib name 'QImageWriter_error';
procedure QImageWriter_errorString(handle: QImageWriterH; retval: PWideString); cdecl; external Qt4PasLib name 'QImageWriter_errorString';
function QImageWriter_supportsOption(handle: QImageWriterH; option: QImageIOHandlerImageOption): Boolean; cdecl; external Qt4PasLib name 'QImageWriter_supportsOption';


type
  QValidatorState = ( // QValidator::State (1)
    QValidatorInvalid, QValidatorIntermediate, QValidatorAcceptable );


type
  QDoubleValidatorNotation = ( // QDoubleValidator::Notation (1)
    QDoubleValidatorStandardNotation, QDoubleValidatorScientificNotation );

procedure QValidator_setLocale(handle: QValidatorH; locale: QLocaleH); cdecl; external Qt4PasLib name 'QValidator_setLocale';
procedure QValidator_locale(handle: QValidatorH; retval: QLocaleH); cdecl; external Qt4PasLib name 'QValidator_locale';
function QValidator_validate(handle: QValidatorH; p1: PWideString; p2: PInteger): QValidatorState; cdecl; external Qt4PasLib name 'QValidator_validate';
procedure QValidator_fixup(handle: QValidatorH; p1: PWideString); cdecl; external Qt4PasLib name 'QValidator_fixup';

function QIntValidator_create(parent: QObjectH): QIntValidatorH; cdecl; external Qt4PasLib name 'QIntValidator_create';
procedure QIntValidator_destroy(handle: QIntValidatorH); cdecl; external Qt4PasLib name 'QIntValidator_destroy'; 
function QIntValidator_create(bottom: Integer; top: Integer; parent: QObjectH): QIntValidatorH; cdecl; external Qt4PasLib name 'QIntValidator_create2';
function QIntValidator_validate(handle: QIntValidatorH; p1: PWideString; p2: PInteger): QValidatorState; cdecl; external Qt4PasLib name 'QIntValidator_validate';
procedure QIntValidator_setBottom(handle: QIntValidatorH; p1: Integer); cdecl; external Qt4PasLib name 'QIntValidator_setBottom';
procedure QIntValidator_setTop(handle: QIntValidatorH; p1: Integer); cdecl; external Qt4PasLib name 'QIntValidator_setTop';
procedure QIntValidator_setRange(handle: QIntValidatorH; bottom: Integer; top: Integer); cdecl; external Qt4PasLib name 'QIntValidator_setRange';
function QIntValidator_bottom(handle: QIntValidatorH): Integer; cdecl; external Qt4PasLib name 'QIntValidator_bottom';
function QIntValidator_top(handle: QIntValidatorH): Integer; cdecl; external Qt4PasLib name 'QIntValidator_top';

function QDoubleValidator_create(parent: QObjectH): QDoubleValidatorH; cdecl; external Qt4PasLib name 'QDoubleValidator_create';
procedure QDoubleValidator_destroy(handle: QDoubleValidatorH); cdecl; external Qt4PasLib name 'QDoubleValidator_destroy'; 
function QDoubleValidator_create(bottom: Double; top: Double; decimals: Integer; parent: QObjectH): QDoubleValidatorH; cdecl; external Qt4PasLib name 'QDoubleValidator_create2';
function QDoubleValidator_validate(handle: QDoubleValidatorH; p1: PWideString; p2: PInteger): QValidatorState; cdecl; external Qt4PasLib name 'QDoubleValidator_validate';
procedure QDoubleValidator_setRange(handle: QDoubleValidatorH; bottom: Double; top: Double; decimals: Integer = 0); cdecl; external Qt4PasLib name 'QDoubleValidator_setRange';
procedure QDoubleValidator_setBottom(handle: QDoubleValidatorH; p1: Double); cdecl; external Qt4PasLib name 'QDoubleValidator_setBottom';
procedure QDoubleValidator_setTop(handle: QDoubleValidatorH; p1: Double); cdecl; external Qt4PasLib name 'QDoubleValidator_setTop';
procedure QDoubleValidator_setDecimals(handle: QDoubleValidatorH; p1: Integer); cdecl; external Qt4PasLib name 'QDoubleValidator_setDecimals';
procedure QDoubleValidator_setNotation(handle: QDoubleValidatorH; p1: QDoubleValidatorNotation); cdecl; external Qt4PasLib name 'QDoubleValidator_setNotation';
function QDoubleValidator_bottom(handle: QDoubleValidatorH): Double; cdecl; external Qt4PasLib name 'QDoubleValidator_bottom';
function QDoubleValidator_top(handle: QDoubleValidatorH): Double; cdecl; external Qt4PasLib name 'QDoubleValidator_top';
function QDoubleValidator_decimals(handle: QDoubleValidatorH): Integer; cdecl; external Qt4PasLib name 'QDoubleValidator_decimals';
function QDoubleValidator_notation(handle: QDoubleValidatorH): QDoubleValidatorNotation; cdecl; external Qt4PasLib name 'QDoubleValidator_notation';

function QRegExpValidator_create(parent: QObjectH): QRegExpValidatorH; cdecl; external Qt4PasLib name 'QRegExpValidator_create';
procedure QRegExpValidator_destroy(handle: QRegExpValidatorH); cdecl; external Qt4PasLib name 'QRegExpValidator_destroy'; 
function QRegExpValidator_create(rx: QRegExpH; parent: QObjectH): QRegExpValidatorH; cdecl; external Qt4PasLib name 'QRegExpValidator_create2';
function QRegExpValidator_validate(handle: QRegExpValidatorH; input: PWideString; pos: PInteger): QValidatorState; cdecl; external Qt4PasLib name 'QRegExpValidator_validate';
procedure QRegExpValidator_setRegExp(handle: QRegExpValidatorH; rx: QRegExpH); cdecl; external Qt4PasLib name 'QRegExpValidator_setRegExp';
function QRegExpValidator_regExp(handle: QRegExpValidatorH): QRegExpH; cdecl; external Qt4PasLib name 'QRegExpValidator_regExp';


type
  QFrameShape = (  //QFrame::Shape (2)
    QFrameNoFrame = 0,
    QFrameBox = $0001,
    QFramePanel = $0002,
    QFrameWinPanel = $0003,
    QFrameHLine = $0004,
    QFrameVLine = $0005,
    QFrameStyledPanel = $0006 );

  QFrameShadow = (  //QFrame::Shadow (2)
    QFramePlain = $0010,
    QFrameRaised = $0020,
    QFrameSunken = $0030 );

  QFrameStyleMask = (  //QFrame::StyleMask (2)
    QFrameShape_Mask = $000f,
    QFrameShadow_Mask = $00f0 );

function QFrame_create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QFrameH; cdecl; external Qt4PasLib name 'QFrame_create';
procedure QFrame_destroy(handle: QFrameH); cdecl; external Qt4PasLib name 'QFrame_destroy'; 
function QFrame_frameStyle(handle: QFrameH): Integer; cdecl; external Qt4PasLib name 'QFrame_frameStyle';
procedure QFrame_setFrameStyle(handle: QFrameH; p1: Integer); cdecl; external Qt4PasLib name 'QFrame_setFrameStyle';
function QFrame_frameWidth(handle: QFrameH): Integer; cdecl; external Qt4PasLib name 'QFrame_frameWidth';
procedure QFrame_sizeHint(handle: QFrameH; retval: PSize); cdecl; external Qt4PasLib name 'QFrame_sizeHint';
function QFrame_frameShape(handle: QFrameH): QFrameShape; cdecl; external Qt4PasLib name 'QFrame_frameShape';
procedure QFrame_setFrameShape(handle: QFrameH; p1: QFrameShape); cdecl; external Qt4PasLib name 'QFrame_setFrameShape';
function QFrame_frameShadow(handle: QFrameH): QFrameShadow; cdecl; external Qt4PasLib name 'QFrame_frameShadow';
procedure QFrame_setFrameShadow(handle: QFrameH; p1: QFrameShadow); cdecl; external Qt4PasLib name 'QFrame_setFrameShadow';
function QFrame_lineWidth(handle: QFrameH): Integer; cdecl; external Qt4PasLib name 'QFrame_lineWidth';
procedure QFrame_setLineWidth(handle: QFrameH; p1: Integer); cdecl; external Qt4PasLib name 'QFrame_setLineWidth';
function QFrame_midLineWidth(handle: QFrameH): Integer; cdecl; external Qt4PasLib name 'QFrame_midLineWidth';
procedure QFrame_setMidLineWidth(handle: QFrameH; p1: Integer); cdecl; external Qt4PasLib name 'QFrame_setMidLineWidth';
procedure QFrame_frameRect(handle: QFrameH; retval: PRect); cdecl; external Qt4PasLib name 'QFrame_frameRect';
procedure QFrame_setFrameRect(handle: QFrameH; p1: PRect); cdecl; external Qt4PasLib name 'QFrame_setFrameRect';

function QStackedWidget_create(parent: QWidgetH = nil): QStackedWidgetH; cdecl; external Qt4PasLib name 'QStackedWidget_create';
procedure QStackedWidget_destroy(handle: QStackedWidgetH); cdecl; external Qt4PasLib name 'QStackedWidget_destroy'; 
function QStackedWidget_addWidget(handle: QStackedWidgetH; w: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QStackedWidget_addWidget';
function QStackedWidget_insertWidget(handle: QStackedWidgetH; index: Integer; w: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QStackedWidget_insertWidget';
procedure QStackedWidget_removeWidget(handle: QStackedWidgetH; w: QWidgetH); cdecl; external Qt4PasLib name 'QStackedWidget_removeWidget';
function QStackedWidget_currentWidget(handle: QStackedWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QStackedWidget_currentWidget';
function QStackedWidget_currentIndex(handle: QStackedWidgetH): Integer; cdecl; external Qt4PasLib name 'QStackedWidget_currentIndex';
function QStackedWidget_indexOf(handle: QStackedWidgetH; p1: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QStackedWidget_indexOf';
function QStackedWidget_widget(handle: QStackedWidgetH; p1: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QStackedWidget_widget';
function QStackedWidget_count(handle: QStackedWidgetH): Integer; cdecl; external Qt4PasLib name 'QStackedWidget_count';
procedure QStackedWidget_setCurrentIndex(handle: QStackedWidgetH; index: Integer); cdecl; external Qt4PasLib name 'QStackedWidget_setCurrentIndex';
procedure QStackedWidget_setCurrentWidget(handle: QStackedWidgetH; w: QWidgetH); cdecl; external Qt4PasLib name 'QStackedWidget_setCurrentWidget';


type
  QStackedWidget_currentChanged_Event = procedure (p1: Integer) of object cdecl;
  QStackedWidget_widgetRemoved_Event = procedure (index: Integer) of object cdecl;


function QAbstractScrollArea_create(parent: QWidgetH = nil): QAbstractScrollAreaH; cdecl; external Qt4PasLib name 'QAbstractScrollArea_create';
procedure QAbstractScrollArea_destroy(handle: QAbstractScrollAreaH); cdecl; external Qt4PasLib name 'QAbstractScrollArea_destroy'; 
function QAbstractScrollArea_verticalScrollBarPolicy(handle: QAbstractScrollAreaH): QtScrollBarPolicy; cdecl; external Qt4PasLib name 'QAbstractScrollArea_verticalScrollBarPolicy';
procedure QAbstractScrollArea_setVerticalScrollBarPolicy(handle: QAbstractScrollAreaH; p1: QtScrollBarPolicy); cdecl; external Qt4PasLib name 'QAbstractScrollArea_setVerticalScrollBarPolicy';
function QAbstractScrollArea_verticalScrollBar(handle: QAbstractScrollAreaH): QScrollBarH; cdecl; external Qt4PasLib name 'QAbstractScrollArea_verticalScrollBar';
procedure QAbstractScrollArea_setVerticalScrollBar(handle: QAbstractScrollAreaH; scrollbar: QScrollBarH); cdecl; external Qt4PasLib name 'QAbstractScrollArea_setVerticalScrollBar';
function QAbstractScrollArea_horizontalScrollBarPolicy(handle: QAbstractScrollAreaH): QtScrollBarPolicy; cdecl; external Qt4PasLib name 'QAbstractScrollArea_horizontalScrollBarPolicy';
procedure QAbstractScrollArea_setHorizontalScrollBarPolicy(handle: QAbstractScrollAreaH; p1: QtScrollBarPolicy); cdecl; external Qt4PasLib name 'QAbstractScrollArea_setHorizontalScrollBarPolicy';
function QAbstractScrollArea_horizontalScrollBar(handle: QAbstractScrollAreaH): QScrollBarH; cdecl; external Qt4PasLib name 'QAbstractScrollArea_horizontalScrollBar';
procedure QAbstractScrollArea_setHorizontalScrollBar(handle: QAbstractScrollAreaH; scrollbar: QScrollBarH); cdecl; external Qt4PasLib name 'QAbstractScrollArea_setHorizontalScrollBar';
function QAbstractScrollArea_cornerWidget(handle: QAbstractScrollAreaH): QWidgetH; cdecl; external Qt4PasLib name 'QAbstractScrollArea_cornerWidget';
procedure QAbstractScrollArea_setCornerWidget(handle: QAbstractScrollAreaH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QAbstractScrollArea_setCornerWidget';
procedure QAbstractScrollArea_addScrollBarWidget(handle: QAbstractScrollAreaH; widget: QWidgetH; alignment: QtAlignment); cdecl; external Qt4PasLib name 'QAbstractScrollArea_addScrollBarWidget';
procedure QAbstractScrollArea_scrollBarWidgets(handle: QAbstractScrollAreaH; retval: PPtrIntArray; alignment: QtAlignment); cdecl; external Qt4PasLib name 'QAbstractScrollArea_scrollBarWidgets';
function QAbstractScrollArea_viewport(handle: QAbstractScrollAreaH): QWidgetH; cdecl; external Qt4PasLib name 'QAbstractScrollArea_viewport';
procedure QAbstractScrollArea_setViewport(handle: QAbstractScrollAreaH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QAbstractScrollArea_setViewport';
procedure QAbstractScrollArea_maximumViewportSize(handle: QAbstractScrollAreaH; retval: PSize); cdecl; external Qt4PasLib name 'QAbstractScrollArea_maximumViewportSize';
procedure QAbstractScrollArea_minimumSizeHint(handle: QAbstractScrollAreaH; retval: PSize); cdecl; external Qt4PasLib name 'QAbstractScrollArea_minimumSizeHint';
procedure QAbstractScrollArea_sizeHint(handle: QAbstractScrollAreaH; retval: PSize); cdecl; external Qt4PasLib name 'QAbstractScrollArea_sizeHint';

function QLCLAbstractScrollArea_create(parent: QWidgetH = nil): QLCLAbstractScrollAreaH; cdecl; external Qt4PasLib name 'QLCLAbstractScrollArea_create';
procedure QLCLAbstractScrollArea_destroy(handle: QLCLAbstractScrollAreaH); cdecl; external Qt4PasLib name 'QLCLAbstractScrollArea_destroy'; 
procedure QLCLAbstractScrollArea_override_viewportEvent(handle: QLCLAbstractScrollAreaH; hook: QLCLAbstractScrollArea_viewportEvent_Override); cdecl; external Qt4PasLib name 'QLCLAbstractScrollArea_override_viewportEvent';
function QLCLAbstractScrollArea_InheritedViewportEvent(handle: QLCLAbstractScrollAreaH; event: QEventH): Boolean; cdecl; external Qt4PasLib name 'QLCLAbstractScrollArea_InheritedViewportEvent';


type
  QAbstractSliderSliderAction = ( // QAbstractSlider::SliderAction (1)
    QAbstractSliderSliderNoAction, QAbstractSliderSliderSingleStepAdd, QAbstractSliderSliderSingleStepSub, QAbstractSliderSliderPageStepAdd, QAbstractSliderSliderPageStepSub, QAbstractSliderSliderToMinimum, 
    QAbstractSliderSliderToMaximum, QAbstractSliderSliderMove );

function QAbstractSlider_create(parent: QWidgetH = nil): QAbstractSliderH; cdecl; external Qt4PasLib name 'QAbstractSlider_create';
procedure QAbstractSlider_destroy(handle: QAbstractSliderH); cdecl; external Qt4PasLib name 'QAbstractSlider_destroy'; 
function QAbstractSlider_orientation(handle: QAbstractSliderH): QtOrientation; cdecl; external Qt4PasLib name 'QAbstractSlider_orientation';
procedure QAbstractSlider_setMinimum(handle: QAbstractSliderH; p1: Integer); cdecl; external Qt4PasLib name 'QAbstractSlider_setMinimum';
function QAbstractSlider_minimum(handle: QAbstractSliderH): Integer; cdecl; external Qt4PasLib name 'QAbstractSlider_minimum';
procedure QAbstractSlider_setMaximum(handle: QAbstractSliderH; p1: Integer); cdecl; external Qt4PasLib name 'QAbstractSlider_setMaximum';
function QAbstractSlider_maximum(handle: QAbstractSliderH): Integer; cdecl; external Qt4PasLib name 'QAbstractSlider_maximum';
procedure QAbstractSlider_setRange(handle: QAbstractSliderH; min: Integer; max: Integer); cdecl; external Qt4PasLib name 'QAbstractSlider_setRange';
procedure QAbstractSlider_setSingleStep(handle: QAbstractSliderH; p1: Integer); cdecl; external Qt4PasLib name 'QAbstractSlider_setSingleStep';
function QAbstractSlider_singleStep(handle: QAbstractSliderH): Integer; cdecl; external Qt4PasLib name 'QAbstractSlider_singleStep';
procedure QAbstractSlider_setPageStep(handle: QAbstractSliderH; p1: Integer); cdecl; external Qt4PasLib name 'QAbstractSlider_setPageStep';
function QAbstractSlider_pageStep(handle: QAbstractSliderH): Integer; cdecl; external Qt4PasLib name 'QAbstractSlider_pageStep';
procedure QAbstractSlider_setTracking(handle: QAbstractSliderH; enable: Boolean); cdecl; external Qt4PasLib name 'QAbstractSlider_setTracking';
function QAbstractSlider_hasTracking(handle: QAbstractSliderH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSlider_hasTracking';
procedure QAbstractSlider_setSliderDown(handle: QAbstractSliderH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractSlider_setSliderDown';
function QAbstractSlider_isSliderDown(handle: QAbstractSliderH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSlider_isSliderDown';
procedure QAbstractSlider_setSliderPosition(handle: QAbstractSliderH; p1: Integer); cdecl; external Qt4PasLib name 'QAbstractSlider_setSliderPosition';
function QAbstractSlider_sliderPosition(handle: QAbstractSliderH): Integer; cdecl; external Qt4PasLib name 'QAbstractSlider_sliderPosition';
procedure QAbstractSlider_setInvertedAppearance(handle: QAbstractSliderH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractSlider_setInvertedAppearance';
function QAbstractSlider_invertedAppearance(handle: QAbstractSliderH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSlider_invertedAppearance';
procedure QAbstractSlider_setInvertedControls(handle: QAbstractSliderH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractSlider_setInvertedControls';
function QAbstractSlider_invertedControls(handle: QAbstractSliderH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSlider_invertedControls';
function QAbstractSlider_value(handle: QAbstractSliderH): Integer; cdecl; external Qt4PasLib name 'QAbstractSlider_value';
procedure QAbstractSlider_triggerAction(handle: QAbstractSliderH; action: QAbstractSliderSliderAction); cdecl; external Qt4PasLib name 'QAbstractSlider_triggerAction';
procedure QAbstractSlider_setValue(handle: QAbstractSliderH; p1: Integer); cdecl; external Qt4PasLib name 'QAbstractSlider_setValue';
procedure QAbstractSlider_setOrientation(handle: QAbstractSliderH; p1: QtOrientation); cdecl; external Qt4PasLib name 'QAbstractSlider_setOrientation';


type
  QAbstractSlider_valueChanged_Event = procedure (value: Integer) of object cdecl;
  QAbstractSlider_sliderPressed_Event = procedure () of object cdecl;
  QAbstractSlider_sliderMoved_Event = procedure (position: Integer) of object cdecl;
  QAbstractSlider_sliderReleased_Event = procedure () of object cdecl;
  QAbstractSlider_rangeChanged_Event = procedure (min: Integer; max: Integer) of object cdecl;
  QAbstractSlider_actionTriggered_Event = procedure (action: Integer) of object cdecl;


function QScrollBar_create(parent: QWidgetH = nil): QScrollBarH; cdecl; external Qt4PasLib name 'QScrollBar_create';
procedure QScrollBar_destroy(handle: QScrollBarH); cdecl; external Qt4PasLib name 'QScrollBar_destroy'; 
function QScrollBar_create(p1: QtOrientation; parent: QWidgetH = nil): QScrollBarH; cdecl; external Qt4PasLib name 'QScrollBar_create2';
procedure QScrollBar_sizeHint(handle: QScrollBarH; retval: PSize); cdecl; external Qt4PasLib name 'QScrollBar_sizeHint';
function QScrollBar_event(handle: QScrollBarH; event: QEventH): Boolean; cdecl; external Qt4PasLib name 'QScrollBar_event';

function QMenu_create(parent: QWidgetH = nil): QMenuH; cdecl; external Qt4PasLib name 'QMenu_create';
procedure QMenu_destroy(handle: QMenuH); cdecl; external Qt4PasLib name 'QMenu_destroy'; 
function QMenu_create(title: PWideString; parent: QWidgetH = nil): QMenuH; cdecl; external Qt4PasLib name 'QMenu_create2';
function QMenu_addAction(handle: QMenuH; text: PWideString): QActionH; cdecl; external Qt4PasLib name 'QMenu_addAction';
function QMenu_addAction(handle: QMenuH; icon: QIconH; text: PWideString): QActionH; cdecl; external Qt4PasLib name 'QMenu_addAction2';
function QMenu_addAction(handle: QMenuH; text: PWideString; receiver: QObjectH; member: PAnsiChar; shortcut: QKeySequenceH = nil): QActionH; cdecl; external Qt4PasLib name 'QMenu_addAction3';
function QMenu_addAction(handle: QMenuH; icon: QIconH; text: PWideString; receiver: QObjectH; member: PAnsiChar; shortcut: QKeySequenceH = nil): QActionH; cdecl; external Qt4PasLib name 'QMenu_addAction4';
function QMenu_addMenu(handle: QMenuH; menu: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenu_addMenu';
function QMenu_addMenu(handle: QMenuH; title: PWideString): QMenuH; cdecl; external Qt4PasLib name 'QMenu_addMenu2';
function QMenu_addMenu(handle: QMenuH; icon: QIconH; title: PWideString): QMenuH; cdecl; external Qt4PasLib name 'QMenu_addMenu3';
function QMenu_addSeparator(handle: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenu_addSeparator';
function QMenu_insertMenu(handle: QMenuH; before: QActionH; menu: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenu_insertMenu';
function QMenu_insertSeparator(handle: QMenuH; before: QActionH): QActionH; cdecl; external Qt4PasLib name 'QMenu_insertSeparator';
function QMenu_isEmpty(handle: QMenuH): Boolean; cdecl; external Qt4PasLib name 'QMenu_isEmpty';
procedure QMenu_clear(handle: QMenuH); cdecl; external Qt4PasLib name 'QMenu_clear';
procedure QMenu_setTearOffEnabled(handle: QMenuH; p1: Boolean); cdecl; external Qt4PasLib name 'QMenu_setTearOffEnabled';
function QMenu_isTearOffEnabled(handle: QMenuH): Boolean; cdecl; external Qt4PasLib name 'QMenu_isTearOffEnabled';
function QMenu_isTearOffMenuVisible(handle: QMenuH): Boolean; cdecl; external Qt4PasLib name 'QMenu_isTearOffMenuVisible';
procedure QMenu_hideTearOffMenu(handle: QMenuH); cdecl; external Qt4PasLib name 'QMenu_hideTearOffMenu';
procedure QMenu_setDefaultAction(handle: QMenuH; p1: QActionH); cdecl; external Qt4PasLib name 'QMenu_setDefaultAction';
function QMenu_defaultAction(handle: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenu_defaultAction';
procedure QMenu_setActiveAction(handle: QMenuH; act: QActionH); cdecl; external Qt4PasLib name 'QMenu_setActiveAction';
function QMenu_activeAction(handle: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenu_activeAction';
procedure QMenu_popup(handle: QMenuH; pos: PQtPoint; at: QActionH = nil); cdecl; external Qt4PasLib name 'QMenu_popup';
function QMenu_exec(handle: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenu_exec';
function QMenu_exec(handle: QMenuH; pos: PQtPoint; at: QActionH = nil): QActionH; cdecl; external Qt4PasLib name 'QMenu_exec2';
function QMenu_exec(actions: PPtrIntArray; pos: PQtPoint; at: QActionH = nil): QActionH; cdecl; external Qt4PasLib name 'QMenu_exec3';
function QMenu_exec(actions: PPtrIntArray; pos: PQtPoint; at: QActionH; parent: QWidgetH): QActionH; cdecl; external Qt4PasLib name 'QMenu_exec4';
procedure QMenu_sizeHint(handle: QMenuH; retval: PSize); cdecl; external Qt4PasLib name 'QMenu_sizeHint';
procedure QMenu_actionGeometry(handle: QMenuH; retval: PRect; p1: QActionH); cdecl; external Qt4PasLib name 'QMenu_actionGeometry';
function QMenu_actionAt(handle: QMenuH; p1: PQtPoint): QActionH; cdecl; external Qt4PasLib name 'QMenu_actionAt';
function QMenu_menuAction(handle: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenu_menuAction';
procedure QMenu_title(handle: QMenuH; retval: PWideString); cdecl; external Qt4PasLib name 'QMenu_title';
procedure QMenu_setTitle(handle: QMenuH; title: PWideString); cdecl; external Qt4PasLib name 'QMenu_setTitle';
procedure QMenu_icon(handle: QMenuH; retval: QIconH); cdecl; external Qt4PasLib name 'QMenu_icon';
procedure QMenu_setIcon(handle: QMenuH; icon: QIconH); cdecl; external Qt4PasLib name 'QMenu_setIcon';
procedure QMenu_setNoReplayFor(handle: QMenuH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QMenu_setNoReplayFor';
function QMenu_separatorsCollapsible(handle: QMenuH): Boolean; cdecl; external Qt4PasLib name 'QMenu_separatorsCollapsible';
procedure QMenu_setSeparatorsCollapsible(handle: QMenuH; collapse: Boolean); cdecl; external Qt4PasLib name 'QMenu_setSeparatorsCollapsible';
{$ifdef DARWIN }
function QMenu_macMenu(handle: QMenuH; merge: Pointer = nil): Pointer; cdecl; external Qt4PasLib name 'QMenu_macMenu';
{$endif}


type
  QMenu_aboutToShow_Event = procedure () of object cdecl;
  QMenu_aboutToHide_Event = procedure () of object cdecl;
  QMenu_triggered_Event = procedure (action: QActionH) of object cdecl;
  QMenu_hovered_Event = procedure (action: QActionH) of object cdecl;


function QMenuBar_create(parent: QWidgetH = nil): QMenuBarH; cdecl; external Qt4PasLib name 'QMenuBar_create';
procedure QMenuBar_destroy(handle: QMenuBarH); cdecl; external Qt4PasLib name 'QMenuBar_destroy'; 
function QMenuBar_addAction(handle: QMenuBarH; text: PWideString): QActionH; cdecl; external Qt4PasLib name 'QMenuBar_addAction';
function QMenuBar_addAction(handle: QMenuBarH; text: PWideString; receiver: QObjectH; member: PAnsiChar): QActionH; cdecl; external Qt4PasLib name 'QMenuBar_addAction2';
function QMenuBar_addMenu(handle: QMenuBarH; menu: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenuBar_addMenu';
function QMenuBar_addMenu(handle: QMenuBarH; title: PWideString): QMenuH; cdecl; external Qt4PasLib name 'QMenuBar_addMenu2';
function QMenuBar_addMenu(handle: QMenuBarH; icon: QIconH; title: PWideString): QMenuH; cdecl; external Qt4PasLib name 'QMenuBar_addMenu3';
function QMenuBar_addSeparator(handle: QMenuBarH): QActionH; cdecl; external Qt4PasLib name 'QMenuBar_addSeparator';
function QMenuBar_insertSeparator(handle: QMenuBarH; before: QActionH): QActionH; cdecl; external Qt4PasLib name 'QMenuBar_insertSeparator';
function QMenuBar_insertMenu(handle: QMenuBarH; before: QActionH; menu: QMenuH): QActionH; cdecl; external Qt4PasLib name 'QMenuBar_insertMenu';
procedure QMenuBar_clear(handle: QMenuBarH); cdecl; external Qt4PasLib name 'QMenuBar_clear';
function QMenuBar_activeAction(handle: QMenuBarH): QActionH; cdecl; external Qt4PasLib name 'QMenuBar_activeAction';
procedure QMenuBar_setActiveAction(handle: QMenuBarH; action: QActionH); cdecl; external Qt4PasLib name 'QMenuBar_setActiveAction';
procedure QMenuBar_setDefaultUp(handle: QMenuBarH; p1: Boolean); cdecl; external Qt4PasLib name 'QMenuBar_setDefaultUp';
function QMenuBar_isDefaultUp(handle: QMenuBarH): Boolean; cdecl; external Qt4PasLib name 'QMenuBar_isDefaultUp';
procedure QMenuBar_sizeHint(handle: QMenuBarH; retval: PSize); cdecl; external Qt4PasLib name 'QMenuBar_sizeHint';
procedure QMenuBar_minimumSizeHint(handle: QMenuBarH; retval: PSize); cdecl; external Qt4PasLib name 'QMenuBar_minimumSizeHint';
function QMenuBar_heightForWidth(handle: QMenuBarH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QMenuBar_heightForWidth';
procedure QMenuBar_actionGeometry(handle: QMenuBarH; retval: PRect; p1: QActionH); cdecl; external Qt4PasLib name 'QMenuBar_actionGeometry';
function QMenuBar_actionAt(handle: QMenuBarH; p1: PQtPoint): QActionH; cdecl; external Qt4PasLib name 'QMenuBar_actionAt';
procedure QMenuBar_setCornerWidget(handle: QMenuBarH; w: QWidgetH; corner: QtCorner = QtTopRightCorner); cdecl; external Qt4PasLib name 'QMenuBar_setCornerWidget';
function QMenuBar_cornerWidget(handle: QMenuBarH; corner: QtCorner = QtTopRightCorner): QWidgetH; cdecl; external Qt4PasLib name 'QMenuBar_cornerWidget';
procedure QMenuBar_setVisible(handle: QMenuBarH; visible: Boolean); cdecl; external Qt4PasLib name 'QMenuBar_setVisible';
{$ifdef DARWIN }
function QMenuBar_macMenu(handle: QMenuBarH): Pointer; cdecl; external Qt4PasLib name 'QMenuBar_macMenu';
function QMenuBar_macUpdateMenuBar(): Boolean; cdecl; external Qt4PasLib name 'QMenuBar_macUpdateMenuBar';
{$endif}


type
  QMenuBar_triggered_Event = procedure (action: QActionH) of object cdecl;
  QMenuBar_hovered_Event = procedure (action: QActionH) of object cdecl;


function QButtonGroup_create(parent: QObjectH = nil): QButtonGroupH; cdecl; external Qt4PasLib name 'QButtonGroup_create';
procedure QButtonGroup_destroy(handle: QButtonGroupH); cdecl; external Qt4PasLib name 'QButtonGroup_destroy'; 
procedure QButtonGroup_setExclusive(handle: QButtonGroupH; p1: Boolean); cdecl; external Qt4PasLib name 'QButtonGroup_setExclusive';
function QButtonGroup_exclusive(handle: QButtonGroupH): Boolean; cdecl; external Qt4PasLib name 'QButtonGroup_exclusive';
procedure QButtonGroup_addButton(handle: QButtonGroupH; p1: QAbstractButtonH); cdecl; external Qt4PasLib name 'QButtonGroup_addButton';
procedure QButtonGroup_addButton(handle: QButtonGroupH; p1: QAbstractButtonH; id: Integer); cdecl; external Qt4PasLib name 'QButtonGroup_addButton2';
procedure QButtonGroup_removeButton(handle: QButtonGroupH; p1: QAbstractButtonH); cdecl; external Qt4PasLib name 'QButtonGroup_removeButton';
procedure QButtonGroup_buttons(handle: QButtonGroupH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QButtonGroup_buttons';
function QButtonGroup_checkedButton(handle: QButtonGroupH): QAbstractButtonH; cdecl; external Qt4PasLib name 'QButtonGroup_checkedButton';
function QButtonGroup_button(handle: QButtonGroupH; id: Integer): QAbstractButtonH; cdecl; external Qt4PasLib name 'QButtonGroup_button';
procedure QButtonGroup_setId(handle: QButtonGroupH; button: QAbstractButtonH; id: Integer); cdecl; external Qt4PasLib name 'QButtonGroup_setId';
function QButtonGroup_id(handle: QButtonGroupH; button: QAbstractButtonH): Integer; cdecl; external Qt4PasLib name 'QButtonGroup_id';
function QButtonGroup_checkedId(handle: QButtonGroupH): Integer; cdecl; external Qt4PasLib name 'QButtonGroup_checkedId';


type
  QButtonGroup_buttonClicked_Event = procedure (p1: QAbstractButtonH) of object cdecl;
  QButtonGroup_buttonClicked2_Event = procedure (p1: Integer) of object cdecl;
  QButtonGroup_buttonPressed_Event = procedure (p1: QAbstractButtonH) of object cdecl;
  QButtonGroup_buttonPressed2_Event = procedure (p1: Integer) of object cdecl;
  QButtonGroup_buttonReleased_Event = procedure (p1: QAbstractButtonH) of object cdecl;
  QButtonGroup_buttonReleased2_Event = procedure (p1: Integer) of object cdecl;


procedure QAbstractButton_setText(handle: QAbstractButtonH; text: PWideString); cdecl; external Qt4PasLib name 'QAbstractButton_setText';
procedure QAbstractButton_text(handle: QAbstractButtonH; retval: PWideString); cdecl; external Qt4PasLib name 'QAbstractButton_text';
procedure QAbstractButton_setIcon(handle: QAbstractButtonH; icon: QIconH); cdecl; external Qt4PasLib name 'QAbstractButton_setIcon';
procedure QAbstractButton_icon(handle: QAbstractButtonH; retval: QIconH); cdecl; external Qt4PasLib name 'QAbstractButton_icon';
procedure QAbstractButton_iconSize(handle: QAbstractButtonH; retval: PSize); cdecl; external Qt4PasLib name 'QAbstractButton_iconSize';
procedure QAbstractButton_setShortcut(handle: QAbstractButtonH; key: QKeySequenceH); cdecl; external Qt4PasLib name 'QAbstractButton_setShortcut';
procedure QAbstractButton_shortcut(handle: QAbstractButtonH; retval: QKeySequenceH); cdecl; external Qt4PasLib name 'QAbstractButton_shortcut';
procedure QAbstractButton_setCheckable(handle: QAbstractButtonH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractButton_setCheckable';
function QAbstractButton_isCheckable(handle: QAbstractButtonH): Boolean; cdecl; external Qt4PasLib name 'QAbstractButton_isCheckable';
function QAbstractButton_isChecked(handle: QAbstractButtonH): Boolean; cdecl; external Qt4PasLib name 'QAbstractButton_isChecked';
procedure QAbstractButton_setDown(handle: QAbstractButtonH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractButton_setDown';
function QAbstractButton_isDown(handle: QAbstractButtonH): Boolean; cdecl; external Qt4PasLib name 'QAbstractButton_isDown';
procedure QAbstractButton_setAutoRepeat(handle: QAbstractButtonH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractButton_setAutoRepeat';
function QAbstractButton_autoRepeat(handle: QAbstractButtonH): Boolean; cdecl; external Qt4PasLib name 'QAbstractButton_autoRepeat';
procedure QAbstractButton_setAutoRepeatDelay(handle: QAbstractButtonH; p1: Integer); cdecl; external Qt4PasLib name 'QAbstractButton_setAutoRepeatDelay';
function QAbstractButton_autoRepeatDelay(handle: QAbstractButtonH): Integer; cdecl; external Qt4PasLib name 'QAbstractButton_autoRepeatDelay';
procedure QAbstractButton_setAutoRepeatInterval(handle: QAbstractButtonH; p1: Integer); cdecl; external Qt4PasLib name 'QAbstractButton_setAutoRepeatInterval';
function QAbstractButton_autoRepeatInterval(handle: QAbstractButtonH): Integer; cdecl; external Qt4PasLib name 'QAbstractButton_autoRepeatInterval';
procedure QAbstractButton_setAutoExclusive(handle: QAbstractButtonH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractButton_setAutoExclusive';
function QAbstractButton_autoExclusive(handle: QAbstractButtonH): Boolean; cdecl; external Qt4PasLib name 'QAbstractButton_autoExclusive';
function QAbstractButton_group(handle: QAbstractButtonH): QButtonGroupH; cdecl; external Qt4PasLib name 'QAbstractButton_group';
procedure QAbstractButton_setIconSize(handle: QAbstractButtonH; size: PSize); cdecl; external Qt4PasLib name 'QAbstractButton_setIconSize';
procedure QAbstractButton_animateClick(handle: QAbstractButtonH; msec: Integer = 100); cdecl; external Qt4PasLib name 'QAbstractButton_animateClick';
procedure QAbstractButton_click(handle: QAbstractButtonH); cdecl; external Qt4PasLib name 'QAbstractButton_click';
procedure QAbstractButton_toggle(handle: QAbstractButtonH); cdecl; external Qt4PasLib name 'QAbstractButton_toggle';
procedure QAbstractButton_setChecked(handle: QAbstractButtonH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractButton_setChecked';


type
  QAbstractButton_pressed_Event = procedure () of object cdecl;
  QAbstractButton_released_Event = procedure () of object cdecl;
  QAbstractButton_clicked_Event = procedure (checked: Boolean = False) of object cdecl;
  QAbstractButton_clicked2_Event = procedure () of object cdecl;
  QAbstractButton_toggled_Event = procedure (checked: Boolean) of object cdecl;


function QPushButton_create(parent: QWidgetH = nil): QPushButtonH; cdecl; external Qt4PasLib name 'QPushButton_create';
procedure QPushButton_destroy(handle: QPushButtonH); cdecl; external Qt4PasLib name 'QPushButton_destroy'; 
function QPushButton_create(text: PWideString; parent: QWidgetH = nil): QPushButtonH; cdecl; external Qt4PasLib name 'QPushButton_create2';
function QPushButton_create(icon: QIconH; text: PWideString; parent: QWidgetH = nil): QPushButtonH; cdecl; external Qt4PasLib name 'QPushButton_create3';
procedure QPushButton_sizeHint(handle: QPushButtonH; retval: PSize); cdecl; external Qt4PasLib name 'QPushButton_sizeHint';
procedure QPushButton_minimumSizeHint(handle: QPushButtonH; retval: PSize); cdecl; external Qt4PasLib name 'QPushButton_minimumSizeHint';
function QPushButton_autoDefault(handle: QPushButtonH): Boolean; cdecl; external Qt4PasLib name 'QPushButton_autoDefault';
procedure QPushButton_setAutoDefault(handle: QPushButtonH; p1: Boolean); cdecl; external Qt4PasLib name 'QPushButton_setAutoDefault';
function QPushButton_isDefault(handle: QPushButtonH): Boolean; cdecl; external Qt4PasLib name 'QPushButton_isDefault';
procedure QPushButton_setDefault(handle: QPushButtonH; p1: Boolean); cdecl; external Qt4PasLib name 'QPushButton_setDefault';
procedure QPushButton_setMenu(handle: QPushButtonH; menu: QMenuH); cdecl; external Qt4PasLib name 'QPushButton_setMenu';
function QPushButton_menu(handle: QPushButtonH): QMenuH; cdecl; external Qt4PasLib name 'QPushButton_menu';
procedure QPushButton_setFlat(handle: QPushButtonH; p1: Boolean); cdecl; external Qt4PasLib name 'QPushButton_setFlat';
function QPushButton_isFlat(handle: QPushButtonH): Boolean; cdecl; external Qt4PasLib name 'QPushButton_isFlat';
procedure QPushButton_showMenu(handle: QPushButtonH); cdecl; external Qt4PasLib name 'QPushButton_showMenu';

function QRadioButton_create(parent: QWidgetH = nil): QRadioButtonH; cdecl; external Qt4PasLib name 'QRadioButton_create';
procedure QRadioButton_destroy(handle: QRadioButtonH); cdecl; external Qt4PasLib name 'QRadioButton_destroy'; 
function QRadioButton_create(text: PWideString; parent: QWidgetH = nil): QRadioButtonH; cdecl; external Qt4PasLib name 'QRadioButton_create2';
procedure QRadioButton_sizeHint(handle: QRadioButtonH; retval: PSize); cdecl; external Qt4PasLib name 'QRadioButton_sizeHint';


type
  QLineEditEchoMode = ( // QLineEdit::EchoMode (1)
    QLineEditNormal, QLineEditNoEcho, QLineEditPassword, QLineEditPasswordEchoOnEdit );

function QLineEdit_create(parent: QWidgetH = nil): QLineEditH; cdecl; external Qt4PasLib name 'QLineEdit_create';
procedure QLineEdit_destroy(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_destroy'; 
function QLineEdit_create(p1: PWideString; parent: QWidgetH = nil): QLineEditH; cdecl; external Qt4PasLib name 'QLineEdit_create2';
procedure QLineEdit_text(handle: QLineEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QLineEdit_text';
procedure QLineEdit_displayText(handle: QLineEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QLineEdit_displayText';
function QLineEdit_maxLength(handle: QLineEditH): Integer; cdecl; external Qt4PasLib name 'QLineEdit_maxLength';
procedure QLineEdit_setMaxLength(handle: QLineEditH; p1: Integer); cdecl; external Qt4PasLib name 'QLineEdit_setMaxLength';
procedure QLineEdit_setFrame(handle: QLineEditH; p1: Boolean); cdecl; external Qt4PasLib name 'QLineEdit_setFrame';
function QLineEdit_hasFrame(handle: QLineEditH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_hasFrame';
function QLineEdit_echoMode(handle: QLineEditH): QLineEditEchoMode; cdecl; external Qt4PasLib name 'QLineEdit_echoMode';
procedure QLineEdit_setEchoMode(handle: QLineEditH; p1: QLineEditEchoMode); cdecl; external Qt4PasLib name 'QLineEdit_setEchoMode';
function QLineEdit_isReadOnly(handle: QLineEditH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_isReadOnly';
procedure QLineEdit_setReadOnly(handle: QLineEditH; p1: Boolean); cdecl; external Qt4PasLib name 'QLineEdit_setReadOnly';
procedure QLineEdit_setValidator(handle: QLineEditH; p1: QValidatorH); cdecl; external Qt4PasLib name 'QLineEdit_setValidator';
function QLineEdit_validator(handle: QLineEditH): QValidatorH; cdecl; external Qt4PasLib name 'QLineEdit_validator';
procedure QLineEdit_setCompleter(handle: QLineEditH; completer: QCompleterH); cdecl; external Qt4PasLib name 'QLineEdit_setCompleter';
function QLineEdit_completer(handle: QLineEditH): QCompleterH; cdecl; external Qt4PasLib name 'QLineEdit_completer';
procedure QLineEdit_sizeHint(handle: QLineEditH; retval: PSize); cdecl; external Qt4PasLib name 'QLineEdit_sizeHint';
procedure QLineEdit_minimumSizeHint(handle: QLineEditH; retval: PSize); cdecl; external Qt4PasLib name 'QLineEdit_minimumSizeHint';
function QLineEdit_cursorPosition(handle: QLineEditH): Integer; cdecl; external Qt4PasLib name 'QLineEdit_cursorPosition';
procedure QLineEdit_setCursorPosition(handle: QLineEditH; p1: Integer); cdecl; external Qt4PasLib name 'QLineEdit_setCursorPosition';
function QLineEdit_cursorPositionAt(handle: QLineEditH; pos: PQtPoint): Integer; cdecl; external Qt4PasLib name 'QLineEdit_cursorPositionAt';
procedure QLineEdit_setAlignment(handle: QLineEditH; flag: QtAlignment); cdecl; external Qt4PasLib name 'QLineEdit_setAlignment';
function QLineEdit_alignment(handle: QLineEditH): QtAlignment; cdecl; external Qt4PasLib name 'QLineEdit_alignment';
procedure QLineEdit_cursorForward(handle: QLineEditH; mark: Boolean; steps: Integer = 1); cdecl; external Qt4PasLib name 'QLineEdit_cursorForward';
procedure QLineEdit_cursorBackward(handle: QLineEditH; mark: Boolean; steps: Integer = 1); cdecl; external Qt4PasLib name 'QLineEdit_cursorBackward';
procedure QLineEdit_cursorWordForward(handle: QLineEditH; mark: Boolean); cdecl; external Qt4PasLib name 'QLineEdit_cursorWordForward';
procedure QLineEdit_cursorWordBackward(handle: QLineEditH; mark: Boolean); cdecl; external Qt4PasLib name 'QLineEdit_cursorWordBackward';
procedure QLineEdit_backspace(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_backspace';
procedure QLineEdit_del(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_del';
procedure QLineEdit_home(handle: QLineEditH; mark: Boolean); cdecl; external Qt4PasLib name 'QLineEdit_home';
procedure QLineEdit_end(handle: QLineEditH; mark: Boolean); cdecl; external Qt4PasLib name 'QLineEdit_end';
function QLineEdit_isModified(handle: QLineEditH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_isModified';
procedure QLineEdit_setModified(handle: QLineEditH; p1: Boolean); cdecl; external Qt4PasLib name 'QLineEdit_setModified';
procedure QLineEdit_setSelection(handle: QLineEditH; p1: Integer; p2: Integer); cdecl; external Qt4PasLib name 'QLineEdit_setSelection';
function QLineEdit_hasSelectedText(handle: QLineEditH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_hasSelectedText';
procedure QLineEdit_selectedText(handle: QLineEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QLineEdit_selectedText';
function QLineEdit_selectionStart(handle: QLineEditH): Integer; cdecl; external Qt4PasLib name 'QLineEdit_selectionStart';
function QLineEdit_isUndoAvailable(handle: QLineEditH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_isUndoAvailable';
function QLineEdit_isRedoAvailable(handle: QLineEditH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_isRedoAvailable';
procedure QLineEdit_setDragEnabled(handle: QLineEditH; b: Boolean); cdecl; external Qt4PasLib name 'QLineEdit_setDragEnabled';
function QLineEdit_dragEnabled(handle: QLineEditH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_dragEnabled';
procedure QLineEdit_inputMask(handle: QLineEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QLineEdit_inputMask';
procedure QLineEdit_setInputMask(handle: QLineEditH; inputMask: PWideString); cdecl; external Qt4PasLib name 'QLineEdit_setInputMask';
function QLineEdit_hasAcceptableInput(handle: QLineEditH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_hasAcceptableInput';
procedure QLineEdit_setTextMargins(handle: QLineEditH; left: Integer; top: Integer; right: Integer; bottom: Integer); cdecl; external Qt4PasLib name 'QLineEdit_setTextMargins';
procedure QLineEdit_getTextMargins(handle: QLineEditH; left: PInteger; top: PInteger; right: PInteger; bottom: PInteger); cdecl; external Qt4PasLib name 'QLineEdit_getTextMargins';
procedure QLineEdit_setText(handle: QLineEditH; p1: PWideString); cdecl; external Qt4PasLib name 'QLineEdit_setText';
procedure QLineEdit_clear(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_clear';
procedure QLineEdit_selectAll(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_selectAll';
procedure QLineEdit_undo(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_undo';
procedure QLineEdit_redo(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_redo';
procedure QLineEdit_cut(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_cut';
procedure QLineEdit_copy(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_copy';
procedure QLineEdit_paste(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_paste';
procedure QLineEdit_deselect(handle: QLineEditH); cdecl; external Qt4PasLib name 'QLineEdit_deselect';
procedure QLineEdit_insert(handle: QLineEditH; p1: PWideString); cdecl; external Qt4PasLib name 'QLineEdit_insert';
function QLineEdit_createStandardContextMenu(handle: QLineEditH): QMenuH; cdecl; external Qt4PasLib name 'QLineEdit_createStandardContextMenu';
procedure QLineEdit_inputMethodQuery(handle: QLineEditH; retval: QVariantH; p1: QtInputMethodQuery); cdecl; external Qt4PasLib name 'QLineEdit_inputMethodQuery';
function QLineEdit_event(handle: QLineEditH; p1: QEventH): Boolean; cdecl; external Qt4PasLib name 'QLineEdit_event';


type
  QLineEdit_textChanged_Event = procedure (p1: PWideString) of object cdecl;
  QLineEdit_textEdited_Event = procedure (p1: PWideString) of object cdecl;
  QLineEdit_cursorPositionChanged_Event = procedure (p1: Integer; p2: Integer) of object cdecl;
  QLineEdit_returnPressed_Event = procedure () of object cdecl;
  QLineEdit_editingFinished_Event = procedure () of object cdecl;
  QLineEdit_selectionChanged_Event = procedure () of object cdecl;



type
  QPlainTextEditLineWrapMode = ( // QPlainTextEdit::LineWrapMode (1)
    QPlainTextEditNoWrap, QPlainTextEditWidgetWidth );

function QPlainTextEdit_create(parent: QWidgetH = nil): QPlainTextEditH; cdecl; external Qt4PasLib name 'QPlainTextEdit_create';
procedure QPlainTextEdit_destroy(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_destroy'; 
function QPlainTextEdit_create(text: PWideString; parent: QWidgetH = nil): QPlainTextEditH; cdecl; external Qt4PasLib name 'QPlainTextEdit_create2';
procedure QPlainTextEdit_setDocument(handle: QPlainTextEditH; document: QTextDocumentH); cdecl; external Qt4PasLib name 'QPlainTextEdit_setDocument';
function QPlainTextEdit_document(handle: QPlainTextEditH): QTextDocumentH; cdecl; external Qt4PasLib name 'QPlainTextEdit_document';
procedure QPlainTextEdit_setTextCursor(handle: QPlainTextEditH; cursor: QTextCursorH); cdecl; external Qt4PasLib name 'QPlainTextEdit_setTextCursor';
procedure QPlainTextEdit_textCursor(handle: QPlainTextEditH; retval: QTextCursorH); cdecl; external Qt4PasLib name 'QPlainTextEdit_textCursor';
function QPlainTextEdit_isReadOnly(handle: QPlainTextEditH): Boolean; cdecl; external Qt4PasLib name 'QPlainTextEdit_isReadOnly';
procedure QPlainTextEdit_setReadOnly(handle: QPlainTextEditH; ro: Boolean); cdecl; external Qt4PasLib name 'QPlainTextEdit_setReadOnly';
procedure QPlainTextEdit_setTextInteractionFlags(handle: QPlainTextEditH; flags: QtTextInteractionFlags); cdecl; external Qt4PasLib name 'QPlainTextEdit_setTextInteractionFlags';
function QPlainTextEdit_textInteractionFlags(handle: QPlainTextEditH): QtTextInteractionFlags; cdecl; external Qt4PasLib name 'QPlainTextEdit_textInteractionFlags';
procedure QPlainTextEdit_mergeCurrentCharFormat(handle: QPlainTextEditH; modifier: QTextCharFormatH); cdecl; external Qt4PasLib name 'QPlainTextEdit_mergeCurrentCharFormat';
procedure QPlainTextEdit_setCurrentCharFormat(handle: QPlainTextEditH; format: QTextCharFormatH); cdecl; external Qt4PasLib name 'QPlainTextEdit_setCurrentCharFormat';
procedure QPlainTextEdit_currentCharFormat(handle: QPlainTextEditH; retval: QTextCharFormatH); cdecl; external Qt4PasLib name 'QPlainTextEdit_currentCharFormat';
function QPlainTextEdit_tabChangesFocus(handle: QPlainTextEditH): Boolean; cdecl; external Qt4PasLib name 'QPlainTextEdit_tabChangesFocus';
procedure QPlainTextEdit_setTabChangesFocus(handle: QPlainTextEditH; b: Boolean); cdecl; external Qt4PasLib name 'QPlainTextEdit_setTabChangesFocus';
procedure QPlainTextEdit_setDocumentTitle(handle: QPlainTextEditH; title: PWideString); cdecl; external Qt4PasLib name 'QPlainTextEdit_setDocumentTitle';
procedure QPlainTextEdit_documentTitle(handle: QPlainTextEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QPlainTextEdit_documentTitle';
function QPlainTextEdit_isUndoRedoEnabled(handle: QPlainTextEditH): Boolean; cdecl; external Qt4PasLib name 'QPlainTextEdit_isUndoRedoEnabled';
procedure QPlainTextEdit_setUndoRedoEnabled(handle: QPlainTextEditH; enable: Boolean); cdecl; external Qt4PasLib name 'QPlainTextEdit_setUndoRedoEnabled';
procedure QPlainTextEdit_setMaximumBlockCount(handle: QPlainTextEditH; maximum: Integer); cdecl; external Qt4PasLib name 'QPlainTextEdit_setMaximumBlockCount';
function QPlainTextEdit_maximumBlockCount(handle: QPlainTextEditH): Integer; cdecl; external Qt4PasLib name 'QPlainTextEdit_maximumBlockCount';
function QPlainTextEdit_lineWrapMode(handle: QPlainTextEditH): QPlainTextEditLineWrapMode; cdecl; external Qt4PasLib name 'QPlainTextEdit_lineWrapMode';
procedure QPlainTextEdit_setLineWrapMode(handle: QPlainTextEditH; mode: QPlainTextEditLineWrapMode); cdecl; external Qt4PasLib name 'QPlainTextEdit_setLineWrapMode';
function QPlainTextEdit_wordWrapMode(handle: QPlainTextEditH): QTextOptionWrapMode; cdecl; external Qt4PasLib name 'QPlainTextEdit_wordWrapMode';
procedure QPlainTextEdit_setWordWrapMode(handle: QPlainTextEditH; policy: QTextOptionWrapMode); cdecl; external Qt4PasLib name 'QPlainTextEdit_setWordWrapMode';
procedure QPlainTextEdit_setBackgroundVisible(handle: QPlainTextEditH; visible: Boolean); cdecl; external Qt4PasLib name 'QPlainTextEdit_setBackgroundVisible';
function QPlainTextEdit_backgroundVisible(handle: QPlainTextEditH): Boolean; cdecl; external Qt4PasLib name 'QPlainTextEdit_backgroundVisible';
procedure QPlainTextEdit_setCenterOnScroll(handle: QPlainTextEditH; enabled: Boolean); cdecl; external Qt4PasLib name 'QPlainTextEdit_setCenterOnScroll';
function QPlainTextEdit_centerOnScroll(handle: QPlainTextEditH): Boolean; cdecl; external Qt4PasLib name 'QPlainTextEdit_centerOnScroll';
function QPlainTextEdit_find(handle: QPlainTextEditH; exp: PWideString; options: QTextDocumentFindFlags = 0): Boolean; cdecl; external Qt4PasLib name 'QPlainTextEdit_find';
procedure QPlainTextEdit_toPlainText(handle: QPlainTextEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QPlainTextEdit_toPlainText';
procedure QPlainTextEdit_ensureCursorVisible(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_ensureCursorVisible';
procedure QPlainTextEdit_loadResource(handle: QPlainTextEditH; retval: QVariantH; _type: Integer; name: QUrlH); cdecl; external Qt4PasLib name 'QPlainTextEdit_loadResource';
function QPlainTextEdit_createStandardContextMenu(handle: QPlainTextEditH): QMenuH; cdecl; external Qt4PasLib name 'QPlainTextEdit_createStandardContextMenu';
procedure QPlainTextEdit_cursorForPosition(handle: QPlainTextEditH; retval: QTextCursorH; pos: PQtPoint); cdecl; external Qt4PasLib name 'QPlainTextEdit_cursorForPosition';
procedure QPlainTextEdit_cursorRect(handle: QPlainTextEditH; retval: PRect; cursor: QTextCursorH); cdecl; external Qt4PasLib name 'QPlainTextEdit_cursorRect';
procedure QPlainTextEdit_cursorRect(handle: QPlainTextEditH; retval: PRect); cdecl; external Qt4PasLib name 'QPlainTextEdit_cursorRect2';
function QPlainTextEdit_overwriteMode(handle: QPlainTextEditH): Boolean; cdecl; external Qt4PasLib name 'QPlainTextEdit_overwriteMode';
procedure QPlainTextEdit_setOverwriteMode(handle: QPlainTextEditH; overwrite: Boolean); cdecl; external Qt4PasLib name 'QPlainTextEdit_setOverwriteMode';
function QPlainTextEdit_tabStopWidth(handle: QPlainTextEditH): Integer; cdecl; external Qt4PasLib name 'QPlainTextEdit_tabStopWidth';
procedure QPlainTextEdit_setTabStopWidth(handle: QPlainTextEditH; width: Integer); cdecl; external Qt4PasLib name 'QPlainTextEdit_setTabStopWidth';
function QPlainTextEdit_cursorWidth(handle: QPlainTextEditH): Integer; cdecl; external Qt4PasLib name 'QPlainTextEdit_cursorWidth';
procedure QPlainTextEdit_setCursorWidth(handle: QPlainTextEditH; width: Integer); cdecl; external Qt4PasLib name 'QPlainTextEdit_setCursorWidth';
procedure QPlainTextEdit_moveCursor(handle: QPlainTextEditH; operation: QTextCursorMoveOperation; mode: QTextCursorMoveMode = QTextCursorMoveAnchor); cdecl; external Qt4PasLib name 'QPlainTextEdit_moveCursor';
function QPlainTextEdit_canPaste(handle: QPlainTextEditH): Boolean; cdecl; external Qt4PasLib name 'QPlainTextEdit_canPaste';
procedure QPlainTextEdit_print(handle: QPlainTextEditH; printer: QPrinterH); cdecl; external Qt4PasLib name 'QPlainTextEdit_print';
function QPlainTextEdit_blockCount(handle: QPlainTextEditH): Integer; cdecl; external Qt4PasLib name 'QPlainTextEdit_blockCount';
procedure QPlainTextEdit_setPlainText(handle: QPlainTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QPlainTextEdit_setPlainText';
procedure QPlainTextEdit_cut(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_cut';
procedure QPlainTextEdit_copy(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_copy';
procedure QPlainTextEdit_paste(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_paste';
procedure QPlainTextEdit_undo(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_undo';
procedure QPlainTextEdit_redo(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_redo';
procedure QPlainTextEdit_clear(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_clear';
procedure QPlainTextEdit_selectAll(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_selectAll';
procedure QPlainTextEdit_insertPlainText(handle: QPlainTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QPlainTextEdit_insertPlainText';
procedure QPlainTextEdit_appendPlainText(handle: QPlainTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QPlainTextEdit_appendPlainText';
procedure QPlainTextEdit_appendHtml(handle: QPlainTextEditH; html: PWideString); cdecl; external Qt4PasLib name 'QPlainTextEdit_appendHtml';
procedure QPlainTextEdit_centerCursor(handle: QPlainTextEditH); cdecl; external Qt4PasLib name 'QPlainTextEdit_centerCursor';

function QPlainTextDocumentLayout_create(document: QTextDocumentH): QPlainTextDocumentLayoutH; cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_create';
procedure QPlainTextDocumentLayout_destroy(handle: QPlainTextDocumentLayoutH); cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_destroy'; 
function QPlainTextDocumentLayout_hitTest(handle: QPlainTextDocumentLayoutH; p1: PQtPointF; p2: QtHitTestAccuracy): Integer; cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_hitTest';
function QPlainTextDocumentLayout_pageCount(handle: QPlainTextDocumentLayoutH): Integer; cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_pageCount';
procedure QPlainTextDocumentLayout_documentSize(handle: QPlainTextDocumentLayoutH; retval: QSizeFH); cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_documentSize';
procedure QPlainTextDocumentLayout_frameBoundingRect(handle: QPlainTextDocumentLayoutH; retval: QRectFH; p1: QTextFrameH); cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_frameBoundingRect';
procedure QPlainTextDocumentLayout_blockBoundingRect(handle: QPlainTextDocumentLayoutH; retval: QRectFH; block: QTextBlockH); cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_blockBoundingRect';
procedure QPlainTextDocumentLayout_ensureBlockLayout(handle: QPlainTextDocumentLayoutH; block: QTextBlockH); cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_ensureBlockLayout';
procedure QPlainTextDocumentLayout_setCursorWidth(handle: QPlainTextDocumentLayoutH; width: Integer); cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_setCursorWidth';
function QPlainTextDocumentLayout_cursorWidth(handle: QPlainTextDocumentLayoutH): Integer; cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_cursorWidth';
procedure QPlainTextDocumentLayout_requestUpdate(handle: QPlainTextDocumentLayoutH); cdecl; external Qt4PasLib name 'QPlainTextDocumentLayout_requestUpdate';


type
  QPlainTextEdit_textChanged_Event = procedure () of object cdecl;
  QPlainTextEdit_undoAvailable_Event = procedure (b: Boolean) of object cdecl;
  QPlainTextEdit_redoAvailable_Event = procedure (b: Boolean) of object cdecl;
  QPlainTextEdit_copyAvailable_Event = procedure (b: Boolean) of object cdecl;
  QPlainTextEdit_selectionChanged_Event = procedure () of object cdecl;
  QPlainTextEdit_cursorPositionChanged_Event = procedure () of object cdecl;
  QPlainTextEdit_updateRequest_Event = procedure (rect: PRect; dy: Integer) of object cdecl;
  QPlainTextEdit_blockCountChanged_Event = procedure (newBlockCount: Integer) of object cdecl;
  QPlainTextEdit_modificationChanged_Event = procedure (p1: Boolean) of object cdecl;



type
  QTextEditLineWrapMode = ( // QTextEdit::LineWrapMode (1)
    QTextEditNoWrap, QTextEditWidgetWidth, QTextEditFixedPixelWidth, QTextEditFixedColumnWidth );

type
  QTextEditAutoFormattingFlag = cardinal; // QTextEdit::AutoFormattingFlag
  QTextEditAutoFormatting = QTextEditAutoFormattingFlag; //QFlags<> (3)
const
  QTextEditAutoNone =   0;
  QTextEditAutoBulletList =   $00000001;
  QTextEditAutoAll =   $ffffffff;

function QTextEdit_create(parent: QWidgetH = nil): QTextEditH; cdecl; external Qt4PasLib name 'QTextEdit_create';
procedure QTextEdit_destroy(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_destroy'; 
function QTextEdit_create(text: PWideString; parent: QWidgetH = nil): QTextEditH; cdecl; external Qt4PasLib name 'QTextEdit_create2';
procedure QTextEdit_setDocument(handle: QTextEditH; document: QTextDocumentH); cdecl; external Qt4PasLib name 'QTextEdit_setDocument';
function QTextEdit_document(handle: QTextEditH): QTextDocumentH; cdecl; external Qt4PasLib name 'QTextEdit_document';
procedure QTextEdit_setTextCursor(handle: QTextEditH; cursor: QTextCursorH); cdecl; external Qt4PasLib name 'QTextEdit_setTextCursor';
procedure QTextEdit_textCursor(handle: QTextEditH; retval: QTextCursorH); cdecl; external Qt4PasLib name 'QTextEdit_textCursor';
function QTextEdit_isReadOnly(handle: QTextEditH): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_isReadOnly';
procedure QTextEdit_setReadOnly(handle: QTextEditH; ro: Boolean); cdecl; external Qt4PasLib name 'QTextEdit_setReadOnly';
procedure QTextEdit_setTextInteractionFlags(handle: QTextEditH; flags: QtTextInteractionFlags); cdecl; external Qt4PasLib name 'QTextEdit_setTextInteractionFlags';
function QTextEdit_textInteractionFlags(handle: QTextEditH): QtTextInteractionFlags; cdecl; external Qt4PasLib name 'QTextEdit_textInteractionFlags';
function QTextEdit_fontPointSize(handle: QTextEditH): qreal; cdecl; external Qt4PasLib name 'QTextEdit_fontPointSize';
procedure QTextEdit_fontFamily(handle: QTextEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_fontFamily';
function QTextEdit_fontWeight(handle: QTextEditH): Integer; cdecl; external Qt4PasLib name 'QTextEdit_fontWeight';
function QTextEdit_fontUnderline(handle: QTextEditH): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_fontUnderline';
function QTextEdit_fontItalic(handle: QTextEditH): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_fontItalic';
procedure QTextEdit_textColor(handle: QTextEditH; retval: PQColor); cdecl; external Qt4PasLib name 'QTextEdit_textColor';
procedure QTextEdit_textBackgroundColor(handle: QTextEditH; retval: PQColor); cdecl; external Qt4PasLib name 'QTextEdit_textBackgroundColor';
procedure QTextEdit_currentFont(handle: QTextEditH; retval: QFontH); cdecl; external Qt4PasLib name 'QTextEdit_currentFont';
function QTextEdit_alignment(handle: QTextEditH): QtAlignment; cdecl; external Qt4PasLib name 'QTextEdit_alignment';
procedure QTextEdit_mergeCurrentCharFormat(handle: QTextEditH; modifier: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextEdit_mergeCurrentCharFormat';
procedure QTextEdit_setCurrentCharFormat(handle: QTextEditH; format: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextEdit_setCurrentCharFormat';
procedure QTextEdit_currentCharFormat(handle: QTextEditH; retval: QTextCharFormatH); cdecl; external Qt4PasLib name 'QTextEdit_currentCharFormat';
function QTextEdit_autoFormatting(handle: QTextEditH): QTextEditAutoFormatting; cdecl; external Qt4PasLib name 'QTextEdit_autoFormatting';
procedure QTextEdit_setAutoFormatting(handle: QTextEditH; features: QTextEditAutoFormatting); cdecl; external Qt4PasLib name 'QTextEdit_setAutoFormatting';
function QTextEdit_tabChangesFocus(handle: QTextEditH): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_tabChangesFocus';
procedure QTextEdit_setTabChangesFocus(handle: QTextEditH; b: Boolean); cdecl; external Qt4PasLib name 'QTextEdit_setTabChangesFocus';
procedure QTextEdit_setDocumentTitle(handle: QTextEditH; title: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_setDocumentTitle';
procedure QTextEdit_documentTitle(handle: QTextEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_documentTitle';
function QTextEdit_isUndoRedoEnabled(handle: QTextEditH): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_isUndoRedoEnabled';
procedure QTextEdit_setUndoRedoEnabled(handle: QTextEditH; enable: Boolean); cdecl; external Qt4PasLib name 'QTextEdit_setUndoRedoEnabled';
function QTextEdit_lineWrapMode(handle: QTextEditH): QTextEditLineWrapMode; cdecl; external Qt4PasLib name 'QTextEdit_lineWrapMode';
procedure QTextEdit_setLineWrapMode(handle: QTextEditH; mode: QTextEditLineWrapMode); cdecl; external Qt4PasLib name 'QTextEdit_setLineWrapMode';
function QTextEdit_lineWrapColumnOrWidth(handle: QTextEditH): Integer; cdecl; external Qt4PasLib name 'QTextEdit_lineWrapColumnOrWidth';
procedure QTextEdit_setLineWrapColumnOrWidth(handle: QTextEditH; w: Integer); cdecl; external Qt4PasLib name 'QTextEdit_setLineWrapColumnOrWidth';
function QTextEdit_wordWrapMode(handle: QTextEditH): QTextOptionWrapMode; cdecl; external Qt4PasLib name 'QTextEdit_wordWrapMode';
procedure QTextEdit_setWordWrapMode(handle: QTextEditH; policy: QTextOptionWrapMode); cdecl; external Qt4PasLib name 'QTextEdit_setWordWrapMode';
function QTextEdit_find(handle: QTextEditH; exp: PWideString; options: QTextDocumentFindFlags = 0): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_find';
procedure QTextEdit_toPlainText(handle: QTextEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_toPlainText';
procedure QTextEdit_toHtml(handle: QTextEditH; retval: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_toHtml';
procedure QTextEdit_ensureCursorVisible(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_ensureCursorVisible';
procedure QTextEdit_loadResource(handle: QTextEditH; retval: QVariantH; _type: Integer; name: QUrlH); cdecl; external Qt4PasLib name 'QTextEdit_loadResource';
function QTextEdit_createStandardContextMenu(handle: QTextEditH): QMenuH; cdecl; external Qt4PasLib name 'QTextEdit_createStandardContextMenu';
function QTextEdit_createStandardContextMenu(handle: QTextEditH; position: PQtPoint): QMenuH; cdecl; external Qt4PasLib name 'QTextEdit_createStandardContextMenu2';
procedure QTextEdit_cursorForPosition(handle: QTextEditH; retval: QTextCursorH; pos: PQtPoint); cdecl; external Qt4PasLib name 'QTextEdit_cursorForPosition';
procedure QTextEdit_cursorRect(handle: QTextEditH; retval: PRect; cursor: QTextCursorH); cdecl; external Qt4PasLib name 'QTextEdit_cursorRect';
procedure QTextEdit_cursorRect(handle: QTextEditH; retval: PRect); cdecl; external Qt4PasLib name 'QTextEdit_cursorRect2';
procedure QTextEdit_anchorAt(handle: QTextEditH; retval: PWideString; pos: PQtPoint); cdecl; external Qt4PasLib name 'QTextEdit_anchorAt';
function QTextEdit_overwriteMode(handle: QTextEditH): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_overwriteMode';
procedure QTextEdit_setOverwriteMode(handle: QTextEditH; overwrite: Boolean); cdecl; external Qt4PasLib name 'QTextEdit_setOverwriteMode';
function QTextEdit_tabStopWidth(handle: QTextEditH): Integer; cdecl; external Qt4PasLib name 'QTextEdit_tabStopWidth';
procedure QTextEdit_setTabStopWidth(handle: QTextEditH; width: Integer); cdecl; external Qt4PasLib name 'QTextEdit_setTabStopWidth';
function QTextEdit_cursorWidth(handle: QTextEditH): Integer; cdecl; external Qt4PasLib name 'QTextEdit_cursorWidth';
procedure QTextEdit_setCursorWidth(handle: QTextEditH; width: Integer); cdecl; external Qt4PasLib name 'QTextEdit_setCursorWidth';
function QTextEdit_acceptRichText(handle: QTextEditH): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_acceptRichText';
procedure QTextEdit_setAcceptRichText(handle: QTextEditH; accept: Boolean); cdecl; external Qt4PasLib name 'QTextEdit_setAcceptRichText';
procedure QTextEdit_moveCursor(handle: QTextEditH; operation: QTextCursorMoveOperation; mode: QTextCursorMoveMode = QTextCursorMoveAnchor); cdecl; external Qt4PasLib name 'QTextEdit_moveCursor';
function QTextEdit_canPaste(handle: QTextEditH): Boolean; cdecl; external Qt4PasLib name 'QTextEdit_canPaste';
procedure QTextEdit_print(handle: QTextEditH; printer: QPrinterH); cdecl; external Qt4PasLib name 'QTextEdit_print';
procedure QTextEdit_setFontPointSize(handle: QTextEditH; s: qreal); cdecl; external Qt4PasLib name 'QTextEdit_setFontPointSize';
procedure QTextEdit_setFontFamily(handle: QTextEditH; fontFamily: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_setFontFamily';
procedure QTextEdit_setFontWeight(handle: QTextEditH; w: Integer); cdecl; external Qt4PasLib name 'QTextEdit_setFontWeight';
procedure QTextEdit_setFontUnderline(handle: QTextEditH; b: Boolean); cdecl; external Qt4PasLib name 'QTextEdit_setFontUnderline';
procedure QTextEdit_setFontItalic(handle: QTextEditH; b: Boolean); cdecl; external Qt4PasLib name 'QTextEdit_setFontItalic';
procedure QTextEdit_setTextColor(handle: QTextEditH; c: PQColor); cdecl; external Qt4PasLib name 'QTextEdit_setTextColor';
procedure QTextEdit_setTextBackgroundColor(handle: QTextEditH; c: PQColor); cdecl; external Qt4PasLib name 'QTextEdit_setTextBackgroundColor';
procedure QTextEdit_setCurrentFont(handle: QTextEditH; f: QFontH); cdecl; external Qt4PasLib name 'QTextEdit_setCurrentFont';
procedure QTextEdit_setAlignment(handle: QTextEditH; a: QtAlignment); cdecl; external Qt4PasLib name 'QTextEdit_setAlignment';
procedure QTextEdit_setPlainText(handle: QTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_setPlainText';
procedure QTextEdit_setHtml(handle: QTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_setHtml';
procedure QTextEdit_setText(handle: QTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_setText';
procedure QTextEdit_cut(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_cut';
procedure QTextEdit_copy(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_copy';
procedure QTextEdit_paste(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_paste';
procedure QTextEdit_undo(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_undo';
procedure QTextEdit_redo(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_redo';
procedure QTextEdit_clear(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_clear';
procedure QTextEdit_selectAll(handle: QTextEditH); cdecl; external Qt4PasLib name 'QTextEdit_selectAll';
procedure QTextEdit_insertPlainText(handle: QTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_insertPlainText';
procedure QTextEdit_insertHtml(handle: QTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_insertHtml';
procedure QTextEdit_append(handle: QTextEditH; text: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_append';
procedure QTextEdit_scrollToAnchor(handle: QTextEditH; name: PWideString); cdecl; external Qt4PasLib name 'QTextEdit_scrollToAnchor';
procedure QTextEdit_zoomIn(handle: QTextEditH; range: Integer = 1); cdecl; external Qt4PasLib name 'QTextEdit_zoomIn';
procedure QTextEdit_zoomOut(handle: QTextEditH; range: Integer = 1); cdecl; external Qt4PasLib name 'QTextEdit_zoomOut';


type
  QTextEdit_textChanged_Event = procedure () of object cdecl;
  QTextEdit_undoAvailable_Event = procedure (b: Boolean) of object cdecl;
  QTextEdit_redoAvailable_Event = procedure (b: Boolean) of object cdecl;
  QTextEdit_currentCharFormatChanged_Event = procedure (format: QTextCharFormatH) of object cdecl;
  QTextEdit_copyAvailable_Event = procedure (b: Boolean) of object cdecl;
  QTextEdit_selectionChanged_Event = procedure () of object cdecl;
  QTextEdit_cursorPositionChanged_Event = procedure () of object cdecl;



type
  QTabWidgetTabPosition = ( // QTabWidget::TabPosition (1)
    QTabWidgetNorth, QTabWidgetSouth, QTabWidgetWest, QTabWidgetEast );

  QTabWidgetTabShape = ( // QTabWidget::TabShape (1)
    QTabWidgetRounded, QTabWidgetTriangular );

function QTabWidget_create(parent: QWidgetH = nil): QTabWidgetH; cdecl; external Qt4PasLib name 'QTabWidget_create';
procedure QTabWidget_destroy(handle: QTabWidgetH); cdecl; external Qt4PasLib name 'QTabWidget_destroy'; 
function QTabWidget_addTab(handle: QTabWidgetH; widget: QWidgetH; p2: PWideString): Integer; cdecl; external Qt4PasLib name 'QTabWidget_addTab';
function QTabWidget_addTab(handle: QTabWidgetH; widget: QWidgetH; icon: QIconH; _label: PWideString): Integer; cdecl; external Qt4PasLib name 'QTabWidget_addTab2';
function QTabWidget_insertTab(handle: QTabWidgetH; index: Integer; widget: QWidgetH; p3: PWideString): Integer; cdecl; external Qt4PasLib name 'QTabWidget_insertTab';
function QTabWidget_insertTab(handle: QTabWidgetH; index: Integer; widget: QWidgetH; icon: QIconH; _label: PWideString): Integer; cdecl; external Qt4PasLib name 'QTabWidget_insertTab2';
procedure QTabWidget_removeTab(handle: QTabWidgetH; index: Integer); cdecl; external Qt4PasLib name 'QTabWidget_removeTab';
function QTabWidget_isTabEnabled(handle: QTabWidgetH; index: Integer): Boolean; cdecl; external Qt4PasLib name 'QTabWidget_isTabEnabled';
procedure QTabWidget_setTabEnabled(handle: QTabWidgetH; index: Integer; p2: Boolean); cdecl; external Qt4PasLib name 'QTabWidget_setTabEnabled';
procedure QTabWidget_tabText(handle: QTabWidgetH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QTabWidget_tabText';
procedure QTabWidget_setTabText(handle: QTabWidgetH; index: Integer; p2: PWideString); cdecl; external Qt4PasLib name 'QTabWidget_setTabText';
procedure QTabWidget_tabIcon(handle: QTabWidgetH; retval: QIconH; index: Integer); cdecl; external Qt4PasLib name 'QTabWidget_tabIcon';
procedure QTabWidget_setTabIcon(handle: QTabWidgetH; index: Integer; icon: QIconH); cdecl; external Qt4PasLib name 'QTabWidget_setTabIcon';
procedure QTabWidget_setTabToolTip(handle: QTabWidgetH; index: Integer; tip: PWideString); cdecl; external Qt4PasLib name 'QTabWidget_setTabToolTip';
procedure QTabWidget_tabToolTip(handle: QTabWidgetH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QTabWidget_tabToolTip';
procedure QTabWidget_setTabWhatsThis(handle: QTabWidgetH; index: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QTabWidget_setTabWhatsThis';
procedure QTabWidget_tabWhatsThis(handle: QTabWidgetH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QTabWidget_tabWhatsThis';
function QTabWidget_currentIndex(handle: QTabWidgetH): Integer; cdecl; external Qt4PasLib name 'QTabWidget_currentIndex';
function QTabWidget_currentWidget(handle: QTabWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QTabWidget_currentWidget';
function QTabWidget_widget(handle: QTabWidgetH; index: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QTabWidget_widget';
function QTabWidget_indexOf(handle: QTabWidgetH; widget: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QTabWidget_indexOf';
function QTabWidget_count(handle: QTabWidgetH): Integer; cdecl; external Qt4PasLib name 'QTabWidget_count';
function QTabWidget_tabPosition(handle: QTabWidgetH): QTabWidgetTabPosition; cdecl; external Qt4PasLib name 'QTabWidget_tabPosition';
procedure QTabWidget_setTabPosition(handle: QTabWidgetH; p1: QTabWidgetTabPosition); cdecl; external Qt4PasLib name 'QTabWidget_setTabPosition';
function QTabWidget_tabsClosable(handle: QTabWidgetH): Boolean; cdecl; external Qt4PasLib name 'QTabWidget_tabsClosable';
procedure QTabWidget_setTabsClosable(handle: QTabWidgetH; closeable: Boolean); cdecl; external Qt4PasLib name 'QTabWidget_setTabsClosable';
function QTabWidget_isMovable(handle: QTabWidgetH): Boolean; cdecl; external Qt4PasLib name 'QTabWidget_isMovable';
procedure QTabWidget_setMovable(handle: QTabWidgetH; movable: Boolean); cdecl; external Qt4PasLib name 'QTabWidget_setMovable';
function QTabWidget_tabShape(handle: QTabWidgetH): QTabWidgetTabShape; cdecl; external Qt4PasLib name 'QTabWidget_tabShape';
procedure QTabWidget_setTabShape(handle: QTabWidgetH; s: QTabWidgetTabShape); cdecl; external Qt4PasLib name 'QTabWidget_setTabShape';
procedure QTabWidget_sizeHint(handle: QTabWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QTabWidget_sizeHint';
procedure QTabWidget_minimumSizeHint(handle: QTabWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QTabWidget_minimumSizeHint';
procedure QTabWidget_setCornerWidget(handle: QTabWidgetH; w: QWidgetH; corner: QtCorner = QtTopRightCorner); cdecl; external Qt4PasLib name 'QTabWidget_setCornerWidget';
function QTabWidget_cornerWidget(handle: QTabWidgetH; corner: QtCorner = QtTopRightCorner): QWidgetH; cdecl; external Qt4PasLib name 'QTabWidget_cornerWidget';
function QTabWidget_elideMode(handle: QTabWidgetH): QtTextElideMode; cdecl; external Qt4PasLib name 'QTabWidget_elideMode';
procedure QTabWidget_setElideMode(handle: QTabWidgetH; p1: QtTextElideMode); cdecl; external Qt4PasLib name 'QTabWidget_setElideMode';
procedure QTabWidget_iconSize(handle: QTabWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QTabWidget_iconSize';
procedure QTabWidget_setIconSize(handle: QTabWidgetH; size: PSize); cdecl; external Qt4PasLib name 'QTabWidget_setIconSize';
function QTabWidget_usesScrollButtons(handle: QTabWidgetH): Boolean; cdecl; external Qt4PasLib name 'QTabWidget_usesScrollButtons';
procedure QTabWidget_setUsesScrollButtons(handle: QTabWidgetH; useButtons: Boolean); cdecl; external Qt4PasLib name 'QTabWidget_setUsesScrollButtons';
function QTabWidget_documentMode(handle: QTabWidgetH): Boolean; cdecl; external Qt4PasLib name 'QTabWidget_documentMode';
procedure QTabWidget_setDocumentMode(handle: QTabWidgetH; _set: Boolean); cdecl; external Qt4PasLib name 'QTabWidget_setDocumentMode';
procedure QTabWidget_clear(handle: QTabWidgetH); cdecl; external Qt4PasLib name 'QTabWidget_clear';
procedure QTabWidget_setCurrentIndex(handle: QTabWidgetH; index: Integer); cdecl; external Qt4PasLib name 'QTabWidget_setCurrentIndex';
procedure QTabWidget_setCurrentWidget(handle: QTabWidgetH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QTabWidget_setCurrentWidget';


type
  QTabWidget_currentChanged_Event = procedure (index: Integer) of object cdecl;
  QTabWidget_tabCloseRequested_Event = procedure (index: Integer) of object cdecl;


function QLCLTabWidget_tabBarHandle(protectedhandle: QTabWidgetH): QTabBarH; cdecl; external Qt4PasLib name 'QLCLTabWidget_tabBarHandle';

type
  QMainWindowDockOption = cardinal; // QMainWindow::DockOption
  QMainWindowDockOptions = QMainWindowDockOption; //QFlags<> (3)
const
  QMainWindowAnimatedDocks =   $01;
  QMainWindowAllowNestedDocks =   $02;
  QMainWindowAllowTabbedDocks =   $04;
  QMainWindowForceTabbedDocks =   $08;
  QMainWindowVerticalTabs =   $10;

function QMainWindow_create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QMainWindowH; cdecl; external Qt4PasLib name 'QMainWindow_create';
procedure QMainWindow_destroy(handle: QMainWindowH); cdecl; external Qt4PasLib name 'QMainWindow_destroy'; 
procedure QMainWindow_iconSize(handle: QMainWindowH; retval: PSize); cdecl; external Qt4PasLib name 'QMainWindow_iconSize';
procedure QMainWindow_setIconSize(handle: QMainWindowH; iconSize: PSize); cdecl; external Qt4PasLib name 'QMainWindow_setIconSize';
function QMainWindow_toolButtonStyle(handle: QMainWindowH): QtToolButtonStyle; cdecl; external Qt4PasLib name 'QMainWindow_toolButtonStyle';
procedure QMainWindow_setToolButtonStyle(handle: QMainWindowH; toolButtonStyle: QtToolButtonStyle); cdecl; external Qt4PasLib name 'QMainWindow_setToolButtonStyle';
function QMainWindow_isAnimated(handle: QMainWindowH): Boolean; cdecl; external Qt4PasLib name 'QMainWindow_isAnimated';
function QMainWindow_isDockNestingEnabled(handle: QMainWindowH): Boolean; cdecl; external Qt4PasLib name 'QMainWindow_isDockNestingEnabled';
function QMainWindow_documentMode(handle: QMainWindowH): Boolean; cdecl; external Qt4PasLib name 'QMainWindow_documentMode';
procedure QMainWindow_setDocumentMode(handle: QMainWindowH; enabled: Boolean); cdecl; external Qt4PasLib name 'QMainWindow_setDocumentMode';
function QMainWindow_tabShape(handle: QMainWindowH): QTabWidgetTabShape; cdecl; external Qt4PasLib name 'QMainWindow_tabShape';
procedure QMainWindow_setTabShape(handle: QMainWindowH; tabShape: QTabWidgetTabShape); cdecl; external Qt4PasLib name 'QMainWindow_setTabShape';
function QMainWindow_tabPosition(handle: QMainWindowH; area: QtDockWidgetArea): QTabWidgetTabPosition; cdecl; external Qt4PasLib name 'QMainWindow_tabPosition';
procedure QMainWindow_setTabPosition(handle: QMainWindowH; areas: QtDockWidgetAreas; tabPosition: QTabWidgetTabPosition); cdecl; external Qt4PasLib name 'QMainWindow_setTabPosition';
procedure QMainWindow_setDockOptions(handle: QMainWindowH; options: QMainWindowDockOptions); cdecl; external Qt4PasLib name 'QMainWindow_setDockOptions';
function QMainWindow_dockOptions(handle: QMainWindowH): QMainWindowDockOptions; cdecl; external Qt4PasLib name 'QMainWindow_dockOptions';
function QMainWindow_isSeparator(handle: QMainWindowH; pos: PQtPoint): Boolean; cdecl; external Qt4PasLib name 'QMainWindow_isSeparator';
function QMainWindow_menuBar(handle: QMainWindowH): QMenuBarH; cdecl; external Qt4PasLib name 'QMainWindow_menuBar';
procedure QMainWindow_setMenuBar(handle: QMainWindowH; menubar: QMenuBarH); cdecl; external Qt4PasLib name 'QMainWindow_setMenuBar';
function QMainWindow_menuWidget(handle: QMainWindowH): QWidgetH; cdecl; external Qt4PasLib name 'QMainWindow_menuWidget';
procedure QMainWindow_setMenuWidget(handle: QMainWindowH; menubar: QWidgetH); cdecl; external Qt4PasLib name 'QMainWindow_setMenuWidget';
function QMainWindow_statusBar(handle: QMainWindowH): QStatusBarH; cdecl; external Qt4PasLib name 'QMainWindow_statusBar';
procedure QMainWindow_setStatusBar(handle: QMainWindowH; statusbar: QStatusBarH); cdecl; external Qt4PasLib name 'QMainWindow_setStatusBar';
function QMainWindow_centralWidget(handle: QMainWindowH): QWidgetH; cdecl; external Qt4PasLib name 'QMainWindow_centralWidget';
procedure QMainWindow_setCentralWidget(handle: QMainWindowH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QMainWindow_setCentralWidget';
procedure QMainWindow_setCorner(handle: QMainWindowH; corner: QtCorner; area: QtDockWidgetArea); cdecl; external Qt4PasLib name 'QMainWindow_setCorner';
function QMainWindow_corner(handle: QMainWindowH; corner: QtCorner): QtDockWidgetArea; cdecl; external Qt4PasLib name 'QMainWindow_corner';
procedure QMainWindow_addToolBarBreak(handle: QMainWindowH; area: QtToolBarArea = QtTopToolBarArea); cdecl; external Qt4PasLib name 'QMainWindow_addToolBarBreak';
procedure QMainWindow_insertToolBarBreak(handle: QMainWindowH; before: QToolBarH); cdecl; external Qt4PasLib name 'QMainWindow_insertToolBarBreak';
procedure QMainWindow_addToolBar(handle: QMainWindowH; area: QtToolBarArea; toolbar: QToolBarH); cdecl; external Qt4PasLib name 'QMainWindow_addToolBar';
procedure QMainWindow_addToolBar(handle: QMainWindowH; toolbar: QToolBarH); cdecl; external Qt4PasLib name 'QMainWindow_addToolBar2';
function QMainWindow_addToolBar(handle: QMainWindowH; title: PWideString): QToolBarH; cdecl; external Qt4PasLib name 'QMainWindow_addToolBar3';
procedure QMainWindow_insertToolBar(handle: QMainWindowH; before: QToolBarH; toolbar: QToolBarH); cdecl; external Qt4PasLib name 'QMainWindow_insertToolBar';
procedure QMainWindow_removeToolBar(handle: QMainWindowH; toolbar: QToolBarH); cdecl; external Qt4PasLib name 'QMainWindow_removeToolBar';
procedure QMainWindow_removeToolBarBreak(handle: QMainWindowH; before: QToolBarH); cdecl; external Qt4PasLib name 'QMainWindow_removeToolBarBreak';
procedure QMainWindow_setUnifiedTitleAndToolBarOnMac(handle: QMainWindowH; _set: Boolean); cdecl; external Qt4PasLib name 'QMainWindow_setUnifiedTitleAndToolBarOnMac';
function QMainWindow_unifiedTitleAndToolBarOnMac(handle: QMainWindowH): Boolean; cdecl; external Qt4PasLib name 'QMainWindow_unifiedTitleAndToolBarOnMac';
function QMainWindow_toolBarArea(handle: QMainWindowH; toolbar: QToolBarH): QtToolBarArea; cdecl; external Qt4PasLib name 'QMainWindow_toolBarArea';
function QMainWindow_toolBarBreak(handle: QMainWindowH; toolbar: QToolBarH): Boolean; cdecl; external Qt4PasLib name 'QMainWindow_toolBarBreak';
procedure QMainWindow_addDockWidget(handle: QMainWindowH; area: QtDockWidgetArea; dockwidget: QDockWidgetH); cdecl; external Qt4PasLib name 'QMainWindow_addDockWidget';
procedure QMainWindow_addDockWidget(handle: QMainWindowH; area: QtDockWidgetArea; dockwidget: QDockWidgetH; orientation: QtOrientation); cdecl; external Qt4PasLib name 'QMainWindow_addDockWidget2';
procedure QMainWindow_splitDockWidget(handle: QMainWindowH; after: QDockWidgetH; dockwidget: QDockWidgetH; orientation: QtOrientation); cdecl; external Qt4PasLib name 'QMainWindow_splitDockWidget';
procedure QMainWindow_tabifyDockWidget(handle: QMainWindowH; first: QDockWidgetH; second: QDockWidgetH); cdecl; external Qt4PasLib name 'QMainWindow_tabifyDockWidget';
procedure QMainWindow_tabifiedDockWidgets(handle: QMainWindowH; retval: PPtrIntArray; dockwidget: QDockWidgetH); cdecl; external Qt4PasLib name 'QMainWindow_tabifiedDockWidgets';
procedure QMainWindow_removeDockWidget(handle: QMainWindowH; dockwidget: QDockWidgetH); cdecl; external Qt4PasLib name 'QMainWindow_removeDockWidget';
function QMainWindow_restoreDockWidget(handle: QMainWindowH; dockwidget: QDockWidgetH): Boolean; cdecl; external Qt4PasLib name 'QMainWindow_restoreDockWidget';
function QMainWindow_dockWidgetArea(handle: QMainWindowH; dockwidget: QDockWidgetH): QtDockWidgetArea; cdecl; external Qt4PasLib name 'QMainWindow_dockWidgetArea';
procedure QMainWindow_saveState(handle: QMainWindowH; retval: QByteArrayH; version: Integer = 0); cdecl; external Qt4PasLib name 'QMainWindow_saveState';
function QMainWindow_restoreState(handle: QMainWindowH; state: QByteArrayH; version: Integer = 0): Boolean; cdecl; external Qt4PasLib name 'QMainWindow_restoreState';
function QMainWindow_createPopupMenu(handle: QMainWindowH): QMenuH; cdecl; external Qt4PasLib name 'QMainWindow_createPopupMenu';
procedure QMainWindow_setAnimated(handle: QMainWindowH; enabled: Boolean); cdecl; external Qt4PasLib name 'QMainWindow_setAnimated';
procedure QMainWindow_setDockNestingEnabled(handle: QMainWindowH; enabled: Boolean); cdecl; external Qt4PasLib name 'QMainWindow_setDockNestingEnabled';


type
  QMainWindow_iconSizeChanged_Event = procedure (iconSize: PSize) of object cdecl;
  QMainWindow_toolButtonStyleChanged_Event = procedure (toolButtonStyle: QtToolButtonStyle) of object cdecl;


function QToolBar_create(title: PWideString; parent: QWidgetH = nil): QToolBarH; cdecl; external Qt4PasLib name 'QToolBar_create';
procedure QToolBar_destroy(handle: QToolBarH); cdecl; external Qt4PasLib name 'QToolBar_destroy'; 
function QToolBar_create(parent: QWidgetH = nil): QToolBarH; cdecl; external Qt4PasLib name 'QToolBar_create2';
procedure QToolBar_setMovable(handle: QToolBarH; movable: Boolean); cdecl; external Qt4PasLib name 'QToolBar_setMovable';
function QToolBar_isMovable(handle: QToolBarH): Boolean; cdecl; external Qt4PasLib name 'QToolBar_isMovable';
procedure QToolBar_setAllowedAreas(handle: QToolBarH; areas: QtToolBarAreas); cdecl; external Qt4PasLib name 'QToolBar_setAllowedAreas';
function QToolBar_allowedAreas(handle: QToolBarH): QtToolBarAreas; cdecl; external Qt4PasLib name 'QToolBar_allowedAreas';
function QToolBar_isAreaAllowed(handle: QToolBarH; area: QtToolBarArea): Boolean; cdecl; external Qt4PasLib name 'QToolBar_isAreaAllowed';
procedure QToolBar_setOrientation(handle: QToolBarH; orientation: QtOrientation); cdecl; external Qt4PasLib name 'QToolBar_setOrientation';
function QToolBar_orientation(handle: QToolBarH): QtOrientation; cdecl; external Qt4PasLib name 'QToolBar_orientation';
procedure QToolBar_clear(handle: QToolBarH); cdecl; external Qt4PasLib name 'QToolBar_clear';
function QToolBar_addAction(handle: QToolBarH; text: PWideString): QActionH; cdecl; external Qt4PasLib name 'QToolBar_addAction';
function QToolBar_addAction(handle: QToolBarH; icon: QIconH; text: PWideString): QActionH; cdecl; external Qt4PasLib name 'QToolBar_addAction2';
function QToolBar_addAction(handle: QToolBarH; text: PWideString; receiver: QObjectH; member: PAnsiChar): QActionH; cdecl; external Qt4PasLib name 'QToolBar_addAction3';
function QToolBar_addAction(handle: QToolBarH; icon: QIconH; text: PWideString; receiver: QObjectH; member: PAnsiChar): QActionH; cdecl; external Qt4PasLib name 'QToolBar_addAction4';
function QToolBar_addSeparator(handle: QToolBarH): QActionH; cdecl; external Qt4PasLib name 'QToolBar_addSeparator';
function QToolBar_insertSeparator(handle: QToolBarH; before: QActionH): QActionH; cdecl; external Qt4PasLib name 'QToolBar_insertSeparator';
function QToolBar_addWidget(handle: QToolBarH; widget: QWidgetH): QActionH; cdecl; external Qt4PasLib name 'QToolBar_addWidget';
function QToolBar_insertWidget(handle: QToolBarH; before: QActionH; widget: QWidgetH): QActionH; cdecl; external Qt4PasLib name 'QToolBar_insertWidget';
procedure QToolBar_actionGeometry(handle: QToolBarH; retval: PRect; action: QActionH); cdecl; external Qt4PasLib name 'QToolBar_actionGeometry';
function QToolBar_actionAt(handle: QToolBarH; p: PQtPoint): QActionH; cdecl; external Qt4PasLib name 'QToolBar_actionAt';
function QToolBar_actionAt(handle: QToolBarH; x: Integer; y: Integer): QActionH; cdecl; external Qt4PasLib name 'QToolBar_actionAt2';
function QToolBar_toggleViewAction(handle: QToolBarH): QActionH; cdecl; external Qt4PasLib name 'QToolBar_toggleViewAction';
procedure QToolBar_iconSize(handle: QToolBarH; retval: PSize); cdecl; external Qt4PasLib name 'QToolBar_iconSize';
function QToolBar_toolButtonStyle(handle: QToolBarH): QtToolButtonStyle; cdecl; external Qt4PasLib name 'QToolBar_toolButtonStyle';
function QToolBar_widgetForAction(handle: QToolBarH; action: QActionH): QWidgetH; cdecl; external Qt4PasLib name 'QToolBar_widgetForAction';
function QToolBar_isFloatable(handle: QToolBarH): Boolean; cdecl; external Qt4PasLib name 'QToolBar_isFloatable';
procedure QToolBar_setFloatable(handle: QToolBarH; floatable: Boolean); cdecl; external Qt4PasLib name 'QToolBar_setFloatable';
function QToolBar_isFloating(handle: QToolBarH): Boolean; cdecl; external Qt4PasLib name 'QToolBar_isFloating';
procedure QToolBar_setIconSize(handle: QToolBarH; iconSize: PSize); cdecl; external Qt4PasLib name 'QToolBar_setIconSize';
procedure QToolBar_setToolButtonStyle(handle: QToolBarH; toolButtonStyle: QtToolButtonStyle); cdecl; external Qt4PasLib name 'QToolBar_setToolButtonStyle';


type
  QToolBar_actionTriggered_Event = procedure (action: QActionH) of object cdecl;
  QToolBar_movableChanged_Event = procedure (movable: Boolean) of object cdecl;
  QToolBar_allowedAreasChanged_Event = procedure (allowedAreas: QtToolBarAreas) of object cdecl;
  QToolBar_orientationChanged_Event = procedure (orientation: QtOrientation) of object cdecl;
  QToolBar_iconSizeChanged_Event = procedure (iconSize: PSize) of object cdecl;
  QToolBar_toolButtonStyleChanged_Event = procedure (toolButtonStyle: QtToolButtonStyle) of object cdecl;


function QSizeGrip_create(parent: QWidgetH): QSizeGripH; cdecl; external Qt4PasLib name 'QSizeGrip_create';
procedure QSizeGrip_destroy(handle: QSizeGripH); cdecl; external Qt4PasLib name 'QSizeGrip_destroy'; 
procedure QSizeGrip_sizeHint(handle: QSizeGripH; retval: PSize); cdecl; external Qt4PasLib name 'QSizeGrip_sizeHint';
procedure QSizeGrip_setVisible(handle: QSizeGripH; p1: Boolean); cdecl; external Qt4PasLib name 'QSizeGrip_setVisible';


type
  QLCDNumberMode = ( // QLCDNumber::Mode (1)
    QLCDNumberHex, QLCDNumberDec, QLCDNumberOct, QLCDNumberBin );

  QLCDNumberSegmentStyle = ( // QLCDNumber::SegmentStyle (1)
    QLCDNumberOutline, QLCDNumberFilled, QLCDNumberFlat );

function QLCDNumber_create(parent: QWidgetH = nil): QLCDNumberH; cdecl; external Qt4PasLib name 'QLCDNumber_create';
procedure QLCDNumber_destroy(handle: QLCDNumberH); cdecl; external Qt4PasLib name 'QLCDNumber_destroy'; 
function QLCDNumber_create(numDigits: LongWord; parent: QWidgetH = nil): QLCDNumberH; cdecl; external Qt4PasLib name 'QLCDNumber_create2';
function QLCDNumber_smallDecimalPoint(handle: QLCDNumberH): Boolean; cdecl; external Qt4PasLib name 'QLCDNumber_smallDecimalPoint';
function QLCDNumber_numDigits(handle: QLCDNumberH): Integer; cdecl; external Qt4PasLib name 'QLCDNumber_numDigits';
procedure QLCDNumber_setNumDigits(handle: QLCDNumberH; nDigits: Integer); cdecl; external Qt4PasLib name 'QLCDNumber_setNumDigits';
function QLCDNumber_checkOverflow(handle: QLCDNumberH; num: Double): Boolean; cdecl; external Qt4PasLib name 'QLCDNumber_checkOverflow';
function QLCDNumber_checkOverflow(handle: QLCDNumberH; num: Integer): Boolean; cdecl; external Qt4PasLib name 'QLCDNumber_checkOverflow2';
function QLCDNumber_mode(handle: QLCDNumberH): QLCDNumberMode; cdecl; external Qt4PasLib name 'QLCDNumber_mode';
procedure QLCDNumber_setMode(handle: QLCDNumberH; p1: QLCDNumberMode); cdecl; external Qt4PasLib name 'QLCDNumber_setMode';
function QLCDNumber_segmentStyle(handle: QLCDNumberH): QLCDNumberSegmentStyle; cdecl; external Qt4PasLib name 'QLCDNumber_segmentStyle';
procedure QLCDNumber_setSegmentStyle(handle: QLCDNumberH; p1: QLCDNumberSegmentStyle); cdecl; external Qt4PasLib name 'QLCDNumber_setSegmentStyle';
function QLCDNumber_value(handle: QLCDNumberH): Double; cdecl; external Qt4PasLib name 'QLCDNumber_value';
function QLCDNumber_intValue(handle: QLCDNumberH): Integer; cdecl; external Qt4PasLib name 'QLCDNumber_intValue';
procedure QLCDNumber_sizeHint(handle: QLCDNumberH; retval: PSize); cdecl; external Qt4PasLib name 'QLCDNumber_sizeHint';
procedure QLCDNumber_display(handle: QLCDNumberH; str: PWideString); cdecl; external Qt4PasLib name 'QLCDNumber_display';
procedure QLCDNumber_display(handle: QLCDNumberH; num: Integer); cdecl; external Qt4PasLib name 'QLCDNumber_display2';
procedure QLCDNumber_display(handle: QLCDNumberH; num: Double); cdecl; external Qt4PasLib name 'QLCDNumber_display3';
procedure QLCDNumber_setHexMode(handle: QLCDNumberH); cdecl; external Qt4PasLib name 'QLCDNumber_setHexMode';
procedure QLCDNumber_setDecMode(handle: QLCDNumberH); cdecl; external Qt4PasLib name 'QLCDNumber_setDecMode';
procedure QLCDNumber_setOctMode(handle: QLCDNumberH); cdecl; external Qt4PasLib name 'QLCDNumber_setOctMode';
procedure QLCDNumber_setBinMode(handle: QLCDNumberH); cdecl; external Qt4PasLib name 'QLCDNumber_setBinMode';
procedure QLCDNumber_setSmallDecimalPoint(handle: QLCDNumberH; p1: Boolean); cdecl; external Qt4PasLib name 'QLCDNumber_setSmallDecimalPoint';


type
  QLCDNumber_overflow_Event = procedure () of object cdecl;



type
  QAbstractSpinBoxButtonSymbols = ( // QAbstractSpinBox::ButtonSymbols (1)
    QAbstractSpinBoxUpDownArrows, QAbstractSpinBoxPlusMinus, QAbstractSpinBoxNoButtons );

  QAbstractSpinBoxCorrectionMode = ( // QAbstractSpinBox::CorrectionMode (1)
    QAbstractSpinBoxCorrectToPreviousValue, QAbstractSpinBoxCorrectToNearestValue );

type
  QAbstractSpinBoxStepEnabledFlag = cardinal; // QAbstractSpinBox::StepEnabledFlag
  QAbstractSpinBoxStepEnabled = QAbstractSpinBoxStepEnabledFlag; //QFlags<> (3)
const
  QAbstractSpinBoxStepNone =   $00;
  QAbstractSpinBoxStepUpEnabled =   $01;
  QAbstractSpinBoxStepDownEnabled =   $02;

function QAbstractSpinBox_create(parent: QWidgetH = nil): QAbstractSpinBoxH; cdecl; external Qt4PasLib name 'QAbstractSpinBox_create';
procedure QAbstractSpinBox_destroy(handle: QAbstractSpinBoxH); cdecl; external Qt4PasLib name 'QAbstractSpinBox_destroy'; 
function QAbstractSpinBox_buttonSymbols(handle: QAbstractSpinBoxH): QAbstractSpinBoxButtonSymbols; cdecl; external Qt4PasLib name 'QAbstractSpinBox_buttonSymbols';
procedure QAbstractSpinBox_setButtonSymbols(handle: QAbstractSpinBoxH; bs: QAbstractSpinBoxButtonSymbols); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setButtonSymbols';
procedure QAbstractSpinBox_setCorrectionMode(handle: QAbstractSpinBoxH; cm: QAbstractSpinBoxCorrectionMode); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setCorrectionMode';
function QAbstractSpinBox_correctionMode(handle: QAbstractSpinBoxH): QAbstractSpinBoxCorrectionMode; cdecl; external Qt4PasLib name 'QAbstractSpinBox_correctionMode';
function QAbstractSpinBox_hasAcceptableInput(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSpinBox_hasAcceptableInput';
procedure QAbstractSpinBox_text(handle: QAbstractSpinBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QAbstractSpinBox_text';
procedure QAbstractSpinBox_specialValueText(handle: QAbstractSpinBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QAbstractSpinBox_specialValueText';
procedure QAbstractSpinBox_setSpecialValueText(handle: QAbstractSpinBoxH; txt: PWideString); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setSpecialValueText';
function QAbstractSpinBox_wrapping(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSpinBox_wrapping';
procedure QAbstractSpinBox_setWrapping(handle: QAbstractSpinBoxH; w: Boolean); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setWrapping';
procedure QAbstractSpinBox_setReadOnly(handle: QAbstractSpinBoxH; r: Boolean); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setReadOnly';
function QAbstractSpinBox_isReadOnly(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSpinBox_isReadOnly';
procedure QAbstractSpinBox_setKeyboardTracking(handle: QAbstractSpinBoxH; kt: Boolean); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setKeyboardTracking';
function QAbstractSpinBox_keyboardTracking(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSpinBox_keyboardTracking';
procedure QAbstractSpinBox_setAlignment(handle: QAbstractSpinBoxH; flag: QtAlignment); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setAlignment';
function QAbstractSpinBox_alignment(handle: QAbstractSpinBoxH): QtAlignment; cdecl; external Qt4PasLib name 'QAbstractSpinBox_alignment';
procedure QAbstractSpinBox_setFrame(handle: QAbstractSpinBoxH; p1: Boolean); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setFrame';
function QAbstractSpinBox_hasFrame(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSpinBox_hasFrame';
procedure QAbstractSpinBox_setAccelerated(handle: QAbstractSpinBoxH; _on: Boolean); cdecl; external Qt4PasLib name 'QAbstractSpinBox_setAccelerated';
function QAbstractSpinBox_isAccelerated(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSpinBox_isAccelerated';
procedure QAbstractSpinBox_sizeHint(handle: QAbstractSpinBoxH; retval: PSize); cdecl; external Qt4PasLib name 'QAbstractSpinBox_sizeHint';
procedure QAbstractSpinBox_minimumSizeHint(handle: QAbstractSpinBoxH; retval: PSize); cdecl; external Qt4PasLib name 'QAbstractSpinBox_minimumSizeHint';
procedure QAbstractSpinBox_interpretText(handle: QAbstractSpinBoxH); cdecl; external Qt4PasLib name 'QAbstractSpinBox_interpretText';
function QAbstractSpinBox_event(handle: QAbstractSpinBoxH; event: QEventH): Boolean; cdecl; external Qt4PasLib name 'QAbstractSpinBox_event';
function QAbstractSpinBox_validate(handle: QAbstractSpinBoxH; input: PWideString; pos: PInteger): QValidatorState; cdecl; external Qt4PasLib name 'QAbstractSpinBox_validate';
procedure QAbstractSpinBox_fixup(handle: QAbstractSpinBoxH; input: PWideString); cdecl; external Qt4PasLib name 'QAbstractSpinBox_fixup';
procedure QAbstractSpinBox_stepBy(handle: QAbstractSpinBoxH; steps: Integer); cdecl; external Qt4PasLib name 'QAbstractSpinBox_stepBy';
procedure QAbstractSpinBox_stepUp(handle: QAbstractSpinBoxH); cdecl; external Qt4PasLib name 'QAbstractSpinBox_stepUp';
procedure QAbstractSpinBox_stepDown(handle: QAbstractSpinBoxH); cdecl; external Qt4PasLib name 'QAbstractSpinBox_stepDown';
procedure QAbstractSpinBox_selectAll(handle: QAbstractSpinBoxH); cdecl; external Qt4PasLib name 'QAbstractSpinBox_selectAll';
procedure QAbstractSpinBox_clear(handle: QAbstractSpinBoxH); cdecl; external Qt4PasLib name 'QAbstractSpinBox_clear';


type
  QAbstractSpinBox_editingFinished_Event = procedure () of object cdecl;


function QLCLAbstractSpinBox_lineEditHandle(protectedhandle: QAbstractSpinBoxH): QLineEditH; cdecl; external Qt4PasLib name 'QLCLAbstractSpinBox_lineEditHandle';

function QSpinBox_create(parent: QWidgetH = nil): QSpinBoxH; cdecl; external Qt4PasLib name 'QSpinBox_create';
procedure QSpinBox_destroy(handle: QSpinBoxH); cdecl; external Qt4PasLib name 'QSpinBox_destroy'; 
function QSpinBox_value(handle: QSpinBoxH): Integer; cdecl; external Qt4PasLib name 'QSpinBox_value';
procedure QSpinBox_prefix(handle: QSpinBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QSpinBox_prefix';
procedure QSpinBox_setPrefix(handle: QSpinBoxH; prefix: PWideString); cdecl; external Qt4PasLib name 'QSpinBox_setPrefix';
procedure QSpinBox_suffix(handle: QSpinBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QSpinBox_suffix';
procedure QSpinBox_setSuffix(handle: QSpinBoxH; suffix: PWideString); cdecl; external Qt4PasLib name 'QSpinBox_setSuffix';
procedure QSpinBox_cleanText(handle: QSpinBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QSpinBox_cleanText';
function QSpinBox_singleStep(handle: QSpinBoxH): Integer; cdecl; external Qt4PasLib name 'QSpinBox_singleStep';
procedure QSpinBox_setSingleStep(handle: QSpinBoxH; val: Integer); cdecl; external Qt4PasLib name 'QSpinBox_setSingleStep';
function QSpinBox_minimum(handle: QSpinBoxH): Integer; cdecl; external Qt4PasLib name 'QSpinBox_minimum';
procedure QSpinBox_setMinimum(handle: QSpinBoxH; min: Integer); cdecl; external Qt4PasLib name 'QSpinBox_setMinimum';
function QSpinBox_maximum(handle: QSpinBoxH): Integer; cdecl; external Qt4PasLib name 'QSpinBox_maximum';
procedure QSpinBox_setMaximum(handle: QSpinBoxH; max: Integer); cdecl; external Qt4PasLib name 'QSpinBox_setMaximum';
procedure QSpinBox_setRange(handle: QSpinBoxH; min: Integer; max: Integer); cdecl; external Qt4PasLib name 'QSpinBox_setRange';
procedure QSpinBox_setValue(handle: QSpinBoxH; val: Integer); cdecl; external Qt4PasLib name 'QSpinBox_setValue';

function QDoubleSpinBox_create(parent: QWidgetH = nil): QDoubleSpinBoxH; cdecl; external Qt4PasLib name 'QDoubleSpinBox_create';
procedure QDoubleSpinBox_destroy(handle: QDoubleSpinBoxH); cdecl; external Qt4PasLib name 'QDoubleSpinBox_destroy'; 
function QDoubleSpinBox_value(handle: QDoubleSpinBoxH): Double; cdecl; external Qt4PasLib name 'QDoubleSpinBox_value';
procedure QDoubleSpinBox_prefix(handle: QDoubleSpinBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QDoubleSpinBox_prefix';
procedure QDoubleSpinBox_setPrefix(handle: QDoubleSpinBoxH; prefix: PWideString); cdecl; external Qt4PasLib name 'QDoubleSpinBox_setPrefix';
procedure QDoubleSpinBox_suffix(handle: QDoubleSpinBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QDoubleSpinBox_suffix';
procedure QDoubleSpinBox_setSuffix(handle: QDoubleSpinBoxH; suffix: PWideString); cdecl; external Qt4PasLib name 'QDoubleSpinBox_setSuffix';
procedure QDoubleSpinBox_cleanText(handle: QDoubleSpinBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QDoubleSpinBox_cleanText';
function QDoubleSpinBox_singleStep(handle: QDoubleSpinBoxH): Double; cdecl; external Qt4PasLib name 'QDoubleSpinBox_singleStep';
procedure QDoubleSpinBox_setSingleStep(handle: QDoubleSpinBoxH; val: Double); cdecl; external Qt4PasLib name 'QDoubleSpinBox_setSingleStep';
function QDoubleSpinBox_minimum(handle: QDoubleSpinBoxH): Double; cdecl; external Qt4PasLib name 'QDoubleSpinBox_minimum';
procedure QDoubleSpinBox_setMinimum(handle: QDoubleSpinBoxH; min: Double); cdecl; external Qt4PasLib name 'QDoubleSpinBox_setMinimum';
function QDoubleSpinBox_maximum(handle: QDoubleSpinBoxH): Double; cdecl; external Qt4PasLib name 'QDoubleSpinBox_maximum';
procedure QDoubleSpinBox_setMaximum(handle: QDoubleSpinBoxH; max: Double); cdecl; external Qt4PasLib name 'QDoubleSpinBox_setMaximum';
procedure QDoubleSpinBox_setRange(handle: QDoubleSpinBoxH; min: Double; max: Double); cdecl; external Qt4PasLib name 'QDoubleSpinBox_setRange';
function QDoubleSpinBox_decimals(handle: QDoubleSpinBoxH): Integer; cdecl; external Qt4PasLib name 'QDoubleSpinBox_decimals';
procedure QDoubleSpinBox_setDecimals(handle: QDoubleSpinBoxH; prec: Integer); cdecl; external Qt4PasLib name 'QDoubleSpinBox_setDecimals';
function QDoubleSpinBox_validate(handle: QDoubleSpinBoxH; input: PWideString; pos: PInteger): QValidatorState; cdecl; external Qt4PasLib name 'QDoubleSpinBox_validate';
function QDoubleSpinBox_valueFromText(handle: QDoubleSpinBoxH; text: PWideString): Double; cdecl; external Qt4PasLib name 'QDoubleSpinBox_valueFromText';
procedure QDoubleSpinBox_textFromValue(handle: QDoubleSpinBoxH; retval: PWideString; val: Double); cdecl; external Qt4PasLib name 'QDoubleSpinBox_textFromValue';
procedure QDoubleSpinBox_fixup(handle: QDoubleSpinBoxH; str: PWideString); cdecl; external Qt4PasLib name 'QDoubleSpinBox_fixup';
procedure QDoubleSpinBox_setValue(handle: QDoubleSpinBoxH; val: Double); cdecl; external Qt4PasLib name 'QDoubleSpinBox_setValue';


type
  QSpinBox_valueChanged_Event = procedure (p1: Integer) of object cdecl;
  QSpinBox_valueChanged2_Event = procedure (p1: PWideString) of object cdecl;



type
  QDoubleSpinBox_valueChanged_Event = procedure (p1: Double) of object cdecl;
  QDoubleSpinBox_valueChanged2_Event = procedure (p1: PWideString) of object cdecl;


function QSplitter_create(parent: QWidgetH = nil): QSplitterH; cdecl; external Qt4PasLib name 'QSplitter_create';
procedure QSplitter_destroy(handle: QSplitterH); cdecl; external Qt4PasLib name 'QSplitter_destroy'; 
function QSplitter_create(p1: QtOrientation; parent: QWidgetH = nil): QSplitterH; cdecl; external Qt4PasLib name 'QSplitter_create2';
procedure QSplitter_addWidget(handle: QSplitterH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QSplitter_addWidget';
procedure QSplitter_insertWidget(handle: QSplitterH; index: Integer; widget: QWidgetH); cdecl; external Qt4PasLib name 'QSplitter_insertWidget';
procedure QSplitter_setOrientation(handle: QSplitterH; p1: QtOrientation); cdecl; external Qt4PasLib name 'QSplitter_setOrientation';
function QSplitter_orientation(handle: QSplitterH): QtOrientation; cdecl; external Qt4PasLib name 'QSplitter_orientation';
procedure QSplitter_setChildrenCollapsible(handle: QSplitterH; p1: Boolean); cdecl; external Qt4PasLib name 'QSplitter_setChildrenCollapsible';
function QSplitter_childrenCollapsible(handle: QSplitterH): Boolean; cdecl; external Qt4PasLib name 'QSplitter_childrenCollapsible';
procedure QSplitter_setCollapsible(handle: QSplitterH; index: Integer; p2: Boolean); cdecl; external Qt4PasLib name 'QSplitter_setCollapsible';
function QSplitter_isCollapsible(handle: QSplitterH; index: Integer): Boolean; cdecl; external Qt4PasLib name 'QSplitter_isCollapsible';
procedure QSplitter_setOpaqueResize(handle: QSplitterH; opaque: Boolean = True); cdecl; external Qt4PasLib name 'QSplitter_setOpaqueResize';
function QSplitter_opaqueResize(handle: QSplitterH): Boolean; cdecl; external Qt4PasLib name 'QSplitter_opaqueResize';
procedure QSplitter_refresh(handle: QSplitterH); cdecl; external Qt4PasLib name 'QSplitter_refresh';
procedure QSplitter_sizeHint(handle: QSplitterH; retval: PSize); cdecl; external Qt4PasLib name 'QSplitter_sizeHint';
procedure QSplitter_minimumSizeHint(handle: QSplitterH; retval: PSize); cdecl; external Qt4PasLib name 'QSplitter_minimumSizeHint';
procedure QSplitter_sizes(handle: QSplitterH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QSplitter_sizes';
procedure QSplitter_setSizes(handle: QSplitterH; list: PPtrIntArray); cdecl; external Qt4PasLib name 'QSplitter_setSizes';
procedure QSplitter_saveState(handle: QSplitterH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QSplitter_saveState';
function QSplitter_restoreState(handle: QSplitterH; state: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QSplitter_restoreState';
function QSplitter_handleWidth(handle: QSplitterH): Integer; cdecl; external Qt4PasLib name 'QSplitter_handleWidth';
procedure QSplitter_setHandleWidth(handle: QSplitterH; p1: Integer); cdecl; external Qt4PasLib name 'QSplitter_setHandleWidth';
function QSplitter_indexOf(handle: QSplitterH; w: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QSplitter_indexOf';
function QSplitter_widget(handle: QSplitterH; index: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QSplitter_widget';
function QSplitter_count(handle: QSplitterH): Integer; cdecl; external Qt4PasLib name 'QSplitter_count';
procedure QSplitter_getRange(handle: QSplitterH; index: Integer; p2: PInteger; p3: PInteger); cdecl; external Qt4PasLib name 'QSplitter_getRange';
function QSplitter_handle(handle: QSplitterH; index: Integer): QSplitterHandleH; cdecl; external Qt4PasLib name 'QSplitter_handle';
procedure QSplitter_setStretchFactor(handle: QSplitterH; index: Integer; stretch: Integer); cdecl; external Qt4PasLib name 'QSplitter_setStretchFactor';

function QSplitterHandle_create(o: QtOrientation; parent: QSplitterH): QSplitterHandleH; cdecl; external Qt4PasLib name 'QSplitterHandle_create';
procedure QSplitterHandle_destroy(handle: QSplitterHandleH); cdecl; external Qt4PasLib name 'QSplitterHandle_destroy'; 
procedure QSplitterHandle_setOrientation(handle: QSplitterHandleH; o: QtOrientation); cdecl; external Qt4PasLib name 'QSplitterHandle_setOrientation';
function QSplitterHandle_orientation(handle: QSplitterHandleH): QtOrientation; cdecl; external Qt4PasLib name 'QSplitterHandle_orientation';
function QSplitterHandle_opaqueResize(handle: QSplitterHandleH): Boolean; cdecl; external Qt4PasLib name 'QSplitterHandle_opaqueResize';
function QSplitterHandle_splitter(handle: QSplitterHandleH): QSplitterH; cdecl; external Qt4PasLib name 'QSplitterHandle_splitter';
procedure QSplitterHandle_sizeHint(handle: QSplitterHandleH; retval: PSize); cdecl; external Qt4PasLib name 'QSplitterHandle_sizeHint';


type
  QSplitter_splitterMoved_Event = procedure (pos: Integer; index: Integer) of object cdecl;



type
  QComboBoxInsertPolicy = ( // QComboBox::InsertPolicy (1)
    QComboBoxNoInsert, QComboBoxInsertAtTop, QComboBoxInsertAtCurrent, QComboBoxInsertAtBottom, QComboBoxInsertAfterCurrent, QComboBoxInsertBeforeCurrent, QComboBoxInsertAlphabetically );

  QComboBoxSizeAdjustPolicy = ( // QComboBox::SizeAdjustPolicy (1)
    QComboBoxAdjustToContents, QComboBoxAdjustToContentsOnFirstShow, QComboBoxAdjustToMinimumContentsLength, QComboBoxAdjustToMinimumContentsLengthWithIcon );

function QComboBox_create(parent: QWidgetH = nil): QComboBoxH; cdecl; external Qt4PasLib name 'QComboBox_create';
procedure QComboBox_destroy(handle: QComboBoxH); cdecl; external Qt4PasLib name 'QComboBox_destroy'; 
function QComboBox_maxVisibleItems(handle: QComboBoxH): Integer; cdecl; external Qt4PasLib name 'QComboBox_maxVisibleItems';
procedure QComboBox_setMaxVisibleItems(handle: QComboBoxH; maxItems: Integer); cdecl; external Qt4PasLib name 'QComboBox_setMaxVisibleItems';
function QComboBox_count(handle: QComboBoxH): Integer; cdecl; external Qt4PasLib name 'QComboBox_count';
procedure QComboBox_setMaxCount(handle: QComboBoxH; max: Integer); cdecl; external Qt4PasLib name 'QComboBox_setMaxCount';
function QComboBox_maxCount(handle: QComboBoxH): Integer; cdecl; external Qt4PasLib name 'QComboBox_maxCount';
function QComboBox_autoCompletion(handle: QComboBoxH): Boolean; cdecl; external Qt4PasLib name 'QComboBox_autoCompletion';
procedure QComboBox_setAutoCompletion(handle: QComboBoxH; enable: Boolean); cdecl; external Qt4PasLib name 'QComboBox_setAutoCompletion';
function QComboBox_autoCompletionCaseSensitivity(handle: QComboBoxH): QtCaseSensitivity; cdecl; external Qt4PasLib name 'QComboBox_autoCompletionCaseSensitivity';
procedure QComboBox_setAutoCompletionCaseSensitivity(handle: QComboBoxH; sensitivity: QtCaseSensitivity); cdecl; external Qt4PasLib name 'QComboBox_setAutoCompletionCaseSensitivity';
function QComboBox_duplicatesEnabled(handle: QComboBoxH): Boolean; cdecl; external Qt4PasLib name 'QComboBox_duplicatesEnabled';
procedure QComboBox_setDuplicatesEnabled(handle: QComboBoxH; enable: Boolean); cdecl; external Qt4PasLib name 'QComboBox_setDuplicatesEnabled';
procedure QComboBox_setFrame(handle: QComboBoxH; p1: Boolean); cdecl; external Qt4PasLib name 'QComboBox_setFrame';
function QComboBox_hasFrame(handle: QComboBoxH): Boolean; cdecl; external Qt4PasLib name 'QComboBox_hasFrame';
function QComboBox_findText(handle: QComboBoxH; text: PWideString; flags: QtMatchFlags = QtMatchExactly or QtMatchCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QComboBox_findText';
function QComboBox_findData(handle: QComboBoxH; data: QVariantH; role: QtItemDataRole = QtUserRole; flags: QtMatchFlags = QtMatchExactly or QtMatchCaseSensitive): Integer; cdecl; external Qt4PasLib name 'QComboBox_findData';
function QComboBox_insertPolicy(handle: QComboBoxH): QComboBoxInsertPolicy; cdecl; external Qt4PasLib name 'QComboBox_insertPolicy';
procedure QComboBox_setInsertPolicy(handle: QComboBoxH; policy: QComboBoxInsertPolicy); cdecl; external Qt4PasLib name 'QComboBox_setInsertPolicy';
function QComboBox_sizeAdjustPolicy(handle: QComboBoxH): QComboBoxSizeAdjustPolicy; cdecl; external Qt4PasLib name 'QComboBox_sizeAdjustPolicy';
procedure QComboBox_setSizeAdjustPolicy(handle: QComboBoxH; policy: QComboBoxSizeAdjustPolicy); cdecl; external Qt4PasLib name 'QComboBox_setSizeAdjustPolicy';
function QComboBox_minimumContentsLength(handle: QComboBoxH): Integer; cdecl; external Qt4PasLib name 'QComboBox_minimumContentsLength';
procedure QComboBox_setMinimumContentsLength(handle: QComboBoxH; characters: Integer); cdecl; external Qt4PasLib name 'QComboBox_setMinimumContentsLength';
procedure QComboBox_iconSize(handle: QComboBoxH; retval: PSize); cdecl; external Qt4PasLib name 'QComboBox_iconSize';
procedure QComboBox_setIconSize(handle: QComboBoxH; size: PSize); cdecl; external Qt4PasLib name 'QComboBox_setIconSize';
function QComboBox_isEditable(handle: QComboBoxH): Boolean; cdecl; external Qt4PasLib name 'QComboBox_isEditable';
procedure QComboBox_setEditable(handle: QComboBoxH; editable: Boolean); cdecl; external Qt4PasLib name 'QComboBox_setEditable';
procedure QComboBox_setLineEdit(handle: QComboBoxH; edit: QLineEditH); cdecl; external Qt4PasLib name 'QComboBox_setLineEdit';
function QComboBox_lineEdit(handle: QComboBoxH): QLineEditH; cdecl; external Qt4PasLib name 'QComboBox_lineEdit';
procedure QComboBox_setValidator(handle: QComboBoxH; v: QValidatorH); cdecl; external Qt4PasLib name 'QComboBox_setValidator';
function QComboBox_validator(handle: QComboBoxH): QValidatorH; cdecl; external Qt4PasLib name 'QComboBox_validator';
procedure QComboBox_setCompleter(handle: QComboBoxH; c: QCompleterH); cdecl; external Qt4PasLib name 'QComboBox_setCompleter';
function QComboBox_completer(handle: QComboBoxH): QCompleterH; cdecl; external Qt4PasLib name 'QComboBox_completer';
function QComboBox_itemDelegate(handle: QComboBoxH): QAbstractItemDelegateH; cdecl; external Qt4PasLib name 'QComboBox_itemDelegate';
procedure QComboBox_setItemDelegate(handle: QComboBoxH; delegate: QAbstractItemDelegateH); cdecl; external Qt4PasLib name 'QComboBox_setItemDelegate';
function QComboBox_model(handle: QComboBoxH): QAbstractItemModelH; cdecl; external Qt4PasLib name 'QComboBox_model';
procedure QComboBox_setModel(handle: QComboBoxH; model: QAbstractItemModelH); cdecl; external Qt4PasLib name 'QComboBox_setModel';
procedure QComboBox_rootModelIndex(handle: QComboBoxH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QComboBox_rootModelIndex';
procedure QComboBox_setRootModelIndex(handle: QComboBoxH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QComboBox_setRootModelIndex';
function QComboBox_modelColumn(handle: QComboBoxH): Integer; cdecl; external Qt4PasLib name 'QComboBox_modelColumn';
procedure QComboBox_setModelColumn(handle: QComboBoxH; visibleColumn: Integer); cdecl; external Qt4PasLib name 'QComboBox_setModelColumn';
function QComboBox_currentIndex(handle: QComboBoxH): Integer; cdecl; external Qt4PasLib name 'QComboBox_currentIndex';
procedure QComboBox_currentText(handle: QComboBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QComboBox_currentText';
procedure QComboBox_itemText(handle: QComboBoxH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QComboBox_itemText';
procedure QComboBox_itemIcon(handle: QComboBoxH; retval: QIconH; index: Integer); cdecl; external Qt4PasLib name 'QComboBox_itemIcon';
procedure QComboBox_itemData(handle: QComboBoxH; retval: QVariantH; index: Integer; role: QtItemDataRole = QtUserRole); cdecl; external Qt4PasLib name 'QComboBox_itemData';
procedure QComboBox_addItem(handle: QComboBoxH; text: PWideString; userData: QVariantH = nil); cdecl; external Qt4PasLib name 'QComboBox_addItem';
procedure QComboBox_addItem(handle: QComboBoxH; icon: QIconH; text: PWideString; userData: QVariantH = nil); cdecl; external Qt4PasLib name 'QComboBox_addItem2';
procedure QComboBox_addItems(handle: QComboBoxH; texts: QStringListH); cdecl; external Qt4PasLib name 'QComboBox_addItems';
procedure QComboBox_insertItem(handle: QComboBoxH; index: Integer; text: PWideString; userData: QVariantH = nil); cdecl; external Qt4PasLib name 'QComboBox_insertItem';
procedure QComboBox_insertItem(handle: QComboBoxH; index: Integer; icon: QIconH; text: PWideString; userData: QVariantH = nil); cdecl; external Qt4PasLib name 'QComboBox_insertItem2';
procedure QComboBox_insertItems(handle: QComboBoxH; index: Integer; texts: QStringListH); cdecl; external Qt4PasLib name 'QComboBox_insertItems';
procedure QComboBox_insertSeparator(handle: QComboBoxH; index: Integer); cdecl; external Qt4PasLib name 'QComboBox_insertSeparator';
procedure QComboBox_removeItem(handle: QComboBoxH; index: Integer); cdecl; external Qt4PasLib name 'QComboBox_removeItem';
procedure QComboBox_setItemText(handle: QComboBoxH; index: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QComboBox_setItemText';
procedure QComboBox_setItemIcon(handle: QComboBoxH; index: Integer; icon: QIconH); cdecl; external Qt4PasLib name 'QComboBox_setItemIcon';
procedure QComboBox_setItemData(handle: QComboBoxH; index: Integer; value: QVariantH; role: QtItemDataRole = QtUserRole); cdecl; external Qt4PasLib name 'QComboBox_setItemData';
function QComboBox_view(handle: QComboBoxH): QAbstractItemViewH; cdecl; external Qt4PasLib name 'QComboBox_view';
procedure QComboBox_setView(handle: QComboBoxH; itemView: QAbstractItemViewH); cdecl; external Qt4PasLib name 'QComboBox_setView';
procedure QComboBox_sizeHint(handle: QComboBoxH; retval: PSize); cdecl; external Qt4PasLib name 'QComboBox_sizeHint';
procedure QComboBox_minimumSizeHint(handle: QComboBoxH; retval: PSize); cdecl; external Qt4PasLib name 'QComboBox_minimumSizeHint';
procedure QComboBox_showPopup(handle: QComboBoxH); cdecl; external Qt4PasLib name 'QComboBox_showPopup';
procedure QComboBox_hidePopup(handle: QComboBoxH); cdecl; external Qt4PasLib name 'QComboBox_hidePopup';
function QComboBox_event(handle: QComboBoxH; event: QEventH): Boolean; cdecl; external Qt4PasLib name 'QComboBox_event';
procedure QComboBox_clear(handle: QComboBoxH); cdecl; external Qt4PasLib name 'QComboBox_clear';
procedure QComboBox_clearEditText(handle: QComboBoxH); cdecl; external Qt4PasLib name 'QComboBox_clearEditText';
procedure QComboBox_setEditText(handle: QComboBoxH; text: PWideString); cdecl; external Qt4PasLib name 'QComboBox_setEditText';
procedure QComboBox_setCurrentIndex(handle: QComboBoxH; index: Integer); cdecl; external Qt4PasLib name 'QComboBox_setCurrentIndex';


type
  QComboBox_editTextChanged_Event = procedure (p1: PWideString) of object cdecl;
  QComboBox_activated_Event = procedure (index: Integer) of object cdecl;
  QComboBox_activated2_Event = procedure (p1: PWideString) of object cdecl;
  QComboBox_highlighted_Event = procedure (index: Integer) of object cdecl;
  QComboBox_highlighted2_Event = procedure (p1: PWideString) of object cdecl;
  QComboBox_currentIndexChanged_Event = procedure (index: Integer) of object cdecl;
  QComboBox_currentIndexChanged2_Event = procedure (p1: PWideString) of object cdecl;


function QCheckBox_create(parent: QWidgetH = nil): QCheckBoxH; cdecl; external Qt4PasLib name 'QCheckBox_create';
procedure QCheckBox_destroy(handle: QCheckBoxH); cdecl; external Qt4PasLib name 'QCheckBox_destroy'; 
function QCheckBox_create(text: PWideString; parent: QWidgetH = nil): QCheckBoxH; cdecl; external Qt4PasLib name 'QCheckBox_create2';
procedure QCheckBox_sizeHint(handle: QCheckBoxH; retval: PSize); cdecl; external Qt4PasLib name 'QCheckBox_sizeHint';
procedure QCheckBox_setTristate(handle: QCheckBoxH; y: Boolean = True); cdecl; external Qt4PasLib name 'QCheckBox_setTristate';
function QCheckBox_isTristate(handle: QCheckBoxH): Boolean; cdecl; external Qt4PasLib name 'QCheckBox_isTristate';
function QCheckBox_checkState(handle: QCheckBoxH): QtCheckState; cdecl; external Qt4PasLib name 'QCheckBox_checkState';
procedure QCheckBox_setCheckState(handle: QCheckBoxH; state: QtCheckState); cdecl; external Qt4PasLib name 'QCheckBox_setCheckState';


type
  QCheckBox_stateChanged_Event = procedure (p1: Integer) of object cdecl;


type
  QSliderTickPosition = cardinal; //  QSlider::TickPosition (4)

const
    QSliderNoTicks = 0 { $0 };
    QSliderTicksAbove = 1 { $1 };
    QSliderTicksLeft = 1 { $1 };
    QSliderTicksBelow = 2 { $2 };
    QSliderTicksRight = 2 { $2 };
    QSliderTicksBothSides = 3 { $3 };


function QSlider_create(parent: QWidgetH = nil): QSliderH; cdecl; external Qt4PasLib name 'QSlider_create';
procedure QSlider_destroy(handle: QSliderH); cdecl; external Qt4PasLib name 'QSlider_destroy'; 
function QSlider_create(orientation: QtOrientation; parent: QWidgetH = nil): QSliderH; cdecl; external Qt4PasLib name 'QSlider_create2';
procedure QSlider_sizeHint(handle: QSliderH; retval: PSize); cdecl; external Qt4PasLib name 'QSlider_sizeHint';
procedure QSlider_minimumSizeHint(handle: QSliderH; retval: PSize); cdecl; external Qt4PasLib name 'QSlider_minimumSizeHint';
procedure QSlider_setTickPosition(handle: QSliderH; position: QSliderTickPosition); cdecl; external Qt4PasLib name 'QSlider_setTickPosition';
function QSlider_tickPosition(handle: QSliderH): QSliderTickPosition; cdecl; external Qt4PasLib name 'QSlider_tickPosition';
procedure QSlider_setTickInterval(handle: QSliderH; ti: Integer); cdecl; external Qt4PasLib name 'QSlider_setTickInterval';
function QSlider_tickInterval(handle: QSliderH): Integer; cdecl; external Qt4PasLib name 'QSlider_tickInterval';
function QSlider_event(handle: QSliderH; event: QEventH): Boolean; cdecl; external Qt4PasLib name 'QSlider_event';

function QTextBrowser_create(parent: QWidgetH = nil): QTextBrowserH; cdecl; external Qt4PasLib name 'QTextBrowser_create';
procedure QTextBrowser_destroy(handle: QTextBrowserH); cdecl; external Qt4PasLib name 'QTextBrowser_destroy'; 
procedure QTextBrowser_source(handle: QTextBrowserH; retval: QUrlH); cdecl; external Qt4PasLib name 'QTextBrowser_source';
procedure QTextBrowser_searchPaths(handle: QTextBrowserH; retval: QStringListH); cdecl; external Qt4PasLib name 'QTextBrowser_searchPaths';
procedure QTextBrowser_setSearchPaths(handle: QTextBrowserH; paths: QStringListH); cdecl; external Qt4PasLib name 'QTextBrowser_setSearchPaths';
procedure QTextBrowser_loadResource(handle: QTextBrowserH; retval: QVariantH; _type: Integer; name: QUrlH); cdecl; external Qt4PasLib name 'QTextBrowser_loadResource';
function QTextBrowser_isBackwardAvailable(handle: QTextBrowserH): Boolean; cdecl; external Qt4PasLib name 'QTextBrowser_isBackwardAvailable';
function QTextBrowser_isForwardAvailable(handle: QTextBrowserH): Boolean; cdecl; external Qt4PasLib name 'QTextBrowser_isForwardAvailable';
procedure QTextBrowser_clearHistory(handle: QTextBrowserH); cdecl; external Qt4PasLib name 'QTextBrowser_clearHistory';
procedure QTextBrowser_historyTitle(handle: QTextBrowserH; retval: PWideString; p1: Integer); cdecl; external Qt4PasLib name 'QTextBrowser_historyTitle';
procedure QTextBrowser_historyUrl(handle: QTextBrowserH; retval: QUrlH; p1: Integer); cdecl; external Qt4PasLib name 'QTextBrowser_historyUrl';
function QTextBrowser_backwardHistoryCount(handle: QTextBrowserH): Integer; cdecl; external Qt4PasLib name 'QTextBrowser_backwardHistoryCount';
function QTextBrowser_forwardHistoryCount(handle: QTextBrowserH): Integer; cdecl; external Qt4PasLib name 'QTextBrowser_forwardHistoryCount';
function QTextBrowser_openExternalLinks(handle: QTextBrowserH): Boolean; cdecl; external Qt4PasLib name 'QTextBrowser_openExternalLinks';
procedure QTextBrowser_setOpenExternalLinks(handle: QTextBrowserH; open: Boolean); cdecl; external Qt4PasLib name 'QTextBrowser_setOpenExternalLinks';
function QTextBrowser_openLinks(handle: QTextBrowserH): Boolean; cdecl; external Qt4PasLib name 'QTextBrowser_openLinks';
procedure QTextBrowser_setOpenLinks(handle: QTextBrowserH; open: Boolean); cdecl; external Qt4PasLib name 'QTextBrowser_setOpenLinks';
procedure QTextBrowser_setSource(handle: QTextBrowserH; name: QUrlH); cdecl; external Qt4PasLib name 'QTextBrowser_setSource';
procedure QTextBrowser_backward(handle: QTextBrowserH); cdecl; external Qt4PasLib name 'QTextBrowser_backward';
procedure QTextBrowser_forward(handle: QTextBrowserH); cdecl; external Qt4PasLib name 'QTextBrowser_forward';
procedure QTextBrowser_home(handle: QTextBrowserH); cdecl; external Qt4PasLib name 'QTextBrowser_home';
procedure QTextBrowser_reload(handle: QTextBrowserH); cdecl; external Qt4PasLib name 'QTextBrowser_reload';


type
  QTextBrowser_backwardAvailable_Event = procedure (p1: Boolean) of object cdecl;
  QTextBrowser_forwardAvailable_Event = procedure (p1: Boolean) of object cdecl;
  QTextBrowser_historyChanged_Event = procedure () of object cdecl;
  QTextBrowser_sourceChanged_Event = procedure (p1: QUrlH) of object cdecl;
  QTextBrowser_highlighted_Event = procedure (p1: QUrlH) of object cdecl;
  QTextBrowser_highlighted2_Event = procedure (p1: PWideString) of object cdecl;
  QTextBrowser_anchorClicked_Event = procedure (p1: QUrlH) of object cdecl;


function QLabel_create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QLabelH; cdecl; external Qt4PasLib name 'QLabel_create';
procedure QLabel_destroy(handle: QLabelH); cdecl; external Qt4PasLib name 'QLabel_destroy'; 
function QLabel_create(text: PWideString; parent: QWidgetH = nil; f: QtWindowFlags = 0): QLabelH; cdecl; external Qt4PasLib name 'QLabel_create2';
procedure QLabel_text(handle: QLabelH; retval: PWideString); cdecl; external Qt4PasLib name 'QLabel_text';
function QLabel_pixmap(handle: QLabelH): QPixmapH; cdecl; external Qt4PasLib name 'QLabel_pixmap';
function QLabel_picture(handle: QLabelH): QPictureH; cdecl; external Qt4PasLib name 'QLabel_picture';
function QLabel_movie(handle: QLabelH): QMovieH; cdecl; external Qt4PasLib name 'QLabel_movie';
function QLabel_textFormat(handle: QLabelH): QtTextFormat; cdecl; external Qt4PasLib name 'QLabel_textFormat';
procedure QLabel_setTextFormat(handle: QLabelH; p1: QtTextFormat); cdecl; external Qt4PasLib name 'QLabel_setTextFormat';
function QLabel_alignment(handle: QLabelH): QtAlignment; cdecl; external Qt4PasLib name 'QLabel_alignment';
procedure QLabel_setAlignment(handle: QLabelH; p1: QtAlignment); cdecl; external Qt4PasLib name 'QLabel_setAlignment';
procedure QLabel_setWordWrap(handle: QLabelH; _on: Boolean); cdecl; external Qt4PasLib name 'QLabel_setWordWrap';
function QLabel_wordWrap(handle: QLabelH): Boolean; cdecl; external Qt4PasLib name 'QLabel_wordWrap';
function QLabel_indent(handle: QLabelH): Integer; cdecl; external Qt4PasLib name 'QLabel_indent';
procedure QLabel_setIndent(handle: QLabelH; p1: Integer); cdecl; external Qt4PasLib name 'QLabel_setIndent';
function QLabel_margin(handle: QLabelH): Integer; cdecl; external Qt4PasLib name 'QLabel_margin';
procedure QLabel_setMargin(handle: QLabelH; p1: Integer); cdecl; external Qt4PasLib name 'QLabel_setMargin';
function QLabel_hasScaledContents(handle: QLabelH): Boolean; cdecl; external Qt4PasLib name 'QLabel_hasScaledContents';
procedure QLabel_setScaledContents(handle: QLabelH; p1: Boolean); cdecl; external Qt4PasLib name 'QLabel_setScaledContents';
procedure QLabel_sizeHint(handle: QLabelH; retval: PSize); cdecl; external Qt4PasLib name 'QLabel_sizeHint';
procedure QLabel_minimumSizeHint(handle: QLabelH; retval: PSize); cdecl; external Qt4PasLib name 'QLabel_minimumSizeHint';
procedure QLabel_setBuddy(handle: QLabelH; p1: QWidgetH); cdecl; external Qt4PasLib name 'QLabel_setBuddy';
function QLabel_buddy(handle: QLabelH): QWidgetH; cdecl; external Qt4PasLib name 'QLabel_buddy';
function QLabel_heightForWidth(handle: QLabelH; p1: Integer): Integer; cdecl; external Qt4PasLib name 'QLabel_heightForWidth';
function QLabel_openExternalLinks(handle: QLabelH): Boolean; cdecl; external Qt4PasLib name 'QLabel_openExternalLinks';
procedure QLabel_setOpenExternalLinks(handle: QLabelH; open: Boolean); cdecl; external Qt4PasLib name 'QLabel_setOpenExternalLinks';
procedure QLabel_setTextInteractionFlags(handle: QLabelH; flags: QtTextInteractionFlags); cdecl; external Qt4PasLib name 'QLabel_setTextInteractionFlags';
function QLabel_textInteractionFlags(handle: QLabelH): QtTextInteractionFlags; cdecl; external Qt4PasLib name 'QLabel_textInteractionFlags';
procedure QLabel_setText(handle: QLabelH; p1: PWideString); cdecl; external Qt4PasLib name 'QLabel_setText';
procedure QLabel_setPixmap(handle: QLabelH; p1: QPixmapH); cdecl; external Qt4PasLib name 'QLabel_setPixmap';
procedure QLabel_setPicture(handle: QLabelH; p1: QPictureH); cdecl; external Qt4PasLib name 'QLabel_setPicture';
procedure QLabel_setMovie(handle: QLabelH; movie: QMovieH); cdecl; external Qt4PasLib name 'QLabel_setMovie';
procedure QLabel_setNum(handle: QLabelH; p1: Integer); cdecl; external Qt4PasLib name 'QLabel_setNum';
procedure QLabel_setNum(handle: QLabelH; p1: Double); cdecl; external Qt4PasLib name 'QLabel_setNum2';
procedure QLabel_clear(handle: QLabelH); cdecl; external Qt4PasLib name 'QLabel_clear';


type
  QLabel_linkActivated_Event = procedure (link: PWideString) of object cdecl;
  QLabel_linkHovered_Event = procedure (link: PWideString) of object cdecl;


function QGroupBox_create(parent: QWidgetH = nil): QGroupBoxH; cdecl; external Qt4PasLib name 'QGroupBox_create';
procedure QGroupBox_destroy(handle: QGroupBoxH); cdecl; external Qt4PasLib name 'QGroupBox_destroy'; 
function QGroupBox_create(title: PWideString; parent: QWidgetH = nil): QGroupBoxH; cdecl; external Qt4PasLib name 'QGroupBox_create2';
procedure QGroupBox_title(handle: QGroupBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QGroupBox_title';
procedure QGroupBox_setTitle(handle: QGroupBoxH; title: PWideString); cdecl; external Qt4PasLib name 'QGroupBox_setTitle';
function QGroupBox_alignment(handle: QGroupBoxH): QtAlignment; cdecl; external Qt4PasLib name 'QGroupBox_alignment';
procedure QGroupBox_setAlignment(handle: QGroupBoxH; alignment: Integer); cdecl; external Qt4PasLib name 'QGroupBox_setAlignment';
procedure QGroupBox_minimumSizeHint(handle: QGroupBoxH; retval: PSize); cdecl; external Qt4PasLib name 'QGroupBox_minimumSizeHint';
function QGroupBox_isFlat(handle: QGroupBoxH): Boolean; cdecl; external Qt4PasLib name 'QGroupBox_isFlat';
procedure QGroupBox_setFlat(handle: QGroupBoxH; flat: Boolean); cdecl; external Qt4PasLib name 'QGroupBox_setFlat';
function QGroupBox_isCheckable(handle: QGroupBoxH): Boolean; cdecl; external Qt4PasLib name 'QGroupBox_isCheckable';
procedure QGroupBox_setCheckable(handle: QGroupBoxH; checkable: Boolean); cdecl; external Qt4PasLib name 'QGroupBox_setCheckable';
function QGroupBox_isChecked(handle: QGroupBoxH): Boolean; cdecl; external Qt4PasLib name 'QGroupBox_isChecked';
procedure QGroupBox_setChecked(handle: QGroupBoxH; checked: Boolean); cdecl; external Qt4PasLib name 'QGroupBox_setChecked';


type
  QGroupBox_clicked_Event = procedure (checked: Boolean = False) of object cdecl;
  QGroupBox_clicked2_Event = procedure () of object cdecl;
  QGroupBox_toggled_Event = procedure (p1: Boolean) of object cdecl;


type
  QDockWidgetDockWidgetFeature = cardinal; //  QDockWidget::DockWidgetFeature (4)
  QDockWidgetDockWidgetFeatures = QDockWidgetDockWidgetFeature; // QFlags<>

const
    QDockWidgetDockWidgetClosable = 1 { $1 };
    QDockWidgetDockWidgetMovable = 2 { $2 };
    QDockWidgetDockWidgetFloatable = 4 { $4 };
    QDockWidgetDockWidgetVerticalTitleBar = 8 { $8 };
    QDockWidgetDockWidgetFeatureMask = 15 { $f };
    QDockWidgetAllDockWidgetFeatures = 7 { $7 };
    QDockWidgetNoDockWidgetFeatures = 0 { $0 };
    QDockWidgetReserved = 255 { $ff };


function QDockWidget_create(title: PWideString; parent: QWidgetH = nil; flags: QtWindowFlags = 0): QDockWidgetH; cdecl; external Qt4PasLib name 'QDockWidget_create';
procedure QDockWidget_destroy(handle: QDockWidgetH); cdecl; external Qt4PasLib name 'QDockWidget_destroy'; 
function QDockWidget_create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QDockWidgetH; cdecl; external Qt4PasLib name 'QDockWidget_create2';
function QDockWidget_widget(handle: QDockWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QDockWidget_widget';
procedure QDockWidget_setWidget(handle: QDockWidgetH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QDockWidget_setWidget';
procedure QDockWidget_setFeatures(handle: QDockWidgetH; features: QDockWidgetDockWidgetFeatures); cdecl; external Qt4PasLib name 'QDockWidget_setFeatures';
function QDockWidget_features(handle: QDockWidgetH): QDockWidgetDockWidgetFeatures; cdecl; external Qt4PasLib name 'QDockWidget_features';
procedure QDockWidget_setFloating(handle: QDockWidgetH; floating: Boolean); cdecl; external Qt4PasLib name 'QDockWidget_setFloating';
function QDockWidget_isFloating(handle: QDockWidgetH): Boolean; cdecl; external Qt4PasLib name 'QDockWidget_isFloating';
procedure QDockWidget_setAllowedAreas(handle: QDockWidgetH; areas: QtDockWidgetAreas); cdecl; external Qt4PasLib name 'QDockWidget_setAllowedAreas';
function QDockWidget_allowedAreas(handle: QDockWidgetH): QtDockWidgetAreas; cdecl; external Qt4PasLib name 'QDockWidget_allowedAreas';
procedure QDockWidget_setTitleBarWidget(handle: QDockWidgetH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QDockWidget_setTitleBarWidget';
function QDockWidget_titleBarWidget(handle: QDockWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QDockWidget_titleBarWidget';
function QDockWidget_isAreaAllowed(handle: QDockWidgetH; area: QtDockWidgetArea): Boolean; cdecl; external Qt4PasLib name 'QDockWidget_isAreaAllowed';
function QDockWidget_toggleViewAction(handle: QDockWidgetH): QActionH; cdecl; external Qt4PasLib name 'QDockWidget_toggleViewAction';


type
  QDockWidget_featuresChanged_Event = procedure (features: QDockWidgetDockWidgetFeatures) of object cdecl;
  QDockWidget_topLevelChanged_Event = procedure (topLevel: Boolean) of object cdecl;
  QDockWidget_allowedAreasChanged_Event = procedure (allowedAreas: QtDockWidgetAreas) of object cdecl;
  QDockWidget_visibilityChanged_Event = procedure (visible: Boolean) of object cdecl;
  QDockWidget_dockLocationChanged_Event = procedure (area: QtDockWidgetArea) of object cdecl;



type
  QTabBarShape = ( // QTabBar::Shape (1)
    QTabBarRoundedNorth, QTabBarRoundedSouth, QTabBarRoundedWest, QTabBarRoundedEast, QTabBarTriangularNorth, QTabBarTriangularSouth, QTabBarTriangularWest, QTabBarTriangularEast );

  QTabBarButtonPosition = ( // QTabBar::ButtonPosition (1)
    QTabBarLeftSide, QTabBarRightSide );

  QTabBarSelectionBehavior = ( // QTabBar::SelectionBehavior (1)
    QTabBarSelectLeftTab, QTabBarSelectRightTab, QTabBarSelectPreviousTab );

function QTabBar_create(parent: QWidgetH = nil): QTabBarH; cdecl; external Qt4PasLib name 'QTabBar_create';
procedure QTabBar_destroy(handle: QTabBarH); cdecl; external Qt4PasLib name 'QTabBar_destroy'; 
function QTabBar_shape(handle: QTabBarH): QTabBarShape; cdecl; external Qt4PasLib name 'QTabBar_shape';
procedure QTabBar_setShape(handle: QTabBarH; shape: QTabBarShape); cdecl; external Qt4PasLib name 'QTabBar_setShape';
function QTabBar_addTab(handle: QTabBarH; text: PWideString): Integer; cdecl; external Qt4PasLib name 'QTabBar_addTab';
function QTabBar_addTab(handle: QTabBarH; icon: QIconH; text: PWideString): Integer; cdecl; external Qt4PasLib name 'QTabBar_addTab2';
function QTabBar_insertTab(handle: QTabBarH; index: Integer; text: PWideString): Integer; cdecl; external Qt4PasLib name 'QTabBar_insertTab';
function QTabBar_insertTab(handle: QTabBarH; index: Integer; icon: QIconH; text: PWideString): Integer; cdecl; external Qt4PasLib name 'QTabBar_insertTab2';
procedure QTabBar_removeTab(handle: QTabBarH; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_removeTab';
procedure QTabBar_moveTab(handle: QTabBarH; from: Integer; _to: Integer); cdecl; external Qt4PasLib name 'QTabBar_moveTab';
function QTabBar_isTabEnabled(handle: QTabBarH; index: Integer): Boolean; cdecl; external Qt4PasLib name 'QTabBar_isTabEnabled';
procedure QTabBar_setTabEnabled(handle: QTabBarH; index: Integer; p2: Boolean); cdecl; external Qt4PasLib name 'QTabBar_setTabEnabled';
procedure QTabBar_tabText(handle: QTabBarH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_tabText';
procedure QTabBar_setTabText(handle: QTabBarH; index: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QTabBar_setTabText';
procedure QTabBar_tabTextColor(handle: QTabBarH; retval: PQColor; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_tabTextColor';
procedure QTabBar_setTabTextColor(handle: QTabBarH; index: Integer; color: PQColor); cdecl; external Qt4PasLib name 'QTabBar_setTabTextColor';
procedure QTabBar_tabIcon(handle: QTabBarH; retval: QIconH; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_tabIcon';
procedure QTabBar_setTabIcon(handle: QTabBarH; index: Integer; icon: QIconH); cdecl; external Qt4PasLib name 'QTabBar_setTabIcon';
function QTabBar_elideMode(handle: QTabBarH): QtTextElideMode; cdecl; external Qt4PasLib name 'QTabBar_elideMode';
procedure QTabBar_setElideMode(handle: QTabBarH; p1: QtTextElideMode); cdecl; external Qt4PasLib name 'QTabBar_setElideMode';
procedure QTabBar_setTabToolTip(handle: QTabBarH; index: Integer; tip: PWideString); cdecl; external Qt4PasLib name 'QTabBar_setTabToolTip';
procedure QTabBar_tabToolTip(handle: QTabBarH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_tabToolTip';
procedure QTabBar_setTabWhatsThis(handle: QTabBarH; index: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QTabBar_setTabWhatsThis';
procedure QTabBar_tabWhatsThis(handle: QTabBarH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_tabWhatsThis';
procedure QTabBar_setTabData(handle: QTabBarH; index: Integer; data: QVariantH); cdecl; external Qt4PasLib name 'QTabBar_setTabData';
procedure QTabBar_tabData(handle: QTabBarH; retval: QVariantH; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_tabData';
procedure QTabBar_tabRect(handle: QTabBarH; retval: PRect; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_tabRect';
function QTabBar_tabAt(handle: QTabBarH; pos: PQtPoint): Integer; cdecl; external Qt4PasLib name 'QTabBar_tabAt';
function QTabBar_currentIndex(handle: QTabBarH): Integer; cdecl; external Qt4PasLib name 'QTabBar_currentIndex';
function QTabBar_count(handle: QTabBarH): Integer; cdecl; external Qt4PasLib name 'QTabBar_count';
procedure QTabBar_sizeHint(handle: QTabBarH; retval: PSize); cdecl; external Qt4PasLib name 'QTabBar_sizeHint';
procedure QTabBar_minimumSizeHint(handle: QTabBarH; retval: PSize); cdecl; external Qt4PasLib name 'QTabBar_minimumSizeHint';
procedure QTabBar_setDrawBase(handle: QTabBarH; drawTheBase: Boolean); cdecl; external Qt4PasLib name 'QTabBar_setDrawBase';
function QTabBar_drawBase(handle: QTabBarH): Boolean; cdecl; external Qt4PasLib name 'QTabBar_drawBase';
procedure QTabBar_iconSize(handle: QTabBarH; retval: PSize); cdecl; external Qt4PasLib name 'QTabBar_iconSize';
procedure QTabBar_setIconSize(handle: QTabBarH; size: PSize); cdecl; external Qt4PasLib name 'QTabBar_setIconSize';
function QTabBar_usesScrollButtons(handle: QTabBarH): Boolean; cdecl; external Qt4PasLib name 'QTabBar_usesScrollButtons';
procedure QTabBar_setUsesScrollButtons(handle: QTabBarH; useButtons: Boolean); cdecl; external Qt4PasLib name 'QTabBar_setUsesScrollButtons';
function QTabBar_tabsClosable(handle: QTabBarH): Boolean; cdecl; external Qt4PasLib name 'QTabBar_tabsClosable';
procedure QTabBar_setTabsClosable(handle: QTabBarH; closable: Boolean); cdecl; external Qt4PasLib name 'QTabBar_setTabsClosable';
procedure QTabBar_setTabButton(handle: QTabBarH; index: Integer; position: QTabBarButtonPosition; widget: QWidgetH); cdecl; external Qt4PasLib name 'QTabBar_setTabButton';
function QTabBar_tabButton(handle: QTabBarH; index: Integer; position: QTabBarButtonPosition): QWidgetH; cdecl; external Qt4PasLib name 'QTabBar_tabButton';
function QTabBar_selectionBehaviorOnRemove(handle: QTabBarH): QTabBarSelectionBehavior; cdecl; external Qt4PasLib name 'QTabBar_selectionBehaviorOnRemove';
procedure QTabBar_setSelectionBehaviorOnRemove(handle: QTabBarH; behavior: QTabBarSelectionBehavior); cdecl; external Qt4PasLib name 'QTabBar_setSelectionBehaviorOnRemove';
function QTabBar_expanding(handle: QTabBarH): Boolean; cdecl; external Qt4PasLib name 'QTabBar_expanding';
procedure QTabBar_setExpanding(handle: QTabBarH; enabled: Boolean); cdecl; external Qt4PasLib name 'QTabBar_setExpanding';
function QTabBar_isMovable(handle: QTabBarH): Boolean; cdecl; external Qt4PasLib name 'QTabBar_isMovable';
procedure QTabBar_setMovable(handle: QTabBarH; movable: Boolean); cdecl; external Qt4PasLib name 'QTabBar_setMovable';
function QTabBar_documentMode(handle: QTabBarH): Boolean; cdecl; external Qt4PasLib name 'QTabBar_documentMode';
procedure QTabBar_setDocumentMode(handle: QTabBarH; _set: Boolean); cdecl; external Qt4PasLib name 'QTabBar_setDocumentMode';
procedure QTabBar_setCurrentIndex(handle: QTabBarH; index: Integer); cdecl; external Qt4PasLib name 'QTabBar_setCurrentIndex';


type
  QTabBar_currentChanged_Event = procedure (index: Integer) of object cdecl;
  QTabBar_tabCloseRequested_Event = procedure (index: Integer) of object cdecl;
  QTabBar_tabMoved_Event = procedure (from: Integer; _to: Integer) of object cdecl;



type
  QProgressBarDirection = ( // QProgressBar::Direction (1)
    QProgressBarTopToBottom, QProgressBarBottomToTop );

function QProgressBar_create(parent: QWidgetH = nil): QProgressBarH; cdecl; external Qt4PasLib name 'QProgressBar_create';
procedure QProgressBar_destroy(handle: QProgressBarH); cdecl; external Qt4PasLib name 'QProgressBar_destroy'; 
function QProgressBar_minimum(handle: QProgressBarH): Integer; cdecl; external Qt4PasLib name 'QProgressBar_minimum';
function QProgressBar_maximum(handle: QProgressBarH): Integer; cdecl; external Qt4PasLib name 'QProgressBar_maximum';
function QProgressBar_value(handle: QProgressBarH): Integer; cdecl; external Qt4PasLib name 'QProgressBar_value';
procedure QProgressBar_text(handle: QProgressBarH; retval: PWideString); cdecl; external Qt4PasLib name 'QProgressBar_text';
procedure QProgressBar_setTextVisible(handle: QProgressBarH; visible: Boolean); cdecl; external Qt4PasLib name 'QProgressBar_setTextVisible';
function QProgressBar_isTextVisible(handle: QProgressBarH): Boolean; cdecl; external Qt4PasLib name 'QProgressBar_isTextVisible';
function QProgressBar_alignment(handle: QProgressBarH): QtAlignment; cdecl; external Qt4PasLib name 'QProgressBar_alignment';
procedure QProgressBar_setAlignment(handle: QProgressBarH; alignment: QtAlignment); cdecl; external Qt4PasLib name 'QProgressBar_setAlignment';
procedure QProgressBar_sizeHint(handle: QProgressBarH; retval: PSize); cdecl; external Qt4PasLib name 'QProgressBar_sizeHint';
procedure QProgressBar_minimumSizeHint(handle: QProgressBarH; retval: PSize); cdecl; external Qt4PasLib name 'QProgressBar_minimumSizeHint';
function QProgressBar_orientation(handle: QProgressBarH): QtOrientation; cdecl; external Qt4PasLib name 'QProgressBar_orientation';
procedure QProgressBar_setInvertedAppearance(handle: QProgressBarH; invert: Boolean); cdecl; external Qt4PasLib name 'QProgressBar_setInvertedAppearance';
function QProgressBar_invertedAppearance(handle: QProgressBarH): Boolean; cdecl; external Qt4PasLib name 'QProgressBar_invertedAppearance';
procedure QProgressBar_setTextDirection(handle: QProgressBarH; textDirection: QProgressBarDirection); cdecl; external Qt4PasLib name 'QProgressBar_setTextDirection';
function QProgressBar_textDirection(handle: QProgressBarH): QProgressBarDirection; cdecl; external Qt4PasLib name 'QProgressBar_textDirection';
procedure QProgressBar_setFormat(handle: QProgressBarH; format: PWideString); cdecl; external Qt4PasLib name 'QProgressBar_setFormat';
procedure QProgressBar_format(handle: QProgressBarH; retval: PWideString); cdecl; external Qt4PasLib name 'QProgressBar_format';
procedure QProgressBar_reset(handle: QProgressBarH); cdecl; external Qt4PasLib name 'QProgressBar_reset';
procedure QProgressBar_setRange(handle: QProgressBarH; minimum: Integer; maximum: Integer); cdecl; external Qt4PasLib name 'QProgressBar_setRange';
procedure QProgressBar_setMinimum(handle: QProgressBarH; minimum: Integer); cdecl; external Qt4PasLib name 'QProgressBar_setMinimum';
procedure QProgressBar_setMaximum(handle: QProgressBarH; maximum: Integer); cdecl; external Qt4PasLib name 'QProgressBar_setMaximum';
procedure QProgressBar_setValue(handle: QProgressBarH; value: Integer); cdecl; external Qt4PasLib name 'QProgressBar_setValue';
procedure QProgressBar_setOrientation(handle: QProgressBarH; p1: QtOrientation); cdecl; external Qt4PasLib name 'QProgressBar_setOrientation';


type
  QProgressBar_valueChanged_Event = procedure (value: Integer) of object cdecl;


function QStatusBar_create(parent: QWidgetH = nil): QStatusBarH; cdecl; external Qt4PasLib name 'QStatusBar_create';
procedure QStatusBar_destroy(handle: QStatusBarH); cdecl; external Qt4PasLib name 'QStatusBar_destroy'; 
procedure QStatusBar_addWidget(handle: QStatusBarH; widget: QWidgetH; stretch: Integer = 0); cdecl; external Qt4PasLib name 'QStatusBar_addWidget';
function QStatusBar_insertWidget(handle: QStatusBarH; index: Integer; widget: QWidgetH; stretch: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QStatusBar_insertWidget';
procedure QStatusBar_addPermanentWidget(handle: QStatusBarH; widget: QWidgetH; stretch: Integer = 0); cdecl; external Qt4PasLib name 'QStatusBar_addPermanentWidget';
function QStatusBar_insertPermanentWidget(handle: QStatusBarH; index: Integer; widget: QWidgetH; stretch: Integer = 0): Integer; cdecl; external Qt4PasLib name 'QStatusBar_insertPermanentWidget';
procedure QStatusBar_removeWidget(handle: QStatusBarH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QStatusBar_removeWidget';
procedure QStatusBar_setSizeGripEnabled(handle: QStatusBarH; p1: Boolean); cdecl; external Qt4PasLib name 'QStatusBar_setSizeGripEnabled';
function QStatusBar_isSizeGripEnabled(handle: QStatusBarH): Boolean; cdecl; external Qt4PasLib name 'QStatusBar_isSizeGripEnabled';
procedure QStatusBar_currentMessage(handle: QStatusBarH; retval: PWideString); cdecl; external Qt4PasLib name 'QStatusBar_currentMessage';
procedure QStatusBar_showMessage(handle: QStatusBarH; text: PWideString; timeout: Integer = 0); cdecl; external Qt4PasLib name 'QStatusBar_showMessage';
procedure QStatusBar_clearMessage(handle: QStatusBarH); cdecl; external Qt4PasLib name 'QStatusBar_clearMessage';


type
  QStatusBar_messageChanged_Event = procedure (text: PWideString) of object cdecl;


function QToolBox_create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QToolBoxH; cdecl; external Qt4PasLib name 'QToolBox_create';
procedure QToolBox_destroy(handle: QToolBoxH); cdecl; external Qt4PasLib name 'QToolBox_destroy'; 
function QToolBox_addItem(handle: QToolBoxH; widget: QWidgetH; text: PWideString): Integer; cdecl; external Qt4PasLib name 'QToolBox_addItem';
function QToolBox_addItem(handle: QToolBoxH; widget: QWidgetH; icon: QIconH; text: PWideString): Integer; cdecl; external Qt4PasLib name 'QToolBox_addItem2';
function QToolBox_insertItem(handle: QToolBoxH; index: Integer; widget: QWidgetH; text: PWideString): Integer; cdecl; external Qt4PasLib name 'QToolBox_insertItem';
function QToolBox_insertItem(handle: QToolBoxH; index: Integer; widget: QWidgetH; icon: QIconH; text: PWideString): Integer; cdecl; external Qt4PasLib name 'QToolBox_insertItem2';
procedure QToolBox_removeItem(handle: QToolBoxH; index: Integer); cdecl; external Qt4PasLib name 'QToolBox_removeItem';
procedure QToolBox_setItemEnabled(handle: QToolBoxH; index: Integer; enabled: Boolean); cdecl; external Qt4PasLib name 'QToolBox_setItemEnabled';
function QToolBox_isItemEnabled(handle: QToolBoxH; index: Integer): Boolean; cdecl; external Qt4PasLib name 'QToolBox_isItemEnabled';
procedure QToolBox_setItemText(handle: QToolBoxH; index: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QToolBox_setItemText';
procedure QToolBox_itemText(handle: QToolBoxH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QToolBox_itemText';
procedure QToolBox_setItemIcon(handle: QToolBoxH; index: Integer; icon: QIconH); cdecl; external Qt4PasLib name 'QToolBox_setItemIcon';
procedure QToolBox_itemIcon(handle: QToolBoxH; retval: QIconH; index: Integer); cdecl; external Qt4PasLib name 'QToolBox_itemIcon';
procedure QToolBox_setItemToolTip(handle: QToolBoxH; index: Integer; toolTip: PWideString); cdecl; external Qt4PasLib name 'QToolBox_setItemToolTip';
procedure QToolBox_itemToolTip(handle: QToolBoxH; retval: PWideString; index: Integer); cdecl; external Qt4PasLib name 'QToolBox_itemToolTip';
function QToolBox_currentIndex(handle: QToolBoxH): Integer; cdecl; external Qt4PasLib name 'QToolBox_currentIndex';
function QToolBox_currentWidget(handle: QToolBoxH): QWidgetH; cdecl; external Qt4PasLib name 'QToolBox_currentWidget';
function QToolBox_widget(handle: QToolBoxH; index: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QToolBox_widget';
function QToolBox_indexOf(handle: QToolBoxH; widget: QWidgetH): Integer; cdecl; external Qt4PasLib name 'QToolBox_indexOf';
function QToolBox_count(handle: QToolBoxH): Integer; cdecl; external Qt4PasLib name 'QToolBox_count';
procedure QToolBox_setCurrentIndex(handle: QToolBoxH; index: Integer); cdecl; external Qt4PasLib name 'QToolBox_setCurrentIndex';
procedure QToolBox_setCurrentWidget(handle: QToolBoxH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QToolBox_setCurrentWidget';


type
  QToolBox_currentChanged_Event = procedure (index: Integer) of object cdecl;



type
  QToolButtonToolButtonPopupMode = ( // QToolButton::ToolButtonPopupMode (1)
    QToolButtonDelayedPopup, QToolButtonMenuButtonPopup, QToolButtonInstantPopup );

function QToolButton_create(parent: QWidgetH = nil): QToolButtonH; cdecl; external Qt4PasLib name 'QToolButton_create';
procedure QToolButton_destroy(handle: QToolButtonH); cdecl; external Qt4PasLib name 'QToolButton_destroy'; 
procedure QToolButton_sizeHint(handle: QToolButtonH; retval: PSize); cdecl; external Qt4PasLib name 'QToolButton_sizeHint';
procedure QToolButton_minimumSizeHint(handle: QToolButtonH; retval: PSize); cdecl; external Qt4PasLib name 'QToolButton_minimumSizeHint';
function QToolButton_toolButtonStyle(handle: QToolButtonH): QtToolButtonStyle; cdecl; external Qt4PasLib name 'QToolButton_toolButtonStyle';
function QToolButton_arrowType(handle: QToolButtonH): QtArrowType; cdecl; external Qt4PasLib name 'QToolButton_arrowType';
procedure QToolButton_setArrowType(handle: QToolButtonH; _type: QtArrowType); cdecl; external Qt4PasLib name 'QToolButton_setArrowType';
procedure QToolButton_setMenu(handle: QToolButtonH; menu: QMenuH); cdecl; external Qt4PasLib name 'QToolButton_setMenu';
function QToolButton_menu(handle: QToolButtonH): QMenuH; cdecl; external Qt4PasLib name 'QToolButton_menu';
procedure QToolButton_setPopupMode(handle: QToolButtonH; mode: QToolButtonToolButtonPopupMode); cdecl; external Qt4PasLib name 'QToolButton_setPopupMode';
function QToolButton_popupMode(handle: QToolButtonH): QToolButtonToolButtonPopupMode; cdecl; external Qt4PasLib name 'QToolButton_popupMode';
function QToolButton_defaultAction(handle: QToolButtonH): QActionH; cdecl; external Qt4PasLib name 'QToolButton_defaultAction';
procedure QToolButton_setAutoRaise(handle: QToolButtonH; enable: Boolean); cdecl; external Qt4PasLib name 'QToolButton_setAutoRaise';
function QToolButton_autoRaise(handle: QToolButtonH): Boolean; cdecl; external Qt4PasLib name 'QToolButton_autoRaise';
procedure QToolButton_showMenu(handle: QToolButtonH); cdecl; external Qt4PasLib name 'QToolButton_showMenu';
procedure QToolButton_setToolButtonStyle(handle: QToolButtonH; style: QtToolButtonStyle); cdecl; external Qt4PasLib name 'QToolButton_setToolButtonStyle';
procedure QToolButton_setDefaultAction(handle: QToolButtonH; p1: QActionH); cdecl; external Qt4PasLib name 'QToolButton_setDefaultAction';


type
  QToolButton_triggered_Event = procedure (p1: QActionH) of object cdecl;


function QScrollArea_create(parent: QWidgetH = nil): QScrollAreaH; cdecl; external Qt4PasLib name 'QScrollArea_create';
procedure QScrollArea_destroy(handle: QScrollAreaH); cdecl; external Qt4PasLib name 'QScrollArea_destroy'; 
function QScrollArea_widget(handle: QScrollAreaH): QWidgetH; cdecl; external Qt4PasLib name 'QScrollArea_widget';
procedure QScrollArea_setWidget(handle: QScrollAreaH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QScrollArea_setWidget';
function QScrollArea_takeWidget(handle: QScrollAreaH): QWidgetH; cdecl; external Qt4PasLib name 'QScrollArea_takeWidget';
function QScrollArea_widgetResizable(handle: QScrollAreaH): Boolean; cdecl; external Qt4PasLib name 'QScrollArea_widgetResizable';
procedure QScrollArea_setWidgetResizable(handle: QScrollAreaH; resizable: Boolean); cdecl; external Qt4PasLib name 'QScrollArea_setWidgetResizable';
procedure QScrollArea_sizeHint(handle: QScrollAreaH; retval: PSize); cdecl; external Qt4PasLib name 'QScrollArea_sizeHint';
function QScrollArea_focusNextPrevChild(handle: QScrollAreaH; next: Boolean): Boolean; cdecl; external Qt4PasLib name 'QScrollArea_focusNextPrevChild';
function QScrollArea_alignment(handle: QScrollAreaH): QtAlignment; cdecl; external Qt4PasLib name 'QScrollArea_alignment';
procedure QScrollArea_setAlignment(handle: QScrollAreaH; p1: QtAlignment); cdecl; external Qt4PasLib name 'QScrollArea_setAlignment';
procedure QScrollArea_ensureVisible(handle: QScrollAreaH; x: Integer; y: Integer; xmargin: Integer = 50; ymargin: Integer = 50); cdecl; external Qt4PasLib name 'QScrollArea_ensureVisible';
procedure QScrollArea_ensureWidgetVisible(handle: QScrollAreaH; childWidget: QWidgetH; xmargin: Integer = 50; ymargin: Integer = 50); cdecl; external Qt4PasLib name 'QScrollArea_ensureWidgetVisible';


type
  QMdiAreaWindowOrder = ( // QMdiArea::WindowOrder (1)
    QMdiAreaCreationOrder, QMdiAreaStackingOrder, QMdiAreaActivationHistoryOrder );

  QMdiAreaViewMode = ( // QMdiArea::ViewMode (1)
    QMdiAreaSubWindowView, QMdiAreaTabbedView );

type
  QMdiAreaAreaOption = cardinal; // QMdiArea::AreaOption
  QMdiAreaAreaOptions = QMdiAreaAreaOption; //QFlags<> (3)
const
  QMdiAreaDontMaximizeSubWindowOnActivation =   $1;

function QMdiArea_create(parent: QWidgetH = nil): QMdiAreaH; cdecl; external Qt4PasLib name 'QMdiArea_create';
procedure QMdiArea_destroy(handle: QMdiAreaH); cdecl; external Qt4PasLib name 'QMdiArea_destroy'; 
procedure QMdiArea_sizeHint(handle: QMdiAreaH; retval: PSize); cdecl; external Qt4PasLib name 'QMdiArea_sizeHint';
procedure QMdiArea_minimumSizeHint(handle: QMdiAreaH; retval: PSize); cdecl; external Qt4PasLib name 'QMdiArea_minimumSizeHint';
function QMdiArea_currentSubWindow(handle: QMdiAreaH): QMdiSubWindowH; cdecl; external Qt4PasLib name 'QMdiArea_currentSubWindow';
function QMdiArea_activeSubWindow(handle: QMdiAreaH): QMdiSubWindowH; cdecl; external Qt4PasLib name 'QMdiArea_activeSubWindow';
procedure QMdiArea_subWindowList(handle: QMdiAreaH; retval: PPtrIntArray; order: QMdiAreaWindowOrder = QMdiAreaCreationOrder); cdecl; external Qt4PasLib name 'QMdiArea_subWindowList';
function QMdiArea_addSubWindow(handle: QMdiAreaH; widget: QWidgetH; flags: QtWindowFlags = 0): QMdiSubWindowH; cdecl; external Qt4PasLib name 'QMdiArea_addSubWindow';
procedure QMdiArea_removeSubWindow(handle: QMdiAreaH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QMdiArea_removeSubWindow';
procedure QMdiArea_background(handle: QMdiAreaH; retval: QBrushH); cdecl; external Qt4PasLib name 'QMdiArea_background';
procedure QMdiArea_setBackground(handle: QMdiAreaH; background: QBrushH); cdecl; external Qt4PasLib name 'QMdiArea_setBackground';
function QMdiArea_activationOrder(handle: QMdiAreaH): QMdiAreaWindowOrder; cdecl; external Qt4PasLib name 'QMdiArea_activationOrder';
procedure QMdiArea_setActivationOrder(handle: QMdiAreaH; order: QMdiAreaWindowOrder); cdecl; external Qt4PasLib name 'QMdiArea_setActivationOrder';
procedure QMdiArea_setOption(handle: QMdiAreaH; option: QMdiAreaAreaOption; _on: Boolean = True); cdecl; external Qt4PasLib name 'QMdiArea_setOption';
function QMdiArea_testOption(handle: QMdiAreaH; opton: QMdiAreaAreaOption): Boolean; cdecl; external Qt4PasLib name 'QMdiArea_testOption';
procedure QMdiArea_setViewMode(handle: QMdiAreaH; mode: QMdiAreaViewMode); cdecl; external Qt4PasLib name 'QMdiArea_setViewMode';
function QMdiArea_viewMode(handle: QMdiAreaH): QMdiAreaViewMode; cdecl; external Qt4PasLib name 'QMdiArea_viewMode';
function QMdiArea_documentMode(handle: QMdiAreaH): Boolean; cdecl; external Qt4PasLib name 'QMdiArea_documentMode';
procedure QMdiArea_setDocumentMode(handle: QMdiAreaH; enabled: Boolean); cdecl; external Qt4PasLib name 'QMdiArea_setDocumentMode';
procedure QMdiArea_setTabShape(handle: QMdiAreaH; shape: QTabWidgetTabShape); cdecl; external Qt4PasLib name 'QMdiArea_setTabShape';
function QMdiArea_tabShape(handle: QMdiAreaH): QTabWidgetTabShape; cdecl; external Qt4PasLib name 'QMdiArea_tabShape';
procedure QMdiArea_setTabPosition(handle: QMdiAreaH; position: QTabWidgetTabPosition); cdecl; external Qt4PasLib name 'QMdiArea_setTabPosition';
function QMdiArea_tabPosition(handle: QMdiAreaH): QTabWidgetTabPosition; cdecl; external Qt4PasLib name 'QMdiArea_tabPosition';
procedure QMdiArea_setActiveSubWindow(handle: QMdiAreaH; window: QMdiSubWindowH); cdecl; external Qt4PasLib name 'QMdiArea_setActiveSubWindow';
procedure QMdiArea_tileSubWindows(handle: QMdiAreaH); cdecl; external Qt4PasLib name 'QMdiArea_tileSubWindows';
procedure QMdiArea_cascadeSubWindows(handle: QMdiAreaH); cdecl; external Qt4PasLib name 'QMdiArea_cascadeSubWindows';
procedure QMdiArea_closeActiveSubWindow(handle: QMdiAreaH); cdecl; external Qt4PasLib name 'QMdiArea_closeActiveSubWindow';
procedure QMdiArea_closeAllSubWindows(handle: QMdiAreaH); cdecl; external Qt4PasLib name 'QMdiArea_closeAllSubWindows';
procedure QMdiArea_activateNextSubWindow(handle: QMdiAreaH); cdecl; external Qt4PasLib name 'QMdiArea_activateNextSubWindow';
procedure QMdiArea_activatePreviousSubWindow(handle: QMdiAreaH); cdecl; external Qt4PasLib name 'QMdiArea_activatePreviousSubWindow';


type
  QMdiArea_subWindowActivated_Event = procedure (p1: QMdiSubWindowH) of object cdecl;


type
  QMdiSubWindowSubWindowOption = cardinal; // QMdiSubWindow::SubWindowOption
  QMdiSubWindowSubWindowOptions = QMdiSubWindowSubWindowOption; //QFlags<> (3)
const
  QMdiSubWindowAllowOutsideAreaHorizontally =   $1;
  QMdiSubWindowAllowOutsideAreaVertically =   $2;
  QMdiSubWindowRubberBandResize =   $4;
  QMdiSubWindowRubberBandMove =   $8;

function QMdiSubWindow_create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QMdiSubWindowH; cdecl; external Qt4PasLib name 'QMdiSubWindow_create';
procedure QMdiSubWindow_destroy(handle: QMdiSubWindowH); cdecl; external Qt4PasLib name 'QMdiSubWindow_destroy'; 
procedure QMdiSubWindow_sizeHint(handle: QMdiSubWindowH; retval: PSize); cdecl; external Qt4PasLib name 'QMdiSubWindow_sizeHint';
procedure QMdiSubWindow_minimumSizeHint(handle: QMdiSubWindowH; retval: PSize); cdecl; external Qt4PasLib name 'QMdiSubWindow_minimumSizeHint';
procedure QMdiSubWindow_setWidget(handle: QMdiSubWindowH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QMdiSubWindow_setWidget';
function QMdiSubWindow_widget(handle: QMdiSubWindowH): QWidgetH; cdecl; external Qt4PasLib name 'QMdiSubWindow_widget';
function QMdiSubWindow_maximizedButtonsWidget(handle: QMdiSubWindowH): QWidgetH; cdecl; external Qt4PasLib name 'QMdiSubWindow_maximizedButtonsWidget';
function QMdiSubWindow_maximizedSystemMenuIconWidget(handle: QMdiSubWindowH): QWidgetH; cdecl; external Qt4PasLib name 'QMdiSubWindow_maximizedSystemMenuIconWidget';
function QMdiSubWindow_isShaded(handle: QMdiSubWindowH): Boolean; cdecl; external Qt4PasLib name 'QMdiSubWindow_isShaded';
procedure QMdiSubWindow_setOption(handle: QMdiSubWindowH; option: QMdiSubWindowSubWindowOption; _on: Boolean = True); cdecl; external Qt4PasLib name 'QMdiSubWindow_setOption';
function QMdiSubWindow_testOption(handle: QMdiSubWindowH; p1: QMdiSubWindowSubWindowOption): Boolean; cdecl; external Qt4PasLib name 'QMdiSubWindow_testOption';
procedure QMdiSubWindow_setKeyboardSingleStep(handle: QMdiSubWindowH; step: Integer); cdecl; external Qt4PasLib name 'QMdiSubWindow_setKeyboardSingleStep';
function QMdiSubWindow_keyboardSingleStep(handle: QMdiSubWindowH): Integer; cdecl; external Qt4PasLib name 'QMdiSubWindow_keyboardSingleStep';
procedure QMdiSubWindow_setKeyboardPageStep(handle: QMdiSubWindowH; step: Integer); cdecl; external Qt4PasLib name 'QMdiSubWindow_setKeyboardPageStep';
function QMdiSubWindow_keyboardPageStep(handle: QMdiSubWindowH): Integer; cdecl; external Qt4PasLib name 'QMdiSubWindow_keyboardPageStep';
procedure QMdiSubWindow_setSystemMenu(handle: QMdiSubWindowH; systemMenu: QMenuH); cdecl; external Qt4PasLib name 'QMdiSubWindow_setSystemMenu';
function QMdiSubWindow_systemMenu(handle: QMdiSubWindowH): QMenuH; cdecl; external Qt4PasLib name 'QMdiSubWindow_systemMenu';
function QMdiSubWindow_mdiArea(handle: QMdiSubWindowH): QMdiAreaH; cdecl; external Qt4PasLib name 'QMdiSubWindow_mdiArea';
procedure QMdiSubWindow_showSystemMenu(handle: QMdiSubWindowH); cdecl; external Qt4PasLib name 'QMdiSubWindow_showSystemMenu';
procedure QMdiSubWindow_showShaded(handle: QMdiSubWindowH); cdecl; external Qt4PasLib name 'QMdiSubWindow_showShaded';


type
  QMdiSubWindow_windowStateChanged_Event = procedure (oldState: QtWindowStates; newState: QtWindowStates) of object cdecl;
  QMdiSubWindow_aboutToActivate_Event = procedure () of object cdecl;



type
  QCalendarWidgetHorizontalHeaderFormat = ( // QCalendarWidget::HorizontalHeaderFormat (1)
    QCalendarWidgetNoHorizontalHeader, QCalendarWidgetSingleLetterDayNames, QCalendarWidgetShortDayNames, QCalendarWidgetLongDayNames );

  QCalendarWidgetVerticalHeaderFormat = ( // QCalendarWidget::VerticalHeaderFormat (1)
    QCalendarWidgetNoVerticalHeader, QCalendarWidgetISOWeekNumbers );

  QCalendarWidgetSelectionMode = ( // QCalendarWidget::SelectionMode (1)
    QCalendarWidgetNoSelection, QCalendarWidgetSingleSelection );

function QCalendarWidget_create(parent: QWidgetH = nil): QCalendarWidgetH; cdecl; external Qt4PasLib name 'QCalendarWidget_create';
procedure QCalendarWidget_destroy(handle: QCalendarWidgetH); cdecl; external Qt4PasLib name 'QCalendarWidget_destroy'; 
procedure QCalendarWidget_sizeHint(handle: QCalendarWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QCalendarWidget_sizeHint';
procedure QCalendarWidget_minimumSizeHint(handle: QCalendarWidgetH; retval: PSize); cdecl; external Qt4PasLib name 'QCalendarWidget_minimumSizeHint';
procedure QCalendarWidget_selectedDate(handle: QCalendarWidgetH; retval: QDateH); cdecl; external Qt4PasLib name 'QCalendarWidget_selectedDate';
function QCalendarWidget_yearShown(handle: QCalendarWidgetH): Integer; cdecl; external Qt4PasLib name 'QCalendarWidget_yearShown';
function QCalendarWidget_monthShown(handle: QCalendarWidgetH): Integer; cdecl; external Qt4PasLib name 'QCalendarWidget_monthShown';
procedure QCalendarWidget_minimumDate(handle: QCalendarWidgetH; retval: QDateH); cdecl; external Qt4PasLib name 'QCalendarWidget_minimumDate';
procedure QCalendarWidget_setMinimumDate(handle: QCalendarWidgetH; date: QDateH); cdecl; external Qt4PasLib name 'QCalendarWidget_setMinimumDate';
procedure QCalendarWidget_maximumDate(handle: QCalendarWidgetH; retval: QDateH); cdecl; external Qt4PasLib name 'QCalendarWidget_maximumDate';
procedure QCalendarWidget_setMaximumDate(handle: QCalendarWidgetH; date: QDateH); cdecl; external Qt4PasLib name 'QCalendarWidget_setMaximumDate';
function QCalendarWidget_firstDayOfWeek(handle: QCalendarWidgetH): QtDayOfWeek; cdecl; external Qt4PasLib name 'QCalendarWidget_firstDayOfWeek';
procedure QCalendarWidget_setFirstDayOfWeek(handle: QCalendarWidgetH; dayOfWeek: QtDayOfWeek); cdecl; external Qt4PasLib name 'QCalendarWidget_setFirstDayOfWeek';
function QCalendarWidget_isHeaderVisible(handle: QCalendarWidgetH): Boolean; cdecl; external Qt4PasLib name 'QCalendarWidget_isHeaderVisible';
procedure QCalendarWidget_setHeaderVisible(handle: QCalendarWidgetH; show: Boolean); cdecl; external Qt4PasLib name 'QCalendarWidget_setHeaderVisible';
function QCalendarWidget_isNavigationBarVisible(handle: QCalendarWidgetH): Boolean; cdecl; external Qt4PasLib name 'QCalendarWidget_isNavigationBarVisible';
function QCalendarWidget_isGridVisible(handle: QCalendarWidgetH): Boolean; cdecl; external Qt4PasLib name 'QCalendarWidget_isGridVisible';
function QCalendarWidget_selectionMode(handle: QCalendarWidgetH): QCalendarWidgetSelectionMode; cdecl; external Qt4PasLib name 'QCalendarWidget_selectionMode';
procedure QCalendarWidget_setSelectionMode(handle: QCalendarWidgetH; mode: QCalendarWidgetSelectionMode); cdecl; external Qt4PasLib name 'QCalendarWidget_setSelectionMode';
function QCalendarWidget_horizontalHeaderFormat(handle: QCalendarWidgetH): QCalendarWidgetHorizontalHeaderFormat; cdecl; external Qt4PasLib name 'QCalendarWidget_horizontalHeaderFormat';
procedure QCalendarWidget_setHorizontalHeaderFormat(handle: QCalendarWidgetH; format: QCalendarWidgetHorizontalHeaderFormat); cdecl; external Qt4PasLib name 'QCalendarWidget_setHorizontalHeaderFormat';
function QCalendarWidget_verticalHeaderFormat(handle: QCalendarWidgetH): QCalendarWidgetVerticalHeaderFormat; cdecl; external Qt4PasLib name 'QCalendarWidget_verticalHeaderFormat';
procedure QCalendarWidget_setVerticalHeaderFormat(handle: QCalendarWidgetH; format: QCalendarWidgetVerticalHeaderFormat); cdecl; external Qt4PasLib name 'QCalendarWidget_setVerticalHeaderFormat';
procedure QCalendarWidget_headerTextFormat(handle: QCalendarWidgetH; retval: QTextCharFormatH); cdecl; external Qt4PasLib name 'QCalendarWidget_headerTextFormat';
procedure QCalendarWidget_setHeaderTextFormat(handle: QCalendarWidgetH; format: QTextCharFormatH); cdecl; external Qt4PasLib name 'QCalendarWidget_setHeaderTextFormat';
procedure QCalendarWidget_weekdayTextFormat(handle: QCalendarWidgetH; retval: QTextCharFormatH; dayOfWeek: QtDayOfWeek); cdecl; external Qt4PasLib name 'QCalendarWidget_weekdayTextFormat';
procedure QCalendarWidget_setWeekdayTextFormat(handle: QCalendarWidgetH; dayOfWeek: QtDayOfWeek; format: QTextCharFormatH); cdecl; external Qt4PasLib name 'QCalendarWidget_setWeekdayTextFormat';
procedure QCalendarWidget_dateTextFormat(handle: QCalendarWidgetH; retval: QTextCharFormatH; date: QDateH); cdecl; external Qt4PasLib name 'QCalendarWidget_dateTextFormat2';
procedure QCalendarWidget_setDateTextFormat(handle: QCalendarWidgetH; date: QDateH; format: QTextCharFormatH); cdecl; external Qt4PasLib name 'QCalendarWidget_setDateTextFormat';
function QCalendarWidget_isDateEditEnabled(handle: QCalendarWidgetH): Boolean; cdecl; external Qt4PasLib name 'QCalendarWidget_isDateEditEnabled';
procedure QCalendarWidget_setDateEditEnabled(handle: QCalendarWidgetH; enable: Boolean); cdecl; external Qt4PasLib name 'QCalendarWidget_setDateEditEnabled';
function QCalendarWidget_dateEditAcceptDelay(handle: QCalendarWidgetH): Integer; cdecl; external Qt4PasLib name 'QCalendarWidget_dateEditAcceptDelay';
procedure QCalendarWidget_setDateEditAcceptDelay(handle: QCalendarWidgetH; delay: Integer); cdecl; external Qt4PasLib name 'QCalendarWidget_setDateEditAcceptDelay';
procedure QCalendarWidget_setSelectedDate(handle: QCalendarWidgetH; date: QDateH); cdecl; external Qt4PasLib name 'QCalendarWidget_setSelectedDate';
procedure QCalendarWidget_setDateRange(handle: QCalendarWidgetH; min: QDateH; max: QDateH); cdecl; external Qt4PasLib name 'QCalendarWidget_setDateRange';
procedure QCalendarWidget_setCurrentPage(handle: QCalendarWidgetH; year: Integer; month: Integer); cdecl; external Qt4PasLib name 'QCalendarWidget_setCurrentPage';
procedure QCalendarWidget_setGridVisible(handle: QCalendarWidgetH; show: Boolean); cdecl; external Qt4PasLib name 'QCalendarWidget_setGridVisible';
procedure QCalendarWidget_setNavigationBarVisible(handle: QCalendarWidgetH; visible: Boolean); cdecl; external Qt4PasLib name 'QCalendarWidget_setNavigationBarVisible';
procedure QCalendarWidget_showNextMonth(handle: QCalendarWidgetH); cdecl; external Qt4PasLib name 'QCalendarWidget_showNextMonth';
procedure QCalendarWidget_showPreviousMonth(handle: QCalendarWidgetH); cdecl; external Qt4PasLib name 'QCalendarWidget_showPreviousMonth';
procedure QCalendarWidget_showNextYear(handle: QCalendarWidgetH); cdecl; external Qt4PasLib name 'QCalendarWidget_showNextYear';
procedure QCalendarWidget_showPreviousYear(handle: QCalendarWidgetH); cdecl; external Qt4PasLib name 'QCalendarWidget_showPreviousYear';
procedure QCalendarWidget_showSelectedDate(handle: QCalendarWidgetH); cdecl; external Qt4PasLib name 'QCalendarWidget_showSelectedDate';
procedure QCalendarWidget_showToday(handle: QCalendarWidgetH); cdecl; external Qt4PasLib name 'QCalendarWidget_showToday';


type
  QCalendarWidget_selectionChanged_Event = procedure () of object cdecl;
  QCalendarWidget_clicked_Event = procedure (date: QDateH) of object cdecl;
  QCalendarWidget_activated_Event = procedure (date: QDateH) of object cdecl;
  QCalendarWidget_currentPageChanged_Event = procedure (year: Integer; month: Integer) of object cdecl;



type
  QRubberBandShape = ( // QRubberBand::Shape (1)
    QRubberBandLine, QRubberBandRectangle );

function QRubberBand_create(p1: QRubberBandShape; p2: QWidgetH = nil): QRubberBandH; cdecl; external Qt4PasLib name 'QRubberBand_create';
procedure QRubberBand_destroy(handle: QRubberBandH); cdecl; external Qt4PasLib name 'QRubberBand_destroy'; 
function QRubberBand_shape(handle: QRubberBandH): QRubberBandShape; cdecl; external Qt4PasLib name 'QRubberBand_shape';
procedure QRubberBand_setGeometry(handle: QRubberBandH; r: PRect); cdecl; external Qt4PasLib name 'QRubberBand_setGeometry';
procedure QRubberBand_setGeometry(handle: QRubberBandH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QRubberBand_setGeometry2';
procedure QRubberBand_move(handle: QRubberBandH; x: Integer; y: Integer); cdecl; external Qt4PasLib name 'QRubberBand_move';
procedure QRubberBand_move(handle: QRubberBandH; p: PQtPoint); cdecl; external Qt4PasLib name 'QRubberBand_move2';
procedure QRubberBand_resize(handle: QRubberBandH; w: Integer; h: Integer); cdecl; external Qt4PasLib name 'QRubberBand_resize';
procedure QRubberBand_resize(handle: QRubberBandH; s: PSize); cdecl; external Qt4PasLib name 'QRubberBand_resize2';


type
  QPrintPreviewWidgetViewMode = ( // QPrintPreviewWidget::ViewMode (1)
    QPrintPreviewWidgetSinglePageView, QPrintPreviewWidgetFacingPagesView, QPrintPreviewWidgetAllPagesView );

  QPrintPreviewWidgetZoomMode = ( // QPrintPreviewWidget::ZoomMode (1)
    QPrintPreviewWidgetCustomZoom, QPrintPreviewWidgetFitToWidth, QPrintPreviewWidgetFitInView );

function QPrintPreviewWidget_create(printer: QPrinterH; parent: QWidgetH = nil; flags: QtWindowFlags = 0): QPrintPreviewWidgetH; cdecl; external Qt4PasLib name 'QPrintPreviewWidget_create';
procedure QPrintPreviewWidget_destroy(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_destroy'; 
function QPrintPreviewWidget_create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QPrintPreviewWidgetH; cdecl; external Qt4PasLib name 'QPrintPreviewWidget_create2';
function QPrintPreviewWidget_zoomFactor(handle: QPrintPreviewWidgetH): qreal; cdecl; external Qt4PasLib name 'QPrintPreviewWidget_zoomFactor';
function QPrintPreviewWidget_orientation(handle: QPrintPreviewWidgetH): QPrinterOrientation; cdecl; external Qt4PasLib name 'QPrintPreviewWidget_orientation';
function QPrintPreviewWidget_viewMode(handle: QPrintPreviewWidgetH): QPrintPreviewWidgetViewMode; cdecl; external Qt4PasLib name 'QPrintPreviewWidget_viewMode';
function QPrintPreviewWidget_zoomMode(handle: QPrintPreviewWidgetH): QPrintPreviewWidgetZoomMode; cdecl; external Qt4PasLib name 'QPrintPreviewWidget_zoomMode';
function QPrintPreviewWidget_currentPage(handle: QPrintPreviewWidgetH): Integer; cdecl; external Qt4PasLib name 'QPrintPreviewWidget_currentPage';
function QPrintPreviewWidget_numPages(handle: QPrintPreviewWidgetH): Integer; cdecl; external Qt4PasLib name 'QPrintPreviewWidget_numPages';
procedure QPrintPreviewWidget_setVisible(handle: QPrintPreviewWidgetH; visible: Boolean); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setVisible';
procedure QPrintPreviewWidget_print(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_print';
procedure QPrintPreviewWidget_zoomIn(handle: QPrintPreviewWidgetH; zoom: qreal = 1.1000000000000001); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_zoomIn';
procedure QPrintPreviewWidget_zoomOut(handle: QPrintPreviewWidgetH; zoom: qreal = 1.1000000000000001); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_zoomOut';
procedure QPrintPreviewWidget_setZoomFactor(handle: QPrintPreviewWidgetH; zoomFactor: qreal); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setZoomFactor';
procedure QPrintPreviewWidget_setOrientation(handle: QPrintPreviewWidgetH; orientation: QPrinterOrientation); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setOrientation';
procedure QPrintPreviewWidget_setViewMode(handle: QPrintPreviewWidgetH; viewMode: QPrintPreviewWidgetViewMode); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setViewMode';
procedure QPrintPreviewWidget_setZoomMode(handle: QPrintPreviewWidgetH; zoomMode: QPrintPreviewWidgetZoomMode); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setZoomMode';
procedure QPrintPreviewWidget_setCurrentPage(handle: QPrintPreviewWidgetH; pageNumber: Integer); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setCurrentPage';
procedure QPrintPreviewWidget_fitToWidth(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_fitToWidth';
procedure QPrintPreviewWidget_fitInView(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_fitInView';
procedure QPrintPreviewWidget_setLandscapeOrientation(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setLandscapeOrientation';
procedure QPrintPreviewWidget_setPortraitOrientation(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setPortraitOrientation';
procedure QPrintPreviewWidget_setSinglePageViewMode(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setSinglePageViewMode';
procedure QPrintPreviewWidget_setFacingPagesViewMode(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setFacingPagesViewMode';
procedure QPrintPreviewWidget_setAllPagesViewMode(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_setAllPagesViewMode';
procedure QPrintPreviewWidget_updatePreview(handle: QPrintPreviewWidgetH); cdecl; external Qt4PasLib name 'QPrintPreviewWidget_updatePreview';


type
  QPrintPreviewWidget_paintRequested_Event = procedure (printer: QPrinterH) of object cdecl;
  QPrintPreviewWidget_previewChanged_Event = procedure () of object cdecl;



type
  QAbstractItemViewSelectionMode = ( // QAbstractItemView::SelectionMode (1)
    QAbstractItemViewNoSelection, QAbstractItemViewSingleSelection, QAbstractItemViewMultiSelection, QAbstractItemViewExtendedSelection, QAbstractItemViewContiguousSelection );

  QAbstractItemViewSelectionBehavior = ( // QAbstractItemView::SelectionBehavior (1)
    QAbstractItemViewSelectItems, QAbstractItemViewSelectRows, QAbstractItemViewSelectColumns );

  QAbstractItemViewScrollHint = ( // QAbstractItemView::ScrollHint (1)
    QAbstractItemViewEnsureVisible, QAbstractItemViewPositionAtTop, QAbstractItemViewPositionAtBottom, QAbstractItemViewPositionAtCenter );

  QAbstractItemViewScrollMode = ( // QAbstractItemView::ScrollMode (1)
    QAbstractItemViewScrollPerItem, QAbstractItemViewScrollPerPixel );

  QAbstractItemViewDragDropMode = ( // QAbstractItemView::DragDropMode (1)
    QAbstractItemViewNoDragDrop, QAbstractItemViewDragOnly, QAbstractItemViewDropOnly, QAbstractItemViewDragDrop, QAbstractItemViewInternalMove );

type
  QAbstractItemViewEditTrigger = cardinal; // QAbstractItemView::EditTrigger
  QAbstractItemViewEditTriggers = QAbstractItemViewEditTrigger; //QFlags<> (3)
const
  QAbstractItemViewNoEditTriggers =   0;
  QAbstractItemViewCurrentChanged =   1;
  QAbstractItemViewDoubleClicked =   2;
  QAbstractItemViewSelectedClicked =   4;
  QAbstractItemViewEditKeyPressed =   8;
  QAbstractItemViewAnyKeyPressed =   16;
  QAbstractItemViewAllEditTriggers =   31;

procedure QAbstractItemView_setModel(handle: QAbstractItemViewH; model: QAbstractItemModelH); cdecl; external Qt4PasLib name 'QAbstractItemView_setModel';
function QAbstractItemView_model(handle: QAbstractItemViewH): QAbstractItemModelH; cdecl; external Qt4PasLib name 'QAbstractItemView_model';
procedure QAbstractItemView_setSelectionModel(handle: QAbstractItemViewH; selectionModel: QItemSelectionModelH); cdecl; external Qt4PasLib name 'QAbstractItemView_setSelectionModel';
function QAbstractItemView_selectionModel(handle: QAbstractItemViewH): QItemSelectionModelH; cdecl; external Qt4PasLib name 'QAbstractItemView_selectionModel';
procedure QAbstractItemView_setItemDelegate(handle: QAbstractItemViewH; delegate: QAbstractItemDelegateH); cdecl; external Qt4PasLib name 'QAbstractItemView_setItemDelegate';
function QAbstractItemView_itemDelegate(handle: QAbstractItemViewH): QAbstractItemDelegateH; cdecl; external Qt4PasLib name 'QAbstractItemView_itemDelegate';
procedure QAbstractItemView_setSelectionMode(handle: QAbstractItemViewH; mode: QAbstractItemViewSelectionMode); cdecl; external Qt4PasLib name 'QAbstractItemView_setSelectionMode';
function QAbstractItemView_selectionMode(handle: QAbstractItemViewH): QAbstractItemViewSelectionMode; cdecl; external Qt4PasLib name 'QAbstractItemView_selectionMode';
procedure QAbstractItemView_setSelectionBehavior(handle: QAbstractItemViewH; behavior: QAbstractItemViewSelectionBehavior); cdecl; external Qt4PasLib name 'QAbstractItemView_setSelectionBehavior';
function QAbstractItemView_selectionBehavior(handle: QAbstractItemViewH): QAbstractItemViewSelectionBehavior; cdecl; external Qt4PasLib name 'QAbstractItemView_selectionBehavior';
procedure QAbstractItemView_currentIndex(handle: QAbstractItemViewH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_currentIndex';
procedure QAbstractItemView_rootIndex(handle: QAbstractItemViewH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_rootIndex';
procedure QAbstractItemView_setEditTriggers(handle: QAbstractItemViewH; triggers: QAbstractItemViewEditTriggers); cdecl; external Qt4PasLib name 'QAbstractItemView_setEditTriggers';
function QAbstractItemView_editTriggers(handle: QAbstractItemViewH): QAbstractItemViewEditTriggers; cdecl; external Qt4PasLib name 'QAbstractItemView_editTriggers';
procedure QAbstractItemView_setVerticalScrollMode(handle: QAbstractItemViewH; mode: QAbstractItemViewScrollMode); cdecl; external Qt4PasLib name 'QAbstractItemView_setVerticalScrollMode';
function QAbstractItemView_verticalScrollMode(handle: QAbstractItemViewH): QAbstractItemViewScrollMode; cdecl; external Qt4PasLib name 'QAbstractItemView_verticalScrollMode';
procedure QAbstractItemView_setHorizontalScrollMode(handle: QAbstractItemViewH; mode: QAbstractItemViewScrollMode); cdecl; external Qt4PasLib name 'QAbstractItemView_setHorizontalScrollMode';
function QAbstractItemView_horizontalScrollMode(handle: QAbstractItemViewH): QAbstractItemViewScrollMode; cdecl; external Qt4PasLib name 'QAbstractItemView_horizontalScrollMode';
procedure QAbstractItemView_setAutoScroll(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QAbstractItemView_setAutoScroll';
function QAbstractItemView_hasAutoScroll(handle: QAbstractItemViewH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemView_hasAutoScroll';
procedure QAbstractItemView_setAutoScrollMargin(handle: QAbstractItemViewH; margin: Integer); cdecl; external Qt4PasLib name 'QAbstractItemView_setAutoScrollMargin';
function QAbstractItemView_autoScrollMargin(handle: QAbstractItemViewH): Integer; cdecl; external Qt4PasLib name 'QAbstractItemView_autoScrollMargin';
procedure QAbstractItemView_setTabKeyNavigation(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QAbstractItemView_setTabKeyNavigation';
function QAbstractItemView_tabKeyNavigation(handle: QAbstractItemViewH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemView_tabKeyNavigation';
procedure QAbstractItemView_setDropIndicatorShown(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QAbstractItemView_setDropIndicatorShown';
function QAbstractItemView_showDropIndicator(handle: QAbstractItemViewH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemView_showDropIndicator';
procedure QAbstractItemView_setDragEnabled(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QAbstractItemView_setDragEnabled';
function QAbstractItemView_dragEnabled(handle: QAbstractItemViewH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemView_dragEnabled';
procedure QAbstractItemView_setDragDropOverwriteMode(handle: QAbstractItemViewH; overwrite: Boolean); cdecl; external Qt4PasLib name 'QAbstractItemView_setDragDropOverwriteMode';
function QAbstractItemView_dragDropOverwriteMode(handle: QAbstractItemViewH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemView_dragDropOverwriteMode';
procedure QAbstractItemView_setDragDropMode(handle: QAbstractItemViewH; behavior: QAbstractItemViewDragDropMode); cdecl; external Qt4PasLib name 'QAbstractItemView_setDragDropMode';
function QAbstractItemView_dragDropMode(handle: QAbstractItemViewH): QAbstractItemViewDragDropMode; cdecl; external Qt4PasLib name 'QAbstractItemView_dragDropMode';
procedure QAbstractItemView_setAlternatingRowColors(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QAbstractItemView_setAlternatingRowColors';
function QAbstractItemView_alternatingRowColors(handle: QAbstractItemViewH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemView_alternatingRowColors';
procedure QAbstractItemView_setIconSize(handle: QAbstractItemViewH; size: PSize); cdecl; external Qt4PasLib name 'QAbstractItemView_setIconSize';
procedure QAbstractItemView_iconSize(handle: QAbstractItemViewH; retval: PSize); cdecl; external Qt4PasLib name 'QAbstractItemView_iconSize';
procedure QAbstractItemView_setTextElideMode(handle: QAbstractItemViewH; mode: QtTextElideMode); cdecl; external Qt4PasLib name 'QAbstractItemView_setTextElideMode';
function QAbstractItemView_textElideMode(handle: QAbstractItemViewH): QtTextElideMode; cdecl; external Qt4PasLib name 'QAbstractItemView_textElideMode';
procedure QAbstractItemView_keyboardSearch(handle: QAbstractItemViewH; search: PWideString); cdecl; external Qt4PasLib name 'QAbstractItemView_keyboardSearch';
procedure QAbstractItemView_visualRect(handle: QAbstractItemViewH; retval: PRect; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_visualRect';
procedure QAbstractItemView_scrollTo(handle: QAbstractItemViewH; index: QModelIndexH; hint: QAbstractItemViewScrollHint = QAbstractItemViewEnsureVisible); cdecl; external Qt4PasLib name 'QAbstractItemView_scrollTo';
procedure QAbstractItemView_indexAt(handle: QAbstractItemViewH; retval: QModelIndexH; point: PQtPoint); cdecl; external Qt4PasLib name 'QAbstractItemView_indexAt';
procedure QAbstractItemView_sizeHintForIndex(handle: QAbstractItemViewH; retval: PSize; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_sizeHintForIndex';
function QAbstractItemView_sizeHintForRow(handle: QAbstractItemViewH; row: Integer): Integer; cdecl; external Qt4PasLib name 'QAbstractItemView_sizeHintForRow';
function QAbstractItemView_sizeHintForColumn(handle: QAbstractItemViewH; column: Integer): Integer; cdecl; external Qt4PasLib name 'QAbstractItemView_sizeHintForColumn';
procedure QAbstractItemView_openPersistentEditor(handle: QAbstractItemViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_openPersistentEditor';
procedure QAbstractItemView_closePersistentEditor(handle: QAbstractItemViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_closePersistentEditor';
procedure QAbstractItemView_setIndexWidget(handle: QAbstractItemViewH; index: QModelIndexH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QAbstractItemView_setIndexWidget';
function QAbstractItemView_indexWidget(handle: QAbstractItemViewH; index: QModelIndexH): QWidgetH; cdecl; external Qt4PasLib name 'QAbstractItemView_indexWidget';
procedure QAbstractItemView_setItemDelegateForRow(handle: QAbstractItemViewH; row: Integer; delegate: QAbstractItemDelegateH); cdecl; external Qt4PasLib name 'QAbstractItemView_setItemDelegateForRow';
function QAbstractItemView_itemDelegateForRow(handle: QAbstractItemViewH; row: Integer): QAbstractItemDelegateH; cdecl; external Qt4PasLib name 'QAbstractItemView_itemDelegateForRow';
procedure QAbstractItemView_setItemDelegateForColumn(handle: QAbstractItemViewH; column: Integer; delegate: QAbstractItemDelegateH); cdecl; external Qt4PasLib name 'QAbstractItemView_setItemDelegateForColumn';
function QAbstractItemView_itemDelegateForColumn(handle: QAbstractItemViewH; column: Integer): QAbstractItemDelegateH; cdecl; external Qt4PasLib name 'QAbstractItemView_itemDelegateForColumn';
function QAbstractItemView_itemDelegate(handle: QAbstractItemViewH; index: QModelIndexH): QAbstractItemDelegateH; cdecl; external Qt4PasLib name 'QAbstractItemView_itemDelegate2';
procedure QAbstractItemView_inputMethodQuery(handle: QAbstractItemViewH; retval: QVariantH; query: QtInputMethodQuery); cdecl; external Qt4PasLib name 'QAbstractItemView_inputMethodQuery';
procedure QAbstractItemView_reset(handle: QAbstractItemViewH); cdecl; external Qt4PasLib name 'QAbstractItemView_reset';
procedure QAbstractItemView_setRootIndex(handle: QAbstractItemViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_setRootIndex';
procedure QAbstractItemView_doItemsLayout(handle: QAbstractItemViewH); cdecl; external Qt4PasLib name 'QAbstractItemView_doItemsLayout';
procedure QAbstractItemView_selectAll(handle: QAbstractItemViewH); cdecl; external Qt4PasLib name 'QAbstractItemView_selectAll';
procedure QAbstractItemView_edit(handle: QAbstractItemViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_edit';
procedure QAbstractItemView_clearSelection(handle: QAbstractItemViewH); cdecl; external Qt4PasLib name 'QAbstractItemView_clearSelection';
procedure QAbstractItemView_setCurrentIndex(handle: QAbstractItemViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_setCurrentIndex';
procedure QAbstractItemView_scrollToTop(handle: QAbstractItemViewH); cdecl; external Qt4PasLib name 'QAbstractItemView_scrollToTop';
procedure QAbstractItemView_scrollToBottom(handle: QAbstractItemViewH); cdecl; external Qt4PasLib name 'QAbstractItemView_scrollToBottom';
procedure QAbstractItemView_update(handle: QAbstractItemViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemView_update';


type
  QAbstractItemView_pressed_Event = procedure (index: QModelIndexH) of object cdecl;
  QAbstractItemView_clicked_Event = procedure (index: QModelIndexH) of object cdecl;
  QAbstractItemView_doubleClicked_Event = procedure (index: QModelIndexH) of object cdecl;
  QAbstractItemView_activated_Event = procedure (index: QModelIndexH) of object cdecl;
  QAbstractItemView_entered_Event = procedure (index: QModelIndexH) of object cdecl;
  QAbstractItemView_viewportEntered_Event = procedure () of object cdecl;



type
  QListViewMovement = ( // QListView::Movement (1)
    QListViewStatic, QListViewFree, QListViewSnap );

  QListViewFlow = ( // QListView::Flow (1)
    QListViewLeftToRight, QListViewTopToBottom );

  QListViewResizeMode = ( // QListView::ResizeMode (1)
    QListViewFixed, QListViewAdjust );

  QListViewLayoutMode = ( // QListView::LayoutMode (1)
    QListViewSinglePass, QListViewBatched );

  QListViewViewMode = ( // QListView::ViewMode (1)
    QListViewListMode, QListViewIconMode );

function QListView_create(parent: QWidgetH = nil): QListViewH; cdecl; external Qt4PasLib name 'QListView_create';
procedure QListView_destroy(handle: QListViewH); cdecl; external Qt4PasLib name 'QListView_destroy'; 
procedure QListView_setMovement(handle: QListViewH; movement: QListViewMovement); cdecl; external Qt4PasLib name 'QListView_setMovement';
function QListView_movement(handle: QListViewH): QListViewMovement; cdecl; external Qt4PasLib name 'QListView_movement';
procedure QListView_setFlow(handle: QListViewH; flow: QListViewFlow); cdecl; external Qt4PasLib name 'QListView_setFlow';
function QListView_flow(handle: QListViewH): QListViewFlow; cdecl; external Qt4PasLib name 'QListView_flow';
procedure QListView_setWrapping(handle: QListViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QListView_setWrapping';
function QListView_isWrapping(handle: QListViewH): Boolean; cdecl; external Qt4PasLib name 'QListView_isWrapping';
procedure QListView_setResizeMode(handle: QListViewH; mode: QListViewResizeMode); cdecl; external Qt4PasLib name 'QListView_setResizeMode';
function QListView_resizeMode(handle: QListViewH): QListViewResizeMode; cdecl; external Qt4PasLib name 'QListView_resizeMode';
procedure QListView_setLayoutMode(handle: QListViewH; mode: QListViewLayoutMode); cdecl; external Qt4PasLib name 'QListView_setLayoutMode';
function QListView_layoutMode(handle: QListViewH): QListViewLayoutMode; cdecl; external Qt4PasLib name 'QListView_layoutMode';
procedure QListView_setSpacing(handle: QListViewH; space: Integer); cdecl; external Qt4PasLib name 'QListView_setSpacing';
function QListView_spacing(handle: QListViewH): Integer; cdecl; external Qt4PasLib name 'QListView_spacing';
procedure QListView_setBatchSize(handle: QListViewH; batchSize: Integer); cdecl; external Qt4PasLib name 'QListView_setBatchSize';
function QListView_batchSize(handle: QListViewH): Integer; cdecl; external Qt4PasLib name 'QListView_batchSize';
procedure QListView_setGridSize(handle: QListViewH; size: PSize); cdecl; external Qt4PasLib name 'QListView_setGridSize';
procedure QListView_gridSize(handle: QListViewH; retval: PSize); cdecl; external Qt4PasLib name 'QListView_gridSize';
procedure QListView_setViewMode(handle: QListViewH; mode: QListViewViewMode); cdecl; external Qt4PasLib name 'QListView_setViewMode';
function QListView_viewMode(handle: QListViewH): QListViewViewMode; cdecl; external Qt4PasLib name 'QListView_viewMode';
procedure QListView_clearPropertyFlags(handle: QListViewH); cdecl; external Qt4PasLib name 'QListView_clearPropertyFlags';
function QListView_isRowHidden(handle: QListViewH; row: Integer): Boolean; cdecl; external Qt4PasLib name 'QListView_isRowHidden';
procedure QListView_setRowHidden(handle: QListViewH; row: Integer; hide: Boolean); cdecl; external Qt4PasLib name 'QListView_setRowHidden';
procedure QListView_setModelColumn(handle: QListViewH; column: Integer); cdecl; external Qt4PasLib name 'QListView_setModelColumn';
function QListView_modelColumn(handle: QListViewH): Integer; cdecl; external Qt4PasLib name 'QListView_modelColumn';
procedure QListView_setUniformItemSizes(handle: QListViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QListView_setUniformItemSizes';
function QListView_uniformItemSizes(handle: QListViewH): Boolean; cdecl; external Qt4PasLib name 'QListView_uniformItemSizes';
procedure QListView_setWordWrap(handle: QListViewH; _on: Boolean); cdecl; external Qt4PasLib name 'QListView_setWordWrap';
function QListView_wordWrap(handle: QListViewH): Boolean; cdecl; external Qt4PasLib name 'QListView_wordWrap';
procedure QListView_setSelectionRectVisible(handle: QListViewH; show: Boolean); cdecl; external Qt4PasLib name 'QListView_setSelectionRectVisible';
function QListView_isSelectionRectVisible(handle: QListViewH): Boolean; cdecl; external Qt4PasLib name 'QListView_isSelectionRectVisible';
procedure QListView_visualRect(handle: QListViewH; retval: PRect; index: QModelIndexH); cdecl; external Qt4PasLib name 'QListView_visualRect';
procedure QListView_scrollTo(handle: QListViewH; index: QModelIndexH; hint: QAbstractItemViewScrollHint); cdecl; external Qt4PasLib name 'QListView_scrollTo';
procedure QListView_indexAt(handle: QListViewH; retval: QModelIndexH; p: PQtPoint); cdecl; external Qt4PasLib name 'QListView_indexAt';
procedure QListView_doItemsLayout(handle: QListViewH); cdecl; external Qt4PasLib name 'QListView_doItemsLayout';
procedure QListView_reset(handle: QListViewH); cdecl; external Qt4PasLib name 'QListView_reset';
procedure QListView_setRootIndex(handle: QListViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QListView_setRootIndex';

type
  QItemSelectionModelSelectionFlag = cardinal; //  QItemSelectionModel::SelectionFlag (4)
  QItemSelectionModelSelectionFlags = QItemSelectionModelSelectionFlag; // QFlags<>

const
    QItemSelectionModelNoUpdate = 0 { $0 };
    QItemSelectionModelClear = 1 { $1 };
    QItemSelectionModelSelect = 2 { $2 };
    QItemSelectionModelDeselect = 4 { $4 };
    QItemSelectionModelToggle = 8 { $8 };
    QItemSelectionModelCurrent = 16 { $10 };
    QItemSelectionModelRows = 32 { $20 };
    QItemSelectionModelColumns = 64 { $40 };
    QItemSelectionModelSelectCurrent = 18 { $12 };
    QItemSelectionModelToggleCurrent = 24 { $18 };
    QItemSelectionModelClearAndSelect = 3 { $3 };


function QItemSelectionRange_create(): QItemSelectionRangeH; cdecl; external Qt4PasLib name 'QItemSelectionRange_create';
procedure QItemSelectionRange_destroy(handle: QItemSelectionRangeH); cdecl; external Qt4PasLib name 'QItemSelectionRange_destroy'; 
function QItemSelectionRange_create(other: QItemSelectionRangeH): QItemSelectionRangeH; cdecl; external Qt4PasLib name 'QItemSelectionRange_create2';
function QItemSelectionRange_create(topLeft: QModelIndexH; bottomRight: QModelIndexH): QItemSelectionRangeH; cdecl; external Qt4PasLib name 'QItemSelectionRange_create3';
function QItemSelectionRange_create(index: QModelIndexH): QItemSelectionRangeH; cdecl; external Qt4PasLib name 'QItemSelectionRange_create4';
function QItemSelectionRange_top(handle: QItemSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QItemSelectionRange_top';
function QItemSelectionRange_left(handle: QItemSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QItemSelectionRange_left';
function QItemSelectionRange_bottom(handle: QItemSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QItemSelectionRange_bottom';
function QItemSelectionRange_right(handle: QItemSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QItemSelectionRange_right';
function QItemSelectionRange_width(handle: QItemSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QItemSelectionRange_width';
function QItemSelectionRange_height(handle: QItemSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QItemSelectionRange_height';
procedure QItemSelectionRange_topLeft(handle: QItemSelectionRangeH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QItemSelectionRange_topLeft';
procedure QItemSelectionRange_bottomRight(handle: QItemSelectionRangeH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QItemSelectionRange_bottomRight';
procedure QItemSelectionRange_parent(handle: QItemSelectionRangeH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QItemSelectionRange_parent';
function QItemSelectionRange_model(handle: QItemSelectionRangeH): QAbstractItemModelH; cdecl; external Qt4PasLib name 'QItemSelectionRange_model';
function QItemSelectionRange_contains(handle: QItemSelectionRangeH; index: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionRange_contains';
function QItemSelectionRange_contains(handle: QItemSelectionRangeH; row: Integer; column: Integer; parentIndex: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionRange_contains2';
function QItemSelectionRange_intersects(handle: QItemSelectionRangeH; other: QItemSelectionRangeH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionRange_intersects';
procedure QItemSelectionRange_intersect(handle: QItemSelectionRangeH; retval: QItemSelectionRangeH; other: QItemSelectionRangeH); cdecl; external Qt4PasLib name 'QItemSelectionRange_intersect';
procedure QItemSelectionRange_intersected(handle: QItemSelectionRangeH; retval: QItemSelectionRangeH; other: QItemSelectionRangeH); cdecl; external Qt4PasLib name 'QItemSelectionRange_intersected';
function QItemSelectionRange_isValid(handle: QItemSelectionRangeH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionRange_isValid';
procedure QItemSelectionRange_indexes(handle: QItemSelectionRangeH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QItemSelectionRange_indexes';

function QItemSelectionModel_create(model: QAbstractItemModelH): QItemSelectionModelH; cdecl; external Qt4PasLib name 'QItemSelectionModel_create';
procedure QItemSelectionModel_destroy(handle: QItemSelectionModelH); cdecl; external Qt4PasLib name 'QItemSelectionModel_destroy'; 
function QItemSelectionModel_create(model: QAbstractItemModelH; parent: QObjectH): QItemSelectionModelH; cdecl; external Qt4PasLib name 'QItemSelectionModel_create2';
procedure QItemSelectionModel_currentIndex(handle: QItemSelectionModelH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QItemSelectionModel_currentIndex';
function QItemSelectionModel_isSelected(handle: QItemSelectionModelH; index: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionModel_isSelected';
function QItemSelectionModel_isRowSelected(handle: QItemSelectionModelH; row: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionModel_isRowSelected';
function QItemSelectionModel_isColumnSelected(handle: QItemSelectionModelH; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionModel_isColumnSelected';
function QItemSelectionModel_rowIntersectsSelection(handle: QItemSelectionModelH; row: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionModel_rowIntersectsSelection';
function QItemSelectionModel_columnIntersectsSelection(handle: QItemSelectionModelH; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionModel_columnIntersectsSelection';
function QItemSelectionModel_hasSelection(handle: QItemSelectionModelH): Boolean; cdecl; external Qt4PasLib name 'QItemSelectionModel_hasSelection';
procedure QItemSelectionModel_selectedIndexes(handle: QItemSelectionModelH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QItemSelectionModel_selectedIndexes';
procedure QItemSelectionModel_selectedRows(handle: QItemSelectionModelH; retval: PPtrIntArray; column: Integer = 0); cdecl; external Qt4PasLib name 'QItemSelectionModel_selectedRows';
procedure QItemSelectionModel_selectedColumns(handle: QItemSelectionModelH; retval: PPtrIntArray; row: Integer = 0); cdecl; external Qt4PasLib name 'QItemSelectionModel_selectedColumns';
function QItemSelectionModel_model(handle: QItemSelectionModelH): QAbstractItemModelH; cdecl; external Qt4PasLib name 'QItemSelectionModel_model';
procedure QItemSelectionModel_setCurrentIndex(handle: QItemSelectionModelH; index: QModelIndexH; command: QItemSelectionModelSelectionFlags); cdecl; external Qt4PasLib name 'QItemSelectionModel_setCurrentIndex';
procedure QItemSelectionModel_select(handle: QItemSelectionModelH; index: QModelIndexH; command: QItemSelectionModelSelectionFlags); cdecl; external Qt4PasLib name 'QItemSelectionModel_select';
procedure QItemSelectionModel_clear(handle: QItemSelectionModelH); cdecl; external Qt4PasLib name 'QItemSelectionModel_clear';
procedure QItemSelectionModel_reset(handle: QItemSelectionModelH); cdecl; external Qt4PasLib name 'QItemSelectionModel_reset';
procedure QItemSelectionModel_clearSelection(handle: QItemSelectionModelH); cdecl; external Qt4PasLib name 'QItemSelectionModel_clearSelection';


type
  QItemSelectionModel_currentChanged_Event = procedure (current: QModelIndexH; previous: QModelIndexH) of object cdecl;
  QItemSelectionModel_currentRowChanged_Event = procedure (current: QModelIndexH; previous: QModelIndexH) of object cdecl;
  QItemSelectionModel_currentColumnChanged_Event = procedure (current: QModelIndexH; previous: QModelIndexH) of object cdecl;



type
  QListWidgetItemItemType = (  //QListWidgetItem::ItemType (2)
    QListWidgetItemType = 0,
    QListWidgetItemUserType = 1000 );

function QListWidgetItem_create(view: QListWidgetH = nil; _type: Integer = QListWidgetItemType): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidgetItem_create';
procedure QListWidgetItem_destroy(handle: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidgetItem_destroy'; 
function QListWidgetItem_create(text: PWideString; view: QListWidgetH = nil; _type: Integer = QListWidgetItemType): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidgetItem_create2';
function QListWidgetItem_create(icon: QIconH; text: PWideString; view: QListWidgetH = nil; _type: Integer = QListWidgetItemType): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidgetItem_create3';
function QListWidgetItem_create(other: QListWidgetItemH): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidgetItem_create4';
function QListWidgetItem_clone(handle: QListWidgetItemH): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidgetItem_clone';
function QListWidgetItem_listWidget(handle: QListWidgetItemH): QListWidgetH; cdecl; external Qt4PasLib name 'QListWidgetItem_listWidget';
procedure QListWidgetItem_setSelected(handle: QListWidgetItemH; select: Boolean); cdecl; external Qt4PasLib name 'QListWidgetItem_setSelected';
function QListWidgetItem_isSelected(handle: QListWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QListWidgetItem_isSelected';
procedure QListWidgetItem_setHidden(handle: QListWidgetItemH; hide: Boolean); cdecl; external Qt4PasLib name 'QListWidgetItem_setHidden';
function QListWidgetItem_isHidden(handle: QListWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QListWidgetItem_isHidden';
function QListWidgetItem_flags(handle: QListWidgetItemH): QtItemFlags; cdecl; external Qt4PasLib name 'QListWidgetItem_flags';
procedure QListWidgetItem_setFlags(handle: QListWidgetItemH; flags: QtItemFlags); cdecl; external Qt4PasLib name 'QListWidgetItem_setFlags';
procedure QListWidgetItem_text(handle: QListWidgetItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QListWidgetItem_text';
procedure QListWidgetItem_setText(handle: QListWidgetItemH; text: PWideString); cdecl; external Qt4PasLib name 'QListWidgetItem_setText';
procedure QListWidgetItem_icon(handle: QListWidgetItemH; retval: QIconH); cdecl; external Qt4PasLib name 'QListWidgetItem_icon';
procedure QListWidgetItem_setIcon(handle: QListWidgetItemH; icon: QIconH); cdecl; external Qt4PasLib name 'QListWidgetItem_setIcon';
procedure QListWidgetItem_statusTip(handle: QListWidgetItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QListWidgetItem_statusTip';
procedure QListWidgetItem_setStatusTip(handle: QListWidgetItemH; statusTip: PWideString); cdecl; external Qt4PasLib name 'QListWidgetItem_setStatusTip';
procedure QListWidgetItem_toolTip(handle: QListWidgetItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QListWidgetItem_toolTip';
procedure QListWidgetItem_setToolTip(handle: QListWidgetItemH; toolTip: PWideString); cdecl; external Qt4PasLib name 'QListWidgetItem_setToolTip';
procedure QListWidgetItem_whatsThis(handle: QListWidgetItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QListWidgetItem_whatsThis';
procedure QListWidgetItem_setWhatsThis(handle: QListWidgetItemH; whatsThis: PWideString); cdecl; external Qt4PasLib name 'QListWidgetItem_setWhatsThis';
procedure QListWidgetItem_font(handle: QListWidgetItemH; retval: QFontH); cdecl; external Qt4PasLib name 'QListWidgetItem_font';
procedure QListWidgetItem_setFont(handle: QListWidgetItemH; font: QFontH); cdecl; external Qt4PasLib name 'QListWidgetItem_setFont';
function QListWidgetItem_textAlignment(handle: QListWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QListWidgetItem_textAlignment';
procedure QListWidgetItem_setTextAlignment(handle: QListWidgetItemH; alignment: Integer); cdecl; external Qt4PasLib name 'QListWidgetItem_setTextAlignment';
procedure QListWidgetItem_backgroundColor(handle: QListWidgetItemH; retval: PQColor); cdecl; external Qt4PasLib name 'QListWidgetItem_backgroundColor';
procedure QListWidgetItem_setBackgroundColor(handle: QListWidgetItemH; color: PQColor); cdecl; external Qt4PasLib name 'QListWidgetItem_setBackgroundColor';
procedure QListWidgetItem_background(handle: QListWidgetItemH; retval: QBrushH); cdecl; external Qt4PasLib name 'QListWidgetItem_background';
procedure QListWidgetItem_setBackground(handle: QListWidgetItemH; brush: QBrushH); cdecl; external Qt4PasLib name 'QListWidgetItem_setBackground';
procedure QListWidgetItem_textColor(handle: QListWidgetItemH; retval: PQColor); cdecl; external Qt4PasLib name 'QListWidgetItem_textColor';
procedure QListWidgetItem_setTextColor(handle: QListWidgetItemH; color: PQColor); cdecl; external Qt4PasLib name 'QListWidgetItem_setTextColor';
procedure QListWidgetItem_foreground(handle: QListWidgetItemH; retval: QBrushH); cdecl; external Qt4PasLib name 'QListWidgetItem_foreground';
procedure QListWidgetItem_setForeground(handle: QListWidgetItemH; brush: QBrushH); cdecl; external Qt4PasLib name 'QListWidgetItem_setForeground';
function QListWidgetItem_checkState(handle: QListWidgetItemH): QtCheckState; cdecl; external Qt4PasLib name 'QListWidgetItem_checkState';
procedure QListWidgetItem_setCheckState(handle: QListWidgetItemH; state: QtCheckState); cdecl; external Qt4PasLib name 'QListWidgetItem_setCheckState';
procedure QListWidgetItem_sizeHint(handle: QListWidgetItemH; retval: PSize); cdecl; external Qt4PasLib name 'QListWidgetItem_sizeHint';
procedure QListWidgetItem_setSizeHint(handle: QListWidgetItemH; size: PSize); cdecl; external Qt4PasLib name 'QListWidgetItem_setSizeHint';
procedure QListWidgetItem_data(handle: QListWidgetItemH; retval: QVariantH; role: Integer); cdecl; external Qt4PasLib name 'QListWidgetItem_data';
procedure QListWidgetItem_setData(handle: QListWidgetItemH; role: Integer; value: QVariantH); cdecl; external Qt4PasLib name 'QListWidgetItem_setData';
procedure QListWidgetItem_read(handle: QListWidgetItemH; _in: QDataStreamH); cdecl; external Qt4PasLib name 'QListWidgetItem_read';
procedure QListWidgetItem_write(handle: QListWidgetItemH; _out: QDataStreamH); cdecl; external Qt4PasLib name 'QListWidgetItem_write';
function QListWidgetItem_type(handle: QListWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QListWidgetItem_type';

function QListWidget_create(parent: QWidgetH = nil): QListWidgetH; cdecl; external Qt4PasLib name 'QListWidget_create';
procedure QListWidget_destroy(handle: QListWidgetH); cdecl; external Qt4PasLib name 'QListWidget_destroy'; 
function QListWidget_item(handle: QListWidgetH; row: Integer): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidget_item';
function QListWidget_row(handle: QListWidgetH; item: QListWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QListWidget_row';
procedure QListWidget_insertItem(handle: QListWidgetH; row: Integer; item: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidget_insertItem';
procedure QListWidget_insertItem(handle: QListWidgetH; row: Integer; _label: PWideString); cdecl; external Qt4PasLib name 'QListWidget_insertItem2';
procedure QListWidget_insertItems(handle: QListWidgetH; row: Integer; labels: QStringListH); cdecl; external Qt4PasLib name 'QListWidget_insertItems';
procedure QListWidget_addItem(handle: QListWidgetH; _label: PWideString); cdecl; external Qt4PasLib name 'QListWidget_addItem';
procedure QListWidget_addItem(handle: QListWidgetH; item: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidget_addItem2';
procedure QListWidget_addItems(handle: QListWidgetH; labels: QStringListH); cdecl; external Qt4PasLib name 'QListWidget_addItems';
function QListWidget_takeItem(handle: QListWidgetH; row: Integer): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidget_takeItem';
function QListWidget_count(handle: QListWidgetH): Integer; cdecl; external Qt4PasLib name 'QListWidget_count';
function QListWidget_currentItem(handle: QListWidgetH): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidget_currentItem';
procedure QListWidget_setCurrentItem(handle: QListWidgetH; item: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidget_setCurrentItem';
procedure QListWidget_setCurrentItem(handle: QListWidgetH; item: QListWidgetItemH; command: QItemSelectionModelSelectionFlags); cdecl; external Qt4PasLib name 'QListWidget_setCurrentItem2';
function QListWidget_currentRow(handle: QListWidgetH): Integer; cdecl; external Qt4PasLib name 'QListWidget_currentRow';
procedure QListWidget_setCurrentRow(handle: QListWidgetH; row: Integer); cdecl; external Qt4PasLib name 'QListWidget_setCurrentRow';
procedure QListWidget_setCurrentRow(handle: QListWidgetH; row: Integer; command: QItemSelectionModelSelectionFlags); cdecl; external Qt4PasLib name 'QListWidget_setCurrentRow2';
function QListWidget_itemAt(handle: QListWidgetH; p: PQtPoint): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidget_itemAt';
function QListWidget_itemAt(handle: QListWidgetH; x: Integer; y: Integer): QListWidgetItemH; cdecl; external Qt4PasLib name 'QListWidget_itemAt2';
procedure QListWidget_visualItemRect(handle: QListWidgetH; retval: PRect; item: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidget_visualItemRect';
procedure QListWidget_sortItems(handle: QListWidgetH; order: QtSortOrder = QtAscendingOrder); cdecl; external Qt4PasLib name 'QListWidget_sortItems';
procedure QListWidget_setSortingEnabled(handle: QListWidgetH; enable: Boolean); cdecl; external Qt4PasLib name 'QListWidget_setSortingEnabled';
function QListWidget_isSortingEnabled(handle: QListWidgetH): Boolean; cdecl; external Qt4PasLib name 'QListWidget_isSortingEnabled';
procedure QListWidget_editItem(handle: QListWidgetH; item: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidget_editItem';
procedure QListWidget_openPersistentEditor(handle: QListWidgetH; item: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidget_openPersistentEditor';
procedure QListWidget_closePersistentEditor(handle: QListWidgetH; item: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidget_closePersistentEditor';
function QListWidget_itemWidget(handle: QListWidgetH; item: QListWidgetItemH): QWidgetH; cdecl; external Qt4PasLib name 'QListWidget_itemWidget';
procedure QListWidget_setItemWidget(handle: QListWidgetH; item: QListWidgetItemH; widget: QWidgetH); cdecl; external Qt4PasLib name 'QListWidget_setItemWidget';
procedure QListWidget_removeItemWidget(handle: QListWidgetH; item: QListWidgetItemH); cdecl; external Qt4PasLib name 'QListWidget_removeItemWidget';
function QListWidget_isItemSelected(handle: QListWidgetH; item: QListWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QListWidget_isItemSelected';
procedure QListWidget_setItemSelected(handle: QListWidgetH; item: QListWidgetItemH; select: Boolean); cdecl; external Qt4PasLib name 'QListWidget_setItemSelected';
procedure QListWidget_selectedItems(handle: QListWidgetH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QListWidget_selectedItems';
procedure QListWidget_findItems(handle: QListWidgetH; retval: PPtrIntArray; text: PWideString; flags: QtMatchFlags); cdecl; external Qt4PasLib name 'QListWidget_findItems';
function QListWidget_isItemHidden(handle: QListWidgetH; item: QListWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QListWidget_isItemHidden';
procedure QListWidget_setItemHidden(handle: QListWidgetH; item: QListWidgetItemH; hide: Boolean); cdecl; external Qt4PasLib name 'QListWidget_setItemHidden';
procedure QListWidget_dropEvent(handle: QListWidgetH; event: QDropEventH); cdecl; external Qt4PasLib name 'QListWidget_dropEvent';
procedure QListWidget_scrollToItem(handle: QListWidgetH; item: QListWidgetItemH; hint: QAbstractItemViewScrollHint); cdecl; external Qt4PasLib name 'QListWidget_scrollToItem';
procedure QListWidget_clear(handle: QListWidgetH); cdecl; external Qt4PasLib name 'QListWidget_clear';


type
  QListWidget_itemPressed_Event = procedure (item: QListWidgetItemH) of object cdecl;
  QListWidget_itemClicked_Event = procedure (item: QListWidgetItemH) of object cdecl;
  QListWidget_itemDoubleClicked_Event = procedure (item: QListWidgetItemH) of object cdecl;
  QListWidget_itemActivated_Event = procedure (item: QListWidgetItemH) of object cdecl;
  QListWidget_itemEntered_Event = procedure (item: QListWidgetItemH) of object cdecl;
  QListWidget_itemChanged_Event = procedure (item: QListWidgetItemH) of object cdecl;
  QListWidget_currentItemChanged_Event = procedure (current: QListWidgetItemH; previous: QListWidgetItemH) of object cdecl;
  QListWidget_currentTextChanged_Event = procedure (currentText: PWideString) of object cdecl;
  QListWidget_currentRowChanged_Event = procedure (currentRow: Integer) of object cdecl;
  QListWidget_itemSelectionChanged_Event = procedure () of object cdecl;


function QTreeView_create(parent: QWidgetH = nil): QTreeViewH; cdecl; external Qt4PasLib name 'QTreeView_create';
procedure QTreeView_destroy(handle: QTreeViewH); cdecl; external Qt4PasLib name 'QTreeView_destroy'; 
procedure QTreeView_setModel(handle: QTreeViewH; model: QAbstractItemModelH); cdecl; external Qt4PasLib name 'QTreeView_setModel';
procedure QTreeView_setRootIndex(handle: QTreeViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QTreeView_setRootIndex';
procedure QTreeView_setSelectionModel(handle: QTreeViewH; selectionModel: QItemSelectionModelH); cdecl; external Qt4PasLib name 'QTreeView_setSelectionModel';
function QTreeView_header(handle: QTreeViewH): QHeaderViewH; cdecl; external Qt4PasLib name 'QTreeView_header';
procedure QTreeView_setHeader(handle: QTreeViewH; header: QHeaderViewH); cdecl; external Qt4PasLib name 'QTreeView_setHeader';
function QTreeView_autoExpandDelay(handle: QTreeViewH): Integer; cdecl; external Qt4PasLib name 'QTreeView_autoExpandDelay';
procedure QTreeView_setAutoExpandDelay(handle: QTreeViewH; delay: Integer); cdecl; external Qt4PasLib name 'QTreeView_setAutoExpandDelay';
function QTreeView_indentation(handle: QTreeViewH): Integer; cdecl; external Qt4PasLib name 'QTreeView_indentation';
procedure QTreeView_setIndentation(handle: QTreeViewH; i: Integer); cdecl; external Qt4PasLib name 'QTreeView_setIndentation';
function QTreeView_rootIsDecorated(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_rootIsDecorated';
procedure QTreeView_setRootIsDecorated(handle: QTreeViewH; show: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setRootIsDecorated';
function QTreeView_uniformRowHeights(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_uniformRowHeights';
procedure QTreeView_setUniformRowHeights(handle: QTreeViewH; uniform: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setUniformRowHeights';
function QTreeView_itemsExpandable(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_itemsExpandable';
procedure QTreeView_setItemsExpandable(handle: QTreeViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setItemsExpandable';
function QTreeView_expandsOnDoubleClick(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_expandsOnDoubleClick';
procedure QTreeView_setExpandsOnDoubleClick(handle: QTreeViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setExpandsOnDoubleClick';
function QTreeView_columnViewportPosition(handle: QTreeViewH; column: Integer): Integer; cdecl; external Qt4PasLib name 'QTreeView_columnViewportPosition';
function QTreeView_columnWidth(handle: QTreeViewH; column: Integer): Integer; cdecl; external Qt4PasLib name 'QTreeView_columnWidth';
procedure QTreeView_setColumnWidth(handle: QTreeViewH; column: Integer; width: Integer); cdecl; external Qt4PasLib name 'QTreeView_setColumnWidth';
function QTreeView_columnAt(handle: QTreeViewH; x: Integer): Integer; cdecl; external Qt4PasLib name 'QTreeView_columnAt';
function QTreeView_isColumnHidden(handle: QTreeViewH; column: Integer): Boolean; cdecl; external Qt4PasLib name 'QTreeView_isColumnHidden';
procedure QTreeView_setColumnHidden(handle: QTreeViewH; column: Integer; hide: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setColumnHidden';
function QTreeView_isHeaderHidden(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_isHeaderHidden';
procedure QTreeView_setHeaderHidden(handle: QTreeViewH; hide: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setHeaderHidden';
function QTreeView_isRowHidden(handle: QTreeViewH; row: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_isRowHidden';
procedure QTreeView_setRowHidden(handle: QTreeViewH; row: Integer; parent: QModelIndexH; hide: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setRowHidden';
function QTreeView_isFirstColumnSpanned(handle: QTreeViewH; row: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_isFirstColumnSpanned';
procedure QTreeView_setFirstColumnSpanned(handle: QTreeViewH; row: Integer; parent: QModelIndexH; span: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setFirstColumnSpanned';
function QTreeView_isExpanded(handle: QTreeViewH; index: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_isExpanded';
procedure QTreeView_setExpanded(handle: QTreeViewH; index: QModelIndexH; expand: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setExpanded';
procedure QTreeView_setSortingEnabled(handle: QTreeViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setSortingEnabled';
function QTreeView_isSortingEnabled(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_isSortingEnabled';
procedure QTreeView_setAnimated(handle: QTreeViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setAnimated';
function QTreeView_isAnimated(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_isAnimated';
procedure QTreeView_setAllColumnsShowFocus(handle: QTreeViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setAllColumnsShowFocus';
function QTreeView_allColumnsShowFocus(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_allColumnsShowFocus';
procedure QTreeView_setWordWrap(handle: QTreeViewH; _on: Boolean); cdecl; external Qt4PasLib name 'QTreeView_setWordWrap';
function QTreeView_wordWrap(handle: QTreeViewH): Boolean; cdecl; external Qt4PasLib name 'QTreeView_wordWrap';
procedure QTreeView_keyboardSearch(handle: QTreeViewH; search: PWideString); cdecl; external Qt4PasLib name 'QTreeView_keyboardSearch';
procedure QTreeView_visualRect(handle: QTreeViewH; retval: PRect; index: QModelIndexH); cdecl; external Qt4PasLib name 'QTreeView_visualRect';
procedure QTreeView_scrollTo(handle: QTreeViewH; index: QModelIndexH; hint: QAbstractItemViewScrollHint); cdecl; external Qt4PasLib name 'QTreeView_scrollTo';
procedure QTreeView_indexAt(handle: QTreeViewH; retval: QModelIndexH; p: PQtPoint); cdecl; external Qt4PasLib name 'QTreeView_indexAt';
procedure QTreeView_indexAbove(handle: QTreeViewH; retval: QModelIndexH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QTreeView_indexAbove';
procedure QTreeView_indexBelow(handle: QTreeViewH; retval: QModelIndexH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QTreeView_indexBelow';
procedure QTreeView_doItemsLayout(handle: QTreeViewH); cdecl; external Qt4PasLib name 'QTreeView_doItemsLayout';
procedure QTreeView_reset(handle: QTreeViewH); cdecl; external Qt4PasLib name 'QTreeView_reset';
procedure QTreeView_sortByColumn(handle: QTreeViewH; column: Integer; order: QtSortOrder); cdecl; external Qt4PasLib name 'QTreeView_sortByColumn';
procedure QTreeView_dataChanged(handle: QTreeViewH; topLeft: QModelIndexH; bottomRight: QModelIndexH); cdecl; external Qt4PasLib name 'QTreeView_dataChanged';
procedure QTreeView_hideColumn(handle: QTreeViewH; column: Integer); cdecl; external Qt4PasLib name 'QTreeView_hideColumn';
procedure QTreeView_showColumn(handle: QTreeViewH; column: Integer); cdecl; external Qt4PasLib name 'QTreeView_showColumn';
procedure QTreeView_expand(handle: QTreeViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QTreeView_expand';
procedure QTreeView_collapse(handle: QTreeViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QTreeView_collapse';
procedure QTreeView_resizeColumnToContents(handle: QTreeViewH; column: Integer); cdecl; external Qt4PasLib name 'QTreeView_resizeColumnToContents';
procedure QTreeView_sortByColumn(handle: QTreeViewH; column: Integer); cdecl; external Qt4PasLib name 'QTreeView_sortByColumn2';
procedure QTreeView_selectAll(handle: QTreeViewH); cdecl; external Qt4PasLib name 'QTreeView_selectAll';
procedure QTreeView_expandAll(handle: QTreeViewH); cdecl; external Qt4PasLib name 'QTreeView_expandAll';
procedure QTreeView_collapseAll(handle: QTreeViewH); cdecl; external Qt4PasLib name 'QTreeView_collapseAll';
procedure QTreeView_expandToDepth(handle: QTreeViewH; depth: Integer); cdecl; external Qt4PasLib name 'QTreeView_expandToDepth';


type
  QTreeView_expanded_Event = procedure (index: QModelIndexH) of object cdecl;
  QTreeView_collapsed_Event = procedure (index: QModelIndexH) of object cdecl;



type
  QTreeWidgetItemChildIndicatorPolicy = ( // QTreeWidgetItem::ChildIndicatorPolicy (1)
    QTreeWidgetItemShowIndicator, QTreeWidgetItemDontShowIndicator, QTreeWidgetItemDontShowIndicatorWhenChildless );

  QTreeWidgetItemItemType = (  //QTreeWidgetItem::ItemType (2)
    QTreeWidgetItemType = 0,
    QTreeWidgetItemUserType = 1000 );

function QTreeWidgetItem_create(_type: Integer = QTreeWidgetItemType): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create';
procedure QTreeWidgetItem_destroy(handle: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_destroy'; 
function QTreeWidgetItem_create(strings: QStringListH; _type: Integer = QTreeWidgetItemType): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create2';
function QTreeWidgetItem_create(view: QTreeWidgetH; _type: Integer = QTreeWidgetItemType): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create3';
function QTreeWidgetItem_create(view: QTreeWidgetH; strings: QStringListH; _type: Integer = QTreeWidgetItemType): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create4';
function QTreeWidgetItem_create(view: QTreeWidgetH; after: QTreeWidgetItemH; _type: Integer = QTreeWidgetItemType): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create5';
function QTreeWidgetItem_create(parent: QTreeWidgetItemH; _type: Integer = QTreeWidgetItemType): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create6';
function QTreeWidgetItem_create(parent: QTreeWidgetItemH; strings: QStringListH; _type: Integer = QTreeWidgetItemType): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create7';
function QTreeWidgetItem_create(parent: QTreeWidgetItemH; after: QTreeWidgetItemH; _type: Integer = QTreeWidgetItemType): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create8';
function QTreeWidgetItem_create(other: QTreeWidgetItemH): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_create9';
function QTreeWidgetItem_clone(handle: QTreeWidgetItemH): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_clone';
function QTreeWidgetItem_treeWidget(handle: QTreeWidgetItemH): QTreeWidgetH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_treeWidget';
procedure QTreeWidgetItem_setSelected(handle: QTreeWidgetItemH; select: Boolean); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setSelected';
function QTreeWidgetItem_isSelected(handle: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidgetItem_isSelected';
procedure QTreeWidgetItem_setHidden(handle: QTreeWidgetItemH; hide: Boolean); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setHidden';
function QTreeWidgetItem_isHidden(handle: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidgetItem_isHidden';
procedure QTreeWidgetItem_setExpanded(handle: QTreeWidgetItemH; expand: Boolean); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setExpanded';
function QTreeWidgetItem_isExpanded(handle: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidgetItem_isExpanded';
procedure QTreeWidgetItem_setFirstColumnSpanned(handle: QTreeWidgetItemH; span: Boolean); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setFirstColumnSpanned';
function QTreeWidgetItem_isFirstColumnSpanned(handle: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidgetItem_isFirstColumnSpanned';
procedure QTreeWidgetItem_setDisabled(handle: QTreeWidgetItemH; disabled: Boolean); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setDisabled';
function QTreeWidgetItem_isDisabled(handle: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidgetItem_isDisabled';
procedure QTreeWidgetItem_setChildIndicatorPolicy(handle: QTreeWidgetItemH; policy: QTreeWidgetItemChildIndicatorPolicy); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setChildIndicatorPolicy';
function QTreeWidgetItem_childIndicatorPolicy(handle: QTreeWidgetItemH): QTreeWidgetItemChildIndicatorPolicy; cdecl; external Qt4PasLib name 'QTreeWidgetItem_childIndicatorPolicy';
function QTreeWidgetItem_flags(handle: QTreeWidgetItemH): QtItemFlags; cdecl; external Qt4PasLib name 'QTreeWidgetItem_flags';
procedure QTreeWidgetItem_setFlags(handle: QTreeWidgetItemH; flags: QtItemFlags); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setFlags';
procedure QTreeWidgetItem_text(handle: QTreeWidgetItemH; retval: PWideString; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_text';
procedure QTreeWidgetItem_setText(handle: QTreeWidgetItemH; column: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setText';
procedure QTreeWidgetItem_icon(handle: QTreeWidgetItemH; retval: QIconH; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_icon';
procedure QTreeWidgetItem_setIcon(handle: QTreeWidgetItemH; column: Integer; icon: QIconH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setIcon';
procedure QTreeWidgetItem_statusTip(handle: QTreeWidgetItemH; retval: PWideString; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_statusTip';
procedure QTreeWidgetItem_setStatusTip(handle: QTreeWidgetItemH; column: Integer; statusTip: PWideString); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setStatusTip';
procedure QTreeWidgetItem_toolTip(handle: QTreeWidgetItemH; retval: PWideString; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_toolTip';
procedure QTreeWidgetItem_setToolTip(handle: QTreeWidgetItemH; column: Integer; toolTip: PWideString); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setToolTip';
procedure QTreeWidgetItem_whatsThis(handle: QTreeWidgetItemH; retval: PWideString; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_whatsThis';
procedure QTreeWidgetItem_setWhatsThis(handle: QTreeWidgetItemH; column: Integer; whatsThis: PWideString); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setWhatsThis';
procedure QTreeWidgetItem_font(handle: QTreeWidgetItemH; retval: QFontH; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_font';
procedure QTreeWidgetItem_setFont(handle: QTreeWidgetItemH; column: Integer; font: QFontH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setFont';
function QTreeWidgetItem_textAlignment(handle: QTreeWidgetItemH; column: Integer): Integer; cdecl; external Qt4PasLib name 'QTreeWidgetItem_textAlignment';
procedure QTreeWidgetItem_setTextAlignment(handle: QTreeWidgetItemH; column: Integer; alignment: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setTextAlignment';
procedure QTreeWidgetItem_backgroundColor(handle: QTreeWidgetItemH; retval: PQColor; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_backgroundColor';
procedure QTreeWidgetItem_setBackgroundColor(handle: QTreeWidgetItemH; column: Integer; color: PQColor); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setBackgroundColor';
procedure QTreeWidgetItem_background(handle: QTreeWidgetItemH; retval: QBrushH; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_background';
procedure QTreeWidgetItem_setBackground(handle: QTreeWidgetItemH; column: Integer; brush: QBrushH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setBackground';
procedure QTreeWidgetItem_textColor(handle: QTreeWidgetItemH; retval: PQColor; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_textColor';
procedure QTreeWidgetItem_setTextColor(handle: QTreeWidgetItemH; column: Integer; color: PQColor); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setTextColor';
procedure QTreeWidgetItem_foreground(handle: QTreeWidgetItemH; retval: QBrushH; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_foreground';
procedure QTreeWidgetItem_setForeground(handle: QTreeWidgetItemH; column: Integer; brush: QBrushH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setForeground';
function QTreeWidgetItem_checkState(handle: QTreeWidgetItemH; column: Integer): QtCheckState; cdecl; external Qt4PasLib name 'QTreeWidgetItem_checkState';
procedure QTreeWidgetItem_setCheckState(handle: QTreeWidgetItemH; column: Integer; state: QtCheckState); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setCheckState';
procedure QTreeWidgetItem_sizeHint(handle: QTreeWidgetItemH; retval: PSize; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_sizeHint';
procedure QTreeWidgetItem_setSizeHint(handle: QTreeWidgetItemH; column: Integer; size: PSize); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setSizeHint';
procedure QTreeWidgetItem_data(handle: QTreeWidgetItemH; retval: QVariantH; column: Integer; role: Integer); cdecl; external Qt4PasLib name 'QTreeWidgetItem_data';
procedure QTreeWidgetItem_setData(handle: QTreeWidgetItemH; column: Integer; role: Integer; value: QVariantH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_setData';
procedure QTreeWidgetItem_read(handle: QTreeWidgetItemH; _in: QDataStreamH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_read';
procedure QTreeWidgetItem_write(handle: QTreeWidgetItemH; _out: QDataStreamH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_write';
function QTreeWidgetItem_parent(handle: QTreeWidgetItemH): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_parent';
function QTreeWidgetItem_child(handle: QTreeWidgetItemH; index: Integer): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_child';
function QTreeWidgetItem_childCount(handle: QTreeWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTreeWidgetItem_childCount';
function QTreeWidgetItem_columnCount(handle: QTreeWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTreeWidgetItem_columnCount';
function QTreeWidgetItem_indexOfChild(handle: QTreeWidgetItemH; child: QTreeWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTreeWidgetItem_indexOfChild';
procedure QTreeWidgetItem_addChild(handle: QTreeWidgetItemH; child: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_addChild';
procedure QTreeWidgetItem_insertChild(handle: QTreeWidgetItemH; index: Integer; child: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_insertChild';
procedure QTreeWidgetItem_removeChild(handle: QTreeWidgetItemH; child: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidgetItem_removeChild';
function QTreeWidgetItem_takeChild(handle: QTreeWidgetItemH; index: Integer): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidgetItem_takeChild';
procedure QTreeWidgetItem_addChildren(handle: QTreeWidgetItemH; children: PPtrIntArray); cdecl; external Qt4PasLib name 'QTreeWidgetItem_addChildren';
procedure QTreeWidgetItem_insertChildren(handle: QTreeWidgetItemH; index: Integer; children: PPtrIntArray); cdecl; external Qt4PasLib name 'QTreeWidgetItem_insertChildren';
procedure QTreeWidgetItem_takeChildren(handle: QTreeWidgetItemH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QTreeWidgetItem_takeChildren';
function QTreeWidgetItem_type(handle: QTreeWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTreeWidgetItem_type';
procedure QTreeWidgetItem_sortChildren(handle: QTreeWidgetItemH; column: Integer; order: QtSortOrder); cdecl; external Qt4PasLib name 'QTreeWidgetItem_sortChildren';

function QTreeWidget_create(parent: QWidgetH = nil): QTreeWidgetH; cdecl; external Qt4PasLib name 'QTreeWidget_create';
procedure QTreeWidget_destroy(handle: QTreeWidgetH); cdecl; external Qt4PasLib name 'QTreeWidget_destroy'; 
function QTreeWidget_columnCount(handle: QTreeWidgetH): Integer; cdecl; external Qt4PasLib name 'QTreeWidget_columnCount';
procedure QTreeWidget_setColumnCount(handle: QTreeWidgetH; columns: Integer); cdecl; external Qt4PasLib name 'QTreeWidget_setColumnCount';
function QTreeWidget_invisibleRootItem(handle: QTreeWidgetH): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_invisibleRootItem';
function QTreeWidget_topLevelItem(handle: QTreeWidgetH; index: Integer): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_topLevelItem';
function QTreeWidget_topLevelItemCount(handle: QTreeWidgetH): Integer; cdecl; external Qt4PasLib name 'QTreeWidget_topLevelItemCount';
procedure QTreeWidget_insertTopLevelItem(handle: QTreeWidgetH; index: Integer; item: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidget_insertTopLevelItem';
procedure QTreeWidget_addTopLevelItem(handle: QTreeWidgetH; item: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidget_addTopLevelItem';
function QTreeWidget_takeTopLevelItem(handle: QTreeWidgetH; index: Integer): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_takeTopLevelItem';
function QTreeWidget_indexOfTopLevelItem(handle: QTreeWidgetH; item: QTreeWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTreeWidget_indexOfTopLevelItem';
procedure QTreeWidget_insertTopLevelItems(handle: QTreeWidgetH; index: Integer; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QTreeWidget_insertTopLevelItems';
procedure QTreeWidget_addTopLevelItems(handle: QTreeWidgetH; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QTreeWidget_addTopLevelItems';
function QTreeWidget_headerItem(handle: QTreeWidgetH): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_headerItem';
procedure QTreeWidget_setHeaderItem(handle: QTreeWidgetH; item: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidget_setHeaderItem';
procedure QTreeWidget_setHeaderLabels(handle: QTreeWidgetH; labels: QStringListH); cdecl; external Qt4PasLib name 'QTreeWidget_setHeaderLabels';
procedure QTreeWidget_setHeaderLabel(handle: QTreeWidgetH; _label: PWideString); cdecl; external Qt4PasLib name 'QTreeWidget_setHeaderLabel';
function QTreeWidget_currentItem(handle: QTreeWidgetH): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_currentItem';
function QTreeWidget_currentColumn(handle: QTreeWidgetH): Integer; cdecl; external Qt4PasLib name 'QTreeWidget_currentColumn';
procedure QTreeWidget_setCurrentItem(handle: QTreeWidgetH; item: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidget_setCurrentItem';
procedure QTreeWidget_setCurrentItem(handle: QTreeWidgetH; item: QTreeWidgetItemH; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidget_setCurrentItem2';
procedure QTreeWidget_setCurrentItem(handle: QTreeWidgetH; item: QTreeWidgetItemH; column: Integer; command: QItemSelectionModelSelectionFlags); cdecl; external Qt4PasLib name 'QTreeWidget_setCurrentItem3';
function QTreeWidget_itemAt(handle: QTreeWidgetH; p: PQtPoint): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_itemAt';
function QTreeWidget_itemAt(handle: QTreeWidgetH; x: Integer; y: Integer): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_itemAt2';
procedure QTreeWidget_visualItemRect(handle: QTreeWidgetH; retval: PRect; item: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidget_visualItemRect';
function QTreeWidget_sortColumn(handle: QTreeWidgetH): Integer; cdecl; external Qt4PasLib name 'QTreeWidget_sortColumn';
procedure QTreeWidget_sortItems(handle: QTreeWidgetH; column: Integer; order: QtSortOrder); cdecl; external Qt4PasLib name 'QTreeWidget_sortItems';
procedure QTreeWidget_setSortingEnabled(handle: QTreeWidgetH; enable: Boolean); cdecl; external Qt4PasLib name 'QTreeWidget_setSortingEnabled';
function QTreeWidget_isSortingEnabled(handle: QTreeWidgetH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidget_isSortingEnabled';
procedure QTreeWidget_editItem(handle: QTreeWidgetH; item: QTreeWidgetItemH; column: Integer = 0); cdecl; external Qt4PasLib name 'QTreeWidget_editItem';
procedure QTreeWidget_openPersistentEditor(handle: QTreeWidgetH; item: QTreeWidgetItemH; column: Integer = 0); cdecl; external Qt4PasLib name 'QTreeWidget_openPersistentEditor';
procedure QTreeWidget_closePersistentEditor(handle: QTreeWidgetH; item: QTreeWidgetItemH; column: Integer = 0); cdecl; external Qt4PasLib name 'QTreeWidget_closePersistentEditor';
function QTreeWidget_itemWidget(handle: QTreeWidgetH; item: QTreeWidgetItemH; column: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QTreeWidget_itemWidget';
procedure QTreeWidget_setItemWidget(handle: QTreeWidgetH; item: QTreeWidgetItemH; column: Integer; widget: QWidgetH); cdecl; external Qt4PasLib name 'QTreeWidget_setItemWidget';
procedure QTreeWidget_removeItemWidget(handle: QTreeWidgetH; item: QTreeWidgetItemH; column: Integer); cdecl; external Qt4PasLib name 'QTreeWidget_removeItemWidget';
function QTreeWidget_isItemSelected(handle: QTreeWidgetH; item: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidget_isItemSelected';
procedure QTreeWidget_setItemSelected(handle: QTreeWidgetH; item: QTreeWidgetItemH; select: Boolean); cdecl; external Qt4PasLib name 'QTreeWidget_setItemSelected';
procedure QTreeWidget_selectedItems(handle: QTreeWidgetH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QTreeWidget_selectedItems';
procedure QTreeWidget_findItems(handle: QTreeWidgetH; retval: PPtrIntArray; text: PWideString; flags: QtMatchFlags; column: Integer = 0); cdecl; external Qt4PasLib name 'QTreeWidget_findItems';
function QTreeWidget_isItemHidden(handle: QTreeWidgetH; item: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidget_isItemHidden';
procedure QTreeWidget_setItemHidden(handle: QTreeWidgetH; item: QTreeWidgetItemH; hide: Boolean); cdecl; external Qt4PasLib name 'QTreeWidget_setItemHidden';
function QTreeWidget_isItemExpanded(handle: QTreeWidgetH; item: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidget_isItemExpanded';
procedure QTreeWidget_setItemExpanded(handle: QTreeWidgetH; item: QTreeWidgetItemH; expand: Boolean); cdecl; external Qt4PasLib name 'QTreeWidget_setItemExpanded';
function QTreeWidget_isFirstItemColumnSpanned(handle: QTreeWidgetH; item: QTreeWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTreeWidget_isFirstItemColumnSpanned';
procedure QTreeWidget_setFirstItemColumnSpanned(handle: QTreeWidgetH; item: QTreeWidgetItemH; span: Boolean); cdecl; external Qt4PasLib name 'QTreeWidget_setFirstItemColumnSpanned';
function QTreeWidget_itemAbove(handle: QTreeWidgetH; item: QTreeWidgetItemH): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_itemAbove';
function QTreeWidget_itemBelow(handle: QTreeWidgetH; item: QTreeWidgetItemH): QTreeWidgetItemH; cdecl; external Qt4PasLib name 'QTreeWidget_itemBelow';
procedure QTreeWidget_setSelectionModel(handle: QTreeWidgetH; selectionModel: QItemSelectionModelH); cdecl; external Qt4PasLib name 'QTreeWidget_setSelectionModel';
procedure QTreeWidget_scrollToItem(handle: QTreeWidgetH; item: QTreeWidgetItemH; hint: QAbstractItemViewScrollHint); cdecl; external Qt4PasLib name 'QTreeWidget_scrollToItem';
procedure QTreeWidget_expandItem(handle: QTreeWidgetH; item: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidget_expandItem';
procedure QTreeWidget_collapseItem(handle: QTreeWidgetH; item: QTreeWidgetItemH); cdecl; external Qt4PasLib name 'QTreeWidget_collapseItem';
procedure QTreeWidget_clear(handle: QTreeWidgetH); cdecl; external Qt4PasLib name 'QTreeWidget_clear';


type
  QTreeWidget_itemPressed_Event = procedure (item: QTreeWidgetItemH; column: Integer) of object cdecl;
  QTreeWidget_itemClicked_Event = procedure (item: QTreeWidgetItemH; column: Integer) of object cdecl;
  QTreeWidget_itemDoubleClicked_Event = procedure (item: QTreeWidgetItemH; column: Integer) of object cdecl;
  QTreeWidget_itemActivated_Event = procedure (item: QTreeWidgetItemH; column: Integer) of object cdecl;
  QTreeWidget_itemEntered_Event = procedure (item: QTreeWidgetItemH; column: Integer) of object cdecl;
  QTreeWidget_itemChanged_Event = procedure (item: QTreeWidgetItemH; column: Integer) of object cdecl;
  QTreeWidget_itemExpanded_Event = procedure (item: QTreeWidgetItemH) of object cdecl;
  QTreeWidget_itemCollapsed_Event = procedure (item: QTreeWidgetItemH) of object cdecl;
  QTreeWidget_currentItemChanged_Event = procedure (current: QTreeWidgetItemH; previous: QTreeWidgetItemH) of object cdecl;
  QTreeWidget_itemSelectionChanged_Event = procedure () of object cdecl;


type
  QHeaderViewResizeMode = cardinal; //  QHeaderView::ResizeMode (4)

const
    QHeaderViewInteractive = 0 { $0 };
    QHeaderViewStretch = 1 { $1 };
    QHeaderViewFixed = 2 { $2 };
    QHeaderViewResizeToContents = 3 { $3 };
    QHeaderViewCustom = 2 { $2 };


function QHeaderView_create(orientation: QtOrientation; parent: QWidgetH = nil): QHeaderViewH; cdecl; external Qt4PasLib name 'QHeaderView_create';
procedure QHeaderView_destroy(handle: QHeaderViewH); cdecl; external Qt4PasLib name 'QHeaderView_destroy'; 
procedure QHeaderView_setModel(handle: QHeaderViewH; model: QAbstractItemModelH); cdecl; external Qt4PasLib name 'QHeaderView_setModel';
function QHeaderView_orientation(handle: QHeaderViewH): QtOrientation; cdecl; external Qt4PasLib name 'QHeaderView_orientation';
function QHeaderView_offset(handle: QHeaderViewH): Integer; cdecl; external Qt4PasLib name 'QHeaderView_offset';
function QHeaderView_length(handle: QHeaderViewH): Integer; cdecl; external Qt4PasLib name 'QHeaderView_length';
procedure QHeaderView_sizeHint(handle: QHeaderViewH; retval: PSize); cdecl; external Qt4PasLib name 'QHeaderView_sizeHint';
function QHeaderView_sectionSizeHint(handle: QHeaderViewH; logicalIndex: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_sectionSizeHint';
function QHeaderView_visualIndexAt(handle: QHeaderViewH; position: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_visualIndexAt';
function QHeaderView_logicalIndexAt(handle: QHeaderViewH; position: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_logicalIndexAt';
function QHeaderView_logicalIndexAt(handle: QHeaderViewH; x: Integer; y: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_logicalIndexAt2';
function QHeaderView_logicalIndexAt(handle: QHeaderViewH; pos: PQtPoint): Integer; cdecl; external Qt4PasLib name 'QHeaderView_logicalIndexAt3';
function QHeaderView_sectionSize(handle: QHeaderViewH; logicalIndex: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_sectionSize';
function QHeaderView_sectionPosition(handle: QHeaderViewH; logicalIndex: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_sectionPosition';
function QHeaderView_sectionViewportPosition(handle: QHeaderViewH; logicalIndex: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_sectionViewportPosition';
procedure QHeaderView_moveSection(handle: QHeaderViewH; from: Integer; _to: Integer); cdecl; external Qt4PasLib name 'QHeaderView_moveSection';
procedure QHeaderView_swapSections(handle: QHeaderViewH; first: Integer; second: Integer); cdecl; external Qt4PasLib name 'QHeaderView_swapSections';
procedure QHeaderView_resizeSection(handle: QHeaderViewH; logicalIndex: Integer; size: Integer); cdecl; external Qt4PasLib name 'QHeaderView_resizeSection';
procedure QHeaderView_resizeSections(handle: QHeaderViewH; mode: QHeaderViewResizeMode); cdecl; external Qt4PasLib name 'QHeaderView_resizeSections';
function QHeaderView_isSectionHidden(handle: QHeaderViewH; logicalIndex: Integer): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_isSectionHidden';
procedure QHeaderView_setSectionHidden(handle: QHeaderViewH; logicalIndex: Integer; hide: Boolean); cdecl; external Qt4PasLib name 'QHeaderView_setSectionHidden';
function QHeaderView_hiddenSectionCount(handle: QHeaderViewH): Integer; cdecl; external Qt4PasLib name 'QHeaderView_hiddenSectionCount';
procedure QHeaderView_hideSection(handle: QHeaderViewH; logicalIndex: Integer); cdecl; external Qt4PasLib name 'QHeaderView_hideSection';
procedure QHeaderView_showSection(handle: QHeaderViewH; logicalIndex: Integer); cdecl; external Qt4PasLib name 'QHeaderView_showSection';
function QHeaderView_count(handle: QHeaderViewH): Integer; cdecl; external Qt4PasLib name 'QHeaderView_count';
function QHeaderView_visualIndex(handle: QHeaderViewH; logicalIndex: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_visualIndex';
function QHeaderView_logicalIndex(handle: QHeaderViewH; visualIndex: Integer): Integer; cdecl; external Qt4PasLib name 'QHeaderView_logicalIndex';
procedure QHeaderView_setMovable(handle: QHeaderViewH; movable: Boolean); cdecl; external Qt4PasLib name 'QHeaderView_setMovable';
function QHeaderView_isMovable(handle: QHeaderViewH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_isMovable';
procedure QHeaderView_setClickable(handle: QHeaderViewH; clickable: Boolean); cdecl; external Qt4PasLib name 'QHeaderView_setClickable';
function QHeaderView_isClickable(handle: QHeaderViewH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_isClickable';
procedure QHeaderView_setHighlightSections(handle: QHeaderViewH; highlight: Boolean); cdecl; external Qt4PasLib name 'QHeaderView_setHighlightSections';
function QHeaderView_highlightSections(handle: QHeaderViewH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_highlightSections';
procedure QHeaderView_setResizeMode(handle: QHeaderViewH; mode: QHeaderViewResizeMode); cdecl; external Qt4PasLib name 'QHeaderView_setResizeMode';
procedure QHeaderView_setResizeMode(handle: QHeaderViewH; logicalIndex: Integer; mode: QHeaderViewResizeMode); cdecl; external Qt4PasLib name 'QHeaderView_setResizeMode2';
function QHeaderView_resizeMode(handle: QHeaderViewH; logicalIndex: Integer): QHeaderViewResizeMode; cdecl; external Qt4PasLib name 'QHeaderView_resizeMode';
function QHeaderView_stretchSectionCount(handle: QHeaderViewH): Integer; cdecl; external Qt4PasLib name 'QHeaderView_stretchSectionCount';
procedure QHeaderView_setSortIndicatorShown(handle: QHeaderViewH; show: Boolean); cdecl; external Qt4PasLib name 'QHeaderView_setSortIndicatorShown';
function QHeaderView_isSortIndicatorShown(handle: QHeaderViewH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_isSortIndicatorShown';
procedure QHeaderView_setSortIndicator(handle: QHeaderViewH; logicalIndex: Integer; order: QtSortOrder); cdecl; external Qt4PasLib name 'QHeaderView_setSortIndicator';
function QHeaderView_sortIndicatorSection(handle: QHeaderViewH): Integer; cdecl; external Qt4PasLib name 'QHeaderView_sortIndicatorSection';
function QHeaderView_sortIndicatorOrder(handle: QHeaderViewH): QtSortOrder; cdecl; external Qt4PasLib name 'QHeaderView_sortIndicatorOrder';
function QHeaderView_stretchLastSection(handle: QHeaderViewH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_stretchLastSection';
procedure QHeaderView_setStretchLastSection(handle: QHeaderViewH; stretch: Boolean); cdecl; external Qt4PasLib name 'QHeaderView_setStretchLastSection';
function QHeaderView_cascadingSectionResizes(handle: QHeaderViewH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_cascadingSectionResizes';
procedure QHeaderView_setCascadingSectionResizes(handle: QHeaderViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QHeaderView_setCascadingSectionResizes';
function QHeaderView_defaultSectionSize(handle: QHeaderViewH): Integer; cdecl; external Qt4PasLib name 'QHeaderView_defaultSectionSize';
procedure QHeaderView_setDefaultSectionSize(handle: QHeaderViewH; size: Integer); cdecl; external Qt4PasLib name 'QHeaderView_setDefaultSectionSize';
function QHeaderView_minimumSectionSize(handle: QHeaderViewH): Integer; cdecl; external Qt4PasLib name 'QHeaderView_minimumSectionSize';
procedure QHeaderView_setMinimumSectionSize(handle: QHeaderViewH; size: Integer); cdecl; external Qt4PasLib name 'QHeaderView_setMinimumSectionSize';
function QHeaderView_defaultAlignment(handle: QHeaderViewH): QtAlignment; cdecl; external Qt4PasLib name 'QHeaderView_defaultAlignment';
procedure QHeaderView_setDefaultAlignment(handle: QHeaderViewH; alignment: QtAlignment); cdecl; external Qt4PasLib name 'QHeaderView_setDefaultAlignment';
procedure QHeaderView_doItemsLayout(handle: QHeaderViewH); cdecl; external Qt4PasLib name 'QHeaderView_doItemsLayout';
function QHeaderView_sectionsMoved(handle: QHeaderViewH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_sectionsMoved';
function QHeaderView_sectionsHidden(handle: QHeaderViewH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_sectionsHidden';
procedure QHeaderView_saveState(handle: QHeaderViewH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QHeaderView_saveState';
function QHeaderView_restoreState(handle: QHeaderViewH; state: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QHeaderView_restoreState';
procedure QHeaderView_reset(handle: QHeaderViewH); cdecl; external Qt4PasLib name 'QHeaderView_reset';
procedure QHeaderView_setOffset(handle: QHeaderViewH; offset: Integer); cdecl; external Qt4PasLib name 'QHeaderView_setOffset';
procedure QHeaderView_setOffsetToSectionPosition(handle: QHeaderViewH; visualIndex: Integer); cdecl; external Qt4PasLib name 'QHeaderView_setOffsetToSectionPosition';
procedure QHeaderView_setOffsetToLastSection(handle: QHeaderViewH); cdecl; external Qt4PasLib name 'QHeaderView_setOffsetToLastSection';
procedure QHeaderView_headerDataChanged(handle: QHeaderViewH; orientation: QtOrientation; logicalFirst: Integer; logicalLast: Integer); cdecl; external Qt4PasLib name 'QHeaderView_headerDataChanged';


type
  QHeaderView_sectionMoved_Event = procedure (logicalIndex: Integer; oldVisualIndex: Integer; newVisualIndex: Integer) of object cdecl;
  QHeaderView_sectionResized_Event = procedure (logicalIndex: Integer; oldSize: Integer; newSize: Integer) of object cdecl;
  QHeaderView_sectionPressed_Event = procedure (logicalIndex: Integer) of object cdecl;
  QHeaderView_sectionClicked_Event = procedure (logicalIndex: Integer) of object cdecl;
  QHeaderView_sectionEntered_Event = procedure (logicalIndex: Integer) of object cdecl;
  QHeaderView_sectionDoubleClicked_Event = procedure (logicalIndex: Integer) of object cdecl;
  QHeaderView_sectionCountChanged_Event = procedure (oldCount: Integer; newCount: Integer) of object cdecl;
  QHeaderView_sectionHandleDoubleClicked_Event = procedure (logicalIndex: Integer) of object cdecl;
  QHeaderView_sectionAutoResize_Event = procedure (logicalIndex: Integer; mode: QHeaderViewResizeMode) of object cdecl;
  QHeaderView_geometriesChanged_Event = procedure () of object cdecl;
  QHeaderView_sortIndicatorChanged_Event = procedure (logicalIndex: Integer; order: QtSortOrder) of object cdecl;



type
  QStandardItemItemType = (  //QStandardItem::ItemType (2)
    QStandardItemType = 0,
    QStandardItemUserType = 1000 );

function QStandardItem_create(): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItem_create';
procedure QStandardItem_destroy(handle: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItem_destroy'; 
function QStandardItem_create(text: PWideString): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItem_create2';
function QStandardItem_create(icon: QIconH; text: PWideString): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItem_create3';
function QStandardItem_create(rows: Integer; columns: Integer = 1): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItem_create4';
procedure QStandardItem_data(handle: QStandardItemH; retval: QVariantH; role: QtItemDataRole); cdecl; external Qt4PasLib name 'QStandardItem_data';
procedure QStandardItem_setData(handle: QStandardItemH; value: QVariantH; role: QtItemDataRole); cdecl; external Qt4PasLib name 'QStandardItem_setData';
procedure QStandardItem_text(handle: QStandardItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_text';
procedure QStandardItem_setText(handle: QStandardItemH; text: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_setText';
procedure QStandardItem_icon(handle: QStandardItemH; retval: QIconH); cdecl; external Qt4PasLib name 'QStandardItem_icon';
procedure QStandardItem_setIcon(handle: QStandardItemH; icon: QIconH); cdecl; external Qt4PasLib name 'QStandardItem_setIcon';
procedure QStandardItem_toolTip(handle: QStandardItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_toolTip';
procedure QStandardItem_setToolTip(handle: QStandardItemH; toolTip: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_setToolTip';
procedure QStandardItem_statusTip(handle: QStandardItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_statusTip';
procedure QStandardItem_setStatusTip(handle: QStandardItemH; statusTip: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_setStatusTip';
procedure QStandardItem_whatsThis(handle: QStandardItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_whatsThis';
procedure QStandardItem_setWhatsThis(handle: QStandardItemH; whatsThis: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_setWhatsThis';
procedure QStandardItem_sizeHint(handle: QStandardItemH; retval: PSize); cdecl; external Qt4PasLib name 'QStandardItem_sizeHint';
procedure QStandardItem_setSizeHint(handle: QStandardItemH; sizeHint: PSize); cdecl; external Qt4PasLib name 'QStandardItem_setSizeHint';
procedure QStandardItem_font(handle: QStandardItemH; retval: QFontH); cdecl; external Qt4PasLib name 'QStandardItem_font';
procedure QStandardItem_setFont(handle: QStandardItemH; font: QFontH); cdecl; external Qt4PasLib name 'QStandardItem_setFont';
function QStandardItem_textAlignment(handle: QStandardItemH): QtAlignment; cdecl; external Qt4PasLib name 'QStandardItem_textAlignment';
procedure QStandardItem_setTextAlignment(handle: QStandardItemH; textAlignment: QtAlignment); cdecl; external Qt4PasLib name 'QStandardItem_setTextAlignment';
procedure QStandardItem_background(handle: QStandardItemH; retval: QBrushH); cdecl; external Qt4PasLib name 'QStandardItem_background';
procedure QStandardItem_setBackground(handle: QStandardItemH; brush: QBrushH); cdecl; external Qt4PasLib name 'QStandardItem_setBackground';
procedure QStandardItem_foreground(handle: QStandardItemH; retval: QBrushH); cdecl; external Qt4PasLib name 'QStandardItem_foreground';
procedure QStandardItem_setForeground(handle: QStandardItemH; brush: QBrushH); cdecl; external Qt4PasLib name 'QStandardItem_setForeground';
function QStandardItem_checkState(handle: QStandardItemH): QtCheckState; cdecl; external Qt4PasLib name 'QStandardItem_checkState';
procedure QStandardItem_setCheckState(handle: QStandardItemH; checkState: QtCheckState); cdecl; external Qt4PasLib name 'QStandardItem_setCheckState';
procedure QStandardItem_accessibleText(handle: QStandardItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_accessibleText';
procedure QStandardItem_setAccessibleText(handle: QStandardItemH; accessibleText: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_setAccessibleText';
procedure QStandardItem_accessibleDescription(handle: QStandardItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_accessibleDescription';
procedure QStandardItem_setAccessibleDescription(handle: QStandardItemH; accessibleDescription: PWideString); cdecl; external Qt4PasLib name 'QStandardItem_setAccessibleDescription';
function QStandardItem_flags(handle: QStandardItemH): QtItemFlags; cdecl; external Qt4PasLib name 'QStandardItem_flags';
procedure QStandardItem_setFlags(handle: QStandardItemH; flags: QtItemFlags); cdecl; external Qt4PasLib name 'QStandardItem_setFlags';
function QStandardItem_isEnabled(handle: QStandardItemH): Boolean; cdecl; external Qt4PasLib name 'QStandardItem_isEnabled';
procedure QStandardItem_setEnabled(handle: QStandardItemH; enabled: Boolean); cdecl; external Qt4PasLib name 'QStandardItem_setEnabled';
function QStandardItem_isEditable(handle: QStandardItemH): Boolean; cdecl; external Qt4PasLib name 'QStandardItem_isEditable';
procedure QStandardItem_setEditable(handle: QStandardItemH; editable: Boolean); cdecl; external Qt4PasLib name 'QStandardItem_setEditable';
function QStandardItem_isSelectable(handle: QStandardItemH): Boolean; cdecl; external Qt4PasLib name 'QStandardItem_isSelectable';
procedure QStandardItem_setSelectable(handle: QStandardItemH; selectable: Boolean); cdecl; external Qt4PasLib name 'QStandardItem_setSelectable';
function QStandardItem_isCheckable(handle: QStandardItemH): Boolean; cdecl; external Qt4PasLib name 'QStandardItem_isCheckable';
procedure QStandardItem_setCheckable(handle: QStandardItemH; checkable: Boolean); cdecl; external Qt4PasLib name 'QStandardItem_setCheckable';
function QStandardItem_isTristate(handle: QStandardItemH): Boolean; cdecl; external Qt4PasLib name 'QStandardItem_isTristate';
procedure QStandardItem_setTristate(handle: QStandardItemH; tristate: Boolean); cdecl; external Qt4PasLib name 'QStandardItem_setTristate';
function QStandardItem_isDragEnabled(handle: QStandardItemH): Boolean; cdecl; external Qt4PasLib name 'QStandardItem_isDragEnabled';
procedure QStandardItem_setDragEnabled(handle: QStandardItemH; dragEnabled: Boolean); cdecl; external Qt4PasLib name 'QStandardItem_setDragEnabled';
function QStandardItem_isDropEnabled(handle: QStandardItemH): Boolean; cdecl; external Qt4PasLib name 'QStandardItem_isDropEnabled';
procedure QStandardItem_setDropEnabled(handle: QStandardItemH; dropEnabled: Boolean); cdecl; external Qt4PasLib name 'QStandardItem_setDropEnabled';
function QStandardItem_parent(handle: QStandardItemH): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItem_parent';
function QStandardItem_row(handle: QStandardItemH): Integer; cdecl; external Qt4PasLib name 'QStandardItem_row';
function QStandardItem_column(handle: QStandardItemH): Integer; cdecl; external Qt4PasLib name 'QStandardItem_column';
procedure QStandardItem_index(handle: QStandardItemH; retval: QModelIndexH); cdecl; external Qt4PasLib name 'QStandardItem_index';
function QStandardItem_model(handle: QStandardItemH): QStandardItemModelH; cdecl; external Qt4PasLib name 'QStandardItem_model';
function QStandardItem_rowCount(handle: QStandardItemH): Integer; cdecl; external Qt4PasLib name 'QStandardItem_rowCount';
procedure QStandardItem_setRowCount(handle: QStandardItemH; rows: Integer); cdecl; external Qt4PasLib name 'QStandardItem_setRowCount';
function QStandardItem_columnCount(handle: QStandardItemH): Integer; cdecl; external Qt4PasLib name 'QStandardItem_columnCount';
procedure QStandardItem_setColumnCount(handle: QStandardItemH; columns: Integer); cdecl; external Qt4PasLib name 'QStandardItem_setColumnCount';
function QStandardItem_hasChildren(handle: QStandardItemH): Boolean; cdecl; external Qt4PasLib name 'QStandardItem_hasChildren';
function QStandardItem_child(handle: QStandardItemH; row: Integer; column: Integer = 0): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItem_child';
procedure QStandardItem_setChild(handle: QStandardItemH; row: Integer; column: Integer; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItem_setChild';
procedure QStandardItem_setChild(handle: QStandardItemH; row: Integer; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItem_setChild2';
procedure QStandardItem_insertRow(handle: QStandardItemH; row: Integer; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItem_insertRow';
procedure QStandardItem_insertColumn(handle: QStandardItemH; column: Integer; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItem_insertColumn';
procedure QStandardItem_insertRows(handle: QStandardItemH; row: Integer; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItem_insertRows';
procedure QStandardItem_insertRows(handle: QStandardItemH; row: Integer; count: Integer); cdecl; external Qt4PasLib name 'QStandardItem_insertRows2';
procedure QStandardItem_insertColumns(handle: QStandardItemH; column: Integer; count: Integer); cdecl; external Qt4PasLib name 'QStandardItem_insertColumns';
procedure QStandardItem_removeRow(handle: QStandardItemH; row: Integer); cdecl; external Qt4PasLib name 'QStandardItem_removeRow';
procedure QStandardItem_removeColumn(handle: QStandardItemH; column: Integer); cdecl; external Qt4PasLib name 'QStandardItem_removeColumn';
procedure QStandardItem_removeRows(handle: QStandardItemH; row: Integer; count: Integer); cdecl; external Qt4PasLib name 'QStandardItem_removeRows';
procedure QStandardItem_removeColumns(handle: QStandardItemH; column: Integer; count: Integer); cdecl; external Qt4PasLib name 'QStandardItem_removeColumns';
procedure QStandardItem_appendRow(handle: QStandardItemH; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItem_appendRow';
procedure QStandardItem_appendRows(handle: QStandardItemH; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItem_appendRows';
procedure QStandardItem_appendColumn(handle: QStandardItemH; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItem_appendColumn';
procedure QStandardItem_insertRow(handle: QStandardItemH; row: Integer; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItem_insertRow2';
procedure QStandardItem_appendRow(handle: QStandardItemH; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItem_appendRow2';
function QStandardItem_takeChild(handle: QStandardItemH; row: Integer; column: Integer = 0): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItem_takeChild';
procedure QStandardItem_takeRow(handle: QStandardItemH; retval: PPtrIntArray; row: Integer); cdecl; external Qt4PasLib name 'QStandardItem_takeRow';
procedure QStandardItem_takeColumn(handle: QStandardItemH; retval: PPtrIntArray; column: Integer); cdecl; external Qt4PasLib name 'QStandardItem_takeColumn';
procedure QStandardItem_sortChildren(handle: QStandardItemH; column: Integer; order: QtSortOrder = QtAscendingOrder); cdecl; external Qt4PasLib name 'QStandardItem_sortChildren';
function QStandardItem_clone(handle: QStandardItemH): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItem_clone';
function QStandardItem_type(handle: QStandardItemH): Integer; cdecl; external Qt4PasLib name 'QStandardItem_type';
procedure QStandardItem_read(handle: QStandardItemH; _in: QDataStreamH); cdecl; external Qt4PasLib name 'QStandardItem_read';
procedure QStandardItem_write(handle: QStandardItemH; _out: QDataStreamH); cdecl; external Qt4PasLib name 'QStandardItem_write';

function QStandardItemModel_create(parent: QObjectH = nil): QStandardItemModelH; cdecl; external Qt4PasLib name 'QStandardItemModel_create';
procedure QStandardItemModel_destroy(handle: QStandardItemModelH); cdecl; external Qt4PasLib name 'QStandardItemModel_destroy'; 
function QStandardItemModel_create(rows: Integer; columns: Integer; parent: QObjectH = nil): QStandardItemModelH; cdecl; external Qt4PasLib name 'QStandardItemModel_create2';
procedure QStandardItemModel_index(handle: QStandardItemModelH; retval: QModelIndexH; row: Integer; column: Integer; parent: QModelIndexH = nil); cdecl; external Qt4PasLib name 'QStandardItemModel_index';
procedure QStandardItemModel_parent(handle: QStandardItemModelH; retval: QModelIndexH; child: QModelIndexH); cdecl; external Qt4PasLib name 'QStandardItemModel_parent';
function QStandardItemModel_rowCount(handle: QStandardItemModelH; parent: QModelIndexH = nil): Integer; cdecl; external Qt4PasLib name 'QStandardItemModel_rowCount';
function QStandardItemModel_columnCount(handle: QStandardItemModelH; parent: QModelIndexH = nil): Integer; cdecl; external Qt4PasLib name 'QStandardItemModel_columnCount';
function QStandardItemModel_hasChildren(handle: QStandardItemModelH; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_hasChildren';
procedure QStandardItemModel_data(handle: QStandardItemModelH; retval: QVariantH; index: QModelIndexH; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt4PasLib name 'QStandardItemModel_data';
function QStandardItemModel_setData(handle: QStandardItemModelH; index: QModelIndexH; value: QVariantH; role: QtItemDataRole = QtEditRole): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_setData';
procedure QStandardItemModel_headerData(handle: QStandardItemModelH; retval: QVariantH; section: Integer; orientation: QtOrientation; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt4PasLib name 'QStandardItemModel_headerData';
function QStandardItemModel_setHeaderData(handle: QStandardItemModelH; section: Integer; orientation: QtOrientation; value: QVariantH; role: QtItemDataRole = QtEditRole): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_setHeaderData';
function QStandardItemModel_insertRows(handle: QStandardItemModelH; row: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_insertRows';
function QStandardItemModel_insertColumns(handle: QStandardItemModelH; column: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_insertColumns';
function QStandardItemModel_removeRows(handle: QStandardItemModelH; row: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_removeRows';
function QStandardItemModel_removeColumns(handle: QStandardItemModelH; column: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_removeColumns';
function QStandardItemModel_flags(handle: QStandardItemModelH; index: QModelIndexH): QtItemFlags; cdecl; external Qt4PasLib name 'QStandardItemModel_flags';
function QStandardItemModel_supportedDropActions(handle: QStandardItemModelH): QtDropActions; cdecl; external Qt4PasLib name 'QStandardItemModel_supportedDropActions';
procedure QStandardItemModel_clear(handle: QStandardItemModelH); cdecl; external Qt4PasLib name 'QStandardItemModel_clear';
procedure QStandardItemModel_sort(handle: QStandardItemModelH; column: Integer; order: QtSortOrder = QtAscendingOrder); cdecl; external Qt4PasLib name 'QStandardItemModel_sort';
function QStandardItemModel_itemFromIndex(handle: QStandardItemModelH; index: QModelIndexH): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_itemFromIndex';
procedure QStandardItemModel_indexFromItem(handle: QStandardItemModelH; retval: QModelIndexH; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItemModel_indexFromItem';
function QStandardItemModel_item(handle: QStandardItemModelH; row: Integer; column: Integer = 0): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_item';
procedure QStandardItemModel_setItem(handle: QStandardItemModelH; row: Integer; column: Integer; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItemModel_setItem';
procedure QStandardItemModel_setItem(handle: QStandardItemModelH; row: Integer; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItemModel_setItem2';
function QStandardItemModel_invisibleRootItem(handle: QStandardItemModelH): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_invisibleRootItem';
function QStandardItemModel_horizontalHeaderItem(handle: QStandardItemModelH; column: Integer): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_horizontalHeaderItem';
procedure QStandardItemModel_setHorizontalHeaderItem(handle: QStandardItemModelH; column: Integer; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItemModel_setHorizontalHeaderItem';
function QStandardItemModel_verticalHeaderItem(handle: QStandardItemModelH; row: Integer): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_verticalHeaderItem';
procedure QStandardItemModel_setVerticalHeaderItem(handle: QStandardItemModelH; row: Integer; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItemModel_setVerticalHeaderItem';
procedure QStandardItemModel_setHorizontalHeaderLabels(handle: QStandardItemModelH; labels: QStringListH); cdecl; external Qt4PasLib name 'QStandardItemModel_setHorizontalHeaderLabels';
procedure QStandardItemModel_setVerticalHeaderLabels(handle: QStandardItemModelH; labels: QStringListH); cdecl; external Qt4PasLib name 'QStandardItemModel_setVerticalHeaderLabels';
procedure QStandardItemModel_setRowCount(handle: QStandardItemModelH; rows: Integer); cdecl; external Qt4PasLib name 'QStandardItemModel_setRowCount';
procedure QStandardItemModel_setColumnCount(handle: QStandardItemModelH; columns: Integer); cdecl; external Qt4PasLib name 'QStandardItemModel_setColumnCount';
procedure QStandardItemModel_appendRow(handle: QStandardItemModelH; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItemModel_appendRow';
procedure QStandardItemModel_appendColumn(handle: QStandardItemModelH; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItemModel_appendColumn';
procedure QStandardItemModel_appendRow(handle: QStandardItemModelH; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItemModel_appendRow2';
procedure QStandardItemModel_insertRow(handle: QStandardItemModelH; row: Integer; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItemModel_insertRow';
procedure QStandardItemModel_insertColumn(handle: QStandardItemModelH; column: Integer; items: PPtrIntArray); cdecl; external Qt4PasLib name 'QStandardItemModel_insertColumn';
procedure QStandardItemModel_insertRow(handle: QStandardItemModelH; row: Integer; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItemModel_insertRow2';
function QStandardItemModel_insertRow(handle: QStandardItemModelH; row: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_insertRow3';
function QStandardItemModel_insertColumn(handle: QStandardItemModelH; column: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_insertColumn2';
function QStandardItemModel_takeItem(handle: QStandardItemModelH; row: Integer; column: Integer = 0): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_takeItem';
procedure QStandardItemModel_takeRow(handle: QStandardItemModelH; retval: PPtrIntArray; row: Integer); cdecl; external Qt4PasLib name 'QStandardItemModel_takeRow';
procedure QStandardItemModel_takeColumn(handle: QStandardItemModelH; retval: PPtrIntArray; column: Integer); cdecl; external Qt4PasLib name 'QStandardItemModel_takeColumn';
function QStandardItemModel_takeHorizontalHeaderItem(handle: QStandardItemModelH; column: Integer): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_takeHorizontalHeaderItem';
function QStandardItemModel_takeVerticalHeaderItem(handle: QStandardItemModelH; row: Integer): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_takeVerticalHeaderItem';
function QStandardItemModel_itemPrototype(handle: QStandardItemModelH): QStandardItemH; cdecl; external Qt4PasLib name 'QStandardItemModel_itemPrototype';
procedure QStandardItemModel_setItemPrototype(handle: QStandardItemModelH; item: QStandardItemH); cdecl; external Qt4PasLib name 'QStandardItemModel_setItemPrototype';
procedure QStandardItemModel_findItems(handle: QStandardItemModelH; retval: PPtrIntArray; text: PWideString; flags: QtMatchFlags = QtMatchExactly; column: Integer = 0); cdecl; external Qt4PasLib name 'QStandardItemModel_findItems';
function QStandardItemModel_sortRole(handle: QStandardItemModelH): Integer; cdecl; external Qt4PasLib name 'QStandardItemModel_sortRole';
procedure QStandardItemModel_setSortRole(handle: QStandardItemModelH; role: Integer); cdecl; external Qt4PasLib name 'QStandardItemModel_setSortRole';
procedure QStandardItemModel_mimeTypes(handle: QStandardItemModelH; retval: QStringListH); cdecl; external Qt4PasLib name 'QStandardItemModel_mimeTypes';
function QStandardItemModel_dropMimeData(handle: QStandardItemModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QStandardItemModel_dropMimeData';


type
  QStandardItemModel_itemChanged_Event = procedure (item: QStandardItemH) of object cdecl;



type
  QAbstractItemDelegateEndEditHint = ( // QAbstractItemDelegate::EndEditHint (1)
    QAbstractItemDelegateNoHint, QAbstractItemDelegateEditNextItem, QAbstractItemDelegateEditPreviousItem, QAbstractItemDelegateSubmitModelCache, QAbstractItemDelegateRevertModelCache );

procedure QAbstractItemDelegate_paint(handle: QAbstractItemDelegateH; painter: QPainterH; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemDelegate_paint';
procedure QAbstractItemDelegate_sizeHint(handle: QAbstractItemDelegateH; retval: PSize; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemDelegate_sizeHint';
function QAbstractItemDelegate_createEditor(handle: QAbstractItemDelegateH; parent: QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH): QWidgetH; cdecl; external Qt4PasLib name 'QAbstractItemDelegate_createEditor';
procedure QAbstractItemDelegate_setEditorData(handle: QAbstractItemDelegateH; editor: QWidgetH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemDelegate_setEditorData';
procedure QAbstractItemDelegate_setModelData(handle: QAbstractItemDelegateH; editor: QWidgetH; model: QAbstractItemModelH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemDelegate_setModelData';
procedure QAbstractItemDelegate_updateEditorGeometry(handle: QAbstractItemDelegateH; editor: QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QAbstractItemDelegate_updateEditorGeometry';
function QAbstractItemDelegate_editorEvent(handle: QAbstractItemDelegateH; event: QEventH; model: QAbstractItemModelH; option: QStyleOptionViewItemH; index: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemDelegate_editorEvent';
procedure QAbstractItemDelegate_elidedText(retval: PWideString; fontMetrics: QFontMetricsH; width: Integer; mode: QtTextElideMode; text: PWideString); cdecl; external Qt4PasLib name 'QAbstractItemDelegate_elidedText';
function QAbstractItemDelegate_helpEvent(handle: QAbstractItemDelegateH; event: QHelpEventH; view: QAbstractItemViewH; option: QStyleOptionViewItemH; index: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QAbstractItemDelegate_helpEvent';


type
  QAbstractItemDelegate_commitData_Event = procedure (editor: QWidgetH) of object cdecl;
  QAbstractItemDelegate_closeEditor_Event = procedure (editor: QWidgetH; hint: QAbstractItemDelegateEndEditHint = QAbstractItemDelegateNoHint) of object cdecl;
  QAbstractItemDelegate_closeEditor2_Event = procedure (editor: QWidgetH) of object cdecl;
  QAbstractItemDelegate_sizeHintChanged_Event = procedure (p1: QModelIndexH) of object cdecl;


function QItemDelegate_create(parent: QObjectH = nil): QItemDelegateH; cdecl; external Qt4PasLib name 'QItemDelegate_create';
procedure QItemDelegate_destroy(handle: QItemDelegateH); cdecl; external Qt4PasLib name 'QItemDelegate_destroy'; 
function QItemDelegate_hasClipping(handle: QItemDelegateH): Boolean; cdecl; external Qt4PasLib name 'QItemDelegate_hasClipping';
procedure QItemDelegate_setClipping(handle: QItemDelegateH; clip: Boolean); cdecl; external Qt4PasLib name 'QItemDelegate_setClipping';
procedure QItemDelegate_paint(handle: QItemDelegateH; painter: QPainterH; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QItemDelegate_paint';
procedure QItemDelegate_sizeHint(handle: QItemDelegateH; retval: PSize; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QItemDelegate_sizeHint';
function QItemDelegate_createEditor(handle: QItemDelegateH; parent: QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH): QWidgetH; cdecl; external Qt4PasLib name 'QItemDelegate_createEditor';
procedure QItemDelegate_setEditorData(handle: QItemDelegateH; editor: QWidgetH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QItemDelegate_setEditorData';
procedure QItemDelegate_setModelData(handle: QItemDelegateH; editor: QWidgetH; model: QAbstractItemModelH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QItemDelegate_setModelData';
procedure QItemDelegate_updateEditorGeometry(handle: QItemDelegateH; editor: QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QItemDelegate_updateEditorGeometry';
function QItemDelegate_itemEditorFactory(handle: QItemDelegateH): QItemEditorFactoryH; cdecl; external Qt4PasLib name 'QItemDelegate_itemEditorFactory';
procedure QItemDelegate_setItemEditorFactory(handle: QItemDelegateH; factory: QItemEditorFactoryH); cdecl; external Qt4PasLib name 'QItemDelegate_setItemEditorFactory';

function QLCLItemDelegate_create(parent: QObjectH = nil): QLCLItemDelegateH; cdecl; external Qt4PasLib name 'QLCLItemDelegate_create';
procedure QLCLItemDelegate_destroy(handle: QLCLItemDelegateH); cdecl; external Qt4PasLib name 'QLCLItemDelegate_destroy'; 
procedure QLCLItemDelegate_override_sizeHint(handle: QLCLItemDelegateH; hook: QLCLItemDelegate_sizeHint_Override); cdecl; external Qt4PasLib name 'QLCLItemDelegate_override_sizeHint';
procedure QLCLItemDelegate_override_paint(handle: QLCLItemDelegateH; hook: QLCLItemDelegate_paint_Override); cdecl; external Qt4PasLib name 'QLCLItemDelegate_override_paint';
procedure QLCLItemDelegate_override_createEditor(handle: QLCLItemDelegateH; hook: QLCLItemDelegate_createEditor_Override); cdecl; external Qt4PasLib name 'QLCLItemDelegate_override_createEditor';
procedure QLCLItemDelegate_override_setEditorData(handle: QLCLItemDelegateH; hook: QLCLItemDelegate_setEditorData_Override); cdecl; external Qt4PasLib name 'QLCLItemDelegate_override_setEditorData';
procedure QLCLItemDelegate_override_setModelData(handle: QLCLItemDelegateH; hook: QLCLItemDelegate_setModelData_Override); cdecl; external Qt4PasLib name 'QLCLItemDelegate_override_setModelData';
procedure QLCLItemDelegate_override_updateEditorGeometry(handle: QLCLItemDelegateH; hook: QLCLItemDelegate_updateEditorGeometry_Override); cdecl; external Qt4PasLib name 'QLCLItemDelegate_override_updateEditorGeometry';
procedure QLCLItemDelegate_override_editorEvent(handle: QLCLItemDelegateH; hook: QLCLItemDelegate_editorEvent_Override); cdecl; external Qt4PasLib name 'QLCLItemDelegate_override_editorEvent';
function QLCLItemDelegate_InheritedEditorEvent(handle: QLCLItemDelegateH; event: QEventH; model: QAbstractItemModelH; option: QStyleOptionViewItemH; index: QModelIndexH): Boolean; cdecl; external Qt4PasLib name 'QLCLItemDelegate_InheritedEditorEvent';

function QTableView_create(parent: QWidgetH = nil): QTableViewH; cdecl; external Qt4PasLib name 'QTableView_create';
procedure QTableView_destroy(handle: QTableViewH); cdecl; external Qt4PasLib name 'QTableView_destroy'; 
procedure QTableView_setModel(handle: QTableViewH; model: QAbstractItemModelH); cdecl; external Qt4PasLib name 'QTableView_setModel';
procedure QTableView_setRootIndex(handle: QTableViewH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QTableView_setRootIndex';
procedure QTableView_setSelectionModel(handle: QTableViewH; selectionModel: QItemSelectionModelH); cdecl; external Qt4PasLib name 'QTableView_setSelectionModel';
function QTableView_horizontalHeader(handle: QTableViewH): QHeaderViewH; cdecl; external Qt4PasLib name 'QTableView_horizontalHeader';
function QTableView_verticalHeader(handle: QTableViewH): QHeaderViewH; cdecl; external Qt4PasLib name 'QTableView_verticalHeader';
procedure QTableView_setHorizontalHeader(handle: QTableViewH; header: QHeaderViewH); cdecl; external Qt4PasLib name 'QTableView_setHorizontalHeader';
procedure QTableView_setVerticalHeader(handle: QTableViewH; header: QHeaderViewH); cdecl; external Qt4PasLib name 'QTableView_setVerticalHeader';
function QTableView_rowViewportPosition(handle: QTableViewH; row: Integer): Integer; cdecl; external Qt4PasLib name 'QTableView_rowViewportPosition';
function QTableView_rowAt(handle: QTableViewH; y: Integer): Integer; cdecl; external Qt4PasLib name 'QTableView_rowAt';
procedure QTableView_setRowHeight(handle: QTableViewH; row: Integer; height: Integer); cdecl; external Qt4PasLib name 'QTableView_setRowHeight';
function QTableView_rowHeight(handle: QTableViewH; row: Integer): Integer; cdecl; external Qt4PasLib name 'QTableView_rowHeight';
function QTableView_columnViewportPosition(handle: QTableViewH; column: Integer): Integer; cdecl; external Qt4PasLib name 'QTableView_columnViewportPosition';
function QTableView_columnAt(handle: QTableViewH; x: Integer): Integer; cdecl; external Qt4PasLib name 'QTableView_columnAt';
procedure QTableView_setColumnWidth(handle: QTableViewH; column: Integer; width: Integer); cdecl; external Qt4PasLib name 'QTableView_setColumnWidth';
function QTableView_columnWidth(handle: QTableViewH; column: Integer): Integer; cdecl; external Qt4PasLib name 'QTableView_columnWidth';
function QTableView_isRowHidden(handle: QTableViewH; row: Integer): Boolean; cdecl; external Qt4PasLib name 'QTableView_isRowHidden';
procedure QTableView_setRowHidden(handle: QTableViewH; row: Integer; hide: Boolean); cdecl; external Qt4PasLib name 'QTableView_setRowHidden';
function QTableView_isColumnHidden(handle: QTableViewH; column: Integer): Boolean; cdecl; external Qt4PasLib name 'QTableView_isColumnHidden';
procedure QTableView_setColumnHidden(handle: QTableViewH; column: Integer; hide: Boolean); cdecl; external Qt4PasLib name 'QTableView_setColumnHidden';
procedure QTableView_setSortingEnabled(handle: QTableViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QTableView_setSortingEnabled';
function QTableView_isSortingEnabled(handle: QTableViewH): Boolean; cdecl; external Qt4PasLib name 'QTableView_isSortingEnabled';
function QTableView_showGrid(handle: QTableViewH): Boolean; cdecl; external Qt4PasLib name 'QTableView_showGrid';
function QTableView_gridStyle(handle: QTableViewH): QtPenStyle; cdecl; external Qt4PasLib name 'QTableView_gridStyle';
procedure QTableView_setGridStyle(handle: QTableViewH; style: QtPenStyle); cdecl; external Qt4PasLib name 'QTableView_setGridStyle';
procedure QTableView_setWordWrap(handle: QTableViewH; _on: Boolean); cdecl; external Qt4PasLib name 'QTableView_setWordWrap';
function QTableView_wordWrap(handle: QTableViewH): Boolean; cdecl; external Qt4PasLib name 'QTableView_wordWrap';
procedure QTableView_setCornerButtonEnabled(handle: QTableViewH; enable: Boolean); cdecl; external Qt4PasLib name 'QTableView_setCornerButtonEnabled';
function QTableView_isCornerButtonEnabled(handle: QTableViewH): Boolean; cdecl; external Qt4PasLib name 'QTableView_isCornerButtonEnabled';
procedure QTableView_visualRect(handle: QTableViewH; retval: PRect; index: QModelIndexH); cdecl; external Qt4PasLib name 'QTableView_visualRect';
procedure QTableView_scrollTo(handle: QTableViewH; index: QModelIndexH; hint: QAbstractItemViewScrollHint); cdecl; external Qt4PasLib name 'QTableView_scrollTo';
procedure QTableView_indexAt(handle: QTableViewH; retval: QModelIndexH; p: PQtPoint); cdecl; external Qt4PasLib name 'QTableView_indexAt';
procedure QTableView_setSpan(handle: QTableViewH; row: Integer; column: Integer; rowSpan: Integer; columnSpan: Integer); cdecl; external Qt4PasLib name 'QTableView_setSpan';
function QTableView_rowSpan(handle: QTableViewH; row: Integer; column: Integer): Integer; cdecl; external Qt4PasLib name 'QTableView_rowSpan';
function QTableView_columnSpan(handle: QTableViewH; row: Integer; column: Integer): Integer; cdecl; external Qt4PasLib name 'QTableView_columnSpan';
procedure QTableView_clearSpans(handle: QTableViewH); cdecl; external Qt4PasLib name 'QTableView_clearSpans';
procedure QTableView_sortByColumn(handle: QTableViewH; column: Integer; order: QtSortOrder); cdecl; external Qt4PasLib name 'QTableView_sortByColumn';
procedure QTableView_selectRow(handle: QTableViewH; row: Integer); cdecl; external Qt4PasLib name 'QTableView_selectRow';
procedure QTableView_selectColumn(handle: QTableViewH; column: Integer); cdecl; external Qt4PasLib name 'QTableView_selectColumn';
procedure QTableView_hideRow(handle: QTableViewH; row: Integer); cdecl; external Qt4PasLib name 'QTableView_hideRow';
procedure QTableView_hideColumn(handle: QTableViewH; column: Integer); cdecl; external Qt4PasLib name 'QTableView_hideColumn';
procedure QTableView_showRow(handle: QTableViewH; row: Integer); cdecl; external Qt4PasLib name 'QTableView_showRow';
procedure QTableView_showColumn(handle: QTableViewH; column: Integer); cdecl; external Qt4PasLib name 'QTableView_showColumn';
procedure QTableView_resizeRowToContents(handle: QTableViewH; row: Integer); cdecl; external Qt4PasLib name 'QTableView_resizeRowToContents';
procedure QTableView_resizeRowsToContents(handle: QTableViewH); cdecl; external Qt4PasLib name 'QTableView_resizeRowsToContents';
procedure QTableView_resizeColumnToContents(handle: QTableViewH; column: Integer); cdecl; external Qt4PasLib name 'QTableView_resizeColumnToContents';
procedure QTableView_resizeColumnsToContents(handle: QTableViewH); cdecl; external Qt4PasLib name 'QTableView_resizeColumnsToContents';
procedure QTableView_sortByColumn(handle: QTableViewH; column: Integer); cdecl; external Qt4PasLib name 'QTableView_sortByColumn2';
procedure QTableView_setShowGrid(handle: QTableViewH; show: Boolean); cdecl; external Qt4PasLib name 'QTableView_setShowGrid';


type
  QTableWidgetItemItemType = (  //QTableWidgetItem::ItemType (2)
    QTableWidgetItemType = 0,
    QTableWidgetItemUserType = 1000 );

function QTableWidgetSelectionRange_create(): QTableWidgetSelectionRangeH; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_create';
procedure QTableWidgetSelectionRange_destroy(handle: QTableWidgetSelectionRangeH); cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_destroy'; 
function QTableWidgetSelectionRange_create(top: Integer; left: Integer; bottom: Integer; right: Integer): QTableWidgetSelectionRangeH; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_create2';
function QTableWidgetSelectionRange_create(other: QTableWidgetSelectionRangeH): QTableWidgetSelectionRangeH; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_create3';
function QTableWidgetSelectionRange_topRow(handle: QTableWidgetSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_topRow';
function QTableWidgetSelectionRange_bottomRow(handle: QTableWidgetSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_bottomRow';
function QTableWidgetSelectionRange_leftColumn(handle: QTableWidgetSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_leftColumn';
function QTableWidgetSelectionRange_rightColumn(handle: QTableWidgetSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_rightColumn';
function QTableWidgetSelectionRange_rowCount(handle: QTableWidgetSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_rowCount';
function QTableWidgetSelectionRange_columnCount(handle: QTableWidgetSelectionRangeH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetSelectionRange_columnCount';

function QTableWidgetItem_create(_type: Integer = QTableWidgetItemType): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidgetItem_create';
procedure QTableWidgetItem_destroy(handle: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidgetItem_destroy'; 
function QTableWidgetItem_create(text: PWideString; _type: Integer = QTableWidgetItemType): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidgetItem_create2';
function QTableWidgetItem_create(icon: QIconH; text: PWideString; _type: Integer = QTableWidgetItemType): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidgetItem_create3';
function QTableWidgetItem_create(other: QTableWidgetItemH): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidgetItem_create4';
function QTableWidgetItem_clone(handle: QTableWidgetItemH): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidgetItem_clone';
function QTableWidgetItem_tableWidget(handle: QTableWidgetItemH): QTableWidgetH; cdecl; external Qt4PasLib name 'QTableWidgetItem_tableWidget';
function QTableWidgetItem_row(handle: QTableWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetItem_row';
function QTableWidgetItem_column(handle: QTableWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetItem_column';
procedure QTableWidgetItem_setSelected(handle: QTableWidgetItemH; select: Boolean); cdecl; external Qt4PasLib name 'QTableWidgetItem_setSelected';
function QTableWidgetItem_isSelected(handle: QTableWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTableWidgetItem_isSelected';
function QTableWidgetItem_flags(handle: QTableWidgetItemH): QtItemFlags; cdecl; external Qt4PasLib name 'QTableWidgetItem_flags';
procedure QTableWidgetItem_setFlags(handle: QTableWidgetItemH; flags: QtItemFlags); cdecl; external Qt4PasLib name 'QTableWidgetItem_setFlags';
procedure QTableWidgetItem_text(handle: QTableWidgetItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QTableWidgetItem_text';
procedure QTableWidgetItem_setText(handle: QTableWidgetItemH; text: PWideString); cdecl; external Qt4PasLib name 'QTableWidgetItem_setText';
procedure QTableWidgetItem_icon(handle: QTableWidgetItemH; retval: QIconH); cdecl; external Qt4PasLib name 'QTableWidgetItem_icon';
procedure QTableWidgetItem_setIcon(handle: QTableWidgetItemH; icon: QIconH); cdecl; external Qt4PasLib name 'QTableWidgetItem_setIcon';
procedure QTableWidgetItem_statusTip(handle: QTableWidgetItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QTableWidgetItem_statusTip';
procedure QTableWidgetItem_setStatusTip(handle: QTableWidgetItemH; statusTip: PWideString); cdecl; external Qt4PasLib name 'QTableWidgetItem_setStatusTip';
procedure QTableWidgetItem_toolTip(handle: QTableWidgetItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QTableWidgetItem_toolTip';
procedure QTableWidgetItem_setToolTip(handle: QTableWidgetItemH; toolTip: PWideString); cdecl; external Qt4PasLib name 'QTableWidgetItem_setToolTip';
procedure QTableWidgetItem_whatsThis(handle: QTableWidgetItemH; retval: PWideString); cdecl; external Qt4PasLib name 'QTableWidgetItem_whatsThis';
procedure QTableWidgetItem_setWhatsThis(handle: QTableWidgetItemH; whatsThis: PWideString); cdecl; external Qt4PasLib name 'QTableWidgetItem_setWhatsThis';
procedure QTableWidgetItem_font(handle: QTableWidgetItemH; retval: QFontH); cdecl; external Qt4PasLib name 'QTableWidgetItem_font';
procedure QTableWidgetItem_setFont(handle: QTableWidgetItemH; font: QFontH); cdecl; external Qt4PasLib name 'QTableWidgetItem_setFont';
function QTableWidgetItem_textAlignment(handle: QTableWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetItem_textAlignment';
procedure QTableWidgetItem_setTextAlignment(handle: QTableWidgetItemH; alignment: Integer); cdecl; external Qt4PasLib name 'QTableWidgetItem_setTextAlignment';
procedure QTableWidgetItem_backgroundColor(handle: QTableWidgetItemH; retval: PQColor); cdecl; external Qt4PasLib name 'QTableWidgetItem_backgroundColor';
procedure QTableWidgetItem_setBackgroundColor(handle: QTableWidgetItemH; color: PQColor); cdecl; external Qt4PasLib name 'QTableWidgetItem_setBackgroundColor';
procedure QTableWidgetItem_background(handle: QTableWidgetItemH; retval: QBrushH); cdecl; external Qt4PasLib name 'QTableWidgetItem_background';
procedure QTableWidgetItem_setBackground(handle: QTableWidgetItemH; brush: QBrushH); cdecl; external Qt4PasLib name 'QTableWidgetItem_setBackground';
procedure QTableWidgetItem_textColor(handle: QTableWidgetItemH; retval: PQColor); cdecl; external Qt4PasLib name 'QTableWidgetItem_textColor';
procedure QTableWidgetItem_setTextColor(handle: QTableWidgetItemH; color: PQColor); cdecl; external Qt4PasLib name 'QTableWidgetItem_setTextColor';
procedure QTableWidgetItem_foreground(handle: QTableWidgetItemH; retval: QBrushH); cdecl; external Qt4PasLib name 'QTableWidgetItem_foreground';
procedure QTableWidgetItem_setForeground(handle: QTableWidgetItemH; brush: QBrushH); cdecl; external Qt4PasLib name 'QTableWidgetItem_setForeground';
function QTableWidgetItem_checkState(handle: QTableWidgetItemH): QtCheckState; cdecl; external Qt4PasLib name 'QTableWidgetItem_checkState';
procedure QTableWidgetItem_setCheckState(handle: QTableWidgetItemH; state: QtCheckState); cdecl; external Qt4PasLib name 'QTableWidgetItem_setCheckState';
procedure QTableWidgetItem_sizeHint(handle: QTableWidgetItemH; retval: PSize); cdecl; external Qt4PasLib name 'QTableWidgetItem_sizeHint';
procedure QTableWidgetItem_setSizeHint(handle: QTableWidgetItemH; size: PSize); cdecl; external Qt4PasLib name 'QTableWidgetItem_setSizeHint';
procedure QTableWidgetItem_data(handle: QTableWidgetItemH; retval: QVariantH; role: Integer); cdecl; external Qt4PasLib name 'QTableWidgetItem_data';
procedure QTableWidgetItem_setData(handle: QTableWidgetItemH; role: Integer; value: QVariantH); cdecl; external Qt4PasLib name 'QTableWidgetItem_setData';
procedure QTableWidgetItem_read(handle: QTableWidgetItemH; _in: QDataStreamH); cdecl; external Qt4PasLib name 'QTableWidgetItem_read';
procedure QTableWidgetItem_write(handle: QTableWidgetItemH; _out: QDataStreamH); cdecl; external Qt4PasLib name 'QTableWidgetItem_write';
function QTableWidgetItem_type(handle: QTableWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTableWidgetItem_type';

function QTableWidget_create(parent: QWidgetH = nil): QTableWidgetH; cdecl; external Qt4PasLib name 'QTableWidget_create';
procedure QTableWidget_destroy(handle: QTableWidgetH); cdecl; external Qt4PasLib name 'QTableWidget_destroy'; 
function QTableWidget_create(rows: Integer; columns: Integer; parent: QWidgetH = nil): QTableWidgetH; cdecl; external Qt4PasLib name 'QTableWidget_create2';
procedure QTableWidget_setRowCount(handle: QTableWidgetH; rows: Integer); cdecl; external Qt4PasLib name 'QTableWidget_setRowCount';
function QTableWidget_rowCount(handle: QTableWidgetH): Integer; cdecl; external Qt4PasLib name 'QTableWidget_rowCount';
procedure QTableWidget_setColumnCount(handle: QTableWidgetH; columns: Integer); cdecl; external Qt4PasLib name 'QTableWidget_setColumnCount';
function QTableWidget_columnCount(handle: QTableWidgetH): Integer; cdecl; external Qt4PasLib name 'QTableWidget_columnCount';
function QTableWidget_row(handle: QTableWidgetH; item: QTableWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTableWidget_row';
function QTableWidget_column(handle: QTableWidgetH; item: QTableWidgetItemH): Integer; cdecl; external Qt4PasLib name 'QTableWidget_column';
function QTableWidget_item(handle: QTableWidgetH; row: Integer; column: Integer): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_item';
procedure QTableWidget_setItem(handle: QTableWidgetH; row: Integer; column: Integer; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_setItem';
function QTableWidget_takeItem(handle: QTableWidgetH; row: Integer; column: Integer): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_takeItem';
function QTableWidget_verticalHeaderItem(handle: QTableWidgetH; row: Integer): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_verticalHeaderItem';
procedure QTableWidget_setVerticalHeaderItem(handle: QTableWidgetH; row: Integer; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_setVerticalHeaderItem';
function QTableWidget_takeVerticalHeaderItem(handle: QTableWidgetH; row: Integer): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_takeVerticalHeaderItem';
function QTableWidget_horizontalHeaderItem(handle: QTableWidgetH; column: Integer): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_horizontalHeaderItem';
procedure QTableWidget_setHorizontalHeaderItem(handle: QTableWidgetH; column: Integer; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_setHorizontalHeaderItem';
function QTableWidget_takeHorizontalHeaderItem(handle: QTableWidgetH; column: Integer): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_takeHorizontalHeaderItem';
procedure QTableWidget_setVerticalHeaderLabels(handle: QTableWidgetH; labels: QStringListH); cdecl; external Qt4PasLib name 'QTableWidget_setVerticalHeaderLabels';
procedure QTableWidget_setHorizontalHeaderLabels(handle: QTableWidgetH; labels: QStringListH); cdecl; external Qt4PasLib name 'QTableWidget_setHorizontalHeaderLabels';
function QTableWidget_currentRow(handle: QTableWidgetH): Integer; cdecl; external Qt4PasLib name 'QTableWidget_currentRow';
function QTableWidget_currentColumn(handle: QTableWidgetH): Integer; cdecl; external Qt4PasLib name 'QTableWidget_currentColumn';
function QTableWidget_currentItem(handle: QTableWidgetH): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_currentItem';
procedure QTableWidget_setCurrentItem(handle: QTableWidgetH; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_setCurrentItem';
procedure QTableWidget_setCurrentItem(handle: QTableWidgetH; item: QTableWidgetItemH; command: QItemSelectionModelSelectionFlags); cdecl; external Qt4PasLib name 'QTableWidget_setCurrentItem2';
procedure QTableWidget_setCurrentCell(handle: QTableWidgetH; row: Integer; column: Integer); cdecl; external Qt4PasLib name 'QTableWidget_setCurrentCell';
procedure QTableWidget_setCurrentCell(handle: QTableWidgetH; row: Integer; column: Integer; command: QItemSelectionModelSelectionFlags); cdecl; external Qt4PasLib name 'QTableWidget_setCurrentCell2';
procedure QTableWidget_sortItems(handle: QTableWidgetH; column: Integer; order: QtSortOrder = QtAscendingOrder); cdecl; external Qt4PasLib name 'QTableWidget_sortItems';
procedure QTableWidget_setSortingEnabled(handle: QTableWidgetH; enable: Boolean); cdecl; external Qt4PasLib name 'QTableWidget_setSortingEnabled';
function QTableWidget_isSortingEnabled(handle: QTableWidgetH): Boolean; cdecl; external Qt4PasLib name 'QTableWidget_isSortingEnabled';
procedure QTableWidget_editItem(handle: QTableWidgetH; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_editItem';
procedure QTableWidget_openPersistentEditor(handle: QTableWidgetH; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_openPersistentEditor';
procedure QTableWidget_closePersistentEditor(handle: QTableWidgetH; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_closePersistentEditor';
function QTableWidget_cellWidget(handle: QTableWidgetH; row: Integer; column: Integer): QWidgetH; cdecl; external Qt4PasLib name 'QTableWidget_cellWidget';
procedure QTableWidget_setCellWidget(handle: QTableWidgetH; row: Integer; column: Integer; widget: QWidgetH); cdecl; external Qt4PasLib name 'QTableWidget_setCellWidget';
procedure QTableWidget_removeCellWidget(handle: QTableWidgetH; row: Integer; column: Integer); cdecl; external Qt4PasLib name 'QTableWidget_removeCellWidget';
function QTableWidget_isItemSelected(handle: QTableWidgetH; item: QTableWidgetItemH): Boolean; cdecl; external Qt4PasLib name 'QTableWidget_isItemSelected';
procedure QTableWidget_setItemSelected(handle: QTableWidgetH; item: QTableWidgetItemH; select: Boolean); cdecl; external Qt4PasLib name 'QTableWidget_setItemSelected';
procedure QTableWidget_setRangeSelected(handle: QTableWidgetH; range: QTableWidgetSelectionRangeH; select: Boolean); cdecl; external Qt4PasLib name 'QTableWidget_setRangeSelected';
procedure QTableWidget_selectedItems(handle: QTableWidgetH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QTableWidget_selectedItems';
procedure QTableWidget_findItems(handle: QTableWidgetH; retval: PPtrIntArray; text: PWideString; flags: QtMatchFlags); cdecl; external Qt4PasLib name 'QTableWidget_findItems';
function QTableWidget_visualRow(handle: QTableWidgetH; logicalRow: Integer): Integer; cdecl; external Qt4PasLib name 'QTableWidget_visualRow';
function QTableWidget_visualColumn(handle: QTableWidgetH; logicalColumn: Integer): Integer; cdecl; external Qt4PasLib name 'QTableWidget_visualColumn';
function QTableWidget_itemAt(handle: QTableWidgetH; p: PQtPoint): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_itemAt';
function QTableWidget_itemAt(handle: QTableWidgetH; x: Integer; y: Integer): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_itemAt2';
procedure QTableWidget_visualItemRect(handle: QTableWidgetH; retval: PRect; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_visualItemRect';
function QTableWidget_itemPrototype(handle: QTableWidgetH): QTableWidgetItemH; cdecl; external Qt4PasLib name 'QTableWidget_itemPrototype';
procedure QTableWidget_setItemPrototype(handle: QTableWidgetH; item: QTableWidgetItemH); cdecl; external Qt4PasLib name 'QTableWidget_setItemPrototype';
procedure QTableWidget_scrollToItem(handle: QTableWidgetH; item: QTableWidgetItemH; hint: QAbstractItemViewScrollHint); cdecl; external Qt4PasLib name 'QTableWidget_scrollToItem';
procedure QTableWidget_insertRow(handle: QTableWidgetH; row: Integer); cdecl; external Qt4PasLib name 'QTableWidget_insertRow';
procedure QTableWidget_insertColumn(handle: QTableWidgetH; column: Integer); cdecl; external Qt4PasLib name 'QTableWidget_insertColumn';
procedure QTableWidget_removeRow(handle: QTableWidgetH; row: Integer); cdecl; external Qt4PasLib name 'QTableWidget_removeRow';
procedure QTableWidget_removeColumn(handle: QTableWidgetH; column: Integer); cdecl; external Qt4PasLib name 'QTableWidget_removeColumn';
procedure QTableWidget_clear(handle: QTableWidgetH); cdecl; external Qt4PasLib name 'QTableWidget_clear';
procedure QTableWidget_clearContents(handle: QTableWidgetH); cdecl; external Qt4PasLib name 'QTableWidget_clearContents';


type
  QTableWidget_itemPressed_Event = procedure (item: QTableWidgetItemH) of object cdecl;
  QTableWidget_itemClicked_Event = procedure (item: QTableWidgetItemH) of object cdecl;
  QTableWidget_itemDoubleClicked_Event = procedure (item: QTableWidgetItemH) of object cdecl;
  QTableWidget_itemActivated_Event = procedure (item: QTableWidgetItemH) of object cdecl;
  QTableWidget_itemEntered_Event = procedure (item: QTableWidgetItemH) of object cdecl;
  QTableWidget_itemChanged_Event = procedure (item: QTableWidgetItemH) of object cdecl;
  QTableWidget_currentItemChanged_Event = procedure (current: QTableWidgetItemH; previous: QTableWidgetItemH) of object cdecl;
  QTableWidget_itemSelectionChanged_Event = procedure () of object cdecl;
  QTableWidget_cellPressed_Event = procedure (row: Integer; column: Integer) of object cdecl;
  QTableWidget_cellClicked_Event = procedure (row: Integer; column: Integer) of object cdecl;
  QTableWidget_cellDoubleClicked_Event = procedure (row: Integer; column: Integer) of object cdecl;
  QTableWidget_cellActivated_Event = procedure (row: Integer; column: Integer) of object cdecl;
  QTableWidget_cellEntered_Event = procedure (row: Integer; column: Integer) of object cdecl;
  QTableWidget_cellChanged_Event = procedure (row: Integer; column: Integer) of object cdecl;
  QTableWidget_currentCellChanged_Event = procedure (currentRow: Integer; currentColumn: Integer; previousRow: Integer; previousColumn: Integer) of object cdecl;


function QItemEditorCreatorBase_createWidget(handle: QItemEditorCreatorBaseH; parent: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QItemEditorCreatorBase_createWidget';
procedure QItemEditorCreatorBase_valuePropertyName(handle: QItemEditorCreatorBaseH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QItemEditorCreatorBase_valuePropertyName';

function QItemEditorFactory_create(): QItemEditorFactoryH; cdecl; external Qt4PasLib name 'QItemEditorFactory_create';
procedure QItemEditorFactory_destroy(handle: QItemEditorFactoryH); cdecl; external Qt4PasLib name 'QItemEditorFactory_destroy'; 
function QItemEditorFactory_createEditor(handle: QItemEditorFactoryH; _type: QVariantType; parent: QWidgetH): QWidgetH; cdecl; external Qt4PasLib name 'QItemEditorFactory_createEditor';
procedure QItemEditorFactory_valuePropertyName(handle: QItemEditorFactoryH; retval: QByteArrayH; _type: QVariantType); cdecl; external Qt4PasLib name 'QItemEditorFactory_valuePropertyName';
procedure QItemEditorFactory_registerEditor(handle: QItemEditorFactoryH; _type: QVariantType; creator: QItemEditorCreatorBaseH); cdecl; external Qt4PasLib name 'QItemEditorFactory_registerEditor';
function QItemEditorFactory_defaultFactory(): QItemEditorFactoryH; cdecl; external Qt4PasLib name 'QItemEditorFactory_defaultFactory';
procedure QItemEditorFactory_setDefaultFactory(factory: QItemEditorFactoryH); cdecl; external Qt4PasLib name 'QItemEditorFactory_setDefaultFactory';

function QStyledItemDelegate_create(parent: QObjectH = nil): QStyledItemDelegateH; cdecl; external Qt4PasLib name 'QStyledItemDelegate_create';
procedure QStyledItemDelegate_destroy(handle: QStyledItemDelegateH); cdecl; external Qt4PasLib name 'QStyledItemDelegate_destroy'; 
procedure QStyledItemDelegate_paint(handle: QStyledItemDelegateH; painter: QPainterH; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QStyledItemDelegate_paint';
procedure QStyledItemDelegate_sizeHint(handle: QStyledItemDelegateH; retval: PSize; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QStyledItemDelegate_sizeHint';
function QStyledItemDelegate_createEditor(handle: QStyledItemDelegateH; parent: QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH): QWidgetH; cdecl; external Qt4PasLib name 'QStyledItemDelegate_createEditor';
procedure QStyledItemDelegate_setEditorData(handle: QStyledItemDelegateH; editor: QWidgetH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QStyledItemDelegate_setEditorData';
procedure QStyledItemDelegate_setModelData(handle: QStyledItemDelegateH; editor: QWidgetH; model: QAbstractItemModelH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QStyledItemDelegate_setModelData';
procedure QStyledItemDelegate_updateEditorGeometry(handle: QStyledItemDelegateH; editor: QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH); cdecl; external Qt4PasLib name 'QStyledItemDelegate_updateEditorGeometry';
function QStyledItemDelegate_itemEditorFactory(handle: QStyledItemDelegateH): QItemEditorFactoryH; cdecl; external Qt4PasLib name 'QStyledItemDelegate_itemEditorFactory';
procedure QStyledItemDelegate_setItemEditorFactory(handle: QStyledItemDelegateH; factory: QItemEditorFactoryH); cdecl; external Qt4PasLib name 'QStyledItemDelegate_setItemEditorFactory';
procedure QStyledItemDelegate_displayText(handle: QStyledItemDelegateH; retval: PWideString; value: QVariantH; locale: QLocaleH); cdecl; external Qt4PasLib name 'QStyledItemDelegate_displayText';


type
  QDialogDialogCode = ( // QDialog::DialogCode (1)
    QDialogRejected, QDialogAccepted );

function QDialog_create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QDialogH; cdecl; external Qt4PasLib name 'QDialog_create';
procedure QDialog_destroy(handle: QDialogH); cdecl; external Qt4PasLib name 'QDialog_destroy'; 
function QDialog_result(handle: QDialogH): Integer; cdecl; external Qt4PasLib name 'QDialog_result';
procedure QDialog_setVisible(handle: QDialogH; visible: Boolean); cdecl; external Qt4PasLib name 'QDialog_setVisible';
procedure QDialog_setOrientation(handle: QDialogH; orientation: QtOrientation); cdecl; external Qt4PasLib name 'QDialog_setOrientation';
function QDialog_orientation(handle: QDialogH): QtOrientation; cdecl; external Qt4PasLib name 'QDialog_orientation';
procedure QDialog_setExtension(handle: QDialogH; extension: QWidgetH); cdecl; external Qt4PasLib name 'QDialog_setExtension';
function QDialog_extension(handle: QDialogH): QWidgetH; cdecl; external Qt4PasLib name 'QDialog_extension';
procedure QDialog_sizeHint(handle: QDialogH; retval: PSize); cdecl; external Qt4PasLib name 'QDialog_sizeHint';
procedure QDialog_minimumSizeHint(handle: QDialogH; retval: PSize); cdecl; external Qt4PasLib name 'QDialog_minimumSizeHint';
procedure QDialog_setSizeGripEnabled(handle: QDialogH; p1: Boolean); cdecl; external Qt4PasLib name 'QDialog_setSizeGripEnabled';
function QDialog_isSizeGripEnabled(handle: QDialogH): Boolean; cdecl; external Qt4PasLib name 'QDialog_isSizeGripEnabled';
procedure QDialog_setModal(handle: QDialogH; modal: Boolean); cdecl; external Qt4PasLib name 'QDialog_setModal';
procedure QDialog_setResult(handle: QDialogH; r: Integer); cdecl; external Qt4PasLib name 'QDialog_setResult';
procedure QDialog_open(handle: QDialogH); cdecl; external Qt4PasLib name 'QDialog_open';
function QDialog_exec(handle: QDialogH): Integer; cdecl; external Qt4PasLib name 'QDialog_exec';
procedure QDialog_done(handle: QDialogH; p1: Integer); cdecl; external Qt4PasLib name 'QDialog_done';
procedure QDialog_accept(handle: QDialogH); cdecl; external Qt4PasLib name 'QDialog_accept';
procedure QDialog_reject(handle: QDialogH); cdecl; external Qt4PasLib name 'QDialog_reject';
procedure QDialog_showExtension(handle: QDialogH; p1: Boolean); cdecl; external Qt4PasLib name 'QDialog_showExtension';


type
  QDialog_finished_Event = procedure (result: Integer) of object cdecl;
  QDialog_accepted_Event = procedure () of object cdecl;
  QDialog_rejected_Event = procedure () of object cdecl;


type
  QFontDialogFontDialogOption = cardinal; // QFontDialog::FontDialogOption
  QFontDialogFontDialogOptions = QFontDialogFontDialogOption; //QFlags<> (3)
const
  QFontDialogNoButtons =   $00000001;
  QFontDialogDontUseNativeDialog =   $00000002;

function QFontDialog_create(parent: QWidgetH = nil): QFontDialogH; cdecl; external Qt4PasLib name 'QFontDialog_create';
procedure QFontDialog_destroy(handle: QFontDialogH); cdecl; external Qt4PasLib name 'QFontDialog_destroy'; 
function QFontDialog_create(initial: QFontH; parent: QWidgetH = nil): QFontDialogH; cdecl; external Qt4PasLib name 'QFontDialog_create2';
procedure QFontDialog_setCurrentFont(handle: QFontDialogH; font: QFontH); cdecl; external Qt4PasLib name 'QFontDialog_setCurrentFont';
procedure QFontDialog_currentFont(handle: QFontDialogH; retval: QFontH); cdecl; external Qt4PasLib name 'QFontDialog_currentFont';
procedure QFontDialog_selectedFont(handle: QFontDialogH; retval: QFontH); cdecl; external Qt4PasLib name 'QFontDialog_selectedFont';
procedure QFontDialog_setOption(handle: QFontDialogH; option: QFontDialogFontDialogOption; _on: Boolean = True); cdecl; external Qt4PasLib name 'QFontDialog_setOption';
function QFontDialog_testOption(handle: QFontDialogH; option: QFontDialogFontDialogOption): Boolean; cdecl; external Qt4PasLib name 'QFontDialog_testOption';
procedure QFontDialog_setOptions(handle: QFontDialogH; options: QFontDialogFontDialogOptions); cdecl; external Qt4PasLib name 'QFontDialog_setOptions';
function QFontDialog_options(handle: QFontDialogH): QFontDialogFontDialogOptions; cdecl; external Qt4PasLib name 'QFontDialog_options';
procedure QFontDialog_open(handle: QFontDialogH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QFontDialog_open';
procedure QFontDialog_setVisible(handle: QFontDialogH; visible: Boolean); cdecl; external Qt4PasLib name 'QFontDialog_setVisible';
procedure QFontDialog_getFont(retval: QFontH; ok: PBoolean; initial: QFontH; parent: QWidgetH; title: PWideString; options: QFontDialogFontDialogOptions); cdecl; external Qt4PasLib name 'QFontDialog_getFont';
procedure QFontDialog_getFont(retval: QFontH; ok: PBoolean; initial: QFontH; parent: QWidgetH; title: PWideString); cdecl; external Qt4PasLib name 'QFontDialog_getFont2';
procedure QFontDialog_getFont(retval: QFontH; ok: PBoolean; initial: QFontH; parent: QWidgetH = nil); cdecl; external Qt4PasLib name 'QFontDialog_getFont3';
procedure QFontDialog_getFont(retval: QFontH; ok: PBoolean; parent: QWidgetH = nil); cdecl; external Qt4PasLib name 'QFontDialog_getFont4';


type
  QMessageBoxIcon = (  //QMessageBox::Icon (2)
    QMessageBoxNoIcon = 0,
    QMessageBoxInformation = 1,
    QMessageBoxWarning = 2,
    QMessageBoxCritical = 3,
    QMessageBoxQuestion = 4 );

  QMessageBoxButtonRole = (  //QMessageBox::ButtonRole (2)
    QMessageBoxInvalidRole = -1,
    QMessageBoxAcceptRole,
    QMessageBoxRejectRole,
    QMessageBoxDestructiveRole,
    QMessageBoxActionRole,
    QMessageBoxHelpRole,
    QMessageBoxYesRole,
    QMessageBoxNoRole,
    QMessageBoxResetRole,
    QMessageBoxApplyRole,
    QMessageBoxNRoles );

type
  QMessageBoxStandardButton = cardinal; //  QMessageBox::StandardButton (4)
  QMessageBoxStandardButtons = QMessageBoxStandardButton; // QFlags<>

const
    QMessageBoxNoButton = 0 { $0 };
    QMessageBoxOk = 1024 { $400 };
    QMessageBoxSave = 2048 { $800 };
    QMessageBoxSaveAll = 4096 { $1000 };
    QMessageBoxOpen = 8192 { $2000 };
    QMessageBoxYes = 16384 { $4000 };
    QMessageBoxYesToAll = 32768 { $8000 };
    QMessageBoxNo = 65536 { $10000 };
    QMessageBoxNoToAll = 131072 { $20000 };
    QMessageBoxAbort = 262144 { $40000 };
    QMessageBoxRetry = 524288 { $80000 };
    QMessageBoxIgnore = 1048576 { $100000 };
    QMessageBoxClose = 2097152 { $200000 };
    QMessageBoxCancel = 4194304 { $400000 };
    QMessageBoxDiscard = 8388608 { $800000 };
    QMessageBoxHelp = 16777216 { $1000000 };
    QMessageBoxApply = 33554432 { $2000000 };
    QMessageBoxReset = 67108864 { $4000000 };
    QMessageBoxRestoreDefaults = 134217728 { $8000000 };
    QMessageBoxFirstButton = 1024 { $400 };
    QMessageBoxLastButton = 134217728 { $8000000 };
    QMessageBoxYesAll = 32768 { $8000 };
    QMessageBoxNoAll = 131072 { $20000 };
    QMessageBoxDefault = 256 { $100 };
    QMessageBoxEscape = 512 { $200 };
    QMessageBoxFlagMask = 768 { $300 };
    QMessageBoxButtonMask = 4294966527 { $fffffcff };


function QMessageBox_create(parent: QWidgetH = nil): QMessageBoxH; cdecl; external Qt4PasLib name 'QMessageBox_create';
procedure QMessageBox_destroy(handle: QMessageBoxH); cdecl; external Qt4PasLib name 'QMessageBox_destroy'; 
function QMessageBox_create(icon: QMessageBoxIcon; title: PWideString; text: PWideString; buttons: QMessageBoxStandardButtons = QMessageBoxNoButton; parent: QWidgetH = nil; flags: QtWindowFlags = QtDialog or QtMSWindowsFixedSizeDialogHint): QMessageBoxH; cdecl; external Qt4PasLib name 'QMessageBox_create2';
procedure QMessageBox_addButton(handle: QMessageBoxH; button: QAbstractButtonH; role: QMessageBoxButtonRole); cdecl; external Qt4PasLib name 'QMessageBox_addButton';
function QMessageBox_addButton(handle: QMessageBoxH; text: PWideString; role: QMessageBoxButtonRole): QPushButtonH; cdecl; external Qt4PasLib name 'QMessageBox_addButton2';
function QMessageBox_addButton(handle: QMessageBoxH; button: QMessageBoxStandardButton): QPushButtonH; cdecl; external Qt4PasLib name 'QMessageBox_addButton3';
procedure QMessageBox_removeButton(handle: QMessageBoxH; button: QAbstractButtonH); cdecl; external Qt4PasLib name 'QMessageBox_removeButton';
procedure QMessageBox_open(handle: QMessageBoxH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QMessageBox_open';
procedure QMessageBox_buttons(handle: QMessageBoxH; retval: PPtrIntArray); cdecl; external Qt4PasLib name 'QMessageBox_buttons';
function QMessageBox_buttonRole(handle: QMessageBoxH; button: QAbstractButtonH): QMessageBoxButtonRole; cdecl; external Qt4PasLib name 'QMessageBox_buttonRole';
procedure QMessageBox_setStandardButtons(handle: QMessageBoxH; buttons: QMessageBoxStandardButtons); cdecl; external Qt4PasLib name 'QMessageBox_setStandardButtons';
function QMessageBox_standardButtons(handle: QMessageBoxH): QMessageBoxStandardButtons; cdecl; external Qt4PasLib name 'QMessageBox_standardButtons';
function QMessageBox_standardButton(handle: QMessageBoxH; button: QAbstractButtonH): QMessageBoxStandardButton; cdecl; external Qt4PasLib name 'QMessageBox_standardButton';
function QMessageBox_button(handle: QMessageBoxH; which: QMessageBoxStandardButton): QAbstractButtonH; cdecl; external Qt4PasLib name 'QMessageBox_button';
function QMessageBox_defaultButton(handle: QMessageBoxH): QPushButtonH; cdecl; external Qt4PasLib name 'QMessageBox_defaultButton';
procedure QMessageBox_setDefaultButton(handle: QMessageBoxH; button: QPushButtonH); cdecl; external Qt4PasLib name 'QMessageBox_setDefaultButton';
procedure QMessageBox_setDefaultButton(handle: QMessageBoxH; button: QMessageBoxStandardButton); cdecl; external Qt4PasLib name 'QMessageBox_setDefaultButton2';
function QMessageBox_escapeButton(handle: QMessageBoxH): QAbstractButtonH; cdecl; external Qt4PasLib name 'QMessageBox_escapeButton';
procedure QMessageBox_setEscapeButton(handle: QMessageBoxH; button: QAbstractButtonH); cdecl; external Qt4PasLib name 'QMessageBox_setEscapeButton';
procedure QMessageBox_setEscapeButton(handle: QMessageBoxH; button: QMessageBoxStandardButton); cdecl; external Qt4PasLib name 'QMessageBox_setEscapeButton2';
function QMessageBox_clickedButton(handle: QMessageBoxH): QAbstractButtonH; cdecl; external Qt4PasLib name 'QMessageBox_clickedButton';
procedure QMessageBox_text(handle: QMessageBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_text';
procedure QMessageBox_setText(handle: QMessageBoxH; text: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_setText';
function QMessageBox_icon(handle: QMessageBoxH): QMessageBoxIcon; cdecl; external Qt4PasLib name 'QMessageBox_icon';
procedure QMessageBox_setIcon(handle: QMessageBoxH; p1: QMessageBoxIcon); cdecl; external Qt4PasLib name 'QMessageBox_setIcon';
procedure QMessageBox_iconPixmap(handle: QMessageBoxH; retval: QPixmapH); cdecl; external Qt4PasLib name 'QMessageBox_iconPixmap';
procedure QMessageBox_setIconPixmap(handle: QMessageBoxH; pixmap: QPixmapH); cdecl; external Qt4PasLib name 'QMessageBox_setIconPixmap';
function QMessageBox_textFormat(handle: QMessageBoxH): QtTextFormat; cdecl; external Qt4PasLib name 'QMessageBox_textFormat';
procedure QMessageBox_setTextFormat(handle: QMessageBoxH; format: QtTextFormat); cdecl; external Qt4PasLib name 'QMessageBox_setTextFormat';
function QMessageBox_information(parent: QWidgetH; title: PWideString; text: PWideString; buttons: QMessageBoxStandardButtons = QMessageBoxOk; defaultButton: QMessageBoxStandardButton = QMessageBoxNoButton): QMessageBoxStandardButton; cdecl; external Qt4PasLib name 'QMessageBox_information';
function QMessageBox_question(parent: QWidgetH; title: PWideString; text: PWideString; buttons: QMessageBoxStandardButtons = QMessageBoxOk; defaultButton: QMessageBoxStandardButton = QMessageBoxNoButton): QMessageBoxStandardButton; cdecl; external Qt4PasLib name 'QMessageBox_question';
function QMessageBox_warning(parent: QWidgetH; title: PWideString; text: PWideString; buttons: QMessageBoxStandardButtons = QMessageBoxOk; defaultButton: QMessageBoxStandardButton = QMessageBoxNoButton): QMessageBoxStandardButton; cdecl; external Qt4PasLib name 'QMessageBox_warning';
function QMessageBox_critical(parent: QWidgetH; title: PWideString; text: PWideString; buttons: QMessageBoxStandardButtons = QMessageBoxOk; defaultButton: QMessageBoxStandardButton = QMessageBoxNoButton): QMessageBoxStandardButton; cdecl; external Qt4PasLib name 'QMessageBox_critical';
procedure QMessageBox_about(parent: QWidgetH; title: PWideString; text: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_about';
procedure QMessageBox_aboutQt(parent: QWidgetH; title: PWideString = nil); cdecl; external Qt4PasLib name 'QMessageBox_aboutQt';
procedure QMessageBox_sizeHint(handle: QMessageBoxH; retval: PSize); cdecl; external Qt4PasLib name 'QMessageBox_sizeHint';
function QMessageBox_create(title: PWideString; text: PWideString; icon: QMessageBoxIcon; button0: Integer; button1: Integer; button2: Integer; parent: QWidgetH = nil; f: QtWindowFlags = QtDialog or QtMSWindowsFixedSizeDialogHint): QMessageBoxH; cdecl; external Qt4PasLib name 'QMessageBox_create3';
function QMessageBox_information(parent: QWidgetH; title: PWideString; text: PWideString; button0Text: PWideString; button1Text: PWideString = nil; button2Text: PWideString = nil; defaultButtonNumber: Integer = 0; escapeButtonNumber: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QMessageBox_information3';
function QMessageBox_question(parent: QWidgetH; title: PWideString; text: PWideString; button0Text: PWideString; button1Text: PWideString = nil; button2Text: PWideString = nil; defaultButtonNumber: Integer = 0; escapeButtonNumber: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QMessageBox_question3';
function QMessageBox_warning(parent: QWidgetH; title: PWideString; text: PWideString; button0Text: PWideString; button1Text: PWideString = nil; button2Text: PWideString = nil; defaultButtonNumber: Integer = 0; escapeButtonNumber: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QMessageBox_warning3';
function QMessageBox_critical(parent: QWidgetH; title: PWideString; text: PWideString; button0Text: PWideString; button1Text: PWideString = nil; button2Text: PWideString = nil; defaultButtonNumber: Integer = 0; escapeButtonNumber: Integer = -1): Integer; cdecl; external Qt4PasLib name 'QMessageBox_critical3';
procedure QMessageBox_buttonText(handle: QMessageBoxH; retval: PWideString; button: Integer); cdecl; external Qt4PasLib name 'QMessageBox_buttonText';
procedure QMessageBox_setButtonText(handle: QMessageBoxH; button: Integer; text: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_setButtonText';
procedure QMessageBox_informativeText(handle: QMessageBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_informativeText';
procedure QMessageBox_setInformativeText(handle: QMessageBoxH; text: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_setInformativeText';
procedure QMessageBox_detailedText(handle: QMessageBoxH; retval: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_detailedText';
procedure QMessageBox_setDetailedText(handle: QMessageBoxH; text: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_setDetailedText';
procedure QMessageBox_setWindowTitle(handle: QMessageBoxH; title: PWideString); cdecl; external Qt4PasLib name 'QMessageBox_setWindowTitle';
procedure QMessageBox_setWindowModality(handle: QMessageBoxH; windowModality: QtWindowModality); cdecl; external Qt4PasLib name 'QMessageBox_setWindowModality';
procedure QMessageBox_standardIcon(retval: QPixmapH; icon: QMessageBoxIcon); cdecl; external Qt4PasLib name 'QMessageBox_standardIcon';


type
  QInputDialogInputMode = ( // QInputDialog::InputMode (1)
    QInputDialogTextInput, QInputDialogIntInput, QInputDialogDoubleInput );

type
  QInputDialogInputDialogOption = cardinal; // QInputDialog::InputDialogOption
  QInputDialogInputDialogOptions = QInputDialogInputDialogOption; //QFlags<> (3)
const
  QInputDialogNoButtons =   $00000001;
  QInputDialogUseListViewForComboBoxItems =   $00000002;

function QInputDialog_create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QInputDialogH; cdecl; external Qt4PasLib name 'QInputDialog_create';
procedure QInputDialog_destroy(handle: QInputDialogH); cdecl; external Qt4PasLib name 'QInputDialog_destroy'; 
procedure QInputDialog_setInputMode(handle: QInputDialogH; mode: QInputDialogInputMode); cdecl; external Qt4PasLib name 'QInputDialog_setInputMode';
function QInputDialog_inputMode(handle: QInputDialogH): QInputDialogInputMode; cdecl; external Qt4PasLib name 'QInputDialog_inputMode';
procedure QInputDialog_setLabelText(handle: QInputDialogH; text: PWideString); cdecl; external Qt4PasLib name 'QInputDialog_setLabelText';
procedure QInputDialog_labelText(handle: QInputDialogH; retval: PWideString); cdecl; external Qt4PasLib name 'QInputDialog_labelText';
procedure QInputDialog_setOption(handle: QInputDialogH; option: QInputDialogInputDialogOption; _on: Boolean = True); cdecl; external Qt4PasLib name 'QInputDialog_setOption';
function QInputDialog_testOption(handle: QInputDialogH; option: QInputDialogInputDialogOption): Boolean; cdecl; external Qt4PasLib name 'QInputDialog_testOption';
procedure QInputDialog_setOptions(handle: QInputDialogH; options: QInputDialogInputDialogOptions); cdecl; external Qt4PasLib name 'QInputDialog_setOptions';
function QInputDialog_options(handle: QInputDialogH): QInputDialogInputDialogOptions; cdecl; external Qt4PasLib name 'QInputDialog_options';
procedure QInputDialog_setTextValue(handle: QInputDialogH; text: PWideString); cdecl; external Qt4PasLib name 'QInputDialog_setTextValue';
procedure QInputDialog_textValue(handle: QInputDialogH; retval: PWideString); cdecl; external Qt4PasLib name 'QInputDialog_textValue';
procedure QInputDialog_setTextEchoMode(handle: QInputDialogH; mode: QLineEditEchoMode); cdecl; external Qt4PasLib name 'QInputDialog_setTextEchoMode';
function QInputDialog_textEchoMode(handle: QInputDialogH): QLineEditEchoMode; cdecl; external Qt4PasLib name 'QInputDialog_textEchoMode';
procedure QInputDialog_setComboBoxEditable(handle: QInputDialogH; editable: Boolean); cdecl; external Qt4PasLib name 'QInputDialog_setComboBoxEditable';
function QInputDialog_isComboBoxEditable(handle: QInputDialogH): Boolean; cdecl; external Qt4PasLib name 'QInputDialog_isComboBoxEditable';
procedure QInputDialog_setComboBoxItems(handle: QInputDialogH; items: QStringListH); cdecl; external Qt4PasLib name 'QInputDialog_setComboBoxItems';
procedure QInputDialog_comboBoxItems(handle: QInputDialogH; retval: QStringListH); cdecl; external Qt4PasLib name 'QInputDialog_comboBoxItems';
procedure QInputDialog_setIntValue(handle: QInputDialogH; value: Integer); cdecl; external Qt4PasLib name 'QInputDialog_setIntValue';
function QInputDialog_intValue(handle: QInputDialogH): Integer; cdecl; external Qt4PasLib name 'QInputDialog_intValue';
procedure QInputDialog_setIntMinimum(handle: QInputDialogH; min: Integer); cdecl; external Qt4PasLib name 'QInputDialog_setIntMinimum';
function QInputDialog_intMinimum(handle: QInputDialogH): Integer; cdecl; external Qt4PasLib name 'QInputDialog_intMinimum';
procedure QInputDialog_setIntMaximum(handle: QInputDialogH; max: Integer); cdecl; external Qt4PasLib name 'QInputDialog_setIntMaximum';
function QInputDialog_intMaximum(handle: QInputDialogH): Integer; cdecl; external Qt4PasLib name 'QInputDialog_intMaximum';
procedure QInputDialog_setIntRange(handle: QInputDialogH; min: Integer; max: Integer); cdecl; external Qt4PasLib name 'QInputDialog_setIntRange';
procedure QInputDialog_setIntStep(handle: QInputDialogH; step: Integer); cdecl; external Qt4PasLib name 'QInputDialog_setIntStep';
function QInputDialog_intStep(handle: QInputDialogH): Integer; cdecl; external Qt4PasLib name 'QInputDialog_intStep';
procedure QInputDialog_setDoubleValue(handle: QInputDialogH; value: Double); cdecl; external Qt4PasLib name 'QInputDialog_setDoubleValue';
function QInputDialog_doubleValue(handle: QInputDialogH): Double; cdecl; external Qt4PasLib name 'QInputDialog_doubleValue';
procedure QInputDialog_setDoubleMinimum(handle: QInputDialogH; min: Double); cdecl; external Qt4PasLib name 'QInputDialog_setDoubleMinimum';
function QInputDialog_doubleMinimum(handle: QInputDialogH): Double; cdecl; external Qt4PasLib name 'QInputDialog_doubleMinimum';
procedure QInputDialog_setDoubleMaximum(handle: QInputDialogH; max: Double); cdecl; external Qt4PasLib name 'QInputDialog_setDoubleMaximum';
function QInputDialog_doubleMaximum(handle: QInputDialogH): Double; cdecl; external Qt4PasLib name 'QInputDialog_doubleMaximum';
procedure QInputDialog_setDoubleRange(handle: QInputDialogH; min: Double; max: Double); cdecl; external Qt4PasLib name 'QInputDialog_setDoubleRange';
procedure QInputDialog_setDoubleDecimals(handle: QInputDialogH; decimals: Integer); cdecl; external Qt4PasLib name 'QInputDialog_setDoubleDecimals';
function QInputDialog_doubleDecimals(handle: QInputDialogH): Integer; cdecl; external Qt4PasLib name 'QInputDialog_doubleDecimals';
procedure QInputDialog_setOkButtonText(handle: QInputDialogH; text: PWideString); cdecl; external Qt4PasLib name 'QInputDialog_setOkButtonText';
procedure QInputDialog_okButtonText(handle: QInputDialogH; retval: PWideString); cdecl; external Qt4PasLib name 'QInputDialog_okButtonText';
procedure QInputDialog_setCancelButtonText(handle: QInputDialogH; text: PWideString); cdecl; external Qt4PasLib name 'QInputDialog_setCancelButtonText';
procedure QInputDialog_cancelButtonText(handle: QInputDialogH; retval: PWideString); cdecl; external Qt4PasLib name 'QInputDialog_cancelButtonText';
procedure QInputDialog_open(handle: QInputDialogH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QInputDialog_open';
procedure QInputDialog_minimumSizeHint(handle: QInputDialogH; retval: PSize); cdecl; external Qt4PasLib name 'QInputDialog_minimumSizeHint';
procedure QInputDialog_sizeHint(handle: QInputDialogH; retval: PSize); cdecl; external Qt4PasLib name 'QInputDialog_sizeHint';
procedure QInputDialog_setVisible(handle: QInputDialogH; visible: Boolean); cdecl; external Qt4PasLib name 'QInputDialog_setVisible';
procedure QInputDialog_getText(retval: PWideString; parent: QWidgetH; title: PWideString; _label: PWideString; echo: QLineEditEchoMode = QLineEditNormal; text: PWideString = nil; ok: PBoolean = nil; flags: QtWindowFlags = 0); cdecl; external Qt4PasLib name 'QInputDialog_getText';
function QInputDialog_getInt(parent: QWidgetH; title: PWideString; _label: PWideString; value: Integer = 0; minValue: Integer = -2147483647; maxValue: Integer = 2147483647; step: Integer = 1; ok: PBoolean = nil; flags: QtWindowFlags = 0): Integer; cdecl; external Qt4PasLib name 'QInputDialog_getInt';
function QInputDialog_getDouble(parent: QWidgetH; title: PWideString; _label: PWideString; value: Double = 0; minValue: Double = -2147483647; maxValue: Double = 2147483647; decimals: Integer = 1; ok: PBoolean = nil; flags: QtWindowFlags = 0): Double; cdecl; external Qt4PasLib name 'QInputDialog_getDouble';
procedure QInputDialog_getItem(retval: PWideString; parent: QWidgetH; title: PWideString; _label: PWideString; items: QStringListH; current: Integer = 0; editable: Boolean = True; ok: PBoolean = nil; flags: QtWindowFlags = 0); cdecl; external Qt4PasLib name 'QInputDialog_getItem';
function QInputDialog_getInteger(parent: QWidgetH; title: PWideString; _label: PWideString; value: Integer = 0; minValue: Integer = -2147483647; maxValue: Integer = 2147483647; step: Integer = 1; ok: PBoolean = nil; flags: QtWindowFlags = 0): Integer; cdecl; external Qt4PasLib name 'QInputDialog_getInteger';
procedure QInputDialog_done(handle: QInputDialogH; result: Integer); cdecl; external Qt4PasLib name 'QInputDialog_done';

type
  QColorDialogColorDialogOption = cardinal; // QColorDialog::ColorDialogOption
  QColorDialogColorDialogOptions = QColorDialogColorDialogOption; //QFlags<> (3)
const
  QColorDialogShowAlphaChannel =   $00000001;
  QColorDialogNoButtons =   $00000002;
  QColorDialogDontUseNativeDialog =   $00000004;

function QColorDialog_create(parent: QWidgetH = nil): QColorDialogH; cdecl; external Qt4PasLib name 'QColorDialog_create';
procedure QColorDialog_destroy(handle: QColorDialogH); cdecl; external Qt4PasLib name 'QColorDialog_destroy'; 
function QColorDialog_create(initial: PQColor; parent: QWidgetH = nil): QColorDialogH; cdecl; external Qt4PasLib name 'QColorDialog_create2';
procedure QColorDialog_setCurrentColor(handle: QColorDialogH; color: PQColor); cdecl; external Qt4PasLib name 'QColorDialog_setCurrentColor';
procedure QColorDialog_currentColor(handle: QColorDialogH; retval: PQColor); cdecl; external Qt4PasLib name 'QColorDialog_currentColor';
procedure QColorDialog_selectedColor(handle: QColorDialogH; retval: PQColor); cdecl; external Qt4PasLib name 'QColorDialog_selectedColor';
procedure QColorDialog_setOption(handle: QColorDialogH; option: QColorDialogColorDialogOption; _on: Boolean = True); cdecl; external Qt4PasLib name 'QColorDialog_setOption';
function QColorDialog_testOption(handle: QColorDialogH; option: QColorDialogColorDialogOption): Boolean; cdecl; external Qt4PasLib name 'QColorDialog_testOption';
procedure QColorDialog_setOptions(handle: QColorDialogH; options: QColorDialogColorDialogOptions); cdecl; external Qt4PasLib name 'QColorDialog_setOptions';
function QColorDialog_options(handle: QColorDialogH): QColorDialogColorDialogOptions; cdecl; external Qt4PasLib name 'QColorDialog_options';
procedure QColorDialog_open(handle: QColorDialogH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QColorDialog_open';
procedure QColorDialog_setVisible(handle: QColorDialogH; visible: Boolean); cdecl; external Qt4PasLib name 'QColorDialog_setVisible';
procedure QColorDialog_getColor(retval: PQColor; initial: PQColor; parent: QWidgetH; title: PWideString; options: QColorDialogColorDialogOptions = 0); cdecl; external Qt4PasLib name 'QColorDialog_getColor';
procedure QColorDialog_getColor(retval: PQColor; initial: PQColor; parent: QWidgetH = nil); cdecl; external Qt4PasLib name 'QColorDialog_getColor2';
function QColorDialog_getRgba(rgba: QRgb = 4294967295; ok: PBoolean = nil; parent: QWidgetH = nil): QRgb; cdecl; external Qt4PasLib name 'QColorDialog_getRgba';
function QColorDialog_customCount(): Integer; cdecl; external Qt4PasLib name 'QColorDialog_customCount';
function QColorDialog_customColor(index: Integer): QRgb; cdecl; external Qt4PasLib name 'QColorDialog_customColor';
procedure QColorDialog_setCustomColor(index: Integer; color: QRgb); cdecl; external Qt4PasLib name 'QColorDialog_setCustomColor';
procedure QColorDialog_setStandardColor(index: Integer; color: QRgb); cdecl; external Qt4PasLib name 'QColorDialog_setStandardColor';


type
  QFileDialogViewMode = ( // QFileDialog::ViewMode (1)
    QFileDialogDetail, QFileDialogList );

  QFileDialogFileMode = ( // QFileDialog::FileMode (1)
    QFileDialogAnyFile, QFileDialogExistingFile, QFileDialogDirectory, QFileDialogExistingFiles, QFileDialogDirectoryOnly );

  QFileDialogAcceptMode = ( // QFileDialog::AcceptMode (1)
    QFileDialogAcceptOpen, QFileDialogAcceptSave );

  QFileDialogDialogLabel = ( // QFileDialog::DialogLabel (1)
    QFileDialogLookIn, QFileDialogFileName, QFileDialogFileType, QFileDialogAccept, QFileDialogReject );

type
  QFileDialogOption = cardinal; // QFileDialog::Option
  QFileDialogOptions = QFileDialogOption; //QFlags<> (3)
const
  QFileDialogShowDirsOnly =   $00000001;
  QFileDialogDontResolveSymlinks =   $00000002;
  QFileDialogDontConfirmOverwrite =   $00000004;
  QFileDialogDontUseSheet =   $00000008;
  QFileDialogDontUseNativeDialog =   $00000010;
  QFileDialogReadOnly =   $00000020;
  QFileDialogHideNameFilterDetails =   $00000040;

function QFileDialog_create(parent: QWidgetH; f: QtWindowFlags): QFileDialogH; cdecl; external Qt4PasLib name 'QFileDialog_create';
procedure QFileDialog_destroy(handle: QFileDialogH); cdecl; external Qt4PasLib name 'QFileDialog_destroy'; 
function QFileDialog_create(parent: QWidgetH = nil; caption: PWideString = nil; directory: PWideString = nil; filter: PWideString = nil): QFileDialogH; cdecl; external Qt4PasLib name 'QFileDialog_create2';
procedure QFileDialog_setDirectory(handle: QFileDialogH; directory: PWideString); cdecl; external Qt4PasLib name 'QFileDialog_setDirectory';
procedure QFileDialog_setDirectory(handle: QFileDialogH; directory: QDirH); cdecl; external Qt4PasLib name 'QFileDialog_setDirectory2';
procedure QFileDialog_directory(handle: QFileDialogH; retval: QDirH); cdecl; external Qt4PasLib name 'QFileDialog_directory';
procedure QFileDialog_selectFile(handle: QFileDialogH; filename: PWideString); cdecl; external Qt4PasLib name 'QFileDialog_selectFile';
procedure QFileDialog_selectedFiles(handle: QFileDialogH; retval: QStringListH); cdecl; external Qt4PasLib name 'QFileDialog_selectedFiles';
procedure QFileDialog_setNameFilterDetailsVisible(handle: QFileDialogH; enabled: Boolean); cdecl; external Qt4PasLib name 'QFileDialog_setNameFilterDetailsVisible';
function QFileDialog_isNameFilterDetailsVisible(handle: QFileDialogH): Boolean; cdecl; external Qt4PasLib name 'QFileDialog_isNameFilterDetailsVisible';
procedure QFileDialog_setNameFilter(handle: QFileDialogH; filter: PWideString); cdecl; external Qt4PasLib name 'QFileDialog_setNameFilter';
procedure QFileDialog_setNameFilters(handle: QFileDialogH; filters: QStringListH); cdecl; external Qt4PasLib name 'QFileDialog_setNameFilters';
procedure QFileDialog_nameFilters(handle: QFileDialogH; retval: QStringListH); cdecl; external Qt4PasLib name 'QFileDialog_nameFilters';
procedure QFileDialog_selectNameFilter(handle: QFileDialogH; filter: PWideString); cdecl; external Qt4PasLib name 'QFileDialog_selectNameFilter';
procedure QFileDialog_selectedNameFilter(handle: QFileDialogH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileDialog_selectedNameFilter';
function QFileDialog_filter(handle: QFileDialogH): QDirFilters; cdecl; external Qt4PasLib name 'QFileDialog_filter';
procedure QFileDialog_setFilter(handle: QFileDialogH; filters: QDirFilters); cdecl; external Qt4PasLib name 'QFileDialog_setFilter';
procedure QFileDialog_setViewMode(handle: QFileDialogH; mode: QFileDialogViewMode); cdecl; external Qt4PasLib name 'QFileDialog_setViewMode';
function QFileDialog_viewMode(handle: QFileDialogH): QFileDialogViewMode; cdecl; external Qt4PasLib name 'QFileDialog_viewMode';
procedure QFileDialog_setFileMode(handle: QFileDialogH; mode: QFileDialogFileMode); cdecl; external Qt4PasLib name 'QFileDialog_setFileMode';
function QFileDialog_fileMode(handle: QFileDialogH): QFileDialogFileMode; cdecl; external Qt4PasLib name 'QFileDialog_fileMode';
procedure QFileDialog_setAcceptMode(handle: QFileDialogH; mode: QFileDialogAcceptMode); cdecl; external Qt4PasLib name 'QFileDialog_setAcceptMode';
function QFileDialog_acceptMode(handle: QFileDialogH): QFileDialogAcceptMode; cdecl; external Qt4PasLib name 'QFileDialog_acceptMode';
procedure QFileDialog_setReadOnly(handle: QFileDialogH; enabled: Boolean); cdecl; external Qt4PasLib name 'QFileDialog_setReadOnly';
function QFileDialog_isReadOnly(handle: QFileDialogH): Boolean; cdecl; external Qt4PasLib name 'QFileDialog_isReadOnly';
procedure QFileDialog_setResolveSymlinks(handle: QFileDialogH; enabled: Boolean); cdecl; external Qt4PasLib name 'QFileDialog_setResolveSymlinks';
function QFileDialog_resolveSymlinks(handle: QFileDialogH): Boolean; cdecl; external Qt4PasLib name 'QFileDialog_resolveSymlinks';
procedure QFileDialog_saveState(handle: QFileDialogH; retval: QByteArrayH); cdecl; external Qt4PasLib name 'QFileDialog_saveState';
function QFileDialog_restoreState(handle: QFileDialogH; state: QByteArrayH): Boolean; cdecl; external Qt4PasLib name 'QFileDialog_restoreState';
procedure QFileDialog_setConfirmOverwrite(handle: QFileDialogH; enabled: Boolean); cdecl; external Qt4PasLib name 'QFileDialog_setConfirmOverwrite';
function QFileDialog_confirmOverwrite(handle: QFileDialogH): Boolean; cdecl; external Qt4PasLib name 'QFileDialog_confirmOverwrite';
procedure QFileDialog_setDefaultSuffix(handle: QFileDialogH; suffix: PWideString); cdecl; external Qt4PasLib name 'QFileDialog_setDefaultSuffix';
procedure QFileDialog_defaultSuffix(handle: QFileDialogH; retval: PWideString); cdecl; external Qt4PasLib name 'QFileDialog_defaultSuffix';
procedure QFileDialog_setHistory(handle: QFileDialogH; paths: QStringListH); cdecl; external Qt4PasLib name 'QFileDialog_setHistory';
procedure QFileDialog_history(handle: QFileDialogH; retval: QStringListH); cdecl; external Qt4PasLib name 'QFileDialog_history';
procedure QFileDialog_setItemDelegate(handle: QFileDialogH; delegate: QAbstractItemDelegateH); cdecl; external Qt4PasLib name 'QFileDialog_setItemDelegate';
function QFileDialog_itemDelegate(handle: QFileDialogH): QAbstractItemDelegateH; cdecl; external Qt4PasLib name 'QFileDialog_itemDelegate';
procedure QFileDialog_setIconProvider(handle: QFileDialogH; provider: QFileIconProviderH); cdecl; external Qt4PasLib name 'QFileDialog_setIconProvider';
function QFileDialog_iconProvider(handle: QFileDialogH): QFileIconProviderH; cdecl; external Qt4PasLib name 'QFileDialog_iconProvider';
procedure QFileDialog_setLabelText(handle: QFileDialogH; _label: QFileDialogDialogLabel; text: PWideString); cdecl; external Qt4PasLib name 'QFileDialog_setLabelText';
procedure QFileDialog_labelText(handle: QFileDialogH; retval: PWideString; _label: QFileDialogDialogLabel); cdecl; external Qt4PasLib name 'QFileDialog_labelText';
procedure QFileDialog_setProxyModel(handle: QFileDialogH; model: QAbstractProxyModelH); cdecl; external Qt4PasLib name 'QFileDialog_setProxyModel';
function QFileDialog_proxyModel(handle: QFileDialogH): QAbstractProxyModelH; cdecl; external Qt4PasLib name 'QFileDialog_proxyModel';
procedure QFileDialog_setOption(handle: QFileDialogH; option: QFileDialogOption; _on: Boolean = True); cdecl; external Qt4PasLib name 'QFileDialog_setOption';
function QFileDialog_testOption(handle: QFileDialogH; option: QFileDialogOption): Boolean; cdecl; external Qt4PasLib name 'QFileDialog_testOption';
procedure QFileDialog_setOptions(handle: QFileDialogH; options: QFileDialogOptions); cdecl; external Qt4PasLib name 'QFileDialog_setOptions';
function QFileDialog_options(handle: QFileDialogH): QFileDialogOptions; cdecl; external Qt4PasLib name 'QFileDialog_options';
procedure QFileDialog_open(handle: QFileDialogH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QFileDialog_open';
procedure QFileDialog_setVisible(handle: QFileDialogH; visible: Boolean); cdecl; external Qt4PasLib name 'QFileDialog_setVisible';
procedure QFileDialog_getOpenFileName(retval: PWideString; parent: QWidgetH = nil; caption: PWideString = nil; dir: PWideString = nil; filter: PWideString = nil; selectedFilter: PWideString = nil; options: QFileDialogOptions = 0); cdecl; external Qt4PasLib name 'QFileDialog_getOpenFileName';
procedure QFileDialog_getSaveFileName(retval: PWideString; parent: QWidgetH = nil; caption: PWideString = nil; dir: PWideString = nil; filter: PWideString = nil; selectedFilter: PWideString = nil; options: QFileDialogOptions = 0); cdecl; external Qt4PasLib name 'QFileDialog_getSaveFileName';
procedure QFileDialog_getExistingDirectory(retval: PWideString; parent: QWidgetH = nil; caption: PWideString = nil; dir: PWideString = nil; options: QFileDialogOptions = QFileDialogShowDirsOnly); cdecl; external Qt4PasLib name 'QFileDialog_getExistingDirectory';
procedure QFileDialog_getOpenFileNames(retval: QStringListH; parent: QWidgetH = nil; caption: PWideString = nil; dir: PWideString = nil; filter: PWideString = nil; selectedFilter: PWideString = nil; options: QFileDialogOptions = 0); cdecl; external Qt4PasLib name 'QFileDialog_getOpenFileNames';


type
  QFileDialog_fileSelected_Event = procedure (_file: PWideString) of object cdecl;
  QFileDialog_filesSelected_Event = procedure (files: QStringListH) of object cdecl;
  QFileDialog_currentChanged_Event = procedure (path: PWideString) of object cdecl;
  QFileDialog_directoryEntered_Event = procedure (directory: PWideString) of object cdecl;
  QFileDialog_filterSelected_Event = procedure (filter: PWideString) of object cdecl;


function QProgressDialog_create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QProgressDialogH; cdecl; external Qt4PasLib name 'QProgressDialog_create';
procedure QProgressDialog_destroy(handle: QProgressDialogH); cdecl; external Qt4PasLib name 'QProgressDialog_destroy'; 
function QProgressDialog_create(labelText: PWideString; cancelButtonText: PWideString; minimum: Integer; maximum: Integer; parent: QWidgetH = nil; flags: QtWindowFlags = 0): QProgressDialogH; cdecl; external Qt4PasLib name 'QProgressDialog_create2';
procedure QProgressDialog_setLabel(handle: QProgressDialogH; _label: QLabelH); cdecl; external Qt4PasLib name 'QProgressDialog_setLabel';
procedure QProgressDialog_setCancelButton(handle: QProgressDialogH; button: QPushButtonH); cdecl; external Qt4PasLib name 'QProgressDialog_setCancelButton';
procedure QProgressDialog_setBar(handle: QProgressDialogH; bar: QProgressBarH); cdecl; external Qt4PasLib name 'QProgressDialog_setBar';
function QProgressDialog_wasCanceled(handle: QProgressDialogH): Boolean; cdecl; external Qt4PasLib name 'QProgressDialog_wasCanceled';
function QProgressDialog_minimum(handle: QProgressDialogH): Integer; cdecl; external Qt4PasLib name 'QProgressDialog_minimum';
function QProgressDialog_maximum(handle: QProgressDialogH): Integer; cdecl; external Qt4PasLib name 'QProgressDialog_maximum';
function QProgressDialog_value(handle: QProgressDialogH): Integer; cdecl; external Qt4PasLib name 'QProgressDialog_value';
procedure QProgressDialog_sizeHint(handle: QProgressDialogH; retval: PSize); cdecl; external Qt4PasLib name 'QProgressDialog_sizeHint';
procedure QProgressDialog_labelText(handle: QProgressDialogH; retval: PWideString); cdecl; external Qt4PasLib name 'QProgressDialog_labelText';
function QProgressDialog_minimumDuration(handle: QProgressDialogH): Integer; cdecl; external Qt4PasLib name 'QProgressDialog_minimumDuration';
procedure QProgressDialog_setAutoReset(handle: QProgressDialogH; reset: Boolean); cdecl; external Qt4PasLib name 'QProgressDialog_setAutoReset';
function QProgressDialog_autoReset(handle: QProgressDialogH): Boolean; cdecl; external Qt4PasLib name 'QProgressDialog_autoReset';
procedure QProgressDialog_setAutoClose(handle: QProgressDialogH; close: Boolean); cdecl; external Qt4PasLib name 'QProgressDialog_setAutoClose';
function QProgressDialog_autoClose(handle: QProgressDialogH): Boolean; cdecl; external Qt4PasLib name 'QProgressDialog_autoClose';
procedure QProgressDialog_open(handle: QProgressDialogH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QProgressDialog_open';
procedure QProgressDialog_cancel(handle: QProgressDialogH); cdecl; external Qt4PasLib name 'QProgressDialog_cancel';
procedure QProgressDialog_reset(handle: QProgressDialogH); cdecl; external Qt4PasLib name 'QProgressDialog_reset';
procedure QProgressDialog_setMaximum(handle: QProgressDialogH; maximum: Integer); cdecl; external Qt4PasLib name 'QProgressDialog_setMaximum';
procedure QProgressDialog_setMinimum(handle: QProgressDialogH; minimum: Integer); cdecl; external Qt4PasLib name 'QProgressDialog_setMinimum';
procedure QProgressDialog_setRange(handle: QProgressDialogH; minimum: Integer; maximum: Integer); cdecl; external Qt4PasLib name 'QProgressDialog_setRange';
procedure QProgressDialog_setValue(handle: QProgressDialogH; progress: Integer); cdecl; external Qt4PasLib name 'QProgressDialog_setValue';
procedure QProgressDialog_setLabelText(handle: QProgressDialogH; text: PWideString); cdecl; external Qt4PasLib name 'QProgressDialog_setLabelText';
procedure QProgressDialog_setCancelButtonText(handle: QProgressDialogH; text: PWideString); cdecl; external Qt4PasLib name 'QProgressDialog_setCancelButtonText';
procedure QProgressDialog_setMinimumDuration(handle: QProgressDialogH; ms: Integer); cdecl; external Qt4PasLib name 'QProgressDialog_setMinimumDuration';


type
  QProgressDialog_canceled_Event = procedure () of object cdecl;



type
  QAbstractPrintDialogPrintRange = ( // QAbstractPrintDialog::PrintRange (1)
    QAbstractPrintDialogAllPages, QAbstractPrintDialogSelection, QAbstractPrintDialogPageRange );

type
  QAbstractPrintDialogPrintDialogOption = cardinal; // QAbstractPrintDialog::PrintDialogOption
  QAbstractPrintDialogPrintDialogOptions = QAbstractPrintDialogPrintDialogOption; //QFlags<> (3)
const
  QAbstractPrintDialogNone =   $0000;
  QAbstractPrintDialogPrintToFile =   $0001;
  QAbstractPrintDialogPrintSelection =   $0002;
  QAbstractPrintDialogPrintPageRange =   $0004;
  QAbstractPrintDialogPrintShowPageSize =   $0008;
  QAbstractPrintDialogPrintCollateCopies =   $0010;
  QAbstractPrintDialogDontUseSheet =   $0020;

function QAbstractPrintDialog_exec(handle: QAbstractPrintDialogH): Integer; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_exec';
procedure QAbstractPrintDialog_addEnabledOption(handle: QAbstractPrintDialogH; option: QAbstractPrintDialogPrintDialogOption); cdecl; external Qt4PasLib name 'QAbstractPrintDialog_addEnabledOption';
procedure QAbstractPrintDialog_setEnabledOptions(handle: QAbstractPrintDialogH; options: QAbstractPrintDialogPrintDialogOptions); cdecl; external Qt4PasLib name 'QAbstractPrintDialog_setEnabledOptions';
function QAbstractPrintDialog_enabledOptions(handle: QAbstractPrintDialogH): QAbstractPrintDialogPrintDialogOptions; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_enabledOptions';
function QAbstractPrintDialog_isOptionEnabled(handle: QAbstractPrintDialogH; option: QAbstractPrintDialogPrintDialogOption): Boolean; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_isOptionEnabled';
procedure QAbstractPrintDialog_setPrintRange(handle: QAbstractPrintDialogH; range: QAbstractPrintDialogPrintRange); cdecl; external Qt4PasLib name 'QAbstractPrintDialog_setPrintRange';
function QAbstractPrintDialog_printRange(handle: QAbstractPrintDialogH): QAbstractPrintDialogPrintRange; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_printRange';
procedure QAbstractPrintDialog_setMinMax(handle: QAbstractPrintDialogH; min: Integer; max: Integer); cdecl; external Qt4PasLib name 'QAbstractPrintDialog_setMinMax';
function QAbstractPrintDialog_minPage(handle: QAbstractPrintDialogH): Integer; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_minPage';
function QAbstractPrintDialog_maxPage(handle: QAbstractPrintDialogH): Integer; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_maxPage';
procedure QAbstractPrintDialog_setFromTo(handle: QAbstractPrintDialogH; fromPage: Integer; toPage: Integer); cdecl; external Qt4PasLib name 'QAbstractPrintDialog_setFromTo';
function QAbstractPrintDialog_fromPage(handle: QAbstractPrintDialogH): Integer; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_fromPage';
function QAbstractPrintDialog_toPage(handle: QAbstractPrintDialogH): Integer; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_toPage';
function QAbstractPrintDialog_printer(handle: QAbstractPrintDialogH): QPrinterH; cdecl; external Qt4PasLib name 'QAbstractPrintDialog_printer';

function QPrintDialog_create(printer: QPrinterH; parent: QWidgetH = nil): QPrintDialogH; cdecl; external Qt4PasLib name 'QPrintDialog_create';
procedure QPrintDialog_destroy(handle: QPrintDialogH); cdecl; external Qt4PasLib name 'QPrintDialog_destroy'; 
function QPrintDialog_create(parent: QWidgetH = nil): QPrintDialogH; cdecl; external Qt4PasLib name 'QPrintDialog_create2';
function QPrintDialog_exec(handle: QPrintDialogH): Integer; cdecl; external Qt4PasLib name 'QPrintDialog_exec';
{$ifdef BINUX or QTOPIA }
procedure QPrintDialog_accept(handle: QPrintDialogH); cdecl; external Qt4PasLib name 'QPrintDialog_accept';
{$endif}
procedure QPrintDialog_done(handle: QPrintDialogH; result: Integer); cdecl; external Qt4PasLib name 'QPrintDialog_done';
procedure QPrintDialog_setOption(handle: QPrintDialogH; option: QAbstractPrintDialogPrintDialogOption; _on: Boolean = True); cdecl; external Qt4PasLib name 'QPrintDialog_setOption';
function QPrintDialog_testOption(handle: QPrintDialogH; option: QAbstractPrintDialogPrintDialogOption): Boolean; cdecl; external Qt4PasLib name 'QPrintDialog_testOption';
procedure QPrintDialog_setOptions(handle: QPrintDialogH; options: QAbstractPrintDialogPrintDialogOptions); cdecl; external Qt4PasLib name 'QPrintDialog_setOptions';
function QPrintDialog_options(handle: QPrintDialogH): QAbstractPrintDialogPrintDialogOptions; cdecl; external Qt4PasLib name 'QPrintDialog_options';
{$ifdef BINUX or DARWIN or QTOPIA }
procedure QPrintDialog_setVisible(handle: QPrintDialogH; visible: Boolean); cdecl; external Qt4PasLib name 'QPrintDialog_setVisible';
{$endif}
procedure QPrintDialog_open(handle: QPrintDialogH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QPrintDialog_open';


type
  QPrintDialog_accepted_Event = procedure (printer: QPrinterH) of object cdecl;


type
  QPageSetupDialogPageSetupDialogOption = cardinal; // QPageSetupDialog::PageSetupDialogOption
  QPageSetupDialogPageSetupDialogOptions = QPageSetupDialogPageSetupDialogOption; //QFlags<> (3)
const
  QPageSetupDialogNone =   $00000000;
  QPageSetupDialogDontUseSheet =   $00000001;
  QPageSetupDialogOwnsPrinter =   $80000000;

function QPageSetupDialog_create(printer: QPrinterH; parent: QWidgetH = nil): QPageSetupDialogH; cdecl; external Qt4PasLib name 'QPageSetupDialog_create';
procedure QPageSetupDialog_destroy(handle: QPageSetupDialogH); cdecl; external Qt4PasLib name 'QPageSetupDialog_destroy'; 
function QPageSetupDialog_create(parent: QWidgetH = nil): QPageSetupDialogH; cdecl; external Qt4PasLib name 'QPageSetupDialog_create2';
procedure QPageSetupDialog_addEnabledOption(handle: QPageSetupDialogH; option: QPageSetupDialogPageSetupDialogOption); cdecl; external Qt4PasLib name 'QPageSetupDialog_addEnabledOption';
procedure QPageSetupDialog_setEnabledOptions(handle: QPageSetupDialogH; options: QPageSetupDialogPageSetupDialogOptions); cdecl; external Qt4PasLib name 'QPageSetupDialog_setEnabledOptions';
function QPageSetupDialog_enabledOptions(handle: QPageSetupDialogH): QPageSetupDialogPageSetupDialogOptions; cdecl; external Qt4PasLib name 'QPageSetupDialog_enabledOptions';
function QPageSetupDialog_isOptionEnabled(handle: QPageSetupDialogH; option: QPageSetupDialogPageSetupDialogOption): Boolean; cdecl; external Qt4PasLib name 'QPageSetupDialog_isOptionEnabled';
procedure QPageSetupDialog_setOption(handle: QPageSetupDialogH; option: QPageSetupDialogPageSetupDialogOption; _on: Boolean = True); cdecl; external Qt4PasLib name 'QPageSetupDialog_setOption';
function QPageSetupDialog_testOption(handle: QPageSetupDialogH; option: QPageSetupDialogPageSetupDialogOption): Boolean; cdecl; external Qt4PasLib name 'QPageSetupDialog_testOption';
procedure QPageSetupDialog_setOptions(handle: QPageSetupDialogH; options: QPageSetupDialogPageSetupDialogOptions); cdecl; external Qt4PasLib name 'QPageSetupDialog_setOptions';
function QPageSetupDialog_options(handle: QPageSetupDialogH): QPageSetupDialogPageSetupDialogOptions; cdecl; external Qt4PasLib name 'QPageSetupDialog_options';
function QPageSetupDialog_exec(handle: QPageSetupDialogH): Integer; cdecl; external Qt4PasLib name 'QPageSetupDialog_exec';
procedure QPageSetupDialog_open(handle: QPageSetupDialogH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QPageSetupDialog_open';
{$ifdef DARWIN }
procedure QPageSetupDialog_setVisible(handle: QPageSetupDialogH; visible: Boolean); cdecl; external Qt4PasLib name 'QPageSetupDialog_setVisible';
{$endif}

function QPrintPreviewDialog_create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QPrintPreviewDialogH; cdecl; external Qt4PasLib name 'QPrintPreviewDialog_create';
procedure QPrintPreviewDialog_destroy(handle: QPrintPreviewDialogH); cdecl; external Qt4PasLib name 'QPrintPreviewDialog_destroy'; 
function QPrintPreviewDialog_create(printer: QPrinterH; parent: QWidgetH = nil; flags: QtWindowFlags = 0): QPrintPreviewDialogH; cdecl; external Qt4PasLib name 'QPrintPreviewDialog_create2';
procedure QPrintPreviewDialog_open(handle: QPrintPreviewDialogH; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt4PasLib name 'QPrintPreviewDialog_open';
function QPrintPreviewDialog_printer(handle: QPrintPreviewDialogH): QPrinterH; cdecl; external Qt4PasLib name 'QPrintPreviewDialog_printer';
procedure QPrintPreviewDialog_setVisible(handle: QPrintPreviewDialogH; visible: Boolean); cdecl; external Qt4PasLib name 'QPrintPreviewDialog_setVisible';
procedure QPrintPreviewDialog_done(handle: QPrintPreviewDialogH; result: Integer); cdecl; external Qt4PasLib name 'QPrintPreviewDialog_done';


type
  QPrintPreviewDialog_paintRequested_Event = procedure (printer: QPrinterH) of object cdecl;



type
  QSystemTrayIconActivationReason = ( // QSystemTrayIcon::ActivationReason (1)
    QSystemTrayIconUnknown, QSystemTrayIconContext, QSystemTrayIconDoubleClick, QSystemTrayIconTrigger, QSystemTrayIconMiddleClick );

  QSystemTrayIconMessageIcon = ( // QSystemTrayIcon::MessageIcon (1)
    QSystemTrayIconNoIcon, QSystemTrayIconInformation, QSystemTrayIconWarning, QSystemTrayIconCritical );

function QSystemTrayIcon_create(parent: QObjectH = nil): QSystemTrayIconH; cdecl; external Qt4PasLib name 'QSystemTrayIcon_create';
procedure QSystemTrayIcon_destroy(handle: QSystemTrayIconH); cdecl; external Qt4PasLib name 'QSystemTrayIcon_destroy'; 
function QSystemTrayIcon_create(icon: QIconH; parent: QObjectH = nil): QSystemTrayIconH; cdecl; external Qt4PasLib name 'QSystemTrayIcon_create2';
procedure QSystemTrayIcon_setContextMenu(handle: QSystemTrayIconH; menu: QMenuH); cdecl; external Qt4PasLib name 'QSystemTrayIcon_setContextMenu';
function QSystemTrayIcon_contextMenu(handle: QSystemTrayIconH): QMenuH; cdecl; external Qt4PasLib name 'QSystemTrayIcon_contextMenu';
procedure QSystemTrayIcon_icon(handle: QSystemTrayIconH; retval: QIconH); cdecl; external Qt4PasLib name 'QSystemTrayIcon_icon';
procedure QSystemTrayIcon_setIcon(handle: QSystemTrayIconH; icon: QIconH); cdecl; external Qt4PasLib name 'QSystemTrayIcon_setIcon';
procedure QSystemTrayIcon_toolTip(handle: QSystemTrayIconH; retval: PWideString); cdecl; external Qt4PasLib name 'QSystemTrayIcon_toolTip';
procedure QSystemTrayIcon_setToolTip(handle: QSystemTrayIconH; tip: PWideString); cdecl; external Qt4PasLib name 'QSystemTrayIcon_setToolTip';
function QSystemTrayIcon_isSystemTrayAvailable(): Boolean; cdecl; external Qt4PasLib name 'QSystemTrayIcon_isSystemTrayAvailable';
function QSystemTrayIcon_supportsMessages(): Boolean; cdecl; external Qt4PasLib name 'QSystemTrayIcon_supportsMessages';
procedure QSystemTrayIcon_showMessage(handle: QSystemTrayIconH; title: PWideString; msg: PWideString; icon: QSystemTrayIconMessageIcon = QSystemTrayIconInformation; msecs: Integer = 10000); cdecl; external Qt4PasLib name 'QSystemTrayIcon_showMessage';
procedure QSystemTrayIcon_geometry(handle: QSystemTrayIconH; retval: PRect); cdecl; external Qt4PasLib name 'QSystemTrayIcon_geometry';
function QSystemTrayIcon_isVisible(handle: QSystemTrayIconH): Boolean; cdecl; external Qt4PasLib name 'QSystemTrayIcon_isVisible';
procedure QSystemTrayIcon_setVisible(handle: QSystemTrayIconH; visible: Boolean); cdecl; external Qt4PasLib name 'QSystemTrayIcon_setVisible';
procedure QSystemTrayIcon_show(handle: QSystemTrayIconH); cdecl; external Qt4PasLib name 'QSystemTrayIcon_show';
procedure QSystemTrayIcon_hide(handle: QSystemTrayIconH); cdecl; external Qt4PasLib name 'QSystemTrayIcon_hide';


type
  QSystemTrayIcon_activated_Event = procedure (reason: QSystemTrayIconActivationReason) of object cdecl;
  QSystemTrayIcon_messageClicked_Event = procedure () of object cdecl;


type
  QStyleStateFlag = cardinal; // QStyle::StateFlag
  QStyleState = QStyleStateFlag; //QFlags<> (3)
const
  QStyleState_None =   $00000000;
  QStyleState_Enabled =   $00000001;
  QStyleState_Raised =   $00000002;
  QStyleState_Sunken =   $00000004;
  QStyleState_Off =   $00000008;
  QStyleState_NoChange =   $00000010;
  QStyleState_On =   $00000020;
  QStyleState_DownArrow =   $00000040;
  QStyleState_Horizontal =   $00000080;
  QStyleState_HasFocus =   $00000100;
  QStyleState_Top =   $00000200;
  QStyleState_Bottom =   $00000400;
  QStyleState_FocusAtBorder =   $00000800;
  QStyleState_AutoRaise =   $00001000;
  QStyleState_MouseOver =   $00002000;
  QStyleState_UpArrow =   $00004000;
  QStyleState_Selected =   $00008000;
  QStyleState_Active =   $00010000;
  QStyleState_Window =   $00020000;
  QStyleState_Open =   $00040000;
  QStyleState_Children =   $00080000;
  QStyleState_Item =   $00100000;
  QStyleState_Sibling =   $00200000;
  QStyleState_Editing =   $00400000;
  QStyleState_KeyboardFocusChange =   $00800000;
  QStyleState_ReadOnly =   $02000000;
  QStyleState_Small =   $04000000;
  QStyleState_Mini =   $08000000;


type
  QStyleControlElement = (  //QStyle::ControlElement (2)
    QStyleCE_PushButton,
    QStyleCE_PushButtonBevel,
    QStyleCE_PushButtonLabel,
    QStyleCE_CheckBox,
    QStyleCE_CheckBoxLabel,
    QStyleCE_RadioButton,
    QStyleCE_RadioButtonLabel,
    QStyleCE_TabBarTab,
    QStyleCE_TabBarTabShape,
    QStyleCE_TabBarTabLabel,
    QStyleCE_ProgressBar,
    QStyleCE_ProgressBarGroove,
    QStyleCE_ProgressBarContents,
    QStyleCE_ProgressBarLabel,
    QStyleCE_MenuItem,
    QStyleCE_MenuScroller,
    QStyleCE_MenuVMargin,
    QStyleCE_MenuHMargin,
    QStyleCE_MenuTearoff,
    QStyleCE_MenuEmptyArea,
    QStyleCE_MenuBarItem,
    QStyleCE_MenuBarEmptyArea,
    QStyleCE_ToolButtonLabel,
    QStyleCE_Header,
    QStyleCE_HeaderSection,
    QStyleCE_HeaderLabel,
    QStyleCE_Q3DockWindowEmptyArea,
    QStyleCE_ToolBoxTab,
    QStyleCE_SizeGrip,
    QStyleCE_Splitter,
    QStyleCE_RubberBand,
    QStyleCE_DockWidgetTitle,
    QStyleCE_ScrollBarAddLine,
    QStyleCE_ScrollBarSubLine,
    QStyleCE_ScrollBarAddPage,
    QStyleCE_ScrollBarSubPage,
    QStyleCE_ScrollBarSlider,
    QStyleCE_ScrollBarFirst,
    QStyleCE_ScrollBarLast,
    QStyleCE_FocusFrame,
    QStyleCE_ComboBoxLabel,
    QStyleCE_ToolBar,
    QStyleCE_ToolBoxTabShape,
    QStyleCE_ToolBoxTabLabel,
    QStyleCE_HeaderEmptyArea,
    QStyleCE_ColumnViewGrip,
    QStyleCE_ItemViewItem,
    QStyleCE_ShapedFrame,
    QStyleCE_CustomBase = $f0000000 );

  QStyleComplexControl = (  //QStyle::ComplexControl (2)
    QStyleCC_SpinBox,
    QStyleCC_ComboBox,
    QStyleCC_ScrollBar,
    QStyleCC_Slider,
    QStyleCC_ToolButton,
    QStyleCC_TitleBar,
    QStyleCC_Q3ListView,
    QStyleCC_Dial,
    QStyleCC_GroupBox,
    QStyleCC_MdiControls,
    QStyleCC_CustomBase = $f0000000 );

type
  QStyleSubControl = cardinal; // QStyle::SubControl
  QStyleSubControls = QStyleSubControl; //QFlags<> (3)
const
  QStyleSC_None =   $00000000;
  QStyleSC_ScrollBarAddLine =   $00000001;
  QStyleSC_ScrollBarSubLine =   $00000002;
  QStyleSC_ScrollBarAddPage =   $00000004;
  QStyleSC_ScrollBarSubPage =   $00000008;
  QStyleSC_ScrollBarFirst =   $00000010;
  QStyleSC_ScrollBarLast =   $00000020;
  QStyleSC_ScrollBarSlider =   $00000040;
  QStyleSC_ScrollBarGroove =   $00000080;
  QStyleSC_SpinBoxUp =   $00000001;
  QStyleSC_SpinBoxDown =   $00000002;
  QStyleSC_SpinBoxFrame =   $00000004;
  QStyleSC_SpinBoxEditField =   $00000008;
  QStyleSC_ComboBoxFrame =   $00000001;
  QStyleSC_ComboBoxEditField =   $00000002;
  QStyleSC_ComboBoxArrow =   $00000004;
  QStyleSC_ComboBoxListBoxPopup =   $00000008;
  QStyleSC_SliderGroove =   $00000001;
  QStyleSC_SliderHandle =   $00000002;
  QStyleSC_SliderTickmarks =   $00000004;
  QStyleSC_ToolButton =   $00000001;
  QStyleSC_ToolButtonMenu =   $00000002;
  QStyleSC_TitleBarSysMenu =   $00000001;
  QStyleSC_TitleBarMinButton =   $00000002;
  QStyleSC_TitleBarMaxButton =   $00000004;
  QStyleSC_TitleBarCloseButton =   $00000008;
  QStyleSC_TitleBarNormalButton =   $00000010;
  QStyleSC_TitleBarShadeButton =   $00000020;
  QStyleSC_TitleBarUnshadeButton =   $00000040;
  QStyleSC_TitleBarContextHelpButton =   $00000080;
  QStyleSC_TitleBarLabel =   $00000100;
  QStyleSC_Q3ListView =   $00000001;
  QStyleSC_Q3ListViewBranch =   $00000002;
  QStyleSC_Q3ListViewExpand =   $00000004;
  QStyleSC_DialGroove =   $00000001;
  QStyleSC_DialHandle =   $00000002;
  QStyleSC_DialTickmarks =   $00000004;
  QStyleSC_GroupBoxCheckBox =   $00000001;
  QStyleSC_GroupBoxLabel =   $00000002;
  QStyleSC_GroupBoxContents =   $00000004;
  QStyleSC_GroupBoxFrame =   $00000008;
  QStyleSC_MdiMinButton =   $00000001;
  QStyleSC_MdiNormalButton =   $00000002;
  QStyleSC_MdiCloseButton =   $00000004;
  QStyleSC_All =   $ffffffff;


type
  QStyleContentsType = (  //QStyle::ContentsType (2)
    QStyleCT_PushButton,
    QStyleCT_CheckBox,
    QStyleCT_RadioButton,
    QStyleCT_ToolButton,
    QStyleCT_ComboBox,
    QStyleCT_Splitter,
    QStyleCT_Q3DockWindow,
    QStyleCT_ProgressBar,
    QStyleCT_MenuItem,
    QStyleCT_MenuBarItem,
    QStyleCT_MenuBar,
    QStyleCT_Menu,
    QStyleCT_TabBarTab,
    QStyleCT_Slider,
    QStyleCT_ScrollBar,
    QStyleCT_Q3Header,
    QStyleCT_LineEdit,
    QStyleCT_SpinBox,
    QStyleCT_SizeGrip,
    QStyleCT_TabWidget,
    QStyleCT_DialogButtons,
    QStyleCT_HeaderSection,
    QStyleCT_GroupBox,
    QStyleCT_MdiControls,
    QStyleCT_ItemViewItem,
    QStyleCT_CustomBase = $f0000000 );

  QStyleStandardPixmap = (  //QStyle::StandardPixmap (2)
    QStyleSP_TitleBarMenuButton,
    QStyleSP_TitleBarMinButton,
    QStyleSP_TitleBarMaxButton,
    QStyleSP_TitleBarCloseButton,
    QStyleSP_TitleBarNormalButton,
    QStyleSP_TitleBarShadeButton,
    QStyleSP_TitleBarUnshadeButton,
    QStyleSP_TitleBarContextHelpButton,
    QStyleSP_DockWidgetCloseButton,
    QStyleSP_MessageBoxInformation,
    QStyleSP_MessageBoxWarning,
    QStyleSP_MessageBoxCritical,
    QStyleSP_MessageBoxQuestion,
    QStyleSP_DesktopIcon,
    QStyleSP_TrashIcon,
    QStyleSP_ComputerIcon,
    QStyleSP_DriveFDIcon,
    QStyleSP_DriveHDIcon,
    QStyleSP_DriveCDIcon,
    QStyleSP_DriveDVDIcon,
    QStyleSP_DriveNetIcon,
    QStyleSP_DirOpenIcon,
    QStyleSP_DirClosedIcon,
    QStyleSP_DirLinkIcon,
    QStyleSP_FileIcon,
    QStyleSP_FileLinkIcon,
    QStyleSP_ToolBarHorizontalExtensionButton,
    QStyleSP_ToolBarVerticalExtensionButton,
    QStyleSP_FileDialogStart,
    QStyleSP_FileDialogEnd,
    QStyleSP_FileDialogToParent,
    QStyleSP_FileDialogNewFolder,
    QStyleSP_FileDialogDetailedView,
    QStyleSP_FileDialogInfoView,
    QStyleSP_FileDialogContentsView,
    QStyleSP_FileDialogListView,
    QStyleSP_FileDialogBack,
    QStyleSP_DirIcon,
    QStyleSP_DialogOkButton,
    QStyleSP_DialogCancelButton,
    QStyleSP_DialogHelpButton,
    QStyleSP_DialogOpenButton,
    QStyleSP_DialogSaveButton,
    QStyleSP_DialogCloseButton,
    QStyleSP_DialogApplyButton,
    QStyleSP_DialogResetButton,
    QStyleSP_DialogDiscardButton,
    QStyleSP_DialogYesButton,
    QStyleSP_DialogNoButton,
    QStyleSP_ArrowUp,
    QStyleSP_ArrowDown,
    QStyleSP_ArrowLeft,
    QStyleSP_ArrowRight,
    QStyleSP_ArrowBack,
    QStyleSP_ArrowForward,
    QStyleSP_DirHomeIcon,
    QStyleSP_CommandLink,
    QStyleSP_VistaShield,
    QStyleSP_BrowserReload,
    QStyleSP_BrowserStop,
    QStyleSP_MediaPlay,
    QStyleSP_MediaStop,
    QStyleSP_MediaPause,
    QStyleSP_MediaSkipForward,
    QStyleSP_MediaSkipBackward,
    QStyleSP_MediaSeekForward,
    QStyleSP_MediaSeekBackward,
    QStyleSP_MediaVolume,
    QStyleSP_MediaVolumeMuted,
    QStyleSP_CustomBase = $f0000000 );

type
  QStylePrimitiveElement = cardinal; //  QStyle::PrimitiveElement (4)

const
    QStylePE_Q3CheckListController = 0 { $0 };
    QStylePE_Q3CheckListExclusiveIndicator = 1 { $1 };
    QStylePE_Q3CheckListIndicator = 2 { $2 };
    QStylePE_Q3DockWindowSeparator = 3 { $3 };
    QStylePE_Q3Separator = 4 { $4 };
    QStylePE_Frame = 5 { $5 };
    QStylePE_FrameDefaultButton = 6 { $6 };
    QStylePE_FrameDockWidget = 7 { $7 };
    QStylePE_FrameFocusRect = 8 { $8 };
    QStylePE_FrameGroupBox = 9 { $9 };
    QStylePE_FrameLineEdit = 10 { $a };
    QStylePE_FrameMenu = 11 { $b };
    QStylePE_FrameStatusBar = 12 { $c };
    QStylePE_FrameStatusBarItem = 12 { $c };
    QStylePE_FrameTabWidget = 13 { $d };
    QStylePE_FrameWindow = 14 { $e };
    QStylePE_FrameButtonBevel = 15 { $f };
    QStylePE_FrameButtonTool = 16 { $10 };
    QStylePE_FrameTabBarBase = 17 { $11 };
    QStylePE_PanelButtonCommand = 18 { $12 };
    QStylePE_PanelButtonBevel = 19 { $13 };
    QStylePE_PanelButtonTool = 20 { $14 };
    QStylePE_PanelMenuBar = 21 { $15 };
    QStylePE_PanelToolBar = 22 { $16 };
    QStylePE_PanelLineEdit = 23 { $17 };
    QStylePE_IndicatorArrowDown = 24 { $18 };
    QStylePE_IndicatorArrowLeft = 25 { $19 };
    QStylePE_IndicatorArrowRight = 26 { $1a };
    QStylePE_IndicatorArrowUp = 27 { $1b };
    QStylePE_IndicatorBranch = 28 { $1c };
    QStylePE_IndicatorButtonDropDown = 29 { $1d };
    QStylePE_IndicatorViewItemCheck = 30 { $1e };
    QStylePE_IndicatorItemViewItemCheck = 30 { $1e };
    QStylePE_IndicatorCheckBox = 31 { $1f };
    QStylePE_IndicatorDockWidgetResizeHandle = 32 { $20 };
    QStylePE_IndicatorHeaderArrow = 33 { $21 };
    QStylePE_IndicatorMenuCheckMark = 34 { $22 };
    QStylePE_IndicatorProgressChunk = 35 { $23 };
    QStylePE_IndicatorRadioButton = 36 { $24 };
    QStylePE_IndicatorSpinDown = 37 { $25 };
    QStylePE_IndicatorSpinMinus = 38 { $26 };
    QStylePE_IndicatorSpinPlus = 39 { $27 };
    QStylePE_IndicatorSpinUp = 40 { $28 };
    QStylePE_IndicatorToolBarHandle = 41 { $29 };
    QStylePE_IndicatorToolBarSeparator = 42 { $2a };
    QStylePE_PanelTipLabel = 43 { $2b };
    QStylePE_IndicatorTabTear = 44 { $2c };
    QStylePE_PanelScrollAreaCorner = 45 { $2d };
    QStylePE_Widget = 46 { $2e };
    QStylePE_IndicatorColumnViewArrow = 47 { $2f };
    QStylePE_IndicatorItemViewItemDrop = 48 { $30 };
    QStylePE_PanelItemViewItem = 49 { $31 };
    QStylePE_PanelItemViewRow = 50 { $32 };
    QStylePE_PanelStatusBar = 51 { $33 };
    QStylePE_IndicatorTabClose = 52 { $34 };
    QStylePE_PanelMenu = 53 { $35 };
    QStylePE_CustomBase = 251658240 { $f000000 };

type
  QStyleSubElement = cardinal; //  QStyle::SubElement (4)

const
    QStyleSE_PushButtonContents = 0 { $0 };
    QStyleSE_PushButtonFocusRect = 1 { $1 };
    QStyleSE_CheckBoxIndicator = 2 { $2 };
    QStyleSE_CheckBoxContents = 3 { $3 };
    QStyleSE_CheckBoxFocusRect = 4 { $4 };
    QStyleSE_CheckBoxClickRect = 5 { $5 };
    QStyleSE_RadioButtonIndicator = 6 { $6 };
    QStyleSE_RadioButtonContents = 7 { $7 };
    QStyleSE_RadioButtonFocusRect = 8 { $8 };
    QStyleSE_RadioButtonClickRect = 9 { $9 };
    QStyleSE_ComboBoxFocusRect = 10 { $a };
    QStyleSE_SliderFocusRect = 11 { $b };
    QStyleSE_Q3DockWindowHandleRect = 12 { $c };
    QStyleSE_ProgressBarGroove = 13 { $d };
    QStyleSE_ProgressBarContents = 14 { $e };
    QStyleSE_ProgressBarLabel = 15 { $f };
    QStyleSE_DialogButtonAccept = 16 { $10 };
    QStyleSE_DialogButtonReject = 17 { $11 };
    QStyleSE_DialogButtonApply = 18 { $12 };
    QStyleSE_DialogButtonHelp = 19 { $13 };
    QStyleSE_DialogButtonAll = 20 { $14 };
    QStyleSE_DialogButtonAbort = 21 { $15 };
    QStyleSE_DialogButtonIgnore = 22 { $16 };
    QStyleSE_DialogButtonRetry = 23 { $17 };
    QStyleSE_DialogButtonCustom = 24 { $18 };
    QStyleSE_ToolBoxTabContents = 25 { $19 };
    QStyleSE_HeaderLabel = 26 { $1a };
    QStyleSE_HeaderArrow = 27 { $1b };
    QStyleSE_TabWidgetTabBar = 28 { $1c };
    QStyleSE_TabWidgetTabPane = 29 { $1d };
    QStyleSE_TabWidgetTabContents = 30 { $1e };
    QStyleSE_TabWidgetLeftCorner = 31 { $1f };
    QStyleSE_TabWidgetRightCorner = 32 { $20 };
    QStyleSE_ViewItemCheckIndicator = 33 { $21 };
    QStyleSE_ItemViewItemCheckIndicator = 33 { $21 };
    QStyleSE_TabBarTearIndicator = 34 { $22 };
    QStyleSE_TreeViewDisclosureItem = 35 { $23 };
    QStyleSE_LineEditContents = 36 { $24 };
    QStyleSE_FrameContents = 37 { $25 };
    QStyleSE_DockWidgetCloseButton = 38 { $26 };
    QStyleSE_DockWidgetFloatButton = 39 { $27 };
    QStyleSE_DockWidgetTitleBarText = 40 { $28 };
    QStyleSE_DockWidgetIcon = 41 { $29 };
    QStyleSE_CheckBoxLayoutItem = 42 { $2a };
    QStyleSE_ComboBoxLayoutItem = 43 { $2b };
    QStyleSE_DateTimeEditLayoutItem = 44 { $2c };
    QStyleSE_DialogButtonBoxLayoutItem = 45 { $2d };
    QStyleSE_LabelLayoutItem = 46 { $2e };
    QStyleSE_ProgressBarLayoutItem = 47 { $2f };
    QStyleSE_PushButtonLayoutItem = 48 { $30 };
    QStyleSE_RadioButtonLayoutItem = 49 { $31 };
    QStyleSE_SliderLayoutItem = 50 { $32 };
    QStyleSE_SpinBoxLayoutItem = 51 { $33 };
    QStyleSE_ToolButtonLayoutItem = 52 { $34 };
    QStyleSE_FrameLayoutItem = 53 { $35 };
    QStyleSE_GroupBoxLayoutItem = 54 { $36 };
    QStyleSE_TabWidgetLayoutItem = 55 { $37 };
    QStyleSE_ItemViewItemDecoration = 56 { $38 };
    QStyleSE_ItemViewItemText = 57 { $39 };
    QStyleSE_ItemViewItemFocusRect = 58 { $3a };
    QStyleSE_TabBarTabLeftButton = 59 { $3b };
    QStyleSE_TabBarTabRightButton = 60 { $3c };
    QStyleSE_TabBarTabText = 61 { $3d };
    QStyleSE_ShapedFrameContents = 62 { $3e };
    QStyleSE_CustomBase = 4026531840 { $f0000000 };

type
  QStylePixelMetric = cardinal; //  QStyle::PixelMetric (4)

const
    QStylePM_ButtonMargin = 0 { $0 };
    QStylePM_ButtonDefaultIndicator = 1 { $1 };
    QStylePM_MenuButtonIndicator = 2 { $2 };
    QStylePM_ButtonShiftHorizontal = 3 { $3 };
    QStylePM_ButtonShiftVertical = 4 { $4 };
    QStylePM_DefaultFrameWidth = 5 { $5 };
    QStylePM_SpinBoxFrameWidth = 6 { $6 };
    QStylePM_ComboBoxFrameWidth = 7 { $7 };
    QStylePM_MaximumDragDistance = 8 { $8 };
    QStylePM_ScrollBarExtent = 9 { $9 };
    QStylePM_ScrollBarSliderMin = 10 { $a };
    QStylePM_SliderThickness = 11 { $b };
    QStylePM_SliderControlThickness = 12 { $c };
    QStylePM_SliderLength = 13 { $d };
    QStylePM_SliderTickmarkOffset = 14 { $e };
    QStylePM_SliderSpaceAvailable = 15 { $f };
    QStylePM_DockWidgetSeparatorExtent = 16 { $10 };
    QStylePM_DockWidgetHandleExtent = 17 { $11 };
    QStylePM_DockWidgetFrameWidth = 18 { $12 };
    QStylePM_TabBarTabOverlap = 19 { $13 };
    QStylePM_TabBarTabHSpace = 20 { $14 };
    QStylePM_TabBarTabVSpace = 21 { $15 };
    QStylePM_TabBarBaseHeight = 22 { $16 };
    QStylePM_TabBarBaseOverlap = 23 { $17 };
    QStylePM_ProgressBarChunkWidth = 24 { $18 };
    QStylePM_SplitterWidth = 25 { $19 };
    QStylePM_TitleBarHeight = 26 { $1a };
    QStylePM_MenuScrollerHeight = 27 { $1b };
    QStylePM_MenuHMargin = 28 { $1c };
    QStylePM_MenuVMargin = 29 { $1d };
    QStylePM_MenuPanelWidth = 30 { $1e };
    QStylePM_MenuTearoffHeight = 31 { $1f };
    QStylePM_MenuDesktopFrameWidth = 32 { $20 };
    QStylePM_MenuBarPanelWidth = 33 { $21 };
    QStylePM_MenuBarItemSpacing = 34 { $22 };
    QStylePM_MenuBarVMargin = 35 { $23 };
    QStylePM_MenuBarHMargin = 36 { $24 };
    QStylePM_IndicatorWidth = 37 { $25 };
    QStylePM_IndicatorHeight = 38 { $26 };
    QStylePM_ExclusiveIndicatorWidth = 39 { $27 };
    QStylePM_ExclusiveIndicatorHeight = 40 { $28 };
    QStylePM_CheckListButtonSize = 41 { $29 };
    QStylePM_CheckListControllerSize = 42 { $2a };
    QStylePM_DialogButtonsSeparator = 43 { $2b };
    QStylePM_DialogButtonsButtonWidth = 44 { $2c };
    QStylePM_DialogButtonsButtonHeight = 45 { $2d };
    QStylePM_MdiSubWindowFrameWidth = 46 { $2e };
    QStylePM_MDIFrameWidth = 46 { $2e };
    QStylePM_MdiSubWindowMinimizedWidth = 47 { $2f };
    QStylePM_MDIMinimizedWidth = 47 { $2f };
    QStylePM_HeaderMargin = 48 { $30 };
    QStylePM_HeaderMarkSize = 49 { $31 };
    QStylePM_HeaderGripMargin = 50 { $32 };
    QStylePM_TabBarTabShiftHorizontal = 51 { $33 };
    QStylePM_TabBarTabShiftVertical = 52 { $34 };
    QStylePM_TabBarScrollButtonWidth = 53 { $35 };
    QStylePM_ToolBarFrameWidth = 54 { $36 };
    QStylePM_ToolBarHandleExtent = 55 { $37 };
    QStylePM_ToolBarItemSpacing = 56 { $38 };
    QStylePM_ToolBarItemMargin = 57 { $39 };
    QStylePM_ToolBarSeparatorExtent = 58 { $3a };
    QStylePM_ToolBarExtensionExtent = 59 { $3b };
    QStylePM_SpinBoxSliderHeight = 60 { $3c };
    QStylePM_DefaultTopLevelMargin = 61 { $3d };
    QStylePM_DefaultChildMargin = 62 { $3e };
    QStylePM_DefaultLayoutSpacing = 63 { $3f };
    QStylePM_ToolBarIconSize = 64 { $40 };
    QStylePM_ListViewIconSize = 65 { $41 };
    QStylePM_IconViewIconSize = 66 { $42 };
    QStylePM_SmallIconSize = 67 { $43 };
    QStylePM_LargeIconSize = 68 { $44 };
    QStylePM_FocusFrameVMargin = 69 { $45 };
    QStylePM_FocusFrameHMargin = 70 { $46 };
    QStylePM_ToolTipLabelFrameWidth = 71 { $47 };
    QStylePM_CheckBoxLabelSpacing = 72 { $48 };
    QStylePM_TabBarIconSize = 73 { $49 };
    QStylePM_SizeGripSize = 74 { $4a };
    QStylePM_DockWidgetTitleMargin = 75 { $4b };
    QStylePM_MessageBoxIconSize = 76 { $4c };
    QStylePM_ButtonIconSize = 77 { $4d };
    QStylePM_DockWidgetTitleBarButtonMargin = 78 { $4e };
    QStylePM_RadioButtonLabelSpacing = 79 { $4f };
    QStylePM_LayoutLeftMargin = 80 { $50 };
    QStylePM_LayoutTopMargin = 81 { $51 };
    QStylePM_LayoutRightMargin = 82 { $52 };
    QStylePM_LayoutBottomMargin = 83 { $53 };
    QStylePM_LayoutHorizontalSpacing = 84 { $54 };
    QStylePM_LayoutVerticalSpacing = 85 { $55 };
    QStylePM_TabBar_ScrollButtonOverlap = 86 { $56 };
    QStylePM_TextCursorWidth = 87 { $57 };
    QStylePM_TabCloseIndicatorWidth = 88 { $58 };
    QStylePM_TabCloseIndicatorHeight = 89 { $59 };
    QStylePM_ScrollView_ScrollBarSpacing = 90 { $5a };
    QStylePM_SubMenuOverlap = 91 { $5b };
    QStylePM_CustomBase = 4026531840 { $f0000000 };

type
  QStyleStyleHint = cardinal; //  QStyle::StyleHint (4)

const
    QStyleSH_EtchDisabledText = 0 { $0 };
    QStyleSH_DitherDisabledText = 1 { $1 };
    QStyleSH_ScrollBar_MiddleClickAbsolutePosition = 2 { $2 };
    QStyleSH_ScrollBar_ScrollWhenPointerLeavesControl = 3 { $3 };
    QStyleSH_TabBar_SelectMouseType = 4 { $4 };
    QStyleSH_TabBar_Alignment = 5 { $5 };
    QStyleSH_Header_ArrowAlignment = 6 { $6 };
    QStyleSH_Slider_SnapToValue = 7 { $7 };
    QStyleSH_Slider_SloppyKeyEvents = 8 { $8 };
    QStyleSH_ProgressDialog_CenterCancelButton = 9 { $9 };
    QStyleSH_ProgressDialog_TextLabelAlignment = 10 { $a };
    QStyleSH_PrintDialog_RightAlignButtons = 11 { $b };
    QStyleSH_MainWindow_SpaceBelowMenuBar = 12 { $c };
    QStyleSH_FontDialog_SelectAssociatedText = 13 { $d };
    QStyleSH_Menu_AllowActiveAndDisabled = 14 { $e };
    QStyleSH_Menu_SpaceActivatesItem = 15 { $f };
    QStyleSH_Menu_SubMenuPopupDelay = 16 { $10 };
    QStyleSH_ScrollView_FrameOnlyAroundContents = 17 { $11 };
    QStyleSH_MenuBar_AltKeyNavigation = 18 { $12 };
    QStyleSH_ComboBox_ListMouseTracking = 19 { $13 };
    QStyleSH_Menu_MouseTracking = 20 { $14 };
    QStyleSH_MenuBar_MouseTracking = 21 { $15 };
    QStyleSH_ItemView_ChangeHighlightOnFocus = 22 { $16 };
    QStyleSH_Widget_ShareActivation = 23 { $17 };
    QStyleSH_Workspace_FillSpaceOnMaximize = 24 { $18 };
    QStyleSH_ComboBox_Popup = 25 { $19 };
    QStyleSH_TitleBar_NoBorder = 26 { $1a };
    QStyleSH_Slider_StopMouseOverSlider = 27 { $1b };
    QStyleSH_ScrollBar_StopMouseOverSlider = 27 { $1b };
    QStyleSH_BlinkCursorWhenTextSelected = 28 { $1c };
    QStyleSH_RichText_FullWidthSelection = 29 { $1d };
    QStyleSH_Menu_Scrollable = 30 { $1e };
    QStyleSH_GroupBox_TextLabelVerticalAlignment = 31 { $1f };
    QStyleSH_GroupBox_TextLabelColor = 32 { $20 };
    QStyleSH_Menu_SloppySubMenus = 33 { $21 };
    QStyleSH_Table_GridLineColor = 34 { $22 };
    QStyleSH_LineEdit_PasswordCharacter = 35 { $23 };
    QStyleSH_DialogButtons_DefaultButton = 36 { $24 };
    QStyleSH_ToolBox_SelectedPageTitleBold = 37 { $25 };
    QStyleSH_TabBar_PreferNoArrows = 38 { $26 };
    QStyleSH_ScrollBar_LeftClickAbsolutePosition = 39 { $27 };
    QStyleSH_Q3ListViewExpand_SelectMouseType = 40 { $28 };
    QStyleSH_UnderlineShortcut = 41 { $29 };
    QStyleSH_SpinBox_AnimateButton = 42 { $2a };
    QStyleSH_SpinBox_KeyPressAutoRepeatRate = 43 { $2b };
    QStyleSH_SpinBox_ClickAutoRepeatRate = 44 { $2c };
    QStyleSH_Menu_FillScreenWithScroll = 45 { $2d };
    QStyleSH_ToolTipLabel_Opacity = 46 { $2e };
    QStyleSH_DrawMenuBarSeparator = 47 { $2f };
    QStyleSH_TitleBar_ModifyNotification = 48 { $30 };
    QStyleSH_Button_FocusPolicy = 49 { $31 };
    QStyleSH_MenuBar_DismissOnSecondClick = 50 { $32 };
    QStyleSH_MessageBox_UseBorderForButtonSpacing = 51 { $33 };
    QStyleSH_TitleBar_AutoRaise = 52 { $34 };
    QStyleSH_ToolButton_PopupDelay = 53 { $35 };
    QStyleSH_FocusFrame_Mask = 54 { $36 };
    QStyleSH_RubberBand_Mask = 55 { $37 };
    QStyleSH_WindowFrame_Mask = 56 { $38 };
    QStyleSH_SpinControls_DisableOnBounds = 57 { $39 };
    QStyleSH_Dial_BackgroundRole = 58 { $3a };
    QStyleSH_ComboBox_LayoutDirection = 59 { $3b };
    QStyleSH_ItemView_EllipsisLocation = 60 { $3c };
    QStyleSH_ItemView_ShowDecorationSelected = 61 { $3d };
    QStyleSH_ItemView_ActivateItemOnSingleClick = 62 { $3e };
    QStyleSH_ScrollBar_ContextMenu = 63 { $3f };
    QStyleSH_ScrollBar_RollBetweenButtons = 64 { $40 };
    QStyleSH_Slider_AbsoluteSetButtons = 65 { $41 };
    QStyleSH_Slider_PageSetButtons = 66 { $42 };
    QStyleSH_Menu_KeyboardSearch = 67 { $43 };
    QStyleSH_TabBar_ElideMode = 68 { $44 };
    QStyleSH_DialogButtonLayout = 69 { $45 };
    QStyleSH_ComboBox_PopupFrameStyle = 70 { $46 };
    QStyleSH_MessageBox_TextInteractionFlags = 71 { $47 };
    QStyleSH_DialogButtonBox_ButtonsHaveIcons = 72 { $48 };
    QStyleSH_SpellCheckUnderlineStyle = 73 { $49 };
    QStyleSH_MessageBox_CenterButtons = 74 { $4a };
    QStyleSH_Menu_SelectionWrap = 75 { $4b };
    QStyleSH_ItemView_MovementWithoutUpdatingSelection = 76 { $4c };
    QStyleSH_ToolTip_Mask = 77 { $4d };
    QStyleSH_FocusFrame_AboveWidget = 78 { $4e };
    QStyleSH_TextControl_FocusIndicatorTextCharFormat = 79 { $4f };
    QStyleSH_WizardStyle = 80 { $50 };
    QStyleSH_ItemView_ArrowKeysNavigateIntoChildren = 81 { $51 };
    QStyleSH_Menu_Mask = 82 { $52 };
    QStyleSH_Menu_FlashTriggeredItem = 83 { $53 };
    QStyleSH_Menu_FadeOutOnHide = 84 { $54 };
    QStyleSH_SpinBox_ClickAutoRepeatThreshold = 85 { $55 };
    QStyleSH_ItemView_PaintAlternatingRowColorsForEmptyArea = 86 { $56 };
    QStyleSH_FormLayoutWrapPolicy = 87 { $57 };
    QStyleSH_TabWidget_DefaultTabPosition = 88 { $58 };
    QStyleSH_ToolBar_Movable = 89 { $59 };
    QStyleSH_FormLayoutFieldGrowthPolicy = 90 { $5a };
    QStyleSH_FormLayoutFormAlignment = 91 { $5b };
    QStyleSH_FormLayoutLabelAlignment = 92 { $5c };
    QStyleSH_ItemView_DrawDelegateFrame = 93 { $5d };
    QStyleSH_TabBar_CloseButtonPosition = 94 { $5e };
    QStyleSH_DockWidget_ButtonsHaveFrame = 95 { $5f };
    QStyleSH_CustomBase = 4026531840 { $f0000000 };


procedure QStyle_polish(handle: QStyleH; p1: QWidgetH); cdecl; external Qt4PasLib name 'QStyle_polish';
procedure QStyle_unpolish(handle: QStyleH; p1: QWidgetH); cdecl; external Qt4PasLib name 'QStyle_unpolish';
procedure QStyle_polish(handle: QStyleH; p1: QApplicationH); cdecl; external Qt4PasLib name 'QStyle_polish2';
procedure QStyle_unpolish(handle: QStyleH; p1: QApplicationH); cdecl; external Qt4PasLib name 'QStyle_unpolish2';
procedure QStyle_polish(handle: QStyleH; p1: QPaletteH); cdecl; external Qt4PasLib name 'QStyle_polish3';
procedure QStyle_itemTextRect(handle: QStyleH; retval: PRect; fm: QFontMetricsH; r: PRect; flags: Integer; enabled: Boolean; text: PWideString); cdecl; external Qt4PasLib name 'QStyle_itemTextRect';
procedure QStyle_itemPixmapRect(handle: QStyleH; retval: PRect; r: PRect; flags: Integer; pixmap: QPixmapH); cdecl; external Qt4PasLib name 'QStyle_itemPixmapRect';
procedure QStyle_drawItemText(handle: QStyleH; painter: QPainterH; rect: PRect; flags: Integer; pal: QPaletteH; enabled: Boolean; text: PWideString; textRole: QPaletteColorRole = QPaletteNoRole); cdecl; external Qt4PasLib name 'QStyle_drawItemText';
procedure QStyle_drawItemPixmap(handle: QStyleH; painter: QPainterH; rect: PRect; alignment: Integer; pixmap: QPixmapH); cdecl; external Qt4PasLib name 'QStyle_drawItemPixmap';
procedure QStyle_standardPalette(handle: QStyleH; retval: QPaletteH); cdecl; external Qt4PasLib name 'QStyle_standardPalette';
procedure QStyle_drawPrimitive(handle: QStyleH; pe: QStylePrimitiveElement; opt: QStyleOptionH; p: QPainterH; w: QWidgetH = nil); cdecl; external Qt4PasLib name 'QStyle_drawPrimitive';
procedure QStyle_drawControl(handle: QStyleH; element: QStyleControlElement; opt: QStyleOptionH; p: QPainterH; w: QWidgetH = nil); cdecl; external Qt4PasLib name 'QStyle_drawControl';
procedure QStyle_subElementRect(handle: QStyleH; retval: PRect; subElement: QStyleSubElement; option: QStyleOptionH; widget: QWidgetH = nil); cdecl; external Qt4PasLib name 'QStyle_subElementRect';
procedure QStyle_drawComplexControl(handle: QStyleH; cc: QStyleComplexControl; opt: QStyleOptionComplexH; p: QPainterH; widget: QWidgetH = nil); cdecl; external Qt4PasLib name 'QStyle_drawComplexControl';
function QStyle_hitTestComplexControl(handle: QStyleH; cc: QStyleComplexControl; opt: QStyleOptionComplexH; pt: PQtPoint; widget: QWidgetH = nil): QStyleSubControl; cdecl; external Qt4PasLib name 'QStyle_hitTestComplexControl';
procedure QStyle_subControlRect(handle: QStyleH; retval: PRect; cc: QStyleComplexControl; opt: QStyleOptionComplexH; sc: QStyleSubControl; widget: QWidgetH = nil); cdecl; external Qt4PasLib name 'QStyle_subControlRect';
function QStyle_pixelMetric(handle: QStyleH; metric: QStylePixelMetric; option: QStyleOptionH = nil; widget: QWidgetH = nil): Integer; cdecl; external Qt4PasLib name 'QStyle_pixelMetric';
procedure QStyle_sizeFromContents(handle: QStyleH; retval: PSize; ct: QStyleContentsType; opt: QStyleOptionH; contentsSize: PSize; w: QWidgetH = nil); cdecl; external Qt4PasLib name 'QStyle_sizeFromContents';
function QStyle_styleHint(handle: QStyleH; stylehint: QStyleStyleHint; opt: QStyleOptionH = nil; widget: QWidgetH = nil; returnData: QStyleHintReturnH = nil): Integer; cdecl; external Qt4PasLib name 'QStyle_styleHint';
procedure QStyle_standardPixmap(handle: QStyleH; retval: QPixmapH; standardPixmap: QStyleStandardPixmap; opt: QStyleOptionH = nil; widget: QWidgetH = nil); cdecl; external Qt4PasLib name 'QStyle_standardPixmap';
procedure QStyle_standardIcon(handle: QStyleH; retval: QIconH; standardIcon: QStyleStandardPixmap; option: QStyleOptionH = nil; widget: QWidgetH = nil); cdecl; external Qt4PasLib name 'QStyle_standardIcon';
procedure QStyle_generatedIconPixmap(handle: QStyleH; retval: QPixmapH; iconMode: QIconMode; pixmap: QPixmapH; opt: QStyleOptionH); cdecl; external Qt4PasLib name 'QStyle_generatedIconPixmap';
procedure QStyle_visualRect(retval: PRect; direction: QtLayoutDirection; boundingRect: PRect; logicalRect: PRect); cdecl; external Qt4PasLib name 'QStyle_visualRect';
procedure QStyle_visualPos(retval: PQtPoint; direction: QtLayoutDirection; boundingRect: PRect; logicalPos: PQtPoint); cdecl; external Qt4PasLib name 'QStyle_visualPos';
function QStyle_sliderPositionFromValue(min: Integer; max: Integer; val: Integer; space: Integer; upsideDown: Boolean = False): Integer; cdecl; external Qt4PasLib name 'QStyle_sliderPositionFromValue';
function QStyle_sliderValueFromPosition(min: Integer; max: Integer; pos: Integer; space: Integer; upsideDown: Boolean = False): Integer; cdecl; external Qt4PasLib name 'QStyle_sliderValueFromPosition';
function QStyle_visualAlignment(direction: QtLayoutDirection; alignment: QtAlignment): QtAlignment; cdecl; external Qt4PasLib name 'QStyle_visualAlignment';
procedure QStyle_alignedRect(retval: PRect; direction: QtLayoutDirection; alignment: QtAlignment; size: PSize; rectangle: PRect); cdecl; external Qt4PasLib name 'QStyle_alignedRect';
function QStyle_layoutSpacing(handle: QStyleH; control1: QSizePolicyControlType; control2: QSizePolicyControlType; orientation: QtOrientation; option: QStyleOptionH = nil; widget: QWidgetH = nil): Integer; cdecl; external Qt4PasLib name 'QStyle_layoutSpacing';
function QStyle_combinedLayoutSpacing(handle: QStyleH; controls1: QSizePolicyControlTypes; controls2: QSizePolicyControlTypes; orientation: QtOrientation; option: QStyleOptionH = nil; widget: QWidgetH = nil): Integer; cdecl; external Qt4PasLib name 'QStyle_combinedLayoutSpacing';


type
  QStyleOptionOptionType = (  //QStyleOption::OptionType (2)
    QStyleOptionSO_Default,
    QStyleOptionSO_FocusRect,
    QStyleOptionSO_Button,
    QStyleOptionSO_Tab,
    QStyleOptionSO_MenuItem,
    QStyleOptionSO_Frame,
    QStyleOptionSO_ProgressBar,
    QStyleOptionSO_ToolBox,
    QStyleOptionSO_Header,
    QStyleOptionSO_Q3DockWindow,
    QStyleOptionSO_DockWidget,
    QStyleOptionSO_Q3ListViewItem,
    QStyleOptionSO_ViewItem,
    QStyleOptionSO_TabWidgetFrame,
    QStyleOptionSO_TabBarBase,
    QStyleOptionSO_RubberBand,
    QStyleOptionSO_ToolBar,
    QStyleOptionSO_GraphicsItem,
    QStyleOptionSO_CustomBase = $f00,
    QStyleOptionSO_Complex = $f0000,
    QStyleOptionSO_Slider,
    QStyleOptionSO_SpinBox,
    QStyleOptionSO_ToolButton,
    QStyleOptionSO_ComboBox,
    QStyleOptionSO_Q3ListView,
    QStyleOptionSO_TitleBar,
    QStyleOptionSO_GroupBox,
    QStyleOptionSO_SizeGrip,
    QStyleOptionSO_ComplexCustomBase = $f000000 );

  QStyleOptionStyleOptionVersion = (  //QStyleOption::StyleOptionVersion (2)
    QStyleOptionVersion = 1 );


type
  QStyleOptionFocusRectStyleOptionVersion = (  //QStyleOptionFocusRect::StyleOptionVersion (2)
    QStyleOptionFocusRectVersion = 1 );


type
  QStyleOptionFrameStyleOptionVersion = (  //QStyleOptionFrame::StyleOptionVersion (2)
    QStyleOptionFrameVersion = 1 );


type
  QStyleOptionFrameV2StyleOptionVersion = (  //QStyleOptionFrameV2::StyleOptionVersion (2)
    QStyleOptionFrameV2Version = 2 );

type
  QStyleOptionFrameV2FrameFeature = cardinal; // QStyleOptionFrameV2::FrameFeature
  QStyleOptionFrameV2FrameFeatures = QStyleOptionFrameV2FrameFeature; //QFlags<> (3)
const
  QStyleOptionFrameV2None =   $00;
  QStyleOptionFrameV2Flat =   $01;


type
  QStyleOptionFrameV3StyleOptionVersion = (  //QStyleOptionFrameV3::StyleOptionVersion (2)
    QStyleOptionFrameV3Version = 3 );


type
  QStyleOptionTabWidgetFrameStyleOptionVersion = (  //QStyleOptionTabWidgetFrame::StyleOptionVersion (2)
    QStyleOptionTabWidgetFrameVersion = 1 );


type
  QStyleOptionTabBarBaseStyleOptionVersion = (  //QStyleOptionTabBarBase::StyleOptionVersion (2)
    QStyleOptionTabBarBaseVersion = 1 );


type
  QStyleOptionTabBarBaseV2StyleOptionVersion = (  //QStyleOptionTabBarBaseV2::StyleOptionVersion (2)
    QStyleOptionTabBarBaseV2Version = 2 );


type
  QStyleOptionHeaderSectionPosition = ( // QStyleOptionHeader::SectionPosition (1)
    QStyleOptionHeaderBeginning, QStyleOptionHeaderMiddle, QStyleOptionHeaderEnd, QStyleOptionHeaderOnlyOneSection );

  QStyleOptionHeaderSelectedPosition = ( // QStyleOptionHeader::SelectedPosition (1)
    QStyleOptionHeaderNotAdjacent, QStyleOptionHeaderNextIsSelected, QStyleOptionHeaderPreviousIsSelected, QStyleOptionHeaderNextAndPreviousAreSelected );

  QStyleOptionHeaderSortIndicator = ( // QStyleOptionHeader::SortIndicator (1)
    QStyleOptionHeaderNone, QStyleOptionHeaderSortUp, QStyleOptionHeaderSortDown );

  QStyleOptionHeaderStyleOptionVersion = (  //QStyleOptionHeader::StyleOptionVersion (2)
    QStyleOptionHeaderVersion = 1 );


type
  QStyleOptionButtonStyleOptionVersion = (  //QStyleOptionButton::StyleOptionVersion (2)
    QStyleOptionButtonVersion = 1 );

type
  QStyleOptionButtonButtonFeature = cardinal; // QStyleOptionButton::ButtonFeature
  QStyleOptionButtonButtonFeatures = QStyleOptionButtonButtonFeature; //QFlags<> (3)
const
  QStyleOptionButtonNone =   $00;
  QStyleOptionButtonFlat =   $01;
  QStyleOptionButtonHasMenu =   $02;
  QStyleOptionButtonDefaultButton =   $04;
  QStyleOptionButtonAutoDefaultButton =   $08;
  QStyleOptionButtonCommandLinkButton =   $10;


type
  QStyleOptionTabTabPosition = ( // QStyleOptionTab::TabPosition (1)
    QStyleOptionTabBeginning, QStyleOptionTabMiddle, QStyleOptionTabEnd, QStyleOptionTabOnlyOneTab );

  QStyleOptionTabSelectedPosition = ( // QStyleOptionTab::SelectedPosition (1)
    QStyleOptionTabNotAdjacent, QStyleOptionTabNextIsSelected, QStyleOptionTabPreviousIsSelected );

  QStyleOptionTabStyleOptionVersion = (  //QStyleOptionTab::StyleOptionVersion (2)
    QStyleOptionTabVersion = 1 );

type
  QStyleOptionTabCornerWidget = cardinal; // QStyleOptionTab::CornerWidget
  QStyleOptionTabCornerWidgets = QStyleOptionTabCornerWidget; //QFlags<> (3)
const
  QStyleOptionTabNoCornerWidgets =   $00;
  QStyleOptionTabLeftCornerWidget =   $01;
  QStyleOptionTabRightCornerWidget =   $02;


type
  QStyleOptionTabV2StyleOptionVersion = (  //QStyleOptionTabV2::StyleOptionVersion (2)
    QStyleOptionTabV2Version = 2 );


type
  QStyleOptionTabV3StyleOptionVersion = (  //QStyleOptionTabV3::StyleOptionVersion (2)
    QStyleOptionTabV3Version = 3 );


type
  QStyleOptionToolBarToolBarPosition = ( // QStyleOptionToolBar::ToolBarPosition (1)
    QStyleOptionToolBarBeginning, QStyleOptionToolBarMiddle, QStyleOptionToolBarEnd, QStyleOptionToolBarOnlyOne );

  QStyleOptionToolBarStyleOptionVersion = (  //QStyleOptionToolBar::StyleOptionVersion (2)
    QStyleOptionToolBarVersion = 1 );

type
  QStyleOptionToolBarToolBarFeature = cardinal; // QStyleOptionToolBar::ToolBarFeature
  QStyleOptionToolBarToolBarFeatures = QStyleOptionToolBarToolBarFeature; //QFlags<> (3)
const
  QStyleOptionToolBarNone =   $0;
  QStyleOptionToolBarMovable =   $1;


type
  QStyleOptionProgressBarStyleOptionVersion = (  //QStyleOptionProgressBar::StyleOptionVersion (2)
    QStyleOptionProgressBarVersion = 1 );


type
  QStyleOptionProgressBarV2StyleOptionVersion = (  //QStyleOptionProgressBarV2::StyleOptionVersion (2)
    QStyleOptionProgressBarV2Version = 2 );


type
  QStyleOptionMenuItemMenuItemType = ( // QStyleOptionMenuItem::MenuItemType (1)
    QStyleOptionMenuItemNormal, QStyleOptionMenuItemDefaultItem, QStyleOptionMenuItemSeparator, QStyleOptionMenuItemSubMenu, QStyleOptionMenuItemScroller, QStyleOptionMenuItemTearOff, QStyleOptionMenuItemMargin, 
    QStyleOptionMenuItemEmptyArea );

  QStyleOptionMenuItemCheckType = ( // QStyleOptionMenuItem::CheckType (1)
    QStyleOptionMenuItemNotCheckable, QStyleOptionMenuItemExclusive, QStyleOptionMenuItemNonExclusive );

  QStyleOptionMenuItemStyleOptionVersion = (  //QStyleOptionMenuItem::StyleOptionVersion (2)
    QStyleOptionMenuItemVersion = 1 );


type
  QStyleOptionQ3ListViewItemStyleOptionVersion = (  //QStyleOptionQ3ListViewItem::StyleOptionVersion (2)
    QStyleOptionQ3ListViewItemVersion = 1 );

type
  QStyleOptionQ3ListViewItemQ3ListViewItemFeature = cardinal; // QStyleOptionQ3ListViewItem::Q3ListViewItemFeature
  QStyleOptionQ3ListViewItemQ3ListViewItemFeatures = QStyleOptionQ3ListViewItemQ3ListViewItemFeature; //QFlags<> (3)
const
  QStyleOptionQ3ListViewItemNone =   $00;
  QStyleOptionQ3ListViewItemExpandable =   