/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_LISTITEMDIARY_HEADER
#define LIFEOGRAPH_LISTITEMDIARY_HEADER


#include "helpers.hpp"  // i18n headers
#include "entry.hpp"
#include "diary.hpp"
#include "views.hpp"
#include "widget_entrytags.hpp"
#include "widget_textview.hpp"


namespace LIFEO
{

class EntryView : public ElementView< Entry >
{
    public:
                                EntryView();

        void                    sync();

        void                    focus_tag();

        Glib::ustring           get_title_str() const
        {
            Glib::ustring title;

            if( ! m_ptr2elem->get_date().is_hidden() )
            {
                title = m_ptr2elem->get_date().format_string();
                title += "  ";
            }

            if( m_ptr2elem->get_date().is_ordinal() )
                title += m_ptr2elem->get_name();
            else
                title += m_ptr2elem->get_date().get_weekday_str();

            return title;
        }
        Glib::ustring           get_info_str() const
        { return Glib::ustring::compose( _( "Entry with %1 word(s)" ),
                                         m_textview->m_buffer->m_word_count ); }

        bool                    is_title_editable() const
        { return( ! m_ptr2elem->get_date().is_hidden() ); }
        Glib::ustring           get_title_edit_str() const
        { return( m_ptr2elem->get_date().format_string() ); }
        bool                    check_title_applicable( const Glib::ustring& ) const;
        bool                    apply_title( const Glib::ustring& );

        void                    show( Entry& );

        void                    handle_login();
        void                    handle_logout();

        void                    prepare_for_hiding( Entry& );

        void                    update_formatting_toolbar();
        void                    update_highlight_button();
        void                    update_status_date();
        void                    toggle_comments();
        void                    update_tag_widget()
        { m_W_tag_list->update(); }
        void                    update_theme();

        TextviewDiary*          get_textview() { return m_textview; }
        TextbufferDiary*        get_buffer() { return m_textview->m_buffer; }

    protected:
        void                    trash_entry();
        void                    restore_entry();
        void                    dismiss_entry();
        void                    print();
        void                    set_todo_status( ElemStatus );
        void                    toggle_favoredness();
        void                    hide();
        void                    hide_before();
        void                    hide_after();
        void                    handle_textview_changed();
        void                    handle_W_tag_updated( WidgetTagEdit::TagOperation, Tag* );
        void                    handle_button_tag_clicked();
        void                    handle_set_theme();
        void                    handle_treeviewtags_buttonpress( GdkEventButton* );
        void                    handle_drag_data_received(
                                        const Glib::RefPtr< Gdk::DragContext >&,
                                        int, int,
                                        const Gtk::SelectionData&,
                                        uint,
                                        guint );

        void                    focus_tag_entry();
        void                    handle_tag_entry_focus_out( GdkEventFocus* );
        void                    edit_tag_in_entry( const Tag* );
        void                    show_tag( const Tag* );
        void                    remove_selected_tags();

        // WIDGETS
        Gtk::RadioButton*       m_button_not_todo;
        Gtk::RadioButton*       m_button_todo;
        Gtk::RadioButton*       m_button_progressed;
        Gtk::RadioButton*       m_button_done;
        Gtk::RadioButton*       m_button_canceled;
        Gtk::Label*             m_label_created;
        Gtk::Label*             m_label_edited;
        Gtk::Label*             m_label_status;
        Gtk::Label*             m_label_status_changed;
        Gtk::ToggleButton*      m_button_toggle_favorite;
        Gtk::Button*            m_button_trash;
        Gtk::Button*            m_button_restore;
        Gtk::Button*            m_button_dismiss;

        Gtk::Button*            m_button_bold;
        Gtk::Button*            m_button_italic;
        Gtk::Button*            m_button_strikethrough;
        Gtk::Button*            m_button_highlight;
        Gtk::Label*             m_label_highlight;
        Gtk::EventBox*          m_eventbox_highlight;      // necessary to change bg color!!
        Gtk::Button*            m_MB_list_item;
        Gtk::MenuItem*          m_MI_list_none;
        Gtk::MenuItem*          m_MI_list_bullet;
        Gtk::MenuItem*          m_MI_list_todo;
        Gtk::MenuItem*          m_MI_list_progressed;
        Gtk::MenuItem*          m_MI_list_done;
        Gtk::MenuItem*          m_MI_list_canceled;
        Gtk::ToggleButton*      m_TB_comments;

        TextviewDiary*          m_textview;
        Gtk::Box*               m_Bx_tag_linked;
        Gtk::Box*               m_Bx_tag_edit;
        WidgetTagEdit*          m_W_tag_edit;
        Gtk::Button*            m_button_tag_operation;
        Gtk::Button*            m_button_set_theme;
        WidgetEntryTags*        m_W_tag_list;
        Gtk::Box*               m_Bx_editing_toolbar;

        // ACTIONS
        Glib::RefPtr< Gtk::Action > m_action_bold;
        Glib::RefPtr< Gtk::Action > m_action_italic;
        Glib::RefPtr< Gtk::Action > m_action_strikethrough;
        Glib::RefPtr< Gtk::Action > m_action_highlight;
        Glib::RefPtr< Gtk::Action > m_action_focus_tag;
        Glib::RefPtr< Gtk::ToggleAction > m_action_toggle_comments;
        Glib::RefPtr< Gtk::Action > m_action_indent;
        Glib::RefPtr< Gtk::Action > m_action_unindent;
        Glib::RefPtr< Gtk::Action > m_action_add_empty_line_above;
        Glib::RefPtr< Gtk::Action > m_action_remove_empty_line_above;
        Glib::RefPtr< Gtk::Action > m_action_move_line_up;
        Glib::RefPtr< Gtk::Action > m_action_move_line_down;
        Glib::RefPtr< Gtk::Action > m_action_delete_paragraph;
        Glib::RefPtr< Gtk::Action > m_action_time_stamp;

        Entry*                  m_entry_sync{ nullptr };
        bool                    m_flag_entrychanged{ false };

    friend class Lifeograph;
};

} // end of namespace LIFEO

#endif
