; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=sparc | FileCheck %s -check-prefix=SPARC

define i32 @test_andn(i32 %x) nounwind {
; SPARC-LABEL: test_andn:
; SPARC:       ! %bb.0: ! %entry
; SPARC-NEXT:    sethi 4194272, %o1
; SPARC-NEXT:    retl
; SPARC-NEXT:    andn %o0, %o1, %o0
entry:
  %and = and i32 %x, 32767
  ret i32 %and
}

define i32 @test_orn(i32 %x) nounwind {
; SPARC-LABEL: test_orn:
; SPARC:       ! %bb.0: ! %entry
; SPARC-NEXT:    sethi 4194272, %o1
; SPARC-NEXT:    retl
; SPARC-NEXT:    orn %o0, %o1, %o0
entry:
  %or = or i32 %x, 32767
  ret i32 %or
}

; If constant is used more than once it is probably
; better to keep it in its original form.
define i32 @test_used_more_than_once(i32 %x) nounwind {
; SPARC-LABEL: test_used_more_than_once:
; SPARC:       ! %bb.0: ! %entry
; SPARC-NEXT:    sethi 31, %o1
; SPARC-NEXT:    or %o1, 1023, %o1
; SPARC-NEXT:    or %o0, %o1, %o2
; SPARC-NEXT:    and %o0, %o1, %o0
; SPARC-NEXT:    retl
; SPARC-NEXT:    xor %o2, %o0, %o0
entry:
  %0 = or i32 %x, 32767
  %and = and i32 %x, 32767
  %res = xor i32 %0, %and
  ret i32 %res
}
