<?php
/*
 * LTSP-Cluster Control Center
 * Copyright (2009) Stéphane Graber <stgraber@ubuntu.com>, Revolution Linux Inc.

 * Author: Stéphane Graber <stgraber@ubuntu.com>

 * 2009, Stéphane Graber <stgraber@ubuntu.com>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of·
 * the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, you can find it on the World Wide
 * Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

    class AccountManager {
        static private $_instance = null;
        private $_td = null; # mcrypt

        # Make sure we don't end up with two instances of the same class
        static public function getInstance() {
            if (self::$_instance == null)
                self::$_instance = new AccountManager();
            return self::$_instance;
        }

        # Initialize mcrypt
        public function __construct() {
            global $config;
            $this->_td = mcrypt_module_open('blowfish', '', 'ecb', '');
            $iv = mcrypt_create_iv (mcrypt_enc_get_iv_size($this->_td), MCRYPT_RAND);
            mcrypt_generic_init($this->_td, $config['accountmanager']['key'], $iv);
        }

        # Stop mcrypt
        public function __destruct() {
            mcrypt_generic_deinit($this->_td);
            mcrypt_module_close($this->_td);
        }

        private function sendRequest($server,$request) {
            $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
            socket_connect($socket, $server, 8001);

            $encrypted_data = mcrypt_generic($this->_td, "$request");

            socket_write($socket,"admin $encrypted_data");
            $response="";
            while ($out = socket_read($socket, 2048)) {
                $response.=$out;
            }
            socket_close($socket);
            return $response;
        }

        public function killUser($server,$username) {
            return $this->sendRequest($server,"kill $username");
        }

        public function listProcess($server,$username) {
            return $this->sendRequest($server,"plist $username");
        }
    }
?>
