#!/usr/bin/perl
# gen.t
# If you run this program with a first argument of 'generate'
# it will generate the z... programs for each in @pnames.
# These are then put into the distribution.

use strict;
use File::Basename ();
use Acme::EyeDrops qw(sightly);

select(STDERR);$|=1;select(STDOUT);$|=1;  # autoflush

# --------------------------------------------------

sub build_file {
   my ($f, $d) = @_;
   local *F; open(F, '>'.$f) or die "open '$f': $!";
   print F $d or die "write '$f': $!"; close(F);
}

sub get_first_line {
   my $f = shift; local *T; open(T, $f) or die "open '$f': $!";
   my $s = <T>; close(T); $s;
}

# --------------------------------------------------

my $generate = @ARGV && $ARGV[0] eq 'generate';

my %attrs = (
   Shape          => 'camel',
   Regex          => 0,
   Compact        => 1,
   TrapEvalDie    => 1,
   InformHandler  => sub {},
   Shape          => 'camel',
   Gap            => 1
);
my @pnames = ( 'gen.t' );

print "1..", scalar(@pnames), "\n";

my $itest = 0;
my $base = File::Basename::dirname($0);
for my $p (@pnames) {
   $attrs{SourceFile} = "$base/$p";
   # Assume first line is #!/usr/bin/perl (needed for taint mode tests).
   my $s_new = get_first_line($attrs{SourceFile}) .
               "# This program was generated by gen.t\n";
   $s_new .= sightly(\%attrs);
   if ($generate) {
      build_file("$base/z$p", $s_new);
      next;
   }
   my $s_old = Acme::EyeDrops::_slurp_tfile("$base/z$p");
   $s_old eq $s_new or print "not ";
   ++$itest; print "ok $itest - $p\n";
}
