/***************************************************************************
                          chublistmanager.h  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHUBLISTMANAGER_H
#define CHUBLISTMANAGER_H

/**
  *@author Mathias Küster
  *
  * This handles downloading and parsing hublist data,
  * the data is then sent to CConfig for storage.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cthread.h>
#include <dclib/core/csingleton.h>
#include <dclib/core/clist.h>

class CHubListManager;
class CHttp;
class DCConfigHubListUrl;
class CByteArray;
class DCConfigHubItem;
class CXml;
class CDCMessage;
class _CCallback0;

class CXmlColumn {
public:
	/** */
	CXmlColumn() {};
	/** */
	~CXmlColumn() {};
	/** Column name */
	CString m_sName;
	/** Column type */
	CString m_sType;
	/** Column value */
	CString m_sValue;
};

class CHubListManager : public CSingleton<CHubListManager> {
public:
	/** */
	CHubListManager();
	/** */
	virtual ~CHubListManager();

	/** callback function */
	virtual int DC_CallBack( CDCMessage * ) { return -1; };

protected:
	/** */
	bool GetPublicHubList();
	/** */
	bool NextHubListUrl();

	/** */
	CThread m_Thread;

	/** */
	CHttp * m_pHttp;
	/** */
	CList<DCConfigHubListUrl> * m_pHubListUrlList;
	/** */
	DCConfigHubListUrl * m_pHubListUrl;
	/** data from old .config format hub lists */
	CByteArray * m_pHubListData;
	/** data from xml hublists */
	CList<DCConfigHubItem> * m_pXmlHubs;
	

private:
	/** http callback function */
	int HttpCallBack( CDCMessage * msg );
	/** called by CManager */
	int Callback();
	/** */
	int ParsePublicHubList();
	/** Parses XML hublist, adding items to m_pXmlHubs */
	int ParseXmlPublicHubList();
	/** Returns number of hubs parsed */
	int ParseXmlHubs( CList<CXmlColumn> * cols );
	/** Searches for and gets column headings */
	CList<CXmlColumn> * FindAndParseXmlColumns();
	/** Gets column values for one hub */
	void ParseXmlHub( CList<CXmlColumn> * cols );
	/** Handle the hublist data, decompressing and parsing the xml if necessary */
	void HandleHubListData( const CString & url, CByteArray * data );

	/** */
	time_t m_nReloadHubListTimeout;
	/** */
	bool m_bGetHubListDone;
	/** CXml object for parsing XML hublists */
	CXml * m_pXml;

	/** */
	_CCallback0 * m_pCallback;
};

#endif
