import unittest
from support import GNATCOLL_TestCase, chdir, pathsep


class Test(GNATCOLL_TestCase):
    @chdir("json1")
    def test_json1(self):
        self.gprbuild()
        self.runexec("decode", "test.out")

    @chdir("M605-001")
    def test_M605_001(self):
        self.gprbuild()
        self.runexec("read", "test.expected")

    @chdir("M626_041")
    def test_M626_041(self):
        self.gprbuild()
        self.runexec("obj/json_test", "test.out")

    @chdir("MB28-001")
    def test_MB28_001(self):
        self.runexec(["python", "make_json.py"])
        self.gprbuild()
        self.runexec("json_stack_test", "test.out")

    @chdir("utf8")
    def test_utf8(self):
        self.gprbuild()
        self.runexec("obj/json_utf8", "")
