/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QtTest/QtTest>

#include "tst_action.h"
#include "tst_context.h"
#include "tst_hud.h"
#include "tst_parameter.h"
#include "tst_slider-parameter.h"

int main(int argc, char *argv[])
{
    bool fail = false;

    TestAction tst_action;
    TestContext tst_context;
    TestHUD tst_hud;
    TestParameter tst_parameter;
    TestSliderParameter tst_sliderparameter;

    if (QTest::qExec(&tst_action, argc, argv) != 0)
        fail = true;
    if (QTest::qExec(&tst_context, argc, argv) != 0)
        fail = true;
    if (QTest::qExec(&tst_hud, argc, argv) != 0)
        fail = true;
    if (QTest::qExec(&tst_parameter, argc, argv) != 0)
        fail = true;
    if (QTest::qExec(&tst_sliderparameter, argc, argv) != 0)
        fail = true;

    if (fail)
        return 1;

    return 0;
}
