<?php
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
enum ExampleEnum {
    const a = 1;

    case Case1 = 100;
    case Case2 = 'C';
}

ExampleEnum::introduceStaticMethod();

enum BackedEnumInt: int {
    const a = 1;

    case Case1 = 1;
    case Case2 = 2;

    public function publicMethod(): void {
        $this->introduceMethod();
        self::introduceStaticMethod();
        static::introduceStaticMethod();
    }
}

BackedEnumInt::Case1->introduceMethod();

enum BackedEnumString: string {
    const a = 1;

    case Case1 = 'A';
    case Case2 = 'B';
}

BackedEnumString::Case2::introduceStaticMethod();
