package PDF::Builder::Resource::Font::CoreFont::helveticaboldoblique;

use strict;
use warnings;

our $VERSION = '3.027'; # VERSION
our $LAST_UPDATE = '3.027'; # manually update whenever code is changed

=head1 NAME

PDF::Builder::Resource::Font::CoreFont::helveticaboldoblique - Font-specific information for bold weight + slanted Helvetica font

Metrics and glyph list are from the Arial typeface

=cut

sub data { return {
    'fontname' => 'Helvetica-BoldOblique',
    'type' => 'Type1',
    'apiname' => 'HeBi',
    'ascender' => '718',
    'capheight' => '718',
    'descender' => '-207',
    'iscore' => '1',
    'isfixedpitch' => '0',
    'italicangle' => '-12',
    'stdhw' => '118',
    'stdvw' => '140',
    'underlineposition' => '-100',
    'underlinethickness' => '50',
    'xheight' => '532',
    'firstchar' => '32',
    'lastchar' => '255',
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
    'fontbbox' => [ -174, -228, 1114, 962 ],
# source: \Windows\Fonts\arialbi.ttf
# font underline position = -217
# CIDs 0 .. 3278 to be output
# fontbbox = (-559 -376 1390 1017)
    'wx' => { # HORIZ. WIDTH TABLE
        'A'       => 722,
        'AE'       => 1000,
        'AEacute'       => 1000,
        'AEmacron'       => 1000,
        'Aacute'       => 722,
        'Abreve'       => 722,
        'Abreveacute'       => 722,
        'Abrevecyrillic'       => 722,
        'Abrevedotbelow'       => 722,
        'Abrevegrave'       => 722,
        'Abrevehookabove'       => 722,
        'Abrevetilde'       => 722,
        'Acaron'       => 722,
        'Acircumflex'       => 722,
        'Acircumflexacute'       => 722,
        'Acircumflexdotbelow'       => 722,
        'Acircumflexgrave'       => 722,
        'Acircumflexhookabove'       => 722,
        'Acircumflextilde'       => 722,
        'Adblgrave'       => 722,
        'Adieresis'       => 722,
        'Adieresiscyrillic'       => 722,
        'Adieresismacron'       => 722,
        'Adotbelow'       => 722,
        'Adotmacron'       => 722,
        'Agrave'       => 722,
        'Ahookabove'       => 722,
        'Aiecyrillic'       => 1000,
        'Ainvertedbreve'       => 722,
        'Alpha'       => 722,
        'Alphatonos'       => 722,
        'Amacron'       => 722,
        'Aogonek'       => 722,
        'Aring'       => 722,
        'Aringacute'       => 722,
        'Aringbelow'       => 722,
        'Atilde'       => 722,
        'Aybarmenian'       => 742,
        'B'       => 722,
        'Bdotaccent'       => 722,
        'Bdotbelow'       => 722,
        'Benarmenian'       => 718,
        'Beta'       => 722,
        'Bhook'       => 795,
        'Blinebelow'       => 722,
        'Btopbar'       => 708,
        'C'       => 722,
        'Caarmenian'       => 777,
        'Cacute'       => 722,
        'Ccaron'       => 722,
        'Ccedilla'       => 722,
        'Ccedillaacute'       => 722,
        'Ccircumflex'       => 722,
        'Cdotaccent'       => 722,
        'Chaarmenian'       => 700,
        'Cheabkhasiancyrillic'       => 859,
        'Chedescenderabkhasiancyrillic'       => 859,
        'Chedescendercyrillic'       => 708,
        'Chedieresiscyrillic'       => 708,
        'Cheharmenian'       => 747,
        'Chekhakassiancyrillic'       => 708,
        'Cheverticalstrokecyrillic'       => 708,
        'Chi'       => 666,
        'Chook'       => 722,
        'Coarmenian'       => 746,
        'D'       => 722,
        'DZ'       => 1333,
        'DZcaron'       => 1333,
        'Daarmenian'       => 737,
        'Dafrican'       => 722,
        'Dcaron'       => 722,
        'Dcedilla'       => 722,
        'Dcircumflexbelow'       => 722,
        'Dcroat'       => 722,
        'Ddotaccent'       => 722,
        'Ddotbelow'       => 722,
        'Deicoptic'       => 506,
        'Delta'       => 671,                         # afm is 612, too narrow
        'Dhook'       => 792,
        'Digammagreek'       => 610,
        'Dlinebelow'       => 722,
        'Dtopbar'       => 666,
        'Dz'       => 1222,
        'Dzcaron'       => 1222,
        'Dzeabkhasiancyrillic'       => 610,
        'E'       => 667,                                         # +1
        'Eacute'       => 667,                                    # +1
        'Ebreve'       => 667,                                    # (+1)
        'Ecaron'       => 667,                                    # +1
        'Ecedillabreve'       => 667,                             # (+1)
        'Echarmenian'       => 717,
        'Ecircumflex'       => 667,                               # +1
        'Ecircumflexacute'       => 667,                          # (+1)
        'Ecircumflexbelow'       => 667,                          # (+1)
        'Ecircumflexdotbelow'       => 667,                       # (+1)
        'Ecircumflexgrave'       => 667,                          # (+1)
        'Ecircumflexhookabove'       => 667,                      # (+1)
        'Ecircumflextilde'       => 667,                          # (+1)
        'Edblgrave'       => 667,                                 # (+1)
        'Edieresis'       => 667,                                 # +1
        'Edotaccent'       => 667,                                # +1
        'Edotbelow'       => 667,                                 # (+1)
        'Egrave'       => 667,                                    # +1
        'Eharmenian'       => 660,
        'Ehookabove'       => 667,                                # (+1)
        'Einvertedbreve'       => 667,                            # (+1)
        'Eiotifiedcyrillic'       => 970,
        'Emacron'       => 667,                                   # +1
        'Emacronacute'       => 667,                              # (+1)
        'Emacrongrave'       => 667,                              # (+1)
        'Endescendercyrillic'       => 722,
        'Eng'       => 723,
        'Enghecyrillic'       => 872,
        'Enhookcyrillic'       => 722,
        'Eogonek'       => 667,                                   # +1
        'Eopen'       => 642,
        'Epsilon'       => 667,                                   # (+1)
        'Epsilontonos'       => 854,
        'Ereversed'       => 667,                                 # (+1)
        'Esdescendercyrillic'       => 722,
        'Esh'       => 590,
        'Eta'       => 722,
        'Etarmenian'       => 720,
        'Etatonos'       => 905,
        'Eth'       => 722,
        'Etilde'       => 667,                                    # (+1)
        'Etildebelow'       => 667,                               # (+1)
        'Euro'       => 556,
        'Ezh'       => 610,
        'Ezhcaron'       => 610,
        'Ezhreversed'       => 610,
        'F'       => 611,                                         # +1
        'Fdotaccent'       => 611,                                # (+1)
        'Feharmenian'       => 824,
        'Feicoptic'       => 670,
        'Fhook'       => 611,                                     # (+1)
        'G'       => 778,                                         # +1
        'Gacute'       => 778,                                    # (+1)
        'Gamma'       => 609,
        'Gammaafrican'       => 620,
        'Gangiacoptic'       => 642,
        'Gbreve'       => 778,                                    # +1
        'Gcaron'       => 778,                                    # (+1)
        'Gcircumflex'       => 778,                               # (+1)
        'Gcommaaccent'       => 778,                              # +1
        'Gdotaccent'       => 778,                                # (+1)
        'Ghadarmenian'       => 735,
        'Ghemiddlehookcyrillic'       => 666,
        'Ghestrokecyrillic'       => 613,
        'Ghook'       => 778,                                     # (+1)
        'Gimarmenian'       => 745,
        'Gmacron'       => 778,                                   # (+1)
        'Gsmallhook'       => 596,
        'Gstroke'       => 778,                                   # (+1)
        'H'       => 722,
        'H18533'       => 604,
        'H18543'       => 354,
        'H18551'       => 354,
        'H22073'       => 604,
        'Haabkhasiancyrillic'       => 725,
        'Hadescendercyrillic'       => 666,
        'Hbar'       => 722,
        'Hbrevebelow'       => 722,
        'Hcedilla'       => 722,
        'Hcircumflex'       => 722,
        'Hdieresis'       => 722,
        'Hdotaccent'       => 722,
        'Hdotbelow'       => 722,
        'Hoarmenian'       => 638,
        'Horicoptic'       => 666,
        'I'       => 278,                                         # +1
        'IJ'       => 782,
        'Iacute'       => 278,                                    # +1
        'Ibreve'       => 278,                                    # (+1)
        'Icaron'       => 278,                                    # (+1)
        'Icircumflex'       => 278,                               # +1
        'Idblgrave'       => 278,                                 # (+1)
        'Idieresis'       => 278,                                 # +1
        'Idieresisacute'       => 278,                            # (+1)
        'Idieresiscyrillic'       => 719,
        'Idotaccent'       => 278,                                # +1
        'Idotbelow'       => 278,                                 # (+1)
        'Iebrevecyrillic'       => 666,
        'Igrave'       => 278,                                    # +1
        'Ihookabove'       => 278,                                # (+1)
        'Iinvertedbreve'       => 278,                            # (+1)
        'Imacron'       => 278,                                   # +1
        'Imacroncyrillic'       => 719,
        'Iniarmenian'       => 681,
        'Iogonek'       => 278,                                   # +1
        'Iota'       => 278,                                      # (+1)
        'Iotaafrican'       => 277,
        'Iotadieresis'       => 278,                              # (+1)
        'Iotatonos'       => 473,
        'Istroke'       => 278,                                   # (+1)
        'Itilde'       => 278,                                    # (+1)
        'Itildebelow'       => 278,                               # (+1)
        'Izhitsadblgravecyrillic'       => 784,
        'J'       => 556,
        'Jaarmenian'       => 723,
        'Jcircumflex'       => 556,
        'Jheharmenian'       => 769,
        'K'       => 722,
        'Kabashkircyrillic'       => 765,
        'Kacute'       => 722,
        'Kadescendercyrillic'       => 614,
        'Kahookcyrillic'       => 659,
        'Kappa'       => 722,
        'Kastrokecyrillic'       => 614,
        'Kaverticalstrokecyrillic'       => 614,
        'Kcaron'       => 722,
        'Kcommaaccent'       => 722,
        'Kdotbelow'       => 722,
        'Keharmenian'       => 767,
        'Kenarmenian'       => 702,
        'Kheicoptic'       => 708,
        'Khook'       => 722,
        'Klinebelow'       => 722,
        'Koppacyrillic'       => 722,
        'Koppagreek'       => 751,
        'Ksicyrillic'       => 642,
        'L'       => 611,                                         # +1
        'LJ'       => 1166,
        'Lacute'       => 611,                                    # +1
        'Lambda'       => 666,
        'Lcaron'       => 611,                                    # +1
        'Lcircumflexbelow'       => 611,                          # (+1)
        'Lcommaaccent'       => 611,                              # +1
        'Ldot'       => 611,                                      # (+1)
        'Ldotbelow'       => 611,                                 # (+1)
        'Ldotbelowmacron'       => 611,                           # (+1)
        'Liwnarmenian'       => 582,
        'Lj'       => 888,
        'Llinebelow'       => 611,                                # (+1)
        'Lslash'       => 611,                                    # +1
        'M'       => 833,
        'Macute'       => 833,
        'Mdotaccent'       => 833,
        'Mdotbelow'       => 833,
        'Menarmenian'       => 766,
        'Mturned'       => 910,
        'Mu'       => 833,
        'N'       => 722,
        'NJ'       => 1278,
        'Nacute'       => 722,
        'Ncaron'       => 722,
        'Ncircumflexbelow'       => 722,
        'Ncommaaccent'       => 722,
        'Ndotaccent'       => 722,
        'Ndotbelow'       => 722,
        'Nhookleft'       => 722,
        'Nj'       => 1000,
        'Nlinebelow'       => 722,
        'Nowarmenian'       => 732,
        'Ntilde'       => 722,
        'Nu'       => 722,
        'O'       => 778,                                         # +1
        'OE'       => 1000,
        'Oacute'       => 778,                                    # +1
        'Obarredcyrillic'       => 777,
        'Obarreddieresiscyrillic'       => 777,
        'Obreve'       => 778,                                    # (+1)
        'Ocaron'       => 778,                                    # (+1)
        'Ocenteredtilde'       => 778,                            # (+1)
        'Ocircumflex'       => 778,                               # +1
        'Ocircumflexacute'       => 778,                          # (+1)
        'Ocircumflexdotbelow'       => 778,                       # (+1)
        'Ocircumflexgrave'       => 778,                          # (+1)
        'Ocircumflexhookabove'       => 778,                      # (+1)
        'Ocircumflextilde'       => 778,                          # (+1)
        'Odblgrave'       => 778,                                 # (+1)
        'Odieresis'       => 778,                                 # +1
        'Odieresiscyrillic'       => 777,
        'Odotbelow'       => 778,                                 # (+1)
        'Ograve'       => 778,                                    # +1
        'Oharmenian'       => 791,
        'Ohookabove'       => 778,                                # (+1)
        'Ohorn'       => 837,
        'Ohornacute'       => 837,
        'Ohorndotbelow'       => 837,
        'Ohorngrave'       => 837,
        'Ohornhookabove'       => 837,
        'Ohorntilde'       => 837,
        'Ohungarumlaut'       => 778,                             # +1
        'Oi'       => 903,
        'Oinvertedbreve'       => 778,                            # (+1)
        'Omacron'       => 778,                                   # +1
        'Omacronacute'       => 778,                              # (+1)
        'Omacrongrave'       => 778,                              # (+1)
        'Omega'       => 780,
        'Omegacyrillic'       => 1295,
        'Omegaroundcyrillic'       => 829,
        'Omegatitlocyrillic'       => 1295,
        'Omegatonos'       => 847,
        'Omicron'       => 778,                                   # (+1)
        'Omicrontonos'       => 844,
        'Oogonek'       => 778,                                   # (+1)
        'Oogonekmacron'       => 778,                             # (+1)
        'Oopen'       => 722,
        'Oslash'       => 778,                                    # +1
        'Oslashacute'       => 778,                               # (+1)
        'Otcyrillic'       => 1295,
        'Otilde'       => 778,                                    # +1
        'Otildeacute'       => 778,                               # (+1)
        'Otildedieresis'       => 778,                            # (+1)
        'P'       => 667,                                         # +1
        'Pacute'       => 667,                                    # (+1)
        'Pdotaccent'       => 667,                                # (+1)
        'Peharmenian'       => 849,
        'Pemiddlehookcyrillic'       => 1116,
        'Phi'       => 822,
        'Phook'       => 740,
        'Pi'       => 717,
        'Piwrarmenian'       => 864,
        'Psi'       => 828,
        'Psicyrillic'       => 828,
        'Q'       => 778,                                         # +1
        'R'       => 722,
        'Raarmenian'       => 773,
        'Racute'       => 722,
        'Rcaron'       => 722,
        'Rcommaaccent'       => 722,
        'Rdblgrave'       => 722,
        'Rdotaccent'       => 722,
        'Rdotbelow'       => 722,
        'Rdotbelowmacron'       => 722,
        'Reharmenian'       => 688,
        'Rho'       => 666,
        'Rinvertedbreve'       => 722,
        'Rlinebelow'       => 722,
        'Rsmallinverted'       => 588,
        'Rsmallinvertedsuperior'       => 399,
        'S'       => 667,                                         # +1
        'SF010000'       => 708,
        'SF020000'       => 708,
        'SF030000'       => 708,
        'SF040000'       => 708,
        'SF050000'       => 708,
        'SF060000'       => 708,
        'SF070000'       => 708,
        'SF080000'       => 708,
        'SF090000'       => 708,
        'SF100000'       => 708,
        'SF110000'       => 625,
        'SF190000'       => 708,
        'SF200000'       => 708,
        'SF210000'       => 708,
        'SF220000'       => 708,
        'SF230000'       => 708,
        'SF240000'       => 708,
        'SF250000'       => 708,
        'SF260000'       => 708,
        'SF270000'       => 708,
        'SF280000'       => 708,
        'SF360000'       => 708,
        'SF370000'       => 708,
        'SF380000'       => 708,
        'SF390000'       => 708,
        'SF400000'       => 708,
        'SF410000'       => 708,
        'SF420000'       => 708,
        'SF430000'       => 708,
        'SF440000'       => 708,
        'SF450000'       => 708,
        'SF460000'       => 708,
        'SF470000'       => 708,
        'SF480000'       => 708,
        'SF490000'       => 708,
        'SF500000'       => 708,
        'SF510000'       => 708,
        'SF520000'       => 708,
        'SF530000'       => 708,
        'SF540000'       => 708,
        'Sacute'       => 667,                                    # +1
        'Sacutedotaccent'       => 667,                           # (+1)
        'Sampigreek'       => 804,
        'Scaron'       => 667,                                    # +1
        'Scarondotaccent'       => 667,                           # (+1)
        'Scedilla'       => 667,                                  # +1
        'Schwacyrillic'       => 747,
        'Schwadieresiscyrillic'       => 747,
        'Scircumflex'       => 667,                               # (+1)
        'Scommaaccent'       => 667,                              # +1
        'Sdotaccent'       => 667,                                # (+1)
        'Sdotbelow'       => 667,                                 # (+1)
        'Sdotbelowdotaccent'       => 667,                        # (+1)
        'Seharmenian'       => 722,
        'Shaarmenian'       => 706,
        'Sheicoptic'       => 910,
        'Shhacyrillic'       => 708,
        'Shimacoptic'       => 734,
        'Sigma'       => 590,
        'Stigmagreek'       => 722,
        'T'       => 611,                                         # +1
        'Tau'       => 611,                                       # (+1)
        'Tbar'       => 611,                                      # (+1)
        'Tcaron'       => 611,                                    # +1
        'Tcedilla'       => 611,                                  # (+1)
        'Tcircumflexbelow'       => 611,                          # (+1)
        'Tcommaaccent'       => 611,                              # +1
        'Tdotaccent'       => 611,                                # (+1)
        'Tdotbelow'       => 611,                                 # (+1)
        'Tedescendercyrillic'       => 610,
        'Tetsecyrillic'       => 872,
        'Theta'       => 777,
        'Thook'       => 611,                                     # (+1)
        'Thorn'       => 667,                                     # +1
        'Tiwnarmenian'       => 679,
        'Tlinebelow'       => 611,                                # (+1)
        'Toarmenian'       => 919,
        'Tonefive'       => 556,
        'Tonesix'       => 708,
        'Tonetwo'       => 666,
        'Tretroflexhook'       => 611,                            # (+1)
        'U'       => 722,
        'Uacute'       => 722,
        'Ubreve'       => 722,
        'Ucaron'       => 722,
        'Ucircumflex'       => 722,
        'Ucircumflexbelow'       => 722,
        'Udblgrave'       => 722,
        'Udieresis'       => 722,
        'Udieresisacute'       => 722,
        'Udieresisbelow'       => 722,
        'Udieresiscaron'       => 722,
        'Udieresiscyrillic'       => 677,
        'Udieresisgrave'       => 722,
        'Udieresismacron'       => 722,
        'Udotbelow'       => 722,
        'Ugrave'       => 722,
        'Uhookabove'       => 722,
        'Uhorn'       => 808,
        'Uhornacute'       => 808,
        'Uhorndotbelow'       => 808,
        'Uhorngrave'       => 808,
        'Uhornhookabove'       => 808,
        'Uhorntilde'       => 808,
        'Uhungarumlaut'       => 722,
        'Uhungarumlautcyrillic'       => 677,
        'Uinvertedbreve'       => 722,
        'Ukcyrillic'       => 1136,
        'Umacron'       => 722,
        'Umacroncyrillic'       => 677,
        'Umacrondieresis'       => 722,
        'Uogonek'       => 722,
        'Upsilon'       => 666,
        'Upsilon1'       => 748,
        'Upsilonacutehooksymbolgreek'       => 992,
        'Upsilonafrican'       => 780,
        'Upsilondieresis'       => 666,
        'Upsilondieresishooksymbolgreek'       => 748,
        'Upsilontonos'       => 930,
        'Uring'       => 722,
        'Ustraightcyrillic'       => 556,
        'Ustraightstrokecyrillic'       => 556,
        'Utilde'       => 722,
        'Utildeacute'       => 722,
        'Utildebelow'       => 722,
        'V'       => 667,                                         # +1
        'Vdotbelow'       => 667,                                 # (+1)
        'Vewarmenian'       => 742,
        'Vhook'       => 722,
        'Voarmenian'       => 722,
        'Vtilde'       => 667,                                    # (+1)
        'W'       => 944,                                         # +1
        'Wacute'       => 944,                                    # (+1)
        'Wcircumflex'       => 944,                               # (+1)
        'Wdieresis'       => 944,                                 # (+1)
        'Wdotaccent'       => 944,                                # (+1)
        'Wdotbelow'       => 944,                                 # (+1)
        'Wgrave'       => 944,                                    # (+1)
        'X'       => 667,                                         # +1
        'Xdieresis'       => 667,                                 # (+1)
        'Xdotaccent'       => 667,                                # (+1)
        'Xeharmenian'       => 949,
        'Xi'       => 657,
        'Y'       => 667,                                         # +1
        'Yacute'       => 667,                                    # +1
        'Ycircumflex'       => 667,                               # (+1)
        'Ydieresis'       => 667,                                 # +1
        'Ydotaccent'       => 667,                                # (+1)
        'Ydotbelow'       => 667,                                 # (+1)
        'Yerudieresiscyrillic'       => 1000,
        'Ygrave'       => 667,                                    # (+1)
        'Yhook'       => 715,
        'Yhookabove'       => 667,                                # (+1)
        'Yiarmenian'       => 746,
        'Yiwnarmenian'       => 531,
        'Ytilde'       => 667,                                    # (+1)
        'Yusbigcyrillic'       => 809,
        'Yusbigiotifiedcyrillic'       => 1083,
        'Yuslittlecyrillic'       => 666,
        'Yuslittleiotifiedcyrillic'       => 925,
        'Z'       => 611,                                         # +1
        'Zaarmenian'       => 723,
        'Zacute'       => 611,                                    # +1
        'Zcaron'       => 611,                                    # +1
        'Zcircumflex'       => 611,                               # (+1)
        'Zdotaccent'       => 611,                                # +1
        'Zdotbelow'       => 611,                                 # (+1)
        'Zedescendercyrillic'       => 642,
        'Zedieresiscyrillic'       => 642,
        'Zeta'       => 610,
        'Zhearmenian'       => 740,
        'Zhebrevecyrillic'       => 927,
        'Zhedescendercyrillic'       => 927,
        'Zhedieresiscyrillic'       => 927,
        'Zlinebelow'       => 611,                                # (+1)
        'Zstroke'       => 611,                                   # (+1)
        'a'       => 556,
        'aacute'       => 556,
        'abbreviationmarkarmenian'       => 513,
        'abreve'       => 556,
        'abreveacute'       => 556,
        'abrevecyrillic'       => 556,
        'abrevedotbelow'       => 556,
        'abrevegrave'       => 556,
        'abrevehookabove'       => 556,
        'abrevetilde'       => 556,
        'acaron'       => 556,
        'acircumflex'       => 556,
        'acircumflexacute'       => 556,
        'acircumflexdotbelow'       => 556,
        'acircumflexgrave'       => 556,
        'acircumflexhookabove'       => 556,
        'acircumflextilde'       => 556,
        'acute'       => 333,
        'acutebelowcmb'       => 0,
        'acutecomb'       => 0,
        'acutelowmod'       => 333,
        'acutetonecmb'       => 0,
        'adblgrave'       => 556,
        'adieresis'       => 556,
        'adieresiscyrillic'       => 556,
        'adieresismacron'       => 556,
        'adotbelow'       => 556,
        'adotmacron'       => 556,
        'ae'       => 889,
        'aeacute'       => 889,
        'aemacron'       => 889,
        'afii00208'       => 1000,
        'afii10017'       => 722,
        'afii10018'       => 708,
        'afii10019'       => 722,
        'afii10020'       => 613,
        'afii10021'       => 722,
        'afii10022'       => 666,
        'afii10023'       => 666,
        'afii10024'       => 927,
        'afii10025'       => 642,
        'afii10026'       => 719,
        'afii10027'       => 719,
        'afii10028'       => 614,
        'afii10029'       => 687,
        'afii10030'       => 833,
        'afii10031'       => 722,
        'afii10032'       => 777,
        'afii10033'       => 719,
        'afii10034'       => 666,
        'afii10035'       => 722,
        'afii10036'       => 610,
        'afii10037'       => 677,
        'afii10038'       => 780,
        'afii10039'       => 666,
        'afii10040'       => 729,
        'afii10041'       => 708,
        'afii10042'       => 979,
        'afii10043'       => 988,
        'afii10044'       => 854,
        'afii10045'       => 1000,
        'afii10046'       => 708,
        'afii10047'       => 718,
        'afii10048'       => 1041,
        'afii10049'       => 729,
        'afii10050'       => 575,
        'afii10051'       => 885,
        'afii10052'       => 613,
        'afii10053'       => 718,
        'afii10054'       => 666,
        'afii10055'       => 277,
        'afii10056'       => 277,
        'afii10057'       => 556,
        'afii10058'       => 1094,
        'afii10059'       => 1041,
        'afii10060'       => 853,
        'afii10061'       => 614,
        'afii10062'       => 677,
        'afii10065'       => 556,
        'afii10066'       => 619,
        'afii10067'       => 604,
        'afii10068'       => 533,
        'afii10069'       => 618,
        'afii10070'       => 556,
        'afii10071'       => 556,
        'afii10072'       => 736,
        'afii10073'       => 510,
        'afii10074'       => 610,
        'afii10075'       => 610,
        'afii10076'       => 506,
        'afii10077'       => 622,
        'afii10078'       => 739,
        'afii10079'       => 604,
        'afii10080'       => 610,
        'afii10081'       => 610,
        'afii10082'       => 610,
        'afii10083'       => 556,
        'afii10084'       => 889,
        'afii10085'       => 556,
        'afii10086'       => 884,
        'afii10087'       => 556,
        'afii10088'       => 645,
        'afii10089'       => 583,
        'afii10090'       => 889,
        'afii10091'       => 935,
        'afii10092'       => 707,
        'afii10093'       => 854,
        'afii10094'       => 593,
        'afii10095'       => 551,
        'afii10096'       => 864,
        'afii10097'       => 588,
        'afii10098'       => 466,
        'afii10099'       => 610,
        'afii10100'       => 469,
        'afii10101'       => 562,
        'afii10102'       => 556,
        'afii10103'       => 277,
        'afii10104'       => 277,
        'afii10105'       => 277,
        'afii10106'       => 969,
        'afii10107'       => 905,
        'afii10108'       => 610,
        'afii10109'       => 506,
        'afii10110'       => 556,
        'afii10145'       => 719,
        'afii10146'       => 821,
        'afii10147'       => 777,
        'afii10148'       => 784,
        'afii10193'       => 610,
        'afii10194'       => 847,
        'afii10195'       => 610,
        'afii10196'       => 613,
        'afii10846'       => 556,
        'afii299'       => 0,
        'afii300'       => 0,
        'afii301'       => 0,
        'afii57636'       => 817,
        'afii57645'       => 446,
        'afii57658'       => 333,
        'afii57664'       => 582,
        'afii57665'       => 575,
        'afii57666'       => 456,
        'afii57667'       => 549,
        'afii57668'       => 614,
        'afii57669'       => 272,
        'afii57670'       => 413,
        'afii57671'       => 615,
        'afii57672'       => 626,
        'afii57673'       => 272,
        'afii57674'       => 521,
        'afii57675'       => 490,
        'afii57676'       => 496,
        'afii57677'       => 610,
        'afii57678'       => 629,
        'afii57679'       => 272,
        'afii57680'       => 385,
        'afii57681'       => 613,
        'afii57682'       => 543,
        'afii57683'       => 593,
        'afii57684'       => 586,
        'afii57685'       => 499,
        'afii57686'       => 511,
        'afii57687'       => 572,
        'afii57688'       => 521,
        'afii57689'       => 714,
        'afii57690'       => 673,
        'afii57694'       => 714,
        'afii57695'       => 714,
        'afii57700'       => 272,
        'afii57705'       => 545,
        'afii57716'       => 545,
        'afii57717'       => 545,
        'afii57718'       => 545,
        'afii57723'       => 322,
        'afii57793'       => 0,
        'afii57794'       => 0,
        'afii57795'       => 0,
        'afii57796'       => 0,
        'afii57797'       => 0,
        'afii57798'       => 0,
        'afii57799'       => 0,
        'afii57800'       => 0,
        'afii57801'       => 0,
        'afii57802'       => 0,
        'afii57803'       => 0,
        'afii57804'       => 0,
        'afii57806'       => 0,
        'afii57807'       => 0,
        'afii57839'       => 0,
        'afii57841'       => 0,
        'afii57842'       => 299,
        'afii57929'       => 277,
        'afii61248'       => 885,
        'afii61289'       => 516,
        'afii61352'       => 1145,
        'afii61573'       => 0,
        'afii61574'       => 0,
        'afii61575'       => 0,
        'afii61664'       => 0,
        'afii64937'       => 277,
        'agrave'       => 556,
        'ahookabove'       => 556,
        'aiecyrillic'       => 889,
        'ainvertedbreve'       => 556,
        'alefdageshhebrew'       => 582,
        'aleflamedhebrew'       => 606,
        'alefpatahhebrew'       => 582,
        'alefqamatshebrew'       => 582,
        'alpha'       => 620,
        'alphatonos'       => 620,
        'amacron'       => 556,
        'ampersand'       => 722,
        'anoteleia'       => 333,
        'aogonek'       => 556,
        'apostrophearmenian'       => 277,
        'approxequal'       => 548,
        'arighthalfring'       => 556,
        'aring'       => 556,
        'aringacute'       => 556,
        'aringbelow'       => 556,
        'arrowboth'       => 1000,
        'arrowdown'       => 500,
        'arrowheaddownmod'       => 583,
        'arrowheadleftmod'       => 583,
        'arrowheadrightmod'       => 583,
        'arrowheadupmod'       => 583,
        'arrowleft'       => 1000,
        'arrowright'       => 1000,
        'arrowup'       => 500,
        'arrowupdn'       => 500,
        'arrowupdnbse'       => 500,
        'asciicircum'       => 584,                               # +1
        'asciitilde'       => 584,                                # +1
        'ascript'       => 610,
        'ascriptturned'       => 610,
        'asterisk'       => 389,
        'at'       => 975,
        'atilde'       => 556,
        'aturned'       => 556,
        'aybarmenian'       => 893,
        'ayinaltonehebrew'       => 559,
        'b'       => 611,                                         # +1
        'backslash'       => 278,                                 # +1
        'bar'       => 280,                                       # +1
        'bdotaccent'       => 611,                                # (+1)
        'bdotbelow'       => 611,                                 # (+1)
        'benarmenian'       => 612,
        'beta'       => 620,
        'betasymbolgreek'       => 563,
        'betdagesh'       => 575,
        'betrafehebrew'       => 575,
        'bhook'       => 611,                                     # (+1)
        'bilabialclick'       => 777,
        'blinebelow'       => 611,                                # (+1)
        'block'       => 708,
        'braceleft'       => 389,
        'braceright'       => 389,
        'bracketleft'       => 333,
        'bracketright'       => 333,
        'breve'       => 333,
        'brevebelowcmb'       => 0,
        'brevecmb'       => 0,
        'breveinvertedbelowcmb'       => 0,
        'breveinvertedcmb'       => 0,
        'breveinverteddoublecmb'       => 0,
        'bridgebelowcmb'       => 0,
        'bridgeinvertedbelowcmb'       => 0,
        'brokenbar'       => 280,                                 # +1
        'bstroke'       => 611,                                   # (+1)
        'btopbar'       => 611,                                   # (+1)
        'bullet'       => 350,
        'c'       => 556,
        'caarmenian'       => 604,
        'cacute'       => 556,
        'candrabinducmb'       => 0,
        'caron'       => 333,
        'caronbelowcmb'       => 0,
        'caroncmb'       => 0,
        'ccaron'       => 556,
        'ccedilla'       => 556,
        'ccedillaacute'       => 556,
        'ccircumflex'       => 556,
        'ccurl'       => 556,
        'cdotaccent'       => 556,
        'cedilla'       => 333,
        'cedillacmb'       => 0,
        'cent'       => 556,
        'chaarmenian'       => 394,
        'cheabkhasiancyrillic'       => 648,
        'chedescenderabkhasiancyrillic'       => 648,
        'chedescendercyrillic'       => 583,
        'chedieresiscyrillic'       => 583,
        'cheharmenian'       => 607,
        'chekhakassiancyrillic'       => 583,
        'cheverticalstrokecyrillic'       => 583,
        'chi'       => 577,
        'chook'       => 556,
        'circle'       => 604,
        'circumflex'       => 333,
        'circumflexbelowcmb'       => 0,
        'circumflexcmb'       => 0,
        'clickalveolar'       => 584,
        'clickdental'       => 279,
        'clickretroflex'       => 333,
        'club'       => 656,
        'coarmenian'       => 613,
        'colon'       => 333,
        'colonmonetary'       => 722,
        'colontriangularhalfmod'       => 333,
        'colontriangularmod'       => 333,
        'comma'       => 278,                                     # +1
        'commaaccent'       => 250,
        'commaabovecmb'       => 0,
        'commaaboverightcmb'       => 0,
        'commaarmenian'       => 265,
        'commareversedabovecmb'       => 0,
        'commaturnedabovecmb'       => 0,
        'commaturnedmod'       => 277,
        'copyright'       => 737,                                 # +1
        'copysr'       => 736,
        'cruzeiro'       => 722,
        'cstretched'       => 556,
        'currency'       => 556,
        'd'       => 611,                                         # +1
        'daarmenian'       => 670,
        'dagger'       => 556,
        'daggerdbl'       => 556,
        'daletdagesh'       => 549,
        'dargahebrew'       => 0,
        'dasiapneumatacyrilliccmb'       => 0,
        'dblarchinvertedbelowcmb'       => 0,
        'dblgravecmb'       => 0,
        'dbllowlinecmb'       => 0,
        'dbloverlinecmb'       => 0,
        'dblprimemod'       => 474,
        'dblverticalbar'       => 497,
        'dblverticallineabovecmb'       => 0,
        'dcaron'       => 743,                        # use afm, was TTF 739
        'dcedilla'       => 611,                                  # (+1)
        'dcircumflexbelow'       => 611,                          # (+1)
        'dcroat'       => 611,                                    # +1
        'ddotaccent'       => 611,                                # (+1)
        'ddotbelow'       => 611,                                 # (+1)
        'degree'       => 400,                                    # +1
        'dehihebrew'       => 0,
        'deicoptic'       => 439,
        'delta'       => 610,
        'deltaturned'       => 610,
        'dezh'       => 937,
        'dhook'       => 610,
        'dialytikatonoscmb'       => 0,
        'diamond'       => 510,
        'dieresis'       => 333,
        'dieresisbelowcmb'       => 0,
        'dieresiscmb'       => 0,
        'dieresistonos'       => 333,
        'divide'       => 548,                        # afm 584 too wide
        'dkshade'       => 729,
        'dlinebelow'       => 610,
        'dnblock'       => 708,
        'dollar'       => 556,
        'dong'       => 513,
        'dotaccent'       => 333,
        'dotaccentcmb'       => 0,
        'dotbelowcomb'       => 0,
        'dotlessi'       => 278,                                  # +1
        'dotlessj'       => 277,
        'dotlessjstrokehook'       => 319,
        'dottedcircle'       => 594,
        'downtackbelowcmb'       => 0,
        'downtackmod'       => 333,
        'dtail'       => 611,                                     # (+1)
        'dtopbar'       => 611,                                   # (+1)
        'dz'       => 1110,
        'dzaltone'       => 1000,
        'dzcaron'       => 1110,
        'dzcurl'       => 1196,
        'dzeabkhasiancyrillic'       => 526,
        'e'       => 556,
        'eacute'       => 556,
        'ebreve'       => 556,
        'ecaron'       => 556,
        'ecedillabreve'       => 556,
        'echarmenian'       => 614,
        'echyiwnarmenian'       => 767,
        'ecircumflex'       => 556,
        'ecircumflexacute'       => 556,
        'ecircumflexbelow'       => 556,
        'ecircumflexdotbelow'       => 556,
        'ecircumflexgrave'       => 556,
        'ecircumflexhookabove'       => 556,
        'ecircumflextilde'       => 556,
        'edblgrave'       => 556,
        'edieresis'       => 556,
        'edotaccent'       => 556,
        'edotbelow'       => 556,
        'egrave'       => 556,
        'eharmenian'       => 574,
        'ehookabove'       => 556,
        'eight'       => 556,
        'eightsuperior'       => 333,
        'einvertedbreve'       => 556,
        'eiotifiedcyrillic'       => 799,
        'ellipsis'       => 1000,
        'emacron'       => 556,
        'emacronacute'       => 556,
        'emacrongrave'       => 556,
        'emdash'       => 1000,
        'emphasismarkarmenian'       => 183,
        'emsp'       => 1000,
        'emsp13'       => 333,
        'emsp14'       => 250,
        'endash'       => 556,
        'endescendercyrillic'       => 604,
        'eng'       => 610,
        'enghecyrillic'       => 694,
        'enhookcyrillic'       => 604,
        'enspace'       => 500,
        'eogonek'       => 556,
        'eopen'       => 478,
        'eopenclosed'       => 571,
        'eopenreversed'       => 510,
        'eopenreversedclosed'       => 571,
        'eopenreversedhook'       => 669,
        'epsilon'       => 478,
        'epsilontonos'       => 478,
        'equal'       => 584,                                     # +1
        'equivalence'       => 583,
        'ereversed'       => 556,
        'esdescendercyrillic'       => 556,
        'esh'       => 319,
        'eshcurl'       => 534,
        'eshreversedloop'       => 359,
        'eshsquatreversed'       => 333,
        'estimated'       => 600,
        'eta'       => 610,
        'etarmenian'       => 610,
        'etatonos'       => 610,
        'eth'       => 611,                                       # +1
        'etilde'       => 556,
        'etildebelow'       => 556,
        'etnahtafoukhhebrew'       => 0,
        'eturned'       => 556,
        'exclam'       => 333,
        'exclamarmenian'       => 234,
        'exclamdbl'       => 604,
        'exclamdown'       => 333,
        'ezh'       => 526,
        'ezhcaron'       => 526,
        'ezhcurl'       => 526,
        'ezhreversed'       => 526,
        'ezhtail'       => 526,
        'f'       => 333,
        'fdotaccent'       => 333,
        'feharmenian'       => 829,
        'feicoptic'       => 610,
        'female'       => 750,
        'ff'       => 647,
        'ffi'       => 920,
        'ffl'       => 921,
        'fi'       => 611,                                        # +1
        'figuredash'       => 556,
        'filledbox'       => 604,
        'filledrect'       => 1000,
        'finalkafdagesh'       => 521,
        'five'       => 556,
        'fiveeighths'       => 833,
        'fivesuperior'       => 333,
        'fl'       => 611,                                        # +1
        'florin'       => 556,
        'four'       => 556,
        'foursuperior'       => 333,
        'fourthtonechinese'       => 333,
        'fraction'       => 167,                                  # +1
        'franc'       => 556,
        'g'       => 611,                                         # +1
        'gacute'       => 611,                                    # (+1)
        'gamma'       => 556,
        'gammad'       => 469,
        'gammalatinsmall'       => 556,
        'gammasuperior'       => 405,
        'gangiacoptic'       => 603,
        'gbreve'       => 611,                                    # +1
        'gcaron'       => 611,                                    # (+1)
        'gcircumflex'       => 611,                               # (+1)
        'gcommaaccent'       => 611,                              # +1
        'gdotaccent'       => 611,                                # (+1)
        'gereshaccenthebrew'       => 0,
        'gereshhebrew'       => 276,
        'gereshmuqdamhebrew'       => 0,
        'germandbls'       => 611,                                # +1
        'gershayimaccenthebrew'       => 0,
        'gershayimhebrew'       => 504,
        'ghadarmenian'       => 614,
        'ghemiddlehookcyrillic'       => 577,
        'ghestrokecyrillic'       => 469,
        'ghook'       => 611,                                     # (+1)
        'gimarmenian'       => 674,
        'gimeldagesh'       => 454,
        'glottalinvertedstroke'       => 556,
        'glottalstop'       => 500,
        'glottalstopinverted'       => 500,
        'glottalstopmod'       => 378,
        'glottalstopreversed'       => 500,
        'glottalstopreversedmod'       => 378,
        'glottalstopreversedsuperior'       => 378,
        'glottalstopstroke'       => 500,
        'glottalstopstrokereversed'       => 500,
        'gmacron'       => 611,                                   # (+1)
        'grave'       => 333,
        'gravebelowcmb'       => 0,
        'gravecomb'       => 0,
        'gravelowmod'       => 333,
        'gravetonecmb'       => 0,
        'greater'       => 584,                                   # +1
        'greaterequal'       => 549,                              # +1
        'gscript'       => 611,                                   # (+1)
        'gstroke'       => 611,                                   # (+1)
        'guillemotleft'       => 556,
        'guillemotright'       => 556,
        'guilsinglleft'       => 333,
        'guilsinglright'       => 333,
        'h'       => 611,                                         # +1
        'haabkhasiancyrillic'       => 564,
        'hadescendercyrillic'       => 556,
        'hairsp'       => 83,
        'hbar'       => 611,                                      # (+1)
        'hbrevebelow'       => 611,                               # (+1)
        'hcedilla'       => 611,                                  # (+1)
        'hcircumflex'       => 611,                               # (+1)
        'hdieresis'       => 611,                                 # (+1)
        'hdotaccent'       => 611,                                # (+1)
        'hdotbelow'       => 611,                                 # (+1)
        'heart'       => 593,
        'hedagesh'       => 614,
        'henghook'       => 610,
        'hhook'       => 611,                                     # (+1)
        'hhooksuperior'       => 402,
        'hlinebelow'       => 611,                                # (+1)
        'hoarmenian'       => 610,
        'hookabovecomb'       => 0,
        'hookpalatalizedbelowcmb'       => 0,
        'hookretroflexbelowcmb'       => 0,
        'horicoptic'       => 666,
        'horncmb'       => 0,
        'house'       => 604,
        'hsuperior'       => 402,
        'hturned'       => 611,                                   # (+1)
        'hungarumlaut'       => 333,
        'hungarumlautcmb'       => 0,
        'hv'       => 933,
        'hyphen'       => 333,
        'i'       => 278,                                         # +1
        'iacute'       => 278,                                    # +1
        'ibreve'       => 278,                                    # (+1)
        'icaron'       => 278,                                    # (+1)
        'icircumflex'       => 278,                               # +1
        'idblgrave'       => 278,                                 # (+1)
        'idieresis'       => 278,                                 # +1
        'idieresisacute'       => 278,                            # (+1)
        'idieresiscyrillic'       => 610,
        'idotbelow'       => 278,                                 # (+1)
        'iebrevecyrillic'       => 556,
        'igrave'       => 278,                                    # +1
        'ihookabove'       => 278,                                # (+1)
        'iinvertedbreve'       => 278,                            # (+1)
        'ij'       => 556,
        'iluyhebrew'       => 0,
        'imacron'       => 278,                                   # +1
        'imacroncyrillic'       => 610,
        'infinity'       => 712,
        'iniarmenian'       => 610,
        'integral'       => 273,
        'integralbt'       => 604,
        'integraltp'       => 604,
        'intersection'       => 722,
        'invbullet'       => 604,
        'invcircle'       => 604,
        'invsmileface'       => 1052,
        'iogonek'       => 278,                                   # +1
        'iota'       => 277,
        'iotadieresis'       => 277,
        'iotadieresistonos'       => 277,
        'iotalatin'       => 277,
        'iotatonos'       => 277,
        'istroke'       => 278,                                   # (+1)
        'itilde'       => 278,                                    # (+1)
        'itildebelow'       => 278,                               # (+1)
        'izhitsadblgravecyrillic'       => 613,
        'j'       => 278,                                         # +1
        'jaarmenian'       => 582,
        'jcaron'       => 278,                                    # (+1)
        'jcircumflex'       => 278,                               # (+1)
        'jcrossedtail'       => 407,
        'jdotlessstroke'       => 333,
        'jheharmenian'       => 563,
        'jsuperior'       => 193,
        'k'       => 556,
        'kabashkircyrillic'       => 612,
        'kacute'       => 556,
        'kadescendercyrillic'       => 506,
        'kafdagesh'       => 490,
        'kafrafehebrew'       => 490,
        'kahookcyrillic'       => 582,
        'kappa'       => 565,
        'kappasymbolgreek'       => 676,
        'kastrokecyrillic'       => 506,
        'kaverticalstrokecyrillic'       => 506,
        'kcaron'       => 556,
        'kcommaaccent'       => 556,
        'kdotbelow'       => 556,
        'keharmenian'       => 613,
        'kenarmenian'       => 611,
        'kgreenlandic'       => 556,
        'kheicoptic'       => 604,
        'khook'       => 556,
        'klinebelow'       => 556,
        'koppacyrillic'       => 500,
        'koroniscmb'       => 0,
        'ksicyrillic'       => 510,
        'kturned'       => 556,
        'l'       => 278,                                         # +1
        'lacute'       => 278,                                    # +1
        'lambda'       => 556,
        'lambdastroke'       => 556,
        'lameddagesh'       => 496,
        'lbar'       => 278,                                      # (+1)
        'lbelt'       => 314,
        'lcaron'       => 400,                        # was 395
        'lcircumflexbelow'       => 278,                          # (+1)
        'lcommaaccent'       => 278,                              # +1
        'ldot'       => 479,
        'ldotbelow'       => 278,                                 # (+1)
        'ldotbelowmacron'       => 278,                           # (+1)
        'leftangleabovecmb'       => 0,
        'lefttackbelowcmb'       => 0,
        'less'       => 584,                                      # +1
        'lessequal'       => 549,                                 # +1
        'lezh'       => 595,
        'lfblock'       => 708,
        'lhookretroflex'       => 278,                            # (+1)
        'lira'       => 556,
        'liwnarmenian'       => 283,
        'lj'       => 555,
        'llinebelow'       => 278,                                # (+1)
        'lmiddletilde'       => 278,                              # (+1)
        'logicalnot'       => 584,                                # +1
        'longs'       => 277,
        'lowlinecmb'       => 0,
        'lozenge'       => 494,
        'lslash'       => 278,                                    # +1
        'ltshade'       => 708,
        'm'       => 889,
        'macron'       => 552,                        # afm 333 too narrow
        'macronbelowcmb'       => 0,
        'macroncmb'       => 0,
        'macronlowmod'       => 333,
        'macute'       => 889,
        'mahapakhhebrew'       => 0,
        'male'       => 750,
        'masoracirclehebrew'       => 0,
        'mdotaccent'       => 889,
        'mdotbelow'       => 889,
        'memdagesh'       => 629,
        'menarmenian'       => 611,
        'merkhahebrew'       => 0,
        'merkhakefulahebrew'       => 0,
        'mhook'       => 889,
        'minus'       => 584,                                     # +1
        'minusbelowcmb'       => 0,
        'minusmod'       => 333,
        'minute'       => 239,
        'mlonglegturned'       => 889,
        'mturned'       => 889,
        'mu'       => 611,                            # use afm, was TTF 603
        'multiply'       => 584,                                  # +1
        'munahhebrew'       => 0,
        'musicalnote'       => 500,
        'musicalnotedbl'       => 750,
        'musicsharpsign'       => 500,
        'n'       => 611,                                         # +1
        'nacute'       => 611,                                    # +1
        'napostrophe'       => 708,
        'ncaron'       => 611,                                    # +1
        'ncircumflexbelow'       => 611,                          # (+1)
        'ncommaaccent'       => 611,                              # +1
        'ndotaccent'       => 611,                                # (+1)
        'ndotbelow'       => 611,                                 # (+1)
        'nhookleft'       => 611,                                 # (+1)
        'nhookretroflex'       => 611,                            # (+1)
        'nine'       => 556,
        'ninesuperior'       => 333,
        'nj'       => 888,
        'nlegrightlong'       => 611,                             # (+1)
        'nlinebelow'       => 611,                                # (+1)
        'notequal'       => 549,                                  # +1
        'nowarmenian'       => 610,
        'nsuperior'       => 395,
        'ntilde'       => 611,                                    # +1
        'nu'       => 556,
        'numbersign'       => 556,
        'numeralsigngreek'       => 333,
        'numeralsignlowergreek'       => 333,
        'numsp'       => 556,
        'nundagesh'       => 385,
        'o'       => 611,                                         # +1
        'oacute'       => 611,                                    # +1
        'obarred'       => 611,                                   # (+1)
        'obarredcyrillic'       => 610,
        'obarreddieresiscyrillic'       => 610,
        'obreve'       => 611,                                    # (+1)
        'ocaron'       => 611,                                    # (+1)
        'ocircumflex'       => 611,                               # +1
        'ocircumflexacute'       => 611,                          # (+1)
        'ocircumflexdotbelow'       => 611,                       # (+1)
        'ocircumflexgrave'       => 611,                          # (+1)
        'ocircumflexhookabove'       => 611,                      # (+1)
        'ocircumflextilde'       => 611,                          # (+1)
        'odblgrave'       => 611,                                 # (+1)
        'odieresis'       => 611,                                 # +1
        'odieresiscyrillic'       => 610,
        'odotbelow'       => 611,                                 # (+1)
        'oe'       => 944,                                        # +1
        'ogonek'       => 333,
        'ogonekcmb'       => 0,
        'ograve'       => 611,                                    # +1
        'oharmenian'       => 608,
        'ohookabove'       => 611,                                # (+1)
        'ohorn'       => 671,
        'ohornacute'       => 671,
        'ohorndotbelow'       => 671,
        'ohorngrave'       => 671,
        'ohornhookabove'       => 671,
        'ohorntilde'       => 671,
        'ohungarumlaut'       => 611,                             # +1
        'oi'       => 733,
        'oinvertedbreve'       => 611,                            # (+1)
        'olehebrew'       => 0,
        'omacron'       => 611,                                   # +1
        'omacronacute'       => 611,                              # (+1)
        'omacrongrave'       => 611,                              # (+1)
        'omega'       => 834,
        'omega1'       => 834,
        'omegacyrillic'       => 778,
        'omegalatinclosed'       => 834,
        'omegaroundcyrillic'       => 648,
        'omegatitlocyrillic'       => 907,
        'omegatonos'       => 834,
        'omicron'       => 611,                                   # (+1)
        'omicrontonos'       => 611,                              # (+1)
        'one'       => 556,
        'oneeighth'       => 833,
        'onehalf'       => 834,                                   # +1
        'onequarter'       => 834,                                # +1
        'onesuperior'       => 333,
        'onethird'       => 833,
        'oogonek'       => 611,                                   # (+1)
        'oogonekmacron'       => 611,                             # (+1)
        'oopen'       => 556,
        'openbullet'       => 354,
        'ordfeminine'       => 370,
        'ordmasculine'       => 365,
        'orthogonal'       => 979,
        'oslash'       => 611,                                    # +1
        'oslashacute'       => 611,                               # (+1)
        'otcyrillic'       => 778,
        'otilde'       => 611,                                    # +1
        'otildeacute'       => 611,                               # (+1)
        'otildedieresis'       => 611,                            # (+1)
        'overline'       => 333,
        'overlinecmb'       => 0,
        'p'       => 611,                                         # +1
        'pacute'       => 611,                                    # (+1)
        'palatalizationcyrilliccmb'       => 0,
        'palochkacyrillic'       => 277,
        'paragraph'       => 556,
        'parenleft'       => 333,
        'parenright'       => 333,
        'partialdiff'       => 494,
        'pashtahebrew'       => 0,
        'pazerhebrew'       => 0,
        'pdotaccent'       => 611,                                # (+1)
        'pedagesh'       => 586,
        'pefinaldageshhebrew'       => 593,
        'peharmenian'       => 893,
        'pemiddlehookcyrillic'       => 911,
        'perafehebrew'       => 586,
        'percent'       => 889,
        'period'       => 278,                                    # +1
        'periodarmenian'       => 333,
        'periodcentered'       => 278,                            # +1
        'perispomenigreekcmb'       => 0,
        'perthousand'       => 1000,
        'peseta'       => 1104,
        'phi'       => 703,
        'phi1'       => 757,
        'philatin'       => 757,
        'phook'       => 611,                                     # (+1)
        'pi'       => 711,
        'piwrarmenian'       => 893,
        'plus'       => 584,                                      # +1
        'plusbelowcmb'       => 0,
        'plusminus'       => 548,                     # afm 584 too wide
        'plusmod'       => 333,
        'primemod'       => 237,
        'product'       => 823,
        'psi'       => 772,
        'psicyrillic'       => 772,
        'psilipneumatacyrilliccmb'       => 0,
        'puncsp'       => 277,
        'q'       => 611,                                         # +1
        'qadmahebrew'       => 0,
        'qarneyparahebrew'       => 0,
        'qhook'       => 611,                                     # (+1)
        'qofdagesh'       => 572,
        'question'       => 611,                                  # +1
        'questionarmenian'       => 292,
        'questiondown'       => 611,                              # +1
        'questiongreek'       => 333,
        'quotedbl'       => 474,
        'quotedblbase'       => 500,
        'quotedblleft'       => 500,
        'quotedblright'       => 500,
        'quoteleft'       => 278,                                 # +1
        'quotereversed'       => 277,
        'quoteright'       => 278,                                # +1
        'quotesinglbase'       => 278,                            # +1
        'quotesingle'       => 238,                               # +1
        'r'       => 389,
        'raarmenian'       => 605,
        'racute'       => 389,
        'radical'       => 549,                                   # +1
        'ramshorn'       => 600,
        'rcaron'       => 389,
        'rcommaaccent'       => 389,
        'rdblgrave'       => 389,
        'rdotaccent'       => 389,
        'rdotbelow'       => 389,
        'rdotbelowmacron'       => 389,
        'registered'       => 737,                                # +1
        'reharmenian'       => 610,
        'reshdageshhebrew'       => 521,
        'reviahebrew'       => 0,
        'revlogicalnot'       => 583,
        'rfishhook'       => 389,
        'rfishhookreversed'       => 389,
        'rho'       => 605,
        'rhook'       => 389,
        'rhookturned'       => 389,
        'rhookturnedsuperior'       => 279,
        'rhosymbolgreek'       => 617,
        'rhotichookmod'       => 333,
        'righttackbelowcmb'       => 0,
        'ring'       => 333,
        'ringbelowcmb'       => 0,
        'ringcmb'       => 0,
        'ringhalfleft'       => 333,
        'ringhalfleftarmenian'       => 277,
        'ringhalfleftbelowcmb'       => 0,
        'ringhalfleftcentered'       => 333,
        'ringhalfright'       => 333,
        'ringhalfrightbelowcmb'       => 0,
        'ringhalfrightcentered'       => 333,
        'rinvertedbreve'       => 389,
        'rlinebelow'       => 389,
        'rlongleg'       => 389,
        'rlonglegturned'       => 389,
        'rtblock'       => 708,
        'rturned'       => 389,
        'rturnedsuperior'       => 279,
        's'       => 556,
        'sacute'       => 556,
        'sacutedotaccent'       => 556,
        'samekhdagesh'       => 613,
        'scaron'       => 556,
        'scarondotaccent'       => 556,
        'scedilla'       => 556,
        'schwadieresiscyrillic'       => 556,
        'schwahook'       => 740,
        'scircumflex'       => 556,
        'scommaaccent'       => 556,
        'sdotaccent'       => 556,
        'sdotbelow'       => 556,
        'sdotbelowdotaccent'       => 556,
        'seagullbelowcmb'       => 0,
        'second'       => 479,
        'secondtonechinese'       => 333,
        'section'       => 556,
        'segoltahebrew'       => 0,
        'seharmenian'       => 610,
        'semicolon'       => 333,
        'seven'       => 556,
        'seveneighths'       => 833,
        'sevensuperior'       => 333,
        'shaarmenian'       => 514,
        'shade'       => 708,
        'shalshelethebrew'       => 0,
        'sheicoptic'       => 889,
        'shhacyrillic'       => 610,
        'shimacoptic'       => 578,
        'shindagesh'       => 714,
        'shindageshshindot'       => 714,
        'shindageshsindot'       => 714,
        'shook'       => 556,
        'sigma'       => 663,
        'sigma1'       => 532,
        'sigmalunatesymbolgreek'       => 556,
        'six'       => 556,
        'sixsuperior'       => 333,
        'slash'       => 278,                                     # +1
        'slongdotaccent'       => 277,
        'smileface'       => 1020,
        'soliduslongoverlaycmb'       => 0,
        'solidusshortoverlaycmb'       => 0,
        'space'       => 278,                                     # +1
        'spade'       => 531,
        'squarebelowcmb'       => 0,
        'sterling'       => 556,
        'strokelongoverlaycmb'       => 0,
        'strokeshortoverlaycmb'       => 0,
        'summation'       => 712,                     # afm 600 too narrow
        'sun'       => 916,
        't'       => 333,
        'tau'       => 408,
        'tavdages'       => 673,
        'tbar'       => 333,
        'tcaron'       => 479,                        # afm 389 too narrow
        'tccurl'       => 839,
        'tcedilla'       => 333,
        'tcircumflexbelow'       => 333,
        'tcommaaccent'       => 333,
        'tdieresis'       => 333,
        'tdotaccent'       => 333,
        'tdotbelow'       => 333,
        'tedescendercyrillic'       => 889,
        'telishagedolahebrew'       => 0,
        'telishaqetanahebrew'       => 0,
        'tesh'       => 573,
        'tetdagesh'       => 626,
        'tetsecyrillic'       => 645,
        'tevirhebrew'       => 0,
        'theta'       => 557,
        'theta1'       => 591,
        'thook'       => 333,
        'thorn'       => 611,                                     # +1
        'thousandcyrillic'       => 583,
        'three'       => 556,
        'threeeighths'       => 833,
        'threequarters'       => 834,                             # +1
        'threesuperior'       => 333,
        'tilde'       => 333,
        'tildebelowcmb'       => 0,
        'tildecomb'       => 0,
        'tildedoublecmb'       => 0,
        'tildeoverlaycmb'       => 0,
        'tildeverticalcmb'       => 0,
        'tipehahebrew'       => 0,
        'titlocyrilliccmb'       => 0,
        'tiwnarmenian'       => 893,
        'tlinebelow'       => 333,
        'toarmenian'       => 781,
        'tonebarextrahighmod'       => 382,
        'tonebarextralowmod'       => 382,
        'tonebarhighmod'       => 382,
        'tonebarlowmod'       => 382,
        'tonebarmidmod'       => 382,
        'tonefive'       => 497,
        'tonesix'       => 610,
        'tonetwo'       => 556,
        'tonos'       => 333,
        'tpalatalhook'       => 333,
        'tprime'       => 479,
        'trademark'       => 1000,
        'tretroflexhook'       => 333,
        'triagdn'       => 989,
        'triaglf'       => 989,
        'triagrt'       => 989,
        'triagup'       => 989,
        'ts'       => 814,
        'tsadidagesh'       => 511,
        'tturned'       => 333,
        'two'       => 556,
        'twostroke'       => 556,
        'twosuperior'       => 333,
        'twothirds'       => 833,
        'u'       => 611,                                         # +1
        'uacute'       => 611,                                    # +1
        'ubar'       => 611,                                      # (+1)
        'ubreve'       => 611,                                    # (+1)
        'ucaron'       => 611,                                    # (+1)
        'ucircumflex'       => 611,                               # +1
        'ucircumflexbelow'       => 611,                          # (+1)
        'udblgrave'       => 611,                                 # (+1)
        'udieresis'       => 611,                                 # +1
        'udieresisacute'       => 611,                            # (+1)
        'udieresisbelow'       => 611,                            # (+1)
        'udieresiscaron'       => 611,                            # (+1)
        'udieresiscyrillic'       => 556,
        'udieresisgrave'       => 611,                            # (+1)
        'udieresismacron'       => 611,                           # (+1)
        'udotbelow'       => 611,                                 # (+1)
        'ugrave'       => 611,                                    # +1
        'uhookabove'       => 611,                                # (+1)
        'uhorn'       => 713,
        'uhornacute'       => 713,
        'uhorndotbelow'       => 713,
        'uhorngrave'       => 713,
        'uhornhookabove'       => 713,
        'uhorntilde'       => 713,
        'uhungarumlaut'       => 611,                             # +1
        'uhungarumlautcyrillic'       => 556,
        'uinvertedbreve'       => 611,                            # (+1)
        'ukcyrillic'       => 981,
        'umacron'       => 611,                                   # +1
        'umacroncyrillic'       => 556,
        'umacrondieresis'       => 611,                           # (+1)
        'underscore'       => 556,
        'underscoredbl'       => 552,
        'uni01F6'       => 1035,
        'uni01F7'       => 688,
        'uni01F8'       => 722,
        'uni01F9'       => 610,
        'uni021C'       => 577,
        'uni021D'       => 520,
        'uni021E'       => 722,
        'uni021F'       => 610,
        'uni0220'       => 708,
        'uni0221'       => 791,
        'uni0222'       => 630,
        'uni0223'       => 630,
        'uni0224'       => 610,
        'uni0225'       => 500,
        'uni0226'       => 722,
        'uni0227'       => 556,
        'uni0228'       => 666,
        'uni0229'       => 556,
        'uni022A'       => 777,
        'uni022B'       => 610,
        'uni022C'       => 777,
        'uni022D'       => 610,
        'uni022E'       => 777,
        'uni022F'       => 610,
        'uni0230'       => 777,
        'uni0231'       => 610,
        'uni0232'       => 666,
        'uni0233'       => 556,
        'uni0234'       => 452,
        'uni0235'       => 785,
        'uni0236'       => 509,
        'uni0238'       => 953,
        'uni0239'       => 951,
        'uni023A'       => 722,
        'uni023B'       => 722,
        'uni023C'       => 556,
        'uni023D'       => 610,
        'uni023E'       => 610,
        'uni023F'       => 556,
        'uni0240'       => 500,
        'uni0241'       => 645,
        'uni0242'       => 483,
        'uni0243'       => 722,
        'uni0244'       => 722,
        'uni0245'       => 666,
        'uni0246'       => 666,
        'uni0247'       => 556,
        'uni0248'       => 556,
        'uni0249'       => 277,
        'uni024A'       => 780,
        'uni024B'       => 610,
        'uni024C'       => 722,
        'uni024D'       => 389,
        'uni024E'       => 666,
        'uni024F'       => 556,
        'uni0262'       => 596,
        'uni026A'       => 405,
        'uni0274'       => 648,
        'uni0276'       => 852,
        'uni0280'       => 588,
        'uni028F'       => 553,
        'uni0299'       => 620,
        'uni029C'       => 604,
        'uni029F'       => 450,
        'uni02A9'       => 860,
        'uni02AA'       => 775,
        'uni02AB'       => 661,
        'uni02AC'       => 533,
        'uni02AD'       => 563,
        'uni02AE'       => 705,
        'uni02AF'       => 705,
        'uni02B3'       => 279,
        'uni02DF'       => 333,
        'uni02E1'       => 179,
        'uni02E2'       => 372,
        'uni02EA'       => 333,
        'uni02EB'       => 333,
        'uni02EC'       => 333,
        'uni02ED'       => 333,
        'uni02EE'       => 500,
        'uni02EF'       => 333,
        'uni02F0'       => 333,
        'uni02F1'       => 333,
        'uni02F2'       => 333,
        'uni02F3'       => 333,
        'uni02F4'       => 333,
        'uni02F5'       => 333,
        'uni02F6'       => 333,
        'uni02F7'       => 333,
        'uni02F8'       => 333,
        'uni02F9'       => 333,
        'uni02FA'       => 333,
        'uni02FB'       => 333,
        'uni02FC'       => 333,
        'uni02FD'       => 397,
        'uni02FE'       => 397,
        'uni02FF'       => 333,
        'uni0326'       => 0,
        'uni0346'       => 0,
        'uni0347'       => 0,
        'uni0348'       => 0,
        'uni0349'       => 0,
        'uni034A'       => 0,
        'uni034B'       => 0,
        'uni034C'       => 0,
        'uni034D'       => 0,
        'uni034E'       => 0,
        'uni034F'       => 0,
        'uni0350'       => 0,
        'uni0351'       => 0,
        'uni0352'       => 0,
        'uni0353'       => 0,
        'uni0354'       => 0,
        'uni0355'       => 0,
        'uni0356'       => 0,
        'uni0357'       => 0,
        'uni0358'       => 0,
        'uni0359'       => 0,
        'uni035A'       => 0,
        'uni035B'       => 0,
        'uni035C'       => 0,
        'uni035D'       => 0,
        'uni035E'       => 0,
        'uni035F'       => 0,
        'uni0362'       => 0,
        'uni0363'       => 0,
        'uni0364'       => 0,
        'uni0365'       => 0,
        'uni0366'       => 0,
        'uni0367'       => 0,
        'uni0368'       => 0,
        'uni0369'       => 0,
        'uni036A'       => 0,
        'uni036B'       => 0,
        'uni036C'       => 0,
        'uni036D'       => 0,
        'uni036E'       => 0,
        'uni036F'       => 0,
        'uni0370'       => 553,
        'uni0371'       => 496,
        'uni0372'       => 610,
        'uni0373'       => 606,
        'uni0376'       => 719,
        'uni0377'       => 611,
        'uni037B'       => 556,
        'uni037C'       => 556,
        'uni037D'       => 556,
        'uni037F'       => 556,
        'uni03CF'       => 722,
        'uni03D7'       => 676,
        'uni03D8'       => 777,
        'uni03D9'       => 610,
        'uni03DB'       => 556,
        'uni03DF'       => 529,
        'uni03E1'       => 610,
        'uni03F4'       => 777,
        'uni03F5'       => 479,
        'uni03F6'       => 479,
        'uni03F7'       => 666,
        'uni03F8'       => 610,
        'uni03F9'       => 722,
        'uni03FA'       => 833,
        'uni03FB'       => 739,
        'uni03FC'       => 605,
        'uni03FD'       => 722,
        'uni03FE'       => 722,
        'uni03FF'       => 722,
        'uni0400'       => 666,
        'uni040D'       => 719,
        'uni0450'       => 556,
        'uni045D'       => 610,
        'uni0487'       => 0,
        'uni0488'       => 0,
        'uni0489'       => 0,
        'uni048A'       => 719,
        'uni048B'       => 610,
        'uni048C'       => 708,
        'uni048D'       => 593,
        'uni048E'       => 666,
        'uni048F'       => 610,
        'uni04C5'       => 687,
        'uni04C6'       => 622,
        'uni04C9'       => 722,
        'uni04CA'       => 604,
        'uni04CD'       => 833,
        'uni04CE'       => 739,
        'uni04CF'       => 277,
        'uni04EC'       => 718,
        'uni04ED'       => 551,
        'uni04F6'       => 613,
        'uni04F7'       => 556,
        'uni04FA'       => 613,
        'uni04FB'       => 469,
        'uni04FC'       => 666,
        'uni04FD'       => 556,
        'uni04FE'       => 666,
        'uni04FF'       => 556,
        'uni0500'       => 666,
        'uni0501'       => 610,
        'uni0502'       => 979,
        'uni0503'       => 932,
        'uni0504'       => 980,
        'uni0505'       => 848,
        'uni0506'       => 642,
        'uni0507'       => 510,
        'uni0508'       => 1004,
        'uni0509'       => 939,
        'uni050A'       => 1038,
        'uni050B'       => 926,
        'uni050C'       => 777,
        'uni050D'       => 596,
        'uni050E'       => 774,
        'uni050F'       => 1204,
        'uni0510'       => 642,
        'uni0511'       => 478,
        'uni0512'       => 687,
        'uni0513'       => 622,
        'uni0514'       => 1018,
        'uni0515'       => 863,
        'uni0516'       => 833,
        'uni0517'       => 825,
        'uni0518'       => 1016,
        'uni0519'       => 883,
        'uni051A'       => 777,
        'uni051B'       => 610,
        'uni051C'       => 943,
        'uni051D'       => 777,
        'uni051E'       => 722,
        'uni051F'       => 565,
        'uni0520'       => 1063,
        'uni0521'       => 890,
        'uni0522'       => 1096,
        'uni0523'       => 872,
        'uni0524'       => 719,
        'uni0525'       => 610,
        'uni0526'       => 708,
        'uni0527'       => 610,
        'uni0528'       => 722,
        'uni0529'       => 604,
        'uni052A'       => 1310,
        'uni052B'       => 1113,
        'uni052C'       => 728,
        'uni052D'       => 644,
        'uni052E'       => 687,
        'uni052F'       => 622,
        'uni058A'       => 392,
        'uni058D'       => 1001,
        'uni058E'       => 1001,
        'uni058F'       => 746,
        'uni05A2'       => 0,
        'uni05BA'       => 0,
        'uni05C5'       => 0,
        'uni05C6'       => 385,
        'uni05C7'       => 0,
        'uni1D00'       => 591,
        'uni1D01'       => 776,
        'uni1D02'       => 889,
        'uni1D03'       => 618,
        'uni1D04'       => 556,
        'uni1D05'       => 605,
        'uni1D06'       => 605,
        'uni1D07'       => 488,
        'uni1D08'       => 510,
        'uni1D09'       => 277,
        'uni1D0A'       => 500,
        'uni1D0B'       => 565,
        'uni1D0C'       => 484,
        'uni1D0D'       => 739,
        'uni1D0E'       => 591,
        'uni1D0F'       => 610,
        'uni1D10'       => 556,
        'uni1D11'       => 610,
        'uni1D12'       => 556,
        'uni1D13'       => 610,
        'uni1D14'       => 943,
        'uni1D15'       => 577,
        'uni1D16'       => 610,
        'uni1D17'       => 610,
        'uni1D18'       => 581,
        'uni1D19'       => 588,
        'uni1D1A'       => 588,
        'uni1D1B'       => 458,
        'uni1D1C'       => 591,
        'uni1D1D'       => 610,
        'uni1D1E'       => 731,
        'uni1D1F'       => 610,
        'uni1D20'       => 556,
        'uni1D21'       => 777,
        'uni1D22'       => 500,
        'uni1D23'       => 526,
        'uni1D24'       => 493,
        'uni1D25'       => 615,
        'uni1D26'       => 469,
        'uni1D27'       => 556,
        'uni1D28'       => 610,
        'uni1D29'       => 581,
        'uni1D2A'       => 772,
        'uni1D2B'       => 622,
        'uni1D2C'       => 509,
        'uni1D2D'       => 732,
        'uni1D2E'       => 498,
        'uni1D2F'       => 498,
        'uni1D30'       => 505,
        'uni1D31'       => 480,
        'uni1D32'       => 480,
        'uni1D33'       => 528,
        'uni1D34'       => 498,
        'uni1D35'       => 211,
        'uni1D36'       => 375,
        'uni1D37'       => 508,
        'uni1D38'       => 418,
        'uni1D39'       => 576,
        'uni1D3A'       => 495,
        'uni1D3B'       => 498,
        'uni1D3C'       => 547,
        'uni1D3D'       => 497,
        'uni1D3E'       => 457,
        'uni1D3F'       => 531,
        'uni1D40'       => 414,
        'uni1D41'       => 480,
        'uni1D42'       => 675,
        'uni1D43'       => 384,
        'uni1D44'       => 384,
        'uni1D45'       => 405,
        'uni1D46'       => 611,
        'uni1D47'       => 415,
        'uni1D48'       => 415,
        'uni1D49'       => 398,
        'uni1D4A'       => 398,
        'uni1D4B'       => 320,
        'uni1D4C'       => 320,
        'uni1D4D'       => 415,
        'uni1D4E'       => 170,
        'uni1D4F'       => 381,
        'uni1D50'       => 594,
        'uni1D51'       => 402,
        'uni1D52'       => 426,
        'uni1D53'       => 404,
        'uni1D54'       => 426,
        'uni1D55'       => 426,
        'uni1D56'       => 420,
        'uni1D57'       => 237,
        'uni1D58'       => 402,
        'uni1D59'       => 402,
        'uni1D5A'       => 594,
        'uni1D5B'       => 401,
        'uni1D5C'       => 430,
        'uni1D5D'       => 425,
        'uni1D5E'       => 388,
        'uni1D5F'       => 427,
        'uni1D60'       => 490,
        'uni1D61'       => 395,
        'uni1D62'       => 170,
        'uni1D63'       => 279,
        'uni1D64'       => 402,
        'uni1D65'       => 401,
        'uni1D66'       => 425,
        'uni1D67'       => 388,
        'uni1D68'       => 415,
        'uni1D69'       => 490,
        'uni1D6A'       => 395,
        'uni1D6B'       => 916,
        'uni1D6C'       => 610,
        'uni1D6D'       => 610,
        'uni1D6E'       => 333,
        'uni1D6F'       => 889,
        'uni1D70'       => 610,
        'uni1D71'       => 610,
        'uni1D72'       => 389,
        'uni1D73'       => 389,
        'uni1D74'       => 556,
        'uni1D75'       => 333,
        'uni1D76'       => 500,
        'uni1D77'       => 610,
        'uni1D78'       => 400,
        'uni1D79'       => 530,
        'uni1D7A'       => 884,
        'uni1D7B'       => 277,
        'uni1D7C'       => 277,
        'uni1D7D'       => 610,
        'uni1D7E'       => 591,
        'uni1D7F'       => 621,
        'uni1D80'       => 610,
        'uni1D81'       => 610,
        'uni1D82'       => 333,
        'uni1D83'       => 726,
        'uni1D84'       => 556,
        'uni1D85'       => 277,
        'uni1D86'       => 889,
        'uni1D87'       => 610,
        'uni1D88'       => 610,
        'uni1D89'       => 389,
        'uni1D8A'       => 556,
        'uni1D8B'       => 393,
        'uni1D8C'       => 556,
        'uni1D8D'       => 556,
        'uni1D8E'       => 500,
        'uni1D8F'       => 556,
        'uni1D90'       => 610,
        'uni1D91'       => 610,
        'uni1D92'       => 556,
        'uni1D93'       => 478,
        'uni1D94'       => 510,
        'uni1D95'       => 588,
        'uni1D96'       => 277,
        'uni1D97'       => 556,
        'uni1D98'       => 319,
        'uni1D99'       => 610,
        'uni1D9A'       => 526,
        'uni1D9B'       => 405,
        'uni1D9C'       => 404,
        'uni1D9D'       => 404,
        'uni1D9E'       => 432,
        'uni1D9F'       => 320,
        'uni1DA0'       => 213,
        'uni1DA1'       => 213,
        'uni1DA2'       => 415,
        'uni1DA3'       => 402,
        'uni1DA4'       => 170,
        'uni1DA5'       => 170,
        'uni1DA6'       => 170,
        'uni1DA7'       => 170,
        'uni1DA8'       => 275,
        'uni1DA9'       => 170,
        'uni1DAA'       => 170,
        'uni1DAB'       => 292,
        'uni1DAC'       => 594,
        'uni1DAD'       => 594,
        'uni1DAE'       => 402,
        'uni1DAF'       => 402,
        'uni1DB0'       => 429,
        'uni1DB1'       => 426,
        'uni1DB2'       => 526,
        'uni1DB3'       => 359,
        'uni1DB4'       => 213,
        'uni1DB5'       => 237,
        'uni1DB6'       => 402,
        'uni1DB7'       => 433,
        'uni1DB8'       => 402,
        'uni1DB9'       => 402,
        'uni1DBA'       => 401,
        'uni1DBB'       => 327,
        'uni1DBC'       => 327,
        'uni1DBD'       => 452,
        'uni1DBE'       => 363,
        'uni1DBF'       => 390,
        'uni1DC0'       => 0,
        'uni1DC1'       => 0,
        'uni1DC2'       => 0,
        'uni1DC3'       => 0,
        'uni1DC4'       => 0,
        'uni1DC5'       => 0,
        'uni1DC6'       => 0,
        'uni1DC7'       => 0,
        'uni1DC8'       => 0,
        'uni1DC9'       => 0,
        'uni1DCA'       => 0,
        'uni1DFE'       => 0,
        'uni1DFF'       => 0,
        'uni1E9C'       => 333,
        'uni1E9D'       => 305,
        'uni1E9E'       => 715,
        'uni1E9F'       => 624,
        'uni1EFA'       => 840,
        'uni1EFB'       => 517,
        'uni1EFC'       => 634,
        'uni1EFD'       => 611,
        'uni1EFE'       => 758,
        'uni1EFF'       => 658,
        'uni1F00'       => 620,
        'uni1F01'       => 620,
        'uni1F02'       => 620,
        'uni1F03'       => 620,
        'uni1F04'       => 620,
        'uni1F05'       => 620,
        'uni1F06'       => 620,
        'uni1F07'       => 620,
        'uni1F08'       => 722,
        'uni1F09'       => 722,
        'uni1F0A'       => 868,
        'uni1F0B'       => 868,
        'uni1F0C'       => 868,
        'uni1F0D'       => 868,
        'uni1F0E'       => 868,
        'uni1F0F'       => 868,
        'uni1F10'       => 478,
        'uni1F11'       => 478,
        'uni1F12'       => 478,
        'uni1F13'       => 478,
        'uni1F14'       => 478,
        'uni1F15'       => 478,
        'uni1F18'       => 764,
        'uni1F19'       => 764,
        'uni1F1A'       => 959,
        'uni1F1B'       => 959,
        'uni1F1C'       => 959,
        'uni1F1D'       => 959,
        'uni1F20'       => 610,
        'uni1F21'       => 610,
        'uni1F22'       => 610,
        'uni1F23'       => 610,
        'uni1F24'       => 610,
        'uni1F25'       => 610,
        'uni1F26'       => 610,
        'uni1F27'       => 610,
        'uni1F28'       => 819,
        'uni1F29'       => 819,
        'uni1F2A'       => 1015,
        'uni1F2B'       => 1015,
        'uni1F2C'       => 1015,
        'uni1F2D'       => 1015,
        'uni1F2E'       => 1015,
        'uni1F2F'       => 1015,
        'uni1F30'       => 277,
        'uni1F31'       => 277,
        'uni1F32'       => 277,
        'uni1F33'       => 277,
        'uni1F34'       => 277,
        'uni1F35'       => 277,
        'uni1F36'       => 277,
        'uni1F37'       => 277,
        'uni1F38'       => 375,
        'uni1F39'       => 375,
        'uni1F3A'       => 570,
        'uni1F3B'       => 570,
        'uni1F3C'       => 570,
        'uni1F3D'       => 570,
        'uni1F3E'       => 570,
        'uni1F3F'       => 570,
        'uni1F40'       => 610,
        'uni1F41'       => 610,
        'uni1F42'       => 610,
        'uni1F43'       => 610,
        'uni1F44'       => 610,
        'uni1F45'       => 610,
        'uni1F48'       => 826,
        'uni1F49'       => 826,
        'uni1F4A'       => 1070,
        'uni1F4B'       => 1070,
        'uni1F4C'       => 973,
        'uni1F4D'       => 973,
        'uni1F50'       => 591,
        'uni1F51'       => 591,
        'uni1F52'       => 591,
        'uni1F53'       => 591,
        'uni1F54'       => 591,
        'uni1F55'       => 591,
        'uni1F56'       => 591,
        'uni1F57'       => 591,
        'uni1F59'       => 813,
        'uni1F5B'       => 959,
        'uni1F5D'       => 1057,
        'uni1F5F'       => 959,
        'uni1F60'       => 834,
        'uni1F61'       => 834,
        'uni1F62'       => 834,
        'uni1F63'       => 834,
        'uni1F64'       => 834,
        'uni1F65'       => 834,
        'uni1F66'       => 834,
        'uni1F67'       => 834,
        'uni1F68'       => 829,
        'uni1F69'       => 829,
        'uni1F6A'       => 1073,
        'uni1F6B'       => 1073,
        'uni1F6C'       => 976,
        'uni1F6D'       => 976,
        'uni1F6E'       => 976,
        'uni1F6F'       => 976,
        'uni1F70'       => 620,
        'uni1F71'       => 620,
        'uni1F72'       => 478,
        'uni1F73'       => 478,
        'uni1F74'       => 610,
        'uni1F75'       => 610,
        'uni1F76'       => 277,
        'uni1F77'       => 277,
        'uni1F78'       => 610,
        'uni1F79'       => 610,
        'uni1F7A'       => 591,
        'uni1F7B'       => 591,
        'uni1F7C'       => 834,
        'uni1F7D'       => 834,
        'uni1F80'       => 620,
        'uni1F81'       => 620,
        'uni1F82'       => 620,
        'uni1F83'       => 620,
        'uni1F84'       => 620,
        'uni1F85'       => 620,
        'uni1F86'       => 620,
        'uni1F87'       => 620,
        'uni1F88'       => 722,
        'uni1F89'       => 722,
        'uni1F8A'       => 868,
        'uni1F8B'       => 868,
        'uni1F8C'       => 868,
        'uni1F8D'       => 868,
        'uni1F8E'       => 868,
        'uni1F8F'       => 868,
        'uni1F90'       => 610,
        'uni1F91'       => 610,
        'uni1F92'       => 610,
        'uni1F93'       => 610,
        'uni1F94'       => 610,
        'uni1F95'       => 610,
        'uni1F96'       => 610,
        'uni1F97'       => 610,
        'uni1F98'       => 819,
        'uni1F99'       => 819,
        'uni1F9A'       => 1015,
        'uni1F9B'       => 1015,
        'uni1F9C'       => 1015,
        'uni1F9D'       => 1015,
        'uni1F9E'       => 1015,
        'uni1F9F'       => 1015,
        'uni1FA0'       => 834,
        'uni1FA1'       => 834,
        'uni1FA2'       => 834,
        'uni1FA3'       => 834,
        'uni1FA4'       => 834,
        'uni1FA5'       => 834,
        'uni1FA6'       => 834,
        'uni1FA7'       => 834,
        'uni1FA8'       => 829,
        'uni1FA9'       => 829,
        'uni1FAA'       => 1073,
        'uni1FAB'       => 1073,
        'uni1FAC'       => 976,
        'uni1FAD'       => 976,
        'uni1FAE'       => 976,
        'uni1FAF'       => 976,
        'uni1FB0'       => 620,
        'uni1FB1'       => 620,
        'uni1FB2'       => 620,
        'uni1FB3'       => 620,
        'uni1FB4'       => 620,
        'uni1FB6'       => 620,
        'uni1FB7'       => 620,
        'uni1FB8'       => 722,
        'uni1FB9'       => 722,
        'uni1FBA'       => 722,
        'uni1FBB'       => 722,
        'uni1FBC'       => 722,
        'uni1FBD'       => 333,
        'uni1FBE'       => 333,
        'uni1FBF'       => 333,
        'uni1FC0'       => 333,
        'uni1FC1'       => 333,
        'uni1FC2'       => 610,
        'uni1FC3'       => 610,
        'uni1FC4'       => 610,
        'uni1FC6'       => 610,
        'uni1FC7'       => 610,
        'uni1FC8'       => 813,
        'uni1FC9'       => 862,
        'uni1FCA'       => 868,
        'uni1FCB'       => 917,
        'uni1FCC'       => 722,
        'uni1FCD'       => 333,
        'uni1FCE'       => 333,
        'uni1FCF'       => 333,
        'uni1FD0'       => 277,
        'uni1FD1'       => 277,
        'uni1FD2'       => 277,
        'uni1FD3'       => 277,
        'uni1FD6'       => 277,
        'uni1FD7'       => 277,
        'uni1FD8'       => 277,
        'uni1FD9'       => 277,
        'uni1FDA'       => 424,
        'uni1FDB'       => 473,
        'uni1FDD'       => 333,
        'uni1FDE'       => 333,
        'uni1FDF'       => 333,
        'uni1FE0'       => 591,
        'uni1FE1'       => 591,
        'uni1FE2'       => 591,
        'uni1FE3'       => 591,
        'uni1FE4'       => 605,
        'uni1FE5'       => 605,
        'uni1FE6'       => 591,
        'uni1FE7'       => 591,
        'uni1FE8'       => 666,
        'uni1FE9'       => 666,
        'uni1FEA'       => 862,
        'uni1FEB'       => 911,
        'uni1FEC'       => 764,
        'uni1FED'       => 333,
        'uni1FEE'       => 333,
        'uni1FEF'       => 333,
        'uni1FF2'       => 834,
        'uni1FF3'       => 834,
        'uni1FF4'       => 834,
        'uni1FF6'       => 834,
        'uni1FF7'       => 834,
        'uni1FF8'       => 924,
        'uni1FF9'       => 826,
        'uni1FFA'       => 927,
        'uni1FFB'       => 829,
        'uni1FFC'       => 780,
        'uni1FFD'       => 333,
        'uni1FFE'       => 333,
        'uni2000'       => 500,
        'uni2001'       => 1000,
        'uni2006'       => 166,
        'uni201F'       => 500,
        'uni202A'       => 0,
        'uni202B'       => 0,
        'uni202F'       => 200,
        'uni203D'       => 610,
        'uni205E'       => 333,
        'uni206A'       => 0,
        'uni206B'       => 0,
        'uni206C'       => 0,
        'uni206D'       => 0,
        'uni206E'       => 0,
        'uni206F'       => 0,
        'uni2090'       => 384,
        'uni2091'       => 398,
        'uni2092'       => 426,
        'uni2093'       => 395,
        'uni2094'       => 398,
        'uni20A0'       => 556,
        'uni20A5'       => 889,
        'uni20A6'       => 722,
        'uni20A8'       => 1215,
        'uni20AD'       => 722,
        'uni20AE'       => 610,
        'uni20AF'       => 1085,
        'uni20B0'       => 556,
        'uni20B1'       => 666,
        'uni20B2'       => 777,
        'uni20B3'       => 722,
        'uni20B4'       => 666,
        'uni20B5'       => 722,
        'uni20B6'       => 556,
        'uni20B7'       => 666,
        'uni20B8'       => 610,
        'uni20B9'       => 556,
        'uni20BA'       => 595,
        'uni20BB'       => 881,
        'uni20BC'       => 902,
        'uni20BD'       => 556,
        'uni20BE'       => 823,
        'uni20BF'       => 722,
        'uni20F0'       => 0,
        'uni214D'       => 1000,
        'uni214E'       => 500,
        'uni2184'       => 556,
        'uni2C60'       => 610,
        'uni2C61'       => 277,
        'uni2C62'       => 610,
        'uni2C63'       => 666,
        'uni2C64'       => 722,
        'uni2C65'       => 556,
        'uni2C66'       => 333,
        'uni2C67'       => 722,
        'uni2C68'       => 610,
        'uni2C69'       => 722,
        'uni2C6A'       => 556,
        'uni2C6B'       => 610,
        'uni2C6C'       => 500,
        'uni2C6D'       => 777,
        'uni2C6E'       => 833,
        'uni2C6F'       => 722,
        'uni2C70'       => 777,
        'uni2C71'       => 603,
        'uni2C72'       => 1044,
        'uni2C73'       => 858,
        'uni2C74'       => 556,
        'uni2C75'       => 553,
        'uni2C76'       => 447,
        'uni2C77'       => 703,
        'uni2C78'       => 700,
        'uni2C79'       => 389,
        'uni2C7A'       => 610,
        'uni2C7B'       => 488,
        'uni2C7C'       => 193,
        'uni2C7D'       => 401,
        'uni2C7E'       => 666,
        'uni2C7F'       => 610,
        'uni2E17'       => 333,
        'uniA717'       => 0,
        'uniA718'       => 0,
        'uniA719'       => 0,
        'uniA71A'       => 0,
        'uniA71B'       => 500,
        'uniA71C'       => 500,
        'uniA71D'       => 333,
        'uniA71E'       => 333,
        'uniA71F'       => 333,
        'uniA720'       => 0,
        'uniA721'       => 0,
        'uniA722'       => 302,
        'uniA723'       => 231,
        'uniA724'       => 299,
        'uniA725'       => 238,
        'uniA726'       => 722,
        'uniA727'       => 610,
        'uniA728'       => 853,
        'uniA729'       => 721,
        'uniA72A'       => 562,
        'uniA72B'       => 562,
        'uniA72C'       => 535,
        'uniA72D'       => 535,
        'uniA72E'       => 632,
        'uniA72F'       => 632,
        'uniA730'       => 520,
        'uniA731'       => 560,
        'uniA732'       => 1210,
        'uniA733'       => 874,
        'uniA734'       => 1183,
        'uniA735'       => 926,
        'uniA736'       => 1116,
        'uniA737'       => 892,
        'uniA738'       => 968,
        'uniA739'       => 796,
        'uniA73A'       => 968,
        'uniA73B'       => 796,
        'uniA73C'       => 968,
        'uniA73D'       => 796,
        'uniA73E'       => 722,
        'uniA73F'       => 556,
        'uniA740'       => 722,
        'uniA741'       => 556,
        'uniA742'       => 722,
        'uniA743'       => 556,
        'uniA744'       => 722,
        'uniA745'       => 556,
        'uniA746'       => 755,
        'uniA747'       => 418,
        'uniA748'       => 610,
        'uniA749'       => 277,
        'uniA74A'       => 880,
        'uniA74B'       => 669,
        'uniA74C'       => 879,
        'uniA74D'       => 692,
        'uniA74E'       => 1315,
        'uniA74F'       => 1004,
        'uniA750'       => 666,
        'uniA751'       => 610,
        'uniA752'       => 857,
        'uniA753'       => 771,
        'uniA754'       => 950,
        'uniA755'       => 857,
        'uniA756'       => 807,
        'uniA757'       => 610,
        'uniA758'       => 986,
        'uniA759'       => 771,
        'uniA75A'       => 610,
        'uniA75B'       => 466,
        'uniA75C'       => 645,
        'uniA75D'       => 645,
        'uniA75E'       => 666,
        'uniA75F'       => 556,
        'uniA760'       => 943,
        'uniA761'       => 777,
        'uniA762'       => 584,
        'uniA763'       => 545,
        'uniA764'       => 666,
        'uniA765'       => 610,
        'uniA766'       => 666,
        'uniA767'       => 610,
        'uniA768'       => 579,
        'uniA769'       => 483,
        'uniA76A'       => 464,
        'uniA76B'       => 464,
        'uniA76C'       => 556,
        'uniA76D'       => 556,
        'uniA76E'       => 573,
        'uniA76F'       => 573,
        'uniA770'       => 334,
        'uniA771'       => 784,
        'uniA772'       => 442,
        'uniA773'       => 1057,
        'uniA774'       => 774,
        'uniA775'       => 389,
        'uniA776'       => 779,
        'uniA777'       => 751,
        'uniA778'       => 514,
        'uniA779'       => 777,
        'uniA77A'       => 610,
        'uniA77B'       => 500,
        'uniA77C'       => 389,
        'uniA77D'       => 589,
        'uniA77E'       => 611,
        'uniA77F'       => 611,
        'uniA780'       => 610,
        'uniA781'       => 277,
        'uniA782'       => 815,
        'uniA783'       => 650,
        'uniA784'       => 500,
        'uniA785'       => 389,
        'uniA786'       => 673,
        'uniA787'       => 555,
        'uniA788'       => 333,
        'uniA789'       => 333,
        'uniA78A'       => 388,
        'uniA78B'       => 237,
        'uniA78C'       => 237,
        'uniA78D'       => 722,
        'uniA78E'       => 542,
        'uniA78F'       => 333,
        'uniA790'       => 759,
        'uniA791'       => 623,
        'uniA792'       => 722,
        'uniA793'       => 556,
        'uniA794'       => 556,
        'uniA795'       => 610,
        'uniA796'       => 912,
        'uniA797'       => 811,
        'uniA798'       => 662,
        'uniA799'       => 333,
        'uniA79A'       => 714,
        'uniA79B'       => 595,
        'uniA79C'       => 734,
        'uniA79D'       => 589,
        'uniA79E'       => 714,
        'uniA79F'       => 595,
        'uniA7A0'       => 777,
        'uniA7A1'       => 610,
        'uniA7A2'       => 722,
        'uniA7A3'       => 556,
        'uniA7A4'       => 722,
        'uniA7A5'       => 610,
        'uniA7A6'       => 722,
        'uniA7A7'       => 389,
        'uniA7A8'       => 666,
        'uniA7A9'       => 556,
        'uniA7AA'       => 815,
        'uniA7AB'       => 642,
        'uniA7AC'       => 763,
        'uniA7AD'       => 772,
        'uniA7AE'       => 610,
        'uniA7B0'       => 722,
        'uniA7B1'       => 610,
        'uniA7B2'       => 523,
        'uniA7B3'       => 778,
        'uniA7B4'       => 722,
        'uniA7B5'       => 620,
        'uniA7B6'       => 1012,
        'uniA7B7'       => 834,
        'uniA7F7'       => 735,
        'uniA7F8'       => 450,
        'uniA7F9'       => 641,
        'uniA7FA'       => 889,
        'uniA7FB'       => 610,
        'uniA7FC'       => 666,
        'uniA7FD'       => 833,
        'uniA7FE'       => 277,
        'uniA7FF'       => 1175,
        'uniAB30'       => 614,
        'uniAB31'       => 889,
        'uniAB32'       => 501,
        'uniAB33'       => 556,
        'uniAB34'       => 668,
        'uniAB35'       => 333,
        'uniAB36'       => 610,
        'uniAB37'       => 486,
        'uniAB38'       => 277,
        'uniAB39'       => 372,
        'uniAB3A'       => 921,
        'uniAB3B'       => 621,
        'uniAB3C'       => 610,
        'uniAB3D'       => 575,
        'uniAB3E'       => 575,
        'uniAB3F'       => 610,
        'uniAB40'       => 967,
        'uniAB41'       => 943,
        'uniAB42'       => 943,
        'uniAB43'       => 1004,
        'uniAB44'       => 1004,
        'uniAB45'       => 586,
        'uniAB46'       => 628,
        'uniAB47'       => 371,
        'uniAB48'       => 560,
        'uniAB49'       => 516,
        'uniAB4A'       => 687,
        'uniAB4B'       => 524,
        'uniAB4C'       => 784,
        'uniAB4D'       => 319,
        'uniAB4E'       => 610,
        'uniAB4F'       => 610,
        'uniAB50'       => 889,
        'uniAB51'       => 889,
        'uniAB52'       => 645,
        'uniAB53'       => 577,
        'uniAB54'       => 647,
        'uniAB55'       => 607,
        'uniAB56'       => 601,
        'uniAB57'       => 591,
        'uniAB58'       => 636,
        'uniAB59'       => 591,
        'uniAB5A'       => 537,
        'uniAB5B'       => 333,
        'uniAB5C'       => 367,
        'uniAB5D'       => 320,
        'uniAB5E'       => 291,
        'uniAB5F'       => 443,
        'uniAB60'       => 854,
        'uniAB61'       => 800,
        'uniAB62'       => 943,
        'uniAB63'       => 978,
        'uniAB64'       => 610,
        'uniAB65'       => 669,
        'uniF301'       => 0,
        'uniFB05'       => 645,
        'uniFB06'       => 857,
        'uniFB13'       => 1226,
        'uniFB14'       => 1226,
        'uniFB15'       => 1226,
        'uniFB16'       => 1226,
        'uniFB17'       => 1333,
        'uniFB1D'       => 272,
        'uniFB1E'       => 0,
        'uniFB21'       => 763,
        'uniFB22'       => 696,
        'uniFB23'       => 760,
        'uniFB24'       => 637,
        'uniFB25'       => 637,
        'uniFB26'       => 718,
        'uniFB27'       => 667,
        'uniFB28'       => 770,
        'uniFB29'       => 583,
        'uniFE20'       => 0,
        'uniFE21'       => 0,
        'uniFE22'       => 0,
        'uniFE23'       => 0,
        'uniFFFC'       => 1000,
        'uogonek'       => 611,                                   # +1
        'upblock'       => 708,
        'upperdothebrew'       => 0,
        'upsilon'       => 591,
        'upsilondieresis'       => 591,
        'upsilondieresistonos'       => 591,
        'upsilonlatin'       => 621,
        'upsilontonos'       => 591,
        'uptackbelowcmb'       => 0,
        'uptackmod'       => 333,
        'uring'       => 611,                                     # +1
        'ustraightcyrillic'       => 556,
        'ustraightstrokecyrillic'       => 556,
        'utilde'       => 611,                                    # (+1)
        'utildeacute'       => 611,                               # (+1)
        'utildebelow'       => 611,                               # (+1)
        'v'       => 556,
        'vdotbelow'       => 556,
        'verticallineabovecmb'       => 0,
        'verticallinebelowcmb'       => 0,
        'verticallinelowmod'       => 333,
        'verticallinemod'       => 333,
        'vewarmenian'       => 611,
        'vhook'       => 591,
        'voarmenian'       => 610,
        'vtilde'       => 556,
        'vturned'       => 556,
        'w'       => 778,                                         # +1
        'wacute'       => 778,                                    # (+1)
        'wcircumflex'       => 778,                               # (+1)
        'wdieresis'       => 778,                                 # (+1)
        'wdotaccent'       => 778,                                # (+1)
        'wdotbelow'       => 778,                                 # (+1)
        'wgrave'       => 778,                                    # (+1)
        'won'       => 943,
        'wring'       => 778,                                     # (+1)
        'wsuperior'       => 554,
        'wturned'       => 778,                                   # (+1)
        'wynn'       => 617,
        'x'       => 556,
        'xabovecmb'       => 0,
        'xdieresis'       => 556,
        'xdotaccent'       => 556,
        'xeharmenian'       => 890,
        'xi'       => 449,
        'xsuperior'       => 398,
        'y'       => 556,
        'yacute'       => 556,
        'ycircumflex'       => 556,
        'ydieresis'       => 556,
        'ydotaccent'       => 556,
        'ydotbelow'       => 556,
        'yen'       => 556,
        'yerahbenyomohebrew'       => 0,
        'yerudieresiscyrillic'       => 854,
        'yetivhebrew'       => 0,
        'ygrave'       => 556,
        'yhook'       => 556,
        'yhookabove'       => 556,
        'yiarmenian'       => 280,
        'yiwnarmenian'       => 439,
        'yoddagesh'       => 322,
        'yotgreek'       => 277,
        'ypogegrammeni'       => 333,
        'ypogegrammenigreekcmb'       => 0,
        'yr'       => 666,
        'yring'       => 556,
        'ysuperior'       => 404,
        'ytilde'       => 556,
        'yturned'       => 556,
        'yusbigcyrillic'       => 753,
        'yusbigiotifiedcyrillic'       => 978,
        'yuslittlecyrillic'       => 556,
        'yuslittleiotifiedcyrillic'       => 800,
        'z'       => 500,
        'zaarmenian'       => 618,
        'zacute'       => 500,
        'zaqefgadolhebrew'       => 0,
        'zaqefqatanhebrew'       => 0,
        'zarqahebrew'       => 0,
        'zayindagesh'       => 437,
        'zcaron'       => 500,
        'zcircumflex'       => 500,
        'zcurl'       => 696,
        'zdotaccent'       => 500,
        'zdotbelow'       => 500,
        'zedescendercyrillic'       => 510,
        'zedieresiscyrillic'       => 510,
        'zero'       => 556,
        'zerosuperior'       => 333,
        'zerowidthspace'       => 0,
        'zeta'       => 491,
        'zhearmenian'       => 664,
        'zhebrevecyrillic'       => 736,
        'zhedescendercyrillic'       => 736,
        'zhedieresiscyrillic'       => 736,
        'zinorhebrew'       => 0,
        'zlinebelow'       => 500,
        'zretroflexhook'       => 500,
        'zstroke'       => 500,
    },
    'wxold' => { # HORIZ. WIDTH TABLE
        'space' => '278',                        # C+0x20 # U+0x0020
        'exclam' => '333',                       # C+0x21 # U+0x0021
        'quotedbl' => '474',                     # C+0x22 # U+0x0022
        'numbersign' => '556',                   # C+0x23 # U+0x0023
        'dollar' => '556',                       # C+0x24 # U+0x0024
        'percent' => '889',                      # C+0x25 # U+0x0025
        'ampersand' => '722',                    # C+0x26 # U+0x0026
        'quotesingle' => '238',                  # C+0x27 # U+0x0027
        'parenleft' => '333',                    # C+0x28 # U+0x0028
        'parenright' => '333',                   # C+0x29 # U+0x0029
        'asterisk' => '389',                     # C+0x2A # U+0x002A
        'plus' => '584',                         # C+0x2B # U+0x002B
        'comma' => '278',                        # C+0x2C # U+0x002C
        'hyphen' => '333',                       # C+0x2D # U+0x002D
        'period' => '278',                       # C+0x2E # U+0x002E
        'slash' => '278',                        # C+0x2F # U+0x002F
        'zero' => '556',                         # C+0x30 # U+0x0030
        'one' => '556',                          # C+0x31 # U+0x0031
        'two' => '556',                          # C+0x32 # U+0x0032
        'three' => '556',                        # C+0x33 # U+0x0033
        'four' => '556',                         # C+0x34 # U+0x0034
        'five' => '556',                         # C+0x35 # U+0x0035
        'six' => '556',                          # C+0x36 # U+0x0036
        'seven' => '556',                        # C+0x37 # U+0x0037
        'eight' => '556',                        # C+0x38 # U+0x0038
        'nine' => '556',                         # C+0x39 # U+0x0039
        'colon' => '333',                        # C+0x3A # U+0x003A
        'semicolon' => '333',                    # C+0x3B # U+0x003B
        'less' => '584',                         # C+0x3C # U+0x003C
        'equal' => '584',                        # C+0x3D # U+0x003D
        'greater' => '584',                      # C+0x3E # U+0x003E
        'question' => '611',                     # C+0x3F # U+0x003F
        'at' => '975',                           # C+0x40 # U+0x0040
        'A' => '722',                            # C+0x41 # U+0x0041
        'B' => '722',                            # C+0x42 # U+0x0042
        'C' => '722',                            # C+0x43 # U+0x0043
        'D' => '722',                            # C+0x44 # U+0x0044
        'E' => '667',                            # C+0x45 # U+0x0045
        'F' => '611',                            # C+0x46 # U+0x0046
        'G' => '778',                            # C+0x47 # U+0x0047
        'H' => '722',                            # C+0x48 # U+0x0048
        'I' => '278',                            # C+0x49 # U+0x0049
        'J' => '556',                            # C+0x4A # U+0x004A
        'K' => '722',                            # C+0x4B # U+0x004B
        'L' => '611',                            # C+0x4C # U+0x004C
        'M' => '833',                            # C+0x4D # U+0x004D
        'N' => '722',                            # C+0x4E # U+0x004E
        'O' => '778',                            # C+0x4F # U+0x004F
        'P' => '667',                            # C+0x50 # U+0x0050
        'Q' => '778',                            # C+0x51 # U+0x0051
        'R' => '722',                            # C+0x52 # U+0x0052
        'S' => '667',                            # C+0x53 # U+0x0053
        'T' => '611',                            # C+0x54 # U+0x0054
        'U' => '722',                            # C+0x55 # U+0x0055
        'V' => '667',                            # C+0x56 # U+0x0056
        'W' => '944',                            # C+0x57 # U+0x0057
        'X' => '667',                            # C+0x58 # U+0x0058
        'Y' => '667',                            # C+0x59 # U+0x0059
        'Z' => '611',                            # C+0x5A # U+0x005A
        'bracketleft' => '333',                  # C+0x5B # U+0x005B
        'backslash' => '278',                    # C+0x5C # U+0x005C
        'bracketright' => '333',                 # C+0x5D # U+0x005D
        'asciicircum' => '584',                  # C+0x5E # U+0x005E
        'underscore' => '556',                   # C+0x5F # U+0x005F
        'grave' => '333',                        # C+0x60 # U+0x0060
        'a' => '556',                            # C+0x61 # U+0x0061
        'b' => '611',                            # C+0x62 # U+0x0062
        'c' => '556',                            # C+0x63 # U+0x0063
        'd' => '611',                            # C+0x64 # U+0x0064
        'e' => '556',                            # C+0x65 # U+0x0065
        'f' => '333',                            # C+0x66 # U+0x0066
        'g' => '611',                            # C+0x67 # U+0x0067
        'h' => '611',                            # C+0x68 # U+0x0068
        'i' => '278',                            # C+0x69 # U+0x0069
        'j' => '278',                            # C+0x6A # U+0x006A
        'k' => '556',                            # C+0x6B # U+0x006B
        'l' => '278',                            # C+0x6C # U+0x006C
        'm' => '889',                            # C+0x6D # U+0x006D
        'n' => '611',                            # C+0x6E # U+0x006E
        'o' => '611',                            # C+0x6F # U+0x006F
        'p' => '611',                            # C+0x70 # U+0x0070
        'q' => '611',                            # C+0x71 # U+0x0071
        'r' => '389',                            # C+0x72 # U+0x0072
        's' => '556',                            # C+0x73 # U+0x0073
        't' => '333',                            # C+0x74 # U+0x0074
        'u' => '611',                            # C+0x75 # U+0x0075
        'v' => '556',                            # C+0x76 # U+0x0076
        'w' => '778',                            # C+0x77 # U+0x0077
        'x' => '556',                            # C+0x78 # U+0x0078
        'y' => '556',                            # C+0x79 # U+0x0079
        'z' => '500',                            # C+0x7A # U+0x007A
        'braceleft' => '389',                    # C+0x7B # U+0x007B
        'bar' => '280',                          # C+0x7C # U+0x007C
        'braceright' => '389',                   # C+0x7D # U+0x007D
        'asciitilde' => '584',                   # C+0x7E # U+0x007E
        'bullet' => '350',                       # C+0x7F # U+0x2022
        'Euro' => '556',                         # C+0x80 # U+0x20AC
        'quotesinglbase' => '278',               # C+0x82 # U+0x201A
        'florin' => '556',                       # C+0x83 # U+0x0192
        'quotedblbase' => '500',                 # C+0x84 # U+0x201E
        'ellipsis' => '1000',                    # C+0x85 # U+0x2026
        'dagger' => '556',                       # C+0x86 # U+0x2020
        'daggerdbl' => '556',                    # C+0x87 # U+0x2021
        'circumflex' => '333',                   # C+0x88 # U+0x02C6
        'perthousand' => '1000',                 # C+0x89 # U+0x2030
        'Scaron' => '667',                       # C+0x8A # U+0x0160
        'guilsinglleft' => '333',                # C+0x8B # U+0x2039
        'OE' => '1000',                          # C+0x8C # U+0x0152
        'Zcaron' => '611',                       # C+0x8E # U+0x017D
        'quoteleft' => '278',                    # C+0x91 # U+0x2018
        'quoteright' => '278',                   # C+0x92 # U+0x2019
        'quotedblleft' => '500',                 # C+0x93 # U+0x201C
        'quotedblright' => '500',                # C+0x94 # U+0x201D
        'endash' => '556',                       # C+0x96 # U+0x2013
        'emdash' => '1000',                      # C+0x97 # U+0x2014
        'tilde' => '333',                        # C+0x98 # U+0x02DC
        'trademark' => '1000',                   # C+0x99 # U+0x2122
        'scaron' => '556',                       # C+0x9A # U+0x0161
        'guilsinglright' => '333',               # C+0x9B # U+0x203A
        'oe' => '944',                           # C+0x9C # U+0x0153
        'zcaron' => '500',                       # C+0x9E # U+0x017E
        'Ydieresis' => '667',                    # C+0x9F # U+0x0178
        'exclamdown' => '333',                   # C+0xA1 # U+0x00A1
        'cent' => '556',                         # C+0xA2 # U+0x00A2
        'sterling' => '556',                     # C+0xA3 # U+0x00A3
        'currency' => '556',                     # C+0xA4 # U+0x00A4
        'yen' => '556',                          # C+0xA5 # U+0x00A5
        'brokenbar' => '280',                    # C+0xA6 # U+0x00A6
        'section' => '556',                      # C+0xA7 # U+0x00A7
        'dieresis' => '333',                     # C+0xA8 # U+0x00A8
        'copyright' => '737',                    # C+0xA9 # U+0x00A9
        'ordfeminine' => '370',                  # C+0xAA # U+0x00AA
        'guillemotleft' => '556',                # C+0xAB # U+0x00AB
        'logicalnot' => '584',                   # C+0xAC # U+0x00AC
        'registered' => '737',                   # C+0xAE # U+0x00AE
        'macron' => '580',                       # C+0xAF # U+0x00AF
        'degree' => '400',                       # C+0xB0 # U+0x00B0
        'plusminus' => '584',                    # C+0xB1 # U+0x00B1
        'twosuperior' => '333',                  # C+0xB2 # U+0x00B2
        'threesuperior' => '333',                # C+0xB3 # U+0x00B3
        'acute' => '333',                        # C+0xB4 # U+0x00B4
        'mu' => '611',                           # C+0xB5 # U+0x00B5
        'paragraph' => '556',                    # C+0xB6 # U+0x00B6
        'periodcentered' => '278',               # C+0xB7 # U+0x00B7
        'cedilla' => '333',                      # C+0xB8 # U+0x00B8
        'onesuperior' => '333',                  # C+0xB9 # U+0x00B9
        'ordmasculine' => '365',                 # C+0xBA # U+0x00BA
        'guillemotright' => '556',               # C+0xBB # U+0x00BB
        'onequarter' => '834',                   # C+0xBC # U+0x00BC
        'onehalf' => '834',                      # C+0xBD # U+0x00BD
        'threequarters' => '834',                # C+0xBE # U+0x00BE
        'questiondown' => '611',                 # C+0xBF # U+0x00BF
        'Agrave' => '722',                       # C+0xC0 # U+0x00C0
        'Aacute' => '722',                       # C+0xC1 # U+0x00C1
        'Acircumflex' => '722',                  # C+0xC2 # U+0x00C2
        'Atilde' => '722',                       # C+0xC3 # U+0x00C3
        'Adieresis' => '722',                    # C+0xC4 # U+0x00C4
        'Aring' => '722',                        # C+0xC5 # U+0x00C5
        'AE' => '1000',                          # C+0xC6 # U+0x00C6
        'Ccedilla' => '722',                     # C+0xC7 # U+0x00C7
        'Egrave' => '667',                       # C+0xC8 # U+0x00C8
        'Eacute' => '667',                       # C+0xC9 # U+0x00C9
        'Ecircumflex' => '667',                  # C+0xCA # U+0x00CA
        'Edieresis' => '667',                    # C+0xCB # U+0x00CB
        'Igrave' => '278',                       # C+0xCC # U+0x00CC
        'Iacute' => '278',                       # C+0xCD # U+0x00CD
        'Icircumflex' => '278',                  # C+0xCE # U+0x00CE
        'Idieresis' => '278',                    # C+0xCF # U+0x00CF
        'Eth' => '722',                          # C+0xD0 # U+0x00D0
        'Ntilde' => '722',                       # C+0xD1 # U+0x00D1
        'Ograve' => '778',                       # C+0xD2 # U+0x00D2
        'Oacute' => '778',                       # C+0xD3 # U+0x00D3
        'Ocircumflex' => '778',                  # C+0xD4 # U+0x00D4
        'Otilde' => '778',                       # C+0xD5 # U+0x00D5
        'Odieresis' => '778',                    # C+0xD6 # U+0x00D6
        'multiply' => '584',                     # C+0xD7 # U+0x00D7
        'Oslash' => '778',                       # C+0xD8 # U+0x00D8
        'Ugrave' => '722',                       # C+0xD9 # U+0x00D9
        'Uacute' => '722',                       # C+0xDA # U+0x00DA
        'Ucircumflex' => '722',                  # C+0xDB # U+0x00DB
        'Udieresis' => '722',                    # C+0xDC # U+0x00DC
        'Yacute' => '667',                       # C+0xDD # U+0x00DD
        'Thorn' => '667',                        # C+0xDE # U+0x00DE
        'germandbls' => '611',                   # C+0xDF # U+0x00DF
        'agrave' => '556',                       # C+0xE0 # U+0x00E0
        'aacute' => '556',                       # C+0xE1 # U+0x00E1
        'acircumflex' => '556',                  # C+0xE2 # U+0x00E2
        'atilde' => '556',                       # C+0xE3 # U+0x00E3
        'adieresis' => '556',                    # C+0xE4 # U+0x00E4
        'aring' => '556',                        # C+0xE5 # U+0x00E5
        'ae' => '889',                           # C+0xE6 # U+0x00E6
        'ccedilla' => '556',                     # C+0xE7 # U+0x00E7
        'egrave' => '556',                       # C+0xE8 # U+0x00E8
        'eacute' => '556',                       # C+0xE9 # U+0x00E9
        'ecircumflex' => '556',                  # C+0xEA # U+0x00EA
        'edieresis' => '556',                    # C+0xEB # U+0x00EB
        'igrave' => '278',                       # C+0xEC # U+0x00EC
        'iacute' => '278',                       # C+0xED # U+0x00ED
        'icircumflex' => '278',                  # C+0xEE # U+0x00EE
        'idieresis' => '278',                    # C+0xEF # U+0x00EF
        'eth' => '611',                          # C+0xF0 # U+0x00F0
        'ntilde' => '611',                       # C+0xF1 # U+0x00F1
        'ograve' => '611',                       # C+0xF2 # U+0x00F2
        'oacute' => '611',                       # C+0xF3 # U+0x00F3
        'ocircumflex' => '611',                  # C+0xF4 # U+0x00F4
        'otilde' => '611',                       # C+0xF5 # U+0x00F5
        'odieresis' => '611',                    # C+0xF6 # U+0x00F6
        'divide' => '584',                       # C+0xF7 # U+0x00F7
        'oslash' => '611',                       # C+0xF8 # U+0x00F8
        'ugrave' => '611',                       # C+0xF9 # U+0x00F9
        'uacute' => '611',                       # C+0xFA # U+0x00FA
        'ucircumflex' => '611',                  # C+0xFB # U+0x00FB
        'udieresis' => '611',                    # C+0xFC # U+0x00FC
        'yacute' => '556',                       # C+0xFD # U+0x00FD
        'thorn' => '611',                        # C+0xFE # U+0x00FE
        'ydieresis' => '556',                    # C+0xFF # U+0x00FF
        'dotlessi' => '278',                     # U+0x0131
        'Lslash' => '611',                       # U+0x0141
        'lslash' => '278',                       # U+0x0142
        'caron' => '333',                        # U+0x02C7
        'breve' => '333',                        # U+0x02D8
        'dotaccent' => '333',                    # U+0x02D9
        'ring' => '333',                         # U+0x02DA
        'ogonek' => '333',                       # U+0x02DB
        'hungarumlaut' => '333',                 # U+0x02DD
        'dblgravecmb' => '333',                  # U+0x030F
        'fraction' => '167',                     # U+0x2044
        'minus' => '584',                        # U+0x2212
        'fi' => '611',                           # U+0xFB01
        'fl' => '611',                           # U+0xFB02
    }, # HORIZ. WIDTH TABLE
} };

1;
